<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Clínica - Sistema de Avaliação IFCora</title>
    <!-- Fonte personalizada e Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <!-- Font Awesome para ícones -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Estilos CSS -->
    <link rel="stylesheet" href="includes/styles-perfil-clinica.css">
    <link rel="stylesheet" href="css/styles.css">
    
    <link rel="stylesheet" href="css/styles-perfil-clinica.css">
    <!-- <style>
        
    
        /* Caso precise de estilos adicionais para faturamento e modal de planos */
        .plan-card {
            background-color: #ffffff;
            b7order: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            text-align: center;
            margin-bottom: 20px;
        }
        .plan-card h3 {
            font-size: 18px;
            color: #2d3748;
            margin-bottom: 10px;
        }
        .plan-card p {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 10px;
        }
        .plan-card button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }
        .plan-card button:hover {
            background-color: #06b287;
        }

        .plans-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        /* Modal de Planos */
        #choosePlanModal .modal-content {
            max-width: 600px;
        }

        .current-plan-info {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .current-plan-info p {
            margin-bottom: 5px;
        }
        .highlight {
            font-weight: 600;
            color: #08C89E;
        }
        
        /* Abas Internas */
.tabs-container {
    margin-bottom: 20px;
}

.tabs {
    display: flex;
    border-bottom: 1px solid #e2e8f0;
    margin-bottom: 20px;
}

.tab {
    padding: 10px 20px;
    cursor: pointer;
    font-size: 16px;
    color: #2d3748;
    background-color: #f7fafc;
    border-top-left-radius: 6px;
    border-top-right-radius: 6px;
    margin-right: 5px;
    display: flex;
    align-items: center;
    border-bottom: 1px solid #e2e8f0;
}

.tab.active {
    background-color: #08C89E;
    color: #fff;
    font-weight: 600;
    border-bottom: 2px solid #08C89E;
}

.tab i {
    margin-right: 10px;
    font-size: 18px;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

/* Tabelas Internas */
.table-section {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
}

.table-section th, .table-section td {
    text-align: left;
    padding: 10px;
    border-bottom: 1px solid #e2e8f0;
    font-size: 16px;
}

.table-section th {
    background-color: #f7fafc;
    color: #2d3748;
}

/* Botões */
.btn {
    padding: 8px 16px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
    transition: background 0.3s;
}

.btn.create-invite {
    background-color: #08C89E;
    color: #fff;
}

.btn.create-invite:hover {
    background-color: #06b287;
}

.btn.copy {
    background-color: #F6AD55;
    color: #fff;
}

.btn.copy:hover {
    background-color: #dd6b20;
}

.btn.accept {
    background-color: #08C89E;
    color: #fff;
}

.btn.accept:hover {
    background-color: #06b287;
}

.btn.decline {
    background-color: #e53e3e;
    color: #fff;
}

.btn.decline:hover {
    background-color: #c53030;
}

.btn.pay-now {
    background-color: #08C89E;
    color: #fff;
    padding: 5px 10px;
    border-radius: 6px;
    cursor: pointer;
    font-size: 13px;
}

.btn.pay-now:hover {
    background-color: #06b287;
}

.btn.contact-sales {
    background-color: #F6AD55;
    color: #fff;
    border: none;
    padding: 10px 15px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
}

.btn.contact-sales:hover {
    background-color: #dd6b20;
}

/* Paginação */
.pagination {
    display: flex;
    gap: 5px;
    margin-top: 10px;
}

.pagination button {
    padding: 5px 10px;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    background-color: #f7fafc;
    cursor: pointer;
    transition: background 0.3s;
}

.pagination button.active {
    background-color: #08C89E;
    color: #fff;
    border-color: #08C89E;
}

.pagination button:hover {
    background-color: #e2e8f0;
}

/* Estilos Gerais do Modal */
.modal {
    display: none; /* Oculto por padrão */
    position: fixed; 
    z-index: 1000; 
    left: 0;
    top: 0;
    width: 100%; 
    height: 100%; 
    overflow: auto; 
    background-color: rgba(0, 0, 0, 0.5); /* Fundo semi-transparente */
    font-family: 'Poppins', sans-serif; /* Fonte consistente com a página */
}

.modal-content {
    background-color: #ffffff;
    margin: 5% auto; /* Centraliza verticalmente */
    padding: 30px; /* Espaçamento interno */
    border: 1px solid #e2e8f0; /* Borda sutil */
    width: 90%; 
    max-width: 500px; 
    border-radius: 10px; /* Bordas arredondadas */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Sombra suave */
    position: relative;
}

.close-button {
    color: #2d3748; /* Cor consistente com o texto principal */
    float: right;
    font-size: 24px;
    font-weight: bold;
    position: absolute;
    right: 20px;
    top: 15px;
    cursor: pointer;
}

.close-button:hover,
.close-button:focus {
    color: #08C89E; /* Destaque ao passar o mouse */
    text-decoration: none;
}

.modal-content h2 {
    color: #08C89E; /* Cor de destaque para o título */
    margin-bottom: 20px;
    font-size: 24px;
}

.child-form label {
    display: block;
    margin-top: 15px;
    font-weight: 500;
    color: #2d3748; /* Cor consistente com o texto principal */
}

.child-form input[type="text"],
.child-form input[type="date"],
.child-form input[type="tel"] {
    width: 100%;
    padding: 10px 12px;
    margin-top: 5px;
    border: 1px solid #cbd5e0; /* Borda consistente */
    border-radius: 6px;
    font-size: 14px;
    box-sizing: border-box;
}

.child-form input[type="text"]::placeholder,
.child-form input[type="date"]::placeholder,
.child-form input[type="tel"]::placeholder {
    color: #a0aec0; /* Cor do placeholder */
}

.form-actions {
    display: flex;
    justify-content: flex-end;
    margin-top: 25px;
}

.form-actions .btn {
    margin-left: 10px;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 14px;
    font-family: 'Poppins', sans-serif;
    transition: background-color 0.3s;
}

/* Botão Cancelar */
.btn.cancel {
    background-color: #e53e3e; /* Vermelho */
    color: #ffffff;
}

.btn.cancel:hover {
    background-color: #c53030; /* Vermelho escuro */
}

/* Botão Salvar */
.btn.save {
    background-color: #08C89E; /* Verde */
    color: #ffffff;
}

.btn.save:hover {
    background-color: #06b287; /* Verde escuro */
}

/* Responsividade */
@media (max-width: 600px) {
    .modal-content {
        padding: 20px;
    }

    .child-form input[type="text"],
    .child-form input[type="date"],
    .child-form input[type="tel"] {
        padding: 8px 10px;
    }

    .modal-content h2 {
        font-size: 20px;
    }

    .form-actions .btn {
        padding: 8px 16px;
        font-size: 13px;
    }
}
.modal {
            display: none; /* Oculto por padrão */
            position: fixed; 
            z-index: 1000; 
            left: 0;
            top: 0;
            width: 100%; 
            height: 100%; 
            overflow: auto; 
            background-color: rgba(0, 0, 0, 0.5); /* Fundo semi-transparente */
            font-family: 'Poppins', sans-serif; /* Fonte consistente com a página */
        }

        .modal-content {
            background-color: #ffffff;
            margin: 5% auto; /* Centraliza verticalmente */
            padding: 30px; /* Espaçamento interno */
            border: 1px solid #e2e8f0; /* Borda sutil */
            width: 90%; 
            max-width: 500px; 
            border-radius: 10px; /* Bordas arredondadas */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Sombra suave */
            position: relative;
        }

        .close-button {
            color: #2d3748; /* Cor consistente com o texto principal */
            float: right;
            font-size: 24px;
            font-weight: bold;
            position: absolute;
            right: 20px;
            top: 15px;
            cursor: pointer;
        }

        .close-button:hover,
        .close-button:focus {
            color: #08C89E; /* Destaque ao passar o mouse */
            text-decoration: none;
        }

        .modal-content h2 {
            color: #08C89E; /* Cor de destaque para o título */
            margin-bottom: 20px;
            font-size: 24px;
        }

        .child-form label {
            display: block;
            margin-top: 15px;
            font-weight: 500;
            color: #2d3748; /* Cor consistente com o texto principal */
        }

        .child-form input[type="text"],
        .child-form input[type="date"],
        .child-form input[type="tel"],
        .child-form select {
            width: 100%;
            padding: 10px 12px;
            margin-top: 5px;
            border: 1px solid #cbd5e0; /* Borda consistente */
            border-radius: 6px;
            font-size: 14px;
            box-sizing: border-box;
        }

        .child-form input[type="text"]::placeholder,
        .child-form input[type="date"]::placeholder,
        .child-form input[type="tel"]::placeholder,
        .child-form select::placeholder {
            color: #a0aec0; /* Cor do placeholder */
        }

        .form-actions {
            display: flex;
            justify-content: flex-end;
            margin-top: 25px;
        }

        .form-actions .btn {
            margin-left: 10px;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
            transition: background-color 0.3s;
        }

        /* Botão Cancelar */
        .btn.cancel {
            background-color: #e53e3e; /* Vermelho */
            color: #ffffff;
        }

        .btn.cancel:hover {
            background-color: #c53030; /* Vermelho escuro */
        }

        /* Botão Salvar */
        .btn.save {
            background-color: #08C89E; /* Verde */
            color: #ffffff;
        }

        .btn.save:hover {
            background-color: #06b287; /* Verde escuro */
        }

        /* Responsividade */
        @media (max-width: 600px) {
            .modal-content {
                padding: 20px;
            }

            .child-form input[type="text"],
            .child-form input[type="date"],
            .child-form input[type="tel"],
            .child-form select {
                padding: 8px 10px;
            }

            .modal-content h2 {
                font-size: 20px;
            }

            .form-actions .btn {
                padding: 8px 16px;
                font-size: 13px;
            }
        }

        /* Estilos para a Tabela de Crianças */
        #childrenTable th,
        #childrenTable td {
            padding: 12px 15px;
            border-bottom: 1px solid #e2e8f0;
            text-align: left;
        }

        #childrenTable th {
            background-color: #f7fafc;
            font-weight: 600;
            color: #2d3748;
        }

        #childrenTable tr:nth-child(even) {
            background-color: #f9fafb;
        }

        #childrenTable tr:hover {
            background-color: #f1f5f9;
        }

        /* Estilos para Paginação */
        .pagination {
            margin-top: 15px;
            display: flex;
            justify-content: center;
            gap: 5px;
        }

        .pagination button {
            background-color: #ffffff;
            border: 1px solid #cbd5e0;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .pagination button.active,
        .pagination button:hover {
            background-color: #08C89E;
            color: #ffffff;
            border-color: #08C89E;
        }

        /* Estilos para Botão "Adicionar Criança" */
        .btn.add {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 8px 16px;
            border-radius: 8px;
            cursor: pointer;
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            display: flex;
            align-items: center;
        }

        .btn.add i {
            margin-right: 5px;
        }

        .btn.add:hover {
            background-color: #06b287;
        }
/* Estilos para Botões de Ação na Tabela */
/* Ajuste para centralizar os ícones nos botões de ação */
.edit-button,
.remove-button {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 30px; /* Defina um tamanho fixo se necessário */
    height: 30px;
}

/* Opcional: Ajustar o tamanho dos ícones */
.edit-button i,
.remove-button i {
    font-size: 16px;
}

/* Remover espaços ou bordas desnecessárias */
.edit-button,
.remove-button {
    padding: 5px;
    text-decoration: none;
}

/* Modal de Edição da Criança */
/* Modal de Edição da Criança */
#editChildModal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5);
    font-family: 'Poppins', sans-serif;
}

#editChildModal .modal-content {
    background-color: #ffffff;
    margin: 5% auto;
    padding: 30px;
    border: 1px solid #e2e8f0;
    width: 90%;
    max-width: 600px;
    border-radius: 10px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    position: relative;
}

#editChildModal .close-button {
    color: #2d3748;
    float: right;
    font-size: 24px;
    font-weight: bold;
    position: absolute;
    right: 20px;
    top: 15px;
    cursor: pointer;
}

#editChildModal .child-form label {
    display: block;
    margin-top: 15px;
    font-weight: 500;
    color: #2d3748;
}

#editChildModal .child-form input[type="text"],
#editChildModal .child-form input[type="date"],
#editChildModal .child-form select,
#editChildModal .child-form p {
    width: 100%;
    padding: 10px 12px;
    margin-top: 5px;
    border: 1px solid #cbd5e0;
    border-radius: 6px;
    font-size: 14px;
    box-sizing: border-box;
}

/* Estilo do Texto Somente Leitura */
#editChildModal .child-form p {
    background-color: #f7fafc;
    border: 1px solid #e2e8f0;
    padding: 10px;
    border-radius: 6px;
    color: #2d3748;
    font-weight: 500;
}

/* Ações */
#editChildModal .form-actions {
    display: flex;
    justify-content: flex-end;
    margin-top: 25px;
}

#editChildModal .form-actions .btn {
    margin-left: 10px;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 14px;
}

#editChildModal .form-actions .btn.cancel {
    background-color: #e53e3e;
    color: #ffffff;
}

#editChildModal .form-actions .btn.cancel:hover {
    background-color: #c53030;
}

#editChildModal .form-actions .btn.save {
    background-color: #08C89E;
    color: #ffffff;
}

#editChildModal .form-actions .btn.save:hover {
    background-color: #06b287;
}

/* Layout Responsivo */
@media (min-width: 768px) {
    #editChildModal .form-group {
        display: flex;
        gap: 15px;
        margin-top: 10px;
    }

    #editChildModal .form-group > div {
        flex: 1;
    }
}


/* Modal para Adicionar Criança */
#addChildModal {
    display: none; /* Oculto por padrão */
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5);
    font-family: 'Poppins', sans-serif;
}

#addChildModal .modal-content {
    background-color: #ffffff;
    margin: 5% auto;
    padding: 30px;
    border: 1px solid #e2e8f0;
    width: 90%;
    max-width: 600px; /* Largura máxima para desktops */
    border-radius: 10px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    position: relative;
}

#addChildModal .close-button {
    color: #2d3748;
    float: right;
    font-size: 24px;
    font-weight: bold;
    position: absolute;
    right: 20px;
    top: 15px;
    cursor: pointer;
}

#addChildModal .child-form label {
    display: block;
    margin-top: 15px;
    font-weight: 500;
    color: #2d3748;
}

#addChildModal .child-form input[type="text"],
#addChildModal .child-form input[type="date"],
#addChildModal .child-form select,
#addChildModal .child-form p {
    width: 100%;
    padding: 10px 12px;
    margin-top: 5px;
    border: 1px solid #cbd5e0;
    border-radius: 6px;
    font-size: 14px;
    box-sizing: border-box;
}

/* Campo Texto Somente Leitura */
#addChildModal .child-form p {
    background-color: #f7fafc;
    border: 1px solid #e2e8f0;
    padding: 10px;
    border-radius: 6px;
    color: #2d3748;
    font-weight: 500;
}

/* Botões */
#addChildModal .form-actions {
    display: flex;
    justify-content: flex-end;
    margin-top: 25px;
}

#addChildModal .form-actions .btn {
    margin-left: 10px;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 14px;
    transition: background-color 0.3s;
}

#addChildModal .form-actions .btn.cancel {
    background-color: #e53e3e;
    color: #ffffff;
}

#addChildModal .form-actions .btn.cancel:hover {
    background-color: #c53030;
}

#addChildModal .form-actions .btn.save {
    background-color: #08C89E;
    color: #ffffff;
}

#addChildModal .form-actions .btn.save:hover {
    background-color: #06b287;
}

/* Layout Responsivo */
@media (min-width: 768px) {
    #addChildModal .form-group {
        display: flex;
        gap: 15px;
        margin-top: 10px;
    }

    #addChildModal .form-group > div {
        flex: 1;
    }
}

    </style> -->
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos">
            <h2>Sistema de Avaliação - IFCora</h2>
        </div>
        <nav class="user-menu">
            <a href="#" title="Notificações"><i class="fas fa-bell"></i></a>
            <a href="#" title="Configurações"><i class="fas fa-cog"></i></a>
            <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>
        </nav>
    </header>
    <!-- Sidebar -->
    <?php include 'includes/sidebar-painel-profissional-clinicas.php'; ?>
    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1>Gerenciar Clínica</h1>
        </div>
        <!-- Seção de Informações da Clínica -->
        <section class="clinic-info-section">
            <div class="clinic-photo">
                <img src="https://via.placeholder.com/100" alt="Logo da Clínica">
                <!-- Botão para alterar logo -->
                <button class="edit-logo" title="Alterar Logo"><i class="fas fa-camera"></i></button>
            </div>
            <div class="clinic-details">
                <div>
                    <p><b>Nome:</b> Clínica Sertãozinho</p>
                    <p><b>Endereço:</b> Rua das Flores, 123 - Centro</p>
                </div>
                <div>
                    <p><b>Email:</b> contato@clinicasertaozinho.com</p>
                    <p><b>Telefone:</b> (99) 99999-9999</p>
                    
                </div>
                
                <div class="clinic-actions">
                <button id="editClinicBtn"><i class="fas fa-edit"></i>Editar Informações</button>
                <button id="editClinicBtn"><i class="fas fa-trash-alt"></i></i>Remover</button>
            </div>
            </div>
            <!-- Ações da Clínica -->
            
        </section>
        <!-- Seção de Abas -->
        <section class="tabs-section">
            <div class="tab-container">
                <!-- Linha das abas: Adicionando a classe 'active' à aba Profissionais -->
                <div class="tabs">
                    <div class="tab active" data-tab="profissionais"><i class="fas fa-user-md"></i> Profissionais</div>
                    <div class="tab" data-tab="criancas"><i class="fas fa-child"></i> Crianças</div>
                    <div class="tab" data-tab="faturamento"><i class="fas fa-file-invoice-dollar"></i> Planos de Assinatura</div>
                    <div class="tab" data-tab="tokens"><i class="fas fa-coins"></i> Comprar Tokens</div>
                </div>
                <!-- Conteúdo das Abas -->
                <!-- Profissionais -->
                <div id="profissionais" class="tab-content active">
                    <h2 style="color: #08C89E">Profissionais</h2>
                <p style="margin-top: -10px; margin-bottom: 10px"><small>Lista de profissionais atribuídos a esta clínica.</small></p>
         
                    <div class="search-container" style="display: flex; align-items: center;">
                        <input type="text" id="searchChildren" placeholder="Pesquisar Profissional..." style="padding: 6px 10px; width: 200px; border: 1px solid #ccc; border-radius: 8px; font-family: 'Poppins', sans-serif; font-size: 14px;">
                        <button id="searchButton" title="Pesquisar" style="background-color: #08C89E; color: #fff; border: none; padding: 8px 12px; border-radius: 8px; cursor: pointer; font-size: 14px; display: flex; align-items: center; margin-left: 5px;">
                            <i class="fas fa-search" style="margin-right: 5px;"></i>Localizar
                        </button>
                        <button id="clearSearch" title="Limpar Pesquisa" style="background-color: #e53e3e; color: #fff; border: none; padding: 8px 12px; border-radius: 8px; cursor: pointer; font-size: 14px; display: flex; align-items: center; margin-left: 5px;">
                            <i class="fas fa-broom" style="margin-right: 5px;"></i>Limpar
                        </button>
                    </div>
                    <table id="professionalsTable" class="table-section">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Profissão</th>
                                <th>Email</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Mariana Santos</td>
                                <td>Fonoaudióloga</td>
                                <td>mariana.santos@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Pedro Oliveira</td>
                                <td>Psicólogo</td>
                                <td>pedro.oliveira@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Ana Luiza</td>
                                <td>Nutricionista</td>
                                <td>ana.luiza@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <!-- Adicionando mais 9 profissionais para totalizar 12 -->
                            <tr>
                                <td>Lucas Almeida</td>
                                <td>Fisioterapeuta</td>
                                <td>lucas.almeida@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Beatriz Souza</td>
                                <td>Terapeuta Ocupacional</td>
                                <td>beatriz.souza@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Felipe Costa</td>
                                <td>Psicopedagogo</td>
                                <td>felipe.costa@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Juliana Lima</td>
                                <td>Enfermeira</td>
                                <td>juliana.lima@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Ricardo Pinto</td>
                                <td>Nutricionista</td>
                                <td>ricardo.pinto@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Camila Rocha</td>
                                <td>Fonoaudióloga</td>
                                <td>camila.rocha@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Thiago Martins</td>
                                <td>Psicólogo</td>
                                <td>thiago.martins@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Patrícia Fernandes</td>
                                <td>Fisioterapeuta</td>
                                <td>patricia.fernandes@example.com</td>
                                <td><a href="#" class="view-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                            <tr>
                                <td>Gustavo Ribeiro</td>
                                <td>Terapeuta Ocupacional</td>
                                <td>gustavo.ribeiro@example.com</td>
                                <td><a href="#" class="remove-button"><i class="fas fa-trash-alt"></i> Remover</a></td>
                            </tr>
                        </tbody>
                    </table>
                    <!-- Paginação para Profissionais -->
                    <div class="pagination" id="pagination-professionals">
                        <!-- Botões de paginação serão gerados via JavaScript -->
                    </div>
                </div>
                <!-- Crianças -->
                <div id="criancas" class="tab-content">
                    <h2 style="color: #08C89E">Gerenciamento de Crianças</h2>
                <p style="margin-top: -10px; margin-bottom: 10px"><small>Cadastre e administre as crianças associadas à sua clínica.</small></p>
                
                    <div class="search-add-container" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; flex-wrap: wrap;">
                        <div class="search-container" style="display: flex; align-items: center;">
                            <input type="text" id="searchChildren" placeholder="Pesquisar Criança..." style="padding: 6px 10px; width: 200px; border: 1px solid #ccc; border-radius: 8px; font-family: 'Poppins', sans-serif; font-size: 14px;">
                            <button id="searchButton" title="Pesquisar" style="background-color: #08C89E; color: #fff; border: none; padding: 8px 12px; border-radius: 8px; cursor: pointer; font-size: 14px; display: flex; align-items: center; margin-left: 5px;">
                                <i class="fas fa-search" style="margin-right: 5px;"></i>Localizar
                            </button>
                            <button id="clearSearch" title="Limpar Pesquisa" style="background-color: #e53e3e; color: #fff; border: none; padding: 8px 12px; border-radius: 8px; cursor: pointer; font-size: 14px; display: flex; align-items: center; margin-left: 5px;">
                                <i class="fas fa-broom" style="margin-right: 5px;"></i>Limpar
                            </button>
                        </div>
                        <button class="btn add" id="addChildBtn" style="background-color: #08C89E; color: #fff; border: none; padding: 8px 16px; border-radius: 8px; cursor: pointer; font-family: 'Poppins', sans-serif; font-size: 14px; display: flex; align-items: center;">
                            <i class="fas fa-plus" style="margin-right: 5px;"></i> Adicionar Criança
                        </button>
                    </div>
                    
                    
                    <!-- Modal para Adicionar Criança -->
<!-- Modal para Adicionar Criança -->
<!-- Modal para Adicionar Criança -->
<div id="addChildModal" class="modal">
    <div class="modal-content">
        <span class="close-button">&times;</span>
        <h2>Adicionar Criança</h2>
        <form id="addChildForm" class="child-form">
            <!-- Grupo Nome e Data de Nascimento -->
            <div class="form-group">
                <div style="flex: 2;">
                    <label for="addChildName">Nome Completo</label>
                    <input type="text" id="addChildName" name="addChildName" required>
                </div>
                <div style="flex: 1;">
                    <label for="addBirthDate">Data de Nascimento</label>
                    <input type="date" id="addBirthDate" name="addBirthDate" required>
                </div>
            </div>

            <!-- Grupo Responsável e Vínculo -->
            <div class="form-group">
                <div style="flex: 2;">
                    <label for="addGuardianName">Nome do Responsável</label>
                    <input type="text" id="addGuardianName" name="addGuardianName" required>
                </div>
                <div style="flex: 1;">
                    <label for="addGuardianRelation">Vínculo</label>
                    <select id="addGuardianRelation" name="addGuardianRelation" required>
                        <option value="Pai">Pai</option>
                        <option value="Mãe">Mãe</option>
                        <option value="Outro">Outro</option>
                    </select>
                </div>
            </div>

            <!-- Campo para especificar vínculo se "Outro" for selecionado -->
            <div id="addRelationOtherField" style="display: none; margin-top: 10px;">
                <label for="addGuardianOther">Especifique o vínculo</label>
                <input type="text" id="addGuardianOther" name="addGuardianOther" placeholder="Informe o vínculo">
            </div>

            <!-- Grupo Profissional e Especialidade -->
            <div class="form-group">
                <div style="flex: 1;">
                    <label for="addAssignedProfessional">Profissional Atribuído</label>
                    <select id="addAssignedProfessional" name="addAssignedProfessional">
                        <!-- Opções serão carregadas dinamicamente -->
                    </select>
                </div>
                <div style="flex: 1;">
                    <label for="addSpecialty">Especialidade do Profissional</label>
                    <p id="addSpecialty" style="background-color: #f7fafc; padding: 10px; border: 1px solid #e2e8f0; border-radius: 6px;">Selecione um profissional</p>
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn cancel" id="cancelAddChild">Cancelar</button>
                <button type="submit" class="btn save">Adicionar Criança</button>
            </div>
        </form>
    </div>
</div>



<div id="editChildModal" class="modal">
    <div class="modal-content">
        <span class="close-button">&times;</span>
        <!-- Título e Código da Criança -->
        <h2>
            Editar Criança <span id="editChildId" style="font-size: 16px; color: #4a5568; font-weight: 400; margin-left: 10px;">#</span>
        </h2>
        <form id="editChildForm" class="child-form">
            <!-- Grupo Nome e Data de Nascimento -->
            <div class="form-group">
                <div style="flex: 2;">
                    <label for="editChildName">Nome Completo</label>
                    <input type="text" id="editChildName" name="editChildName" required>
                </div>
                <div style="flex: 1;">
                    <label for="editBirthDate">Data de Nascimento</label>
                    <input type="date" id="editBirthDate" name="editBirthDate" required>
                </div>
            </div>

            <!-- Grupo Responsável e Vínculo -->
            <div class="form-group">
                <div style="flex: 2;">
                    <label for="editGuardianName">Nome do Responsável</label>
                    <input type="text" id="editGuardianName" name="editGuardianName" required>
                </div>
                <div style="flex: 1;">
                    <label for="editGuardianRelation">Vínculo</label>
                    <select id="editGuardianRelation" name="editGuardianRelation" required>
                        <option value="Pai">Pai</option>
                        <option value="Mãe">Mãe</option>
                        <option value="Outro">Outro</option>
                    </select>
                </div>
            </div>

            <!-- Campo para especificar vínculo se "Outro" for selecionado -->
            <div id="relationOtherField" style="display: none; margin-top: 10px;">
                <label for="editGuardianOther">Especifique o vínculo</label>
                <input type="text" id="editGuardianOther" name="editGuardianOther" placeholder="Informe o vínculo">
            </div>

            <!-- Grupo Profissional e Especialidade -->
            <div class="form-group">
                <div style="flex: 1;">
                    <label for="editAssignedProfessional">Profissional Atribuído</label>
                    <select id="editAssignedProfessional" name="editAssignedProfessional" required>
                        <!-- Opções serão carregadas dinamicamente -->
                    </select>
                </div>
                <div style="flex: 1;">
                    <label for="editSpecialty">Especialidade do Profissional</label>
                    <p id="editSpecialty" style="background-color: #f7fafc; padding: 10px; border: 1px solid #e2e8f0; border-radius: 6px;">Selecione um profissional</p>
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn cancel" id="cancelEditChild">Cancelar</button>
                <button type="submit" class="btn save">Salvar Alterações</button>
            </div>
        </form>
    </div>
</div>




                    
                    
                    
                    <table id="childrenTable" class="table-section">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nome</th>
            <th>Idade</th>
            <th>Responsável</th>
            <th>Profissional Atribuído</th>
            <th>Especialidade do Profissional</th>
            <th>Ações</th>
        </tr>
    </thead>
    <tbody>
        <!-- Registro existente ajustado para nova coluna -->
        <tr>
            <td>#ABC12345</td>
            <td>Luís Gustavo</td>
            <td>7 anos</td>
            <td>Ana Paula</td>
            <td>Mariana Santos</td>
            <td>Fonoaudióloga</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <!-- 7 novos registros de exemplo -->
        <tr>
            <td>#ABC12346</td>
            <td>Maria Fernanda</td>
            <td>5 anos</td>
            <td>Carlos Eduardo</td>
            <td>Pedro Oliveira</td>
            <td>Psicólogo</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <tr>
            <td>#ABC12347</td>
            <td>João Pedro</td>
            <td>6 anos</td>
            <td>Fernanda Silva</td>
            <td>Ana Luiza</td>
            <td>Nutricionista</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <tr>
            <td>#ABC12348</td>
            <td>Beatriz Lima</td>
            <td>4 anos</td>
            <td>Ricardo Lima</td>
            <td>Lucas Almeida</td>
            <td>Fisioterapeuta</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <tr>
            <td>#ABC12349</td>
            <td>Rafael Santos</td>
            <td>8 anos</td>
            <td>Patrícia Santos</td>
            <td>Beatriz Souza</td>
            <td>Terapeuta Ocupacional</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <tr>
            <td>#ABC12350</td>
            <td>Isabela Costa</td>
            <td>5 anos</td>
            <td>Gustavo Costa</td>
            <td>Felipe Costa</td>
            <td>Psicopedagogo</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <tr>
            <td>#ABC12351</td>
            <td>Felipe Oliveira</td>
            <td>7 anos</td>
            <td>Juliana Oliveira</td>
            <td>Juliana Lima</td>
            <td>Enfermeira</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
        <tr>
            <td>#ABC12352</td>
            <td>Larissa Gomes</td>
            <td>6 anos</td>
            <td>Thiago Gomes</td>
            <td>Ricardo Pinto</td>
            <td>Nutricionista</td>
            <td>
                <a href="#" class="edit-button" title="Editar"><i class="fas fa-edit"></i></a>
                <a href="#" class="remove-button" title="Remover" style="margin-left:5px;"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
    </tbody>
</table>


                    <!-- Paginação para Crianças -->
                    <div class="pagination" id="pagination-children">
                        <!-- Botões de paginação serão gerados via JavaScript -->
                    </div>
                </div>
                <!-- Seção Faturamento (aba Faturamento) -->
                <div id="faturamento" class="tab-content">
                    <h2 style="color: #08C89E">Planos de Assinatura</h2>
                    <p style="margin-top: -10px"><small>Contrate e gerencie o plano de assinatura da sua clínica.</small></p>
                    
                    <!-- Resumo do Plano Atual -->
                    <div class="billing-summary" style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 10px; padding: 20px; margin-bottom: 20px;">
                        <h3 style="font-size: 20px; color: #08C89E; margin-bottom: 15px;">Plano Atual: Profissional (Fixo)</h3>
                        <p><b>Valor Base Mensal:</b> R$ 200,00</p>
                        <p><b>Crianças Incluídas no Plano:</b> 50</p>
                        <p><b>Crianças Cadastradas Atualmente:</b> 162</p>
                        <!-- Cálculo de excedentes -->
                        <p><b>Crianças Excedentes:</b> 112 (162 - 50)</p>
                        <p><b>Custo por Criança Excedente:</b> R$ 5,00</p>
                        <hr style="margin: 15px 0;">
                        <p><b>Total Excedente:</b> 112 x R$ 5,00 = R$ 560,00</p>
                        <p><b>Total Mensal (Base + Excedente):</b> R$ 200,00 + R$ 560,00 = <span style="font-weight: 600; color: #2d3748;">R$ 760,00</span></p>
                        
                        <!-- Excedente acima de 100 -->
                        <div style="margin-top: 20px;">
                            <p style="color: #e53e3e; font-weight: 600;">
                                    Você excedeu o limite de 100 crianças. Entre em contato com nossa equipe de vendas para um plano personalizado.
                            </p>
                            <button class="btn contact-sales" style="background-color: #F6AD55; color: #fff; border: none; padding: 10px 15px; border-radius: 8px; cursor: pointer; font-size: 14px;">
                                <i class="fas fa-phone"></i> Falar com Vendas
                            </button>
                        </div>
                    </div>

                    <!-- Fatura Atual - Resumo -->
                <!-- Supondo que a fatura atual #011 seja referente a Dezembro/2023,
                     gerada em 21/11/2023, vence em 01/12/2023 e ainda está em aberto.
                     Supondo que hoje seja 25/11/2023, restam 6 dias até o vencimento. -->
                <div class="active-invoice" style="background-color: #ffffff; border: 1px solid #e2e8f0; border-radius: 10px; padding: 20px; margin-bottom: 20px;">
                    <h3 style="font-size: 18px; color: #08C89E; margin-bottom: 20px;">Fatura Atual</h3>
                    
                    <div style="display: flex; justify-content: space-between; flex-wrap: wrap;">
                        <!-- Coluna 1 -->
                        <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                            <p><strong>ID da Fatura:</strong></p>
                            <p>#011</p>
                        </div>
                        
                        <!-- Coluna 2 -->
                        <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                            <p><strong>Data de Geração:</strong></p>
                            <p>21/11/2023</p>
                        </div>
                        
                        <!-- Coluna 3 -->
                        <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                            <p><strong>Data de Vencimento:</strong></p>
                            <p>01/12/2023</p>
                        </div>
                        
                        <!-- Coluna 4 -->
                        <div style="flex: 1; min-width: 150px;">
                            <p><strong>Dias Restantes para Vencimento:</strong></p>
                            <p>6 dias</p> <!-- Ajuste conforme a data atual real -->
                        </div>
                    </div>
                </div>


    <!-- Histórico de Pagamentos -->
    <h3 style="font-size: 18px; margin-bottom: 10px; color: #08C89E;">Histórico de Pagamentos</h3>
    <table id="billingHistoryTable" class="table-section" style="width: 100%; border-collapse: collapse; font-size: 14px;">
        <thead>
            <tr style="background-color: #f7fafc; color: #2d3748;">
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">ID da Fatura</th>
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Período</th>
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Crianças Incluídas</th>
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Crianças Excedentes</th>
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Total</th>
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Status</th>
                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Ações</th>
            </tr>
        </thead>
        <tbody>
            <!-- Fatura atual (Em Aberto) gera um botão "Pagar Agora" -->
            <tr>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#011</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Dezembro/2023</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">50</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">112</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 760,00</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #d69e2e; font-weight: 600;">Em Aberto</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                    <button class="btn pay-now" style="background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;">
                        <i class="fas fa-credit-card"></i> Pagar Agora
                    </button>
                </td>
            </tr>

            <!-- Faturas anteriores pagas (data de pagamento poderia ser exibida se desejado) -->
            <tr>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#010</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Novembro/2023</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">50</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">112</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 760,00</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                        <i class="fas fa-eye"></i> Ver Recibo
                    </a>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#009</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Outubro/2023</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">50</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">30</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 350,00</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                        <i class="fas fa-eye"></i> Ver Recibo
                    </a>
                </td>
            </tr>
        </tbody>
    </table>
</div>

                <!-- Conteúdo da aba Tokens -->
<!-- Tokens (Nova aba) -->
                <div id="tokens" class="tab-content">
                    <h2 style="color: #08C89E">Comprar Tokens</h2>
                    <p style="margin-top: -10px"><small>Adquira tokens para gerar relatórios com Inteligência Artificial.</small></p>
                    
                    <!-- Resumo de Tokens -->
                    <div class="tokens-summary" style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 10px; padding: 20px; margin-bottom: 20px;">
                        <h3 style="font-size: 18px; color: #08C89E; margin-bottom: 15px;">Seu Saldo de Tokens</h3>
                        <p><b>Tokens Disponíveis:</b> 120</p>
                        <p><small>O consumo de tokens varia conforme a complexidade do relatório gerado.</small></p>
                        
                        <div style="margin-top: 20px; display: flex; gap: 10px;">
                            <button id="buyTokensBtn" class="btn" style="background-color: #08C89E; color: #fff; border: none; padding: 10px 15px; border-radius: 8px; cursor: pointer; font-size: 14px;">
                                <i class="fas fa-cart-plus"></i> Comprar Tokens
                            </button>
                        </div>
                    </div>

                    <!-- Histórico de Compras de Tokens -->
                    <h3 style="font-size: 18px; margin-bottom: 10px; color: #08C89E;">Histórico de Compras de Tokens</h3>
                    <table id="tokenPurchaseHistory" class="table-section" style="width: 100%; border-collapse: collapse; font-size: 14px;">
                        <thead>
                            <tr style="background-color: #f7fafc; color: #2d3748;">
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">ID da Compra</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Data</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Quantidade</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Valor</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Status</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#1004</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">05/12/2024</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">100 Tokens</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 50.00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #d69e2e; font-weight: 600;">Em Aberto</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <button class="btn pay-now" style="background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;">
                                        <i class="fas fa-credit-card"></i> Pagar Agora
                                    </button>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#1003</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">25/11/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">100 Tokens</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 50,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Ver Recibo
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#1002</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">10/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">50 Tokens</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 30,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Ver Recibo
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div id="configuracoes" class="tab-content">
                    <!-- Conteúdo anterior da aba Configurações não mais necessário, pois agora é a aba Tokens -->
                </div>
            </div>
        </section>
    </main>

    <!-- Modal para Editar Informações da Clínica -->
    <div id="editClinicModal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <h2>Editar Dados da Clínica</h2>
            <form id="clinicForm" class="clinic-form">
                <label for="clinicName">Nome da Clínica</label>
                <input type="text" id="clinicName" name="clinicName" value="Clínica Sertãozinho" required>
                <label for="clinicAddress">Endereço</label>
                <input type="text" id="clinicAddress" name="clinicAddress" value="Rua das Flores, 123 - Centro" required>
                <label for="clinicPhone">Telefone</label>
                <input type="tel" id="clinicPhone" name="clinicPhone" value="(99) 99999-9999">
                <label for="clinicEmail">E-mail</label>
                <input type="email" id="clinicEmail" name="clinicEmail" value="contato@clinicasertaozinho.com">
                <label for="clinicDescription">Descrição</label>
                <textarea id="clinicDescription" name="clinicDescription" rows="4">Especializada em atendimento infantil.</textarea>
                <div class="form-actions">
                    <button type="button" class="btn cancel" id="cancelButton">Cancelar</button>
                    <button type="submit" class="btn save">Salvar</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal para Comprar Tokens -->
    <div id="buyTokensModal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <h2>Comprar Tokens</h2>
            <p>Escolha um pacote de tokens:</p>
            <div style="display: flex; gap: 20px; flex-wrap: wrap; margin-top: 15px;">
                <div style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 8px; padding: 15px; text-align: center; flex: 1; min-width: 150px;">
                    <h3 style="font-size:16px; margin-bottom:10px;">50 Tokens</h3>
                    <p style="margin-bottom:10px;">R$ 30,00</p>
                    <button class="buy-token-package" data-tokens="50" data-price="30.00" style="background-color: #08C89E; color: #fff; border: none; border-radius: 6px; padding: 8px 12px; cursor:pointer;">Comprar</button>
                </div>
                <div style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 8px; padding: 15px; text-align: center; flex: 1; min-width: 150px;">
                    <h3 style="font-size:16px; margin-bottom:10px;">100 Tokens</h3>
                    <p style="margin-bottom:10px;">R$ 50,00</p>
                    <button class="buy-token-package" data-tokens="100" data-price="50.00" style="background-color: #08C89E; color: #fff; border: none; border-radius: 6px; padding: 8px 12px; cursor:pointer;">Comprar</button>
                </div>
                <div style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 8px; padding: 15px; text-align: center; flex: 1; min-width: 150px;">
                    <h3 style="font-size:16px; margin-bottom:10px;">200 Tokens</h3>
                    <p style="margin-bottom:10px;">R$ 90,00</p>
                    <button class="buy-token-package" data-tokens="200" data-price="90.00" style="background-color: #08C89E; color: #fff; border: none; border-radius: 6px; padding: 8px 12px; cursor:pointer;">Comprar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Resultado -->
    <div id="result-modal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <p>Resultado do M-CHAT: Pontuação de Risco: 3. ...</p>
            <button class="btn save" id="copy-button">Copiar Texto</button>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const tabs = document.querySelectorAll('.tab');
            const tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    tabs.forEach(item => item.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    tab.classList.add('active');
                    document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
                });
            });

            // Modal editar clínica
            const editClinicBtn = document.getElementById('editClinicBtn');
            const editClinicModal = document.getElementById('editClinicModal');
            const closeModalBtns = document.querySelectorAll('.close-button');

            editClinicBtn.addEventListener('click', () => {
                editClinicModal.style.display = 'block';
            });

            closeModalBtns.forEach(btn => {
                btn.addEventListener('click', () => {
                    btn.closest('.modal').style.display = 'none';
                });
            });

            window.addEventListener('click', (event) => {
                if (event.target.classList.contains('modal')) {
                    event.target.style.display = 'none';
                }
            });

            document.getElementById('cancelButton').addEventListener('click', function() {
                if (confirm('Tem certeza de que deseja cancelar as alterações?')) {
                    location.reload();
                }
            });

            document.getElementById('clinicForm').addEventListener('submit', function(event) {
                event.preventDefault();
                alert('Informações da clínica atualizadas com sucesso!');
                editClinicModal.style.display = 'none';
            });

            // Função de Paginação
            function paginateTable(tableId, paginationId, itemsPerPage) {
                const table = document.getElementById(tableId);
                const tbody = table.querySelector('tbody');
                const rows = Array.from(tbody.querySelectorAll('tr'));
                const totalPages = Math.ceil(rows.length / itemsPerPage);
                const pagination = document.getElementById(paginationId);

                if(!pagination) return; // Se não existir, não faz nada

                pagination.innerHTML = '';

                function showPage(page) {
                    rows.forEach((row, index) => {
                        row.style.display = (index >= (page - 1) * itemsPerPage && index < page * itemsPerPage) ? '' : 'none';
                    });

                    const buttons = pagination.querySelectorAll('button');
                    buttons.forEach(btn => btn.classList.remove('active'));
                    if (buttons[page - 1]) {
                        buttons[page - 1].classList.add('active');
                    }
                }

                for (let i = 1; i <= totalPages; i++) {
                    const btn = document.createElement('button');
                    btn.innerText = i;
                    if (i === 1) btn.classList.add('active');
                    btn.addEventListener('click', () => showPage(i));
                    pagination.appendChild(btn);
                }

                showPage(1);
            }

            paginateTable('professionalsTable', 'pagination-professionals', 10);
            paginateTable('childrenTable', 'pagination-children', 10);

            // Busca em crianças
            const searchInput = document.getElementById('searchChildren');
            if (searchInput) {
                searchInput.addEventListener('input', function() {
                    const filter = searchInput.value.toLowerCase();
                    const table = document.getElementById('childrenTable');
                    const tbody = table.querySelector('tbody');
                    const rows = Array.from(tbody.querySelectorAll('tr'));

                    rows.forEach(row => {
                        const cells = row.querySelectorAll('td');
                        const match = Array.from(cells).some(cell => cell.textContent.toLowerCase().includes(filter));
                        row.style.display = match ? '' : 'none';
                    });
                    // Recalcular paginação após filtro se necessário...
                });
            }

            // Modal Resultado
            const resultModal = document.getElementById('result-modal');
            const copyButton = document.getElementById('copy-button');
            const viewButtons = document.querySelectorAll('.view-button');

            viewButtons.forEach(button => {
                button.addEventListener('click', function(event) {
                    event.preventDefault();
                    resultModal.style.display = 'block';
                });
            });

            if (copyButton) {
                copyButton.addEventListener('click', function() {
                    const textToCopy = resultModal.querySelector('p').innerText;
                    navigator.clipboard.writeText(textToCopy).then(function() {
                        alert('Texto copiado para a área de transferência.');
                    }, function() {
                        alert('Erro ao copiar o texto.');
                    });
                });
            }

            // Aba Tokens: Compra de Tokens
            let nextTokenInvoiceId = 1004; // Próximo ID de fatura de tokens
            const buyTokensBtn = document.getElementById('buyTokensBtn');
            const buyTokensModal = document.getElementById('buyTokensModal');
            const buyTokenPackageButtons = document.querySelectorAll('.buy-token-package');

            buyTokensBtn.addEventListener('click', () => {
                buyTokensModal.style.display = 'block';
            });

            buyTokenPackageButtons.forEach(btn => {
                btn.addEventListener('click', () => {
                    const tokens = btn.getAttribute('data-tokens');
                    const price = btn.getAttribute('data-price');
                    // Ao clicar, geramos uma nova fatura em aberto no histórico
                    const tableBody = document.querySelector('#tokenPurchaseHistory tbody');
                    const newRow = tableBody.insertRow(0); // Insere no topo do histórico
                    const invoiceId = nextTokenInvoiceId++;
                    const dateStr = new Date().toLocaleDateString('pt-BR');
                    const tokensAmount = `${tokens} Tokens`;
                    const valor = `R$ ${price}`;

                    newRow.innerHTML = `
                        <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#${invoiceId}</td>
                        <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">${dateStr}</td>
                        <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">${tokensAmount}</td>
                        <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">${valor}</td>
                        <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #d69e2e; font-weight: 600;">Em Aberto</td>
                        <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                            <button class="btn pay-now" style="background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;">
                                <i class="fas fa-credit-card"></i> Pagar Agora
                            </button>
                        </td>
                    `;

                    alert(`Fatura gerada: #${invoiceId} - ${tokens} Tokens, R$ ${price}. Status: Em Aberto.`);
                    buyTokensModal.style.display = 'none';
                });
            });
        });
    </script>
    
    
    
    <!-- Modal para Editar Informações da Clínica -->
    <div id="editClinicModal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <h2>Editar Informações da Clínica</h2>
            <form id="clinicForm" class="clinic-form">
                <label for="clinicName">Nome da Clínica</label>
                <input type="text" id="clinicName" name="clinicName" value="Clínica Sertãozinho" required>
                <label for="clinicAddress">Endereço</label>
                <input type="text" id="clinicAddress" name="clinicAddress" value="Rua das Flores, 123 - Centro" required>
                <label for="clinicPhone">Telefone</label>
                <input type="tel" id="clinicPhone" name="clinicPhone" value="(99) 99999-9999">
                <label for="clinicEmail">Email</label>
                <input type="email" id="clinicEmail" name="clinicEmail" value="contato@clinicasertaozinho.com">
                <label for="clinicDescription">Descrição</label>
                <textarea id="clinicDescription" name="clinicDescription" rows="4">Especializada em atendimento infantil.</textarea>
                <!-- Ações do Formulário -->
                <div class="form-actions">
                    <button type="button" class="btn cancel" id="cancelButton">Cancelar</button>
                    <button type="submit" class="btn save">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>

    <!-- NOVO: Modal para escolher plano -->
    <div id="choosePlanModal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <h2>Escolher/Alterar Plano</h2>
            <p>Selecione um plano de acordo com a quantidade de crianças que deseja cadastrar na clínica.</p>
            <div class="plans-container">
                <div class="plan-card" data-plan="Basico" data-price="99.90" data-children="20">
                    <h3>Plano Básico</h3>
                    <p>Até 20 crianças</p>
                    <p>R$ 99,90/mês</p>
                    <button class="select-plan-btn">Selecionar</button>
                </div>
                <div class="plan-card" data-plan="Pro" data-price="199.90" data-children="50">
                    <h3>Plano Pro</h3>
                    <p>Até 50 crianças</p>
                    <p>R$ 199,90/mês</p>
                    <button class="select-plan-btn">Selecionar</button>
                </div>
                <div class="plan-card" data-plan="Premium" data-price="299.90" data-children="100">
                    <h3>Plano Premium</h3>
                    <p>Até 100 crianças</p>
                    <p>R$ 299,90/mês</p>
                    <button class="select-plan-btn">Selecionar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Resultado (exemplo fornecido) -->
    <div id="result-modal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <p>Resultado do M-CHAT: ...</p>
            <button class="btn save" id="copy-button">Copiar Texto</button>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const tabs = document.querySelectorAll('.tab');
            const tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    tabs.forEach(item => item.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    tab.classList.add('active');
                    document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
                });
            });

            const editClinicBtn = document.getElementById('editClinicBtn');
            const editClinicModal = document.getElementById('editClinicModal');
            const closeModalBtns = document.querySelectorAll('.close-button');

            if (editClinicBtn) {
                editClinicBtn.addEventListener('click', () => {
                    editClinicModal.style.display = 'block';
                });
            }

            closeModalBtns.forEach(btn => {
                btn.addEventListener('click', () => {
                    btn.closest('.modal').style.display = 'none';
                });
            });

            window.addEventListener('click', (event) => {
                if (event.target.classList.contains('modal')) {
                    event.target.style.display = 'none';
                }
            });

            document.getElementById('cancelButton').addEventListener('click', function() {
                if (confirm('Tem certeza de que deseja cancelar as alterações?')) {
                    location.reload();
                }
            });

            document.getElementById('clinicForm').addEventListener('submit', function(event) {
                event.preventDefault();
                alert('Informações da clínica atualizadas com sucesso!');
                editClinicModal.style.display = 'none';
            });

            // Faturamento - Botão alterar plano
            const changePlanBtn = document.getElementById('changePlanBtn');
            const choosePlanModal = document.getElementById('choosePlanModal');
            const selectPlanBtns = document.querySelectorAll('.select-plan-btn');

            changePlanBtn.addEventListener('click', () => {
                choosePlanModal.style.display = 'block';
            });

            selectPlanBtns.forEach(btn => {
                btn.addEventListener('click', () => {
                    const planCard = btn.closest('.plan-card');
                    const planName = planCard.getAttribute('data-plan');
                    const planPrice = planCard.getAttribute('data-price');
                    const planChildren = planCard.getAttribute('data-children');

                    // Aqui você faria a chamada ao backend para gerar a cobrança no Asaas
                    // Por exemplo, algo como:
                    /*
                    fetch('/api/gerar-cobranca', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({plan: planName, price: planPrice, children: planChildren})
                    })
                    .then(response => response.json())
                    .then(data => {
                        if(data.success) {
                            alert('Cobrança gerada com sucesso. Confira seu email para pagamento via Asaas.');
                            // Atualizar infos de plano no front-end
                            document.getElementById('currentPlanName').textContent = planName;
                            document.getElementById('allowedChildren').textContent = planChildren;
                            document.getElementById('planPrice').textContent = 'R$ ' + planPrice;
                            choosePlanModal.style.display = 'none';
                        } else {
                            alert('Não foi possível gerar a cobrança. Tente novamente.');
                        }
                    });
                    */

                    // Simulação sem backend:
                    alert(`Plano ${planName} selecionado. Simulando geração de cobrança no Asaas...`);
                    document.getElementById('currentPlanName').textContent = planName;
                    document.getElementById('allowedChildren').textContent = planChildren;
                    document.getElementById('planPrice').textContent = 'R$ ' + planPrice;
                    choosePlanModal.style.display = 'none';
                });
            });

            // Aqui você poderia também implementar funcionalidade real de paginação, busca, etc.

            // Caso queira integrar de fato com Asaas:
            // - Você precisará de um endpoint no back-end (PHP, Node, etc) que chame a API do Asaas usando uma chave de API.
            // - O front-end apenas solicitará a criação da cobrança e receberá um link de pagamento ou algo do tipo.
        });
    </script>
    
    
    
    
    
    
    
    
    
    
    
    <!-- Modal para Editar Informações da Clínica -->
    <div id="editClinicModal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <h2>Editar Informações da Clínica</h2>
            <form id="clinicForm" class="clinic-form">
                <label for="clinicName">Nome da Clínica</label>
                <input type="text" id="clinicName" name="clinicName" value="Clínica Sertãozinho" required>
                <label for="clinicAddress">Endereço</label>
                <input type="text" id="clinicAddress" name="clinicAddress" value="Rua das Flores, 123 - Centro" required>
                <label for="clinicPhone">Telefone</label>
                <input type="tel" id="clinicPhone" name="clinicPhone" value="(99) 99999-9999">
                <label for="clinicEmail">Email</label>
                <input type="email" id="clinicEmail" name="clinicEmail" value="contato@clinicasertaozinho.com">
                <label for="clinicDescription">Descrição</label>
                <textarea id="clinicDescription" name="clinicDescription" rows="4">Especializada em atendimento infantil.</textarea>
                <!-- Ações do Formulário -->
                <div class="form-actions">
                    <button type="button" class="btn cancel" id="cancelButton">Cancelar</button>
                    <button type="submit" class="btn save">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
    <!-- Modal para Visualizar Resultado -->
    <div id="result-modal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <p>Resultado do M-CHAT: Pontuação de Risco: 3. Nível de Risco: Risco Médio. As seguintes áreas do desenvolvimento podem estar comprometidas: Sensibilidade e resposta auditiva, Atenção, Compreensão, Comportamento, Uso Corporal. Perguntas que indicaram risco: item2, item5, item12. O resultado indica um risco médio de TEA. Recomenda-se repetir o teste em um mês e considerar uma avaliação profissional.</p>
            <button class="btn save" id="copy-button">Copiar Texto</button>
        </div>
    </div>
    <!-- Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Seleciona todas as abas
            const tabs = document.querySelectorAll('.tab');
            // Seleciona todo o conteúdo das abas
            const tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    // Remove a classe 'active' de todas as abas e conteúdos
                    tabs.forEach(item => item.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    // Adiciona a classe 'active' na aba clicada e no conteúdo correspondente
                    tab.classList.add('active');
                    document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
                });
            });

            // Modal para editar informações da clínica
            const editClinicBtn = document.getElementById('editClinicBtn');
            const editClinicModal = document.getElementById('editClinicModal');
            const closeModalBtns = document.querySelectorAll('.close-button');

            editClinicBtn.addEventListener('click', () => {
                editClinicModal.style.display = 'block';
            });

            closeModalBtns.forEach(btn => {
                btn.addEventListener('click', () => {
                    btn.closest('.modal').style.display = 'none';
                });
            });

            // Fechar os modais ao clicar fora deles
            window.addEventListener('click', (event) => {
                if (event.target.classList.contains('modal')) {
                    event.target.style.display = 'none';
                }
            });

            // Evento para o botão Cancelar no formulário da clínica
            document.getElementById('cancelButton').addEventListener('click', function() {
                if (confirm('Tem certeza de que deseja cancelar as alterações?')) {
                    // Recarregar a página para restaurar os valores originais
                    location.reload();
                }
            });

            // Evento para o formulário da clínica
            document.getElementById('clinicForm').addEventListener('submit', function(event) {
                event.preventDefault();
                // Lógica para salvar as alterações no servidor
                alert('Informações da clínica atualizadas com sucesso!');
                editClinicModal.style.display = 'none';
            });

            

            document.getElementById('addInvoiceBtn').addEventListener('click', function() {
                alert('Funcionalidade de adicionar fatura em desenvolvimento.');
            });

            // Função para destacar colunas ativas ao clicar no cabeçalho
            const tableHeaders = document.querySelectorAll('.table-section th');

            tableHeaders.forEach(header => {
                header.addEventListener('click', () => {
                    // Remove destaque de todos os cabeçalhos e células
                    tableHeaders.forEach(h => h.classList.remove('active-column'));
                    const table = header.closest('table');
                    const index = Array.from(header.parentNode.children).indexOf(header);
                    const rows = table.querySelectorAll('tr');

                    rows.forEach(row => {
                        const cells = row.children;
                        Array.from(cells).forEach((cell, i) => {
                            if (i === index) {
                                cell.classList.toggle('active-column');
                            } else {
                                cell.classList.remove('active-column');
                            }
                        });
                    });
                });
            });

            // Modal para Visualizar Resultado
            const resultModal = document.getElementById('result-modal');
            const copyButton = document.getElementById('copy-button');

            // Ajuste para abrir o modal ao clicar em links com classe 'view-button'
            const viewButtons = document.querySelectorAll('.view-button');
            viewButtons.forEach(button => {
                button.addEventListener('click', function(event) {
                    event.preventDefault();
                    resultModal.style.display = 'block';
                });
            });

            copyButton.addEventListener('click', function() {
                const textToCopy = resultModal.querySelector('p').innerText;
                navigator.clipboard.writeText(textToCopy).then(function() {
                    alert('Texto copiado para a área de transferência.');
                }, function() {
                    alert('Erro ao copiar o texto.');
                });
            });

            // Função de Paginação
            function paginateTable(tableId, paginationId, itemsPerPage) {
                const table = document.getElementById(tableId);
                const tbody = table.querySelector('tbody');
                const rows = Array.from(tbody.querySelectorAll('tr'));
                const totalPages = Math.ceil(rows.length / itemsPerPage);
                const pagination = document.getElementById(paginationId);

                // Limpa a paginação existente
                pagination.innerHTML = '';

                function showPage(page) {
                    // Esconde todas as linhas
                    rows.forEach((row, index) => {
                        row.style.display = (index >= (page - 1) * itemsPerPage && index < page * itemsPerPage) ? '' : 'none';
                    });

                    // Atualiza os botões de paginação
                    const buttons = pagination.querySelectorAll('button');
                    buttons.forEach(btn => btn.classList.remove('active'));
                    if (buttons[page - 1]) {
                        buttons[page - 1].classList.add('active');
                    }
                }

                // Cria os botões de paginação
                for (let i = 1; i <= totalPages; i++) {
                    const btn = document.createElement('button');
                    btn.innerText = i;
                    if (i === 1) btn.classList.add('active');
                    btn.addEventListener('click', () => showPage(i));
                    pagination.appendChild(btn);
                }

                // Mostra a primeira página inicialmente
                showPage(1);
            }

            // Inicializa a paginação para Profissionais e Crianças
            paginateTable('professionalsTable', 'pagination-professionals', 10);
            paginateTable('childrenTable', 'pagination-children', 10);

            // Função de Busca para Crianças
            const searchInput = document.getElementById('searchChildren');
            searchInput.addEventListener('input', function() {
                const filter = searchInput.value.toLowerCase();
                const table = document.getElementById('childrenTable');
                const tbody = table.querySelector('tbody');
                const rows = Array.from(tbody.querySelectorAll('tr'));

                rows.forEach(row => {
                    const cells = row.querySelectorAll('td');
                    const match = Array.from(cells).some(cell => cell.textContent.toLowerCase().includes(filter));
                    row.style.display = match ? '' : 'none';
                });

                // Atualiza a paginação após a busca
                // Filtrar os rows visíveis
                const visibleRows = rows.filter(row => row.style.display !== 'none');
                const totalPages = Math.ceil(visibleRows.length / 10);
                const pagination = document.getElementById('pagination-children');

                // Limpa a paginação existente
                pagination.innerHTML = '';

                if (totalPages > 0) {
                    for (let i = 1; i <= totalPages; i++) {
                        const btn = document.createElement('button');
                        btn.innerText = i;
                        if (i === 1) btn.classList.add('active');
                        btn.addEventListener('click', () => {
                            // Esconde todas as linhas
                            rows.forEach(row => {
                                row.style.display = 'none';
                            });
                            // Mostra as linhas da página atual
                            visibleRows.slice((i - 1) * 10, i * 10).forEach(row => {
                                row.style.display = '';
                            });
                            // Atualiza os botões de paginação
                            const buttons = pagination.querySelectorAll('button');
                            buttons.forEach(button => button.classList.remove('active'));
                            btn.classList.add('active');
                        });
                        pagination.appendChild(btn);
                    }
                    // Mostra a primeira página
                    visibleRows.slice(0, 10).forEach(row => {
                        row.style.display = '';
                    });
                }
            });

            // Script para o botão "Nova Avaliação"
            const newEvaluationButton = document.getElementById('new-evaluation-button');
            const mchatForm = document.getElementById('mchat-form');
            const progressBar = document.getElementById('progress-bar');
            const questions = document.querySelectorAll('.question');

            if (newEvaluationButton) {
                newEvaluationButton.addEventListener('click', function() {
                    // Resetar o formulário
                    mchatForm.reset();
                    // Mostrar o formulário
                    mchatForm.style.display = 'block';
                    // Resetar barra de progresso
                    progressBar.style.width = '0%';
                    // Rolar até o formulário
                    mchatForm.scrollIntoView({ behavior: 'smooth' });
                });
            }

            // Script para a barra de progresso
            if (progressBar) {
                const totalQuestions = 20;
                const updateProgress = () => {
                    let answered = 0;
                    questions.forEach(question => {
                        const inputs = question.querySelectorAll('input[type="radio"]');
                        inputs.forEach(input => {
                            if (input.checked) {
                                answered++;
                            }
                        });
                    });
                    const progressPercent = (answered / totalQuestions) * 100;
                    progressBar.style.width = progressPercent + '%';
                };
                questions.forEach(question => {
                    const inputs = question.querySelectorAll('input[type="radio"]');
                    inputs.forEach(input => {
                        input.addEventListener('change', updateProgress);
                    });
                });
            }

            // Script para o botão "Continuar"
            const continueButtons = document.querySelectorAll('.continue-button');

            continueButtons.forEach(button => {
                button.addEventListener('click', function(event) {
                    event.preventDefault();
                    // Mostrar o formulário
                    mchatForm.style.display = 'block';
                    // Simular dados salvos
                    const savedData = {
                        q1: 'Sim',
                        notes1: 'Observação sobre a pergunta 1',
                        q2: 'Não',
                        notes2: 'Observação sobre a pergunta 2',
                        // Adicione os dados para todas as perguntas
                    };
                    // Preencher o formulário com os dados salvos
                    for (let key in savedData) {
                        if (savedData.hasOwnProperty(key)) {
                            const field = mchatForm.querySelector(`[name="${key}"]`);
                            if (field) {
                                if (field.type === 'radio') {
                                    const radio = mchatForm.querySelector(`input[name="${key}"][value="${savedData[key]}"]`);
                                    if (radio) {
                                        radio.checked = true;
                                    }
                                } else {
                                    field.value = savedData[key];
                                }
                            }
                        }
                    }
                    // Atualizar a barra de progresso
                    if (progressBar) updateProgress();
                    // Rolar até o formulário
                    mchatForm.scrollIntoView({ behavior: 'smooth' });
                });
            });

            // Script para o botão "Cancelar"
            const cancelButtonMchat = document.querySelector('.cancel-button');

            if (cancelButtonMchat) {
                cancelButtonMchat.addEventListener('click', function() {
                    // Resetar o formulário
                    mchatForm.reset();
                    // Ocultar o formulário
                    mchatForm.style.display = 'none';
                    // Resetar a barra de progresso
                    if (progressBar) progressBar.style.width = '0%';
                });
            }
        });
    </script>
    
    
    <script>
    document.addEventListener('DOMContentLoaded', () => {
        // Seleciona as abas e conteúdos existentes
        const tabs = document.querySelectorAll('.tab');
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                tabs.forEach(item => item.classList.remove('active'));
                tabContents.forEach(content => content.classList.remove('active'));

                tab.classList.add('active');
                document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
            });
        });

        // Modal para adicionar criança
        const addChildBtn = document.getElementById('addChildBtn');
        const addChildModal = document.getElementById('addChildModal');
        const closeButtons = addChildModal.querySelectorAll('.close-button');
        const cancelAddChild = document.getElementById('cancelAddChild');
        const addChildForm = document.getElementById('addChildForm');
        const assignedProfessionalSelect = document.getElementById('assignedProfessional');

        // Função para abrir o modal
        addChildBtn.addEventListener('click', () => {
            addChildModal.style.display = 'block';
            preencherDropdownProfissionais();
        });

        // Função para fechar o modal ao clicar nos botões de fechar
        closeButtons.forEach(btn => {
            btn.addEventListener('click', () => {
                addChildModal.style.display = 'none';
            });
        });

        // Função para fechar o modal ao clicar no botão "Cancelar"
        cancelAddChild.addEventListener('click', () => {
            if (confirm('Tem certeza de que deseja cancelar a adição desta criança?')) {
                addChildModal.style.display = 'none';
                addChildForm.reset();
            }
        });

        // Fechar o modal ao clicar fora dele
        window.addEventListener('click', (event) => {
            if (event.target == addChildModal) {
                addChildModal.style.display = 'none';
                addChildForm.reset();
            }
        });

        // Função para preencher o dropdown de profissionais
        function preencherDropdownProfissionais() {
            // Limpa as opções existentes (exceto a primeira)
            while (assignedProfessionalSelect.options.length > 1) {
                assignedProfessionalSelect.remove(1);
            }

            // Seleciona a tabela de profissionais
            const professionalsTable = document.getElementById('professionalsTable');
            const tbody = professionalsTable.querySelector('tbody');
            const rows = tbody.querySelectorAll('tr');

            rows.forEach(row => {
                const cells = row.querySelectorAll('td');
                const nomeProfissional = cells[0].textContent.trim(); // Supondo que o nome está na primeira coluna
                // Adiciona a opção ao select
                const option = document.createElement('option');
                option.value = nomeProfissional;
                option.textContent = nomeProfissional;
                assignedProfessionalSelect.appendChild(option);
            });
        }

        // Manipulação da submissão do formulário
        addChildForm.addEventListener('submit', function(event) {
            event.preventDefault();
            // Coleta os dados do formulário
            const childName = document.getElementById('childName').value;
            const birthDate = document.getElementById('birthDate').value;
            const guardianName = document.getElementById('guardianName').value;
            const contactPhone = document.getElementById('contactPhone').value;
            const assignedProfessional = assignedProfessionalSelect.value; // Pode ser vazio

            // Aqui você pode adicionar a lógica para enviar os dados para o servidor via AJAX
            // Por exemplo, usando fetch ou XMLHttpRequest

            // Exemplo simples de feedback
            alert('Criança adicionada com sucesso!');
            addChildModal.style.display = 'none';
            addChildForm.reset();

            // Atualizar a tabela de crianças dinamicamente
            adicionarLinhaNaTabela(childName, birthDate, guardianName, assignedProfessional);
        });

        // Função para adicionar uma nova linha na tabela de crianças (Simulação)
        function adicionarLinhaNaTabela(childName, birthDate, guardianName, assignedProfessional) {
            const tableBody = document.querySelector('#childrenTable tbody');
            const newRow = tableBody.insertRow();

            // Calcula a idade
            const age = calcularIdade(birthDate);

            // Determina o texto a ser exibido para o profissional atribuído
            const profissionalTexto = assignedProfessional ? assignedProfessional : 'Nenhum';

            // Define as ações (por exemplo, visualizar detalhes)
            const actions = `<a href="#" class="view-button"><i class="fas fa-eye"></i> Ver Detalhes</a>`;

            // Insere o conteúdo na nova linha
            newRow.innerHTML = `
                <td>${childName}</td>
                <td>${age}</td>
                <td>${guardianName}</td>
                <td>${profissionalTexto}</td>
                <td>${actions}</td>
            `;

            // Atualiza a paginação após adicionar uma nova linha
            atualizarPaginação('childrenTable', 'pagination-children', 10);

            // Reatribuir eventos aos novos botões "Ver Detalhes"
            reatribuirEventosViewButtons();
        }

        // Função para calcular a idade com base na data de nascimento
        function calcularIdade(dataNascimento) {
            const hoje = new Date();
            const nascimento = new Date(dataNascimento);
            let idade = hoje.getFullYear() - nascimento.getFullYear();
            const m = hoje.getMonth() - nascimento.getMonth();
            if (m < 0 || (m === 0 && hoje.getDate() < nascimento.getDate())) {
                idade--;
            }
            return `${idade} anos`;
        }

        // Função de Paginação
        function paginateTable(tableId, paginationId, itemsPerPage) {
            const table = document.getElementById(tableId);
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const totalPages = Math.ceil(rows.length / itemsPerPage);
            const pagination = document.getElementById(paginationId);

            if(!pagination) return; // Se não existir, não faz nada

            pagination.innerHTML = '';

            function showPage(page) {
                rows.forEach((row, index) => {
                    row.style.display = (index >= (page - 1) * itemsPerPage && index < page * itemsPerPage) ? '' : 'none';
                });

                const buttons = pagination.querySelectorAll('button');
                buttons.forEach(btn => btn.classList.remove('active'));
                if (buttons[page - 1]) {
                    buttons[page - 1].classList.add('active');
                }
            }

            for (let i = 1; i <= totalPages; i++) {
                const btn = document.createElement('button');
                btn.innerText = i;
                if (i === 1) btn.classList.add('active');
                btn.addEventListener('click', () => showPage(i));
                pagination.appendChild(btn);
            }

            showPage(1);
        }

        // Função para Atualizar a Paginação Após Adição
        function atualizarPaginação(tableId, paginationId, itemsPerPage) {
            paginateTable(tableId, paginationId, itemsPerPage);
        }

        // Inicializa a paginação para Crianças
        paginateTable('childrenTable', 'pagination-children', 10);

        // Reatribuir eventos aos botões "Ver Detalhes"
        function reatribuirEventosViewButtons() {
            const viewButtons = document.querySelectorAll('.view-button');
            viewButtons.forEach(button => {
                button.removeEventListener('click', visualizarDetalhes);
                button.addEventListener('click', visualizarDetalhes);
            });
        }

        // Função para visualizar detalhes (Exemplo)
        function visualizarDetalhes(event) {
            event.preventDefault();
            // Implementar a lógica para visualizar detalhes da criança
            alert('Funcionalidade "Ver Detalhes" em desenvolvimento.');
        }

        // Inicializa os eventos para os botões existentes
        reatribuirEventosViewButtons();
    });
    
    
    document.addEventListener('DOMContentLoaded', () => {
    const editChildModal = document.getElementById('editChildModal');
    const editChildForm = document.getElementById('editChildForm');
    const cancelEditChild = document.getElementById('cancelEditChild');
    const closeButtons = editChildModal.querySelectorAll('.close-button');
    const editAssignedProfessional = document.getElementById('editAssignedProfessional');
    const editSpecialty = document.getElementById('editSpecialty');
    
    // Dados simulados de profissionais e suas especialidades
    const professionalsData = {
        "Mariana Santos": "Fonoaudióloga",
        "Pedro Oliveira": "Psicólogo",
        "Ana Luiza": "Nutricionista",
        "Lucas Almeida": "Fisioterapeuta",
        "Beatriz Souza": "Terapeuta Ocupacional",
        "Felipe Costa": "Psicopedagogo",
        "Juliana Lima": "Enfermeira",
        "Ricardo Pinto": "Nutricionista"
    };

    // Ao clicar no botão de editar
    document.querySelectorAll('.edit-button').forEach(btn => {
        btn.addEventListener('click', (event) => {
            event.preventDefault();
            const row = btn.closest('tr');
            
            // Extrair dados da linha
            const childId = row.cells[0].textContent.trim();
            const childName = row.cells[1].textContent.trim();
            const guardianName = row.cells[3].textContent.trim();
            const assignedProfessional = row.cells[4].textContent.trim();
            const birthDate = row.getAttribute('data-birthdate') || '';

            // Preenche o formulário do modal
            document.getElementById('editChildId').textContent = childId; // Código como texto fixo
            document.getElementById('editChildName').value = childName;
            document.getElementById('editBirthDate').value = birthDate;
            document.getElementById('editGuardianName').value = guardianName;

            // Carrega o dropdown de profissionais e seleciona o atribuído
            editAssignedProfessional.innerHTML = '<option value="">Selecione um profissional</option>';
            Object.keys(professionalsData).forEach(professional => {
                const option = document.createElement('option');
                option.value = professional;
                option.textContent = professional;
                if (professional === assignedProfessional) {
                    option.selected = true;
                    editSpecialty.textContent = professionalsData[professional]; // Atualiza a especialidade
                }
                editAssignedProfessional.appendChild(option);
            });

            // Exibe o modal
            editChildModal.style.display = 'block';
        });
    });

    // Atualiza a especialidade ao selecionar um profissional
    editAssignedProfessional.addEventListener('change', () => {
        const selectedProfessional = editAssignedProfessional.value;
        if (selectedProfessional && professionalsData[selectedProfessional]) {
            editSpecialty.textContent = professionalsData[selectedProfessional];
        } else {
            editSpecialty.textContent = "Selecione um profissional";
        }
    });

    // Cancelar edição
    cancelEditChild.addEventListener('click', () => {
        if (confirm('Tem certeza que deseja cancelar a edição?')) {
            editChildModal.style.display = 'none';
        }
    });

    // Fechar modal ao clicar no botão de fechar
    closeButtons.forEach(btn => {
        btn.addEventListener('click', () => {
            editChildModal.style.display = 'none';
        });
    });

    // Fechar modal ao clicar fora dele
    window.addEventListener('click', (event) => {
        if (event.target == editChildModal) {
            editChildModal.style.display = 'none';
        }
    });

    // Submeter o formulário de edição
    editChildForm.addEventListener('submit', (event) => {
        event.preventDefault();
        alert('Informações atualizadas com sucesso!');
        editChildModal.style.display = 'none';

        // Aqui você pode enviar os dados atualizados ao servidor ou atualizar a tabela localmente.
    });
});

document.addEventListener('DOMContentLoaded', () => {
    const guardianRelation = document.getElementById('editGuardianRelation');
    const relationOtherField = document.getElementById('relationOtherField');

    // Mostrar/esconder campo "Especifique o vínculo"
    guardianRelation.addEventListener('change', () => {
        if (guardianRelation.value === 'Outro') {
            relationOtherField.style.display = 'block';
        } else {
            relationOtherField.style.display = 'none';
            document.getElementById('editGuardianOther').value = ''; // Limpar o campo
        }
    });
});
document.addEventListener('DOMContentLoaded', () => {
    const addChildModal = document.getElementById('addChildModal');
    const addChildForm = document.getElementById('addChildForm');
    const cancelAddChild = document.getElementById('cancelAddChild');
    const closeButtons = addChildModal.querySelectorAll('.close-button');
    const addAssignedProfessional = document.getElementById('addAssignedProfessional');
    const addSpecialty = document.getElementById('addSpecialty');
    const addRelationOtherField = document.getElementById('addRelationOtherField');
    const addGuardianRelation = document.getElementById('addGuardianRelation');

    // Dados simulados de profissionais e suas especialidades
    const professionalsData = {
        "Mariana Santos": "Fonoaudióloga",
        "Pedro Oliveira": "Psicólogo",
        "Ana Luiza": "Nutricionista",
        "Lucas Almeida": "Fisioterapeuta"
    };

    // Abrir modal
    document.getElementById('addChildBtn').addEventListener('click', () => {
        addChildModal.style.display = 'block';

        // Preencher dropdown de profissionais
        addAssignedProfessional.innerHTML = '<option value="">Selecione um profissional</option>';
        Object.keys(professionalsData).forEach(professional => {
            const option = document.createElement('option');
            option.value = professional;
            option.textContent = professional;
            addAssignedProfessional.appendChild(option);
        });
    });

    // Fechar modal
    closeButtons.forEach(btn => {
        btn.addEventListener('click', () => {
            addChildModal.style.display = 'none';
        });
    });

    cancelAddChild.addEventListener('click', () => {
        if (confirm('Tem certeza de que deseja cancelar?')) {
            addChildModal.style.display = 'none';
            addChildForm.reset();
        }
    });

    // Mostrar campo de vínculo adicional
    addGuardianRelation.addEventListener('change', () => {
        if (addGuardianRelation.value === 'Outro') {
            addRelationOtherField.style.display = 'block';
        } else {
            addRelationOtherField.style.display = 'none';
            document.getElementById('addGuardianOther').value = '';
        }
    });

    // Atualizar especialidade ao selecionar profissional
    addAssignedProfessional.addEventListener('change', () => {
        const selectedProfessional = addAssignedProfessional.value;
        addSpecialty.textContent = professionalsData[selectedProfessional] || "Selecione um profissional";
    });

    // Submeter o formulário
    addChildForm.addEventListener('submit', (event) => {
        event.preventDefault();
        alert('Criança adicionada com sucesso!');
        addChildModal.style.display = 'none';
        addChildForm.reset();

        // Atualizar a tabela dinamicamente ou enviar os dados ao servidor
    });
});


</script>


</body>
</html>
