<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Assistente - Gerenciar Clínicas</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Estilos da página */
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .clinics-container {
            margin-top: 20px;
        }

        .clinic-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
            transition: transform 0.2s;
        }

        .clinic-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .clinic-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .clinic-info i {
            font-size: 30px;
            color: #08C89E;
        }

        .clinic-details {
            display: flex;
            flex-direction: column;
        }

        .clinic-details h3 {
            margin: 0;
            font-size: 20px;
            color: #2d3748;
        }

        .clinic-details p {
            margin: 2px 0;
            font-size: 14px;
            color: #4a5568;
        }

        .clinic-actions button {
            background-color: #e53e3e;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }

        .clinic-actions button:hover {
            background-color: #c53030;
        }

        /* Modal de Confirmação */
        .modal {
            display: none; /* Oculto por padrão */
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.5);
            justify-content: center;
            align-items: center;
        }

        .modal-content {
            background-color: #fff;
            padding: 20px 30px;
            border-radius: 12px;
            width: 90%;
            max-width: 400px;
            position: relative;
            box-sizing: border-box;
        }

        .close-modal {
            position: absolute;
            top: 15px;
            right: 20px;
            font-size: 24px;
            color: #aaa;
            cursor: pointer;
        }

        .close-modal:hover {
            color: #000;
        }

        .modal-content h2 {
            margin-top: 0;
            color: #2d3748;
            font-size: 20px;
        }

        .modal-content p {
            color: #4a5568;
            font-size: 14px;
            margin: 15px 0;
        }

        .modal-actions {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        .modal-actions button {
            padding: 8px 16px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
        }

        .confirm-btn {
            background-color: #e53e3e;
            color: #fff;
        }

        .confirm-btn:hover {
            background-color: #c53030;
        }

        .cancel-btn {
            background-color: #a0aec0;
            color: #fff;
        }

        .cancel-btn:hover {
            background-color: #718096;
        }

        /* Responsividade */
        @media(max-width:768px) {
            .clinic-card {
                flex-direction: column;
                align-items: flex-start;
            }

            .clinic-actions {
                margin-top: 10px;
                width: 100%;
                display: flex;
                justify-content: flex-end;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-assistente-gerenciar-clinicas.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1 style="color:#08C89E;">Gerenciar Clínicas</h1>
        </div>

        <div class="clinics-container" id="clinicsContainer">
            <!-- Cards das Clínicas serão inseridos aqui via JavaScript -->
        </div>
    </main>

    <!-- Modal de Confirmação -->
    <div class="modal" id="confirmModal">
        <div class="modal-content">
            <span class="close-modal" id="closeModal">&times;</span>
            <h2>Confirmar Saída</h2>
            <p>Você tem certeza que deseja sair desta clínica?</p>
            <div class="modal-actions">
                <button class="confirm-btn" id="confirmLeave">Sim, sair</button>
                <button class="cancel-btn" id="cancelLeave">Cancelar</button>
            </div>
        </div>
    </div>

    <script>
        // Dados simulados das clínicas vinculadas ao assistente
        let clinics = [
            {id: 'CLIN001', nome: 'Clínica Saúde Integral', localizacao: 'Av. Paulista, 1000, São Paulo'},
            {id: 'CLIN002', nome: 'Centro de Terapias ABC', localizacao: 'Rua das Acácias, 200, Campinas'},
            {id: 'CLIN003', nome: 'Clínica Bem-Estar', localizacao: 'Praça da Sé, 50, São Paulo'},
            // Adicione mais clínicas conforme necessário
        ];

        const clinicsContainer = document.getElementById('clinicsContainer');
        const confirmModal = document.getElementById('confirmModal');
        const closeModal = document.getElementById('closeModal');
        const confirmLeaveBtn = document.getElementById('confirmLeave');
        const cancelLeaveBtn = document.getElementById('cancelLeave');
        let selectedClinicId = null;

        // Função para renderizar as clínicas
        function renderClinics() {
            clinicsContainer.innerHTML = '';

            if (clinics.length === 0) {
                clinicsContainer.innerHTML = '<p style="font-size: 16px; color: #4a5568;">Você não está vinculado a nenhuma clínica.</p>';
                return;
            }

            clinics.forEach(clinic => {
                const card = document.createElement('div');
                card.className = 'clinic-card';
                card.innerHTML = `
                    <div class="clinic-info">
                        <i class="fas fa-hospital-alt"></i>
                        <div class="clinic-details">
                            <h3>${clinic.nome}</h3>
                            <p><strong>ID:</strong> ${clinic.id}</p>
                            <p><strong>Localização:</strong> ${clinic.localizacao}</p>
                        </div>
                    </div>
                    <div class="clinic-actions">
                        <button onclick="leaveClinic('${clinic.id}')"><i class="fas fa-sign-out-alt"></i> Sair</button>
                    </div>
                `;
                clinicsContainer.appendChild(card);
            });
        }

        // Função para abrir o modal de confirmação
        function leaveClinic(id) {
            selectedClinicId = id;
            confirmModal.style.display = 'flex';
        }

        // Função para fechar o modal
        function closeConfirmationModal() {
            confirmModal.style.display = 'none';
            selectedClinicId = null;
        }

        // Evento para confirmar a saída da clínica
        confirmLeaveBtn.addEventListener('click', () => {
            if (selectedClinicId) {
                // Simular a remoção da clínica da lista
                clinics = clinics.filter(clinic => clinic.id !== selectedClinicId);
                renderClinics();
                alert('Você saiu da clínica com sucesso.');
                closeConfirmationModal();
            }
        });

        // Evento para cancelar a ação
        cancelLeaveBtn.addEventListener('click', closeConfirmationModal);
        closeModal.addEventListener('click', closeConfirmationModal);

        // Fechar o modal ao clicar fora do conteúdo
        window.addEventListener('click', (event) => {
            if (event.target == confirmModal) {
                closeConfirmationModal();
            }
        });

        // Inicializar a página
        document.addEventListener('DOMContentLoaded', renderClinics);
    </script>
</body>
</html>
