<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">

    <!-- CSS Personalizado -->
    <style>
        /* ... (seu CSS existente) ... */
        /* Atualizações e Novos Estilos */
        /* Estilos para o Modal */
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            background-color: #fefefe;
            margin: auto;
            padding: 20px;
            border: 1px solid #888;
            border-radius: 12px;
            width: 90%;
            max-width: 700px;
            position: relative;
        }
        
        .close-modal,
        .close-button {
            color: #aaa;
            float: right;
            font-size: 24px;
            font-weight: bold;
            position: absolute;
            top: 10px;
            right: 20px;
            cursor: pointer;
        }
        
        .close-modal:hover,
        .close-modal:focus,
        .close-button:hover,
        .close-button:focus {
            color: #000;
            text-decoration: none;
        }
        
        .modal-header {
            margin-bottom: 10px;
        }
        
        .modal-header h2 {
            margin: 0;
            color: #08C89E;
        }
        
        .modal-body .form-group {
            margin-bottom: 10px;
            margin-top: -40px
        }
        
        .modal-body .form-group label {
            display: block;
            margin-bottom: -5px;
            font-weight: 600;
        }
        
        .modal-body .form-group input,
        .modal-body .form-group select,
        .modal-body .form-group textarea {
            width: 100%;
            padding: 8px 12px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 14px;
        }
        
        .modal-footer {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 20px;
        }
        
        .modal-footer .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.3s;
        }
        
        .modal-footer .btn.cancel {
            background-color: #EDF2F7;
            color: #2d3748;
        }
        
        .modal-footer .btn.cancel:hover {
            background-color: #e2e8f0;
        }
        
        .modal-footer .btn.submit {
            background-color: #08C89E;
            color: #fff;
        }
        
        .modal-footer .btn.submit:hover {
            background-color: #06b287;
        }
        /* Estilos para o botão Excluir no Modal */
        
        .btn.delete {
            background-color: #e53e3e;
            color: #fff;
        }
        
        .btn.delete:hover {
            background-color: #c53030;
        }
        /* Estilos para a nova aba "Informações da Clínica" */
        
        .informacoes-clinica-section {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
        }
        /* Atualizações na tabela de profissionais */
        
        #professionalsTable th,
        #professionalsTable td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        
        #professionalsTable th {
            background-color: #f7fafc;
            color: #2d3748;
        }
        /* Melhorando a visualização das abas */
        
        .tabs-container {
            margin-bottom: 20px;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        /* Responsividade para novos elementos */
        
        @media (max-width: 768px) {
            .clinic-details div {
                flex: 1 1 100%;
            }
            .clinic-actions {
                flex: 1 1 100%;
            }
            .search-add-container {
                flex-direction: column;
                align-items: flex-start;
            }
            .search-container {
                width: 100%;
                margin-bottom: 10px;
            }
            .clinic-info-section,
            .informacoes-clinica-section {
                flex-direction: column;
                align-items: flex-start;
            }
        }
        
        .clinic-photo {
            position: relative;
            margin-right: 20px;
        }
        
        .clinic-photo img {
            width: 80px;
            height: 80px;
            border-radius: 10%;
            object-fit: cover;
            border: 2px solid #08C89E;
        }
        
        .edit-logo {
            position: absolute;
            bottom: 0;
            right: 0;
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 50%;
            padding: 6px;
            cursor: pointer;
            font-size: 14px;
        }
        
        .clinic-details p {
            margin: 5px 0;
            font-size: 16px;
        }
        
        .billing-summary {
            background-color: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .billing-summary p {
            margin-top: -5px;
            margin-bottom: -5px;
        }
        
        .billing-summary h3 {
            margin-top: -10px;
        }
        
        .active-invoice {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 0px;
        }
        
        .active-invoice p {
            margin: 0px;
        }
        
        .active-invoice h3 {
            margin: 0px;
        }
        /* Estilos para o Modal de Informações do Profissional */
        
        #professionalInfoModal .professional-details p {
            margin: 5px 0;
            font-size: 16px;
        }
        
        #assignedChildrenTable th,
        #assignedChildrenTable td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        
        #assignedChildrenTable th {
            background-color: #f7fafc;
            color: #2d3748;
        }
        
        
        
        /* Estilos para o Modal de Edição da Criança */
#editChildModal .modal-content {
            width: 95%;
            max-width: 700px;
            padding: 20px;
            border-radius: 16px;
            background-color: #fefefe;
            box-shadow: 0 5px 15px rgba(0,0,0,0.3);
            display: flex;
            flex-direction: column;
            position: relative;
            animation: fadeIn 0.3s ease-out;
            font-family: 'Poppins', sans-serif;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        #editChildModal .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }

        #editChildModal .modal-header h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: -10px;
        }

        #editChildModal .child-id {
            color: #F6AD55;
            font-weight: 700;
        }

        .form-section {
            margin-bottom: 15px;
        }

        .form-section h3 {
            font-size: 16px;
            color: #2d3748;
            margin-bottom: 10px;
            border-bottom: 2px solid #e2e8f0;
            padding-bottom: 5px;
        }

        
        .form-field {
            flex: 1;
            min-width: 180px;
            display: flex;
            flex-direction: column;
        }

        .form-field.full-width {
            flex: 1 1 100%;
        }

        .form-field label {
            margin-bottom: 5px;
            font-weight: 600;
            color: #2d3748;
            font-size: 14px;
        }

        .form-field input,
        .form-field select,
        .form-field textarea {
            padding: 8px 10px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        .form-field input:focus,
        .form-field select:focus,
        .form-field textarea:focus {
            border-color: #06b287;
            outline: none;
        }

        .specialty-display {
            padding: 8px 10px;
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            min-height: 38px;
            display: flex;
            align-items: center;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
            font-family: 'Poppins', sans-serif;
            font-size: 14px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .add-professional-btn {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 12px;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .add-professional-btn:hover {
            background-color: #06b287;
        }

        .remove-professional {
            background-color: #e53e3e;
            color: #fff;
            padding: 6px 10px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
        }

        .remove-professional:hover {
            background-color: #c53030;
        }

        .form-actions {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 10px;
        }

        .form-actions .btn.cancel {
            background-color: #edf2f7;
            color: #2d3748;
        }

        .form-actions .btn.cancel:hover {
            background-color: #e2e8f0;
        }

        .form-actions .btn.delete {
            background-color: #e53e3e;
            color: #fff;
        }

        .form-actions .btn.delete:hover {
            background-color: #c53030;
        }

        .form-actions .btn.save {
            background-color: #08C89E;
            color: #fff;
        }

        .form-actions .btn.save:hover {
            background-color: #06b287;
        }

        .assigned-professionals-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .assigned-professionals-table th,
        .assigned-professionals-table td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }

        .assigned-professionals-table th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        .assigned-professionals-table tr:hover {
            background-color: #f1f1f1;
        }

        .hidden {
            display: none;
        }

        

    .btn.view-professional {
        background-color: #f7fafc;
        
    }
    
    /* Paginação */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
        }

        .pagination a {
            padding: 4px 7px;
            text-decoration: none;
            color: #333;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            margin: 0 5px;
            font-size: 14px;
        }

        .pagination a.active {
            background-color: #08C89E;
            color: white;
            border-color: #08C89E;
        }

        .pagination a:hover:not(.active) {
            background-color: #f1f5f9;
        }

        .pagination a.disabled {
            color: #cbd5e0;
            cursor: not-allowed;
        }
        
        
        .record-count {
    margin-right: auto; /* Empurra a contagem para a esquerda */
    font-size: 14px;
    color: #333;
}
        
        #calculo-container {
            display: none;
            margin-top: 20px;
        }
        
        #professionalsTable td, #professionalsTable th {
        padding: 5px ; /* Ajuste os valores conforme necessário */
        font-size: 14px; /* Pode ajustar o tamanho da fonte também para diminuir a altura */
    }
        
        
        /* Container de Informações - visual compacto */
        .nf-info-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .nf-info-card h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: 8px;
        }

        .nf-info-list p {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 4px;
        }

        .nf-edit-button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 8px 16px;
            font-size: 14px;
            cursor: pointer;
            align-self: flex-end; /* Fica à direita */
            transition: background 0.3s;
        }
        .nf-edit-button:hover {
            background-color: #06b287;
        }

        /* Overlay do Modal */
        .modal-overlay {
            display: none; /* Oculto por padrão */
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0,0,0,0.5);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }

        /* Conteúdo do Modal */
        .modal-content {
            background-color: #fff;
            border-radius: 12px;
            padding: 20px;
            max-width: 700px;
            width: 90%;
            box-sizing: border-box;
            position: relative;
            animation: fadeIn 0.3s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }

        /* Botão de Fechar do Modal */
        .modal-close-btn {
            position: absolute;
            top: 16px;
            right: 16px;
            background: none;
            border: none;
            font-size: 18px;
            cursor: pointer;
            color: #4a5568;
        }
        .modal-close-btn:hover {
            color: #e53e3e;
        }

        /* Formulário dentro do Modal */
        .nf-modal-form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
            margin-top: 40px;
        }
        .nf-modal-form label {
            font-size: 14px;
            color: #2d3748;
            margin-bottom: 4px;
        }
        .nf-modal-form input {
            width: 100%;
            padding: 8px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
        }
        .nf-modal-form select {
            width: 100%;
            padding: 8px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
        }

        .nf-modal-form .full-width {
            grid-column: 1 / 3; /* Faz o input ocupar as 2 colunas do grid */
        }

        .modal-footer {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 16px;
        }
        .modal-btn {
            padding: 8px 16px;
            border-radius: 8px;
            font-size: 14px;
            border: none;
            cursor: pointer;
            transition: background 0.3s;
        }
        .modal-btn.cancel {
            background-color: #e53e3e;
            color: #fff;
        }
        .modal-btn.cancel:hover {
            background-color: #c53030;
        }
        .modal-btn.save {
            background-color: #08C89E;
            color: #fff;
        }
        .modal-btn.save:hover {
            background-color: #06b287;
        }
        
        
        
        
        
        /* Cartão de Informações da Clínica */
        .clinic-info-card {
            background-color: #ffffff;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 20px;
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .clinic-info-card h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: -20px;
            margin-top: -10px;
        }

        .clinic-info-list p {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: -15px;
        }
        .clinic-info-list a {
            margin-top: 35px;
        }

        /* Botão Editar com Estilo Minimalista */
        .clinic-edit-button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 8px 16px;
            font-size: 14px;
            cursor: pointer;
            align-self: flex-end;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: background 0.3s;
        }

        .clinic-edit-button:hover {
            background-color: #06b287;
        }

        /* Modal Overlay */
        .clinic-modal-overlay {
            display: none; /* Oculto por padrão */
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0,0,0,0.5);
            z-index: 1000;
            justify-content: center;
            align-items: center;
            padding: 10px;
            box-sizing: border-box;
        }

        /* Exibir Modal quando Alvo é Ativado */
        #clinic-edit-modal:target {
            display: flex;
        }

        /* Conteúdo do Modal */
        .clinic-modal-content {
            background-color: #fff;
            border-radius: 12px;
            padding: 20px;
            max-width: 800px;
            width: 100%;
            box-sizing: border-box;
            position: relative;
            animation: fadeIn 0.3s ease-in-out;
            max-height: 90vh;
            overflow-y: auto;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }

        /* Botão de Fechar Modal */
        .clinic-modal-close {
            position: absolute;
            top: 16px;
            right: 16px;
            background: none;
            border: none;
            font-size: 22px;
            cursor: pointer;
            color: #4a5568;
        }

        .clinic-modal-close:hover {
            color: #e53e3e;
        }

        /* Formulário no Modal */
        .clinic-modal-form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
            margin-top: 20px;
        }

        .clinic-modal-form label {
            font-size: 14px;
            color: #2d3748;
            margin-bottom: 4px;
        }

        .clinic-modal-form input,
        .clinic-modal-form select,
        .clinic-modal-form textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
        }

        /* Campo que ocupa duas colunas */
        .clinic-modal-form .full-width {
            grid-column: 1 / 3;
        }

        /* Botões de Ação no Modal */
        .clinic-modal-footer {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 20px;
            grid-column: 1 / 3; /* Ocupa as duas colunas */
        }

        .clinic-modal-btn {
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            border: none;
            cursor: pointer;
            transition: background 0.3s;
        }

        .clinic-modal-btn.cancel {
            background-color: #e53e3e;
            color: #fff;
            text-decoration: none;
            display: inline-block;
        }

        .clinic-modal-btn.cancel:hover {
            background-color: #c53030;
        }

        .clinic-modal-btn.save {
            background-color: #08C89E;
            color: #fff;
            text-decoration: none;
            display: inline-block;
        }

        .clinic-modal-btn.save:hover {
            background-color: #06b287;
        }

        
    </style>
</head>

<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-clinicas-gerenciar_novo.php'; ?>

    <!-- Conteúdo Principal -->
    <main class="content" style="margin-top: 70px">
        <div class="header-content" >

            <h1 style="color: #08C89E; margin-left: 15px"><i class="fas fa-edit" style="margin-right: 0px"></i> Gerenciar: <span style="color: #F6AD55">Clínica Sertãozinho</span></h1>
        </div>

        <!-- Seção de Abas -->
        <section class="tabs-section">
            <div class="tabs-container">
                <!-- Linha das abas: Adicionando a classe 'active' à aba Profissionais -->
                <div class="tabs">
                    <div class="tab active" data-tab="profissionais"><i class="fas fa-user-md"></i> Profissionais</div>
                    <div class="tab" data-tab="criancas"><i class="fas fa-child"></i> Pacientes</div>
                    <div class="tab" data-tab="faturamento"><i class="fas fa-file-invoice-dollar"></i> Assinatura</div>
                    <!-- <div class="tab" data-tab="tokens"><i class="fas fa-coins"></i> Tokens</div> -->
                    <div class="tab" data-tab="informacoes"><i class="fas fa-info-circle"></i> Informações</div>
                    <!-- Nova Aba -->
                </div>
                <!-- Conteúdo das Abas -->

                <!-- Profissionais -->
                <div id="profissionais" class="tab-content active">
                    <p style="margin-top: -20px; margin-bottom: 0px">Lista de profissionais atribuídos a esta clínica.</p>
                    <hr />
                    <div class="filters" role="search" aria-label="Filtros de Pesquisa">
                        <div class="filter-group">
                            <label for="searchChildName">Buscar por Código:</label>
                            <input style="width: 150px" type="text" id="searchChildName" name="searchChildName" placeholder="Ex: PRA001" aria-label="Nome da Criança">
                        </div>
                        <div class="filter-group">
                            <label for="searchChildName">Buscar por Nome (Profissional):</label>
                            <input type="text" id="searchChildName" name="searchChildName" placeholder="Nome do profissional..." aria-label="Nome do profissional" style="width: 300px">
                        </div>
                        <div class="filter-group">
                            <label for="professionalFilterChildren">Filtrar por Perfil:</label>
                            <select id="professionalFilterChildren" name="professionalFilterChildren" style="width: 200px">
                                <option value="">Todos</option>
                                <option value="Admin">Admin</option>
                                <option value="Co-Admin">C-oAdmin</option>
                                <option value="Supervisor">Supervisor</option>
                                <option value="Colaborador">Colaborador</option>
                            </select>
                        </div>
                    </div>

                    <table id="professionalsTable" class="table-section">
                        <thead>
                            <tr>
                                <th>ORD</th>
                                <th>Código</th>
                                <th>Nome do Profissional</th>
                                <th>Formação Acadêmica</th>
                                <th>Email de Usuario</th>
                                <th>Perfil de Acesso</th>
                                <th>#</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>1</td>
                                <td>PRF001</td>
                                <td>Mariana Santos</td>
                                <td>Fonoaudióloga</td>
                                <td>mariana.santos@example.com</td>
                                <td>Admin</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001" onclick="mostrarprofessionalInfoModal1()"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>2</td>
                                <td>PRF002</td>
                                <td>Pedro Oliveira</td>
                                <td>Psicólogo</td>
                                <td>pedro.oliveira@example.com</td>
                                <td>Co-Admin</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001" onclick="mostrarprofessionalInfoModal1()"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>3</td>
                                <td>PRF003</td>
                                <td>Ana Luiza</td>
                                <td>Nutricionista</td>
                                <td>ana.luiza@example.com</td>
                                <td>Supervisor</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001" onclick="mostrarprofessionalInfoModal1()"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <!-- Adicionando mais 9 profissionais com IDs e Perfis -->
                            <tr>
                                <td>4</td>
                                <td>PRF004</td>
                                <td>Lucas Almeida</td>
                                <td>Fisioterapeuta</td>
                                <td>lucas.almeida@example.com</td>
                                <td>Colaborador</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001" onclick="mostrarprofessionalInfoModal()"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>5</td>
                                <td>PRF005</td>
                                <td>Beatriz Souza</td>
                                <td>Terapeuta Ocupacional</td>
                                <td>beatriz.souza@example.com</td>
                                <td>Colaborador</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001" onclick="mostrarprofessionalInfoModal()"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>6</td>
                                <td>PRF006</td>
                                <td>Felipe Costa</td>
                                <td>Psicopedagogo</td>
                                <td>felipe.costa@example.com</td>
                                <td>Colaborador</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>7</td>
                                <td>PRF007</td>
                                <td>Juliana Lima</td>
                                <td>Enfermeira</td>
                                <td>juliana.lima@example.com</td>
                                <td>Colaborador</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>8</td>
                                <td>PRF008</td>
                                <td>Ricardo Pinto</td>
                                <td>Nutricionista</td>
                                <td>ricardo.pinto@example.com</td>
                                <td>Colaborador</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>9</td>
                                <td>PRF009</td>
                                <td>Camila Rocha</td>
                                <td>Fonoaudióloga</td>
                                <td>camila.rocha@example.com</td>
                                <td>Colaborador</td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            <tr>
                                <td>10</td>
                                <td>PRF010</td>
                                <td>Thiago Martins</td>
                                <td>Psicólogo</td>
                                <td>thiago.martins@example.com</td>
                                <td>Supervisor </td>
                                <td>
                                    <button style="background-color: transparent; border: none; padding: 0px" class="btn view-professional" data-professional-id="PRF001"><i class="fas fa-eye" style="margin-right: 8px"></i></button>
                                </td>

                            </tr>
                            
                        </tbody>
                    </table>
                    
                    <!-- Paginação para Profissionais -->
                   <!-- Paginação para Profissionais com Informação de Registros -->
<div class="pagination-container" style="text-align: center; margin-top: 20px;">
    
    <div class="pagination">
        <span class="record-count">Total de registros: 25</span>
        <a href="#" class="active">1</a>
        <a href="#">2</a>
        <a href="#">3</a>
        <a href="#">4</a>
        <a href="#">Próximo &raquo;</a>
    </div>
</div>
                </div>

                <!-- Modal para Informações do Profissional -->
                <div id="professionalInfoModal" class="modal">
                    <div class="modal-content">
                        <span class="close-modal">&times;</span>
                        <div class="modal-header">
                            <h2 style="color: #fff">Profissional: <span style="color: #F6AD55">#PRA008</span></h2>
                        </div>
                        <div class="modal-body">
                            <div class="professional-details">
                                <p style="margin-top: 0px;"><strong>Nome Completo:</strong> Mariana Santos</p>
                                <p style="margin-top: -10px;"><strong>Formação:</strong> Fonoaudióloga</span></p>
                                <p style="margin-top: -10px;"><strong>Email:</strong> mariana.santos@example.com</span></p>
                                <p style="margin-top: -10px;"><strong>Perfil:</strong> Colaborador</span></p>
                            </div>

                            <div class="assigned-children" style="margin-bottom: 20px; margin-top: 0px; background-color: #f9f9f9; padding: 8px 16px; border-radius: 8px; border: 1px solid #ccc;">
                                <h3 style="margin-top: 0px;">Crianças Atribuídas</h3>
                                <p style="margin-top: -20px; font-size: 80%"><b>OBS: </b>Use a aba <b>'Crianças'</b> para adicionar pacientes.</p>
                                <hr />
                                <table id="assignedChildrenTable" class="table-section">
                                    <thead>
                                        <tr>
                                            <th>Ord</th>
                                            <th>ID Paciente</th>
                                            <th>Nome Completo</th>
                                            <th>Responsável</th>
                                            <th>#</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <td>1</td>
                                        <td>ABC12347</td>
                                        <td>Beatriz Lima</td>
                                        <td>Ricardo Lima</td>
                                        <td><i class="fas fa-trash-alt"></i></td>
                                    </tbody>
                                    <tbody>
                                        <td>2</td>
                                        <td>ABC12347</td>
                                        <td>Maria Fernanda</td>
                                        <td>Carlos Eduardo</td>
                                        <td><i class="fas fa-trash-alt"></i></td>
                                    </tbody>
                                    <tbody>
                                        <td>3</td>
                                        <td>ABC12347</td>
                                        <td>Rafael Santos</td>
                                        <td>Patrícia Santos</td>
                                        <td><i class="fas fa-trash-alt"></i></td>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
                
                <!-- Modal para Informações do Profissional Perfil -->
                <div id="professionalInfoModal1" class="modal">
                    <div class="modal-content">
                        <span class="close-modal">&times;</span>
                        <div class="modal-header">
                            <h2 style="color: #fff">Profissional: <span style="color: #F6AD55">#PRA008</span></h2>
                        </div>
                        <div class="modal-body">
                            <div class="professional-details">
                                <p style="margin-top: 0px;"><strong>Nome Completo:</strong> Mariana Santos</p>
                                <p style="margin-top: -20px;"><strong>Formação:</strong> Fonoaudióloga</span></p>
                                <p style="margin-top: -20px;"><strong>Email:</strong> mariana.santos@example.com</span></p>
                                <p style="margin-top: -20px;"><strong>Perfil:</strong> Admin/Co-Admin/Supervisor</span></p>
                            </div>

                            <div class="assigned-children" style="margin-bottom: 20px; margin-top: 0px; background-color: #f9f9f9; padding: 8px 16px; border-radius: 8px; border: 1px solid #ccc;">
                                <h3 style="margin-top: 0px;">Crianças Atribuídas</h3>
                                <hr />
                                <p> Este perfil possui acesso a todos os pacientes cadastrados nessa clínica.</p>

                            </div>
                        </div>

                    </div>
                </div>



                <!-- Crianças -->
                <div id="criancas" class="tab-content">
                    <p style="margin-top: -20px; margin-bottom: 0px">Cadastre e administre os pacientes associadas à sua clínica.</p>
                    <hr />
                    <div class="filters" role="search" aria-label="Filtros de Pesquisa">
                        <div class="filter-group">
                            <label for="searchChildName">Cadastrar Paciente:</label>
                            <button class="btn add" id="addChildBtn" style="background-color: #08C89E; color: #fff; border: none; padding: 8px 20px; border-radius: 8px; cursor: pointer; font-family: 'Poppins', sans-serif; font-size: 14px; display: flex; align-items: center;" onclick="mostraraddChildModal()">
                            <i class="fas fa-plus" style="margin-right: 5px;"></i>Novo Paciente</button>
                            
                        </div>
                        <div class="filter-group">
                            <label for="searchChildName">Buscar por Código:</label>
                            <input style="width: 150px" type="text" id="searchChildName" name="searchChildName" placeholder="Ex: PCA001" aria-label="Nome da Criança">
                        </div>
                        <div class="filter-group">
                            <label for="searchChildName">Buscar por Nome (Paciente):</label>
                            <input style="width: 300px" type="text" id="searchChildName" name="searchChildName" placeholder="Digite o nome da criança..." aria-label="Nome da Criança">
                        </div>
                    </div>

                    <!-- Modal para Adicionar Criança -->
                    <div id="addChildModal" class="modal">
                        <div class="modal-content">
                            <header class="modal-header">
                                <h2 class="modal-title">
                                    <span style="color: #fff; margin: 0px">Cadastrar Novo Paciente</span>
                                </h2>
                            </header>
                            <span class="close-button">&times;</span>
                            <form id="addChildForm">
                                <!-- Seção de Informações Pessoais -->
                                <section>
                                    <div style="display: flex; gap: 15px; margin-bottom: 10px;">
                                        <div style="flex: 2;">
                                            <label for="addChildName" style="font-size: 14px; font-weight: normal; color: #333;">Nome Completo:</label>
                                            <input type="text" id="addChildName" name="addChildName" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" value="Rafael Santos" placeholder="Digite o nome completo">
                                        </div>
                                        <div style="flex: 1;">
                                            <label for="addBirthDate" style="font-size: 14px; font-weight: normal; color: #333;">DT/Nascimento:</label>
                                            <input type="date" id="addBirthDate" name="addBirthDate" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" value="2022-05-09" placeholder="Escolha a data de nascimento">
                                        </div>
                                        <div style="flex: 1;">
                                            <label for="addChildSex" style="font-size: 14px; font-weight: normal; color: #333;">Sexo:</label>
                                            <select id="addChildSex" name="addChildSex" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" onchange="toggleSexOtherField()">
                                                <option value="">Selecione</option>
                                                <option value="Masculino" Selected>Masculino</option>
                                                <option value="Feminino">Feminino</option>
                                            </select>
                                        </div>
                                    </div>
                                </section>
                                
                                <!-- Seção de Informações do Responsável -->
                                <section style="margin-bottom: 20px;">
                                    <div style="display: flex; gap: 15px; margin-top: -10px;">
                                        <div style="flex: 2;">
                                            <label for="addGuardianName" style="font-size: 14px; font-weight: normal; color: #333;">Nome do Responsável:</label>
                                            <input type="text" id="addGuardianName" name="addGuardianName" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" value="Fernanda Silva" placeholder="Digite o nome do responsável">
                                        </div>
                                        <div style="flex: 1;">
                                            <label for="addGuardianRelation" style="font-size: 14px; font-weight: normal; color: #333;">Vínculo:</label>
                                            <select id="addGuardianRelation" name="addGuardianRelation" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" onchange="toggleRelationField()">
                                                <option value="">Selecione</option>
                                                <option value="Pai">Pai</option>
                                                <option value="Mãe" Selected>Mãe</option>
                                                <option value="Outro">Outro</option>
                                            </select>
                                        </div>
                                        <div id="addRelationOtherField" style="display: none;">
                                            <div style="flex: 1;">
                                                <label for="addGuardianOther" style="font-size: 14px; font-weight: normal; color: #333;">Especifique o Vínculo:</label>
                                                <input type="text" id="addGuardianOther" name="addGuardianOther" placeholder="Informe o vínculo" style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                                            </div>
                                        </div>
                                    </div>
                                </section>
                                
                                <!-- Ações de Formulário -->
                                <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                                    <button type="button" style="background-color: #edf2f7; color: #2d3748; border: none; padding: 8px 16px; border-radius: 8px; cursor: pointer;" id="cancelAddChild">Cancelar</button>
                                    <button type="submit" style="background-color: #08C89E; color: #fff; border: none; padding: 8px 16px; border-radius: 8px; cursor: pointer;">Adicionar Criança</button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Modal para Editar Criança -->
                    <div id="editChildModal" class="modal">
                        <div class="modal-content">
                            <span class="close-button">&times;</span>
                    
                            <!-- Cabeçalho do Modal -->
                            <header class="modal-header">
                                <h2 class="modal-title"><span style="color: #fff"> Editar Criança: </span><span id="editChildId" class="child-id">#ABC12345</span></h2>
                            </header>

                            <form id="editChildForm">
                                <!-- Seção de Informações Pessoais -->
                                <section style="margin-bottom: 20px; margin-top: -20px;">
                                    <div style="display: flex; gap: 15px; margin-bottom: -10px;">
                                        <div style="flex: 2;">
                                            <label for="editChildName" style="font-size: 14px; font-weight: normal; color: #333;">Nome Completo:</label>
                                            <input type="text" id="editChildName" name="editChildName" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" value="Maria Fernanda" placeholder="Digite o nome completo">
                                        </div>
                                        <div style="flex: 1;">
                                            <label for="editBirthDate" style="font-size: 14px; font-weight: normal; color: #333;">Data de Nascimento:</label>
                                            <input type="date" id="editBirthDate" name="editBirthDate" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" value="2022-10-01" placeholder="Escolha a data de nascimento">
                                        </div>
                                        <div style="flex: 1;">
                                            <label for="editChildSex" style="font-size: 14px; font-weight: normal; color: #333;">Sexo:</label>
                                            <select id="editChildSex" name="editChildSex" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" onchange="toggleSexOtherField()">
                                                <option value="">Selecione</option>
                                                <option value="Masculino" selected>Masculino</option>
                                                <option value="Feminino">Feminino</option>
                                            </select>
                                        </div>
                                    </div>
                                </section>
                        
                                <!-- Seção de Informações do Responsável -->
                                <section style="margin-top: -30px;">
                                    <div style="display: flex; gap: 15px; margin-bottom: 0px;">
                                        <div style="flex: 2;">
                                            <label for="editGuardianName" style="font-size: 14px; font-weight: normal; color: #333;">Nome do Responsável:</label>
                                            <input type="text" id="editGuardianName" name="editGuardianName" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" value="Carlos Eduardo" placeholder="Digite o nome do responsável">
                                        </div>
                                        <div style="flex: 1;">
                                            <label for="editGuardianRelation" style="font-size: 14px; font-weight: normal; color: #333;">Vínculo:</label>
                                            <select id="editGuardianRelation" name="editGuardianRelation" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;" onchange="toggleRelationOtherField()">
                                                <option value="Pai">Pai</option>
                                                <option value="Mãe">Mãe</option>
                                                <option value="Outro">Outro</option>
                                            </select>
                                        </div>
                                        <div id="relationOtherField" style="display: none;">
                                            <div style="flex: 1;">
                                                <label for="editGuardianOther" style="font-size: 14px; font-weight: normal; color: #333;">Especifique o vínculo:</label>
                                                <input type="text" id="editGuardianOther" name="editGuardianOther" placeholder="Informe o vínculo" style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                                            </div>
                                        </div>
                                    </div>
                                </section>
                        
                                <!-- Seção de Profissionais Atribuídos -->
                                <section style="margin-bottom: 10px;">
                                    <div style="margin-bottom: 20px; margin-top: 0px; background-color: #f9f9f9; padding: 8px 16px; border-radius: 8px; border: 1px solid #ccc;">
                                        <h3 style="margin-bottom: 0px; margin-top: -5px; text-align: center">Profissionais Com Acesso ao Paciente</h3>
                                        <div style="display: flex; gap: 15px; margin-bottom: 10px;">
                                            <div style="flex: 2;">
                                                <label for="editAssignedProfessional" style="font-size: 14px; font-weight: normal; color: #333;">Adicionar Profissional (Colaborador):</label>
                                                <select id="editAssignedProfessional" name="editAssignedProfessional" required style="width: 100%; padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                                                    <option value="" disabled>Selecione um profissional</option>
                                                    <option value="Coralina Matos" selected>Coralina Matos</option>
                                                </select>
                                            </div>
                                            <div style="flex: 1;">
                                                <label for="editSpecialty" style="font-size: 14px; font-weight: normal; color: #333;">Especialidade:</label>
                                                <p id="editSpecialty" style="background-color: #f7fafc; border: 1px solid #e2e8f0; border-radius: 6px; font-size: 14px; min-height: 38px; display: flex; justify-content: center; align-items: center; margin-top: 0px;">Terapeuta Ocupacional</p>
                                            </div>
                                        </div>
                                        
                                        <button type="button" id="addProfessionalBtn" style="background-color: #08C89E; color: #fff; border: none; padding: 8px 12px; border-radius: 8px; cursor: pointer; font-size: 14px; display: flex; align-items: center; gap: 5px; margin-bottom: 10px; margin-top: -10px;">
                                            <i class="fas fa-plus"></i> Adicionar Profissional
                                        </button>
                        
                                        <!-- Tabela de Profissionais Atribuídos -->
                                        <table id="assignedProfessionalsTable" style="width: 100%; border-collapse: collapse; margin-bottom: 10px;" class="table-section">
                                            <thead>
                                                <tr>
                                                    <th style="padding: 8px; text-align: left; background-color: #f7fafc; border-bottom: 1px solid #e2e8f0;">ORD</th>
                                                    <th style="padding: 8px; text-align: left; background-color: #f7fafc; border-bottom: 1px solid #e2e8f0;">Código</th>
                                                    <th style="padding: 8px; text-align: left; background-color: #f7fafc; border-bottom: 1px solid #e2e8f0;">Nome do Profissional</th>
                                                    <th style="padding: 8px; text-align: left; background-color: #f7fafc; border-bottom: 1px solid #e2e8f0;">Especialidade</th>
                                                    <th style="padding: 8px; text-align: left; background-color: #f7fafc; border-bottom: 1px solid #e2e8f0;">Perfil</th>
                                                    <th style="padding: 8px; text-align: left; background-color: #f7fafc; border-bottom: 1px solid #e2e8f0;">Ação</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>1</td>
                                                    <td>PRA005</td>
                                                    <td>Coralina Matos</td>
                                                    <td>Terapeuta Ocupacional</td>
                                                    <td>Admin</td>
                                                    <td>--</td>
                                                </tr>
                                                <tr>
                                                    <td>2</td>
                                                    <td>PRA008</td>
                                                    <td>Pedro Oliveira</td>
                                                    <td>Psicólogo</td>
                                                    <td>Supervisor</td>
                                                    <td>--</td>
                                                </tr>
                                                <tr>
                                                    <td>3</td>
                                                    <td>PRA010</td>
                                                    <td>Fisioterapeuta</td>
                                                    <td>Fisioterapeuta</td>
                                                    <td>Colaborador</td>
                                                    <td><i class="fas fa-trash-alt"></i></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </section>
                                
                                <!-- Seção de Ações -->
                                <footer class="form-actions" style="margin-top: 20px">
                                    <button type="button" class="btn cancel" id="cancelEditChild">Cancelar</button>
                                    <button type="button" class="btn delete" id="deleteChildBtn">Excluir</button>
                                    <button type="submit" class="btn save">Salvar Alterações</button>
                                </footer>
                            </form>
                        </div>
                    </div>

                    <table id="childrenTable" class="table-section">
                        <thead>
                            <tr>
                                <th>ORD</th>
                                <th>Código</th>
                                <th>Nome do Paciente</th>
                                <th>Sexo</th>
                                <th>DT/Nascimento</th>
                                <th>Nome do Responsável</th>
                                <th>#</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Registro existente ajustado para nova coluna -->
                            <tr>
                                <td>1</td>
                                <td>ABC12345</td>
                                <td>Luís Gustavo</td>
                                <td>Masculino</td>
                                <td>20/02/2018</td>
                                <td>Ana Paula</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar" onclick="mostrareditChildModal()"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <!-- 7 novos registros de exemplo -->
                            <tr>
                                <td>2</td>
                                <td>ABC12346</td>
                                <td>Maria Fernanda</td>
                                <td>Feminino</td>
                                <td>20/02/2018</td>
                                <td>Carlos Eduardo</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>ABC12347</td>
                                <td>João Pedro</td>
                                <td>Masculino</td>
                                <td>20/02/2018</td>
                                <td>Fernanda Silva</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>ABC12348</td>
                                <td>Beatriz Lima</td>
                                <td>Feminino</td>
                                <td>20/02/2018</td>
                                <td>Ricardo Lima</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>5</td>
                                <td>ABC12349</td>
                                <td>Rafael Santos</td>
                                <td>Masculino</td>
                                <td>20/02/2018</td>
                                <td>Patrícia Santos</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>6</td>
                                <td>ABC12350</td>
                                <td>Isabela Costa</td>
                                <td>Feminino</td>
                                <td>20/02/2018</td>
                                <td>Gustavo Costa</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>7</td>
                                <td>ABC12351</td>
                                <td>Felipe Oliveira</td>
                                <td>Masculino</td>
                                <td>20/02/2018</td>
                                <td>Juliana Oliveira</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>8</td>
                                <td>ABC12352</td>
                                <td>Larissa Gomes</td>
                                <td>Feminino</td>
                                <td>20/02/2018</td>
                                <td>Thiago Gomes</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>9</td>
                                <td>ABC12346</td>
                                <td>Maria Fernanda</td>
                                <td>Feminino</td>
                                <td>20/02/2018</td>
                                <td>Carlos Eduardo</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>10</td>
                                <td>ABC12347</td>
                                <td>João Pedro</td>
                                <td>Masculino</td>
                                <td>20/02/2018</td>
                                <td>Fernanda Silva</td>
                                <td>
                                    <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i></a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    
                    <!-- Paginação para Pacientes -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <span class="record-count">Total de registros: 25</span>
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
                </div>

                <!-- Faturamento -->
                <div id="faturamento" class="tab-content">
                    <p style="margin-top: -20px">Contrate e gerencie o plano de assinatura da sua clínica.</p>

                    <!-- Resumo do Plano Atual -->
                    <div class="billing-summary">
                        <h3 style="font-size: 18px; color: #08C89E; margin-bottom: 5px;">Plano Atual: <span style="color: #F6AD55;">Plano Basico (Fixo + Excedente)</span></h3>
                        <p><b>Valor Base Mensal:</b> R$ 200,00</p>
                        <p><b>Crianças Incluídas no Plano:</b> 50</p>
                        <p><b>Crianças Cadastradas Atualmente:</b> 162</p>
                        <!-- Cálculo de excedentes -->
                        <p><b>Crianças Excedentes:</b> 112 (162 - 50)</p>
                        <p><b>Custo por Criança Excedente:</b> R$ 5,00</p>
                        
                        <button class="btn contact-sales" style="margin-top: 10px; margin-bottom: -20px; background-color: #F6AD55; color: #fff; border: none; padding: 5px 10px; border-radius: 8px; cursor: pointer; font-size: 14px;" onclick="mostrarConteudo()">
                                <i class="fas fa-calculator"></i> Calcular Nova Fatura</button>

                        
                        <!-- Conteúdo a ser exibido quando o botão for clicado -->
                        <div id="calculo-container">
                            <hr style="margin: 15px 0;">
                            <p><b>Total Excedente:</b> 112 x R$ 5,00 = R$ 560,00</p>
                            <p><b>Total Mensal (Base + Excedente):</b> R$ 200,00 + R$ 560,00 = <span style="font-weight: 600; color: #2d3748;">R$ 760,00</span></p>
                            <button class="btn contact-sales" style="margin-top: 10px; margin-bottom: -20px; background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 8px; cursor: pointer; font-size: 14px;">
                                <i class="fas fa-arrow-rotate-right"></i> Gerar Nova Fatura</button>
<button class="btn contact-sales" style="margin-top: 10px; margin-bottom: -20px; background-color: #E2E4E5; color: #000; border: none; padding: 5px 10px; border-radius: 8px; cursor: pointer; font-size: 14px;" onclick="cancelarConteudo()">Cancelar</button>

                        </div>
                        <!-- Excedente acima de 100 -->
                        <!-- <div style="margin-top: 10px; margin-bottom: 20px;">
                            <p style="color: #e53e3e; font-weight: 600;">
                                Você excedeu o limite de 100 crianças. Entre em contato com nossa equipe de vendas para um plano personalizado.
                            </p>
                            <button class="btn contact-sales" style="margin-top: 20px; margin-bottom: -20px; background-color: #F6AD55; color: #fff; border: none; padding: 10px 15px; border-radius: 8px; cursor: pointer; font-size: 14px;">
                                <i class="fas fa-phone"></i> Falar com Vendas
                            </button>
                        </div> -->
                    </div>

                    <!-- Fatura Atual - Resumo -->
                    <!-- Supondo que a fatura atual #011 seja referente a Dezembro/2023,
                         gerada em 21/11/2023, vence em 01/12/2023 e ainda está em aberto.
                         Supondo que hoje seja 25/11/2023, restam 6 dias até o vencimento. -->
                    <!-- <div class="active-invoice">
                        <h3 style="font-size: 18px; color: #08C89E">Fatura Atual: <span style="font-weight: 600; color: #F6AD55;">#011 (Dias restantes: 6)</span></h3>

                        <div style="display: flex; justify-content: space-between; flex-wrap: wrap; font-size: 14px">

                            <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                                <p><strong>Plano:</strong></p>
                                <p>Plano Basico</p>
                            </div>

                            <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                                <p><strong>Data de Geração:</strong></p>
                                <p>21/11/2023</p>
                            </div>

                            <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                                <p><strong>Data do Pagamento:</strong></p>
                                <p>28/11/2023</p>
                            </div>

                            <div style="flex: 1; min-width: 150px; margin-right: 10px;">
                                <p><strong>Data de Vencimento:</strong></p>
                                <p>01/12/2023</p>
                            </div>

                            <div style="flex: 1; min-width: 150px;">
                                <p><strong>Dias Restantes:</strong></p>
                                <p>6 dias</p>

                            </div>
                        </div>
                    </div> -->

                    <!-- Histórico de Pagamentos -->
                    <h3 style="font-size: 18px; margin-bottom: 10px; color: #08C89E;">Histórico de Pagamentos</h3>
                    <table id="billingHistoryTable" class="table-section" style="width: 100%; border-collapse: collapse; font-size: 14px;">
                        <thead>
                            <tr style="background-color: #f7fafc; color: #2d3748;">
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">ORD</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Fatura</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Data</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Plano</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Total</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Validade</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Status</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Ações</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Acesso</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Fatura atual (Em Aberto) gera um botão "Pagar Agora" -->
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">1</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">FTA011</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Enterprise Gold</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 760,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">05/10/2023</td>
                                
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #d69e2e; font-weight: 600;">Em Aberto</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <button class="btn pay-now" style="background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;"> <i class="fas fa-credit-card"></i> Pagar Agora</button>
                                </td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">---</td>
                            </tr>

                            <!-- Faturas anteriores pagas (data de pagamento poderia ser exibida se desejado) -->
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">2</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">FTA010</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Enterprise Platinum</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 760,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">05/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: red; font-weight: 600;">Vencido</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="background-color: #F6AD55; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;"><i class="fas fa-sync"></i> Atualizar</a>
                                </td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">---</td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">3</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">FTA009</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Plano Basico</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 350,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Ver Recibo
                                    </a>
                                </td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">6 dias</td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">4</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">FTA009</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Plano Basico</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 350,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Ver Recibo
                                    </a>
                                </td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">0</td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">5</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">FTA009</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Plano Basico</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 350,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Ver Recibo
                                    </a>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">0</td>

                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">6</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">FTA009</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Plano Basico</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 350,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">01/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Ver Recibo
                                    </a>
                                </td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">0</td>
                            </tr>
                        </tbody>
                    </table>
                    
                    <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
                </div>

                <!-- Conteúdo da aba Tokens -->
                <!-- Tokens (Nova aba) -->
                <div id="tokens" class="tab-content">
                    <p style="margin-top: -20px">Compre tokens para gerar relatórios detalhados usando Inteligência Artificial</p>

                    <!-- Resumo de Tokens -->
                    <div class="tokens-summary" style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 10px; padding: 20px; margin-top: 0px;">
                        <h3 style="margin-top: -15px">Seu Saldo de Tokens</h3>
                        <p style="margin-top: -20px; margin-bottom: -20px"><b>Tokens Disponíveis:</b> 120</p>
                        <p><small>O consumo de tokens varia conforme a complexidade do relatório gerado.</small></p>

                        <div style="margin-top: 20px; display: flex; gap: 10px;">
                            <button id="buyTokensBtn" class="btn" style="background-color: #08C89E; color: #fff; border: none; padding: 10px 15px; border-radius: 8px; cursor: pointer; font-size: 14px;" onclick="mostrarbuyTokensModals()"><i class="fas fa-cart-plus"></i> Adquirir Tokens</button>
                        </div>
                    </div>

                    <!-- Histórico de Compras de Tokens -->
                    <h3 style="font-size: 18px; margin-bottom: 10px; color: #08C89E;">Histórico de Compras de Tokens</h3>
                    <table id="tokenPurchaseHistory" class="table-section" style="width: 100%; border-collapse: collapse; font-size: 14px;">
                        <thead>
                            <tr style="background-color: #f7fafc; color: #2d3748;">
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">ORD</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Fatura</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Data</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Quantidade</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Valor</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Status</th>
                                <th style="padding: 10px; border-bottom: 1px solid #e2e8f0;">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">1</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#1004</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">05/12/2024</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">100 Tokens</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 50.00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #d69e2e; font-weight: 600;">Em Aberto</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <button class="btn pay-now" style="background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;">
                                <i class="fas fa-credit-card"></i> Pagar Agora
                            </button>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">2</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#1003</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">25/11/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">100 Tokens</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 50,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Visualizar Recibo</a>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">3</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#1002</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">10/10/2023</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">50 Tokens</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">R$ 30,00</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #48bb78; font-weight: 600;">Pago</td>
                                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                                    <a href="#" class="view-button" style="color: #08C89E; text-decoration: underline;">
                                        <i class="fas fa-eye"></i> Visualizar Recibo
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <!-- Informações da Clínica (Nova Aba) -->
                <div id="informacoes" class="tab-content">
                    <div class="header-content">
                        <p style="margin-top: -10px; color: #4a5568; font-size: 14px;">Confira as informações da clínica abaixo. Para editar, clique no botão.</p>
                    </div>
                    <hr />
                <!-- Cartão com Informações Compactadas -->
                <div class="clinic-info-card" 
                     style="border-radius: 8px;padding: 20px;margin-bottom: 20px;>
                
                    <!-- Título Principal da Clínica -->
                    <h2 style="margin-top: 0; font-size: 20px; color: #08C89E; margin-bottom: 10px;">Clínica Sertãozinho</h2>
                
                    <!-- Lista de Informações -->
                    <div class="clinic-info-list" style="font-size: 14px; color: #2d3748; line-height: 1.6;">
                        
                        <!-- Exemplo de Exibição do "Tipo" de Cadastro -->
                        <p style="margin: 4px 0;"><strong>Tipo:</strong>PJ</p>
                
                        <!-- Se for PJ, exibir Razão Social / Nome Fantasia / CNPJ -->
                        <!-- Se for PF, exibir Nome Completo / CPF -->
                
                        <!-- Razão Social (PJ) -->
                        <p style="margin: 4px 0;">
                            <strong>Razão Social:</strong> Clínica Sertãozinho Ltda.
                        </p>
                
                        <!-- Nome Fantasia (PJ) ou Nome Completo (PF) -->
                        <p style="margin: 4px 0;">
                            <strong>Nome Fantasia:</strong> Clínica Sertãozinho
                        </p>
                
                        <!-- CPF ou CNPJ -->
                        <p style="margin: 4px 0;">
                            <strong>CNPJ:</strong> 12.345.678/0001-99
                            <!-- Se PF, substituir por:
                                 <strong>CPF:</strong> 123.456.789-00
                            -->
                        </p>
                
                        <!-- Endereço -->
                        <p style="margin: 4px 0;">
                            <strong>Endereço:</strong> Rua das Flores, 123 - Centro, 
                            CEP 14.100-000, Sertãozinho - SP
                        </p>
                
                        <!-- Telefone -->
                        <p style="margin: 4px 0;">
                            <strong>Telefone:</strong> (16) 3262-0000
                        </p>
                
                        <!-- E-mail Financeiro -->
                        <p style="margin: 4px 0;">
                            <strong>E-mail Financeiro:</strong> financeiro@clinicasertaozinho.com
                        </p>
                
                        <!-- Botão de Edição -->
                        <a href="#" 
                           class="clinic-edit-button" 
                           onclick="mostrarcliniceditmodal()" 
                           style="display: inline-block; 
                                  margin-top: 10px; 
                                  background-color: #F6AD55; 
                                  color: #ffffff; 
                                  padding: 8px 16px; 
                                  border-radius: 6px; 
                                  font-size: 14px; 
                                  text-decoration: none; 
                                  cursor: pointer;">
                            <i class="fas fa-edit" style="margin-right: 8px;"></i> 
                            Editar
                        </a>
                    </div>
                </div>

            </div>
        </section>
    </main>

    <!-- Modal para Edição das Informações da Clínica -->

    <div id="cliniceditmodal" class="modal" style="display: none; 
        position: fixed; 
        top: 0; 
        left: 0; 
        width: 100%; 
        height: 100%; 
        background-color: rgba(0,0,0,0.5); 
        justify-content: center; 
        align-items: center; 
        z-index: 9999;">
        
        <div class="modal-content" style="
            background-color: #ffffff; 
            border-radius: 12px; 
            width: 90%; 
            max-width: 800px; 
            padding: 20px; 
            position: relative; 
            box-sizing: border-box; 
            max-height: 90vh; 
            overflow-y: auto; 
            font-family: 'Poppins', sans-serif;">
            
            <!-- Botão para Fechar o Modal -->
            <span id="closeCreateModalBtn" class="close-modal" style="
                position: absolute; 
                top: 16px; 
                right: 16px; 
                font-size: 24px; 
                font-weight: bold; 
                color: #4a5568; 
                cursor: pointer;">
                &times;
            </span>
            
            <!-- Cabeçalho do Modal -->
            <div class="modal-header" style="text-align: center; margin-bottom: 20px;">
                            <h2 style="color: #fff; background-color: #08C89E; padding: 10px 0; border-radius: 8px; margin: 0;">Editar Dados da Clínica <span style="color: #F6AD55">#PRA008</span></h2>

            </div>
            
            <!-- Corpo do Modal -->
            <div class="modal-body" style="padding: 0 10px;">
                <!-- Orientação ao Usuário -->
                <p style="font-size: 14px; color: #4a5568; margin-bottom: 0px; margin-top: -20px">
                    Preencha as informações para cadastrar uma nova clínica no sistema. 
                    Se o responsável for <b>Pessoa Física</b>, utilize <i>Nome Completo</i> e <i>CPF</i>; 
                    caso seja <b>Pessoa Jurídica</b>, utilize <i>Razão Social</i> e <i>CNPJ</i>.
                </p>
    
                <!-- Formulário no Modal -->
                <form class="clinic-modal-form" id="createClinicForm" style="display: flex; flex-direction: column; gap: 20px;">
                    
                    <!-- Seção 1: Seleção de Tipo (PF ou PJ) -->
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <div style="flex: 1; min-width: 200px;">
                            <label for="clinicType" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 5px;">
                                Tipo de Responsável
                            </label>
                            <select id="clinicType" name="clinicType" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748;">
                                <option value="" disabled selected>Selecione</option>
                                <option value="pf" Selected>Pessoa Física</option>
                                <option value="pj">Pessoa Jurídica</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Seção 2: Dados de Identificação -->
                    <div class="identification-section" style="display: flex; flex-direction: column; gap: 10px;">
                        
                        <!-- Pessoa Física -->
                        <div id="pf-fields" style="display: flex; gap: 10px;">
                            <!-- Linha 1: Nome Completo -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 480px;">
                                    <label for="pfName" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        Nome Completo
                                    </label>
                                    <input type="text" id="pfName" name="pfName" placeholder="Ex: João da Silva" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;" value="João da Silva">
                                </div>
                            </div>
                            
                            <!-- Linha 2: CPF -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 250px;">
                                    <label for="pfCPF" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        CPF
                                    </label>
                                    <input type="text" id="pfCPF" name="pfCPF" placeholder="000.000.000-00" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;" value="000.111.222-33">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Pessoa Jurídica -->
                        <div id="pj-fields" style="display: none; gap: 10px;">
                            <!-- Linha 1: Razão Social -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 480px;">
                                    <label for="pjRazaoSocial" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        Razão Social
                                    </label>
                                    <input type="text" id="pjRazaoSocial" name="pjRazaoSocial" placeholder="Ex: Clínica Exemplo LTDA" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;">
                                </div>
                            </div>
                            
                            <!-- Linha 2: CNPJ -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 250px;">
                                    <label for="pjCNPJ" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        CNPJ
                                    </label>
                                    <input type="text" id="pjCNPJ" name="pjCNPJ" placeholder="00.000.000/0001-00" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Seção 3: Contato e E-mail Financeiro -->
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <!-- Telefone -->
                        <div style="flex: 1; min-width: 200px;">
                            <label for="clinicPhone" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                Telefone / Celular
                            </label>
                            <input type="tel" id="clinicPhone" name="clinicPhone" placeholder="(99) 99999-9999" 
                                   style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                          border-radius: 8px; font-size: 14px; color: #2d3748; 
                                          box-sizing: border-box;" value="(74) 99123-1234">
                        </div>
                        <!-- E-mail Financeiro -->
                        <div style="flex: 1; min-width: 280px;">
                            <label for="clinicFinanceEmail" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                E-mail Financeiro
                            </label>
                            <input type="email" id="clinicFinanceEmail" name="clinicFinanceEmail" 
                                   placeholder="financeiro@exemplo.com" required 
                                   style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                          border-radius: 8px; font-size: 14px; color: #2d3748; 
                                          box-sizing: border-box;" value="financeiro@clinicasertaozinho.com">
                        </div>
                    </div>
                    
                    <!-- Seção 4: Endereço -->
                    <div style="display: flex; flex-direction: column; gap: 10px; margin-top: -20px">
                        <h3 style="
                            font-size: 16px; 
                            color: #2d3748; 
                            border-bottom: 1px solid #e2e8f0; 
                            padding-bottom: 5px; 
                            margin: 0;">
                            Endereço
                        </h3>
                        
                        <!-- Linha 1: Logradouro, Número e Complemento -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap; margin-top: -10px">
                            <div style="flex: 2; min-width: 200px;">
                                <label for="clinicStreet" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px;">
                                    Logradouro
                                </label>
                                <input type="text" id="clinicStreet" name="clinicStreet" placeholder="Rua / Avenida" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;" value="Rua Canafístula">
                            </div>
                            <div style="flex: 1; min-width: 100px;">
                                <label for="clinicNumber" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px;">
                                    Número
                                </label>
                                <input type="text" id="clinicNumber" name="clinicNumber" placeholder="123" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;" value="187">
                            </div>
                            <div style="flex: 1; min-width: 150px;">
                                <label for="clinicComplement" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px;">
                                    Complemento
                                </label>
                                <input type="text" id="clinicComplement" name="clinicComplement" placeholder="Apto, Sala..." 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;" value="Casa">
                            </div>
                        </div>
                        
                        <!-- Linha 2: Bairro, Cidade, Estado e CEP -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <div style="flex: 1; min-width: 180px;">
                                <label for="clinicNeighborhood" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    Bairro
                                </label>
                                <input type="text" id="clinicNeighborhood" name="clinicNeighborhood" placeholder="Centro" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;" value="Centenário">
                            </div>
                            <div style="flex: 1; min-width: 180px;">
                                <label for="clinicCity" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    Cidade
                                </label>
                                <input type="text" id="clinicCity" name="clinicCity" placeholder="Sertãozinho" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;" value="Juazeiro">
                            </div>
                            <div style="flex: 1; min-width: 80px;">
                                <label for="clinicState" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    Estado
                                </label>
                                <select id="clinicState" name="clinicState" required 
                                        style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                               border-radius: 8px; font-size: 14px; color: #2d3748; 
                                               box-sizing: border-box;">
                                    <option value="" disabled selected>UF</option>
                                    <option value="SP">SP</option>
                                    <option value="RJ">RJ</option>
                                    <option value="MG">MG</option>
                                    <option value="BA" Selected>BA</option>
                                    <option value="RS">RS</option>
                                    <!-- Adicione mais opções de estados conforme necessário -->
                                </select>
                            </div>
                            <div style="flex: 1; min-width: 150px;">
                                <label for="clinicCEP" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    CEP
                                </label>
                                <input type="text" id="clinicCEP" name="clinicCEP" placeholder="12.345-678" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;" value="48905-215">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Botões de Ação -->
                    <div style="display: flex; justify-content: flex-end; gap: 10px;">
                        <button type="button" id="cancelCreateBtn" style="
                            background-color: #e53e3e; 
                            color: #fff; 
                            padding: 10px 20px; 
                            border: none; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            cursor: pointer;">
                            Cancelar
                        </button>
                        <button type="submit" style="
                            background-color: #08C89E; 
                            color: #fff; 
                            padding: 10px 20px; 
                            border: none; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            cursor: pointer;">
                            Salvar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>








    <!-- Modal para Comprar Tokens -->
    <div id="buyTokensModals" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <h2>Comprar Tokens</h2>
            <p>Escolha um pacote de tokens:</p>
            <div style="display: flex; gap: 20px; flex-wrap: wrap; margin-top: 15px;">
                <div style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 8px; padding: 15px; text-align: center; flex: 1; min-width: 150px;">
                    <h3 style="font-size:16px; margin-bottom:10px;">50 Tokens</h3>
                    <p style="margin-bottom:10px;">R$ 30,00</p>
                    <button class="buy-token-package" data-tokens="50" data-price="30.00" style="background-color: #08C89E; color: #fff; border: none; border-radius: 6px; padding: 8px 12px; cursor:pointer;">Comprar</button>
                </div>
                <div style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 8px; padding: 15px; text-align: center; flex: 1; min-width: 150px;">
                    <h3 style="font-size:16px; margin-bottom:10px;">100 Tokens</h3>
                    <p style="margin-bottom:10px;">R$ 50,00</p>
                    <button class="buy-token-package" data-tokens="100" data-price="50.00" style="background-color: #08C89E; color: #fff; border: none; border-radius: 6px; padding: 8px 12px; cursor:pointer;">Comprar</button>
                </div>
                <div style="background-color: #fff; border: 1px solid #e2e8f0; border-radius: 8px; padding: 15px; text-align: center; flex: 1; min-width: 150px;">
                    <h3 style="font-size:16px; margin-bottom:10px;">200 Tokens</h3>
                    <p style="margin-bottom:10px;">R$ 90,00</p>
                    <button class="buy-token-package" data-tokens="200" data-price="90.00" style="background-color: #08C89E; color: #fff; border: none; border-radius: 6px; padding: 8px 12px; cursor:pointer;">Comprar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Resultado -->
    <div id="result-modal" class="modal">
        <div class="modal-content">
            <span class="close-button">&times;</span>
            <p>Resultado do M-CHAT: Pontuação de Risco: 3. ...</p>
            <button class="btn save" id="copy-button">Copiar Texto</button>
        </div>
    </div>

    <!-- Script Consolidado -->
    <!-- Script Consolidado -->
    <script>
    document.addEventListener('DOMContentLoaded', () => {
        /* Variáveis Globais */
        const professionalsData = {
            "Mariana Santos": "Fonoaudióloga",
            "Pedro Oliveira": "Psicólogo",
            "Ana Luiza": "Nutricionista",
            "Lucas Almeida": "Fisioterapeuta",
            "Beatriz Souza": "Terapeuta Ocupacional",
            "Felipe Costa": "Psicopedagogo",
            "Juliana Lima": "Enfermeira",
            "Ricardo Pinto": "Nutricionista",
            "Camila Rocha": "Fonoaudióloga",
            "Thiago Martins": "Psicólogo",
            "Patrícia Fernandes": "Fisioterapeuta",
            "Gustavo Ribeiro": "Terapeuta Ocupacional"
        };

        /* Dados de Crianças Atribuídas a Cada Profissional (Modelo) */
        const assignedChildrenData = {
            "PRF001": [ // Mariana Santos
                {
                    childId: "#CH001",
                    childName: "Ana Clara",
                    guardian: "João Silva",
                    age: "5 anos"
                },
                {
                    childId: "#CH002",
                    childName: "Bruno Costa",
                    guardian: "Maria Oliveira",
                    age: "6 anos"
                },
                {
                    childId: "#CH003",
                    childName: "Carla Souza",
                    guardian: "Pedro Souza",
                    age: "4 anos"
                }
            ],
            "PRF002": [ // Pedro Oliveira
                {
                    childId: "#CH004",
                    childName: "Daniel Lima",
                    guardian: "Fernanda Lima",
                    age: "7 anos"
                },
                {
                    childId: "#CH005",
                    childName: "Eduarda Gomes",
                    guardian: "Ricardo Gomes",
                    age: "5 anos"
                }
            ],
            "PRF003": [ // Ana Luiza
                {
                    childId: "#CH006",
                    childName: "Felipe Martins",
                    guardian: "Luciana Martins",
                    age: "6 anos"
                },
                {
                    childId: "#CH007",
                    childName: "Gabriela Rocha",
                    guardian: "Thiago Rocha",
                    age: "5 anos"
                }
            ],
            // Adicione mais profissionais conforme necessário
            "PRF004": [], // Lucas Almeida - Sem crianças atribuídas
            "PRF005": [], // Beatriz Souza - Sem crianças atribuídas
            "PRF006": [],
            "PRF007": [],
            "PRF008": [],
            "PRF009": [],
            "PRF010": [],
            "PRF011": [],
            "PRF012": []
        };

        let currentEditingRow = null; // Linha atualmente sendo editada
        let profissionaisAtribuidos = []; // Lista de profissionais atribuídos no modal

        /* 1. Função de Navegação por Abas (Tabs) */
        const tabs = document.querySelectorAll('.tab');
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                tabs.forEach(item => item.classList.remove('active'));
                tabContents.forEach(content => content.classList.remove('active'));

                tab.classList.add('active');
                document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
            });
        });

        /* 2. Modais de Edição da Clínica */
        const editClinicBtn = document.getElementById('editClinicBtn');
        const editClinicModal = document.getElementById('editClinicModal');
        const closeModalBtns = document.querySelectorAll('.close-button');

        if (editClinicBtn) {
            editClinicBtn.addEventListener('click', () => {
                editClinicModal.style.display = 'flex';
            });
        }

        closeModalBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                btn.closest('.modal').style.display = 'none';
            });
        });

        window.addEventListener('click', (event) => {
            if (event.target.classList.contains('modal')) {
                event.target.style.display = 'none';
            }
        });

        document.getElementById('clinicForm').addEventListener('submit', function(event) {
            event.preventDefault();
            alert('Informações da clínica atualizadas com sucesso!');
            editClinicModal.style.display = 'none';
        });

        document.getElementById('cancelButton').addEventListener('click', function() {
            if (confirm('Tem certeza de que deseja cancelar as alterações?')) {
                location.reload();
            }
        });

        /* 3. Modais de Escolha de Plano e Compra de Tokens */
        const changePlanBtn = document.getElementById('changePlanBtn');
        const choosePlanModal = document.getElementById('choosePlanModal');
        const selectPlanBtns = document.querySelectorAll('.select-plan-btn');

        if (changePlanBtn) {
            changePlanBtn.addEventListener('click', () => {
                choosePlanModal.style.display = 'flex';
            });
        }

        selectPlanBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                const planCard = btn.closest('.plan-card');
                const planName = planCard.getAttribute('data-plan');
                const planPrice = planCard.getAttribute('data-price');
                const planChildren = planCard.getAttribute('data-children');

                // Simulação sem backend:
                alert(`Plano ${planName} selecionado. Simulando geração de cobrança no Asaas...`);
                document.getElementById('currentPlanName').textContent = planName;
                document.getElementById('allowedChildren').textContent = planChildren;
                document.getElementById('planPrice').textContent = 'R$ ' + planPrice;
                choosePlanModal.style.display = 'none';
            });
        });

        /* Modal Compra de Tokens */
        const buyTokensBtn = document.getElementById('buyTokensBtn');
        const buyTokensModal = document.getElementById('buyTokensModal');
        const buyTokenPackageButtons = document.querySelectorAll('.buy-token-package');
        let nextTokenInvoiceId = 1004; // Próximo ID de fatura de tokens

        if (buyTokensBtn) {
            buyTokensBtn.addEventListener('click', () => {
                buyTokensModal.style.display = 'flex';
            });
        }

        buyTokenPackageButtons.forEach(btn => {
            btn.addEventListener('click', () => {
                const tokens = btn.getAttribute('data-tokens');
                const price = btn.getAttribute('data-price');
                // Simulação de geração de fatura
                const tableBody = document.querySelector('#tokenPurchaseHistory tbody');
                const newRow = tableBody.insertRow(0); // Insere no topo do histórico
                const invoiceId = nextTokenInvoiceId++;
                const dateStr = new Date().toLocaleDateString('pt-BR');
                const tokensAmount = `${tokens} Tokens`;
                const valor = `R$ ${price}`;

                newRow.innerHTML = `
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">#${invoiceId}</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">${dateStr}</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">${tokensAmount}</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">${valor}</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0; color: #d69e2e; font-weight: 600;">Em Aberto</td>
                <td style="padding: 10px; border-bottom: 1px solid #e2e8f0;">
                    <button class="btn pay-now" style="background-color: #08C89E; color: #fff; border: none; padding: 5px 10px; border-radius: 6px; cursor: pointer; font-size: 13px;">
                        <i class="fas fa-credit-card"></i> Pagar Agora
                    </button>
                </td>
            `;

                alert(`Fatura gerada: #${invoiceId} - ${tokens} Tokens, R$ ${price}. Status: Em Aberto.`);
                buyTokensModal.style.display = 'none';
            });
        });

        /* 4. Gerenciamento de Crianças (Adicionar e Editar) */
        const addChildBtn = document.getElementById('addChildBtn');
        const addChildModal = document.getElementById('addChildModal');
        const closeAddChildBtns = addChildModal.querySelectorAll('.close-button');
        const cancelAddChild = document.getElementById('cancelAddChild');
        const addChildForm = document.getElementById('addChildForm');
        const addAssignedProfessionalSelect = document.getElementById('addAssignedProfessional');
        const addSpecialtyField = document.getElementById('addSpecialty');

        /* Abrir Modal Adicionar Criança */
        addChildBtn.addEventListener('click', () => {
            addChildModal.style.display = 'flex';
            preencherDropdownProfissionais('add');
        });

        /* Fechar Modal Adicionar Criança */
        closeAddChildBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                addChildModal.style.display = 'none';
            });
        });

        cancelAddChild.addEventListener('click', () => {
            if (confirm('Tem certeza de que deseja cancelar a adição desta criança?')) {
                addChildModal.style.display = 'none';
                addChildForm.reset();
            }
        });

        window.addEventListener('click', (event) => {
            if (event.target == addChildModal) {
                addChildModal.style.display = 'none';
                addChildForm.reset();
            }
        });

        /* Preencher Dropdown de Profissionais */
        function preencherDropdownProfissionais(tipo) {
            let selectElement;
            if (tipo === 'add') {
                selectElement = addAssignedProfessionalSelect;
            } else if (tipo === 'edit') {
                selectElement = document.getElementById('editAssignedProfessional');
            }

            // Limpa as opções existentes (exceto a primeira)
            while (selectElement.options.length > 1) {
                selectElement.remove(1);
            }

            // Seleciona a tabela de profissionais
            const professionalsTable = document.getElementById('professionalsTable');
            const tbody = professionalsTable.querySelector('tbody');
            const rows = tbody.querySelectorAll('tr');

            rows.forEach(row => {
                const cells = row.querySelectorAll('td');
                const professionalId = cells[0].textContent.trim(); // Código está na primeira coluna (index 0)
                const nomeProfissional = cells[1].textContent.trim(); // Nome está na segunda coluna (index 1)
                // Adiciona a opção ao select
                const option = document.createElement('option');
                option.value = nomeProfissional;
                option.textContent = nomeProfissional;
                option.setAttribute('data-professional-id', professionalId); // Adiciona o ID do profissional
                selectElement.appendChild(option);
            });
        }

        /* Selecionar Especialidade ao Escolher Profissional (Adicionar Criança) */
        addAssignedProfessionalSelect.addEventListener('change', () => {
            const selectedProfessional = addAssignedProfessionalSelect.value;
            const selectedOption = addAssignedProfessionalSelect.options[addAssignedProfessionalSelect.selectedIndex];
            const professionalId = selectedOption.getAttribute('data-professional-id');
            if (selectedProfessional && professionalsData[selectedProfessional]) {
                addSpecialtyField.textContent = professionalsData[selectedProfessional];
            } else {
                addSpecialtyField.textContent = "Selecione um profissional";
            }
        });

        /* Submissão do Formulário Adicionar Criança */
        addChildForm.addEventListener('submit', function(event) {
            event.preventDefault();
            // Coleta os dados do formulário
            const childName = document.getElementById('addChildName').value;
            const birthDate = document.getElementById('addBirthDate').value;
            const guardianName = document.getElementById('addGuardianName').value;
            const guardianRelation = document.getElementById('addGuardianRelation').value;
            const guardianOther = document.getElementById('addGuardianOther') ? document.getElementById('addGuardianOther').value : '';
            const assignedProfessional = addAssignedProfessionalSelect.value; // Pode ser vazio
            const selectedOption = addAssignedProfessionalSelect.options[addAssignedProfessionalSelect.selectedIndex];
            const professionalId = selectedOption.getAttribute('data-professional-id');

            // Determina o perfil com base no profissional (simulação)
            const profile = professionalsData[assignedProfessional] || "Nenhum";

            // Determina o vínculo
            const vinculoTexto = guardianRelation === 'Outro' ? guardianOther : guardianRelation;

            // Simulação de envio de dados
            alert('Criança adicionada com sucesso!');
            addChildModal.style.display = 'none';
            addChildForm.reset();

            // Atualizar a tabela de crianças dinamicamente
            adicionarLinhaNaTabela(childName, birthDate, guardianName, guardianRelation, guardianOther, assignedProfessional, profile);

            // Adicionar a criança à estrutura de dados modelada
            const childId = gerarNovoChildId();
            const age = calcularIdade(birthDate);
            const newChild = {
                childId,
                childName,
                guardian: guardianName,
                age
            };
            if (!assignedChildrenData[professionalId]) {
                assignedChildrenData[professionalId] = [];
            }
            assignedChildrenData[professionalId].push(newChild);
        });

        /* Função para Adicionar Linha na Tabela de Crianças */
        function adicionarLinhaNaTabela(childName, birthDate, guardianName, guardianRelation, guardianOther, assignedProfessional, profile) {
            const tableBody = document.querySelector('#childrenTable tbody');
            const newRow = tableBody.insertRow();

            // Geração de ID único (simulação)
            const lastRow = tableBody.rows[tableBody.rows.length - 1];
            let lastId = lastRow ? lastRow.cells[0].textContent.trim() : '#ABC12352';
            let newIdNum = parseInt(lastId.replace('#ABC', '')) + 1;
            const childId = `#ABC${newIdNum.toString().padStart(5, '0')}`;

            // Calcula a idade
            const age = calcularIdade(birthDate);

            // Determina o texto a ser exibido para o vínculo
            const vinculoTexto = guardianRelation === 'Outro' ? guardianOther : guardianRelation;

            // Determina o perfil a ser exibido
            const perfilTexto = profile;

            // Define as ações (um único botão Gerenciar)
            const actions = `
                <a href="#" class="manage-button" title="Gerenciar"><i class="fas fa-cog"></i> Gerenciar</a>
            `;

            // Insere o conteúdo na nova linha
            newRow.innerHTML = `
                <td>${childId}</td>
                <td>${childName}</td>
                <td>${guardianName}</td>
                <td>${age}</td>
                <td>${assignedProfessional}</td>
                <td>${perfilTexto}</td>
                <td>
                    ${actions}
                </td>
            `;

            // Reatribuir eventos aos novos botões "Gerenciar"
            reatribuirEventosManageButtons();
        }

        /* Função para Calcular Idade */
        function calcularIdade(dataNascimento) {
            const hoje = new Date();
            const nascimento = new Date(dataNascimento);
            let idade = hoje.getFullYear() - nascimento.getFullYear();
            const m = hoje.getMonth() - nascimento.getMonth();
            if (m < 0 || (m === 0 && hoje.getDate() < nascimento.getDate())) {
                idade--;
            }
            return `${idade} anos`;
        }

        /* Função para Gerar Novo ID de Criança */
        function gerarNovoChildId() {
            const tableBody = document.querySelector('#childrenTable tbody');
            const rows = tableBody.querySelectorAll('tr');
            let lastId = "#ABC12352"; // Último ID atual
            if (rows.length > 0) {
                lastId = rows[rows.length - 1].cells[0].textContent.trim();
            }
            let newIdNum = parseInt(lastId.replace('#ABC', '')) + 1;
            return `#ABC${newIdNum.toString().padStart(5, '0')}`;
        }

        /* 5. Gerenciamento de Crianças (Gerenciar) */
        const childrenTable = document.getElementById('childrenTable');
        const editChildModal = document.getElementById('editChildModal');
        const editChildForm = document.getElementById('editChildForm');
        const cancelEditChild = document.getElementById('cancelEditChild');
        const deleteChildBtn = document.getElementById('deleteChildBtn');
        const editSpecialtyField = document.getElementById('editSpecialty');
        const addProfessionalBtn = document.getElementById('addProfessionalBtn');
        const assignedProfessionalsTable = document.getElementById('assignedProfessionalsTable').querySelector('tbody');

        /* Função para Reatribuir Event Listeners aos Botões "Gerenciar" */
        function reatribuirEventosManageButtons() {
            const manageButtons = document.querySelectorAll('.manage-button');
            manageButtons.forEach(button => {
                button.removeEventListener('click', gerenciarCriança);
                button.addEventListener('click', gerenciarCriança);
            });
        }

        /* Inicializar Event Listeners para os Botões "Gerenciar" Existentes */
        reatribuirEventosManageButtons();

        /* Função para Gerenciar a Criança (Abrir Modal de Edição) */
        function gerenciarCriança(event) {
            event.preventDefault();
            const button = event.currentTarget;
            const row = button.closest('tr');

            // Extrair dados da linha
            const childId = row.cells[0].textContent.trim();
            const childName = row.cells[1].textContent.trim();
            const guardianName = row.cells[2].textContent.trim();
            const age = row.cells[3].textContent.trim();
            const assignedProfessional = row.cells[4].textContent.trim();
            const profile = row.cells[5].textContent.trim();

            // Preenche o formulário do modal
            document.getElementById('editChildId').textContent = childId;
            document.getElementById('editChildName').value = childName;
            // Converter idade de volta para data de nascimento (simulação)
            // Aqui assumimos que a data de nascimento não está disponível, então deixamos o campo vazio
            document.getElementById('editBirthDate').value = '';
            document.getElementById('editGuardianName').value = guardianName;
            document.getElementById('editGuardianRelation').value = ''; // Precisa ajustar conforme a lógica
            // Para simplificação, deixaremos o campo de vínculo vazio
            document.getElementById('editGuardianOther').value = '';
            document.getElementById('relationOtherField').style.display = 'none';

            // Carrega o dropdown de profissionais e seleciona o atribuído
            preencherDropdownProfissionais('edit');
            const editAssignedProfessionalSelect = document.getElementById('editAssignedProfessional');
            editAssignedProfessionalSelect.value = assignedProfessional;
            // Atualiza a especialidade
            document.getElementById('editSpecialty').textContent = professionalsData[assignedProfessional] || "Selecione um profissional";

            // Inicializar a lista de profissionais atribuídos
            profissionaisAtribuidos = getProfissionaisAtribuidosByChild(childId);
            preencherTabelaProfissionaisAtribuidos(profissionaisAtribuidos);

            // Armazena a referência da linha atual para exclusão
            currentEditingRow = row;

            // Exibe o modal
            editChildModal.style.display = 'flex';
        }

        /* Função para Obter Profissionais Atribuídos por Child ID */
        function getProfissionaisAtribuidosByChild(childId) {
            // Aqui você pode buscar os profissionais atribuídos à criança a partir da sua estrutura de dados
            // Para simulação, retornaremos uma lista estática com códigos
            return [
                { codigo: "PRF001", nome: "Mariana Santos", especialidade: "Fonoaudióloga" },
                { codigo: "PRF002", nome: "Pedro Oliveira", especialidade: "Psicólogo" },
            ];
        }

        /* Função para preencher a tabela de profissionais atribuídos */
        function preencherTabelaProfissionaisAtribuidos(profissionaisAtribuidosList) {
            assignedProfessionalsTable.innerHTML = ''; // Limpar tabela antes de adicionar

            profissionaisAtribuidosList.forEach(profissional => {
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${profissional.codigo}</td>
                    <td>${profissional.nome}</td>
                    <td>${profissional.especialidade}</td>
                    <td>
                        <button class="btn remove-professional" data-professional-name="${profissional.nome}">
                            <i class="fas fa-trash-alt"></i> 
                        </button>
                    </td>
                `;
                assignedProfessionalsTable.appendChild(tr);
            });

            // Reatribuir eventos de remover
            document.querySelectorAll('.remove-professional').forEach(button => {
                button.removeEventListener('click', removerProfissional);
                button.addEventListener('click', removerProfissional);
            });
        }

        /* Função para adicionar um novo profissional à lista de profissionais atribuídos */
        function adicionarProfissional() {
            const editAssignedProfessionalSelect = document.getElementById('editAssignedProfessional');
            const nomeProfissional = editAssignedProfessionalSelect.value;
            const selectedOption = editAssignedProfessionalSelect.options[editAssignedProfessionalSelect.selectedIndex];
            const professionalCode = selectedOption.getAttribute('data-professional-id') || '---';
            const especialidade = document.getElementById('editSpecialty').textContent;

            if (!nomeProfissional || nomeProfissional === "Selecione um profissional") {
                alert('Por favor, selecione um profissional.');
                return;
            }

            // Verificar se o profissional já está na lista
            const existe = profissionaisAtribuidos.some(prof => prof.nome === nomeProfissional);
            if (existe) {
                alert('Este profissional já está atribuído à criança.');
                return;
            }

            // Adiciona o profissional à lista incluindo o código
            profissionaisAtribuidos.push({ codigo: professionalCode, nome: nomeProfissional, especialidade });

            // Atualiza a tabela
            preencherTabelaProfissionaisAtribuidos(profissionaisAtribuidos);

            // Limpa a seleção
            editAssignedProfessionalSelect.value = '';
            document.getElementById('editSpecialty').textContent = 'Selecione um profissional';
        }

        /* Função para remover um profissional da lista */
        function removerProfissional(event) {
            const nomeProfissional = event.currentTarget.getAttribute('data-professional-name');

            profissionaisAtribuidos = profissionaisAtribuidos.filter(prof => prof.nome !== nomeProfissional);

            // Atualiza a tabela
            preencherTabelaProfissionaisAtribuidos(profissionaisAtribuidos);
        }

        /* Evento para adicionar profissional */
        addProfessionalBtn.addEventListener('click', adicionarProfissional);

        /* Submissão do Formulário Editar Criança */
        editChildForm.addEventListener('submit', (event) => {
            event.preventDefault();
            // Atualizar os dados na tabela
            if (currentEditingRow) {
                const childName = document.getElementById('editChildName').value;
                const birthDate = document.getElementById('editBirthDate').value;
                const guardianName = document.getElementById('editGuardianName').value;
                const guardianRelation = document.getElementById('editGuardianRelation').value;
                const guardianOther = document.getElementById('editGuardianOther').value;
                const assignedProfessional = document.getElementById('editAssignedProfessional').value;
                const specialty = document.getElementById('editSpecialty').textContent;

                // Determina o vínculo
                const vinculo = guardianRelation === 'Outro' ? guardianOther : guardianRelation;

                // Atualiza os campos na tabela
                currentEditingRow.cells[1].textContent = childName;
                currentEditingRow.cells[2].textContent = guardianName;
                currentEditingRow.cells[3].textContent = calcularIdade(birthDate);
                currentEditingRow.cells[4].textContent = assignedProfessional;
                currentEditingRow.cells[5].textContent = specialty;

                // Atualizar os dados na estrutura de dados modelada
                const professionalId = obterProfessionalIdPorNome(assignedProfessional);
                if (professionalId) {
                    const childId = document.getElementById('editChildId').textContent.trim();
                    const childIndex = assignedChildrenData[professionalId].findIndex(child => child.childId === childId);
                    if (childIndex !== -1) {
                        assignedChildrenData[professionalId][childIndex].childName = childName;
                        assignedChildrenData[professionalId][childIndex].guardian = guardianName;
                        assignedChildrenData[professionalId][childIndex].age = calcularIdade(birthDate);
                    }
                }

                // Atualizar a lista de profissionais atribuídos na estrutura de dados
                // (Aqui você pode adicionar lógica para armazenar profissionais atribuídos)

                alert('Informações atualizadas com sucesso!');
                editChildModal.style.display = 'none';
                currentEditingRow = null;
            }
        });

        /* Função para Obter ID do Profissional pelo Nome */
        function obterProfessionalIdPorNome(nome) {
            const professionalsTable = document.getElementById('professionalsTable');
            const tbody = professionalsTable.querySelector('tbody');
            const rows = tbody.querySelectorAll('tr');
            for (let row of rows) {
                const professionalName = row.cells[1].textContent.trim();
                if (professionalName === nome) {
                    return row.cells[0].textContent.trim();
                }
            }
            return null;
        }

        /* Botão de Excluir Criança */
        deleteChildBtn.addEventListener('click', () => {
            if (currentEditingRow) {
                const childId = document.getElementById('editChildId').textContent.trim();
                const assignedProfessional = currentEditingRow.cells[4].textContent.trim();
                const professionalId = obterProfessionalIdPorNome(assignedProfessional);

                if (confirm('Tem certeza que deseja excluir esta criança?')) {
                    // Remover da tabela
                    currentEditingRow.remove();

                    // Remover da estrutura de dados modelada
                    if (professionalId && assignedChildrenData[professionalId]) {
                        assignedChildrenData[professionalId] = assignedChildrenData[professionalId].filter(child => child.childId !== childId);
                    }

                    alert('Criança excluída com sucesso!');
                    editChildModal.style.display = 'none';
                    currentEditingRow = null;
                }
            }
        });

        /* Gerenciamento de Relações do Guardião */
        const addGuardianRelation = document.getElementById('editGuardianRelation');
        const relationOtherField = document.getElementById('relationOtherField');

        if (addGuardianRelation) {
            addGuardianRelation.addEventListener('change', () => {
                if (addGuardianRelation.value === 'Outro') {
                    relationOtherField.classList.remove('hidden');
                } else {
                    relationOtherField.classList.add('hidden');
                    document.getElementById('editGuardianOther').value = ''; // Limpar o campo
                }
            });
        }

        /* 6. Função para Gerenciar Informações dos Profissionais */
        const professionalInfoModal = document.getElementById('professionalInfoModal');
        const closeProfessionalModalBtns = professionalInfoModal.querySelectorAll('.close-modal');

        /* Fechar o Modal de Informações do Profissional */
        closeProfessionalModalBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                professionalInfoModal.style.display = 'none';
                // Limpar a tabela de crianças atribuídas
                document.querySelector('#assignedChildrenTable tbody').innerHTML = '';
            });
        });

        window.addEventListener('click', (event) => {
            if (event.target == professionalInfoModal) {
                professionalInfoModal.style.display = 'none';
                // Limpar a tabela de crianças atribuídas
                document.querySelector('#assignedChildrenTable tbody').innerHTML = '';
            }
        });

        /* Adicionar Event Listener aos Botões "Ver" dos Profissionais */
        const viewProfessionalButtons = document.querySelectorAll('.view-professional');
        viewProfessionalButtons.forEach(button => {
            button.addEventListener('click', (event) => {
                event.preventDefault();
                const professionalId = button.getAttribute('data-professional-id');
                const row = button.closest('tr');

                // Extrair dados do profissional
                const code = row.cells[0].textContent.trim();
                const name = row.cells[1].textContent.trim();
                const formation = row.cells[2].textContent.trim();
                const email = row.cells[3].textContent.trim();
                const profile = row.cells[4].textContent.trim();
                const patients = row.cells[5].textContent.trim();

                // Preencher o modal com as informações do profissional
                document.getElementById('modalProfessionalCode').textContent = code;
                document.getElementById('modalProfessionalName').textContent = name;
                document.getElementById('modalProfessionalFormation').textContent = formation;
                document.getElementById('modalProfessionalEmail').textContent = email;
                document.getElementById('modalProfessionalProfile').textContent = profile;
                document.getElementById('modalProfessionalPatients').textContent = patients;

                // Obter as crianças atribuídas ao profissional
                const assignedChildren = assignedChildrenData[professionalId] || [];

                // Preencher a tabela de crianças atribuídas no modal
                const assignedChildrenTableBody = document.querySelector('#assignedChildrenTable tbody');
                assignedChildrenTableBody.innerHTML = ''; // Limpar conteúdo anterior

                if (assignedChildren.length > 0) {
                    assignedChildren.forEach(child => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${child.childId}</td>
                            <td>${child.childName}</td>
                            <td>${child.guardian}</td>
                            <td>${child.age}</td>
                        `;
                        assignedChildrenTableBody.appendChild(tr);
                    });
                } else {
                    const tr = document.createElement('tr');
                    tr.innerHTML = `<td colspan="4" style="text-align: center;">Nenhuma criança atribuída.</td>`;
                    assignedChildrenTableBody.appendChild(tr);
                }

                // Exibir o modal
                professionalInfoModal.style.display = 'flex';
            });
        });
    });
</script>

<script>
        // Função para mostrar o conteúdo quando o botão for clicado
        function mostrarConteudo() {
            // Tornar visível o conteúdo
            document.getElementById("calculo-container").style.display = "block";
        }
        // Função para esconder o conteúdo quando o botão "Cancelar" for clicado
        function cancelarConteudo() {
            document.getElementById("calculo-container").style.display = "none";
        }
        
        function mostraraddChildModal() {
            // Tornar visível o conteúdo
            document.getElementById("addChildModal").style.display = "block";
        }
        
        function mostrareditChildModal() {
            // Tornar visível o conteúdo
            document.getElementById("editChildModal").style.display = "block";
        }
        
        function mostrarprofessionalInfoModal() {
            // Tornar visível o conteúdo
            document.getElementById("professionalInfoModal").style.display = "block";
        }
        
        function mostrarprofessionalInfoModal1() {
            // Tornar visível o conteúdo
            document.getElementById("professionalInfoModal1").style.display = "block";
        }
        
        function mostrarcliniceditmodal() {
            // Tornar visível o conteúdo
            document.getElementById("cliniceditmodal").style.display = "block";
        }
        
        function mostrarbuyTokensModals() {
            // Tornar visível o conteúdo
            document.getElementById("buyTokensModals").style.display = "block";
        }
        
        
        // Função para mostrar ou esconder o campo de vínculo "Outro"
function toggleRelationField() {
    const relationSelect = document.getElementById("addGuardianRelation");
    const relationOtherField = document.getElementById("addRelationOtherField");
    
    // Se "Outro" for selecionado, exibe o campo adicional
    if (relationSelect.value === "Outro") {
        relationOtherField.style.display = "block";
    } else {
        relationOtherField.style.display = "none";
    }
}



function toggleRelationOtherField() {
        var relationSelect = document.getElementById("editGuardianRelation");
        var relationOtherField = document.getElementById("relationOtherField");
        
        if (relationSelect.value === "Outro") {
            relationOtherField.style.display = "block"; // Exibe o campo para especificar vínculo
        } else {
            relationOtherField.style.display = "none"; // Esconde o campo para especificar vínculo
        }
    }
    
    // Chama a função ao carregar a página para verificar o estado inicial
    window.onload = function() {
        toggleRelationOtherField();
    };
    </script>

<script>
        // Abrir e Fechar Modal
        const openEditModalBtn = document.getElementById('openEditModalBtn');
        const editModalOverlay = document.getElementById('editModalOverlay');
        const closeEditModalBtn = document.getElementById('closeEditModalBtn');
        const cancelEditBtn = document.getElementById('cancelEditBtn');

        openEditModalBtn.addEventListener('click', () => {
            editModalOverlay.style.display = 'flex';
        });
        closeEditModalBtn.addEventListener('click', () => {
            editModalOverlay.style.display = 'none';
        });
        cancelEditBtn.addEventListener('click', () => {
            editModalOverlay.style.display = 'none';
        });

        // Fechar modal ao clicar no fundo
        editModalOverlay.addEventListener('click', (event) => {
            if (event.target === editModalOverlay) {
                editModalOverlay.style.display = 'none';
            }
        });

        // Submit do Formulário
        document.getElementById('nfEditForm').addEventListener('submit', function(event) {
            event.preventDefault();
            // Lógica de salvamento...
            alert('Dados atualizados com sucesso!');
            editModalOverlay.style.display = 'none';
        });
    </script>
    
    <!-- Scripts -->
    <script>
        // Seleção de Tipo (PF ou PJ)
        const clinicTypeSelect = document.getElementById('clinicType');
        const pfFields = document.getElementById('pf-fields');
        const pjFields = document.getElementById('pj-fields');

        clinicTypeSelect.addEventListener('change', function() {
            if (this.value === 'pf') {
                pfFields.style.display = 'flex';
                pjFields.style.display = 'none';
            } else if (this.value === 'pj') {
                pfFields.style.display = 'none';
                pjFields.style.display = 'flex';
            } else {
                pfFields.style.display = 'none';
                pjFields.style.display = 'none';
            }
        });

        // Abertura do Modal
        const openCreateModalBtn = document.getElementById('openCreateModalBtn');
        const clinicCreateModal = document.getElementById('clinic-create-modal');

        openCreateModalBtn.addEventListener('click', function() {
            clinicCreateModal.style.display = 'flex';
        });

        // Fechamento do Modal
        const closeCreateModalBtn = document.getElementById('closeCreateModalBtn');
        const cancelCreateBtn = document.getElementById('cancelCreateBtn');

        closeCreateModalBtn.addEventListener('click', function() {
            clinicCreateModal.style.display = 'none';
            resetForm();
        });

        cancelCreateBtn.addEventListener('click', function() {
            clinicCreateModal.style.display = 'none';
            resetForm();
        });

        // Fechar o Modal ao Clicar Fora dele
        window.addEventListener('click', function(event) {
            if (event.target === clinicCreateModal) {
                clinicCreateModal.style.display = 'none';
                resetForm();
            }
        });

        // Resetar o Formulário
        function resetForm() {
            document.getElementById('createClinicForm').reset();
            pfFields.style.display = 'none';
            pjFields.style.display = 'none';
        }

        // Submissão do Formulário
        const createClinicForm = document.getElementById('createClinicForm');
        createClinicForm.addEventListener('submit', function(event) {
            event.preventDefault();
            // Aqui você pode adicionar a lógica para enviar os dados para o servidor.
            alert('Clínica cadastrada com sucesso!');
            clinicCreateModal.style.display = 'none';
            resetForm();
        });
    </script>


</body>

</html>