<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Actions */
        .actions {
            display: flex;
            align-items: center;
            flex-wrap: wrap;
        }

        .actions .add-new {
            background-color: #08C89E;
            color: #fff;
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 14px;
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            margin-right: 10px;
            margin-bottom: 20px;
        }

        .actions .add-new i {
            margin-right: 8px;
        }

        /* Cards */
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 20px;
        }

        .card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            padding: 20px;
            display: flex;
            flex-direction: column;
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        .partner-clinic {
            border: 2px solid #08C89E; /* Borda verde para diferenciar */
            box-shadow: 0 4px 12px rgba(8, 200, 158, 0.2); /* Sombra leve */
            position: relative;
        }

        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .card-header .icon {
            font-size: 20px;
            color: #F6AD55;
            margin-right: 15px;
        }

        .card-header h3 {
            font-size: 22px;
            color: #08C89E;
            margin: 0;
        }

        .partner-badge {
            position: absolute;
            top: -10px;
            right: -10px;
            background-color: #08C89E;
            color: white;
            font-size: 12px;
            font-weight: bold;
            padding: 5px 10px;
            border-radius: 20px;
            text-transform: uppercase;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }

        .card-content p {
            margin: 5px 0;
            font-size: 15px;
            color: #4a5568;
             margin-top: -10px;
        }

        .card-content p b {
            color: #2d3748;
           
        }

        .card-footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 20px;
        }

        .card-footer .btn {
            background-color: #EDF2F7;
            color: #2d3748;
            padding: 10px 15px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
            display: flex;
            align-items: center;
            margin-left: 10px;
        }

        .card-footer .btn i {
            margin-right: 5px;
        }

        /* Botões */
        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
            display: flex;
            align-items: center;
        }

        .btn.edit {
            background-color: #F6AD55;
            color: #fff;
        }

        .btn.edit:hover {
            background-color: #dd6b20;
        }

        .btn.link {
            background-color: #08C89E;
            color: #fff;
        }

        .btn.link:hover {
            background-color: #06b287;
        }

        /* Classes adicionais específicas para os botões dentro dos cards */
        .manage-button {
            /* Adicione estilos específicos se necessário */
        }

        .access-button {
            /* Adicione estilos específicos se necessário */
        }

        /* Estilos Adicionais para Aceitar Convite */

        .summary-section {
            background-color: #FFFFFF;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            margin-bottom: 20px;
            display: flex;
            
            gap: 15px;
            border: 1px solid #e2e8f0;
        }

        .summary-section h2 {
            font-size: 20px;
            color: #2d3748;
            margin-bottom: 10px;
        }
        
        /* Coluna Esquerda */
        .left-column {
            flex: 2;
            min-width: 800px; /* Ajuste conforme necessário */
        }
        
        /* Coluna Direita */
        .right-column {
            flex: 1;
            min-width: 50px; /* Ajuste conforme necessário */
        }
        
        /* Divisor Visual entre as Colunas */
        .divider {
            width: 2px;
            background-color: #e2e8f0;
            height: auto;
            align-self: stretch; /* Faz o divisor estender-se verticalmente */
            margin: 0 10px;
        }

        /* Formulário de Aceitação de Convite de Parceira */
        #acceptPartnerInviteForm {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        #acceptPartnerInviteForm input[type="text"] {
            width: 150px;
            padding: 8px 16px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 16px;
        }

        /* Detalhes do Convite de Parceira */
        #parceirasInviteDetails {
            display: none;
        }

        .parceiras-action-buttons .btn:hover {
            /* As pseudo-classes já estão definidas nas classes existentes */
        }
        
        /* Container Principal da Seção de Parcerias */
        .partnership-management {
            background-color: #FFFFFF;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        /* Contêiner Flex para as Sub-seções */
        .partnership-container {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            align-items: flex-start; /* Alinha as sub-seções ao topo */
        }

        /* Sub-seção: Criar Nova Clínica */
        .create-clinic {
            flex: 1 1 200px; 
            max-width: 300px; 
            background-color: #F9FAFB;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 100px;
        }

        /* Sub-seção: Aceitar Convite de Parceria */
        .accept-invite {
            flex: 3 1 600px; 
            background-color: #F9FAFB;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 100px;
        }

        .partnership-item h2 {
            font-size: 18px;
            color: #08C89E;
            margin-bottom: -10px;
            margin-top: -10px;
        }

        .partnership-item p {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 20px;
            flex-grow: 1;
            margin-bottom: -5px;
        }

        /* Botão "Nova Clínica" */
        .create-clinic .add-new {
            background-color: #08C89E;
            color: #fff;
            padding: 10px 16px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            font-size: 14px;
            transition: background-color 0.3s;
        }

        .create-clinic .add-new i {
            margin-right: 8px;
        }

        .create-clinic .add-new:hover {
            background-color: #06b287;
        }

        /* Formulário de Aceitação de Convite */
        .accept-invite .invite-form {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        .accept-invite .form-group {
            display: flex;
            flex-direction: column;
            gap: 5px;
            flex: 1;
            min-width: 150px;
        }

        .accept-invite .form-group label {
            font-size: 14px;
            color: #2d3748;
            font-weight: 600;
        }

        #partnerInviteCodeInput {
            width: 100%;
            padding: 8px 12px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        #partnerInviteCodeInput:focus {
            border-color: #06b287;
            outline: none;
        }

        .btn.load-invite {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 16px;
            font-size: 14px;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            transition: background-color 0.3s;
        }

        .btn.load-invite i {
            margin-right: 5px;
        }

        .btn.load-invite:hover {
            background-color: #06b287;
        }

        /* Detalhes do Convite */
        .invite-details {
            display: none;
            flex-direction: column;
            gap: 10px;
            margin-top: 20px;
            background-color: #fff;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .invite-details p {
            margin: 0;
            font-size: 14px;
            color: #2d3748;
        }

        .invite-divider {
            border: none;
            border-top: 1px solid #e2e8f0;
            margin: 10px 0;
        }

        /* Botões de Ação no Detalhe do Convite */
        .parceiras-action-buttons {
            display: flex;
            gap: 10px;
            margin-top: 10px;
        }

        .parceiras-action-buttons .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            transition: background-color 0.3s;
        }

        .parceiras-action-buttons .save {
            background-color: #08C89E;
            color: #fff;
        }

        .parceiras-action-buttons .save:hover {
            background-color: #06b287;
        }

        .parceiras-action-buttons .decline {
            background-color: #EDF2F7;
            color: #2d3748;
        }

        .parceiras-action-buttons .decline:hover {
            background-color: #e2e8f0;
        }

        /* Responsividade */
        @media (max-width: 992px) {
            .partnership-container {
                flex-direction: column;
            }

            .create-clinic,
            .accept-invite {
                flex: 1 1 100%;
                max-width: 100%;
            }
        }

        /* Modal Styles */
/* Modal Overlay */
.modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(0, 0, 0, 0.6);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    transition: opacity 0.3s ease;
}

/* Modal Container */
.modal-container {
    background-color: #ffffff;
    border-radius: 16px;
    padding: 24px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2); /* Sombra mais suave */
    display: flex;
    flex-direction: column;
    gap: 16px;
    animation: fadeIn 0.3s ease;
    box-sizing: border-box;
    overflow: hidden;
}

/* Header */
.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-bottom: 8px;
    background-color: #08C89E; /* Fundo expandido */
    border-radius: 8px 8px 0 0; /* Arredonda apenas os cantos superiores */
    padding: 16px;
}

.modal-title h2 {
    font-size: 20px;
    font-weight: bold;
    color: #ffffff;
    margin: 0;
}

.btn-close {
    background: none;
    border: none;
    font-size: 20px;
    cursor: pointer;
    color: #ffffff;
}

.btn-close:hover {
    color: #e53e3e;
}

/* Form Fields */
.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

label {
    font-size: 14px;
    font-weight: bold;
    color: #2d3748;
}

/* Ajuste para os Inputs */
input[type="text"], input[type="email"], input[type="number"], select {
    width: 100%;
    max-width: 100%;
    padding: 10px 14px;
    border: 1.5px solid #e2e8f0;
    border-radius: 8px;
    font-size: 14px;
    outline: none;
    transition: border-color 0.2s;
    box-sizing: border-box;
}

input:focus {
    border-color: #08C89E;
    box-shadow: 0 0 0 3px rgba(8, 200, 158, 0.2);
}

/* Footer */
.modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 12px;
    border-top: 1px solid #e2e8f0;
    padding-top: 12px;
}

.btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    cursor: pointer;
    border: none;
    transition: background-color 0.2s, transform 0.2s;
}

.btn.cancel {
    background-color: #edf2f7;
    color: #2d3748;
}

.btn.cancel:hover {
    background-color: #e2e8f0;
}

.btn.save {
    background-color: #08C89E;
    color: #ffffff;
}

.btn.save:hover {
    background-color: #06b287;
}

.btn:active {
    transform: scale(0.95);
}






    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-clinicas_novo.php'; ?>

    <!-- Conteúdo Principal -->
    <main>
        <div class="content">
            <div class="header-content">
                <h1 style="color: #08C89E; margin-left: 15px"><i class="fa-solid fa-house" style="margin-right: 8px"></i>Início</h1>
            </div>
           

            <!-- Seção de Gerenciamento de Parcerias -->
            <section class="partnership-management">
                <div class="partnership-container">
                    <!-- Sub-seção: Criar Nova Clínica -->
                    <div class="partnership-item create-clinic">
                        <h2>Cadastre Sua Clínica</h2>
                        <p style="margin-bottom: 10px">Cadastre clínica para começar a usar o sistema.</p>
                        <button class="btn add-new" onclick="mostrarcreateclinicmodal()"><i class="fas fa-plus"></i>Cadastrar Nova Clínica</button>
                    </div>

                    <!-- Sub-seção: Aceitar Convite de Parceria -->
                    <div class="partnership-item accept-invite">
                        <h2>Aceitar Convite Para Parceria</h2>
                        <p style="margin-bottom: 5px">Inserir código de convite para se tornar parceiro de uma clínica existente.</p>
                        
                        <form id="acceptPartnerInviteForm" class="invite-form" aria-labelledby="inviteTitle">
                            <div class="form-group">
                                <label for="partnerInviteCodeInput">Digite o código de convite:</label>
                                <input type="text" id="partnerInviteCodeInput" name="partnerInviteCodeInput" 
                                    required placeholder="Ex: ABC123" aria-required="true" value="ABC123">
                            </div>
                            <button type="submit" class="btn load-invite"><i class="fas fa-upload"></i> Carregar Convite</button>
                        </form>

                        <div id="parceirasInviteDetails" class="invite-details" aria-live="polite">
                            <p><strong>Convite Localizado Com Sucesso!</strong></p>
                            <hr class="invite-divider" />
                            <p><strong>Convite para a clínica:</strong> <span id="parceirasClinicName"></span></p>
                            <p><strong>Enviado por:</strong> <span id="parceirasInviterName"></span></p>
                            <p><strong>Perfil:</strong> <span id="parceirasInviterPerfil"></span></p>
                            
                            <div class="parceiras-action-buttons">
                                <button class="btn save" id="parceirasAcceptButton">Confirmar Convite</button>
                                <button class="btn decline" id="parceirasDeclineButton">Cancelar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <div class="cards">
                <!-- Card de Clínica -->
                <div class="card">
                    <div>
                        <div class="card-header">
                            <span class="icon"><i class="fas fa-hospital"></i></span>
                            <h3>Clínica Sertãozinho</h3>
                        </div>
                        <div class="card-content">
                            
                            <p><b>Código:</b> CLA001 <span style="color: #08C89E;">(Ativo)</span></p>
                            <p><b>Meu Perfil:</b> Admin</p>
                            <p style="margin-top: 0px; margin-bottom: 10px"><hr /></p>
                        </div>
                        <div class="card-footer">
                            <button onclick="window.location.href='painel-p-clinca-gerenciar.php'" class="btn edit manage-button">
                                <i class="fas fa-edit"></i> Gerenciar
                            </button>
                            <button onclick="window.location.href='painel-clinica-crianças.php'" class="btn link access-button"><i class="fas fa-arrow-right"></i>Acessar</button>
                        </div>
                    </div>
                </div>

                <!-- Outro Card -->
                <div class="card partner-clinic">
                    <div>
                        <div class="card-header">
                            <span class="icon"><i class="fas fa-hospital"></i></span>
                            <h3>Clínica Central</h3>
                            <span class="partner-badge">Parceira</span>
                        </div>
                        <div class="card-content">
                            <p><b>Código:</b> CLA002 <span style="color: #F6AD55;">(Suspenso)</span></p>
                            <p><b>Meu Perfil:</b> Supervisor</p>
                            <p style="margin-top: 0px; margin-bottom: 10px"><hr /></p>
                        </div>
                        <div class="card-footer">
                            <button onclick="window.location.href='painel-clinica-crianças.php'" class="btn link access-button"><i class="fas fa-arrow-right"></i>Acessar</button>
                        </div>
                    </div>
                </div>
                
                <!-- Outro Card -->
                <div class="card partner-clinic">
                    <div>
                        <div class="card-header">
                            <span class="icon"><i class="fas fa-hospital"></i></span>
                            <h3>Clínica do Norte</h3>
                            <span class="partner-badge">Parceira</span>
                        </div>
                        <div class="card-content">
                            <p><b>Código:</b> CLA003 <span style="color: #F6AD55;">(Suspenso)</span></p>
                            <p><b>Meu Perfil:</b> Colaborador</p>
                            <p style="margin-top: 0px; margin-bottom: 10px"><hr /></p>
                        </div>
                        <div class="card-footer">
                            <button onclick="window.location.href='painel-clinica-crianças.php'" class="btn link access-button"><i class="fas fa-arrow-right"></i>Acessar</button>
                        </div>
                    </div>
                </div>
                
                
                
                
            </div>
        </div>
    </main>

   <!-- Modal para Cadastrar Nova Clínica -->

    <div class="modal-overlay" id="createsClwinicModalOverlay">
        <header class="modal-header">
            <div class="modal-title">
                <h2>Cadastro de Clínica</h2>
            </div>
            <button type="button" class="btn-close" id="closeCreateClinicModal" aria-label="Fechar">&times;</button>
        </header>
        <form id="createClinicForm">
            <div class="form-group">
                <label for="clinicName">Nome da Clínica:</label>
                <input type="text" id="clinicName" name="clinicName" required placeholder="Ex: Clínica Pediátrica ABC">
            </div>
            <!-- Adicione mais campos aqui -->
            <footer class="modal-footer">
                <button type="button" class="btn cancel" id="cancelCreateClinic">Cancelar</button>
                <button type="submit" class="btn save">Salvar</button>
            </footer>
        </form>
    </div>
</div>

<!-- Modal para Criar Nova Clínica -->
    <div id="createclinicmodal" class="modal" style="display: none; 
        position: fixed; 
        top: 0; 
        left: 0; 
        width: 100%; 
        height: 100%; 
        background-color: rgba(0,0,0,0.5); 
        justify-content: center; 
        align-items: center; 
        z-index: 9999;">
        
        <div class="modal-content" style="
            background-color: #ffffff; 
            border-radius: 12px; 
            width: 90%; 
            max-width: 800px; 
            padding: 20px; 
            position: relative; 
            box-sizing: border-box; 
            max-height: 90vh; 
            overflow-y: auto; 
            font-family: 'Poppins', sans-serif;">
            
            <!-- Botão para Fechar o Modal -->
            <span id="closeCreateModalBtn" class="close-modal" style="
                position: absolute; 
                top: 16px; 
                right: 16px; 
                font-size: 24px; 
                font-weight: bold; 
                color: #4a5568; 
                cursor: pointer;">
                &times;
            </span>
            
            <!-- Cabeçalho do Modal -->
            <div class="modal-header" style="text-align: center; margin-bottom: 20px;">
                <h2 style="
                    color: #fff; 
                    background-color: #08C89E; 
                    padding: 10px 0; 
                    border-radius: 8px; 
                    margin: 0;">
                    Criar Nova Clínica</h2>
            </div>
            
            <!-- Corpo do Modal -->
            <div class="modal-body" style="padding: 0 10px;">
                <!-- Orientação ao Usuário -->
                <p style="font-size: 14px; color: #4a5568; margin-bottom: 0px; margin-top: -20px">
                    Preencha as informações para cadastrar uma nova clínica no sistema. 
                    Se o responsável for <b>Pessoa Física</b>, utilize <i>Nome Completo</i> e <i>CPF</i>; 
                    caso seja <b>Pessoa Jurídica</b>, utilize <i>Razão Social</i> e <i>CNPJ</i>.
                </p>
    
                <!-- Formulário no Modal -->
                <form class="clinic-modal-form" id="createClinicForm" style="display: flex; flex-direction: column; gap: 20px;">
                    
                    <!-- Seção 1: Seleção de Tipo (PF ou PJ) -->
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <div style="flex: 1; min-width: 200px;">
                            <label for="clinicType" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 5px;">
                                Tipo de Responsável
                            </label>
                            <select id="clinicType" name="clinicType" required style="
                                width: 100%; 
                                padding: 8px; 
                                border: 1px solid #e2e8f0; 
                                border-radius: 8px; 
                                font-size: 14px; 
                                color: #2d3748;">
                                <option value="" disabled selected>Selecione</option>
                                <option value="pf">Pessoa Física</option>
                                <option value="pj">Pessoa Jurídica</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Seção 2: Dados de Identificação -->
                    <div class="identification-section" style="display: flex; flex-direction: column; gap: 10px;">
                        
                        <!-- Pessoa Física -->
                        <div id="pf-fields" style="display: none; gap: 10px;">
                            <!-- Linha 1: Nome Completo -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 480px;">
                                    <label for="pfName" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        Nome Completo
                                    </label>
                                    <input type="text" id="pfName" name="pfName" placeholder="Ex: João da Silva" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;">
                                </div>
                            </div>
                            
                            <!-- Linha 2: CPF -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 250px;">
                                    <label for="pfCPF" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        CPF
                                    </label>
                                    <input type="text" id="pfCPF" name="pfCPF" placeholder="000.000.000-00" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Pessoa Jurídica -->
                        <div id="pj-fields" style="display: none; gap: 10px;">
                            <!-- Linha 1: Razão Social -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 480px;">
                                    <label for="pjRazaoSocial" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        Razão Social
                                    </label>
                                    <input type="text" id="pjRazaoSocial" name="pjRazaoSocial" placeholder="Ex: Clínica Exemplo LTDA" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;">
                                </div>
                            </div>
                            
                            <!-- Linha 2: CNPJ -->
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                <div style="flex: 1; min-width: 250px;">
                                    <label for="pjCNPJ" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                        CNPJ
                                    </label>
                                    <input type="text" id="pjCNPJ" name="pjCNPJ" placeholder="00.000.000/0001-00" 
                                           style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                                  border-radius: 8px; font-size: 14px; color: #2d3748; 
                                                  box-sizing: border-box;">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Seção 3: Contato e E-mail Financeiro -->
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <!-- Telefone -->
                        <div style="flex: 1; min-width: 200px;">
                            <label for="clinicPhone" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                Telefone / Celular
                            </label>
                            <input type="tel" id="clinicPhone" name="clinicPhone" placeholder="(99) 99999-9999" 
                                   style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                          border-radius: 8px; font-size: 14px; color: #2d3748; 
                                          box-sizing: border-box;">
                        </div>
                        <!-- E-mail Financeiro -->
                        <div style="flex: 1; min-width: 280px;">
                            <label for="clinicFinanceEmail" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                E-mail Financeiro
                            </label>
                            <input type="email" id="clinicFinanceEmail" name="clinicFinanceEmail" 
                                   placeholder="financeiro@exemplo.com" required 
                                   style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                          border-radius: 8px; font-size: 14px; color: #2d3748; 
                                          box-sizing: border-box;">
                        </div>
                    </div>
                    
                    <!-- Seção 4: Endereço -->
                    <div style="display: flex; flex-direction: column; gap: 10px; margin-top: -20px">
                        <h3 style="
                            font-size: 16px; 
                            color: #2d3748; 
                            border-bottom: 1px solid #e2e8f0; 
                            padding-bottom: 5px; 
                            margin: 0;">
                            Endereço
                        </h3>
                        
                        <!-- Linha 1: Logradouro, Número e Complemento -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap; margin-top: -10px">
                            <div style="flex: 2; min-width: 200px;">
                                <label for="clinicStreet" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px;">
                                    Logradouro
                                </label>
                                <input type="text" id="clinicStreet" name="clinicStreet" placeholder="Rua / Avenida" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;">
                            </div>
                            <div style="flex: 1; min-width: 100px;">
                                <label for="clinicNumber" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px;">
                                    Número
                                </label>
                                <input type="text" id="clinicNumber" name="clinicNumber" placeholder="123" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;">
                            </div>
                            <div style="flex: 1; min-width: 150px;">
                                <label for="clinicComplement" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px;">
                                    Complemento
                                </label>
                                <input type="text" id="clinicComplement" name="clinicComplement" placeholder="Apto, Sala..." 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;">
                            </div>
                        </div>
                        
                        <!-- Linha 2: Bairro, Cidade, Estado e CEP -->
                        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <div style="flex: 1; min-width: 180px;">
                                <label for="clinicNeighborhood" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    Bairro
                                </label>
                                <input type="text" id="clinicNeighborhood" name="clinicNeighborhood" placeholder="Centro" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;">
                            </div>
                            <div style="flex: 1; min-width: 180px;">
                                <label for="clinicCity" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    Cidade
                                </label>
                                <input type="text" id="clinicCity" name="clinicCity" placeholder="Sertãozinho" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;">
                            </div>
                            <div style="flex: 1; min-width: 80px;">
                                <label for="clinicState" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    Estado
                                </label>
                                <select id="clinicState" name="clinicState" required 
                                        style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                               border-radius: 8px; font-size: 14px; color: #2d3748; 
                                               box-sizing: border-box;">
                                    <option value="" disabled selected>UF</option>
                                    <option value="SP">SP</option>
                                    <option value="RJ">RJ</option>
                                    <option value="MG">MG</option>
                                    <option value="BA">BA</option>
                                    <option value="RS">RS</option>
                                    <!-- Adicione mais opções de estados conforme necessário -->
                                </select>
                            </div>
                            <div style="flex: 1; min-width: 150px;">
                                <label for="clinicCEP" style="display: block; font-size: 14px; color: #2d3748; margin-bottom: 0px; margin-top: -20px">
                                    CEP
                                </label>
                                <input type="text" id="clinicCEP" name="clinicCEP" placeholder="12.345-678" required 
                                       style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; 
                                              border-radius: 8px; font-size: 14px; color: #2d3748; 
                                              box-sizing: border-box;">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Botões de Ação -->
                    <div style="display: flex; justify-content: flex-end; gap: 10px;">
                        <button type="button" id="cancelCreateBtn" style="
                            background-color: #e53e3e; 
                            color: #fff; 
                            padding: 10px 20px; 
                            border: none; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            cursor: pointer;">
                            Cancelar
                        </button>
                        <button type="submit" style="
                            background-color: #08C89E; 
                            color: #fff; 
                            padding: 10px 20px; 
                            border: none; 
                            border-radius: 8px; 
                            font-size: 14px; 
                            cursor: pointer;">
                            Salvar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>





    <!-- JavaScript para Gerenciamento de Convites e Modal -->
    <script>
        // Convites
        document.getElementById('acceptPartnerInviteForm').addEventListener('submit', function(event) {
            event.preventDefault();
            const inviteCode = document.getElementById('partnerInviteCodeInput').value.trim();

            // Simulação de verificação de código de convite
            if(inviteCode === 'ABC123') { // Exemplo de código válido
                document.getElementById('parceirasClinicName').textContent = 'Clínica Exemplo';
                document.getElementById('parceirasInviterName').textContent = 'Dr. João Silva';
                document.getElementById('parceirasInviterPerfil').textContent = 'Colaborador';
                document.getElementById('parceirasInviteDetails').style.display = 'block';
            } else {
                alert('Código de convite inválido. Por favor, tente novamente.');
            }
        });

        document.getElementById('parceirasAcceptButton').addEventListener('click', function() {
            // Lógica para aceitar o convite
            // Ocultar detalhes do convite após aceitação
            document.getElementById('parceirasInviteDetails').style.display = 'none';
            // Limpar o campo do formulário
            document.getElementById('acceptPartnerInviteForm').reset();
        });

        document.getElementById('parceirasDeclineButton').addEventListener('click', function() {
            // Lógica para recusar o convite
            // Ocultar detalhes do convite após recusa
            document.getElementById('parceirasInviteDetails').style.display = 'none';
            // Limpar o campo do formulário
            document.getElementById('acceptPartnerInviteForm').reset();
        });

        // Modal Nova Clínica
        const openModalBtn = document.getElementById('openCreateClinicModal');
        const modalOverlay = document.getElementById('createClinicModalOverlay');
        const cancelBtn = document.getElementById('cancelCreateClinic');
        const modalContainer = document.getElementById('createClinicModal');

        // Abrir modal
        openModalBtn.addEventListener('click', () => {
            modalOverlay.style.display = 'flex';
        });

        // Fechar modal ao clicar em "Cancelar"
        cancelBtn.addEventListener('click', () => {
            modalOverlay.style.display = 'none';
        });

        // Fechar modal ao clicar fora do container
        modalOverlay.addEventListener('click', (e) => {
            if(e.target === modalOverlay) {
                modalOverlay.style.display = 'none';
            }
        });

        // Submit do formulário da nova clínica
        document.getElementById('createClinicForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const clinicName = document.getElementById('clinicName').value.trim();

            if(clinicName) {
                // Aqui ficaria a lógica para salvar a clínica via AJAX ou outra abordagem.
                alert('Clínica "' + clinicName + '" cadastrada com sucesso!');
                // Fechar o modal após o cadastro
                modalOverlay.style.display = 'none';
                // Limpar o formulário
                document.getElementById('createClinicForm').reset();
            } else {
                alert('Por favor, preencha o nome da clínica.');
            }
        });
    </script>
    
    <script>
        function mostrarcreateclinicmodal() {
            // Tornar visível o conteúdo
            document.getElementById("createclinicmodal").style.display = "block";
        }
    </script>
    <!-- Scripts -->
    <script>
        // Seleção de Tipo (PF ou PJ)
        const clinicTypeSelect = document.getElementById('clinicType');
        const pfFields = document.getElementById('pf-fields');
        const pjFields = document.getElementById('pj-fields');

        clinicTypeSelect.addEventListener('change', function() {
            if (this.value === 'pf') {
                pfFields.style.display = 'flex';
                pjFields.style.display = 'none';
            } else if (this.value === 'pj') {
                pfFields.style.display = 'none';
                pjFields.style.display = 'flex';
            } else {
                pfFields.style.display = 'none';
                pjFields.style.display = 'none';
            }
        });

        // Abertura do Modal
        const openCreateModalBtn = document.getElementById('openCreateModalBtn');
        const clinicCreateModal = document.getElementById('clinic-create-modal');

        openCreateModalBtn.addEventListener('click', function() {
            clinicCreateModal.style.display = 'flex';
        });

        // Fechamento do Modal
        const closeCreateModalBtn = document.getElementById('closeCreateModalBtn');
        const cancelCreateBtn = document.getElementById('cancelCreateBtn');

        closeCreateModalBtn.addEventListener('click', function() {
            clinicCreateModal.style.display = 'none';
            resetForm();
        });

        cancelCreateBtn.addEventListener('click', function() {
            clinicCreateModal.style.display = 'none';
            resetForm();
        });

        // Fechar o Modal ao Clicar Fora dele
        window.addEventListener('click', function(event) {
            if (event.target === clinicCreateModal) {
                clinicCreateModal.style.display = 'none';
                resetForm();
            }
        });

        // Resetar o Formulário
        function resetForm() {
            document.getElementById('createClinicForm').reset();
            pfFields.style.display = 'none';
            pjFields.style.display = 'none';
        }

        // Submissão do Formulário
        const createClinicForm = document.getElementById('createClinicForm');
        createClinicForm.addEventListener('submit', function(event) {
            event.preventDefault();
            // Aqui você pode adicionar a lógica para enviar os dados para o servidor.
            alert('Clínica cadastrada com sucesso!');
            clinicCreateModal.style.display = 'none';
            resetForm();
        });
    </script>
</body>
</html>
