<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>

/* Formulário de Perfil */
.profile-form {
    background-color: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    padding: 20px;
    max-width: 100%;
    box-sizing: border-box;
}

.profile-form h2 {
    font-size: 24px;
    color: #08C89E;
    margin-bottom: 10px;
    margin-top: -10px;
    text-align: left; /* Alterado do inline */
}

.profile-form form {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.profile-form .column {
    background-color: #f9fafb;
    padding: 15px;
    border-radius: 8px;
    box-sizing: border-box;
    border: 1px solid #e2e8f0;
    display: flex;
    flex-direction: column;
}

.profile-form .column h3 {
    font-size: 18px;
    color: #2d3748;
    margin-bottom: 15px;
    border-bottom: 1px solid #e2e8f0;
    padding-bottom: 10px;
}

.profile-form .avatar-wrapper {
    text-align: center;
    margin-bottom: 35px;
    position: relative;
}

.profile-form .avatar-wrapper img {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    border: 3px solid #08C89E;
    object-fit: cover;
}

.profile-form .upload-button {
    position: absolute;
    bottom: 0;
    right: calc(50% - 60px);
    background-color: #08C89E;
    border: none;
    border-radius: 50%;
    padding: 10px;
    cursor: pointer;
    color: #fff;
    transition: background 0.3s;
}

.profile-form .upload-button:hover {
    background-color: #06b287;
}

.profile-form .upload-button input[type="file"] {
    display: none;
}

.profile-form label {
    display: block;
    font-size: 16px;
    color: #4a5568;
    margin-bottom: 5px;
}

.profile-form input,
.profile-form select,
.profile-form textarea {
    width: 100%;
    padding: 10px;
    margin-bottom: 15px;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    font-size: 16px;
    color: #2d3748;
    box-sizing: border-box;
}

.profile-form input[readonly] {
    background-color: #edf2f7;
    cursor: not-allowed;
}

/* Grupos de Formulário */
.form-group {
    margin-bottom: 0px;
}

</style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-perfil.php'; ?>

    <!-- Conteúdo Principal -->
    <main class="content" >

    <div class="header-content">
        <h1><i class="fas fa-user" style="margin-right: 8px"></i>Meu Perfil</h1>
    </div>
    <!-- Formulário de Perfil -->
    <div class="profile-form">
        <!-- <h2>Atualize suas informações</h2> -->
        <form id="profileForm">
            <!-- Primeira Coluna: Dados Pessoais com Avatar -->
            <div class="column">
                <h3>Dados Pessoais</h3>
                <div class="avatar-wrapper">
                    <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                    <label class="upload-button" for="upload-photo" aria-label="Upload de Foto">
                        <i class="fas fa-camera"></i>
                        <input type="file" id="upload-photo" accept="image/*" aria-hidden="true">
                    </label>
                </div>
                <div class="form-group">
                    <label for="profileName">Nome Completo</label>
                    <input type="text" id="profileName" name="profileName" value="Coralina Matos" required>
                </div>
                <div class="form-group">
                    <label for="profileProfession">Profissão</label>
                    <input type="text" id="profileProfession" name="profileProfession" value="Terapeuta Ocupacional">
                </div>
                <div class="form-group">
                    <label for="profileRegistration">Registro Profissional</label>
                    <input type="text" id="profileRegistration" name="profileRegistration" value="CREFITO: 12.132-TO">
                </div>
                
                <div class="form-group">
                    <label for="profileEmail">Email</label>
                    <input type="email" id="profileEmail" name="profileEmail" value="coralina.matos@example.com" readonly>
                </div>
                <div class="form-group">
                    <label for="profilePhone">Telefone</label>
                    <input type="tel" id="profilePhone" name="profilePhone" value="(99) 99999-9999">
                </div>
                
                <button type="button" class="btn save" id="savePersonalInfo">Salvar Informações</button>
            </div>
            <!-- Segunda Coluna: Contato com Endereço -->
            <div class="column">
                <h3>Endereço</h3>
                
                <!-- Campos de Endereço -->
                <div class="form-group">
                    <label for="profileStreet">Endereço</label>
                    <input type="text" id="profileStreet" name="profileStreet" placeholder="Rua Exemplo" required>
                </div>
                <div class="form-group">
                    <label for="profileNumber">Número</label>
                    <input type="text" id="profileNumber" name="profileNumber" placeholder="123" required>
                </div>
                <div class="form-group">
                    <label for="profileComplement">Complemento</label>
                    <input type="text" id="profileComplement" name="profileComplement" placeholder="Apto 45">
                </div>
                <div class="form-group">
                    <label for="profileNeighborhood">Bairro</label>
                    <input type="text" id="profileNeighborhood" name="profileNeighborhood" placeholder="Bairro Exemplo" required>
                </div>
                <div class="form-group">
                    <label for="profileCity">Cidade</label>
                    <input type="text" id="profileCity" name="profileCity" placeholder="Cidade Exemplo" required>
                </div>
                <div class="form-group">
                    <label for="profileState">Estado</label>
                    <select id="profileState" name="profileState" required>
                        <option value="">Selecione</option>
                        <option value="AC">Acre (AC)</option>
                        <option value="AL">Alagoas (AL)</option>
                        <option value="AP">Amapá (AP)</option>
                        <option value="AM">Amazonas (AM)</option>
                        <option value="BA">Bahia (BA)</option>
                        <option value="CE">Ceará (CE)</option>
                        <option value="DF">Distrito Federal (DF)</option>
                        <option value="ES">Espírito Santo (ES)</option>
                        <option value="GO">Goiás (GO)</option>
                        <option value="MA">Maranhão (MA)</option>
                        <option value="MT">Mato Grosso (MT)</option>
                        <option value="MS">Mato Grosso do Sul (MS)</option>
                        <option value="MG">Minas Gerais (MG)</option>
                        <option value="PA">Pará (PA)</option>
                        <option value="PB">Paraíba (PB)</option>
                        <option value="PR">Paraná (PR)</option>
                        <option value="PE">Pernambuco (PE)</option>
                        <option value="PI">Piauí (PI)</option>
                        <option value="RJ">Rio de Janeiro (RJ)</option>
                        <option value="RN">Rio Grande do Norte (RN)</option>
                        <option value="RS">Rio Grande do Sul (RS)</option>
                        <option value="RO">Rondônia (RO)</option>
                        <option value="RR">Roraima (RR)</option>
                        <option value="SC">Santa Catarina (SC)</option>
                        <option value="SP">São Paulo (SP)</option>
                        <option value="SE">Sergipe (SE)</option>
                        <option value="TO">Tocantins (TO)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="profileCEP">CEP</label>
                    <input type="text" id="profileCEP" name="profileCEP" placeholder="12345-678" required>
                </div>
                <button type="button" class="btn save" id="saveContactInfo">Salvar Endereço</button>
            </div>
            <!-- Terceira Coluna: Alterar Senha -->
            <div class="column">
                <h3>Alterar Senha</h3>
                <div class="form-group">
                    <label for="currentPassword">Senha Atual</label>
                    <input type="password" id="currentPassword" name="currentPassword" required>
                </div>
                <div class="form-group">
                    <label for="newPassword">Nova Senha</label>
                    <input type="password" id="newPassword" name="newPassword" required>
                </div>
                <div class="form-group">
                    <label for="confirmPassword">Repetir Nova Senha</label>
                    <input type="password" id="confirmPassword" name="confirmPassword" required>
                </div>
                <button type="submit" class="btn save">Salvar Senha</button>
            </div>
        </form>
    </div>


    </main>
    
    

    <!-- Script -->
    <script></script>
    
</body>
</html>
