<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Super Admin - Gestão de Clínicas</title>
    <!-- Fontes e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- CSS Global do Projeto (Exemplo) -->
    <!-- Substitua os links abaixo pelos caminhos corretos dos seus arquivos CSS -->
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f4f8;
            margin: 0;
            padding: 0;
        }
        .content {
            padding: 20px;
        }
        .header-content h1 {
            color: #08C89E;
            margin-top: -20px;
            font-size: 24px;
        }

        /* Barra de status / mensagem */
        .status-message {
            background-color: #48BB78;
            color: #fff;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 8px;
            display: none;
            transition: opacity 0.3s ease;
        }
        .status-error {
            background-color: #E53E3E !important;
        }

        /* Container principal */
        .partnership-management {
            background-color: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        /* Filtros */
        .filters {
            display: flex;
            align-items: flex-end;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }
        .filters .filter-group {
            display: flex;
            flex-direction: column;
        }
        .filters label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }
        .filters select,
        .filters input {
            padding: 8px 12px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            width: 250px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }
        .filters select:focus,
        .filters input:focus {
            border-color: #08C89E;
            outline: none;
        }
        .filters .btn {
            padding: 8px 16px;
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.3s ease;
        }
        .filters .btn:hover {
            background-color: #06a08a;
        }

        /* Tabela de Clínicas */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            text-align: left;
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 14px;
            vertical-align: middle;
        }
        th {
            background: #f7fafc;
            color: #2d3748;
            position: relative;
        }
        tr:hover {
            background: #f1f5f9;
        }

        /* Paginação */
        .pagination {
            text-align: center;
            margin-top: 20px;
        }
        .pagination a {
            display: inline-block;
            margin: 0 4px;
            padding: 6px 10px;
            background-color: #ebf8ff;
            color: #2d3748;
            border-radius: 4px;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        .pagination a.active {
            background-color: #08C89E;
            color: #fff;
        }
        .pagination a:hover:not(.active) {
            background-color: #cceaf5;
        }

        /* Botões de ação (ícones) */
        .icon-actions {
            display: flex;
            gap: 8px;
        }
        .icon-actions button {
            background: none;
            border: none;
            padding: 4px;
            cursor: pointer;
            color: #4A5568;
            font-size: 16px;
            transition: color 0.3s ease;
        }
        .icon-actions button:hover {
            color: #08C89E;
        }

        /* Modal */
        .modal {
            display: none; 
            position: fixed; 
            z-index: 9999; 
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0,0,0,0.5);
            overflow-y: auto;
            padding: 20px;
            justify-content: center;
            align-items: center;
            animation: fadeIn 0.3s ease;
        }
        .modal-content {
            background: #fff;
            margin: 40px auto;
            padding: 20px;
            border-radius: 12px;
            width: 90%;
            max-width: 600px;
            position: relative;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            animation: slideDown 0.3s ease;
        }
        .modal-content h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: 10px;
        }
        .modal-content .close {
            position: absolute;
            top: 10px;
            right: 20px;
            font-size: 24px;
            color: #aaa;
            cursor: pointer;
            transition: color 0.3s ease;
        }
        .modal-content .close:hover {
            color: #555;
        }
        .modal-actions {
            margin-top: 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        .btn-modal {
            padding: 8px 16px;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .btn-cancel {
            background-color: #e53e3e;
            color: #fff;
        }
        .btn-cancel:hover {
            background-color: #c53030;
        }
        .btn-confirm {
            background-color: #08C89E;
            color: #fff;
        }
        .btn-confirm:hover {
            background-color: #06a08a;
        }

        /* Formulário de Transferência no Modal */
        .modal-form-group {
            margin-bottom: 15px;
        }
        .modal-form-group label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }
        .modal-form-group input,
        .modal-form-group select {
            width: 100%;
            padding: 8px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }
        .modal-form-group input:focus,
        .modal-form-group select:focus {
            border-color: #08C89E;
            outline: none;
        }

        /* Resultados da Pesquisa */
        .search-results {
            background-color: #f7fafc;
            border: 1px solid #cbd5e0;
            border-radius: 8px;
            padding: 10px;
            margin-top: 10px;
            display: none;
            transition: all 0.3s ease;
        }
        .search-results p {
            margin: 5px 0;
            font-size: 14px;
            color: #2d3748;
        }

        /* Animações */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideDown {
            from { transform: translateY(-20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
    </style>
</head>
<body>
    <!-- Cabeçalho e Sidebar -->
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin-clinicas.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1>Clínicas</h1>
        </div>
        <div class="status-message" id="statusMessage"></div>
        
        <!-- Container de Gestão de Clínicas -->
        <div class="partnership-management">
            <p style="margin-top:-15px;">Visualize, filtre e gerencie as clínicas do sistema.</p>
            <hr />
            
            <!-- Filtros -->
            <div class="filters">
                <div class="filter-group" style="width: 100px;">
                    <label for="filterName">Código:</label>
                    <input type="text" id="filterName" placeholder="Ex: CLA002">
                </div>
                <div class="filter-group">
                    <label for="filterName">Nome da Clínica:</label>
                    <input type="text" id="filterName" placeholder="Ex: Clínica Central">
                </div>
                <div class="filter-group">
                    <label for="filterAdmin">Administrador:</label>
                    <input type="text" id="filterAdmin" placeholder="Ex: José Almeida">
                </div>
                <div class="filter-group" style="width: 150px;">
                    <label for="filterStatus">Status:</label>
                    <select id="filterStatus">
                        <option value="">Todos</option>
                        <option value="Ativa">Ativa</option>
                        <option value="Suspensa">Suspensa</option>
                        <option value="Inativa">Inativa</option>
                    </select>
                </div>
                <button class="btn" id="applyFilters">Aplicar Filtros</button>
            </div>
            
            <!-- Tabela de Clínicas -->
            <table id="clinicsTable">
                <thead>
                    <tr>
                        <th>ORD</th>
                        <th>ID</th>
                        <th>Nome da Clínica</th>
                        <th>Administrador</th>
                        
                        <th>Plano</th>
                        <th>Pac.</th>
                        <th>Prof.</th>
                        <th>Status</th>
                        <th>#</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Exemplo de dados -->
                    <tr>
                        <td>1</td>
                        <td>CL001</td>
                        <td>Clínica Sertãozinho</td>
                        <td>José Almeida</td>
                        
                        <td>Premium</td>
                        <td>50</td>
                        <td>5</td>
                        <td>Ativa</td>
                        <td>
                            <div class="icon-actions">
                                <button class="btn-transfer" data-id="CL001" data-owner="José Almeida" title="Transferir Clínica">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>CL002</td>
                        <td>Clínica Central</td>
                        <td>Luiz Gustavo</td>
                        
                        <td>Básico</td>
                        <td>20</td>
                        <td>2</td>
                        <td>Suspensa</td>
                        <td>
                            <div class="icon-actions">
                                <button class="btn-transfer" data-id="CL002" data-owner="Luiz Gustavo" title="Transferir Clínica">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>CL003</td>
                        <td>Clínica do Norte</td>
                        <td>José Almeida</td>
                        
                        <td>Profissional</td>
                        <td>0</td>
                        <td>0</td>
                        <td>Inativa</td>
                        <td>
                            <div class="icon-actions">
                                <button class="btn-transfer" data-id="CL003" data-owner="José Almeida" title="Transferir Clínica">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <td>CL004</td>
                        <td>Clínica Exemplo</td>
                        <td>Luiz Gustavo</td>
                        
                        <td>Básico</td>
                        <td>10</td>
                        <td>1</td>
                        <td>Ativa</td>
                        <td>
                            <div class="icon-actions">
                                <button class="btn-transfer" data-id="CL004" data-owner="Luiz Gustavo" title="Transferir Clínica">
                                    <i class="fas fa-exchange-alt"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            
            <!-- Paginação de Exemplo -->
            <div class="pagination" style="margin-top:20px;">
                <a href="#" class="active">1</a>
                <a href="#">2</a>
                <a href="#">Próximo &raquo;</a>
            </div>
        </div>
    </main>

    <!-- MODAL: Transferir Clínica -->
    <div class="modal" id="transferModal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Transferir Clínica</h2>
            
            <!-- Informações Completas da Clínica -->
            <div id="clinicInfo" style="background-color: #f7fafc; border: 1px solid #cbd5e0; border-radius: 8px; padding: 10px; margin-bottom: 15px;">
                <p style="margin: 4px 0; font-size: 14px; color: #2d3748;"><strong>ID da Clínica:</strong> <span id="clinicId">CL001</span></p>
                <p style="margin: 4px 0; font-size: 14px; color: #2d3748;"><strong>Nome da Clínica:</strong> <span id="clinicName">Clínica Sertãozinho</span></p>
                <p style="margin: 4px 0; font-size: 14px; color: #2d3748;"><strong>Status da Clínica:</strong> <span id="clinicStatus">Ativa</span></p>
                <p style="margin: 4px 0; font-size: 14px; color: #2d3748;"><strong>Proprietário Atual:</strong> <span id="currentOwner">José Almeida</span></p>
            </div>

            <!-- Formulário de Transferência -->
            <form id="transferForm" style="display: flex; flex-direction: column; gap: 10px;">
                <!-- Campo para inserir código do novo profissional -->
                <div class="modal-form-group" style="margin-bottom: 5px;">
                    <label for="transferCode" style="display: block; font-size: 14px; font-weight: 600; color: #2d3748; margin-bottom: 5px;">
                        Código do Novo Profissional
                    </label>
                    <input 
                        type="text"
                        id="transferCode"
                        placeholder="Ex: PRF001"
                        required
                        style="width: 100%; padding: 8px; border: 1px solid #e2e8f0; border-radius: 8px; font-size: 14px; color: #2d3748;" value="PRF001">
                </div>

                <!-- Botão "Pesquisar" -->
                <button 
                    type="button"
                    id="searchProfBtn"
                    style="background-color: #3182ce; color: #fff; border: none; padding: 8px 16px; border-radius: 8px; font-size: 14px; cursor: pointer;">
                    <i class="fas fa-search"></i> Pesquisar
                </button>

                <!-- Área para Exibir Informações do Novo Proprietário Encontrado -->
                <div id="searchResults" class="search-results" style="background-color: #f7fafc; border: 1px solid #cbd5e0; border-radius: 8px; padding: 10px; margin-bottom: 10px; display: none;">
                    <!-- Exemplo de Como Ficarão as Informações Carregadas:
                         <p><strong>Nome:</strong> Maria da Silva</p>
                         <p><strong>E-mail:</strong> maria.silva@exemplo.com</p>
                         <p><strong>Formação:</strong> Fonoaudióloga</p>
                         <p><strong>Registro Profissional:</strong> CRFa 12345</p>
                    -->
                </div>

                <!-- Botões de Ação no Modal -->
                <div class="modal-actions" style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 5px;">
                    <button type="button" class="btn-modal btn-cancel" id="cancelTransfer"
                        style="background-color: #e53e3e; color: #fff; padding: 8px 16px; border: none; border-radius: 8px; font-size: 14px; cursor: pointer;">
                        Cancelar
                    </button>
                    <button
                        type="submit"
                        class="btn-modal btn-confirm"
                        id="confirmTransferBtn"
                        disabled
                        style="background-color: #08C89E; color: #fff; padding: 8px 16px; border: none; border-radius: 8px; font-size: 14px; cursor: pointer;">
                        Confirmar Transferência
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // ELEMENTOS DE FILTRO
        const filterName       = document.getElementById('filterName');
        const filterAdmin      = document.getElementById('filterAdmin');
        const filterStatus     = document.getElementById('filterStatus');
        const applyFiltersBtn  = document.getElementById('applyFilters');

        // TABELA
        const tableBody       = document.querySelector('#clinicsTable tbody');

        // MENSAGEM DE STATUS
        const statusMessage   = document.getElementById('statusMessage');

        // MODAL: Transferência
        const transferModal     = document.getElementById('transferModal');
        const transferModalClose= transferModal.querySelector('.close');
        const currentOwner      = document.getElementById('currentOwner');
        const transferCodeInput = document.getElementById('transferCode');
        const searchProfBtn     = document.getElementById('searchProfBtn');
        const searchResults     = document.getElementById('searchResults');
        const transferForm      = document.getElementById('transferForm');
        const confirmTransferBtn= document.getElementById('confirmTransferBtn');
        const cancelTransferBtn = document.getElementById('cancelTransfer');

        // FUNÇÃO PARA EXIBIR MENSAGENS
        function showMessage(msg, isError=false){
            statusMessage.textContent = msg;
            statusMessage.classList.remove('status-error');
            if(isError) statusMessage.classList.add('status-error');
            statusMessage.style.display='block';
            setTimeout(()=>{ statusMessage.style.display='none'; }, 3000);
        }

        // OBTÉM TODAS AS LINHAS
        function getAllRows(){
            return Array.from(tableBody.querySelectorAll('tr'));
        }

        // FILTROS
        function applyFilters(){
            const nameVal   = filterName.value.toLowerCase().trim();
            const adminVal  = filterAdmin.value.toLowerCase().trim();
            const statusVal = filterStatus.value.trim();

            const rows = getAllRows();
            rows.forEach(row=>{
                const cells = row.querySelectorAll('td');
                const clinicName  = cells[1].textContent.toLowerCase();
                const adminName   = cells[2].textContent.toLowerCase();
                const stat        = cells[3].textContent.trim();
                
                const matchName   = !nameVal   || clinicName.includes(nameVal);
                const matchAdmin  = !adminVal  || adminName.includes(adminVal);
                const matchStat   = !statusVal || stat===statusVal;
                
                row.style.display = (matchName && matchAdmin && matchStat)?'':'none';
            });
        }
        applyFiltersBtn.onclick = applyFilters;

        // FECHAR O MODAL DE TRANSFERÊNCIA
        function closeTransferModal(){
            transferModal.style.display='none';
            transferCodeInput.value='';
            searchResults.innerHTML='';
            searchResults.style.display='none';
            confirmTransferBtn.disabled=true;
        }
        transferModalClose.onclick = closeTransferModal;
        cancelTransferBtn.onclick   = closeTransferModal;

        // ABRIR MODAL QUANDO CLICA NO ÍCONE DE TRANSFERIR
        document.body.addEventListener('click', (e)=>{
            if(e.target.closest('.btn-transfer')){
                const btn = e.target.closest('.btn-transfer');
                const row = btn.closest('tr');
                if(!row) return;
                const cells = row.querySelectorAll('td');
                
                const clinicData = {
                    id   : cells[0].textContent,
                    name : cells[1].textContent,
                    status: cells[3].textContent,
                    owner: btn.getAttribute('data-owner') || 'Desconhecido'
                };
                
                // Exibir no modal
                transferModal.style.display='flex';
                currentOwner.textContent = clinicData.owner;

                // Preencher as informações da clínica no modal
                document.getElementById('clinicId').textContent = clinicData.id;
                document.getElementById('clinicName').textContent = clinicData.name;
                document.getElementById('clinicStatus').textContent = clinicData.status;
                
                // Armazenar ID da clínica no form (poderia usar data-attribute)
                transferForm.setAttribute('data-clinic-id', clinicData.id);
            }
        });

        // BOTÃO "PESQUISAR" PROFISSIONAL
        searchProfBtn.addEventListener('click', ()=>{
            const code = transferCodeInput.value.trim().toUpperCase();
            if(!code){
                showMessage('Digite o código do novo profissional!', true);
                return;
            }
            // Exemplo fictício de busca
            const found = fakeSearchProfessional(code);
            if(found){
                searchResults.innerHTML=`
                    <p><strong>Nome:</strong> ${found.name}</p>
                    <p><strong>E-mail:</strong> ${found.email}</p>
                    <p><strong>Formação:</strong> ${found.job}</p>
                    <p><strong>Registro Profissional:</strong> ${found.registration}</p>
                `;
                searchResults.style.display='block';
                confirmTransferBtn.disabled=false;
            } else {
                searchResults.innerHTML='<p style="color:#E53E3E;">Profissional não encontrado.</p>';
                searchResults.style.display='block';
                confirmTransferBtn.disabled=true;
            }
        });

        // SUBMISSÃO DO FORM DE TRANSFERÊNCIA
        transferForm.addEventListener('submit', (e)=>{
            e.preventDefault();
            const code = transferCodeInput.value.trim().toUpperCase();
            if(!code){
                showMessage('Nenhum profissional selecionado.', true);
                return;
            }
            const professional = fakeSearchProfessional(code);
            if(!professional){
                showMessage('Profissional não encontrado.', true);
                return;
            }
            const clinicId = transferForm.getAttribute('data-clinic-id');
            // Simular a transferência
            showMessage(`Clínica ${clinicId} transferida com sucesso para o profissional ${professional.name}!`);
            closeTransferModal();
            
            // Atualizar a tabela (coluna 3 -> Administrador)
            const rows = getAllRows();
            const row = rows.find(r => r.querySelector('td').textContent===clinicId);
            if(row){
                row.querySelectorAll('td')[2].textContent = professional.name;
                // Atualizar atributo data-owner para o novo administrador
                const actionBtn = row.querySelector('.btn-transfer');
                if(actionBtn){
                    actionBtn.setAttribute('data-owner', professional.name);
                }
            }
        });

        // SIMULA BUSCA DE PROFISSIONAL
        function fakeSearchProfessional(code){
            // Tabela fictícia
            const sampleProfs = [
                {code:'PRF001', name:'Mariana Santos', email:'mariana.santos@exemplo.com', job:'Fonoaudióloga', registration:'CRFa 12345'},
                {code:'PRF002', name:'Pedro Oliveira', email:'pedro.oliveira@exemplo.com', job:'Psicólogo', registration:'CRP 67890'},
                {code:'PRF003', name:'Ana Luiza', email:'ana.luiza@exemplo.com', job:'Nutricionista', registration:'CRN 54321'},
                {code:'PRF004', name:'Lucas Almeida', email:'lucas.almeida@exemplo.com', job:'Fisioterapeuta', registration:'CRF 98765'},
                {code:'PRF005', name:'Bruna Amaral', email:'bruna.amaral@exemplo.com', job:'Terapeuta Ocupacional', registration:'CRO 11223'},
            ];
            return sampleProfs.find(p=>p.code===code) || null;
        }

        // FECHAR O MODAL AO CLICAR FORA
        window.onclick=(e)=>{
            if(e.target===transferModal){
                closeTransferModal();
            }
        };
    </script>
</body>
</html>
