<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Super Admin - Gestão de Clínicas</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        
        /* Main Content */
        .content {
            margin-top: 60px;
            margin-left: 220px;
            padding: 20px;
            flex: 1;
        }
        .header-content {
            margin-bottom: 20px;
        }
        .header-content h1 {
            color: #08C89E;
        }
        .metrics {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 30px;
        }
        .metric-card {
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 20px;
            flex: 1 1 200px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            text-align: center;
        }
        .metric-card h2 {
            margin: 0;
            font-size: 24px;
            color: #234EA1;
        }
        .metric-card p {
            margin: 5px 0 0;
            font-size: 14px;
            color: #4a5568;
        }
        .charts {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 30px;
        }
        .chart-container {
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 20px;
            flex: 1 1 400px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .activities {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }
        .activity-section {
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 20px;
            flex: 1 1 400px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            max-height: 400px;
            overflow-y: auto;
        }
        .activity-section h3 {
            margin-top: 0;
            color: #234EA1;
            margin-bottom: 15px;
        }
        .activity-item {
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #e2e8f0;
        }
        .activity-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .activity-item p {
            margin: 0;
            font-size: 14px;
            color: #4a5568;
        }
        /* Alert */
        .alert {
            background: #48BB78;
            color: #fff;
            padding: 10px 15px;
            border-radius: 8px;
            position: fixed;
            top: 80px; right: 20px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.2);
            display: none;
            animation: fadeIn 0.3s ease-in-out;
            z-index: 10000;
        }
        .alert.error { background: #E53E3E; }
        /* Modal */
        .modal-overlay {
            display: none;
            position: fixed;
            top:0; left:0; right:0; bottom:0;
            background: rgba(0,0,0,0.5);
            z-index: 10000;
            justify-content: center;
            align-items: center;
        }
        .modal-container {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            width: 90%;
            max-width: 800px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            animation: fadeIn 0.3s ease-in-out;
            max-height: 90vh;
            overflow-y: auto;
        }
        .modal-container h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: 10px;
        }
        .modal-container .close-modal {
            position: absolute;
            right: 20px;
            top: 20px;
            font-size: 24px;
            cursor: pointer;
            color: #aaa;
        }
        .modal-container .close-modal:hover { color: #333; }
        /* Gráficos */
        canvas {
            width: 100% !important;
            height: 300px !important;
        }
        @keyframes fadeIn {
            from {opacity:0; transform:translateY(-10px);}
            to {opacity:1; transform:translateY(0);}
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin.phps'; ?>
    
    <aside class="sidebar" style="width: 220px; height: 100vh; background-color: #ffffff; border-right: 1px solid #e2e8f0; position: fixed; top: 50px; left: 0; padding: 1rem 1rem; display: flex; flex-direction: column; justify-content: space-between; overflow: hidden; box-sizing: border-box;">
    <div class="profile" style="text-align: center; margin-bottom: 1.5rem;">
        <img src="https://api.dicebear.com/6.x/pixel-art/svg?seed=superadmin" alt="Avatar" style="width: 70px; height: 70px; border-radius: 50%; border: 3px solid #08C89E;">
        <h3 style="margin-top: 8px; font-size: 16px; color: #2d3748; margin-bottom: 4px;">Super Admin</h3>
        <p class="profile-title" style="margin: 0; font-size: 14px; color: #4a5568;">Administrador do Sistema</p>
        <small style="display: inline-block; background-color: #08C89E; color: #fff; padding: 3px 8px; border-radius: 10px; font-size: 11px; margin-top: 4px;">superadmin@ifcora.com</small>
    </div>
    <div><hr /></div>
    <nav class="menu" style="margin-top: 20px; flex-grow: 1; overflow-y: auto;">
        <a href="painel-superadmin-dashboard.php" class="active" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #2d3748; margin-bottom: 8px; background-color: #e6fffa; color: #08C89E;">
            <i class="fas fa-tachometer-alt" style="margin-right: 12px; font-size: 16px;"></i>Dashboard
        </a>
        <a href="painel-superadmin-clinicas.php" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #2d3748; margin-bottom: 8px;">
            <i class="fas fa-clinic-medical" style="margin-right: 12px; font-size: 16px;"></i>Clínicas
        </a>
        <a href="painel-superadmin-usuarios.php" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #2d3748; margin-bottom: 8px;">
            <i class="fas fa-users" style="margin-right: 12px; font-size: 16px;"></i>Usuários
        </a>
        <a href="painel-superadmin-pacientes.php" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #2d3748; margin-bottom: 8px;">
            <i class="fas fa-child" style="margin-right: 12px; font-size: 16px;"></i>Pacientes
        </a>
        <a href="painel-superadmin-financeiro.php" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #2d3748; margin-bottom: 8px;">
            <i class="fas fa-file-invoice-dollar" style="margin-right: 12px; font-size: 16px;"></i>Financeiro
        </a>
        <a href="painel-superadmin-suporte.php" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #2d3748; margin-bottom: 8px;">
            <i class="fas fa-shield-alt" style="margin-right: 12px; font-size: 16px;"></i>Suporte
        </a>
    </nav>
    <div class="logout" style="margin-bottom: 50px;">
        <a href="login.php" style="font-size: 15px; display: flex; align-items: center; padding: 10px 15px; border-radius: 6px; transition: background 0.3s, color 0.3s; color: #e53e3e;">
            <i class="fas fa-sign-out-alt" style="margin-right: 12px; font-size: 16px;"></i>Sair
        </a>
    </div>
</aside>

    


    <!-- Main Content -->
    <main class="content">
        <div class="header-content">
            <h1>Dashboard Financeiro</h1>
        </div>
        
        <!-- Resumo de Métricas -->
        <div class="metrics">
            <div class="metric-card">
                <h2 id="totalClinics">0</h2>
                <p>Total de Clínicas</p>
            </div>
            <div class="metric-card">
                <h2 id="activeEnterprisePlans">0</h2>
                <p>Planos Enterprise Ativos</p>
            </div>
            <div class="metric-card">
                <h2 id="totalInvoices">0</h2>
                <p>Total de Faturas</p>
            </div>
            <div class="metric-card">
                <h2 id="pendingInvoices">0</h2>
                <p>Faturas Pendentes</p>
            </div>
        </div>

        <!-- Gráficos -->
        <div class="charts">
            <div class="chart-container">
                <h3>Faturamento Mensal</h3>
                <canvas id="monthlyRevenueChart"></canvas>
            </div>
            <div class="chart-container">
                <h3>Status de Pagamento das Faturas</h3>
                <canvas id="paymentStatusChart"></canvas>
            </div>
        </div>

        <!-- Atividades Recentes -->
        <div class="activities">
            <div class="activity-section">
                <h3>Últimas Faturas Geradas</h3>
                <div id="recentInvoices">
                    <!-- Itens de atividades serão preenchidos via JS -->
                </div>
            </div>
            <div class="activity-section">
                <h3>Últimas Clínicas Adicionadas</h3>
                <div id="recentClinics">
                    <!-- Itens de atividades serão preenchidos via JS -->
                </div>
            </div>
        </div>
    </main>

    <!-- Alert -->
    <div class="alert" id="alertBox"></div>

    <!-- Script JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Dados Simulados
        let clinics = [
            {id:'CL001', name:'Clínica Sertãozinho', children:50, status:'Em Dia', dataCadastro:'2023-01-15'},
            {id:'CL002', name:'Clínica Central', children:162, status:'Atrasado', dataCadastro:'2023-02-20'},
            {id:'CL003', name:'Clínica do Norte', children:9, status:'Em Dia', dataCadastro:'2023-03-10'},
            {id:'CL004', name:'Clínica Sul', children:15, status:'Em Dia', dataCadastro:'2023-04-05'},
            {id:'CL005', name:'Clínica Leste', children:100, status:'Atrasado', dataCadastro:'2023-05-22'}
        ];

        let enterprisePlans = [
            {id:'P001', name:'Enterprise Gold', description:'Plano personalizado gold', value:1000.00, childrenLimit:150, clinics:['CL002']},
            {id:'P002', name:'Enterprise Platinum', description:'Plano top', value:2000.00, childrenLimit:200, clinics:[]}
        ];

        // Faturas: {id, clinicId, mes:'2023-01', valor, validade:'2023-12-31', dataCriacao: '2023-01-05', status:'Aberta', dataPagamento: '2023-01-10'}
        let invoices = [
            {id:'F001', clinicId:'CL001', mes:'2023-02', valor:200+(40*5), validade:'2023-12-31', dataCriacao:'2023-02-01', status:'Aberta', dataPagamento:''},
            {id:'F002', clinicId:'CL002', mes:'2023-02', valor:200+(152*5), validade:'2023-12-31', dataCriacao:'2023-02-01', status:'Paga', dataPagamento:'2023-02-05'},
            {id:'F003', clinicId:'CL005', mes:'2023-01', valor:200+(90*5), validade:'2023-11-30', dataCriacao:'2023-01-01', status:'Vencida', dataPagamento:''}
        ];

        // Histórico Mensal: [ {clinicId, mes:'2023-01', children: X, valorPago: Y}, ...]
        let monthlyHistory = [
            {clinicId:'CL001', mes:'2023-01', children:48, valorPago: 200+(38*5)},
            {clinicId:'CL001', mes:'2023-02', children:50, valorPago: 200+(40*5)},
            {clinicId:'CL002', mes:'2023-01', children:160, valorPago:0}, 
            {clinicId:'CL002', mes:'2023-02', children:162, valorPago:200+(152*5)},
            {clinicId:'CL005', mes:'2023-01', children:100, valorPago:200+(90*5)}
        ];

        // Estado
        let currentSort = {column:null, asc:true};
        let currentPage = 1;
        const perPage = 5;

        // Elementos do Alert
        const alertBox = document.getElementById('alertBox');
        function showAlert(msg, type) {
            alertBox.textContent = msg;
            alertBox.classList.remove('error');
            if(type === 'error') {
                alertBox.classList.add('error');
            }
            alertBox.style.display = 'block';
            setTimeout(()=>{
                alertBox.style.display = 'none';
            },3000);
        }

        // Função para Renderizar Métricas
        function renderMetrics() {
            document.getElementById('totalClinics').textContent = clinics.length;
            document.getElementById('activeEnterprisePlans').textContent = enterprisePlans.length;
            document.getElementById('totalInvoices').textContent = invoices.length;
            const pending = invoices.filter(inv => inv.status !== 'Paga').length;
            document.getElementById('pendingInvoices').textContent = pending;
        }

        // Função para Renderizar Gráfico de Faturamento Mensal
        function renderMonthlyRevenueChart() {
            const ctx = document.getElementById('monthlyRevenueChart').getContext('2d');
            // Agregar faturamento por mês
            let revenueByMonth = {};
            invoices.forEach(inv => {
                if(!revenueByMonth[inv.mes]) {
                    revenueByMonth[inv.mes] = 0;
                }
                revenueByMonth[inv.mes] += inv.valor;
            });
            // Ordenar por mês
            const sortedMonths = Object.keys(revenueByMonth).sort((a, b) => {
                const [monthA, yearA] = a.split('/').map(Number);
                const [monthB, yearB] = b.split('/').map(Number);
                return yearA === yearB ? monthA - monthB : yearA - yearB;
            });
            const labels = sortedMonths;
            const data = sortedMonths.map(m => revenueByMonth[m]);

            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Faturamento (R$)',
                        data: data,
                        backgroundColor: '#234EA1'
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false },
                        tooltip: { mode: 'index', intersect: false },
                    },
                    interaction: {
                        mode: 'nearest',
                        intersect: false
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }

        // Função para Renderizar Gráfico de Status de Pagamento das Faturas
        function renderPaymentStatusChart() {
            const ctx = document.getElementById('paymentStatusChart').getContext('2d');
            const statusCounts = {};
            invoices.forEach(inv => {
                if(!statusCounts[inv.status]) {
                    statusCounts[inv.status] = 0;
                }
                statusCounts[inv.status]++;
            });
            const labels = Object.keys(statusCounts);
            const data = Object.values(statusCounts);
            const backgroundColors = [
                '#48BB78', // Em Dia
                '#E53E3E', // Atrasado
                '#ED8936', // Vencida
                '#4299E1'  // Paga
            ];

            new Chart(ctx, {
                type: 'pie',
                data: {
                    labels: labels,
                    datasets: [{
                        data: data,
                        backgroundColor: backgroundColors.slice(0, labels.length)
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { position: 'top' },
                        tooltip: { mode: 'index', intersect: false },
                    }
                }
            });
        }

        // Função para Renderizar Atividades Recentes
        function renderRecentActivities() {
            const recentInvoicesDiv = document.getElementById('recentInvoices');
            const recentClinicsDiv = document.getElementById('recentClinics');

            // Ordenar faturas por data de criação descendente
            const sortedInvoices = invoices.slice().sort((a, b) => new Date(b.dataCriacao) - new Date(a.dataCriacao));
            const recentInvoices = sortedInvoices.slice(0, 5);
            recentInvoicesDiv.innerHTML = '';
            recentInvoices.forEach(inv => {
                const clinic = clinics.find(c => c.id === inv.clinicId);
                const div = document.createElement('div');
                div.classList.add('activity-item');
                div.innerHTML = `
                    <p><strong>${inv.id}</strong> gerada para <strong>${clinic ? clinic.name : 'Clínica Desconhecida'}</strong> no mês de <strong>${inv.mes}</strong>.</p>
                    <p>Valor: R$ ${inv.valor.toFixed(2)} - Status: ${inv.status}</p>
                `;
                recentInvoicesDiv.appendChild(div);
            });

            // Ordenar clínicas por data de cadastro descendente
            const sortedClinics = clinics.slice().sort((a, b) => new Date(b.dataCadastro) - new Date(a.dataCadastro));
            const recentClinics = sortedClinics.slice(0, 5);
            recentClinicsDiv.innerHTML = '';
            recentClinics.forEach(c => {
                const div = document.createElement('div');
                div.classList.add('activity-item');
                div.innerHTML = `
                    <p><strong>${c.id}</strong> - <strong>${c.name}</strong> adicionada em <strong>${c.dataCadastro}</strong>.</p>
                    <p>Crianças Cadastradas: ${c.children} - Status: ${c.status}</p>
                `;
                recentClinicsDiv.appendChild(div);
            });
        }

        // Função para Renderizar Todas as Funcionalidades do Dashboard
        function renderDashboard() {
            renderMetrics();
            renderMonthlyRevenueChart();
            renderPaymentStatusChart();
            renderRecentActivities();
        }

        // Inicialização
        function init() {
            renderDashboard();
        }

        init();
    </script>
</body>
</html>
