<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Super Admin - Gestão de Usuários</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        
        /* Main Content */
        
        .filters, .bulk-actions {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }
        .filters select, .filters input, .form-group input, .form-group select {
            padding: 8px 12px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            width: 250px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            text-align: left;
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 14px;
        }
        th {
            background: #f7fafc;
            color: #2d3748;
            cursor: pointer;
        }
        tr:hover {
            background: #f1f5f9;
        }
        .pagination {
            margin-top: 20px;
            display: flex;
            gap: 10px;
        }
        .pagination button {
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 5px;
            padding: 5px 10px;
            cursor: pointer;
        }
        .pagination button.active {
            background: #08C89E;
            color: #fff;
        }
        .btn-action {
            padding: 5px 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 12px;
            margin: 0 5px;
        }
        .btn-fatura { background-color: #08C89E; color: #fff; }
        .btn-suspender { background-color: #E53E3E; color: #fff; }
        .btn-detalhes { background-color: #F6AD55; color: #fff; }
        .btn-enterprise { background-color: #234EA1; color: #fff; }
        .btn-edit { background-color: #F6AD55; color: #fff; }
        .btn-delete { background-color: #E53E3E; color: #fff; }
        .btn-history { background-color: #2d3748; color: #fff; }
        .btn.save { background-color: #234EA1; color: #fff; border-radius: 8px; }
        .alert {
            background: #48BB78;
            color: #fff;
            padding: 10px 15px;
            border-radius: 8px;
            position: fixed;
            top: 80px; right: 20px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.2);
            display: none;
            animation: fadeIn 0.3s ease-in-out;
            z-index: 10000;
        }
        .alert.error { background: #E53E3E; }
        /* Modal */
        .modal-overlay {
            display: none;
            position: fixed;
            top:0; left:0; right:0; bottom:0;
            background: rgba(0,0,0,0.5);
            z-index: 10000;
            justify-content: center;
            align-items: center;
        }
        .modal-container {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            width: 90%;
            max-width: 800px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            position: relative;
            animation: fadeIn 0.3s ease-in-out;
            max-height: 90vh;
            overflow-y: auto;
        }
        .modal-container h2 {
            font-size: 20px;
            color: #08C89E;
            margin-bottom: 10px;
        }
        .modal-container .close-modal {
            position: absolute;
            right: 20px;
            top: 20px;
            font-size: 24px;
            cursor: pointer;
            color: #aaa;
        }
        .modal-container .close-modal:hover { color: #333; }
        .info-box {
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .info-box h3 {
            font-size: 18px;
            color: #2d3748;
            margin-top: -5px;
            margin-bottom: 10px;
        }
        .info-box p {
            font-size: 14px;
            margin-bottom: 5px;
        }
        .tabs {
            display: flex;
            gap: 5px;
            border-bottom: 1px solid #e2e8f0;
            margin-bottom: 20px;
        }
        .tab {
            padding: 10px 20px;
            cursor: pointer;
            font-size: 14px;
            background: #f7fafc;
            color: #2d3748;
            border-top-left-radius: 6px;
            border-top-right-radius: 6px;
        }
        .tab.active {
            background: #08C89E;
            color: #fff;
            font-weight: 600;
            border-bottom: 2px solid #08C89E;
        }
        .tab-content {
            display: none;
        }
        .tab-content.active { display: block; }
        .form-group { margin-bottom: 15px; }
        .form-group label {
            display: block;
            font-size: 14px;
            margin-bottom: 5px;
            color: #4a5568;
        }
        .enterprise-actions, .invoice-actions {
            display: flex;
            gap: 10px;
            margin-bottom: 15px;
        }
        .clinic-actions {
            margin-top: 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        .multiselect-container {
            max-height: 150px;
            overflow: auto;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 10px;
        }
        .multiselect-container label { display: block; margin-bottom: 5px; }
        /* Dashboard */
        .dashboard {
            padding: 20px;
            display: none;
        }
        .dashboard h3 { color: #2d3748; margin-bottom: 10px; }
        .dashboard .section { margin-bottom: 20px; }
        .dashboard table {
            width: 100%;
            border-collapse: collapse;
        }
        .dashboard th, .dashboard td {
            text-align: left;
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 14px;
        }
        .dashboard th { background: #f7fafc; color: #2d3748; }
        @keyframes fadeIn {
            from {opacity:0; transform:translateY(-10px);}
            to {opacity:1; transform:translateY(0);}
        }
        .partnership-management {
            background-color: #FFFFFF;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin-financeiro.php'; ?>

    <!-- Main Content -->
    <main class="content">
        <div class="header-content">
            <h1 style="color:#08C89E;">Gestão Financeira</h1>
        </div>

            <!-- Abas -->
        <div class="tabs-container">    
            <div class="tabs">
                <div class="tab active" data-tab="standardBilling">Cobrança Padrão</div>
                <div class="tab" data-tab="enterprisePlans">Planos Enterprise</div>
                <div class="tab" data-tab="invoicesHistory">Raio-X</div>
            </div>
    
            <!-- Aba Cobrança Padrão -->
            <div id="standardBilling" class="tab-content active">
                <div class="info-box">
                    <h3>Modelo de Cobrança Padrão</h3>
                    <p><b>Valor Fixo Mensal:</b> R$ 200,00 (até 10 crianças)</p>
                    <p><b>Excedente (11 a 100 crianças):</b> R$ 5,00/mês por criança</p>
                    <p><b>Planos Enterprise:</b> Clínicas com mais de 100 crianças podem optar por planos personalizados.</p>
                </div>
    
                <div class="filters">
                    <input type="text" id="filterClinicName" placeholder="Pesquisar por Nome ou Código da Clínica">
                    <select id="filterPaymentStatus">
                        <option value="">Status Pagamento</option>
                        <option value="Em Dia">Em Dia</option>
                        <option value="Atrasado">Atrasado</option>
                    </select>
                    <button class="btn save" id="applyFilters">Aplicar Filtros</button>
                </div>
    
                <table id="clinicsTable">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Clínica</th>
                            <th>Crianças</th>
                            <th>Excedente</th>
                            <th>Plano</th>
                            <th>Status Pgto</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
    
                <div class="pagination" id="pagination"></div>
            </div>
    
            <!-- Aba Planos Enterprise -->
            <div id="enterprisePlans" class="tab-content">
                <p style="margin-bottom:20px;">Gerencie planos Enterprise, defina limites de crianças e associe-os a múltiplas clínicas.</p>
    
                <div class="enterprise-actions">
                    <button class="btn-action btn-enterprise" id="openCreatePlanModal">Criar Novo Plano Enterprise</button>
                </div>
    
                <table id="enterprisePlansTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nome do Plano</th>
                            <th>Descrição</th>
                            <th>Valor Mensal Base</th>
                            <th>Limite de Crianças</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
    
            <!-- Aba Faturas e Histórico -->
            <div id="invoicesHistory" class="tab-content">
                <p style="margin-bottom:20px;">Visualize o histórico de faturas e eventos das clínicas através de dashboards detalhados.</p>
    
                <div class="filters">
                    <input type="text" id="searchClinicCode" placeholder="Digite o Código da Clínica">
                    <button class="btn save" id="openClinicDashboard">Abrir Dashboard</button>
                </div>
    
                <!-- Dashboard da Clínica -->
                <div id="clinicDashboard" class="dashboard">
                    <h3>Dashboard da Clínica <span id="dashboardClinicName"></span></h3>
    
                    <div class="section">
                        <h4>Histórico de Faturas</h4>
                        <table id="dashboardInvoicesTable">
                            <thead>
                                <tr>
                                    <th>ID Fatura</th>
                                    <th>Valor</th>
                                    <th>Data de Criação</th>
                                    <th>Status</th>
                                    <th>Data de Pagamento</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
    
                    <div class="section">
                        <h4>Histórico de Pacientes</h4>
                        <table id="dashboardPatientsTable">
                            <thead>
                                <tr>
                                    <th>ID Paciente</th>
                                    <th>Nome</th>
                                    <th>Data de Cadastro</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
    
                    <div class="section">
                        <h4>Profissionais Associados</h4>
                        <table id="dashboardProfessionalsTable">
                            <thead>
                                <tr>
                                    <th>ID Profissional</th>
                                    <th>Nome</th>
                                    <th>Especialidade</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        
        </div>
    </main>

    <!-- Modal Detalhes Financeiros da Clínica -->
    <div class="modal-overlay" id="clinicModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeClinicModal">&times;</span>
            <h2>Detalhes Financeiros da Clínica</h2>
            <p><b>Código:</b> <span id="modalClinicId"></span></p>
            <p><b>Nome:</b> <span id="modalClinicName"></span></p>
            <p><b>Crianças Cadastradas:</b> <span id="modalClinicChildren"></span></p>
            <p><b>Excedentes:</b> <span id="modalClinicExcedentes"></span></p>
            <p><b>Plano:</b> <span id="modalClinicPlan"></span></p>
            <p><b>Valor Fixo:</b> R$ 200,00</p>
            <p><b>Valor Excedentes:</b> <span id="modalClinicExcedentesValor"></span></p>
            <p><b>Total Mensal:</b> <span id="modalClinicTotal"></span></p>
            <p><b>Status Pagamento:</b> <span id="modalClinicStatus"></span></p>

            <div class="clinic-actions">
                <button class="btn-action btn-fatura" id="modalGenerateInvoiceBtn">Gerar Fatura</button>
                <button class="btn-action btn-suspender" id="modalSuspendBtn">Suspender</button>
                <button class="btn-action btn-history" id="modalInvoiceHistoryBtn">Histórico de Faturas</button>
            </div>
        </div>
    </div>

    <!-- Modal Histórico de Faturas da Clínica -->
    <div class="modal-overlay" id="invoiceHistoryModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeInvoiceHistoryModal">&times;</span>
            <h2>Histórico de Faturas</h2>
            <p><b>Clínica:</b> <span id="invoiceHistoryClinicName"></span></p>
            <table style="margin-top:10px;width:100%;" id="invoiceHistoryTable">
                <thead>
                    <tr>
                        <th>ID Fatura</th>
                        <th>Valor</th>
                        <th>Data de Criação</th>
                        <th>Status</th>
                        <th>Data de Pagamento</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            <div class="clinic-actions" style="margin-top:20px;">
                <button class="btn-action btn-fatura" id="generateUpdatedInvoiceBtn">Gerar Nova Fatura Atualizada</button>
            </div>
        </div>
    </div>

    <!-- Modal Criar/Editar Plano Enterprise -->
    <div class="modal-overlay" id="planModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closePlanModal">&times;</span>
            <h2 id="planModalTitle">Criar Plano Enterprise</h2>
            <form id="planForm">
                <input type="hidden" id="planId">
                <div class="form-group">
                    <label for="planName">Nome do Plano</label>
                    <input type="text" id="planName" required>
                </div>
                <div class="form-group">
                    <label for="planDescription">Descrição</label>
                    <input type="text" id="planDescription">
                </div>
                <div class="form-group">
                    <label for="planValue">Valor Mensal Base (R$)</label>
                    <input type="number" id="planValue" min="0" step="0.01" required>
                </div>
                <div class="form-group">
                    <label for="planChildrenLimit">Limite de Crianças</label>
                    <input type="number" id="planChildrenLimit" min="0" step="1" required>
                </div>
                <button type="submit" class="btn-action btn-enterprise">Salvar</button>
            </form>
        </div>
    </div>

    <!-- Modal Atribuir Plano a Múltiplas Clínicas -->
    <div class="modal-overlay" id="assignMultiClinicModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeAssignMultiClinicModal">&times;</span>
            <h2>Atribuir Plano a Múltiplas Clínicas</h2>
            <p><b>Plano:</b> <span id="assignMultiPlanName"></span></p>
            <div class="form-group">
                <label for="searchAssignClinic">Pesquisar Clínica (Nome ou Código)</label>
                <input type="text" id="searchAssignClinic" placeholder="Digite o Nome ou Código">
            </div>
            <div class="multiselect-container" id="multiClinicContainer">
                <!-- Checkboxes de clínicas serão preenchidos via JS -->
            </div>
            <button class="btn-action btn-enterprise" id="assignMultipleClinicsBtn">Atribuir</button>
        </div>
    </div>

    <!-- Modal Editar Validade da Fatura -->
    <div class="modal-overlay" id="editInvoiceModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeEditInvoiceModal">&times;</span>
            <h2>Editar Validade da Fatura</h2>
            <p><b>ID Fatura:</b> <span id="editInvoiceId"></span></p>
            <div class="form-group">
                <label for="editInvoiceDate">Nova Data de Validade</label>
                <input type="date" id="editInvoiceDate" required>
            </div>
            <button class="btn-action btn-edit" id="saveInvoiceDateBtn">Salvar</button>
        </div>
    </div>

    <!-- Modal Confirmar Exclusão de Fatura -->
    <div class="modal-overlay" id="deleteInvoiceModalOverlay">
        <div class="modal-container">
            <span class="close-modal" id="closeDeleteInvoiceModal">&times;</span>
            <h2>Excluir Fatura</h2>
            <p>Tem certeza que deseja excluir a fatura <b id="deleteInvoiceId"></b>?</p>
            <button class="btn-action btn-delete" id="confirmDeleteInvoiceBtn">Excluir</button>
        </div>
    </div>

    <!-- Alert -->
    <div class="alert" id="alertBox"></div>

    <!-- Script JavaScript -->
    <script>
        // Dados Simulados
        let clinics = [
            {id:'CL001', name:'Clínica Sertãozinho', children:50, status:'Em Dia'},
            {id:'CL002', name:'Clínica Central', children:162, status:'Atrasado'},
            {id:'CL003', name:'Clínica do Norte', children:9, status:'Em Dia'},
            {id:'CL004', name:'Clínica Sul', children:15, status:'Em Dia'},
            {id:'CL005', name:'Clínica Leste', children:100, status:'Atrasado'}
        ];

        let enterprisePlans = [
            {id:'P001', name:'Enterprise Gold', description:'Plano personalizado gold', value:1000.00, childrenLimit:150, clinics:['CL002']},
            {id:'P002', name:'Enterprise Platinum', description:'Plano top', value:2000.00, childrenLimit:200, clinics:[]}
        ];

        // Histórico Mensal: [ {clinicId, mes:'2023-01', children: X, valorPago: Y}, ...]
        let monthlyHistory = [
            {clinicId:'CL001', mes:'2023-01', children:48, valorPago: 200+(38*5)},
            {clinicId:'CL001', mes:'2023-02', children:50, valorPago: 200+(40*5)},
            {clinicId:'CL002', mes:'2023-01', children:160, valorPago:0}, 
            {clinicId:'CL002', mes:'2023-02', children:162, valorPago:200+(152*5)},
            {clinicId:'CL005', mes:'2023-01', children:100, valorPago:200+(90*5)}
        ];

        // Faturas: {id, clinicId, mes:'2023-01', valor, validade:'2023-12-31', dataCriacao: '2023-01-05', status:'Aberta', dataPagamento: '2023-01-10'}
        let invoices = [
            {id:'F001', clinicId:'CL001', mes:'2023-02', valor:200+(40*5), validade:'2023-12-31', dataCriacao:'2023-02-01', status:'Aberta', dataPagamento:''},
            {id:'F002', clinicId:'CL002', mes:'2023-02', valor:200+(152*5), validade:'2023-12-31', dataCriacao:'2023-02-01', status:'Paga', dataPagamento:'2023-02-05'},
            {id:'F003', clinicId:'CL005', mes:'2023-01', valor:200+(90*5), validade:'2023-11-30', dataCriacao:'2023-01-01', status:'Vencida', dataPagamento:''}
        ];

        // Estado
        let currentSort = {column:null, asc:true};
        let currentPage = 1;
        const perPage = 5;
        let currentInvoiceId = null;
        let currentAssignPlanId = null;
        let currentHistoryClinicId = null;

        // Elementos do Alert
        const alertBox = document.getElementById('alertBox');
        function showAlert(msg, type) {
            alertBox.textContent = msg;
            alertBox.classList.remove('error');
            if(type === 'error') {
                alertBox.classList.add('error');
            }
            alertBox.style.display = 'block';
            setTimeout(()=>{
                alertBox.style.display = 'none';
            },3000);
        }

        // Tabs
        const tabs = document.querySelectorAll('.tab');
        const tabContents = document.querySelectorAll('.tab-content');
        tabs.forEach(tab=>{
            tab.addEventListener('click', ()=>{
                tabs.forEach(t=>t.classList.remove('active'));
                tabContents.forEach(c=>c.classList.remove('active'));
                tab.classList.add('active');
                document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
            });
        });

        // --- Cobrança Padrão ---
        const clinicsTableBody = document.querySelector('#clinicsTable tbody');
        const applyFiltersBtn = document.getElementById('applyFilters');
        const paginationDiv = document.getElementById('pagination');

        applyFiltersBtn.addEventListener('click', ()=>{
            currentPage = 1;
            renderClinics();
        });

        document.querySelectorAll('#clinicsTable th').forEach((th, i)=>{
            th.addEventListener('click', ()=>{
                let columnName;
                switch(i) {
                    case 0: columnName='id'; break;
                    case 1: columnName='name'; break;
                    case 2: columnName='children'; break;
                    case 3: columnName='excedente'; break;
                    case 4: columnName='plan'; break;
                    case 5: columnName='status'; break;
                    default:return;
                }

                if(currentSort.column === columnName) {
                    currentSort.asc = !currentSort.asc;
                } else {
                    currentSort.column = columnName;
                    currentSort.asc = true;
                }
                renderClinics();
            });
        });

        function renderClinics() {
            const nameFilter = document.getElementById('filterClinicName').value.toLowerCase();
            const payStatusFilter = document.getElementById('filterPaymentStatus').value;
            let filtered = clinics.filter(c=>{
                const matchName = c.name.toLowerCase().includes(nameFilter) || c.id.toLowerCase().includes(nameFilter);
                const matchStatus = !payStatusFilter || c.status === payStatusFilter;
                return matchName && matchStatus;
            });

            if(currentSort.column) {
                filtered.sort((a, b)=>{
                    let valA, valB;
                    switch(currentSort.column) {
                        case 'id':
                            valA = a.id.toLowerCase();
                            valB = b.id.toLowerCase();
                            break;
                        case 'name':
                            valA = a.name.toLowerCase();
                            valB = b.name.toLowerCase();
                            break;
                        case 'children':
                            valA = a.children;
                            valB = b.children;
                            break;
                        case 'excedente':
                            valA = (a.children > 10) ? (a.children - 10) : 0;
                            valB = (b.children > 10) ? (b.children - 10) : 0;
                            break;
                        case 'plan':
                            valA = getPlanName(a.id).toLowerCase();
                            valB = getPlanName(b.id).toLowerCase();
                            break;
                        case 'status':
                            valA = a.status.toLowerCase();
                            valB = b.status.toLowerCase();
                            break;
                        default:
                            valA = 0;
                            valB = 0;
                    }

                    if(valA < valB) return currentSort.asc ? -1 : 1;
                    if(valA > valB) return currentSort.asc ? 1 : -1;
                    return 0;
                });
            }

            const total = filtered.length;
            const totalPages = Math.ceil(total / perPage);
            if(currentPage > totalPages && totalPages > 0) currentPage = totalPages;
            const start = (currentPage - 1) * perPage;
            const end = start + perPage;
            const pageData = filtered.slice(start, end);

            clinicsTableBody.innerHTML = '';
            pageData.forEach(c=>{
                const excedentes = c.children > 10 ? (c.children - 10) : 0;
                const excedVal = excedentes * 5;
                const totalVal = 200 + excedVal;
                const planName = getPlanName(c.id);
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${c.id}</td>
                    <td>${c.name}</td>
                    <td>${c.children}</td>
                    <td>${excedentes}</td>
                    <td>${planName}</td>
                    <td>${c.status}</td>
                    <td>
                        <button class="btn-action btn-detalhes" data-id="${c.id}">Ver Detalhes</button>
                        <button class="btn-action btn-history" data-id="${c.id}">Histórico de Faturas</button>
                    </td>
                `;
                clinicsTableBody.appendChild(tr);
            });

            renderPagination(totalPages);
        }

        function getPlanName(clinicId) {
            for(let plan of enterprisePlans) {
                if(plan.clinics.includes(clinicId)) {
                    return plan.name;
                }
            }
            return 'Padrão';
        }

        function renderPagination(totalPages) {
            paginationDiv.innerHTML = '';
            for(let i = 1; i <= totalPages; i++) {
                const btn = document.createElement('button');
                btn.textContent = i;
                if(i === currentPage) btn.classList.add('active');
                btn.addEventListener('click', ()=>{
                    currentPage = i;
                    renderClinics();
                });
                paginationDiv.appendChild(btn);
            }
        }

        // Modal Clínica
        const clinicModalOverlay = document.getElementById('clinicModalOverlay');
        const closeClinicModal = document.getElementById('closeClinicModal');
        const modalClinicId = document.getElementById('modalClinicId');
        const modalClinicName = document.getElementById('modalClinicName');
        const modalClinicChildren = document.getElementById('modalClinicChildren');
        const modalClinicExcedentes = document.getElementById('modalClinicExcedentes');
        const modalClinicExcedentesValor = document.getElementById('modalClinicExcedentesValor');
        const modalClinicTotal = document.getElementById('modalClinicTotal');
        const modalClinicStatus = document.getElementById('modalClinicStatus');
        const modalGenerateInvoiceBtn = document.getElementById('modalGenerateInvoiceBtn');
        const modalSuspendBtn = document.getElementById('modalSuspendBtn');
        const modalInvoiceHistoryBtn = document.getElementById('modalInvoiceHistoryBtn');

        document.body.addEventListener('click', (e)=>{
            if(e.target.classList.contains('btn-detalhes')) {
                const id = e.target.dataset.id;
                openClinicModal(id);
            } else if(e.target.classList.contains('btn-history')) {
                const id = e.target.dataset.id;
                openInvoiceHistoryModal(id);
            }
        });

        function openClinicModal(id) {
            const c = clinics.find(x => x.id === id);
            if(!c) return;
            modalClinicId.textContent = c.id;
            modalClinicName.textContent = c.name;
            modalClinicChildren.textContent = c.children;

            const excedentes = c.children > 10 ? (c.children - 10) : 0;
            const excedVal = excedentes * 5;
            modalClinicExcedentes.textContent = excedentes;
            modalClinicExcedentesValor.textContent = `R$ ${excedVal.toFixed(2)}`;
            const totalVal = 200 + excedVal;
            modalClinicTotal.textContent = `R$ ${totalVal.toFixed(2)}`;
            modalClinicStatus.textContent = c.status;

            modalGenerateInvoiceBtn.onclick = ()=>{
                generateInvoiceForClinic(c.id);
                clinicModalOverlay.style.display = 'none';
            };
            modalSuspendBtn.onclick = ()=>{
                c.status = 'Atrasado';
                showAlert(`Clínica ${c.id} suspensa!`, '');
                clinicModalOverlay.style.display = 'none';
                renderClinics();
            };
            modalInvoiceHistoryBtn.onclick = ()=>{
                openInvoiceHistoryModal(c.id);
                clinicModalOverlay.style.display = 'none';
            };

            clinicModalOverlay.style.display = 'flex';
        }

        function generateInvoiceForClinic(clinicId) {
            const c = clinics.find(x => x.id === clinicId);
            if(!c) return;
            const excedentes = c.children > 10 ? (c.children - 10) : 0;
            const excedVal = excedentes * 5;
            const totalVal = 200 + excedVal;
            const newInvoiceId = 'F' + String(invoices.length + 1).padStart(3, '0');
            const currentDate = new Date();
            const mesAno = `${String(currentDate.getMonth()+1).padStart(2,'0')}/${currentDate.getFullYear()}`;
            const validadeDate = new Date(currentDate);
            validadeDate.setMonth(validadeDate.getMonth()+1);
            const validade = validadeDate.toISOString().split('T')[0];
            invoices.push({
                id: newInvoiceId,
                clinicId: clinicId,
                mes: mesAno,
                valor: totalVal,
                validade: validade,
                dataCriacao: currentDate.toISOString().split('T')[0],
                status: 'Aberta',
                dataPagamento: ''
            });
            showAlert(`Nova fatura ${newInvoiceId} gerada para ${c.name}!`, '');
            renderClinics();
        }

        closeClinicModal.addEventListener('click', ()=>{
            clinicModalOverlay.style.display = 'none';
        });

        window.addEventListener('click', (e)=>{
            if(e.target === clinicModalOverlay) {
                clinicModalOverlay.style.display = 'none';
            }
        });

        // Modal Histórico de Faturas da Clínica
        const invoiceHistoryModalOverlay = document.getElementById('invoiceHistoryModalOverlay');
        const closeInvoiceHistoryModal = document.getElementById('closeInvoiceHistoryModal');
        const invoiceHistoryClinicName = document.getElementById('invoiceHistoryClinicName');
        const invoiceHistoryTable = document.getElementById('invoiceHistoryTable').querySelector('tbody');
        const generateUpdatedInvoiceBtn = document.getElementById('generateUpdatedInvoiceBtn');

        function openInvoiceHistoryModal(clinicId) {
            const c = clinics.find(x => x.id === clinicId);
            if(!c) return;
            currentHistoryClinicId = clinicId;
            invoiceHistoryClinicName.textContent = c.name;
            invoiceHistoryTable.innerHTML = '';

            const clinicInvoices = invoices.filter(i => i.clinicId === clinicId);
            clinicInvoices.forEach(inv=>{
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${inv.id}</td>
                    <td>R$ ${inv.valor.toFixed(2)}</td>
                    <td>${inv.dataCriacao}</td>
                    <td>${inv.status}</td>
                    <td>${inv.dataPagamento || '-'}</td>
                `;
                invoiceHistoryTable.appendChild(tr);
            });

            generateUpdatedInvoiceBtn.style.display = 'inline-block';
            generateUpdatedInvoiceBtn.onclick = ()=>{
                generateUpdatedInvoice(clinicId);
            };

            invoiceHistoryModalOverlay.style.display = 'flex';
        }

        function generateUpdatedInvoice(clinicId) {
            const c = clinics.find(x => x.id === clinicId);
            if(!c) return;
            const excedentes = c.children > 10 ? (c.children - 10) : 0;
            const excedVal = excedentes * 5;
            const totalVal = 200 + excedVal;
            const newInvoiceId = 'F' + String(invoices.length + 1).padStart(3, '0');
            const currentDate = new Date();
            const mesAno = `${String(currentDate.getMonth()+1).padStart(2,'0')}/${currentDate.getFullYear()}`;
            const validadeDate = new Date(currentDate);
            validadeDate.setMonth(validadeDate.getMonth()+1);
            const validade = validadeDate.toISOString().split('T')[0];
            invoices.push({
                id: newInvoiceId,
                clinicId: clinicId,
                mes: mesAno,
                valor: totalVal,
                validade: validade,
                dataCriacao: currentDate.toISOString().split('T')[0],
                status: 'Aberta',
                dataPagamento: ''
            });
            showAlert(`Nova fatura ${newInvoiceId} gerada para ${c.name}!`, '');
            openInvoiceHistoryModal(clinicId);
            renderClinics();
        }

        closeInvoiceHistoryModal.addEventListener('click', ()=>{
            invoiceHistoryModalOverlay.style.display = 'none';
        });

        window.addEventListener('click', (e)=>{
            if(e.target === invoiceHistoryModalOverlay) {
                invoiceHistoryModalOverlay.style.display = 'none';
            }
        });

        // --- Planos Enterprise ---
        const enterprisePlansTableBody = document.getElementById('enterprisePlansTable').querySelector('tbody');
        const openCreatePlanModalBtn = document.getElementById('openCreatePlanModal');
        const planModalOverlay = document.getElementById('planModalOverlay');
        const closePlanModalBtn = document.getElementById('closePlanModal');
        const planForm = document.getElementById('planForm');
        const planModalTitle = document.getElementById('planModalTitle');
        const planIdField = document.getElementById('planId');
        const planNameField = document.getElementById('planName');
        const planDescriptionField = document.getElementById('planDescription');
        const planValueField = document.getElementById('planValue');
        const planChildrenLimitField = document.getElementById('planChildrenLimit');

        openCreatePlanModalBtn.addEventListener('click', ()=>{
            openPlanModal();
        });

        function openPlanModal(plan) {
            if(plan) {
                planIdField.value = plan.id;
                planNameField.value = plan.name;
                planDescriptionField.value = plan.description;
                planValueField.value = plan.value;
                planChildrenLimitField.value = plan.childrenLimit;
                planModalTitle.textContent = 'Editar Plano Enterprise';
            } else {
                planIdField.value = '';
                planNameField.value = '';
                planDescriptionField.value = '';
                planValueField.value = '';
                planChildrenLimitField.value = '';
                planModalTitle.textContent = 'Criar Plano Enterprise';
            }
            planModalOverlay.style.display = 'flex';
        }

        closePlanModalBtn.addEventListener('click', ()=>{
            planModalOverlay.style.display = 'none';
        });

        window.addEventListener('click', (e)=>{
            if(e.target === planModalOverlay) {
                planModalOverlay.style.display = 'none';
            }
        });

        planForm.addEventListener('submit', (e)=>{
            e.preventDefault();
            const id = planIdField.value;
            const name = planNameField.value.trim();
            const description = planDescriptionField.value.trim();
            const value = parseFloat(planValueField.value);
            const childrenLimit = parseInt(planChildrenLimitField.value);

            if(!name || isNaN(value) || isNaN(childrenLimit)) {
                showAlert('Preencha os campos obrigatórios corretamente', 'error');
                return;
            }

            if(id) {
                const p = enterprisePlans.find(x => x.id === id);
                if(p) {
                    p.name = name;
                    p.description = description;
                    p.value = value;
                    p.childrenLimit = childrenLimit;
                    showAlert('Plano atualizado com sucesso!', '');
                }
            } else {
                const newId = 'P' + String(enterprisePlans.length + 1).padStart(3, '0');
                enterprisePlans.push({id: newId, name, description, value, childrenLimit, clinics:[]});
                showAlert('Plano criado com sucesso!', '');
            }
            planModalOverlay.style.display = 'none';
            renderEnterprisePlans();
            renderClinics();
        });

        // Função de Renderização dos Planos Enterprise
        function renderEnterprisePlans() {
            enterprisePlansTableBody.innerHTML = '';
            enterprisePlans.forEach(p=>{
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${p.id}</td>
                    <td>${p.name}</td>
                    <td>${p.description}</td>
                    <td>R$ ${p.value.toFixed(2)}</td>
                    <td>${p.childrenLimit}</td>
                    <td>
                        <button class="btn-action btn-enterprise edit-plan" data-id="${p.id}">Editar</button>
                        <button class="btn-action btn-suspender remove-plan" data-id="${p.id}">Remover</button>
                        <button class="btn-action btn-enterprise assign-multi" data-id="${p.id}">Associar Clínicas</button>
                    </td>
                `;
                enterprisePlansTableBody.appendChild(tr);
            });
        }

        // Modal Atribuir Plano a Múltiplas Clínicas
        const assignMultiClinicModalOverlay = document.getElementById('assignMultiClinicModalOverlay');
        const closeAssignMultiClinicModalBtn = document.getElementById('closeAssignMultiClinicModal');
        const assignMultiPlanName = document.getElementById('assignMultiPlanName');
        const multiClinicContainer = document.getElementById('multiClinicContainer');
        const assignMultipleClinicsBtn = document.getElementById('assignMultipleClinicsBtn');
        const searchAssignClinicInput = document.getElementById('searchAssignClinic');

        document.body.addEventListener('click', (e)=>{
            if(e.target.classList.contains('edit-plan')) {
                const id = e.target.dataset.id;
                const p = enterprisePlans.find(x => x.id === id);
                openPlanModal(p);
            } else if(e.target.classList.contains('remove-plan')) {
                const id = e.target.dataset.id;
                enterprisePlans = enterprisePlans.filter(x => x.id !== id);
                // Remover plano das clínicas associadas
                clinics.forEach(c=>{
                    const isAssociated = enterprisePlans.some(plan => plan.clinics.includes(c.id));
                    if(!isAssociated && getPlanName(c.id) !== 'Padrão') {
                        // Se a clínica não está mais associada a nenhum plano, pode-se atribuir o status padrão ou manter
                        // Aqui mantemos o status atual
                    }
                });
                showAlert(`Plano ${id} removido!`, '');
                renderEnterprisePlans();
                renderClinics();
            } else if(e.target.classList.contains('assign-multi')) {
                const id = e.target.dataset.id;
                openAssignMultiClinicModal(id);
            } else if(e.target.classList.contains('plan-history')) {
                const id = e.target.dataset.id;
                openPlanInvoiceHistory(id);
            }
        });

        function openAssignMultiClinicModal(planId) {
            currentAssignPlanId = planId;
            const p = enterprisePlans.find(x => x.id === planId);
            if(!p) return;
            assignMultiPlanName.textContent = p.name;
            multiClinicContainer.innerHTML = '';

            // Preencher clínicas
            clinics.forEach(c=>{
                const label = document.createElement('label');
                const chk = document.createElement('input');
                chk.type = 'checkbox';
                chk.value = c.id;
                chk.checked = p.clinics.includes(c.id);
                label.appendChild(chk);
                label.appendChild(document.createTextNode(' ' + c.name + ' (Código: ' + c.id + ')'));
                multiClinicContainer.appendChild(label);
            });

            assignMultiClinicModalOverlay.style.display = 'flex';
        }

        closeAssignMultiClinicModalBtn.addEventListener('click', ()=>{
            assignMultiClinicModalOverlay.style.display = 'none';
        });

        window.addEventListener('click', (e)=>{
            if(e.target === assignMultiClinicModalOverlay) {
                assignMultiClinicModalOverlay.style.display = 'none';
            }
        });

        assignMultipleClinicsBtn.addEventListener('click', ()=>{
            const p = enterprisePlans.find(x => x.id === currentAssignPlanId);
            if(!p) return;
            const selectedClinics = [];
            multiClinicContainer.querySelectorAll('input[type=checkbox]:checked').forEach(ch=>{
                selectedClinics.push(ch.value);
            });
            p.clinics = selectedClinics;
            showAlert(`Clínicas atribuídas ao plano ${p.name}!`, '');
            assignMultiClinicModalOverlay.style.display = 'none';
            renderEnterprisePlans();
            renderClinics();
        });

        // Pesquisa no Modal de Atribuição
        searchAssignClinicInput.addEventListener('input', ()=>{
            const query = searchAssignClinicInput.value.toLowerCase();
            multiClinicContainer.querySelectorAll('label').forEach(label=>{
                const text = label.textContent.toLowerCase();
                if(text.includes(query)) {
                    label.style.display = 'block';
                } else {
                    label.style.display = 'none';
                }
            });
        });

        

        // --- Faturas e Histórico ---
        const openClinicDashboardBtn = document.getElementById('openClinicDashboard');
        const searchClinicCodeInputField = document.getElementById('searchClinicCode');

        openClinicDashboardBtn.addEventListener('click', ()=>{
            const clinicId = searchClinicCodeInputField.value.trim().toUpperCase();
            if(!clinicId) {
                showAlert('Por favor, insira o código da clínica', 'error');
                return;
            }
            const c = clinics.find(x => x.id === clinicId);
            if(!c) {
                showAlert('Clínica não encontrada', 'error');
                return;
            }
            openClinicDashboard(c.id);
        });

        // Dashboard da Clínica
        const clinicDashboardDiv = document.getElementById('clinicDashboard');
        const dashboardClinicName = document.getElementById('dashboardClinicName');
        const dashboardInvoicesTable = document.getElementById('dashboardInvoicesTable').querySelector('tbody');
        const dashboardPatientsTable = document.getElementById('dashboardPatientsTable').querySelector('tbody');
        const dashboardProfessionalsTable = document.getElementById('dashboardProfessionalsTable').querySelector('tbody');

        function openClinicDashboard(clinicId) {
            const c = clinics.find(x => x.id === clinicId);
            if(!c) return;
            dashboardClinicName.textContent = c.name;
            dashboardInvoicesTable.innerHTML = '';
            dashboardPatientsTable.innerHTML = '';
            dashboardProfessionalsTable.innerHTML = '';

            // Faturas da clínica
            const clinicInvoices = invoices.filter(i => i.clinicId === clinicId);
            clinicInvoices.forEach(inv=>{
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${inv.id}</td>
                    <td>R$ ${inv.valor.toFixed(2)}</td>
                    <td>${inv.dataCriacao}</td>
                    <td>${inv.status}</td>
                    <td>${inv.dataPagamento || '-'}</td>
                `;
                dashboardInvoicesTable.appendChild(tr);
            });

            // Pacientes da clínica (dados simulados)
            const patients = [
                {id:'PA001', name:'João Silva', dataCadastro:'2023-01-15'},
                {id:'PA002', name:'Maria Oliveira', dataCadastro:'2023-02-20'},
                {id:'PA003', name:'Pedro Santos', dataCadastro:'2023-03-10'},
                // Adicione mais pacientes conforme necessário
            ];
            patients.forEach(p=>{
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${p.id}</td>
                    <td>${p.name}</td>
                    <td>${p.dataCadastro}</td>
                `;
                dashboardPatientsTable.appendChild(tr);
            });

            // Profissionais da clínica (dados simulados)
            const professionals = [
                {id:'PR001', name:'Dr. Ana Paula', especialidade:'Pediatria'},
                {id:'PR002', name:'Dr. Carlos Eduardo', especialidade:'Fisioterapia'},
                {id:'PR003', name:'Dr. Beatriz Lima', especialidade:'Nutrição'},
                // Adicione mais profissionais conforme necessário
            ];
            professionals.forEach(pr=>{
                const tr = document.createElement('tr');
                tr.innerHTML = `
                    <td>${pr.id}</td>
                    <td>${pr.name}</td>
                    <td>${pr.especialidade}</td>
                `;
                dashboardProfessionalsTable.appendChild(tr);
            });

            clinicDashboardDiv.style.display = 'block';
            // Scroll para o dashboard
            clinicDashboardDiv.scrollIntoView({behavior: 'smooth'});
        }

        // --- Faturas e Histórico ---
        const historyTableInInvoicesHistory = document.getElementById('historyTable')?.querySelector('tbody');
        const invoicesTableInInvoicesHistory = document.getElementById('invoicesTable')?.querySelector('tbody');

        // Nota: As funções de renderização na aba "Faturas e Histórico" já estão integradas no dashboard da clínica
        // Portanto, a renderização nesta aba pode ser omitida ou adaptada conforme a necessidade

        // --- Editar e Excluir faturas na aba Faturas e Histórico ---
        const editInvoiceModalOverlay = document.getElementById('editInvoiceModalOverlay');
        const closeEditInvoiceModal = document.getElementById('closeEditInvoiceModal');
        const editInvoiceId = document.getElementById('editInvoiceId');
        const editInvoiceDate = document.getElementById('editInvoiceDate');
        const saveInvoiceDateBtn = document.getElementById('saveInvoiceDateBtn');

        const deleteInvoiceModalOverlay = document.getElementById('deleteInvoiceModalOverlay');
        const closeDeleteInvoiceModal = document.getElementById('closeDeleteInvoiceModal');
        const deleteInvoiceId = document.getElementById('deleteInvoiceId');
        const confirmDeleteInvoiceBtn = document.getElementById('confirmDeleteInvoiceBtn');

        document.body.addEventListener('click', (e)=>{
            if(e.target.classList.contains('edit-invoice')) {
                currentInvoiceId = e.target.dataset.id;
                openEditInvoiceModal(currentInvoiceId);
            } else if(e.target.classList.contains('delete-invoice')) {
                currentInvoiceId = e.target.dataset.id;
                openDeleteInvoiceModal(currentInvoiceId);
            }
        });

        function openEditInvoiceModal(id) {
            const inv = invoices.find(x => x.id === id);
            if(!inv) return;
            editInvoiceId.textContent = inv.id;
            editInvoiceDate.value = inv.validade;
            editInvoiceModalOverlay.style.display = 'flex';
        }

        closeEditInvoiceModal.addEventListener('click', ()=>{
            editInvoiceModalOverlay.style.display = 'none';
        });

        window.addEventListener('click', (e)=>{
            if(e.target === editInvoiceModalOverlay) {
                editInvoiceModalOverlay.style.display = 'none';
            }
        });

        saveInvoiceDateBtn.addEventListener('click', ()=>{
            const inv = invoices.find(x => x.id === currentInvoiceId);
            if(!inv) return;
            if(!editInvoiceDate.value) {
                showAlert('Preencha a data', 'error');
                return;
            }
            inv.validade = editInvoiceDate.value;
            showAlert(`Validade da fatura ${inv.id} atualizada!`, '');
            editInvoiceModalOverlay.style.display = 'none';
            renderClinics();
            if(currentHistoryClinicId) openInvoiceHistoryModal(currentHistoryClinicId);
        });

        function openDeleteInvoiceModal(id) {
            const inv = invoices.find(x => x.id === id);
            if(!inv) return;
            deleteInvoiceId.textContent = inv.id;
            deleteInvoiceModalOverlay.style.display = 'flex';
        }

        closeDeleteInvoiceModal.addEventListener('click', ()=>{
            deleteInvoiceModalOverlay.style.display = 'none';
        });

        window.addEventListener('click', (e)=>{
            if(e.target === deleteInvoiceModalOverlay) {
                deleteInvoiceModalOverlay.style.display = 'none';
            }
        });

        confirmDeleteInvoiceBtn.addEventListener('click', ()=>{
            invoices = invoices.filter(x => x.id !== currentInvoiceId);
            showAlert(`Fatura ${currentInvoiceId} excluída!`, '');
            deleteInvoiceModalOverlay.style.display = 'none';
            renderClinics();
            if(currentHistoryClinicId) openInvoiceHistoryModal(currentHistoryClinicId);
        });

        // --- Planos Enterprise ---
        // A função renderEnterprisePlans já está definida anteriormente

        // Inicialização
        function init() {
            renderClinics();
            renderEnterprisePlans();
        }

        init();
    </script>
</body>
</html>
