<?php
/**
 * Script para analisar respostas de itens cognitivos e gerar relatório com respostas padrão.
 * Agora com autenticação e recebimento de JSON via requisição HTTP.
 */

// Chave esperada para autenticação
$EXPECTED_API_KEY = 'sua_chave_secreta_aqui';

// Função para obter todos os cabeçalhos (compatível com diferentes ambientes)
function getRequestHeaders() {
    if (function_exists('getallheaders')) {
        return getallheaders();
    }
    $headers = [];
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
            $headerName = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
            $headers[$headerName] = $value;
        }
    }
    return $headers;
}

// Verificação da chave de autenticação
$headers = getRequestHeaders();
if(isset($headers['Authorization'])) {
    // Extrai a chave do cabeçalho Authorization: Bearer {token}
    $authHeader = $headers['Authorization'];
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $provided_key = $matches[1];
    } else {
        $provided_key = '';
    }
    
    if($provided_key !== $EXPECTED_API_KEY) {
        header('HTTP/1.1 401 Unauthorized');
        echo json_encode(['error' => 'Unauthorized']);
        exit;
    }
} else {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Ler o corpo da requisição contendo o JSON
$json_input = file_get_contents('php://input');

// Definição do mapeamento de itens para classes e faixas etárias
$item_mapping = [
    // Classe 1: Discriminação Visual
    "cog_item1" => ["class" => 1, "age_range" => "0-1"],
    "cog_item2" => ["class" => 1, "age_range" => "0-1"],

    // Classe 2: Colocar/Remover Objetos de Recipientes
    "cog_item3" => ["class" => 2, "age_range" => "0-1"],
    "cog_item4" => ["class" => 2, "age_range" => "0-1"],
    "cog_item5" => ["class" => 2, "age_range" => "0-1"],
    "cog_item7" => ["class" => 2, "age_range" => "0-1"],
    "cog_item15" => ["class" => 2, "age_range" => "1-2"],

    // Classe 3: Manipular Objetos/Brinquedos
    "cog_item6" => ["class" => 3, "age_range" => "0-1"],
    "cog_item8" => ["class" => 3, "age_range" => "0-1"],
    "cog_item9" => ["class" => 3, "age_range" => "0-1"],
    "cog_item11" => ["class" => 3, "age_range" => "0-1"],

    // Classe 4: Encontrar Objetos/Figuras Ausentes
    "cog_item10" => ["class" => 4, "age_range" => "0-1"],
    "cog_item24" => ["class" => 4, "age_range" => "1-2"],
    "cog_item25" => ["class" => 4, "age_range" => "2-3"],

    // Classe 5: Colocar/Remover Peças em Pranchas de Encaixe/Quebra-Cabeças
    "cog_item12" => ["class" => 5, "age_range" => "0-1"],
    "cog_item26" => ["class" => 5, "age_range" => "2-3"],
    "cog_item37" => ["class" => 5, "age_range" => "2-3"],
    "cog_item60" => ["class" => 5, "age_range" => "3-4"],

        // Classe 6: Colocar pinos em pranchas
    "cog_item13" => ["class" => 6, "age_range" => "0-1"],
    "cog_item21" => ["class" => 6, "age_range" => "1-2"],

    // Classe 7: Executar gestos
    "cog_item14" => ["class" => 7, "age_range" => "0-1"],
    "cog_item47" => ["class" => 7, "age_range" => "3-4"],

    // Classe 8: Apontar partes do corpo
    "cog_item16" => ["class" => 8, "age_range" => "1-2"],
    "cog_item42" => ["class" => 8, "age_range" => "3-4"],

    // Classe 9: Empilhar blocos/argolas
    "cog_item17" => ["class" => 9, "age_range" => "1-2"],
    "cog_item40" => ["class" => 9, "age_range" => "2-3"],
    "cog_item56" => ["class" => 9, "age_range" => "3-4"],
    "cog_item80" => ["class" => 9, "age_range" => "4-5"],

    // Classe 10: Emparelhar objetos/figuras semelhantes
    "cog_item18" => ["class" => 10, "age_range" => "1-2"],
    "cog_item22" => ["class" => 10, "age_range" => "1-2"],
    "cog_item48" => ["class" => 10, "age_range" => "3-4"],
    "cog_item50" => ["class" => 10, "age_range" => "3-4"],
    "cog_item52" => ["class" => 10, "age_range" => "3-4"],
    "cog_item57" => ["class" => 10, "age_range" => "3-4"],
    "cog_item83" => ["class" => 10, "age_range" => "4-5"],

    // Classe 11: Realizar traços em papel
    "cog_item19"  => ["class" => 11, "age_range" => "1-2"],
    "cog_item28"  => ["class" => 11, "age_range" => "2-3"],
    "cog_item29"  => ["class" => 11, "age_range" => "2-3"],
    "cog_item30"  => ["class" => 11, "age_range" => "2-3"],
    "cog_item33"  => ["class" => 11, "age_range" => "2-3"],
    "cog_item53"  => ["class" => 11, "age_range" => "3-4"],
    "cog_item54"  => ["class" => 11, "age_range" => "3-4"],
    "cog_item58"  => ["class" => 11, "age_range" => "3-4"],
    "cog_item59"  => ["class" => 11, "age_range" => "3-4"],
    "cog_item62"  => ["class" => 11, "age_range" => "3-4"],
    "cog_item67"  => ["class" => 11, "age_range" => "4-5"],
    "cog_item78"  => ["class" => 11, "age_range" => "4-5"],
    "cog_item100" => ["class" => 11, "age_range" => "5-6"],

    // Classe 12: Identificar a si próprio
    "cog_item20" => ["class" => 12, "age_range" => "1-2"],

    // Classe 13: Apontar figuras nomeadas
    "cog_item23" => ["class" => 13, "age_range" => "1-2"],
    "cog_item43" => ["class" => 13, "age_range" => "3-4"],

    // Classe 14: Identificar tamanho e comprimento de objetos/figuras
    "cog_item32" => ["class" => 14, "age_range" => "2-3"],
    "cog_item41" => ["class" => 14, "age_range" => "3-4"],
    "cog_item49" => ["class" => 14, "age_range" => "3-4"],
    "cog_item81" => ["class" => 14, "age_range" => "4-5"],
    "cog_item93" => ["class" => 14, "age_range" => "5-6"],

    // Classe 15: Nomear figuras/objetos
    "cog_item27" => ["class" => 15, "age_range" => "2-3"],
    "cog_item36" => ["class" => 15, "age_range" => "2-3"],
    "cog_item38" => ["class" => 15, "age_range" => "2-3"],

    // Classe 16: Identificar texturas
    "cog_item31" => ["class" => 16, "age_range" => "2-3"],
    "cog_item66" => ["class" => 16, "age_range" => "4-5"],

    // Classe 17: Identificar cores
    "cog_item34" => ["class" => 17, "age_range" => "2-3"],
    "cog_item63" => ["class" => 17, "age_range" => "3-4"],
    "cog_item73" => ["class" => 17, "age_range" => "4-5"],
    "cog_item76" => ["class" => 17, "age_range" => "4-5"],

    // Classe 18: Identificar posição espacial de objetos
    "cog_item35" => ["class" => 18, "age_range" => "2-3"],
    "cog_item82" => ["class" => 18, "age_range" => "4-5"],
    "cog_item86" => ["class" => 18, "age_range" => "4-5"],
    "cog_item96" => ["class" => 18, "age_range" => "5-6"],

    // Classe 19: Identifica/reunir formas geométricas
    "cog_item39" => ["class" => 19, "age_range" => "2-3"],
    "cog_item64" => ["class" => 19, "age_range" => "3-4"],

    // Classe 20: Identificar peso de objetos
    "cog_item44" => ["class" => 20, "age_range" => "3-4"],
    "cog_item71" => ["class" => 20, "age_range" => "4-5"],

    // Classe 21: Unir figuras
    "cog_item45" => ["class" => 21, "age_range" => "3-4"],

    // Classe 22: Descrever eventos
    "cog_item46" => ["class" => 22, "age_range" => "3-4"],
    "cog_item77" => ["class" => 22, "age_range" => "4-5"],

    // Classe 23: Contar objetos
    "cog_item51"  => ["class" => 23, "age_range" => "3-4"],
    "cog_item55"  => ["class" => 23, "age_range" => "3-4"],
    "cog_item85"  => ["class" => 23, "age_range" => "4-5"],
    "cog_item87"  => ["class" => 23, "age_range" => "5-6"],
    "cog_item108" => ["class" => 23, "age_range" => "5-6"],

    // Classe 24: Indicar se objetos são iguais ou diferentes
    "cog_item61" => ["class" => 24, "age_range" => "3-4"],

    // Classe 25: Identificar número de objetos
    "cog_item65" => ["class" => 25, "age_range" => "4-5"],

    // Classe 26: Recordar-se de objetos vistos
    "cog_item68" => ["class" => 26, "age_range" => "4-5"],
    "cog_item72" => ["class" => 26, "age_range" => "4-5"],

    // Classe 27: Identificar tempo (manhã/tarde)
    "cog_item69" => ["class" => 27, "age_range" => "4-5"],

    // Classe 28: Repetir rimas/cantar
    "cog_item70" => ["class" => 28, "age_range" => "4-5"],
    "cog_item79" => ["class" => 28, "age_range" => "4-5"],

    // Classe 29: Identificar valor de moedas
    "cog_item74" => ["class" => 29, "age_range" => "4-5"],

    // Classe 30: Emparelhar/nomear letras e números
    "cog_item75"  => ["class" => 30, "age_range" => "4-5"],
    "cog_item88"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item90"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item92"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item94"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item95"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item97"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item98"  => ["class" => 30, "age_range" => "5-6"],
    "cog_item99"  => ["class" => 30, "age_range" => "5-6"],

    // Classe 31: Identificar esquerda/direita
    "cog_item89" => ["class" => 31, "age_range" => "5-6"],

    // Classe 32: Escrever seu nome
    "cog_item91" => ["class" => 32, "age_range" => "5-6"],

    // Classe 33: Completar labirintos
    "cog_item101" => ["class" => 33, "age_range" => "5-6"],

    // Classe 34: Identificar dias da semana
    "cog_item102" => ["class" => 34, "age_range" => "5-6"],

    // Classe 35: Somar e subtrair
    "cog_item103" => ["class" => 35, "age_range" => "5-6"],

    // Classe 36: Identificar mês e dia de nascimento
    "cog_item104" => ["class" => 36, "age_range" => "5-6"],

    // Classe 37: Ler palavras
    "cog_item105" => ["class" => 37, "age_range" => "5-6"],

    // Classe 38: Predizer o que ocorrerá
    "cog_item106" => ["class" => 38, "age_range" => "5-6"],

    // Classe 39: Identificar objetos inteiros ou partidos ao meio
    "cog_item107" => ["class" => 39, "age_range" => "5-6"],

];

// Definição das respostas padrão por classe e faixa etária
$standard_responses = [
    // Classe 1: Discriminação Visual
    1 => [
        "0-1" => "Teve dificuldade em remover estímulos visuais ou buscar o que some de vista, sugerindo atraso na percepção básica e prejudicando a exploração do ambiente.",
    ],

    // Classe 2:  Colocar/ remover objetos de recipientes
    2 => [
        "0-1" => "Teve dificuldade em colocar ou tirar objetos de recipientes, indicando atraso na coordenação olho-mão, dificultando a exploração de brinquedos.",
        "1-2" => "Não retirou vários objetos de forma eficiente, revelando limitação na coordenação fina e reduzindo a autonomia nas brincadeiras.",
    ],
    // Classe 3: Manipular Objetos/Brinquedos
    3 => [
        "0-1" => "Teve dificuldade em balançar, trocar de mão ou deixar cair e pegar brinquedos, demonstrando atraso na manipulação e noções de causa e efeito, prejudicando o engajamento lúdico.",
    ],
    
    // Classe 4: Encontrar Objetos/Figuras Ausentes
    4 => [
        "0-1" => "Não buscou objeto escondido, indicando atraso na noção de permanência.",
        "1-2" => "Dificuldade ao virar páginas para achar figuras, mostrando pouca atenção visual.",
        "2-3" => "Não encontrou livro solicitado, revelando falha na memória e identificação de objetos.",
        "4-5" => "Não reconheceu parte ausente de uma figura, prejudicando a percepção de detalhes.",
    ],
    
    // Classe 5: Colocar/Remover Peças em Pranchas de Encaixe/Quebra-cabeças
    5 => [
        "0-1" => "Não removeu círculo por imitação, apontando atraso na coordenação e imitação de ações simples.",
        "2-3" => "Teve dificuldade em completar encaixes básicos, mostrando pouca coordenação e compreensão de formas.",
        "3-4" => "Não finalizou quebra-cabeças de 6 peças, evidenciando atraso na percepção visual e na organização espacial.",
    ],
    
    // Classe 6: Colocar Pinos em Pranchas
    6 => [
        "0-1" => "Não colocou pino redondo quando solicitado, sugerindo atraso na coordenação fina e compreensão de instruções.",
        "1-2" => "Não conseguiu colocar 5 pinos de forma orientada, prejudicando a precisão motora e a execução de tarefas manuais.",
    ],
    
    // Classe 7: Executar Gestos
    7 => [
        "0-1" => "Não realizou gestos simples, mostrando dificuldade de imitação e comunicação não verbal.",
        "3-4" => "Não repetiu gestos ou rimas com movimentos, indicando atraso na coordenação e memorização de sequências.",
    ],
    
    // Classe 8: Apontar Partes do Corpo
    8 => [
        "1-2" => "Não reconheceu ou apontou partes do corpo, sugerindo atraso na percepção de si e compreensão verbal.",
        "3-4" => "Teve dificuldade em apontar 10 partes do corpo, indicando pouca familiaridade com o esquema corporal.",
    ],
    
    // Classe 9: Empilhar Blocos/Argolas
    9 => [
        "1-2" => "Não empilhou 3 blocos, demonstrando atraso na coordenação e organização espacial.",
        "2-3" => "Falhou ao empilhar 5 argolas, prejudicando a precisão motora fina.",
        "3-4" => "Não construiu ponte de 3 blocos, evidenciando pouca noção de equilíbrio e planejamento.",
        "4-5" => "Não formou pirâmide de 10 blocos, sugerindo dificuldade em raciocínio construtivo e coordenação.",
    ],
    
    // Classe 10: Emparelhar Objetos/Figuras Semelhantes
    10 => [
        "1-2" => "Não agrupou objetos ou figuras idênticas, indicando falha na percepção de semelhanças.",
        "3-4" => "Teve dificuldade em emparelhar múltiplos itens, mostrando atraso na categorização.",
        "4-5" => "Não formou conjuntos iguais de 10 objetos, prejudicando a organização e atenção a detalhes.",
    ],
    
    // Classe 11: Realizar Traços em Papel
    11 => [
        "1-2" => "Não fez rabiscos, demonstrando pouco envolvimento com grafismo.",
        "2-3" => "Não imitou linhas ou círculos simples, indicando atraso na coordenação para desenho.",
        "3-4" => "Dificuldade em traçar formas (V, diagonal) ou completar desenho do corpo, afetando expressão gráfica.",
        "4-5" => "Não copiou triângulo nem desenhou figura humana básica, mostrando falha na evolução motora fina.",
        "5-6" => "Não copiou losango, revelando atraso no domínio de formas mais complexas.",
    ],
    
    // Classe 12: Identificar a Si Próprio
    12 => [
        "1-2" => "Não apontou para si ao ser chamado, sugerindo atraso na consciência de identidade e percepção de si.",
    ],
    
    // Classe 13: Apontar Figuras Nomeadas
    13 => [
        "1-2" => "Não localizou figuras ao nomeá-las, indicando dificuldade de associação entre palavra e imagem.",
        "3-4" => "Não distinguiu menino/menina ao apontar, sugerindo falha no reconhecimento de diferenças básicas.",
    ],
    
    // Classe 14: Identificar Tamanho e Comprimento de Objetos/Figuras
    14 => [
        "2-3" => "Não apontou “pequeno” e “grande”, indicando atraso em conceitos de tamanho.",
        "3-4" => "Dificuldade em nomear objetos curtos ou compridos, prejudicando comparações visuais.",
        "4-5" => "Não rotulou objetos como compridos ou curtos, impactando noções de medida.",
        "5-6" => "Não ordenou objetos por comprimento/largura, evidenciando falha na percepção sequencial.",
    ],
    
    // Classe 15: Nomear Figuras/Objetos
    15 => [
        "2-3" => "Falhou em nomear objetos comuns em figuras ou identificar sons/ações, sugerindo atraso na linguagem compreensiva e expressiva, prejudicando a comunicação.",
    ],
    
    // Classe 16: Identificar Texturas
    16 => [
        "2-3" => "Não emparelhou objetos pela mesma textura, apontando falha na discriminação sensorial.",
        "4-5" => "Não nomeou 5 texturas, prejudicando a percepção tátil e vocabulário.",
    ],
    
    // Classe 17: Identificar Cores
    17 => [
        "2-3" => "Não emparelhou 3 cores, indicando atraso na percepção de cores.",
        "3-4" => "Não nomeou 3 cores solicitadas, evidenciando falha no vocabulário cromático.",
        "4-5" => "Teve dificuldade em nomear 8 cores ou indicar a cor de objetos, prejudicando descrições visuais.",
    ],
    
    // Classe 18: Identificar Posição Espacial de Objetos
    18 => [
        "2-3" => "Não colocou objetos dentro, em cima ou embaixo conforme pedido, mostrando atraso em noções espaciais.",
        "4-5" => "Falhou ao posicionar atrás/ao lado, indicando dificuldade em seguir instruções espaciais.",
        "5-6" => "Não reconheceu 1º, 2º e 3º lugar, prejudicando a compreensão sequencial.",
    ],
    
    // Classe 19: Identificar/Reunir Formas Geométricas
    19 => [
        "2-3" => "Não emparelhou forma com figura correspondente, sugerindo atraso na discriminação de formas.",
        "3-4" => "Não nomeou formas simples (quadrado, triângulo, círculo), impactando a aprendizagem de conceitos geométricos.",
    ],
    
    // Classe 20: Identificar Peso de Objetos
    20 => [
        "3-4" => "Não soube dizer se objeto é pesado ou leve, sugerindo pouca percepção de diferenças básicas de peso.",
        "4-5" => "Teve dificuldade em comparar pesos com diferença de 0,5 quilo, prejudicando a compreensão sensorial.",
    ],
    
    // Classe 21: Unir Figuras
    21 => [
        "3-4" => "Não uniu partes para formar um todo, revelando atraso na percepção visual e na organização de partes.",
    ],
    
    // Classe 22: Descrever Eventos
    22 => [
        "3-4" => "Não descreveu personagens ou eventos simples, sugerindo dificuldade em organizar pensamentos.",
        "4-5" => "Não relatou fatos principais de uma história, prejudicando a memória e expressão verbal.",
    ],
    
    // Classe 23: Contar Objetos
    23 => [
        "3-4" => "Não contou até 3 ou 10 imitando adulto, mostrando falha inicial em sequências numéricas.",
        "4-5" => "Não contou 1 a 20 com clareza, evidenciando atraso na contagem básica.",
        "5-6" => "Não contou até 20 objetos ou manteve a sequência até 100, prejudicando o raciocínio matemático inicial.",
    ],
    
    // Classe 24: Indicar se Objetos São Iguais ou Diferentes
    24 => [
        "3-4" => "Não distinguiu objetos iguais ou diferentes, sugerindo atraso na percepção comparativa.",
    ],
    
    // Classe 25: Identificar Número de Objetos
    25 => [
        "4-5" => "Não apanhou a quantidade exata de 1 a 5 objetos, indicando dificuldade em relacionar número e quantidade.",
    ],
    
    // Classe 26: Recordar-se de Objetos Vistos
    26 => [
        "4-5" => "Não lembrou de objetos vistos ou não notou o que faltava em um grupo, prejudicando a memória visual.",
    ],
    
    // Classe 27: Identificar Tempo (Manhã/Tarde)
    27 => [
        "4-5" => "Não associou atividade ao momento do dia, sugerindo atraso na percepção temporal e rotina.",
    ],
    
    // Classe 28: Repetir Rimas/Cantar
    28 => [
        "4-5" => "Não repetiu rimas ou cantou pequenas músicas, indicando atraso na memória auditiva e expressão oral.",
    ],
    
    // Classe 29: Identificar Valor de Moedas
    29 => [
        "4-5" => "Não reconheceu o valor de 3 moedas, evidenciando dificuldade na compreensão de quantias.",
    ],
    
    // Classe 30: Emparelhar/Nomear Letras e Números
    30 => [
        "4-5" => "Não emparelhou símbolos básicos, prejudicando a iniciação à leitura e contagem.",
        "5-6" => "Falhou em nomear/numerar letras e ordenar numerais, indicando atraso na identificação alfanumérica.",
    ],
    
    // Classe 31: Identificar Esquerda/Direita
    31 => [
        "5-6" => "Não reconheceu sua esquerda ou direita, comprometendo a orientação corporal e espacial.",
    ],
    
    // Classe 32: Escrever Seu Nome
    32 => [
        "5-6" => "Não escreveu o nome em letras de forma, apontando atraso na pré-alfabetização e coordenação motora fina.",
    ],
    
    // Classe 33: Completar Labirintos
    33 => [
        "5-6" => "Não resolveu labirinto simples, evidenciando falha no planejamento visual e na coordenação para traçar caminhos.",
    ],
    
    // Classe 34: Identificar Dias da Semana
    34 => [
        "5-6" => "Não disse corretamente os dias da semana, indicando dificuldade com sequências temporais básicas.",
    ],
    
    // Classe 35: Somar e Subtrair
    35 => [
        "5-6" => "Não realizou soma ou subtração de até 3 elementos, sugerindo atraso na noção inicial de operações matemáticas.",
    ],
    
    // Classe 36: Identificar Mês e Dia de Nascimento
    36 => [
        "5-6" => "Não nomeou corretamente mês e dia do próprio aniversário, prejudicando a noção de temporalidade e datas pessoais.",
    ],
    
    // Classe 37: Ler Palavras
    37 => [
        "5-6" => "Não leu 10 palavras simples, demonstrando atraso significativo na leitura inicial, impactando o processo de alfabetização.",
    ],
    
    // Classe 38: Predizer o Que Ocorrerá
    38 => [
        "5-6" => "Não antecipou o desenrolar de uma situação, mostrando dificuldade na compreensão de causa e efeito.",
    ],
    
    // Classe 39: Identificar Objetos Inteiros ou Partidos ao Meio
    39 => [
        "5-6" => "Não diferenciou objetos inteiros de partidos, sugerindo atraso na percepção de totalidade e análise visual.",
    ],



];

// Função para ordenar faixas etárias
function get_age_order($age_range) {
    $parts = explode('-', $age_range);
    return intval($parts[0]);
}

// Função para processar as respostas e gerar o relatório
function generate_report($json_data, $item_mapping, $standard_responses) {
    $input = json_decode($json_data, true);
    
    if ($input === null) {
        return "Erro: JSON inválido.";
    }
    
    $class_failures = [];
    
    foreach ($input as $item => $value) {
        if ($value == 1 && isset($item_mapping[$item])) {
            $class = $item_mapping[$item]['class'];
            $age_range = $item_mapping[$item]['age_range'];
            $age_order = get_age_order($age_range);
            
            if (!isset($class_failures[$class])) {
                $class_failures[$class] = [
                    "age_range" => $age_range,
                    "age_order" => $age_order,
                ];
            } else {
                if ($age_order < $class_failures[$class]['age_order']) {
                    $class_failures[$class] = [
                        "age_range" => $age_range,
                        "age_order" => $age_order,
                    ];
                }
            }
        }
    }
    
    $report = [];
    
    foreach ($class_failures as $class => $info) {
        $age_range = $info['age_range'];
        if (isset($standard_responses[$class][$age_range])) {
            $report[] = $standard_responses[$class][$age_range];
        }
    }
    
    if (empty($report)) {
        return "Nenhuma falha identificada nos itens avaliados.";
    } else {
        $output = "Relatório de Avaliação Cognitiva:\n\n";
        foreach ($report as $index => $response) {
            $output .= ($index + 1) . ". " . $response . "\n\n";
        }
        return $output;
    }
}

// Gerar e exibir o relatório
$relatorio = generate_report($json_input, $item_mapping, $standard_responses);
echo $relatorio;
?>