<?php
/**
 * Script para analisar respostas de itens cognitivos e gerar relatório com respostas padrão.
 * Agora com autenticação e recebimento de JSON via requisição HTTP.
 */

// Chave esperada para autenticação
$EXPECTED_API_KEY = 'sua_chave_secreta_aqui';

// Função para obter todos os cabeçalhos (compatível com diferentes ambientes)
function getRequestHeaders() {
    if (function_exists('getallheaders')) {
        return getallheaders();
    }
    $headers = [];
    foreach ($_SERVER as $name => $value) {
        if (substr($name, 0, 5) == 'HTTP_') {
            $headerName = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
            $headers[$headerName] = $value;
        }
    }
    return $headers;
}

// Verificação da chave de autenticação
$headers = getRequestHeaders();
if(isset($headers['Authorization'])) {
    // Extrai a chave do cabeçalho Authorization: Bearer {token}
    $authHeader = $headers['Authorization'];
    if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        $provided_key = $matches[1];
    } else {
        $provided_key = '';
    }
    
    if($provided_key !== $EXPECTED_API_KEY) {
        header('HTTP/1.1 401 Unauthorized');
        echo json_encode(['error' => 'Unauthorized']);
        exit;
    }
} else {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Ler o corpo da requisição contendo o JSON
$json_input = file_get_contents('php://input');

// Definição do mapeamento de itens para classes e faixas etárias
$item_mapping = [
    // Classe 1a: Beber
"autoc_item1"  => ["class" => "1a", "age_range" => "0-1"],   
"autoc_item2"  => ["class" => "1a", "age_range" => "0-1"],  
"autoc_item3"  => ["class" => "1a", "age_range" => "0-1"], 
"autoc_item5"  => ["class" => "1a", "age_range" => "0-1"], 
"autoc_item6"  => ["class" => "1a", "age_range" => "0-1"], 
"autoc_item8"  => ["class" => "1a", "age_range" => "0-1"], 
"autoc_item11" => ["class" => "1a", "age_range" => "0-1"], 
"autoc_item15" => ["class" => "1a", "age_range" => "1-2"], 
"autoc_item26" => ["class" => "1a", "age_range" => "2-3"], 
"autoc_item28" => ["class" => "1a", "age_range" => "2-3"],

// Classe 1b: Comer
"autoc_item4"  => ["class" => "1b", "age_range" => "0-1"],
"autoc_item7"  => ["class" => "1b", "age_range" => "0-1"],
"autoc_item9"  => ["class" => "1b", "age_range" => "0-1"],
"autoc_item10" => ["class" => "1b", "age_range" => "0-1"],
"autoc_item12" => ["class" => "1b", "age_range" => "0-1"],
"autoc_item14" => ["class" => "1b", "age_range" => "1-2"],
"autoc_item26" => ["class" => "1b", "age_range" => "2-3"], // também aparece em 1a, pois abrange beber e comer
"autoc_item29" => ["class" => "1b", "age_range" => "2-3"],
"autoc_item46" => ["class" => "1b", "age_range" => "2-3"],
"autoc_item53" => ["class" => "1b", "age_range" => "3-4"],
"autoc_item75" => ["class" => "1b", "age_range" => "3-4"],
"autoc_item79" => ["class" => "1b", "age_range" => "4-5"],
"autoc_item100"=> ["class" => "1b", "age_range" => "4-5"],

// Classe 1c: Obtenção/preparo de alimentos
"autoc_item39" => ["class" => "1c", "age_range" => "2-3"],
"autoc_item45" => ["class" => "1c", "age_range" => "2-3"],
"autoc_item47" => ["class" => "1c", "age_range" => "2-3"],
"autoc_item95" => ["class" => "1c", "age_range" => "5-6"],
"autoc_item98" => ["class" => "1c", "age_range" => "5-6"],
"autoc_item102"=> ["class" => "1c", "age_range" => "5-6"],

// Classe 1d: Pôr a mesa / servir-se à mesa
"autoc_item72" => ["class" => "1d", "age_range" => "4-5"],
"autoc_item82" => ["class" => "1d", "age_range" => "5-6"],
"autoc_item83" => ["class" => "1d", "age_range" => "5-6"],
"autoc_item94" => ["class" => "1d", "age_range" => "5-6"],
"autoc_item103"=> ["class" => "1d", "age_range" => "5-6"],

// Classe 2a: Desvestir/Vestir (calça, casaco, meia, sapato e fechos)
"autoc_item13" => ["class" => "2a", "age_range" => "0-1"],  
"autoc_item18" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item19" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item20" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item21" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item22" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item23" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item24" => ["class" => "2a", "age_range" => "1-2"],  
"autoc_item35" => ["class" => "2a", "age_range" => "2-3"],  
"autoc_item37" => ["class" => "2a", "age_range" => "2-3"],  
"autoc_item48" => ["class" => "2a", "age_range" => "2-3"],  
"autoc_item50" => ["class" => "2a", "age_range" => "2-3"],  
"autoc_item51" => ["class" => "2a", "age_range" => "2-3"],  
"autoc_item52" => ["class" => "2a", "age_range" => "2-3"],  
"autoc_item54" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item58" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item59" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item64" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item65" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item66" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item67" => ["class" => "2a", "age_range" => "3-4"],  
"autoc_item70" => ["class" => "2a", "age_range" => "4-5"],  
"autoc_item71" => ["class" => "2a", "age_range" => "4-5"],  
"autoc_item73" => ["class" => "2a", "age_range" => "4-5"],  
"autoc_item80" => ["class" => "2a", "age_range" => "4-5"],  
"autoc_item81" => ["class" => "2a", "age_range" => "4-5"],  
"autoc_item89" => ["class" => "2a", "age_range" => "5-6"],  
"autoc_item90" => ["class" => "2a", "age_range" => "5-6"],  
"autoc_item92" => ["class" => "2a", "age_range" => "5-6"],  
"autoc_item104"=> ["class" => "2a", "age_range" => "5-6"],  

// Classe 2b: Guardar roupas
"autoc_item42" => ["class" => "2b", "age_range" => "2-3"],  
"autoc_item62" => ["class" => "2b", "age_range" => "3-4"],  
"autoc_item87" => ["class" => "2b", "age_range" => "4-5"],  

// Classe 3a: Lavar mãos/rosto
"autoc_item16" => ["class" => "3a", "age_range" => "1-2"],  
"autoc_item27" => ["class" => "3a", "age_range" => "2-3"],  
"autoc_item31" => ["class" => "3a", "age_range" => "2-3"],  
"autoc_item40" => ["class" => "3a", "age_range" => "2-3"],  
"autoc_item74" => ["class" => "3a", "age_range" => "4-5"],  

// Classe 3b: Treino ao toalete
"autoc_item17" => ["class" => "3b", "age_range" => "1-2"],  
"autoc_item25" => ["class" => "3b", "age_range" => "1-2"],  
"autoc_item32" => ["class" => "3b", "age_range" => "2-3"],  
"autoc_item34" => ["class" => "3b", "age_range" => "2-3"],  
"autoc_item38" => ["class" => "3b", "age_range" => "2-3"],  
"autoc_item41" => ["class" => "3b", "age_range" => "2-3"],  
"autoc_item43" => ["class" => "3b", "age_range" => "2-3"],  
"autoc_item56" => ["class" => "3b", "age_range" => "3-4"],  
"autoc_item57" => ["class" => "3b", "age_range" => "3-4"],  
"autoc_item76" => ["class" => "3b", "age_range" => "4-5"],  
"autoc_item85" => ["class" => "3b", "age_range" => "4-5"],  
"autoc_item101"=> ["class" => "3b", "age_range" => "5-6"],  

// Classe 3c: Controle de baba
"autoc_item33" => ["class" => "3c", "age_range" => "2-3"],  

// Classe 3d: Assoar o nariz
"autoc_item55" => ["class" => "3d", "age_range" => "3-4"],  
"autoc_item60" => ["class" => "3d", "age_range" => "3-4"],  
"autoc_item77" => ["class" => "3d", "age_range" => "4-5"],  

// Classe 3e: Pentear cabelo
"autoc_item86" => ["class" => "3e", "age_range" => "4-5"],  

// Classe 3f: Escovar dentes
"autoc_item36" => ["class" => "3f", "age_range" => "2-3"],  
"autoc_item63" => ["class" => "3f", "age_range" => "3-4"],  
"autoc_item84" => ["class" => "3f", "age_range" => "4-5"],  

// Classe 3g: Tomar banho
"autoc_item49" => ["class" => "3g", "age_range" => "2-3"],  
"autoc_item78" => ["class" => "3g", "age_range" => "4-5"],  
"autoc_item97" => ["class" => "3g", "age_range" => "5-6"],  

// Classe 4: EVITAR RISCOS
"autoc_item30" => ["class" => "4", "age_range" => "2-3"],  
"autoc_item44" => ["class" => "4", "age_range" => "2-3"],  
"autoc_item61" => ["class" => "4", "age_range" => "3-4"],  
"autoc_item69" => ["class" => "4", "age_range" => "4-5"],  
"autoc_item88" => ["class" => "4", "age_range" => "5-6"],  
"autoc_item93" => ["class" => "4", "age_range" => "5-6"],  
"autoc_item99" => ["class" => "4", "age_range" => "5-6"],  
"autoc_item105"=> ["class" => "4", "age_range" => "5-6"],  

// Classe 5: REALIZAR TAREFAS DOMÉSTICAS
"autoc_item68" => ["class" => "5", "age_range" => "4-5"],  
"autoc_item91" => ["class" => "5", "age_range" => "5-6"],  
"autoc_item96" => ["class" => "5", "age_range" => "5-6"],  

    

];

// Definição das respostas padrão por classe e faixa etária
$standard_responses = [
    
    // Classe 1: ALIMENTAÇÃO
    "1a" => [
        "0-1" => "Dificuldade em segurar ou levar a mamadeira à boca sugere atraso na coordenação motora fina para beber.",
        "1-2" => "Não segurou a caneca com uma mão ao beber, indicando atraso na independência ao consumir líquidos.",
        "2-3" => "Incapacidade de sugar líquido do copo com canudinho aponta para atraso no uso de utensílios adequados para beber.",
    ],
    
    "1b" => [
        "0-1" => "Dificuldade em consumir alimentos liquidificados ou semi-sólidos sozinho revela atraso na alimentação independente.",
        "1-2" => "Falha ao comer com os dedos ou colher sem ajuda indica limitação na coordenação alimentar.",
        "2-3" => "Problemas ao dar garfadas ou mastigar alimentos consistentes apontam para atraso na autossuficiência alimentar.",
        "3-4" => "Não se alimentou sozinho durante toda a refeição, afetando a autonomia no comer.",
        "4-5" => "Incapacidade de usar talheres apropriadamente para se alimentar evidencia atraso na coordenação fina.",
        "5-6" => "Dificuldade em cortar alimentos tenros com faca sugere limitação em habilidades alimentares mais complexas.",
    ],
    
    "1c" => [
        "1-2" => "Não obteve água ou não despejou líquido para um copo sem ajuda, mostrando atraso na manipulação de utensílios.",
        "2-3" => "Falhou ao encher um copo ou ao usar garfo para levar alimento à boca, indicando falta de independência.",
        "4-5" => "Dificuldade em abrir embalagens de leite aponta para habilidades motoras finas insuficientes.",
        "5-6" => "Não preparou sua própria caneca de café com leite, evidenciando atraso na autossuficiência alimentar básica.",
    ],
    
    "1d" => [
        "4-5" => "Não ajudou a pôr a mesa ou não se serviu adequadamente, indicando atraso na colaboração e autonomia à mesa.",
    ],
    
    // Classe 2: VESTUÁRIO
    "2a" => [
        "descricao" => "Em cada faixa etária, a criança apresentou dificuldades em vestir ou despir peças de roupa correspondentes à sua idade, indicando atraso na independência e coordenação para lidar com fechos, botões e outros detalhes do vestuário.",
    ],
    
    "2b" => [
        "1-2" => "Não pendurou o casaco, mostrando dependência para guardar roupas.",
        "3-4" => "Não pendurou roupas no cabide quando solicitado, prejudicando organização.",
        "5-6" => "Falhou em guardar roupas no armário, indicando falta de autonomia para organizar itens pessoais.",
    ],
    
    // Classe 3: HIGIENE PESSOAL
    "3a" => [
        "1-2" => "Não lavou mãos ou rosto sozinho, demonstrando dependência para higiene básica.",
        "2-3" => "Falhou em usar sabonete ou enxugar mãos adequadamente, indicando atraso na rotina de higiene.",
        "4-5" => "Não lavou as mãos e o rosto sem lembretes, prejudicando a autonomia em cuidados pessoais.",
    ],
    
    "3b" => [
        "1-2" => "Não avisou necessidade de ir ao banheiro quando solicitado, sugerindo falta de percepção corporal.",
        "2-3" => "Não controlou esfíncteres consistentemente ou não usou o potty, atrasando a independência no banheiro.",
        "3-4" => "Falha em urinar em pé (meninos) ou em avisar a tempo para usar o banheiro, indicando consolidação incompleta do treino ao toalete.",
        "5-6" => "Não encontrou o banheiro em público corretamente, demonstrando insegurança em situações novas.",
    ],
    
    "3c" => [
        "2-3" => "Não controlou a baba adequadamente, sugerindo atraso em habilidades de auto-regulação oral.",
    ],
    
    "3d" => [
        "3-4" => "Não assoou o nariz quando lembrado, evidenciando atraso na higiene nasal.",
        "4-5" => "Falhou em assuar o nariz espontaneamente, afetando a higiene pessoal.",
    ],
    
    "3e" => [
        "4-5" => "Não penteou ou escovou o cabelo sozinho, apontando atraso na autogestão da aparência.",
    ],
    
    "3f" => [
        "2-3" => "Não escovou os dentes com instrução, sugerindo atraso na higiene bucal inicial.",
        "3-4" => "Falhou em escovar os dentes ao receber orientação, demonstrando dependência.",
        "4-5" => "Não escovou os dentes sozinho, indicando falta de autonomia e hábito consolidado.",
    ],
    
    "3g" => [
        "2-3" => "Não colaborou no banho ou não lavou determinadas partes do corpo, mostrando dependência.",
        "4-5" => "Falhou ao tomar banho sozinho, precisando de ajuda em áreas específicas.",
        "5-6" => "Não ajustou a temperatura da água para o banho, indicando falta de habilidade na gestão do próprio banho.",
    ],
    
    // Classe 4: EVITAR RISCOS
    "4" => [
        "2-3" => "Não evitou riscos básicos (objetos pontiagudos, escadas sem proteção), sugerindo pouca consciência de perigo inicial.",
        "3-4" => "Falhou em evitar acidentes corriqueiros, prejudicando a segurança pessoal.",
        "4-5" => "Não demonstrou cautela suficiente em situações potencialmente perigosas, indicando atraso na percepção e resposta a riscos.",
        "5-6" => "Não demonstrou cautela suficiente em situações potencialmente perigosas, indicando atraso na percepção e resposta a riscos.",
    ],
    
    // Classe 5: REALIZAR TAREFAS DOMÉSTICAS
    "5" => [
        "4-5" => "Não limpou o que derramou ou realizou tarefa doméstica simples ao ser lembrado, apontando baixo engajamento em atividades domésticas.",
        "5-6" => "Falha em executar tarefas diárias ou semanais com responsabilidade, indicando atraso na assunção de responsabilidades em casa.",
    ],

];

// Função para ordenar faixas etárias
function get_age_order($age_range) {
    $parts = explode('-', $age_range);
    return intval($parts[0]);
}

// Função para processar as respostas e gerar o relatório
function generate_report($json_data, $item_mapping, $standard_responses) {
    $input = json_decode($json_data, true);
    
    if ($input === null) {
        return "Erro: JSON inválido.";
    }
    
    $class_failures = [];
    
    foreach ($input as $item => $value) {
        if ($value == 1 && isset($item_mapping[$item])) {
            $class = $item_mapping[$item]['class'];
            $age_range = $item_mapping[$item]['age_range'];
            $age_order = get_age_order($age_range);
            
            if (!isset($class_failures[$class])) {
                $class_failures[$class] = [
                    "age_range" => $age_range,
                    "age_order" => $age_order,
                ];
            } else {
                if ($age_order < $class_failures[$class]['age_order']) {
                    $class_failures[$class] = [
                        "age_range" => $age_range,
                        "age_order" => $age_order,
                    ];
                }
            }
        }
    }
    
    $report = [];
    
    foreach ($class_failures as $class => $info) {
        $age_range = $info['age_range'];
        if (isset($standard_responses[$class][$age_range])) {
            $report[] = $standard_responses[$class][$age_range];
        }
    }
    
    if (empty($report)) {
        return "Nenhuma falha identificada nos itens avaliados.";
    } else {
        $output = "Relatório de Autocuidados:\n\n";
        foreach ($report as $index => $response) {
            $output .= ($index + 1) . ". " . $response . "\n\n";
        }
        return $output;
    }
}

// Gerar e exibir o relatório
$relatorio = generate_report($json_input, $item_mapping, $standard_responses);
echo $relatorio;
?>