<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Plano de Intervenção - Portage</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet"/>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"/>
  <style>
    /* Reset básico */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    /* Estilo Geral */
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f9fafb;
      color: #2d3748;
      padding-top: 60px; /* Espaço para o cabeçalho fixo */
      padding-left: 10px;
      padding-right: 10px;
      padding-bottom: 20px;
    }

    /* Seção de Informações no Topo */
    .info-section {
      max-width: 900px;
      margin: auto;
      background-color: #ffffff;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.05);
      padding: 15px;
      margin-bottom: 20px;
    }
    .info-section .child-name {
      font-size: 1.2em;
      font-weight: 800;
      color: #2c3e50;
      margin-bottom: 8px;
    }
    .info-section .current-date {
      font-size: 0.95em;
      color: #555;
    }

    .container {
      max-width: 900px;
      margin: auto;
      padding: 20px;
      background-color: #ffffff;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    
    /* Cabeçalho */
    header {
      text-align: center;
      margin-bottom: 30px;
    }

    header h1 {
      font-size: 2em;
      color: #2c3e50;
      margin-bottom: 5px;
    }

    header p {
      font-size: 1em;
      color: #7f8c8d;
    }

    /* Botão de Salvar Global */
    .print-button {
      display: inline-block;
      padding: 8px 16px;
      margin-top: 15px;
      background-color: #08C89E;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      font-size: 1em;
      text-align: center;
      cursor: pointer;
      transition: background-color 0.3s;
    }

    .print-button:hover {
      background-color: #069f7a;
    }

    /* Seções de Áreas */
    .area {
      margin-bottom: 40px;
    }

    .area-header {
      display: flex;
      align-items: center;
      margin-bottom: 15px;
      border-bottom: 1px solid #e0e0e0;
      padding-bottom: 5px;
    }

    .area-header img {
      width: 24px;
      height: 24px;
      margin-right: 10px;
      opacity: 0.7;
    }

    .area-header h2 {
      font-size: 1.4em;
      color: #08C89E;
      margin-bottom: 0;
    }

    /* Itens de Intervenção (Portage Cards) */
    .portage-card {
      background: #ffffff;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.05);
      transition: box-shadow 0.3s ease, border 0.3s ease;
    }

    .portage-card:hover {
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    .checkbox-title {
      font-weight: 600;
      margin-bottom: 5px;
      font-size: 14px;
      color: #2d3748;
      line-height: 1.2;
    }

    /* Ações de Habilidade (Radio Buttons) */
    .skill-actions {
      display: flex;
      justify-content: space-between;
      gap: 10px;
      margin-top: 15px;
      padding: 10px 0;
    }

    .skill-actions .option {
      flex: 1 1 45%;
    }

    .skill-actions .option label {
      display: block;
      padding: 10px;
      border: 1px solid #e2e8f0;
      border-radius: 6px;
      text-align: center;
      cursor: pointer;
      transition: background-color 0.3s, border-color 0.3s;
    }

    .skill-actions .option input[type="radio"] {
      display: none;
    }

    /* Estilização para as opções selecionadas com cores sutis */
    .skill-actions .option input[type="radio"]:checked + label {
      background-color: #6abf69; /* Tom suave de verde para "Passou" */
      color: white;
      border-color: #6abf69;
    }

    .skill-actions .option input[type="radio"][value="Falha"]:checked + label {
      background-color: #f06c6c; /* Tom suave de vermelho para "Falha" */
      color: white;
      border-color: #f06c6c;
    }

    /* Toggle de Orientações */
    .portage-orientation-toggle {
      display: flex;
      align-items: center;
      gap: 5px;
      cursor: pointer;
      color: #3182ce;
      font-size: 14px;
      margin-top: 10px;
    }

    .portage-orientation-toggle i {
      transition: transform 0.3s;
    }

    .portage-orientation-toggle.rotate i {
      transform: rotate(180deg);
    }

    .portage-orientation-text {
      display: none;
      font-size: 13px;
      line-height: 1.2;
      color: #4a5568;
      margin-top: 10px;
    }

    .portage-orientation-text ol {
      padding-left: 10px;
      list-style-type: decimal;
      margin-bottom: 20px;
    }

    .portage-orientation-text li {
      margin-bottom: 10px;
      font-size: 12px;
      color: #555;
    }

    .portage-orientation-text li::marker {
      color: #007BFF;
      font-weight: bold;
    }

    .portage-orientation-text li:hover {
      background-color: #eef9ff;
      cursor: pointer;
    }

    .portage-orientation-text li:last-child {
      margin-bottom: 0;
    }

    /* Rodapé */
    footer {
      text-align: center;
      margin-top: 40px;
      font-size: 0.9em;
      color: #95a5a6;
      border-top: 1px solid #e2e8f0;
      padding-top: 10px;
    }

    /* Estilos para Impressão */
    @media print {
      body { padding: 0; }
      .info-section, .print-button {
        display: none;
      }
      .container {
        border: none;
        padding: 0;
        margin: 0;
        box-shadow: none;
      }
      .area-header img {
        display: none;
      }
      .portage-card {
        border: 2px solid #2c3e50;
        background-color: #fff;
        box-shadow: none;
      }
      .portage-orientation-toggle,
      .portage-orientation-text {
        display: none;
      }
      .skill-actions .option label {
        border: none;
        background-color: transparent;
        color: #2d3748;
      }
      .skill-actions .option input[type="radio"]:checked + label {
        background-color: transparent;
        color: #2d3748;
        border-color: transparent;
      }
      .portage-orientation-text ol li::marker {
        color: #000;
      }
    }

    /* Responsividade para Dispositivos Móveis */
    @media (max-width: 768px) {
      .info-section { padding: 15px; }
      .container {
        padding: 15px;
        width: 100%;
        box-sizing: border-box;
      }

      header h1 {
        font-size: 1.6em;
      }

      header p {
        font-size: 0.9em;
      }

      .area-header h2 {
        font-size: 1.2em;
      }

      .portage-card {
        padding: 12px;
      }

      .checkbox-title {
        font-size: 13px;
      }

      .skill-actions {
        flex-direction: row;
        gap: 10px;
      }

      .skill-actions .option {
        flex: 1 1 45%;
      }

      .skill-actions .option label {
        font-size: 0.95em;
        padding: 8px;
      }

      .portage-orientation-toggle {
        font-size: 13px;
      }

      .portage-orientation-text ol li {
        font-size: 11px;
      }
    }

    /* Estilos para Telas Menores (Smartphones) */
    @media (max-width: 480px) {
      .info-section { padding: 10px; }
      header h1 {
        font-size: 1.4em;
      }

      header p {
        font-size: 0.8em;
      }

      .area-header h2 {
        font-size: 1.1em;
      }

      .portage-card {
        padding: 10px;
      }

      .checkbox-title {
        font-size: 12px;
      }

      .skill-actions {
        flex-direction: row;
        gap: 10px;
      }

      .skill-actions .option {
        flex: 1 1 45%;
      }

      .skill-actions .option label {
        font-size: 0.9em;
        padding: 8px;
      }

      .portage-orientation-toggle {
        font-size: 12px;
      }
    }
    /* Navbar */
    .navbar {
      background-color: #08C89E;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      z-index: 1000;
      padding: 10px 20px;
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .navbar-brand {
      color: #fff;
      font-weight: 600;
      font-size: 1.2em;
      text-decoration: none;
      text-align: center;
    }

    .item-class {
  font-size: 0.7em;
  color: #4a5568;
  margin-bottom: 4px;
  line-height: 1.2;
}

.item-description {
  font-size: 0.7em;
  color: #555;
  margin-top: 6px;
  line-height: 1.2;
}
  </style>
</head>
<body>
  <nav class="navbar">
    <a href="#" class="navbar-brand">Plano de Intervenção</a>
  </nav>

  <div class="container">
    <header>
      <h1>Plano de Intervenção</h1>
      <p>Inventário Operacionalizado Portage</p>
      
      <div class="child-name">Helena Silva Simon</div>
    <!-- Exibir data atual dinamicamente, ou insira manualmente -->
    <div class="current-date" id="currentDate"></div>
      
      <!-- Botão de Salvar Global -->
      <a href="#" class="print-button" onclick="salvarTodas()">Salvar</a>
    </header>

    <!-- Área de Socialização -->
    <div class="area">
          <div class="area-header">
            <img src="https://img.icons8.com/ios-filled/50/000000/conference-call.png" alt="Socialização"/>
            <h2>Socialização</h2>
          </div>
    
        <?php include '6_plano_intervencao-social.php'; ?>
        
    </div>

    <!-- Área de Cognição -->
    <div class="area">
      <div class="area-header">
        <img src="https://img.icons8.com/ios-filled/50/000000/brain.png" alt="Cognição"/>
        <h2>Cognição</h2>
      </div>

      <?php include '6_plano_intervencao-cognicao.php'; ?>

    </div>
    
    <!-- Área de Linguagem -->
    <div class="area">
      <div class="area-header">
        <img src="https://img.icons8.com/ios-filled/50/000000/comments.png" alt="Linguagem"/>
        <h2>Linguagem</h2>
      </div>

      <?php include '6_plano_intervencao-linguagem.php'; ?>

    </div>
    
    <!-- Área de Autocuidado -->
    <div class="area">
      <div class="area-header">
        <img src="https://img.icons8.com/ios-filled/50/000000/tooth.png" alt="Autocuidado"/>
        <h2>Autocuidado</h2>
      </div>

      <?php include '6_plano_intervencao-autocuidado.php'; ?>

    </div>
    
    <!-- Área de Motor -->
    <div class="area">
      <div class="area-header">
        <img src="https://img.icons8.com/ios-filled/50/000000/running.png" alt="Motor"/>
        <h2>Desenvolvimento Motor</h2>
      </div>

      <?php include '6_plano_intervencao-motor.php'; ?>

    </div>
    
    

    <!-- Adicione mais áreas conforme necessário -->

    <footer>
      <p>Este plano de intervenção foi elaborado para estimular o desenvolvimento do seu filho(a). Em caso de dúvidas, consulte um especialista.</p>
    </footer>
  </div>

  <script>
    // Função para exibir a data atual no formato DD/MM/AAAA (pode ajustar conforme necessário)
    function exibirDataAtual() {
      const data = new Date();
      const dia = String(data.getDate()).padStart(2, '0');
      const mes = String(data.getMonth() + 1).padStart(2, '0');
      const ano = data.getFullYear();
      // Ajuste o formato da data conforme desejado
      return `${dia}/${mes}/${ano}`;
    }

    // Função para alternar a exibição das orientações
    function toggleOrientation(id) {
      const orientationText = document.getElementById(id);
      const toggleButton = orientationText.previousElementSibling;
      if (orientationText.style.display === "block") {
        orientationText.style.display = "none";
        toggleButton.classList.remove('rotate');
      } else {
        orientationText.style.display = "block";
        toggleButton.classList.add('rotate');
      }
    }

    // Função para ação do botão global Salvar
    function salvarTodas() {
      // Lógica para salvar globalmente as escolhas do usuário.
      alert('As opções foram salvas com sucesso!');
    }

    // Ao carregar a página, abre todas as orientações e exibe a data
    window.onload = function() {
      // Exibir data atual
      const currentDateElem = document.getElementById('currentDate');
      currentDateElem.textContent = `Data de hoje: ${exibirDataAtual()}`;

      // Abrir todas as orientações
      const allOrientationTexts = document.querySelectorAll('.portage-orientation-text');
      const allToggleButtons = document.querySelectorAll('.portage-orientation-toggle');
      allOrientationTexts.forEach(text => {
        text.style.display = "block";
      });
      allToggleButtons.forEach(btn => {
        btn.classList.add('rotate');
      });
    }
  </script>
</body>
</html>
