<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checklist PORTAGE - Avaliação Móvel</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
            padding-top: 70px; /* Espaço para o cabeçalho fixo */
        }
        
        .container {
      max-width: 900px;
      margin: auto;
      padding: 20px;
      background-color: #ffffff;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.05);
      margin-bottom: 30px;
    }

        h3, h4, h5 {
            color: #08C89E;
            margin-bottom: 15px;
        }

        p {
            font-size: 14px;
            color: #4a5568;
        }

        .info-section {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px 10px 0px 10px;
            margin-bottom: 20px;
            margin-left: 20px;
            margin-right: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .info-section h5 {
            color: #08C89E;
            margin-bottom: 10px;
        }

        .info-section p {
            margin-bottom: 5px;
        }

        .avaliacoes-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .checklist-left-section {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
            width: 100%;
            margin-bottom: 10px;
        }

        /* Estilização dos Botões */
        .checklist-editar-btn,
        .btn-back,
        .btn-save,
        .btn-load {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 5px;
            color: white;
        }

        .btn-back {
            background-color: #4a5568;
        }

        .btn-back:hover {
            background-color: #2d3748;
        }

        .btn-save {
            background-color: #08C89E;
        }

        .btn-save:hover {
            background-color: #069f7a;
        }

        .btn-load {
            background-color: #3182ce;
        }

        .btn-load:hover {
            background-color: #2c5282;
        }

        /* Responsividade */
        @media (max-width: 576px) {
            .avaliacoes-container {
                flex-direction: column;
                align-items: stretch;
            }

            .checklist-left-section {
                width: 100%;
                justify-content: center;
            }

            .checklist-avaliacao-select {
                width: 100%;
                margin-top: 10px;
            }
        }

        /* Card renomeado para evitar conflitos */
        .portage-card {
            background: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: box-shadow 0.3s ease, border 0.3s ease;
            cursor: pointer;
        }

        .portage-card:hover {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        /* Estilo quando card estiver selecionado */
        .portage-card.selected {
           
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .checkbox-title {
            font-weight: 600;
            margin-bottom: 5px;
            font-size: 13px;
            color: #2d3748;
            line-height: 1.2;

        }

        .skill-description {
            font-size: 13px;
            color: #4a5568;
            margin-bottom: 10px;
        }

        .skill-actions {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            border-top: 1px solid #e2e8f0;
            border-bottom: 1px solid #e2e8f0;
            padding: 10px 0;
            font-size: 13px;
        }

        .skill-actions .option {
            flex: 1;
            text-align: center;
        }

        .skill-actions .option:not(:last-child) {
            border-right: 1px solid #e2e8f0;
        }

        .skill-actions .option:last-child {
            border-right: none;
        }

        .skill-actions .option label {
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }

        .skill-actions .option input[type="radio"] {
            margin-right: 5px;
        }

        /* Renomeando classes de orientação */
        .portage-orientation-toggle {
            display: flex;
            align-items: center;
            gap: 5px;
            cursor: pointer;
            color: #3182ce;
            font-size: 14px;
        }

        .portage-orientation-text {
            margin-top: 10px;
            display: none;
            font-size: 13px;
            line-height: 1.2;
            color: #4a5568;
            font-size: 11px;
        }
        
        .portage-orientation-text ol {
            padding-left: 10px; /* Alinhar a lista com uma margem à esquerda */
            list-style-type: decimal; /* Números em formato decimal */
            margin-bottom: 20px; /* Espaço abaixo da lista */
        }
        
        .portage-orientation-text li {
            margin-bottom: 10px; /* Espaçamento entre os itens da lista */
            font-size: 12px; /* Tamanho da fonte dos itens */
            color: #555; /* Cor do texto dos itens da lista */
            font-size: 11px;
        }
        
        .portage-orientation-text li::marker {
            color: #007BFF; /* Cor personalizada para os números da lista */
            font-weight: bold; /* Negrito para os números */
        }
        
        .portage-orientation-text li:hover {
            background-color: #eef9ff; /* Cor de fundo suave quando o item é passado o mouse sobre */
            cursor: pointer; /* Mostrar cursor de clique */
        }
        
        .portage-orientation-text li:last-child {
            margin-bottom: 0; /* Remover margem do último item */
        }
        
        .portage-orientation-text p {
            margin-bottom: 8px;
            font-size: 11px;
        }

        /* Ícone de seta rotacionar quando ativo */
        .portage-orientation-toggle.rotate i {
            transform: rotate(180deg);
            transition: transform 0.3s;
        }

        /* Modal Customizado */
        .modal-header {
            background-color: #08C89E;
            color: white;
            border-bottom: none;
        }

        .modal-footer {
            border-top: none;
        }
        
        /* Estilização Geral das Abas */
        .nav-tabs {
            border-bottom: 2px solid #08C89E; /* Linha inferior das abas principais */
        }

        .nav-tabs .nav-link {
            color: #4a5568; /* Cor do texto das abas */
            font-weight: 600; /* Peso da fonte */
            border: none; /* Remove bordas padrão */
            border-radius: 10px 10px 0px 0px; /* Remove bordas arredondadas */
            margin-right: 0px; /* Espaçamento entre as abas */
            padding: 10px 15px; /* Padding interno das abas */
            transition: background-color 0.3s, color 0.3s; /* Transições suaves */
            border-bottom: 1px solid #e2e8f0; /* Borda das abas */
            
        }

        .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da aba ativa */
            background-color: #08C89E; /* Fundo da aba ativa */
            border-bottom: 2px solid #08C89E; /* Linha inferior da aba ativa */
            
        }

        /* Estilização das Sub-Abas */
        .tab-content .nav-tabs {
            border-bottom: 1px solid #e2e8f0; /* Linha inferior das sub-abas */
            margin-bottom: 15px; /* Espaçamento abaixo das sub-abas */
        }

        .tab-content .nav-tabs .nav-link {
            color: #2d3748; /* Cor do texto das sub-abas */
            background-color: #f5f8fb; /* Fundo das sub-abas */
            font-weight: 500; /* Peso da fonte */
            margin-right: 2px;
            border: 1px solid #e2e8f0;
            
        }

        .tab-content .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da sub-aba ativa */
            background-color: #3182ce; /* Fundo da sub-aba ativa */
            border-bottom: none; /* Remove a linha inferior da sub-aba ativa */
            border: 1px solid #3182ce;
        }

        /* Estilização das Páginas das Abas (Tab Panes) */
        .tab-pane {
            padding: 20px; /* Padding interno das abas */
            background-color: #08C89E; /* Fundo das abas */
            border: 1px solid #08C89E; /* Borda das abas */
            border-top: none; /* Remove a borda superior para conectar com as abas */
            border-radius: 0 0 8px 8px; /* Bordas arredondadas na parte inferior */
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05); /* Sombra sutil */
            transition: opacity 0.3s ease-in-out; /* Transição de opacidade suave */
            opacity: 0; /* Opacidade inicial */
            height: 100%; /* Altura completa */
        }

        .tab-pane.show {
            opacity: 1; /* Opacidade quando a aba está ativa */
        }

        /* Estilização para Abas Aninhadas */
        .tab-content .tab-content .nav-tabs {
            border-bottom: 1px solid #cbd5e0; /* Linha inferior das sub-sub-abas */
            margin-bottom: 10px; /* Espaçamento abaixo das sub-sub-abas */
        }

        .tab-content .tab-content .nav-tabs .nav-link {
            color: #2d3748; /* Cor do texto das sub-sub-abas */
            background-color: #edf2f7; /* Fundo das sub-sub-abas */
            font-weight: 500; /* Peso da fonte */
            margin-right: 2px;
            
        }

        .tab-content .tab-content .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da sub-sub-aba ativa */
            background-color: #2b6cb0; /* Fundo da sub-sub-aba ativa */
            border-bottom: none; /* Remove a borda inferior da sub-sub-aba ativa */
        }

        .tab-content .tab-content .tab-pane {
            padding: 15px; /* Padding interno das sub-abas */
            background-color: #e9f4ff; /* Fundo das sub-abas */
            border: 1px solid #cbd5e0; /* Borda das sub-abas */
            border-top: none; /* Remove a borda superior para conectar com as sub-abas */
            border-radius: 0 0 6px 6px; /* Bordas arredondadas na parte inferior */
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05); /* Sombra sutil */
        }

        .tab-content .tab-content .tab-pane.show {
            opacity: 1; /* Opacidade quando a sub-aba está ativa */
        }

        /* Transições Suaves para Abas Aninhadas */
        .tab-content .tab-content .tab-pane {
            transition: opacity 0.3s ease-in-out;
            opacity: 0;
        }

        /* Responsividade para Dispositivos Móveis */
        @media (max-width: 768px) {
            body {
                padding: 0px;
                margin-top: 70px;
            }
            
            .nav-tabs .nav-link {
                padding: 8px 12px; /* Reduz o padding em telas menores */
                font-size: 14px; /* Reduz o tamanho da fonte */
            }

            .tab-content .nav-tabs .nav-link {
                padding: 6px 10px; /* Reduz o padding das sub-abas */
                font-size: 13px; /* Reduz o tamanho da fonte das sub-abas */
            }

            .tab-content .tab-content .nav-tabs .nav-link {
                padding: 5px 8px; /* Reduz ainda mais o padding das sub-sub-abas */
                font-size: 12px; /* Reduz o tamanho da fonte das sub-sub-abas */
            }

            .tab-pane, .tab-content .tab-content .tab-pane {
                padding: 5px; /* Ajusta o padding interno */
            }
            
            .container {
                max-width: 100%; /* Garante que a largura seja 100% */
                padding-left: 0px; /* Pode adicionar algum padding se necessário */
                padding-right: 0px;
                background-color: #eaeef1;
                border: NONE;
                margin-top: -15px;
                border-radius: 0px;
                
            }
            
        }

        /* Melhorias Visuais para Padrões de Abas */
        .tab-content .tab-content .nav-tabs .nav-link:hover {
            background-color: #2c5282; /* Fundo das sub-sub-abas ao passar o mouse */
        }

        /* Scroll suave para mobile */
        .tab-content {
            overflow-x: auto;
        }
        
        /* Navbar Customizada */
        .navbar {
            background-color: #08C89E;
        }

        .navbar-brand, .navbar-nav .nav-link, .navbar-toggler-icon {
            color: #fff !important;
        }
        
        /* Cores suaves para feedback visual */
        .bg-sim {
            background-color: #d4f8d4 !important; /* verde suave */
        }
        
        .bg-av {
            background-color: #ffd8b1 !important; /* laranja suave */
        }
        
        .bg-nao {
            background-color: #f8d4d4 !important; /* vermelho suave */
        }
        
        
        .checkbox-interpretation {
            font-size: 11px;
            color: #6b7280;        /* Tom de cinza suave para o texto */
            margin-top: 4px;
            padding: 4px 0;        /* Pequeno espaçamento superior e inferior */
            font-style: italic;    /* Estilo itálico para diferenciação sutil */
            line-height: 1.2;
        }



.nav-tabs {
    display: flex;
    justify-content: center;
    width: 100%;
    padding-left: 0; /* Remove o espaçamento à esquerda */
    padding-right: 0; /* Remove o espaçamento à direita */
}

.nav-tabs .nav-item {
    flex-grow: 1; /* Permite que cada item cresça igualmente */
    text-align: center; /* Centraliza o conteúdo das abas */
}

.nav-tabs .nav-link {
    text-align: center; /* Garante que o texto das abas fique centralizado */
    padding: 5px 5px; /* Espaçamento interno da aba */
    width: 100%; /* Faz a aba ocupar toda a largura disponível */
    display: block; /* Para garantir que ocupe 100% da largura do item */
}


    </style>
</head>
<body>
    <!-- Cabeçalho (Navbar) -->
    <!-- Navbar Fixa -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <a class="navbar-brand" href="#">IFCora - Portage</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mobileNavbar" aria-controls="mobileNavbar" aria-expanded="false" aria-label="Alternar navegação">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="mobileNavbar">
            <ul class="navbar-nav mr-auto">
                
                <!-- Adicione mais itens de navegação conforme necessário -->
            </ul>
            <ul class="navbar-nav">
                
                <li class="nav-item">
                    <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
                </li>
            </ul>
        </div>
    </nav>
    
    <div class="container">
        <!-- <h3>Checklist PORTAGE</h3>
        <p style="margin-top:-20px">Toque nas orientações para expandir dicas e informações adicionais.</p> -->

        <!-- Seção de Informações sobre a Criança, Profissional e Avaliação (Compacta com Accordion) -->
        <div class="info-section">
            <h5 data-toggle="collapse" href="#infoContent" role="button" aria-expanded="false" aria-controls="infoContent">
                <i class="fas fa-user"></i> Informações da Avaliação <i class="fas fa-chevron-down float-right"></i>
            </h5>
            <div class="collapse info-content" id="infoContent">
                <div class="row">
                    <!-- Informações da Criança -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-child"></i> Criança</h6>
                        <p><strong>Nome:</strong> Helena Silva Simon</p>
                        <p><strong>Dt/N:</strong> 20/05/2018 (6 anos)</p>
                        <p><strong>Gênero:</strong> Feminino</p>
                    </div>
                    <!-- Informações do Profissional -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-user-md"></i> Profissional</h6>
                        <p><strong>Nome:</strong> Coralina Da Silva Matos Simon</p>
                        <p><strong>Especialidade:</strong> Terapeuta Ocupacional</p>
                        
                    </div>
                    <!-- Informações da Avaliação -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-file-alt"></i> Avaliação</h6>
                        <p><strong>ID Avaliação:</strong> AV27490</p>
                        <p><strong>Data:</strong> 28/06/2024</p>
                        <p><strong>Status:</strong> Aberta</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Seção de Gerenciamento de Avaliações -->
<div class="avaliacoes-container" style="display: flex; justify-content: space-between; align-items: center; padding: 0px;">
    <div class="checklist-left-section" style="display: flex; gap: 10px;">
        <!-- Botão Voltar -->
        <button type="button" class="btn-back" id="backBtn" 
            style="padding: 5px 10px; background-color: #f1f1f1; border: 1px solid #ddd; border-radius: 5px; color: #234EA1; font-size: 1rem; cursor: pointer; transition: background-color 0.3s ease, color 0.3s ease;">
            <i class="fas fa-arrow-left" style="margin-right: 8px;"></i> Voltar
        </button>

        <!-- Botão Salvar -->
        <button type="button" class="btn-save" id="saveBtn" 
            style="padding: 5px 10px; background-color: #08CA9D; border: 1px solid #08CA9D; border-radius: 5px; color: white; font-size: 1rem; cursor: pointer; transition: background-color 0.3s ease, transform 0.2s ease;">
            <i class="fas fa-save" style="margin-right: 8px;"></i> Salvar
        </button>

        <!-- Botão Finalizar -->
        <button type="button" class="btn-finish" id="finishBtn" 
            style="padding: 5px 10px; background-color: #234EA1; border: 1px solid #234EA1; border-radius: 5px; color: white; font-size: 1rem; cursor: pointer; transition: background-color 0.3s ease, transform 0.2s ease;">
            <i class="fas fa-check-circle" style="margin-right: 8px;"></i> Finalizar
        </button>
    </div>
</div>
        
        <!-- Abas de áreas de desenvolvimento -->
        <ul class="nav nav-tabs" id="areaTabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" href="#social" data-toggle="tab" role="tab" aria-controls="social" aria-selected="false"><i class="fas fa-user-friends"></i></i> Soc.</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#cognicao" data-toggle="tab" role="tab" aria-controls="cognicao" aria-selected="false"><i class="fas fa-brain"></i> Cog.</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#linguagem" data-toggle="tab" role="tab" aria-controls="linguagem" aria-selected="false"><i class="fa-solid fa-comment-dots"></i> Ling.</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#autocuidado" data-toggle="tab" role="tab" aria-controls="autocuidado" aria-selected="false"><i class="fas fa-hands-wash"></i> Aut.</a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="#motor" data-toggle="tab" role="tab" aria-controls="motor" aria-selected="true"><i class="fas fa-running"></i> Mot.</a>
            </li>
        </ul>

        <div class="tab-content nested-tab-content">
            <!-- Área Social -->
            <?php include 'painel-clinica-perfil-criança-portage-novo_pSocial.php'; ?>
            
        
            
            <!-- Área Cognição -->
            <?php include 'painel-clinica-perfil-criança-portage-novo_pCognicao.php'; ?>
            
            <!-- Área Linguagem -->
            <?php include 'painel-clinica-perfil-criança-portage-novo_pLinguagem.php'; ?>
            
            <!-- Área Autocuidado ok -->
            <?php include 'painel-clinica-perfil-criança-portage-novo_pAutocuidado.php'; ?>
            
            <!-- Área Motor ok -->
            <?php include 'painel-clinica-perfil-criança-portage-novo_pMotor.php'; ?>
            
        </div>

        <!-- Scripts Bootstrap e jQuery -->
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
        
        <script>
            function scrollToTop() {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth' // Rolagem suave
                });
            }
        </script>

        <!-- Custom JavaScript -->
        <script>
        document.addEventListener('DOMContentLoaded', () => {

            // Mapeamento de área -> prefixo -> are
            const areaMap = {
                'social':       { are: 1, prefix: 'S' },
                'cognicao':     { are: 2, prefix: 'C' },
                'linguagem':    { are: 3, prefix: 'L' },
                'autocuidado':  { are: 4, prefix: 'A' },
                'motor':        { are: 5, prefix: 'M' }
            };

            // Mapeamento de faixa etária -> nvl
            const faixaMap = {
                '0_1': 1,
                '1_2': 2,
                '2_3': 3,
                '3_4': 4,
                '4_5': 5,
                '5_6': 6
            };

            // Mapeamento de respostas para números
            // 1 = Não, 2 = Ás vezes, 3 = Sim
            const respostaMap = {
                'Não': 1,
                'AV': 2,
                'Sim': 3
            };

            /**
             * name do input (ex: "social0_1_item2")
             * Formato esperado: [area][faixa]_item[numero]
             * Exemplo: "social0_1_item2"
             *   -> area = "social"  -> are=1, prefix='S'
             *   -> faixa = "0_1"    -> nvl=1
             *   -> item2 -> qst = prefix + 2 => "S2"
             */
            function parseInputName(fullName) {
                // Ex: "social0_1_item2"
                // 1) separar "social0_1" e "item2" -> split por '_item'
                const [areaFaixa, item] = fullName.split('_item');
                // areaFaixa = "social0_1"
                // item = "2"

                // 2) separar "social" de "0_1"
                //    DICA: a string "social0_1" não tem separador fixo,
                //    mas podemos usar regex ou achar os dígitos "0_1".
                //    Exemplo simples: localize "0_1", "1_2", etc. e separe:
                let foundFaixa = '';
                for (const faixaKey in faixaMap) {
                    if (areaFaixa.includes(faixaKey)) {
                        foundFaixa = faixaKey; 
                        break;
                    }
                }
                // foundFaixa = "0_1"
                // areaString = "social"
                const areaString = areaFaixa.replace(foundFaixa, ''); 
                // areaString => "social"

                // 3) Montar as chaves
                const are  = areaMap[areaString].are;       // ex: 1
                const pre  = areaMap[areaString].prefix;    // ex: "S"
                const nvl  = faixaMap[foundFaixa];          // ex: 1
                const qst  = pre + item;                    // ex: "S2"

                return { are, nvl, qst };
            }

            function salvarAvaliacao() {
                // Exemplo: "avl" (ID da avaliação) pode ser gerado ou vindo de outro lugar
                const avlID = "AVA001"; 
                
                // Pegar todos os inputs marcados
                const inputs = document.querySelectorAll('input[type="radio"]:checked');
                
                // Montar array de respostas
                const respostas = [];
                inputs.forEach(input => {
                    const { are, nvl, qst } = parseInputName(input.name);
                    const valorResposta     = respostaMap[input.value] || 0; // se não achar, 0
                    // Monta objeto conforme modelo
                    respostas.push({
                        avl: avlID,
                        are: are,
                        nvl: nvl,
                        qst: qst,
                        rsp: valorResposta
                        // data_resposta será gerada no PHP
                    });
                });

                // Envia via fetch para o PHP
                fetch('salvar_avaliacao.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ respostas: respostas })
                })
                .then(response => response.text())
                .then(data => {
                    alert(data); 
                })
                .catch(error => {
                    console.error('Erro ao salvar:', error);
                });
            }

            // Apenas para limpar o formulário
            function resetarFormulario() {
                const inputs = document.querySelectorAll('input[type="radio"]');
                inputs.forEach(input => (input.checked = false));
                alert('Formulário resetado.');
            }

            // Event Listeners
            document.getElementById('saveBtn').addEventListener('click', salvarAvaliacao);
            document.getElementById('backBtn').addEventListener('click', resetarFormulario);

            // Lógica para exibir/esconder orientações
            const orientationToggles = document.querySelectorAll('.portage-orientation-toggle');
            orientationToggles.forEach(toggle => {
                toggle.addEventListener('click', () => {
                    const targetId = toggle.getAttribute('data-target');
                    const targetElement = document.getElementById(targetId);
                    if (targetElement.style.display === 'block') {
                        targetElement.style.display = 'none';
                        toggle.classList.remove('rotate');
                    } else {
                        targetElement.style.display = 'block';
                        toggle.classList.add('rotate');
                    }
                });
            });

            // Destacar o card ao clicar (opcional)
            const portageCards = document.querySelectorAll('.portage-card');
            portageCards.forEach(card => {
                card.addEventListener('click', (e) => {
                    // Evitar que o clique no input ou no toggle destaque o card
                    if (e.target.tagName.toLowerCase() === 'input' || e.target.closest('.portage-orientation-toggle')) {
                        return;
                    }
                    // Remover destaque de outros cards
                    portageCards.forEach(c => c.classList.remove('selected'));
                    // Destacar o card clicado
                    card.classList.add('selected');
                });
            });
            
            // Lógica para aplicar cor de fundo no cartão ao selecionar uma opção
            const radioButtons = document.querySelectorAll('input[type="radio"]');
            radioButtons.forEach(input => {
                input.addEventListener('change', function() {
                    const card = input.closest('.portage-card');
                    if (!card) return;
        
                    // Remove classes de fundo anteriores
                    card.classList.remove('bg-sim', 'bg-av', 'bg-nao');
        
                    // Aplica a classe conforme a resposta selecionada
                    const valor = input.value;
                    if (valor === 'Sim') {
                        card.classList.add('bg-sim');
                    } else if (valor === 'AV') {
                        card.classList.add('bg-av');
                    } else if (valor === 'Não') {
                        card.classList.add('bg-nao');
                    }
                });
            });
            
            // Lógica para aplicar cor de fundo na div.option ao selecionar uma opção
            // const radioButtons = document.querySelectorAll('input[type="radio"]');
            // radioButtons.forEach(input => {
            //     input.addEventListener('change', function() {
            //        // Localiza o contêiner skill-actions mais próximo
            //        const skillActions = input.closest('.skill-actions');
            //        if (!skillActions) return;
            
                      // Remove classes de fundo de todos os .option dentro do mesmo grupo
            //        const options = skillActions.querySelectorAll('.option');
            //       options.forEach(opt => opt.classList.remove('bg-sim', 'bg-av', 'bg-nao'));
            
            //        // Localiza a div.option que contém o input selecionado
            //        const selectedOption = input.closest('.option');
            //        if (!selectedOption) return;
            
                     // Aplica a classe conforme a resposta selecionada
            //        const valor = input.value;
            //        if (valor === 'Sim') {
            //            selectedOption.classList.add('bg-sim');
            //        } else if (valor === 'AV') {
            //            selectedOption.classList.add('bg-av');
            //        } else if (valor === 'Não') {
            //            selectedOption.classList.add('bg-nao');
            //        }
            //    });
            //    });

        });
    </script>
        
    </div>
</body>
</html>
