<!-- Contêiner Principal com ID Único para Isolamento -->
<div id="graficos" class="tab-pane fade" role="tabpanel" aria-labelledby="graficos">
  <!-- Inclusão dos Scripts Necessários (Certifique-se de que estes estão carregados no HTML principal) -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
  <!-- Remova a linha abaixo se o Bootstrap já estiver incluído no HTML principal -->
  <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> -->

  <!-- Estilos Específicos para o Painel (Isolados para Evitar Conflitos) -->
  <style>
    /* Container das Seções */
    #painelDesenvolvimento .area-secao {
      border: 1px solid #dee2e6;
      border-radius: 8px;
      padding: 20px;
      background-color: #ffffff;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    /* Estilos para os Gráficos */
    #painelDesenvolvimento .grafico-container {
      background: #f7fafc;
      border-radius: 8px;
      padding: 15px;
    }

    /* Estilos para Botões */
    #painelDesenvolvimento .btn {
      min-width: 150px;
    }

    /* Ajustes para Textareas */
    #painelDesenvolvimento textarea {
      resize: vertical;
    }

    /* Mensagem de Sucesso/Ocultação */
    #painelDesenvolvimento .mensagem {
      display: none;
      margin-top: 10px;
    }

    #painelDesenvolvimento .mensagem.show {
      display: block;
    }

    /* Separador Estilizado */
    #painelDesenvolvimento .separador {
      border: none;
      border-top: 2px solid #dee2e6;
      margin: 40px 0;
      position: relative;
    }

    /* Linha Decorativa no Separador */
    #painelDesenvolvimento .separador::after {
      content: '';
      position: absolute;
      top: -12px;
      left: 50%;
      transform: translateX(-50%);
      background-color: #ffffff;
      padding: 0 10px;
    }

    /* Ícone ou Texto no Separador (Opcional) */
    #painelDesenvolvimento .separador::before {
      content: '• • •';
      position: absolute;
      top: -10px;
      left: 50%;
      transform: translateX(-50%);
      font-size: 20px;
      color: #dee2e6;
    }

    /* Responsividade Ajustada */
    @media (max-width: 768px) {
      #painelDesenvolvimento .col-md-6 {
        flex: 0 0 100%;
        max-width: 100%;
      }
    }
  </style>

  <!-- Estrutura das Seções: Socialização, Cognição e Linguagem -->
  <!-- Seção: Socialização -->
  <div class="area-secao mb-5">
    <!-- Título da Área -->
    <h5>Socialização e Desempenho Global por Faixa Etária</h5>
    <div class="row">
      <!-- Coluna do Gráfico -->
      <div class="col-md-6">
        <div class="grafico-container">
          <canvas
            id="graficoSocializacao"
            aria-label="Gráfico de Socialização"
            role="img"
          ></canvas>
        </div>
        <div class="mt-3 d-flex flex-wrap">
          <button
            id="btnExportarImagemSocializacao"
            type="button"
            class="btn btn-secondary me-2 mb-2"
            aria-label="Exportar gráfico de Socialização como imagem"
          >
            Exportar Imagem
          </button>
          <button
            id="btnGerarInterpretacaoSocializacao"
            type="button"
            class="btn btn-primary mb-2"
            aria-label="Gerar interpretação do gráfico de Socialização"
          >
            Gerar Interpretação
          </button>
          <!-- Mensagem de Sucesso -->
          <span id="msgExportarSocializacao" class="mensagem text-success">
            Imagem exportada com sucesso!
          </span>
        </div>
      </div>

      <!-- Coluna do Textarea e Botões de Edição -->
      <div class="col-md-6 d-flex flex-column">
        <label for="interpretacaoSocializacao" class="form-label mt-2">
          Interpretação do Gráfico:
        </label>
        <textarea
          id="interpretacaoSocializacao"
          class="form-control flex-grow-1"
          rows="8"
          placeholder="A interpretação aparecerá aqui..."
          readonly
          aria-readonly="true"
        ></textarea>
        <div class="mt-2">
          <button
            id="btnEditarInterpretacaoSocializacao"
            type="button"
            class="btn btn-warning me-2"
            aria-label="Editar interpretação do gráfico de Socialização"
          >
            Editar Interpretação
          </button>
        </div>
        <div
          id="btnSalvarCancelarSocializacao"
          class="mt-2"
          style="display: none;"
        >
          <button
            id="btnSalvarSocializacao"
            type="button"
            class="btn btn-success me-2"
            aria-label="Salvar interpretação editada de Socialização"
          >
            Salvar
          </button>
          <button
            id="btnCancelarSocializacao"
            type="button"
            class="btn btn-danger"
            aria-label="Cancelar edição da interpretação de Socialização"
          >
            Cancelar
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Separador entre as Áreas -->
  <hr class="separador">

  <!-- Seção: Cognição -->
  <div class="area-secao mb-5">
    <h5>Cognição e Desempenho Global por Faixa Etária</h5>
    <div class="row">
      <div class="col-md-6">
        <div class="grafico-container">
          <canvas
            id="graficoCognicao"
            aria-label="Gráfico de Cognição"
            role="img"
          ></canvas>
        </div>
        <div class="mt-3 d-flex flex-wrap">
          <button
            id="btnExportarImagemCognicao"
            type="button"
            class="btn btn-secondary me-2 mb-2"
            aria-label="Exportar gráfico de Cognição como imagem"
          >
            Exportar Imagem
          </button>
          <button
            id="btnGerarInterpretacaoCognicao"
            type="button"
            class="btn btn-primary mb-2"
            aria-label="Gerar interpretação do gráfico de Cognição"
          >
            Gerar Interpretação
          </button>
          <span id="msgExportarCognicao" class="mensagem text-success">
            Imagem exportada com sucesso!
          </span>
        </div>
      </div>
      <div class="col-md-6 d-flex flex-column">
        <label for="interpretacaoCognicao" class="form-label mt-2">
          Interpretação do Gráfico:
        </label>
        <textarea
          id="interpretacaoCognicao"
          class="form-control flex-grow-1"
          rows="8"
          placeholder="A interpretação aparecerá aqui..."
          readonly
          aria-readonly="true"
        ></textarea>
        <div class="mt-2">
          <button
            id="btnEditarInterpretacaoCognicao"
            type="button"
            class="btn btn-warning me-2"
            aria-label="Editar interpretação do gráfico de Cognição"
          >
            Editar Interpretação
          </button>
        </div>
        <div
          id="btnSalvarCancelarCognicao"
          class="mt-2"
          style="display: none;"
        >
          <button
            id="btnSalvarCognicao"
            type="button"
            class="btn btn-success me-2"
            aria-label="Salvar interpretação editada de Cognição"
          >
            Salvar
          </button>
          <button
            id="btnCancelarCognicao"
            type="button"
            class="btn btn-danger"
            aria-label="Cancelar edição da interpretação de Cognição"
          >
            Cancelar
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Separador entre as Áreas -->
  <hr class="separador">

  <!-- Seção: Linguagem -->
  <div class="area-secao mb-5">
    <h5>Linguagem e Desempenho Global por Faixa Etária</h5>
    <div class="row">
      <div class="col-md-6">
        <div class="grafico-container">
          <canvas
            id="graficoLinguagem"
            aria-label="Gráfico de Linguagem"
            role="img"
          ></canvas>
        </div>
        <div class="mt-3 d-flex flex-wrap">
          <button
            id="btnExportarImagemLinguagem"
            type="button"
            class="btn btn-secondary me-2 mb-2"
            aria-label="Exportar gráfico de Linguagem como imagem"
          >
            Exportar Imagem
          </button>
          <button
            id="btnGerarInterpretacaoLinguagem"
            type="button"
            class="btn btn-primary mb-2"
            aria-label="Gerar interpretação do gráfico de Linguagem"
          >
            Gerar Interpretação
          </button>
          <span id="msgExportarLinguagem" class="mensagem text-success">
            Imagem exportada com sucesso!
          </span>
        </div>
      </div>
      <div class="col-md-6 d-flex flex-column">
        <label for="interpretacaoLinguagem" class="form-label mt-2">
          Interpretação do Gráfico:
        </label>
        <textarea
          id="interpretacaoLinguagem"
          class="form-control flex-grow-1"
          rows="8"
          placeholder="A interpretação aparecerá aqui..."
          readonly
          aria-readonly="true"
        ></textarea>
        <div class="mt-2">
          <button
            id="btnEditarInterpretacaoLinguagem"
            type="button"
            class="btn btn-warning me-2"
            aria-label="Editar interpretação do gráfico de Linguagem"
          >
            Editar Interpretação
          </button>
        </div>
        <div
          id="btnSalvarCancelarLinguagem"
          class="mt-2"
          style="display: none;"
        >
          <button
            id="btnSalvarLinguagem"
            type="button"
            class="btn btn-success me-2"
            aria-label="Salvar interpretação editada de Linguagem"
          >
            Salvar
          </button>
          <button
            id="btnCancelarLinguagem"
            type="button"
            class="btn btn-danger"
            aria-label="Cancelar edição da interpretação de Linguagem"
          >
            Cancelar
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Scripts JavaScript Encapsulados para Isolamento -->
  <script>
    (function() {
      // Objeto para armazenar as interpretações originais
      const interpretacaoOriginal = {
        Socializacao: '',
        Cognicao: '',
        Linguagem: ''
      };

      // Definição das Áreas com Dados
      const areas = [
        {
          nome: 'Socializacao',
          titulo: 'Socialização e Desempenho Global por Faixa Etária',
          idadeBiologica: 28,
          idadeCalculada: 18,
          dados: [70, 48, 30, 50, 60, 20, (18 / 28) * 100]
        },
        {
          nome: 'Cognicao',
          titulo: 'Cognição e Desempenho Global por Faixa Etária',
          idadeBiologica: 30,
          idadeCalculada: 22,
          dados: [75, 55, 40, 60, 65, 25, (22 / 30) * 100]
        },
        {
          nome: 'Linguagem',
          titulo: 'Linguagem e Desempenho Global por Faixa Etária',
          idadeBiologica: 26,
          idadeCalculada: 16,
          dados: [68, 50, 35, 45, 55, 15, (16 / 26) * 100]
        }
      ];

      // Cores Definidas para as Barras
      const coresBarra = [
        'rgba(255, 99, 132, 0.7)', 
        'rgba(54, 162, 235, 0.7)', 
        'rgba(255, 206, 86, 0.7)',
        'rgba(75, 192, 192, 0.7)',
        'rgba(153, 102, 255, 0.7)',
        'rgba(255, 159, 64, 0.7)',
        'rgba(0, 128, 0, 0.7)' // Cor para "Global"
      ];

      const bordasBarra = [
        'rgba(255, 99, 132, 1)', 
        'rgba(54, 162, 235, 1)', 
        'rgba(255, 206, 86, 1)',
        'rgba(75, 192, 192, 1)',
        'rgba(153, 102, 255, 1)',
        'rgba(255, 159, 64, 1)',
        'rgba(0, 128, 0, 1)' // Borda para "Global"
      ];

      // Função para Criar Gráficos
      function criarGrafico(idCanvas, dados, titulo) {
        const ctx = document.getElementById(idCanvas).getContext('2d');
        return new Chart(ctx, {
          type: 'bar',
          data: {
            labels: ['0-1 ano', '1-2 anos', '2-3 anos', '3-4 anos', '4-5 anos', '5-6 anos', 'Global'],
            datasets: [
              {
                label: 'Porcentagem de Desenvolvimento',
                data: dados,
                backgroundColor: coresBarra,
                borderColor: bordasBarra,
                borderWidth: 1
              }
            ]
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
              y: {
                beginAtZero: true,
                max: 100,
                ticks: {
                  stepSize: 10,
                  color: '#000',
                  font: {
                    size: 14
                  }
                },
                title: {
                  display: true,
                  text: 'Porcentagem (%)',
                  font: {
                    size: 16,
                    weight: 'bold'
                  }
                },
                grid: {
                  color: 'rgba(0,0,0,0.1)'
                }
              },
              x: {
                ticks: {
                  color: '#000',
                  font: {
                    size: 14
                  }
                },
                grid: {
                  display: false
                }
              }
            },
            plugins: {
              legend: {
                display: false
              },
              subtitle: {
                display: true,
                text: 'Global = (Idade Calculada / Idade Biológica) x 100 (%)',
                color: '#666',
                font: {
                  size: 14,
                  style: 'italic'
                },
                padding: {
                  top: 0,
                  bottom: 10
                }
              },
              title: {
                display: true,
                text: titulo,
                color: '#000',
                font: {
                  size: 20,
                  weight: 'bold'
                },
                padding: {
                  top: 20,
                  bottom: 10
                }
              },
              tooltip: {
                callbacks: {
                  label: function(context) {
                    if(context.label === 'Global') {
                      return `Global: ${context.raw.toFixed(2)}% (Idade Calculada vs Biológica)`;
                    }
                    return `${context.raw}%`;
                  }
                }
              },
              datalabels: {
                anchor: 'end',
                align: 'end',
                color: '#000',
                font: {
                  weight: 'bold',
                  size: 14
                },
                formatter: function(value) {
                  return `${value.toFixed(2)}%`;
                }
              }
            }
          },
          plugins: [ChartDataLabels]
        });
      }

      // Função para Exportar Gráfico como Imagem
      function exportarGrafico(idGrafico, area) {
        try {
          const grafico = Chart.getChart(idGrafico);
          if (grafico) {
            const imagemBase64 = grafico.toBase64Image();
            const linkDownload = document.createElement('a');
            linkDownload.href = imagemBase64;
            linkDownload.download = `${area}_grafico.png`;
            document.body.appendChild(linkDownload); // Adiciona ao DOM para compatibilidade
            linkDownload.click();
            document.body.removeChild(linkDownload); // Remove após o clique

            // Exibir Mensagem de Sucesso
            const msgId = `msgExportar${area}`;
            const msgElemento = document.getElementById(msgId);
            if (msgElemento) {
              msgElemento.classList.add('show');
              setTimeout(() => {
                msgElemento.classList.remove('show');
              }, 3000); // Oculta após 3 segundos
            }
          } else {
            throw new Error('Gráfico não encontrado!');
          }
        } catch (error) {
          alert(`Erro ao exportar o gráfico: ${error.message}`);
        }
      }

      // Função para Gerar Interpretação
      function gerarInterpretacao(areaObj) {
        const { nome, idadeBiologica, idadeCalculada, dados } = areaObj;
        const valorGlobal = (idadeCalculada / idadeBiologica) * 100;

        const interpretacao = `
**Interpretação do Gráfico: ${nome} e Desempenho Global por Faixa Etária**

1. **Faixa Etária 0-1 ano:** ${dados[0]}% de desenvolvimento, indicando um bom progresso nesta fase inicial.
2. **Faixa Etária 1-2 anos:** ${dados[1]}% de desenvolvimento, mostrando uma diminuição em relação ao período anterior.
3. **Faixa Etária 2-3 anos:** ${dados[2]}% de desenvolvimento, sugerindo um desempenho abaixo do esperado.
4. **Faixa Etária 3-4 anos:** ${dados[3]}% de desenvolvimento, representando uma recuperação parcial.
5. **Faixa Etária 4-5 anos:** ${dados[4]}% de desenvolvimento, indicando uma melhora contínua.
6. **Faixa Etária 5-6 anos:** ${dados[5]}% de desenvolvimento, o menor valor entre as faixas, apontando para áreas que necessitam de maior atenção.
7. **Global:** ${valorGlobal.toFixed(2)}% (Idade Calculada vs Biológica), refletindo o desempenho geral.

**Observações:**
- A tendência geral mostra variações no desenvolvimento ao longo das faixas etárias, com picos e quedas que podem estar relacionados a diferentes fatores.
- A baixa pontuação na faixa etária de 5-6 anos sugere a necessidade de intervenções específicas para melhorar o desempenho.

*Global = (Idade Calculada / Idade Biológica) x 100 (%)*
        `.trim();

        // Inserir a Interpretação no Textarea Correspondente
        const textareaId = `interpretacao${nome}`;
        const textarea = document.getElementById(textareaId);
        if (textarea) {
          textarea.value = interpretacao;
          interpretacaoOriginal[nome] = interpretacao; // Armazenar o Texto Original
        } else {
          console.error(`Textarea com ID ${textareaId} não encontrado.`);
        }
      }

      // Funções para Editar, Salvar e Cancelar Edição
      function editarInterpretacao(area) {
        const textarea = document.getElementById(`interpretacao${area}`);
        const btnSalvarCancelar = document.getElementById(`btnSalvarCancelar${area}`);
        const btnEditar = document.getElementById(`btnEditarInterpretacao${area}`);

        if (textarea && btnSalvarCancelar && btnEditar) {
          textarea.readOnly = false;
          textarea.focus();

          btnSalvarCancelar.style.display = 'block';
          btnEditar.style.display = 'none';
        }
      }

      function salvarInterpretacao(area) {
        const textarea = document.getElementById(`interpretacao${area}`);
        const btnSalvarCancelar = document.getElementById(`btnSalvarCancelar${area}`);
        const btnEditar = document.getElementById(`btnEditarInterpretacao${area}`);

        if (textarea && btnSalvarCancelar && btnEditar) {
          textarea.readOnly = true;
          interpretacaoOriginal[area] = textarea.value; // Atualizar Texto Original

          btnSalvarCancelar.style.display = 'none';
          btnEditar.style.display = 'inline-block';
        }
      }

      function cancelarEdicao(area) {
        const textarea = document.getElementById(`interpretacao${area}`);
        const btnSalvarCancelar = document.getElementById(`btnSalvarCancelar${area}`);
        const btnEditar = document.getElementById(`btnEditarInterpretacao${area}`);

        if (textarea && btnSalvarCancelar && btnEditar) {
          textarea.value = interpretacaoOriginal[area] || '';
          textarea.readOnly = true;

          btnSalvarCancelar.style.display = 'none';
          btnEditar.style.display = 'inline-block';
        }
      }

      // Inicialização dos Gráficos e Associações de Eventos
      function inicializarPainel() {
        // Criar Gráficos para Cada Área
        areas.forEach(area => {
          criarGrafico(`grafico${area.nome}`, area.dados, area.titulo);
        });

        // Associar Eventos aos Botões de Cada Área
        areas.forEach(area => {
          // Botão de Exportar Imagem
          const btnExportar = document.getElementById(`btnExportarImagem${area.nome}`);
          if (btnExportar) {
            btnExportar.addEventListener('click', () => {
              exportarGrafico(`grafico${area.nome}`, area.nome);
            });
          }

          // Botão de Gerar Interpretação
          const btnGerarInterpretacao = document.getElementById(`btnGerarInterpretacao${area.nome}`);
          if (btnGerarInterpretacao) {
            btnGerarInterpretacao.addEventListener('click', () => {
              gerarInterpretacao(area);
            });
          }

          // Botão de Editar Interpretação
          const btnEditarInterpretacao = document.getElementById(`btnEditarInterpretacao${area.nome}`);
          if (btnEditarInterpretacao) {
            btnEditarInterpretacao.addEventListener('click', () => {
              editarInterpretacao(area.nome);
            });
          }

          // Botão de Salvar
          const btnSalvar = document.getElementById(`btnSalvar${area.nome}`);
          if (btnSalvar) {
            btnSalvar.addEventListener('click', () => {
              salvarInterpretacao(area.nome);
            });
          }

          // Botão de Cancelar
          const btnCancelar = document.getElementById(`btnCancelar${area.nome}`);
          if (btnCancelar) {
            btnCancelar.addEventListener('click', () => {
              cancelarEdicao(area.nome);
            });
          }
        });
      }

      // Executar a Inicialização Quando o DOM Estiver Pronto
      document.addEventListener('DOMContentLoaded', inicializarPainel);
    })();
  </script>
</div>
