<?php
// processa_recupera_senha.php

session_start(); // Inicia a sessão

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Filtrar e validar dados de entrada
    $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
    $captcha = trim($_POST['captcha']);
    $form_start_time = isset($_POST['form_start_time']) ? intval($_POST['form_start_time']) : 0;
    $current_time = time();

    // Simular verificação de tempo mínimo para preencher o formulário (ex: 5 segundos)
    if (($current_time - $form_start_time) < 3) {
        die('Formulário preenchido muito rapidamente. Por favor, tente novamente.');
    }

    // Verificar CAPTCHA
    if ($captcha !== '9') { // Quanto é 2 + 7?
        die('CAPTCHA incorreto.');
    }

    // Verificar honeypot
    if (!empty($_POST['honeypot'])) {
        die('Bot detectado.');
    }

    if (!$email) {
        die('E-mail inválido.');
    }

    // Simular verificação de existência do e-mail
    // Neste exemplo, assumimos que qualquer e-mail válido existe
    // Gerar código de recuperação fixo para simulação
    $codigo = '123456';

    // Armazenar o código e o e-mail na sessão
    $_SESSION['recupera_senha'] = [
        'email' => $email,
        'codigo' => $codigo,
        'expira' => $current_time + 900 // 15 minutos de validade
    ];

    // Simular envio de e-mail
    // Para fins de simulação, exibiremos o código na tela
    // Em um ambiente real, você enviaria o código por e-mail

    // Exibir mensagem de sucesso com redirecionamento para verifica_codigo.php
    echo "<!DOCTYPE html>
    <html lang='pt-BR'>
    <head>
        <meta charset='UTF-8'>
        <title>Código Enviado</title>
        <meta http-equiv='refresh' content='5;url=verifica_codigo.php'>
        <style>
            body { font-family: 'Nunito', sans-serif; background-color: #f0f2f5; display: flex; justify-content: center; align-items: center; height: 100vh; }
            .message { background: #fff; padding: 30px; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); text-align: center; }
            .code { font-size: 1.5rem; color: #08CA9D; }
        </style>
    </head>
    <body>
        <div class='message'>
            <h2>Código de Recuperação Enviado!</h2>
            <p>Um código de recuperação foi enviado para o e-mail: <strong>{$email}</strong>.</p>
            <p>Para fins de simulação, seu código é: <span class='code'>{$codigo}</span></p>
            <p>Aguarde enquanto redirecionamos para a próxima etapa...</p>
        </div>
    </body>
    </html>";
    exit();
} else {
    header('Location: recupera_senha.php');
    exit();
}
?>
