<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Gráfico de Socialização e Desempenho Global</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
  <!-- A versão 3 (ou superior) do Chart.js é necessária para o subtitle -->
  <!-- Se estiver usando Chart.js v2, será necessário criar um plugin customizado para inserir texto no gráfico. -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
  <div class="container mt-5">
    <h5>Socialização e Desempenho Global por Faixa Etária</h5>
    <canvas id="graficoCombinado" width="1000" height="500"></canvas>
    <button id="btnExportarImagem" type="button" class="btn btn-secondary mt-3">
      Exportar Gráfico como Imagem
    </button>
  </div>

  <script>
    // Idades de exemplo em meses
    const idadeBiologica = 28;   // Ex: 28 meses
    const idadeCalculada = 18;   // Ex: 18 meses

    // Cálculo do Global como porcentagem (Idade Calculada / Idade Biológica) * 100
    const valorGlobal = (idadeCalculada / idadeBiologica) * 100;

    // Cores definidas para as barras
    const coresBarra = [
      'rgba(255, 99, 132, 1)', 
      'rgba(54, 162, 235, 1)', 
      'rgba(255, 206, 86, 1)',
      'rgba(75, 192, 192, 1)',
      'rgba(153, 102, 255, 1)',
      'rgba(255, 159, 64, 1)',
      'rgba(0, 128, 0, 1)' // Cor para "Global"
    ];

    const bordasBarra = [
      'rgba(255, 99, 132, 1)', 
      'rgba(54, 162, 235, 1)', 
      'rgba(255, 206, 86, 1)',
      'rgba(75, 192, 192, 1)',
      'rgba(153, 102, 255, 1)',
      'rgba(255, 159, 64, 1)',
      'rgba(0, 128, 0, 1)' // Borda para "Global"
    ];

    // Rótulos das faixas etárias + "Global"
    const labels = [
      '0-1 ano (12m)', 
      '1-2 anos (24m)', 
      '2-3 anos (36m)', 
      '3-4 anos (48m)', 
      '4-5 anos (60m)', 
      '5-6 anos (72m)',
      'Global'
    ];

    // Dados para a porcentagem de desenvolvimento por faixa etária + valor Global
    const dadosDesenvolvimento = {
      labels: labels,
      datasets: [
        {
          label: 'Porcentagem de Desenvolvimento',
          data: [70, 48, 30, 0, 0, 0, valorGlobal],
          backgroundColor: coresBarra,
          borderColor: bordasBarra,
          borderWidth: 1
        }
      ]
    };

    // Configuração do gráfico
    const configCombinado = {
      type: 'bar',
      data: dadosDesenvolvimento,
      options: {
        responsive: false,
        maintainAspectRatio: false,
        scales: {
          y: {
            beginAtZero: true,
            max: 100,
            ticks: {
              stepSize: 10,
              color: '#000',
              font: {
                size: 14
              }
            },
            title: {
              display: true,
              text: 'Porcentagem (%)',
              font: {
                size: 16,
                weight: 'bold'
              }
            },
            grid: {
              color: 'rgba(0,0,0,0.1)'
            }
          },
          x: {
            ticks: {
              color: '#000',
              font: {
                size: 14
              }
            },
            grid: {
              display: false
            }
          }
        },
        plugins: {
          legend: {
            display: false
          },
          // Adicionando a explicação do Global como subtítulo
          subtitle: {
            display: true,
            text: 'Global = (Idade Calculada / Idade Biológica) x 100 (%)',
            color: '#666',
            font: {
              size: 14,
              style: 'italic'
            },
            padding: {
              top: 0,
              bottom: 10
            }
          },
          title: {
            display: true,
            text: 'Socialização e Desempenho Global por Faixa Etária',
            color: '#000',
            font: {
              size: 20,
              weight: 'bold'
            },
            padding: {
              top: 20,
              bottom: 10
            }
          },
          tooltip: {
            callbacks: {
              label: function(context) {
                if(context.label === 'Global') {
                  return `Global: ${context.raw.toFixed(2)}% (Idade Calculada vs Biológica)`;
                }
                return context.raw + '%';
              }
            }
          },
          datalabels: {
            anchor: 'end',
            align: 'end',
            color: '#000',
            font: {
              weight: 'bold',
              size: 14
            },
            formatter: function(value) {
              return value.toFixed(2) + '%';
            }
          }
        }
      },
      plugins: [ChartDataLabels]
    };

    // Criação do gráfico
    const ctxCombinado = document.getElementById('graficoCombinado').getContext('2d');
    const graficoCombinado = new Chart(ctxCombinado, configCombinado);

    // Função para exportar o gráfico como imagem
    function exportarGraficoCombinado() {
      const imagemBase64 = graficoCombinado.toBase64Image();
      const linkDownload = document.createElement('a');
      linkDownload.href = imagemBase64;
      linkDownload.download = 'grafico_combinado.png';
      linkDownload.click();
    }
    document.getElementById('btnExportarImagem').addEventListener('click', exportarGraficoCombinado);
  </script>
</body>
</html>
