<?php
// Define o tipo de conteúdo para resposta JSON
header('Content-Type: application/json');

// Recebe os dados JSON enviados pela requisição POST
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Verifica se todos os dados necessários estão presentes
if (
    isset($data['item']) &&
    isset($data['num_item']) &&
    isset($data['area']) &&
    isset($data['nivel']) &&
    isset($data['nome_da_tarefa']) &&
    isset($data['cl_num']) &&
    isset($data['cl_des'])
) {
    // Extrai os dados recebidos
    $item = $data['item'];
    $num_item = $data['num_item'];
    $area = $data['area'];
    $nivel = $data['nivel'];
    $nome_da_tarefa = $data['nome_da_tarefa'];
    $cl_num = $data['cl_num'];
    $cl_des = $data['cl_des'];
    
    // Extrai os campos op_1 a op_10
    $opcoes = array();
    for ($i = 1; $i <= 10; $i++) {
        $key = 'op_' . $i;
        if (isset($data[$key]) && trim($data[$key]) !== '') {
            // Adiciona apenas se o campo não estiver vazio
            $opcoes[] = "<li>" . htmlspecialchars($data[$key], ENT_QUOTES, 'UTF-8') . "</li>";
        }
    }

    // Gera o HTML conforme o modelo especificado
    $html = "<!-- Item $item -->
<div class=\"portage-card\">
    <div class=\"checkbox-title\">
        (AV) " . htmlspecialchars($item, ENT_QUOTES, 'UTF-8') . " - " . htmlspecialchars($nome_da_tarefa, ENT_QUOTES, 'UTF-8') . "
    </div>
    
    <div class=\"portage-orientation-toggle\" onclick=\"toggleOrientation('orient{$area}{$nivel}_item{$num_item}')\">
        <i class=\"fas fa-chevron-down\"></i> Orientações
    </div>
    <div class=\"portage-orientation-text\" id=\"orient{$area}{$nivel}_item{$num_item}\">
        <ol>
            " . implode("\n            ", $opcoes) . "
        </ol>
        
        <hr>
        <div class=\"item-class\">Classe: ({$cl_num}) " . htmlspecialchars($cl_des, ENT_QUOTES, 'UTF-8') . "<br />Faixa etária: 0-1 ano</div>
        <!-- <div class=\"item-class\" >Resp.: Inconsistente	</div> -->
    </div>
    <div class=\"skill-actions\">
        <div class=\"option\">
            <input type=\"radio\" id=\"passou_{$area}{$nivel}_item{$num_item}\" name=\"{$area}{$nivel}_item{$num_item}\" value=\"Passou\" onchange=\"updateRowHighlight('row{$num_item}', 'Passou')\"/>
            <label for=\"passou_{$area}{$nivel}_item{$num_item}\">Passou</label>
        </div>
        <div class=\"option\">
            <input type=\"radio\" id=\"falha_{$area}{$nivel}_item{$num_item}\" name=\"{$area}{$nivel}_item{$num_item}\" value=\"Falha\" onchange=\"updateRowHighlight('row{$num_item}', 'Falha')\"/>
            <label for=\"falha_{$area}{$nivel}_item{$num_item}\">Falha</label>
        </div>
    </div>
</div>
";

    // Define o caminho do arquivo de texto onde os dados serão armazenados
    $file = 'requisições_plano.txt';

    // Tenta abrir o arquivo no modo de anexação (append)
    if ($handle = fopen($file, 'a')) {
        // Escreve o HTML no arquivo com duas quebras de linha para separação
        fwrite($handle, $html . "\n\n");
        fclose($handle); // Fecha o arquivo

        // Envia uma resposta JSON indicando sucesso
        echo json_encode(['status' => 'Sucesso']);
    } else {
        // Envia uma resposta JSON indicando erro ao abrir o arquivo
        echo json_encode(['error' => 'Não foi possível abrir o arquivo para escrita.']);
    }
} else {
    // Envia uma resposta JSON indicando que faltam dados
    echo json_encode(['error' => 'Dados ausentes no JSON enviado.']);
}
?>
