<?php
// Recebe os dados JSON enviados pela requisição POST
$data = json_decode(file_get_contents('php://input'), true);

// Verifica se os dados necessários estão presentes
if(isset($data['item']) && isset($data['numero_do_item']) && isset($data['area']) && isset($data['nivel']) && isset($data['nome_da_tarefa']) && isset($data['condicao']) && isset($data['rsp_passa']) && isset($data['rsp_falha'])) {
    $item = $data['item'];
    $numero_do_item = $data['numero_do_item'];
    $area = $data['area'];
    $nivel = $data['nivel'];
    $nome_da_tarefa = $data['nome_da_tarefa'];
    $condicao = $data['condicao'];
    $rsp_passa = $data['rsp_passa'];
    $rsp_falha = $data['rsp_falha'];

    // Gera o HTML com os dados recebidos
    $html = "
    <!-- Card $item -->
    <div class=\"portage-card\">
        <div class=\"checkbox-title\">$item - $nome_da_tarefa</div>
        <div class=\"skill-actions\">
            <div class=\"option\"><label><input type=\"radio\" name=\"$area{$nivel}_item$numero_do_item\" value=\"Sim\">Sim</label></div>
            <div class=\"option\"><label><input type=\"radio\" name=\"$area{$nivel}_item$numero_do_item\" value=\"AV\">AV</label></div>
            <div class=\"option\"><label><input type=\"radio\" name=\"$area{$nivel}_item$numero_do_item\" value=\"Não\">Não</label></div>
        </div>
        <div class=\"portage-orientation-toggle\" data-target=\"orient$area{$nivel}_item$numero_do_item\"><i class=\"fas fa-chevron-down\"></i> Orientações</div>
        <div class=\"portage-orientation-text\" id=\"orient$area{$nivel}_item$numero_do_item\">
            <p><strong>Condição:</strong> $condicao</p>
            <strong>Critérios:</strong><br>
            <ul>
                <li><strong>Sim:</strong> $rsp_passa</li>
                <li><strong>Não:</strong> $rsp_falha</li>
            </ul>
        </div>
    </div>
    ";

    // Salva o HTML no arquivo de texto
    $file = 'requisições.txt';  // Caminho do arquivo de texto onde os dados serão armazenados
    $handle = fopen($file, 'a');  // Abre o arquivo no modo de anexação (append)
    if ($handle) {
        fwrite($handle, $html . "\n\n");  // Escreve o HTML no arquivo com uma linha de espaço
        fclose($handle);  // Fecha o arquivo
        
        // Envia uma resposta JSON com sucesso
        echo json_encode(['status' => 'Sucesso']);
    } else {
        echo json_encode(['error' => 'Não foi possível abrir o arquivo']);
    }

} else {
    echo json_encode(['error' => 'Dados ausentes no JSON']);
}
?>
