<?php
// Define o tipo de conteúdo para resposta JSON
header('Content-Type: application/json');

// Recebe os dados JSON enviados pela requisição POST
$data = json_decode(file_get_contents('php://input'), true);

// Verifica se todos os dados necessários estão presentes
if (
    isset($data['item']) &&
    isset($data['numero_do_item']) &&
    isset($data['area']) &&
    isset($data['nivel']) &&
    isset($data['nome_da_tarefa']) &&
    isset($data['condicao']) &&
    isset($data['rsp_passa']) &&
    isset($data['rsp_falha'])
) {
    // Extrai os dados recebidos
    $item = $data['item'];
    $numero_do_item = $data['numero_do_item'];
    $area = $data['area'];
    $nivel = $data['nivel'];
    $nome_da_tarefa = $data['nome_da_tarefa'];
    $condicao = $data['condicao'];
    $rsp_passa = $data['rsp_passa'];
    $rsp_falha = $data['rsp_falha'];

    // Gera o HTML conforme o novo modelo
    $html = "
    <!-- Linha $item -->
    <tr id=\"$item\">
        <td>
            <div class=\"checkbox-title\" onclick=\"toggleDescription(this)\">
                $item - $nome_da_tarefa
            </div>
            <div class=\"skill-description\">
                $condicao
            </div>
        </td>
        <td class=\"text-center\">
            <input type=\"radio\" name=\"{$area}{$nivel}_item{$numero_do_item}\" value=\"Sim\" onchange=\"updateRowHighlight('$item', 'Sim')\">
        </td>
        <td class=\"text-center\">
            <input type=\"radio\" name=\"{$area}{$nivel}_item{$numero_do_item}\" value=\"AV\" onchange=\"updateRowHighlight('$item', 'AV')\">
        </td>
        <td class=\"text-center\">
            <input type=\"radio\" name=\"{$area}{$nivel}_item{$numero_do_item}\" value=\"Não\" onchange=\"updateRowHighlight('$item', 'Não')\">
        </td>
    </tr>
    ";

    // Define o caminho do arquivo de texto onde os dados serão armazenados
    $file = 'requisições_novo.txt';

    // Tenta abrir o arquivo no modo de anexação (append)
    if ($handle = fopen($file, 'a')) {
        // Escreve o HTML no arquivo com uma nova linha
        fwrite($handle, $html . "\n");
        fclose($handle); // Fecha o arquivo

        // Envia uma resposta JSON indicando sucesso
        echo json_encode(['status' => 'Sucesso']);
    } else {
        // Envia uma resposta JSON indicando erro ao abrir o arquivo
        echo json_encode(['error' => 'Não foi possível abrir o arquivo para escrita.']);
    }
} else {
    // Envia uma resposta JSON indicando que faltam dados
    echo json_encode(['error' => 'Dados ausentes no JSON enviado.']);
}
?>
