<?php
// Recebe os dados JSON enviados via POST
$data = json_decode(file_get_contents('php://input'), true);

// Verifica se o prompt foi enviado
if (isset($data['prompt'])) {
    $prompt = $data['prompt'];
    
    // Defina a chave da sua API de geração de imagens aqui (exemplo com DALL·E)
    $apiKey = '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';  // Substitua por sua chave real da API
    $url = 'https://api.openai.com/v1/images/generations';  // URL da API para DALL·E (exemplo)

    // Dados a serem enviados na requisição para a API de geração de imagens
    $postData = json_encode([
        'prompt' => $prompt,
        'n' => 1,  // Gerar uma imagem
        'size' => '1024x1024'  // Tamanho da imagem (ajuste conforme necessário)
    ]);

    // Inicializa o cURL para chamar a API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

    // Executa a requisição e obtém a resposta
    $response = curl_exec($ch);
    curl_close($ch);

    // Verifica se houve erro na requisição
    if ($response === false) {
        echo json_encode(['error' => 'Erro ao chamar a API de geração de imagens']);
        exit;
    }

    // Converte a resposta da API para um array PHP
    $responseData = json_decode($response, true);

    // Verifica se a imagem foi gerada com sucesso
    if (isset($responseData['data'][0]['url'])) {
        // Retorna a URL da imagem gerada pela IA
        echo json_encode(['image_url' => $responseData['data'][0]['url']]);
    } else {
        echo json_encode(['error' => 'Não foi possível gerar a imagem']);
    }
} else {
    echo json_encode(['error' => 'Prompt não fornecido']);
}
?>
