<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Criativo de Café</title>
</head>
<body>
    <h1>Criativo para Vender Café</h1>

    <canvas id="myCanvas" width="800" height="600"></canvas>

    <br><br>

    <button onclick="generateAndDrawImage()">Gerar Imagem de Café</button>

    <script>
        // Função para gerar imagem usando a API PHP
        async function generateAndDrawImage() {
            const prompt = "Imagem de uma mulher sorrindo e com expressão amigável, vestindo uma camisa branca, em um ambiente profissional, com fundo suave de cor azul clara. A mulher deve estar em uma pose confiante, com os braços abertos ou gesticulando, como se estivesse explicando algo. No topo, o texto grande 'MASTERCLASS' em uma fonte moderna e ousada, e logo abaixo, o texto 'Prática Clínica para crianças com TEA' em uma fonte complementar, mais discreta. O design deve ser clean, moderno e profissional, com bastante espaço para incluir um logotipo no canto superior esquerdo e um fundo neutro que não distraia a atenção do texto e da imagem central.";  // Texto para a IA gerar a imagem

            const response = await fetch('generate_image.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ prompt: prompt })
            });

            const data = await response.json();
            const imageUrl = data.image_url;  // A URL da imagem gerada

            drawImageOnCanvas(imageUrl);
        }

        // Função para desenhar a imagem gerada no Canvas
        function drawImageOnCanvas(imageUrl) {
            var canvas = document.getElementById("myCanvas");
            var ctx = canvas.getContext("2d");

            var img = new Image();
            img.onload = function() {
                ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
            };
            img.src = imageUrl;  // Usando a URL da imagem retornada pela IA
        }
    </script>
</body>
</html>
