<?php

// URL do endpoint
$url = "https://ifcora.com.br/Arquivos/m-chat.php";

// Dados JSON a serem enviados
$jsonData = [
    "nome" => "João Silva",
    "data_nascimento" => "2021-08-10", // Data de nascimento da criança
    "data_avaliacao" => "2024-02-15",  // Data da avaliação
    "item1" => "não",
    "item2" => "sim", // Falha em item crítico - "sim" = 1 ponto
    "item3" => "não",
    "item4" => "não",
    "item5" => "sim", // "sim" = 1 ponto
    "item6" => "não",
    "item7" => "não", // Falha em item crítico
    "item8" => "sim",
    "item9" => "sim", // Falha em item crítico
    "item10" => "sim",
    "item11" => "não",
    "item12" => "não", // "sim" = 1 ponto
    "item13" => "sim", // Falha em item crítico
    "item14" => "sim", // Falha em item crítico
    "item15" => "sim", // Falha em item crítico
    "item16" => "não",
    "item17" => "sim",
    "item18" => "sim",
    "item19" => "sim",
    "item20" => "sim"
];

// Codifica os dados em formato JSON
$jsonDataEncoded = json_encode($jsonData);

// Inicializa o cURL
$ch = curl_init($url);

// Configurações do cURL
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataEncoded);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($jsonDataEncoded)
]);

// Executa a requisição e captura a resposta
$response = curl_exec($ch);

// Verifica erros no cURL
if ($response === false) {
    echo "Erro ao enviar a requisição: " . curl_error($ch);
} else {
    // Decodifica a resposta JSON
    $decodedResponse = json_decode($response, true); // true para retornar um array associativo

    if (json_last_error() === JSON_ERROR_NONE) {
        echo "Resposta do servidor (decodificada):\n";
        print_r($decodedResponse); // Exibe a resposta decodificada
    } else {
        echo "Erro ao decodificar a resposta JSON: " . json_last_error_msg();
    }
}

// Fecha o cURL
curl_close($ch);

?>
