<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento de Crianças - Sistema de Avaliação IFCora</title>
    <!-- Fonte personalizada e Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Estilos CSS -->
    <link rel="stylesheet" href="includes/styles-criancas.css">
    <!-- Estilos Inline para Aprimorar os Modais e a Tabela -->
    <style>
        /* Estilos Gerais */
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f8;
        }

        /* Modal Overlay */
        .modal {
            display: none; /* Oculto por padrão */
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5); /* Fundo semi-transparente */
            align-items: center;
            justify-content: center;
            animation: fadeIn 0.3s;
            font-family: 'Poppins', sans-serif; /* Fonte consistente com a página */
        }

        /* Modal Content */
        .modal-content {
            background-color: #ffffff;
            margin: 5% auto; /* Centraliza verticalmente */
            padding: 30px; /* Espaçamento interno */
            border: 1px solid #e2e8f0; /* Borda sutil */
            width: 90%;
            max-width: 600px; /* Ajustado para maior consistência */
            border-radius: 10px; /* Bordas arredondadas */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Sombra suave */
            position: relative;
            animation: slideDown 0.3s;
        }

        /* Close Button */
        .close-button {
            color: #2d3748; /* Cor consistente com o texto principal */
            position: absolute;
            top: 15px;
            right: 20px;
            background: none;
            border: none;
            font-size: 24px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.2s;
        }

        .close-button:hover,
        .close-button:focus {
            color: #08C89E; /* Destaque ao passar o mouse */
            text-decoration: none;
        }

        /* Form Rows */
        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .form-group {
            flex: 1;
            min-width: 200px;
            display: flex;
            flex-direction: column;
        }

        label {
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #2d3748;
        }

        input[type="text"],
        input[type="date"],
        select {
            padding: 10px 12px;
            border: 1px solid #cbd5e0;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.2s;
            box-sizing: border-box;
        }

        input[type="text"]:focus,
        input[type="date"]:focus,
        select:focus {
            border-color: #08C89E;
            outline: none;
        }

        .specialty-display {
            padding: 10px 12px;
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
            min-height: 2rem;
        }

        .hidden {
            display: none;
        }

        /* Form Actions */
        .form-actions {
            display: flex;
            justify-content: flex-end;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .form-actions .btn {
            margin-left: 10px;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-family: 'Poppins', sans-serif;
            transition: background-color 0.3s;
        }

        /* Botões Específicos */
        .btn.add {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 8px 16px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: background-color 0.3s;
        }

        .btn.add i {
            margin-right: 5px;
        }

        .btn.add:hover {
            background-color: #06b287;
        }

        .btn.edit {
            background-color: #ffc107;
            color: #ffffff;
        }

        .btn.edit:hover {
            background-color: #e0a800;
        }

        .btn.transfer {
            background-color: #17a2b8;
            color: #ffffff;
        }

        .btn.transfer:hover {
            background-color: #138496;
        }

        .btn.delete {
            background-color: #dc3545;
            color: #ffffff;
        }

        .btn.delete:hover {
            background-color: #c82333;
        }

        .btn.cancel {
            background-color: #e53e3e;
            color: #ffffff;
        }

        .btn.cancel:hover {
            background-color: #c53030;
        }

        .btn.save {
            background-color: #08C89E;
            color: #ffffff;
        }

        .btn.save:hover {
            background-color: #06b287;
        }

        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 1rem;
        }

        .pagination button {
            padding: 6px 12px;
            border: 1px solid #cbd5e0;
            background-color: #ffffff;
            color: #2d3748;
            border-radius: 4px;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s;
        }

        .pagination button.active,
        .pagination button:hover {
            background-color: #08C89E;
            color: #ffffff;
            border-color: #08C89E;
        }

        /* Table Styles */
        .table-container {
            width: 100%;
            overflow-x: auto; /* Adiciona rolagem horizontal se necessário */
            margin-top: 1rem;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            min-width: 700px; /* Define uma largura mínima para evitar quebra em telas muito pequenas */
        }

        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
            white-space: nowrap; /* Evita que o texto quebre em múltiplas linhas */
            font-size: 14px;
            color: #2d3748;
        }

        th {
            background-color: #f7fafc;
            font-weight: 600;
            color: #2d3748;
            position: sticky;
            top: 0;
            z-index: 1;
        }

        tr:nth-child(even) {
            background-color: #f9fafb;
        }

        tr:hover {
            background-color: #f1f5f9;
        }

        .actions button {
            margin-right: 0.5rem;
            white-space: nowrap; /* Evita quebra de linha nos botões */
        }

        /* Animations */
        @keyframes fadeIn {
            from {opacity: 0;}
            to {opacity: 1;}
        }

        @keyframes slideDown {
            from {transform: translateY(-20px);}
            to {transform: translateY(0);}
        }

        /* Responsiveness Enhancements */
        @media (max-width: 1200px) {
            table {
                min-width: 600px;
            }
        }

        @media (max-width: 992px) {
            table {
                min-width: 500px;
            }
        }

        @media (max-width: 768px) {
            .form-row {
                flex-direction: column;
            }

            th, td {
                padding: 10px 12px;
            }

            .modal-content {
                padding: 20px;
            }

            .btn {
                padding: 8px 16px;
                font-size: 13px;
            }

            table {
                min-width: 400px;
            }
        }

        @media (max-width: 576px) {
            table {
                min-width: 300px;
            }

            th, td {
                padding: 8px 10px;
                font-size: 13px;
            }

            .btn {
                padding: 6px 12px;
                font-size: 12px;
            }
        }

        /* Estilos Adicionais para Faturamento e Modal de Planos */
        .plan-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            text-align: center;
            margin-bottom: 20px;
        }

        .plan-card h3 {
            font-size: 18px;
            color: #2d3748;
            margin-bottom: 10px;
        }

        .plan-card p {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 10px;
        }

        .plan-card button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }

        .plan-card button:hover {
            background-color: #06b287;
        }

        .plans-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        /* Modal de Planos */
        #choosePlanModal .modal-content {
            max-width: 600px;
        }

        .current-plan-info {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .current-plan-info p {
            margin-bottom: 5px;
        }

        .highlight {
            font-weight: 600;
            color: #08C89E;
        }

        /* Abas Internas */
        .tabs-container {
            margin-bottom: 20px;
        }

        .tabs {
            display: flex;
            border-bottom: 1px solid #e2e8f0;
            margin-bottom: 20px;
        }

        .tab {
            padding: 10px 20px;
            cursor: pointer;
            font-size: 16px;
            color: #2d3748;
            background-color: #f7fafc;
            border-top-left-radius: 6px;
            border-top-right-radius: 6px;
            margin-right: 5px;
            display: flex;
            align-items: center;
            border-bottom: 1px solid #e2e8f0;
            transition: background-color 0.3s, color 0.3s;
        }

        .tab.active {
            background-color: #08C89E;
            color: #fff;
            font-weight: 600;
            border-bottom: 2px solid #08C89E;
        }

        .tab i {
            margin-right: 10px;
            font-size: 18px;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Tabelas Internas */
        .table-section {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .table-section th, .table-section td {
            text-align: left;
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 16px;
            color: #2d3748;
        }

        .table-section th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        /* Botões Adicionais */
        .btn.copy {
            background-color: #F6AD55;
            color: #fff;
        }

        .btn.copy:hover {
            background-color: #dd6b20;
        }

        .btn.accept {
            background-color: #08C89E;
            color: #fff;
        }

        .btn.accept:hover {
            background-color: #06b287;
        }

        .btn.decline {
            background-color: #e53e3e;
            color: #fff;
        }

        .btn.decline:hover {
            background-color: #c53030;
        }

        .btn.pay-now {
            background-color: #08C89E;
            color: #fff;
            padding: 5px 10px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
        }

        .btn.pay-now:hover {
            background-color: #06b287;
        }

        .btn.contact-sales {
            background-color: #F6AD55;
            color: #fff;
            border: none;
            padding: 10px 15px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
        }

        .btn.contact-sales:hover {
            background-color: #dd6b20;
        }

        /* Estilos para a Tabela de Crianças */
        #childrenTable th,
        #childrenTable td {
            padding: 12px 15px;
            border-bottom: 1px solid #e2e8f0;
            text-align: left;
            font-size: 14px;
            color: #2d3748;
        }

        #childrenTable th {
            background-color: #f7fafc;
            font-weight: 600;
            color: #2d3748;
        }

        #childrenTable tr:nth-child(even) {
            background-color: #f9fafb;
        }

        #childrenTable tr:hover {
            background-color: #f1f5f9;
        }

        /* Estilos para Botões de Ação na Tabela */
        .edit-button,
        .remove-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 30px; /* Defina um tamanho fixo se necessário */
            height: 30px;
            padding: 5px;
            text-decoration: none;
            cursor: pointer;
        }

        /* Opcional: Ajustar o tamanho dos ícones */
        .edit-button i,
        .remove-button i {
            font-size: 16px;
        }

        /* Planos e Abas Internas */
        /* ... (Já incluído acima) ... */
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos" width="50" height="50">
            <h2>Sistema de Avaliação - IFCora</h2>
        </div>
        <nav class="user-menu">
            <a href="#" title="Notificações"><i class="fas fa-bell"></i><span class="sr-only">Notificações</span></a>
            <a href="#" title="Configurações"><i class="fas fa-cog"></i><span class="sr-only">Configurações</span></a>
            <a href="#" title="Suporte"><i class="fas fa-headset"></i><span class="sr-only">Suporte</span></a>
        </nav>
    </header>
    <!-- Sidebar -->
    <?php include 'includes/sidebar-painel-profissional.php'; ?>

    <!-- Conteúdo -->
    <div class="">
        <h1>Gerenciar Clínica</h1>
    </div>

    <main class="content-container" aria-labelledby="gerenciamentoCrianças">
        <div class="page-header">
            <h1 id="gerenciamentoCrianças">Gerenciamento de Crianças</h1>
            <p>Adicione, edite, transfira e gerencie de forma eficiente as crianças associadas às clínicas sob sua responsabilidade.</p>
        </div>

        <section class="management-section">
            <div class="actions">
                <button class="btn add" id="openAddChildModalBtn" aria-label="Adicionar Criança">
                    <i class="fas fa-plus"></i> Adicionar Nova Criança
                </button>
            </div>
            <hr />
            <div class="filters" role="search" aria-label="Filtros de Pesquisa">
                <div class="filter-group">
                    <label for="clinicFilterChildren">Filtrar por Clínica</label>
                    <select id="clinicFilterChildren" name="clinicFilterChildren">
                        <option value="">Todas as Clínicas</option>
                        <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                        <option value="Clínica Central">Clínica Central</option>
                        <option value="Clínica do Norte">Clínica do Norte</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label for="professionalFilterChildren">Filtrar por Profissional</label>
                    <select id="professionalFilterChildren" name="professionalFilterChildren">
                        <option value="">Todos os Profissionais</option>
                        <option value="Mariana Santos">Mariana Santos</option>
                        <option value="Pedro Oliveira">Pedro Oliveira</option>
                        <option value="Ana Luiza">Ana Luiza</option>
                        <option value="Lucas Almeida">Lucas Almeida</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label for="searchChildName">Pesquisar por Nome</label>
                    <input type="text" id="searchChildName" name="searchChildName" placeholder="Digite o nome da criança..." aria-label="Pesquisar por Nome da Criança">
                </div>
            </div>

            <div class="table-container">
                <table id="childrenTable" aria-describedby="childrenTableDescription">
                    <caption id="childrenTableDescription">Tabela de gerenciamento das crianças cadastradas. Utilize os filtros acima para refinar a busca.</caption>
                    <thead>
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Nome</th>
                            <th scope="col">Responsável</th>
                            <th scope="col">Clínica Atribuída</th>
                            <th scope="col">Profissional Atribuído</th>
                            <th scope="col">Especialidade</th>
                            <th scope="col">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Dados de Exemplo -->
                        <tr data-birthdate="2016-05-20" data-clinic="Clínica Sertãozinho">
                            <td>#ABC12345</td>
                            <td>Luís Gustavo</td>
                            <td>Ana Paula</td>
                            <td>Clínica Sertãozinho</td>
                            <td>Mariana Santos</td>
                            <td>Fonoaudióloga</td>
                            <td class="actions">
                                <button class="btn edit" title="Editar Criança" aria-label="Editar Criança"><i class="fas fa-edit"></i> Editar</button>
                                <button class="btn transfer" title="Transferir de Clínica" aria-label="Transferir de Clínica"><i class="fas fa-exchange-alt"></i> Transferir</button>
                                <button class="btn delete" title="Remover Criança" aria-label="Remover Criança"><i class="fas fa-trash-alt"></i> Remover</button>
                            </td>
                        </tr>
                        <tr data-birthdate="2018-03-10" data-clinic="Clínica Central">
                            <td>#ABC12346</td>
                            <td>Maria Fernanda</td>
                            <td>Carlos Eduardo</td>
                            <td>Clínica Central</td>
                            <td>Pedro Oliveira</td>
                            <td>Psicólogo</td>
                            <td class="actions">
                                <button class="btn edit" title="Editar Criança" aria-label="Editar Criança"><i class="fas fa-edit"></i> Editar</button>
                                <button class="btn transfer" title="Transferir de Clínica" aria-label="Transferir de Clínica"><i class="fas fa-exchange-alt"></i> Transferir</button>
                                <button class="btn delete" title="Remover Criança" aria-label="Remover Criança"><i class="fas fa-trash-alt"></i> Remover</button>
                            </td>
                        </tr>
                        <!-- Adicione mais linhas conforme necessário -->
                    </tbody>
                </table>
            </div>

            <nav class="pagination" id="pagination-children" aria-label="Navegação de Páginas"></nav>
        </section>
    </main>

    <!-- Modal Adicionar Criança -->
    <div id="addChildModal" class="modal" role="dialog" aria-labelledby="addChildModalTitle" aria-modal="true">
        <div class="modal-content">
            <button class="close-button" aria-label="Fechar">&times;</button>
            <h2 id="addChildModalTitle">Adicionar Nova Criança</h2>
            <form id="addChildForm" class="child-form" novalidate>
                <!-- Primeira Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="addChildName" class="required">Nome Completo</label>
                        <input type="text" id="addChildName" name="addChildName" placeholder="Ex: João da Silva" required>
                    </div>
                    <div class="form-group">
                        <label for="addBirthDate" class="required">Data de Nascimento</label>
                        <input type="date" id="addBirthDate" name="addBirthDate" required>
                    </div>
                </div>

                <!-- Segunda Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="addClinic" class="required">Clínica Responsável</label>
                        <select id="addClinic" name="addClinic" required>
                            <option value="">Selecione uma clínica</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="addAssignedProfessional">Profissional Atribuído</label>
                        <select id="addAssignedProfessional" name="addAssignedProfessional">
                            <option value="">Nenhum</option>
                            <option value="Mariana Santos">Mariana Santos</option>
                            <option value="Pedro Oliveira">Pedro Oliveira</option>
                            <option value="Ana Luiza">Ana Luiza</option>
                            <option value="Lucas Almeida">Lucas Almeida</option>
                        </select>
                    </div>
                </div>

                <!-- Terceira Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label>Especialidade do Profissional</label>
                        <p id="addSpecialty" class="specialty-display">Selecione um profissional para ver a especialidade</p>
                    </div>
                </div>

                <!-- Quarta Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="addGuardianName" class="required">Nome do Responsável</label>
                        <input type="text" id="addGuardianName" name="addGuardianName" placeholder="Ex: Ana Paula" required>
                    </div>
                    <div class="form-group">
                        <label for="addGuardianRelation" class="required">Vínculo com a Criança</label>
                        <select id="addGuardianRelation" name="addGuardianRelation" required>
                            <option value="Pai">Pai</option>
                            <option value="Mãe">Mãe</option>
                            <option value="Outro">Outro</option>
                        </select>
                    </div>
                </div>

                <!-- Campo Específico -->
                <div id="addRelationOtherField" class="form-group hidden">
                    <label for="addGuardianOther">Especifique o Vínculo</label>
                    <input type="text" id="addGuardianOther" name="addGuardianOther" placeholder="Ex: Tia, Avó...">
                </div>

                <!-- Ações do Formulário -->
                <div class="form-actions">
                    <button type="button" class="btn cancel" id="cancelAddChild">Cancelar</button>
                    <button type="submit" class="btn save">Adicionar Criança</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Editar Criança -->
    <div id="editChildModal" class="modal" role="dialog" aria-labelledby="editChildModalTitle" aria-modal="true">
        <div class="modal-content">
            <button class="close-button" aria-label="Fechar">&times;</button>
            <h2 id="editChildModalTitle">Editar Informações da Criança <span id="editChildId" class="child-id">#</span></h2>
            <form id="editChildForm" class="child-form" novalidate>
                <!-- Primeira Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="editChildName" class="required">Nome Completo</label>
                        <input type="text" id="editChildName" name="editChildName" placeholder="Ex: João da Silva" required>
                    </div>
                    <div class="form-group">
                        <label for="editBirthDate" class="required">Data de Nascimento</label>
                        <input type="date" id="editBirthDate" name="editBirthDate" required>
                    </div>
                </div>

                <!-- Segunda Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="editClinic" class="required">Clínica Responsável</label>
                        <select id="editClinic" name="editClinic" required>
                            <option value="">Selecione uma clínica</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="editAssignedProfessional">Profissional Atribuído</label>
                        <select id="editAssignedProfessional" name="editAssignedProfessional">
                            <option value="">Nenhum</option>
                            <option value="Mariana Santos">Mariana Santos</option>
                            <option value="Pedro Oliveira">Pedro Oliveira</option>
                            <option value="Ana Luiza">Ana Luiza</option>
                            <option value="Lucas Almeida">Lucas Almeida</option>
                        </select>
                    </div>
                </div>

                <!-- Terceira Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label>Especialidade do Profissional</label>
                        <p id="editSpecialty" class="specialty-display">Selecione um profissional para ver a especialidade</p>
                    </div>
                </div>

                <!-- Quarta Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="editGuardianName" class="required">Nome do Responsável</label>
                        <input type="text" id="editGuardianName" name="editGuardianName" placeholder="Ex: Ana Paula" required>
                    </div>
                    <div class="form-group">
                        <label for="editGuardianRelation" class="required">Vínculo com a Criança</label>
                        <select id="editGuardianRelation" name="editGuardianRelation" required>
                            <option value="Pai">Pai</option>
                            <option value="Mãe">Mãe</option>
                            <option value="Outro">Outro</option>
                        </select>
                    </div>
                </div>

                <!-- Campo Específico -->
                <div id="relationOtherField" class="form-group hidden">
                    <label for="editGuardianOther">Especifique o Vínculo</label>
                    <input type="text" id="editGuardianOther" name="editGuardianOther" placeholder="Ex: Tia, Avó...">
                </div>

                <!-- Ações do Formulário -->
                <div class="form-actions">
                    <button type="button" class="btn cancel" id="cancelEditChild">Cancelar</button>
                    <button type="submit" class="btn save">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Transferir Criança -->
    <div id="transferChildModal" class="modal" role="dialog" aria-labelledby="transferChildModalTitle" aria-modal="true">
        <div class="modal-content">
            <button class="close-button" aria-label="Fechar">&times;</button>
            <h2 id="transferChildModalTitle">Transferir Criança para Outra Clínica</h2>
            <form id="transferChildForm" class="child-form" novalidate>
                <!-- Primeira Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label for="transferChildClinic" class="required">Nova Clínica</label>
                        <select id="transferChildClinic" name="transferChildClinic" required>
                            <option value="">Selecione uma clínica</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="transferAssignedProfessional" class="required">Novo Profissional</label>
                        <select id="transferAssignedProfessional" name="transferAssignedProfessional" required>
                            <option value="">Selecione uma clínica primeiro</option>
                        </select>
                    </div>
                </div>

                <!-- Segunda Linha -->
                <div class="form-row">
                    <div class="form-group">
                        <label>Especialidade do Novo Profissional</label>
                        <p id="transferSpecialty" class="specialty-display">Selecione um profissional para ver a especialidade</p>
                    </div>
                </div>

                <!-- Ações do Formulário -->
                <div class="form-actions">
                    <button type="button" class="btn cancel" id="cancelTransferChild">Cancelar</button>
                    <button type="submit" class="btn save">Confirmar Transferência</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Script JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const professionalsData = {
                "Mariana Santos": "Fonoaudióloga",
                "Pedro Oliveira": "Psicólogo",
                "Ana Luiza": "Nutricionista",
                "Lucas Almeida": "Fisioterapeuta"
            };

            const clinicProfessionals = {
                "Clínica Sertãozinho": ["Mariana Santos", "Pedro Oliveira"],
                "Clínica Central": ["Ana Luiza", "Lucas Almeida"],
                "Clínica do Norte": ["Mariana Santos", "Lucas Almeida"]
            };

            // Função para calcular idade
            const calcularIdade = (dataNascimento) => {
                const hoje = new Date();
                const nascimento = new Date(dataNascimento);
                let idade = hoje.getFullYear() - nascimento.getFullYear();
                const m = hoje.getMonth() - nascimento.getMonth();
                if (m < 0 || (m === 0 && hoje.getDate() < nascimento.getDate())) {
                    idade--;
                }
                return `${idade} anos`;
            };

            // Função para gerar ID único
            const generateUniqueId = () => {
                return '#' + Math.random().toString(36).substr(2, 8).toUpperCase();
            };

            // Função para atualizar a especialidade com base no profissional selecionado
            const atualizarEspecialidade = (selectElement, displayElement) => {
                const profissional = selectElement.value;
                displayElement.textContent = professionalsData[profissional] || "Selecione um profissional";
            };

            // Função para alternar o campo "Especifique o vínculo"
            const toggleRelationField = (selectElement, otherField) => {
                if (selectElement.value === 'Outro') {
                    otherField.classList.remove('hidden');
                } else {
                    otherField.classList.add('hidden');
                    otherField.querySelector('input').value = '';
                }
            };

            // Função para abrir modal
            const abrirModal = (modal) => {
                modal.style.display = 'flex';
                // Foco no primeiro campo do formulário
                const firstInput = modal.querySelector('input, select, textarea, button');
                if (firstInput) firstInput.focus();
            };

            // Função para fechar modal
            const fecharModal = (modal) => {
                modal.style.display = 'none';
            };

            // Função para limpar formulário e resetar campos específicos
            const limparFormulario = (form, displayElements = []) => {
                form.reset();
                displayElements.forEach(element => element.textContent = "Selecione um profissional");
                const hiddenFields = form.querySelectorAll('.hidden');
                hiddenFields.forEach(field => field.classList.add('hidden'));
                // Limpar opções do profissional no modal de transferência
                if (form.id === 'transferChildForm') {
                    const transferProfessional = document.getElementById('transferAssignedProfessional');
                    transferProfessional.innerHTML = '<option value="">Selecione uma clínica primeiro</option>';
                    document.getElementById('transferSpecialty').textContent = "Selecione um profissional";
                }
            };

            // Função para paginar a tabela
            const paginateTable = (tableId, paginationId, itemsPerPage) => {
                const table = document.getElementById(tableId);
                const tbody = table.querySelector('tbody');
                const rows = Array.from(tbody.querySelectorAll('tr'));
                const totalPages = Math.ceil(rows.length / itemsPerPage);
                const pagination = document.getElementById(paginationId);

                if (!pagination) return;
                pagination.innerHTML = '';

                const showPage = (page) => {
                    rows.forEach((row, index) => {
                        row.style.display = (index >= (page - 1) * itemsPerPage && index < page * itemsPerPage) ? '' : 'none';
                    });
                    const buttons = pagination.querySelectorAll('button');
                    buttons.forEach(btn => btn.classList.remove('active'));
                    if (buttons[page - 1]) {
                        buttons[page - 1].classList.add('active');
                    }
                };

                for (let i = 1; i <= totalPages; i++) {
                    const btn = document.createElement('button');
                    btn.innerText = i;
                    if (i === 1) btn.classList.add('active');
                    btn.addEventListener('click', () => showPage(i));
                    pagination.appendChild(btn);
                }

                showPage(1);
            };

            // Inicializar paginação
            paginateTable('childrenTable', 'pagination-children', 10);

            // Seletores de filtros
            const clinicFilterChildren = document.getElementById('clinicFilterChildren');
            const professionalFilterChildren = document.getElementById('professionalFilterChildren');
            const searchChildName = document.getElementById('searchChildName');

            // Função para filtrar a tabela
            const filtrarTabelaCrianças = () => {
                const filterClinic = clinicFilterChildren.value.toLowerCase();
                const filterProfessional = professionalFilterChildren.value.toLowerCase();
                const filterName = searchChildName.value.toLowerCase();
                const table = document.getElementById('childrenTable');
                const tbody = table.querySelector('tbody');
                const rows = Array.from(tbody.querySelectorAll('tr'));

                rows.forEach(row => {
                    const cells = row.querySelectorAll('td');
                    const clinic = (cells[3]?.textContent || '').toLowerCase();
                    const profissional = (cells[4]?.textContent || '').toLowerCase();
                    const nome = (cells[1]?.textContent || '').toLowerCase();
                    const responsavel = (cells[2]?.textContent || '').toLowerCase();
                    const matchClinic = !filterClinic || clinic.includes(filterClinic);
                    const matchProfessional = !filterProfessional || profissional.includes(filterProfessional);
                    const matchName = !filterName || nome.includes(filterName) || responsavel.includes(filterName);
                    row.style.display = (matchClinic && matchProfessional && matchName) ? '' : 'none';
                });

                paginateTable('childrenTable', 'pagination-children', 10);
            };

            // Adicionar eventos aos filtros
            clinicFilterChildren.addEventListener('change', filtrarTabelaCrianças);
            professionalFilterChildren.addEventListener('change', filtrarTabelaCrianças);
            searchChildName.addEventListener('input', filtrarTabelaCrianças);

            // Seletores de modais
            const addChildModal = document.getElementById('addChildModal');
            const editChildModal = document.getElementById('editChildModal');
            const transferChildModal = document.getElementById('transferChildModal');

            // Botões para abrir modais
            const openAddChildModalBtn = document.getElementById('openAddChildModalBtn');

            // Formulários
            const addChildForm = document.getElementById('addChildForm');
            const editChildForm = document.getElementById('editChildForm');
            const transferChildForm = document.getElementById('transferChildForm');

            // Campos específicos
            const addGuardianRelation = document.getElementById('addGuardianRelation');
            const addRelationOtherField = document.getElementById('addRelationOtherField');
            const addAssignedProfessional = document.getElementById('addAssignedProfessional');
            const addSpecialty = document.getElementById('addSpecialty');

            const editGuardianRelation = document.getElementById('editGuardianRelation');
            const relationOtherField = document.getElementById('relationOtherField');
            const editAssignedProfessional = document.getElementById('editAssignedProfessional');
            const editSpecialty = document.getElementById('editSpecialty');

            const transferChildClinic = document.getElementById('transferChildClinic');
            const transferAssignedProfessional = document.getElementById('transferAssignedProfessional');
            const transferSpecialty = document.getElementById('transferSpecialty');

            // Botões de cancelar
            const cancelAddChild = document.getElementById('cancelAddChild');
            const cancelEditChild = document.getElementById('cancelEditChild');
            const cancelTransferChild = document.getElementById('cancelTransferChild');

            // Especialidades
            const specialtyDisplays = {
                add: addSpecialty,
                edit: editSpecialty,
                transfer: transferSpecialty
            };

            // Abrir modal adicionar criança
            openAddChildModalBtn.addEventListener('click', () => {
                abrirModal(addChildModal);
            });

            // Cancelar adicionar criança
            cancelAddChild.addEventListener('click', () => {
                if (confirm('Tem certeza que deseja cancelar o cadastro da criança? Todas as informações inseridas serão perdidas.')) {
                    fecharModal(addChildModal);
                    limparFormulario(addChildForm, [addSpecialty]);
                }
            });

            // Cancelar editar criança
            if (cancelEditChild) {
                cancelEditChild.addEventListener('click', () => {
                    if (confirm('Tem certeza que deseja cancelar as alterações? Todas as modificações não salvas serão perdidas.')) {
                        fecharModal(editChildModal);
                        limparFormulario(editChildForm, [editSpecialty]);
                    }
                });
            }

            // Cancelar transferência de criança
            if (cancelTransferChild) {
                cancelTransferChild.addEventListener('click', () => {
                    if (confirm('Tem certeza que deseja cancelar a transferência? Todas as informações inseridas serão perdidas.')) {
                        fecharModal(transferChildModal);
                        limparFormulario(transferChildForm, [transferSpecialty]);
                    }
                });
            }

            // Fechar modais ao clicar no X
            document.querySelectorAll('.close-button').forEach(btn => {
                btn.addEventListener('click', () => {
                    fecharModal(btn.closest('.modal'));
                    // Limpar todos os formulários e resetar campos específicos
                    limparFormulario(addChildForm, [addSpecialty]);
                    limparFormulario(editChildForm, [editSpecialty]);
                    limparFormulario(transferChildForm, [transferSpecialty]);
                });
            });

            // Fechar modais ao clicar fora do conteúdo
            window.addEventListener('click', (event) => {
                if (event.target.classList.contains('modal')) {
                    fecharModal(event.target);
                    limparFormulario(addChildForm, [addSpecialty]);
                    limparFormulario(editChildForm, [editSpecialty]);
                    limparFormulario(transferChildForm, [transferSpecialty]);
                }
            });

            // Toggle campo "Especifique o vínculo" no adicionar criança
            addGuardianRelation.addEventListener('change', () => {
                toggleRelationField(addGuardianRelation, addRelationOtherField);
            });

            // Toggle campo "Especifique o vínculo" no editar criança
            editGuardianRelation.addEventListener('change', () => {
                toggleRelationField(editGuardianRelation, relationOtherField);
            });

            // Atualizar especialidade ao selecionar profissional no adicionar
            addAssignedProfessional.addEventListener('change', () => {
                atualizarEspecialidade(addAssignedProfessional, addSpecialty);
            });

            // Atualizar especialidade ao selecionar profissional no editar
            editAssignedProfessional.addEventListener('change', () => {
                atualizarEspecialidade(editAssignedProfessional, editSpecialty);
            });

            // Atualizar especialidade ao selecionar profissional no transferir
            transferAssignedProfessional.addEventListener('change', () => {
                atualizarEspecialidade(transferAssignedProfessional, transferSpecialty);
            });

            // Manipulação do formulário de adicionar criança
            addChildForm.addEventListener('submit', (event) => {
                event.preventDefault();
                // Validação adicional pode ser implementada aqui

                // Lógica para salvar a criança no backend (simulação)
                alert('Criança cadastrada com sucesso!');
                fecharModal(addChildModal);
                limparFormulario(addChildForm, [addSpecialty]);
                adicionarLinhaNaTabela();
            });

            // Manipulação do formulário de editar criança
            editChildForm.addEventListener('submit', (event) => {
                event.preventDefault();
                // Validação adicional pode ser implementada aqui

                // Lógica para salvar as alterações no backend (simulação)
                alert('Informações da criança atualizadas com sucesso!');
                fecharModal(editChildModal);
                limparFormulario(editChildForm, [editSpecialty]);
                atualizarLinhaNaTabela();
            });

            // Manipulação do formulário de transferir criança
            transferChildForm.addEventListener('submit', (event) => {
                event.preventDefault();
                // Validação adicional pode ser implementada aqui

                // Lógica para transferir a criança no backend (simulação)
                alert('Transferência realizada com sucesso!');
                fecharModal(transferChildModal);
                limparFormulario(transferChildForm, [transferSpecialty]);
                atualizarLinhaNaTabelaTransferida();
            });

            // Delegação de eventos para botões dinâmicos na tabela
            const childrenTable = document.getElementById('childrenTable').querySelector('tbody');

            childrenTable.addEventListener('click', (event) => {
                const target = event.target;
                const button = target.closest('button');
                if (!button) return;
                const row = button.closest('tr');

                if (button.classList.contains('edit')) {
                    // Preencher formulário de edição com dados da linha
                    const childId = row.cells[0].textContent;
                    const childName = row.cells[1].textContent;
                    const birthDate = row.getAttribute('data-birthdate') || '';
                    const clinic = row.getAttribute('data-clinic') || '';
                    const guardianName = row.cells[2].textContent;
                    const guardianRelation = row.getAttribute('data-guardian-relation') || "Mãe"; // Supondo um atributo data
                    const guardianOther = row.getAttribute('data-guardian-other') || '';
                    const assignedProfessional = row.cells[4].textContent;
                    const specialty = professionalsData[assignedProfessional] || "Nenhuma";

                    document.getElementById('editChildId').textContent = childId;
                    document.getElementById('editChildName').value = childName;
                    document.getElementById('editBirthDate').value = birthDate;
                    document.getElementById('editClinic').value = clinic;
                    document.getElementById('editGuardianName').value = guardianName;
                    document.getElementById('editGuardianRelation').value = guardianRelation;
                    toggleRelationField(editGuardianRelation, relationOtherField);
                    document.getElementById('editGuardianOther').value = guardianOther;
                    document.getElementById('editAssignedProfessional').value = assignedProfessional;
                    editSpecialty.textContent = specialty;

                    abrirModal(editChildModal);
                }

                if (button.classList.contains('transfer')) {
                    // Preencher formulário de transferência com dados da linha
                    const clinic = row.getAttribute('data-clinic') || '';
                    transferChildClinic.value = clinic;
                    carregarProfissionaisTransferencia(clinic);
                    transferSpecialty.textContent = professionalsData[transferAssignedProfessional.value] || "Selecione um profissional";

                    abrirModal(transferChildModal);
                }

                if (button.classList.contains('delete')) {
                    if (confirm('Deseja realmente remover esta criança? Esta ação não poderá ser desfeita.')) {
                        row.remove();
                        paginateTable('childrenTable', 'pagination-children', 10);
                        alert('Criança removida com sucesso!');
                    }
                }
            });

            // Função para carregar profissionais no modal de transferência com base na clínica selecionada
            const carregarProfissionaisTransferencia = (clinic) => {
                const profissionaisSelect = transferAssignedProfessional;
                profissionaisSelect.innerHTML = ''; // Limpa as opções anteriores

                if (clinic && clinicProfessionals[clinic]) {
                    clinicProfessionals[clinic].forEach(profissional => {
                        const option = document.createElement('option');
                        option.value = profissional;
                        option.textContent = profissional;
                        profissionaisSelect.appendChild(option);
                    });
                } else {
                    profissionaisSelect.innerHTML = '<option value="">Selecione uma clínica primeiro</option>';
                }

                // Atualizar a especialidade display
                transferSpecialty.textContent = "Selecione um profissional";
            };

            // Evento para carregar profissionais quando a clínica é selecionada no modal de transferência
            transferChildClinic.addEventListener('change', () => {
                const selectedClinic = transferChildClinic.value;
                carregarProfissionaisTransferencia(selectedClinic);
            });

            // Função para adicionar uma nova linha na tabela de crianças (Simulação)
            const adicionarLinhaNaTabela = () => {
                const tableBody = document.querySelector('#childrenTable tbody');
                const newRow = tableBody.insertRow();
                const uniqueId = generateUniqueId();
                const childName = document.getElementById('addChildName').value;
                const birthDate = document.getElementById('addBirthDate').value;
                const clinic = document.getElementById('addClinic').value;
                const guardianName = document.getElementById('addGuardianName').value;
                const guardianRelation = document.getElementById('addGuardianRelation').value === 'Outro' ? document.getElementById('addGuardianOther').value : document.getElementById('addGuardianRelation').value;
                const assignedProfessional = document.getElementById('addAssignedProfessional').value;
                const specialty = professionalsData[assignedProfessional] || "Nenhuma";

                newRow.setAttribute('data-birthdate', birthDate);
                newRow.setAttribute('data-clinic', clinic);
                newRow.setAttribute('data-guardian-relation', document.getElementById('addGuardianRelation').value);
                newRow.setAttribute('data-guardian-other', document.getElementById('addGuardianOther').value || '');

                newRow.innerHTML = `
                    <td>${uniqueId}</td>
                    <td>${childName}</td>
                    <td>${guardianName}</td>
                    <td>${clinic}</td>
                    <td>${assignedProfessional}</td>
                    <td>${specialty}</td>
                    <td class="actions">
                        <button class="btn edit" title="Editar Criança" aria-label="Editar Criança"><i class="fas fa-edit"></i> Editar</button>
                        <button class="btn transfer" title="Transferir de Clínica" aria-label="Transferir de Clínica"><i class="fas fa-exchange-alt"></i> Transferir</button>
                        <button class="btn delete" title="Remover Criança" aria-label="Remover Criança"><i class="fas fa-trash-alt"></i> Remover</button>
                    </td>
                `;
                paginateTable('childrenTable', 'pagination-children', 10);
            };

            // Função para atualizar a linha na tabela após edição (Simulação)
            const atualizarLinhaNaTabela = () => {
                // Aqui você implementaria a lógica para atualizar a linha com base nos dados editados
                alert('Informações da criança atualizadas com sucesso!');
                paginateTable('childrenTable', 'pagination-children', 10);
            };

            // Função para atualizar a tabela após transferência (Simulação)
            const atualizarLinhaNaTabelaTransferida = () => {
                // Aqui você implementaria a lógica para atualizar a linha com a nova clínica e profissional
                alert('Transferência realizada com sucesso!');
                paginateTable('childrenTable', 'pagination-children', 10);
            };
        });
    </script>

</body>
</html>
