<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Perfil - Sistema de Avaliação IFCora</title>
    <!-- Fonte personalizada e Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Estilos CSS -->
    <style>
        /* Estilos globais */
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f7fafc;
            color: #2d3748;
            overflow-x: hidden;
            margin: 0;
            padding: 0;
        }
        a {
            text-decoration: none;
            color: inherit;
        }
        /* Header */
        .header {
            background-color: #ffffff;
            height: 60px;
            width: 100%;
            position: fixed;
            top: 0;
            border-bottom: 1px solid #e2e8f0;
            z-index: 100;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            box-sizing: border-box;
        }
        .header .logo {
            display: flex;
            align-items: center;
        }
        .header .logo img {
            height: 40px;
            margin-right: 10px;
        }
        .header .logo h2 {
            font-size: 20px;
            color: #2d3748;
            margin: 0;
        }
        .header .user-menu {
            display: flex;
            align-items: center;
        }
        .header .user-menu a {
            font-size: 18px;
            margin-left: 20px;
            color: #2d3748;
            position: relative;
        }
        .header .user-menu a:hover {
            color: #08C89E;
        }
        /* Sidebar */
        .sidebar {
            width: 240px;
            height: calc(100vh - 60px);
            background-color: #ffffff;
            border-right: 1px solid #e2e8f0;
            position: fixed;
            top: 60px;
            left: 0;
            padding: 2rem 1rem;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            box-sizing: border-box;
        }
        .sidebar .profile {
            text-align: center;
            margin-bottom: 2rem;
        }
        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            border: 3px solid #08C89E;
            object-fit: cover;
        }
        .sidebar h3 {
            margin-top: 10px;
            font-size: 18px;
            color: #2d3748;
            margin-bottom: 5px;
        }
        .sidebar p {
            font-size: 90%;
            margin: 2px 0;
            color: #4a5568;
        }
        .sidebar small {
            display: inline-block;
            background-color: #08C89E;
            color: #fff;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            margin-top: 5px;
        }
        .sidebar .menu {
            margin-top: 30px;
        }
        .sidebar .menu a {
            font-size: 16px;
            display: flex;
            align-items: center;
            padding: 12px 20px;
            border-radius: 8px;
            transition: background 0.3s;
            color: #2d3748;
            margin-bottom: 10px;
        }
        .sidebar .menu a:hover {
            background-color: #f1f5f9;
        }
        .sidebar .menu a.active {
            background-color: #e6fffa;
            color: #08C89E;
            font-weight: 600;
        }
        .sidebar .menu a i {
            margin-right: 15px;
            font-size: 18px;
        }
        /* Botão de Sair */
        .logout {
            margin-top: auto;
        }
        .logout a {
            font-size: 16px;
            display: flex;
            align-items: center;
            padding: 12px 20px;
            border-radius: 8px;
            transition: background 0.3s;
            color: #e53e3e;
        }
        .logout a:hover {
            background-color: #ffe5e5;
        }
        .logout a i {
            margin-right: 15px;
            font-size: 18px;
        }
        /* Conteúdo */
        .content {
            margin-top: 80px;
            margin-left: 260px;
            padding: 20px 30px;
            box-sizing: border-box;
        }
        .header-content {
            margin-bottom: 20px;
        }
        .header-content h1 {
            font-size: 28px;
            color: #2d3748;
            margin-bottom: 5px;
            margin-top: -20px;
        }
        .header-content p {
            font-size: 16px;
            color: #4a5568;
            margin: 0;
        }
        /* Formulário de Perfil */
        .profile-form {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            max-width: 100%px;
            box-sizing: border-box;
        }
        .profile-form h2 {
            font-size: 24px;
            color: #08C89E;
            margin-bottom: 10px;
            margin-top: -10px;
            text-align: center;
        }
        .profile-form form {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }
        .profile-form .column {
            background-color: #f9fafb;
            padding: 15px;
            border-radius: 8px;
            box-sizing: border-box;
            border: 1px solid #e2e8f0;
            display: flex;
            flex-direction: column;
        }
        .profile-form .column h3 {
            font-size: 18px;
            color: #2d3748;
            margin-bottom: 15px;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 10px;
        }
        .profile-form .avatar-wrapper {
            text-align: center;
            margin-bottom: 35px;
            position: relative;
        }
        .profile-form .avatar-wrapper img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 3px solid #08C89E;
            object-fit: cover;
        }
        .profile-form .avatar-wrapper .upload-button {
            position: absolute;
            bottom: 0;
            right: calc(50% - 60px);
            background-color: #08C89E;
            border: none;
            border-radius: 50%;
            padding: 10px;
            cursor: pointer;
            color: #fff;
            transition: background 0.3s;
        }
        .profile-form .avatar-wrapper .upload-button:hover {
            background-color: #06b287;
        }
        .profile-form .avatar-wrapper input[type="file"] {
            display: none;
        }
        .profile-form label {
            display: block;
            font-size: 16px;
            color: #4a5568;
            margin-bottom: 5px;
        }
        .profile-form input,
        .profile-form select,
        .profile-form textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 16px;
            color: #2d3748;
            box-sizing: border-box;
        }
        .profile-form input[readonly] {
            background-color: #edf2f7;
            cursor: not-allowed;
        }
        .profile-form .form-actions {
            grid-column: 1 / -1;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-top: 10px;
        }
        .profile-form .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
            margin-left: 10px;
        }
        .profile-form .btn.save {
            background-color: #08C89E;
            color: #fff;
        }
        .profile-form .btn.save:hover {
            background-color: #06b287;
        }
        .profile-form .btn.cancel {
            background-color: #e53e3e;
            color: #fff;
        }
        .profile-form .btn.cancel:hover {
            background-color: #c53030;
        }
        /* Responsividade */
        @media (max-width: 1024px) {
            .profile-form form {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        @media (max-width: 768px) {
            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
                padding: 10px 20px;
                top: 60px;
                flex-direction: row;
                justify-content: space-between;
                align-items: center;
            }
            .sidebar .profile {
                display: none;
            }
            .sidebar .menu {
                flex-direction: row;
                margin-top: 0;
            }
            .sidebar .menu a {
                font-size: 14px;
                padding: 10px;
                margin-bottom: 0;
            }
            .sidebar .menu a i {
                margin-right: 5px;
            }
            .header {
                justify-content: space-between;
            }
            .header .logo h2 {
                font-size: 18px;
            }
            .content {
                margin-left: 0;
                margin-top: 80px;
            }
            .profile-form {
                padding: 15px;
            }
            .profile-form form {
                grid-template-columns: 1fr;
            }
            .profile-form .column {
                width: 100%;
            }
            .profile-form .avatar-wrapper .upload-button {
                right: calc(50% - 60px);
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos">
            <h2>Sistema de Avaliação - IFCora</h2>
        </div>
        <nav class="user-menu">
            <a href="#" title="Notificações"><i class="fas fa-bell"></i></a>
            <a href="#" title="Configurações"><i class="fas fa-cog"></i></a>
            <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>
        </nav>
    </header>
    <!-- Sidebar -->
    <?php include 'includes/sidebar-painel-profissional.php'; ?>
    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1 style="margin-top: -20px; margin-bottom: -10px; color: #08C89E" >Gerenciar Perfil</h1>
        </div>
        <!-- Formulário de Perfil -->
        <div class="profile-form">
            <h2 style="text-align: left">Atualize suas informações</h2>
            <form id="profileForm">
                <!-- Primeira Coluna: Dados Pessoais com Avatar -->
                <div class="column">
                    <h3>Dados Pessoais</h3>
                    <div class="avatar-wrapper">
                        <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                        <label class="upload-button" for="upload-photo" aria-label="Upload de Foto">
                            <i class="fas fa-camera"></i>
                            <input type="file" id="upload-photo" accept="image/*" aria-hidden="true">
                        </label>
                    </div>
                    <div class="form-group">
                        <label for="profileName">Nome Completo</label>
                        <input type="text" id="profileName" name="profileName" value="Coralina Matos" required>
                    </div>
                    <div class="form-group">
                        <label for="profileProfession">Profissão</label>
                        <input type="text" id="profileProfession" name="profileProfession" value="Terapeuta Ocupacional">
                    </div>
                    <div class="form-group">
                        <label for="profileRegistration">Registro Profissional</label>
                        <input type="text" id="profileRegistration" name="profileRegistration" value="CREFITO: 12.132-TO">
                    </div>
                    
                    <div class="form-group">
                        <label for="profileEmail">Email</label>
                        <input type="email" id="profileEmail" name="profileEmail" value="coralina.matos@example.com" readonly>
                    </div>
                    <div class="form-group">
                        <label for="profilePhone">Telefone</label>
                        <input type="tel" id="profilePhone" name="profilePhone" value="(99) 99999-9999">
                    </div>
                    
                    <button type="button" class="btn save" id="savePersonalInfo">Salvar Informações</button>
                </div>
                <!-- Segunda Coluna: Contato com Endereço -->
                <div class="column">
                    <h3>Endereço</h3>
                    
                    <!-- Campos de Endereço -->
                    <div class="form-group">
                        <label for="profileStreet">Endereço</label>
                        <input type="text" id="profileStreet" name="profileStreet" placeholder="Rua Exemplo" required>
                    </div>
                    <div class="form-group">
                        <label for="profileNumber">Número</label>
                        <input type="text" id="profileNumber" name="profileNumber" placeholder="123" required>
                    </div>
                    <div class="form-group">
                        <label for="profileComplement">Complemento</label>
                        <input type="text" id="profileComplement" name="profileComplement" placeholder="Apto 45">
                    </div>
                    <div class="form-group">
                        <label for="profileNeighborhood">Bairro</label>
                        <input type="text" id="profileNeighborhood" name="profileNeighborhood" placeholder="Bairro Exemplo" required>
                    </div>
                    <div class="form-group">
                        <label for="profileCity">Cidade</label>
                        <input type="text" id="profileCity" name="profileCity" placeholder="Cidade Exemplo" required>
                    </div>
                    <div class="form-group">
                        <label for="profileState">Estado</label>
                        <select id="profileState" name="profileState" required>
                            <option value="">Selecione</option>
                            <option value="AC">Acre (AC)</option>
                            <option value="AL">Alagoas (AL)</option>
                            <option value="AP">Amapá (AP)</option>
                            <option value="AM">Amazonas (AM)</option>
                            <option value="BA">Bahia (BA)</option>
                            <option value="CE">Ceará (CE)</option>
                            <option value="DF">Distrito Federal (DF)</option>
                            <option value="ES">Espírito Santo (ES)</option>
                            <option value="GO">Goiás (GO)</option>
                            <option value="MA">Maranhão (MA)</option>
                            <option value="MT">Mato Grosso (MT)</option>
                            <option value="MS">Mato Grosso do Sul (MS)</option>
                            <option value="MG">Minas Gerais (MG)</option>
                            <option value="PA">Pará (PA)</option>
                            <option value="PB">Paraíba (PB)</option>
                            <option value="PR">Paraná (PR)</option>
                            <option value="PE">Pernambuco (PE)</option>
                            <option value="PI">Piauí (PI)</option>
                            <option value="RJ">Rio de Janeiro (RJ)</option>
                            <option value="RN">Rio Grande do Norte (RN)</option>
                            <option value="RS">Rio Grande do Sul (RS)</option>
                            <option value="RO">Rondônia (RO)</option>
                            <option value="RR">Roraima (RR)</option>
                            <option value="SC">Santa Catarina (SC)</option>
                            <option value="SP">São Paulo (SP)</option>
                            <option value="SE">Sergipe (SE)</option>
                            <option value="TO">Tocantins (TO)</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="profileCEP">CEP</label>
                        <input type="text" id="profileCEP" name="profileCEP" placeholder="12345-678" required>
                    </div>
                    <button type="button" class="btn save" id="saveContactInfo">Salvar Endereço</button>
                </div>
                <!-- Terceira Coluna: Alterar Senha -->
                <div class="column">
                    <h3>Alterar Senha</h3>
                    <div class="form-group">
                        <label for="currentPassword">Senha Atual</label>
                        <input type="password" id="currentPassword" name="currentPassword" required>
                    </div>
                    <div class="form-group">
                        <label for="newPassword">Nova Senha</label>
                        <input type="password" id="newPassword" name="newPassword" required>
                    </div>
                    <div class="form-group">
                        <label for="confirmPassword">Repetir Nova Senha</label>
                        <input type="password" id="confirmPassword" name="confirmPassword" required>
                    </div>
                    <button type="submit" class="btn save">Salvar Senha</button>
                </div>
            </form>
        </div>
    </main>
    <!-- Scripts -->
    <script>
        // Evento para salvar informações pessoais
        document.getElementById('savePersonalInfo').addEventListener('click', function() {
            // Aqui você pode adicionar a lógica para salvar as informações pessoais no servidor
            alert('Informações pessoais salvas com sucesso!');
        });

        // Evento para salvar informações de contato
        document.getElementById('saveContactInfo').addEventListener('click', function() {
            // Aqui você pode adicionar a lógica para salvar as informações de contato e endereço no servidor
            alert('Informações de contato e endereço salvas com sucesso!');
        });

        // Evento para o formulário de senha
        document.getElementById('profileForm').addEventListener('submit', function(event) {
            event.preventDefault();
            // Validação básica para verificar se as senhas coincidem
            const currentPassword = document.getElementById('currentPassword').value;
            const newPassword = document.getElementById('newPassword').value;
            const confirmPassword = document.getElementById('confirmPassword').value;

            if (newPassword !== confirmPassword) {
                alert('As novas senhas não coincidem. Por favor, verifique.');
                return;
            }

            if (newPassword.length < 6) {
                alert('A nova senha deve ter pelo menos 6 caracteres.');
                return;
            }

            // Aqui você pode adicionar a lógica para alterar a senha no servidor
            alert('Senha alterada com sucesso!');
            // Opcional: limpar os campos de senha
            document.getElementById('currentPassword').value = '';
            document.getElementById('newPassword').value = '';
            document.getElementById('confirmPassword').value = '';
        });

        // Pré-visualização da foto de perfil
        const uploadPhotoInput = document.getElementById('upload-photo');
        const avatarImage = document.getElementById('avatar');

        uploadPhotoInput.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    avatarImage.src = e.target.result;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>
</html>
