<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checklist PORTAGE - Avaliação Móvel</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
            padding-top: 70px; /* Espaço para o cabeçalho fixo */
        }

        h3, h4, h5 {
            color: #08C89E;
            margin-bottom: 15px;
        }

        p {
            font-size: 14px;
            color: #4a5568;
        }

        .info-section {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px 10px 0px 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .info-section h5 {
            color: #08C89E;
            margin-bottom: 10px;
        }

        .info-section p {
            margin-bottom: 5px;
        }

        .avaliacoes-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .checklist-left-section {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
            width: 100%;
            margin-bottom: 10px;
        }

        /* Estilização dos Botões */
        .checklist-editar-btn,
        .btn-back,
        .btn-save,
        .btn-load {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 5px;
            color: white;
        }

        .btn-back {
            background-color: #4a5568;
        }

        .btn-back:hover {
            background-color: #2d3748;
        }

        .btn-save {
            background-color: #08C89E;
        }

        .btn-save:hover {
            background-color: #069f7a;
        }

        .btn-load {
            background-color: #3182ce;
        }

        .btn-load:hover {
            background-color: #2c5282;
        }

        /* Responsividade */
        @media (max-width: 576px) {
            .avaliacoes-container {
                flex-direction: column;
                align-items: stretch;
            }

            .checklist-left-section {
                width: 100%;
                justify-content: center;
            }

            .checklist-avaliacao-select {
                width: 100%;
                margin-top: 10px;
            }
        }

        /* Card renomeado para evitar conflitos */
        .portage-card {
            background: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: box-shadow 0.3s ease, border 0.3s ease;
            cursor: pointer;
        }

        .portage-card:hover {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }

        /* Estilo quando card estiver selecionado */
        .portage-card.selected {
            border: 2px solid #08C89E;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .checkbox-title {
            font-weight: 600;
            margin-bottom: 5px;
            font-size: 14px;
            color: #2d3748;
            line-height: 1.2;

        }

        .skill-description {
            font-size: 13px;
            color: #4a5568;
            margin-bottom: 10px;
        }

        .skill-actions {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            border-top: 1px solid #e2e8f0;
            border-bottom: 1px solid #e2e8f0;
            padding: 10px 0;
            font-size: 13px;
        }

        .skill-actions .option {
            flex: 1;
            text-align: center;
        }

        .skill-actions .option:not(:last-child) {
            border-right: 1px solid #e2e8f0;
        }

        .skill-actions .option:last-child {
            border-right: none;
        }

        .skill-actions .option label {
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }

        .skill-actions .option input[type="radio"] {
            margin-right: 5px;
        }

        /* Renomeando classes de orientação */
        .portage-orientation-toggle {
            display: flex;
            align-items: center;
            gap: 5px;
            cursor: pointer;
            color: #3182ce;
            font-size: 14px;
        }

        .portage-orientation-text {
            margin-top: 10px;
            display: none;
            font-size: 13px;
            line-height: 1.2;
            color: #4a5568;
        }
        
        .portage-orientation-text ol {
            padding-left: 10px; /* Alinhar a lista com uma margem à esquerda */
            list-style-type: decimal; /* Números em formato decimal */
            margin-bottom: 20px; /* Espaço abaixo da lista */
        }
        
        .portage-orientation-text li {
            margin-bottom: 10px; /* Espaçamento entre os itens da lista */
            font-size: 12px; /* Tamanho da fonte dos itens */
            color: #555; /* Cor do texto dos itens da lista */
        }
        
        .portage-orientation-text li::marker {
            color: #007BFF; /* Cor personalizada para os números da lista */
            font-weight: bold; /* Negrito para os números */
        }
        
        .portage-orientation-text li:hover {
            background-color: #eef9ff; /* Cor de fundo suave quando o item é passado o mouse sobre */
            cursor: pointer; /* Mostrar cursor de clique */
        }
        
        .portage-orientation-text li:last-child {
            margin-bottom: 0; /* Remover margem do último item */
        }
        
        .portage-orientation-text p {
            margin-bottom: 8px;
            font-size: 11px;
        }

        /* Ícone de seta rotacionar quando ativo */
        .portage-orientation-toggle.rotate i {
            transform: rotate(180deg);
            transition: transform 0.3s;
        }

        /* Modal Customizado */
        .modal-header {
            background-color: #08C89E;
            color: white;
            border-bottom: none;
        }

        .modal-footer {
            border-top: none;
        }
        
        /* Estilização Geral das Abas */
        .nav-tabs {
            border-bottom: 2px solid #08C89E; /* Linha inferior das abas principais */
        }

        .nav-tabs .nav-link {
            color: #4a5568; /* Cor do texto das abas */
            font-weight: 600; /* Peso da fonte */
            border: none; /* Remove bordas padrão */
            border-radius: 10px 10px 0px 0px; /* Remove bordas arredondadas */
            margin-right: 0px; /* Espaçamento entre as abas */
            padding: 10px 15px; /* Padding interno das abas */
            transition: background-color 0.3s, color 0.3s; /* Transições suaves */
            border-bottom: 1px solid #e2e8f0; /* Borda das abas */
        }

        .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da aba ativa */
            background-color: #08C89E; /* Fundo da aba ativa */
            border-bottom: 2px solid #08C89E; /* Linha inferior da aba ativa */
        }

        /* Estilização das Sub-Abas */
        .tab-content .nav-tabs {
            border-bottom: 1px solid #e2e8f0; /* Linha inferior das sub-abas */
            margin-bottom: 15px; /* Espaçamento abaixo das sub-abas */
        }

        .tab-content .nav-tabs .nav-link {
            color: #2d3748; /* Cor do texto das sub-abas */
            background-color: #f5f8fb; /* Fundo das sub-abas */
            font-weight: 500; /* Peso da fonte */
            margin-right: 2px;
        }

        .tab-content .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da sub-aba ativa */
            background-color: #3182ce; /* Fundo da sub-aba ativa */
            border-bottom: none; /* Remove a linha inferior da sub-aba ativa */
        }

        /* Estilização das Páginas das Abas (Tab Panes) */
        .tab-pane {
            padding: 20px; /* Padding interno das abas */
            background-color: #ffffff; /* Fundo das abas */
            border: 1px solid #e2e8f0; /* Borda das abas */
            border-top: none; /* Remove a borda superior para conectar com as abas */
            border-radius: 0 0 8px 8px; /* Bordas arredondadas na parte inferior */
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05); /* Sombra sutil */
            transition: opacity 0.3s ease-in-out; /* Transição de opacidade suave */
            opacity: 0; /* Opacidade inicial */
            height: 100%; /* Altura completa */
        }

        .tab-pane.show {
            opacity: 1; /* Opacidade quando a aba está ativa */
        }

        /* Estilização para Abas Aninhadas */
        .tab-content .tab-content .nav-tabs {
            border-bottom: 1px solid #cbd5e0; /* Linha inferior das sub-sub-abas */
            margin-bottom: 10px; /* Espaçamento abaixo das sub-sub-abas */
        }

        .tab-content .tab-content .nav-tabs .nav-link {
            color: #2d3748; /* Cor do texto das sub-sub-abas */
            background-color: #edf2f7; /* Fundo das sub-sub-abas */
            font-weight: 500; /* Peso da fonte */
            margin-right: 2px;
        }

        .tab-content .tab-content .nav-tabs .nav-link.active {
            color: #ffffff; /* Cor do texto da sub-sub-aba ativa */
            background-color: #2b6cb0; /* Fundo da sub-sub-aba ativa */
            border-bottom: none; /* Remove a borda inferior da sub-sub-aba ativa */
        }

        .tab-content .tab-content .tab-pane {
            padding: 15px; /* Padding interno das sub-abas */
            background-color: #e9f4ff; /* Fundo das sub-abas */
            border: 1px solid #cbd5e0; /* Borda das sub-abas */
            border-top: none; /* Remove a borda superior para conectar com as sub-abas */
            border-radius: 0 0 6px 6px; /* Bordas arredondadas na parte inferior */
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05); /* Sombra sutil */
        }

        .tab-content .tab-content .tab-pane.show {
            opacity: 1; /* Opacidade quando a sub-aba está ativa */
        }

        /* Transições Suaves para Abas Aninhadas */
        .tab-content .tab-content .tab-pane {
            transition: opacity 0.3s ease-in-out;
            opacity: 0;
        }

        /* Responsividade para Dispositivos Móveis */
        @media (max-width: 768px) {
            body {
                padding: 0px;
                margin-top: 70px;
            }
            
            .nav-tabs .nav-link {
                padding: 8px 12px; /* Reduz o padding em telas menores */
                font-size: 14px; /* Reduz o tamanho da fonte */
            }

            .tab-content .nav-tabs .nav-link {
                padding: 6px 10px; /* Reduz o padding das sub-abas */
                font-size: 13px; /* Reduz o tamanho da fonte das sub-abas */
            }

            .tab-content .tab-content .nav-tabs .nav-link {
                padding: 5px 8px; /* Reduz ainda mais o padding das sub-sub-abas */
                font-size: 12px; /* Reduz o tamanho da fonte das sub-sub-abas */
            }

            .tab-pane, .tab-content .tab-content .tab-pane {
                padding: 15px; /* Ajusta o padding interno */
            }
            
            .container-fluid {
                max-width: 100%; /* Garante que a largura seja 100% */
                padding-left: 0px; /* Pode adicionar algum padding se necessário */
                padding-right: 0px;
            }
        }

        /* Melhorias Visuais para Padrões de Abas */
        .tab-content .tab-content .nav-tabs .nav-link:hover {
            background-color: #2c5282; /* Fundo das sub-sub-abas ao passar o mouse */
        }

        /* Scroll suave para mobile */
        .tab-content {
            overflow-x: auto;
        }
        
        /* Navbar Customizada */
        .navbar {
            background-color: #08C89E;
        }

        .navbar-brand, .navbar-nav .nav-link, .navbar-toggler-icon {
            color: #fff !important;
        }
        
        /* Cores suaves para feedback visual */
        .bg-sim {
            background-color: #d4f8d4 !important; /* verde suave */
        }
        
        .bg-av {
            background-color: #ffd8b1 !important; /* laranja suave */
        }
        
        .bg-nao {
            background-color: #f8d4d4 !important; /* vermelho suave */
        }
        
        
        .checkbox-interpretation {
            font-size: 11px;
            color: #6b7280;        /* Tom de cinza suave para o texto */
            margin-top: 4px;
            padding: 4px 0;        /* Pequeno espaçamento superior e inferior */
            font-style: italic;    /* Estilo itálico para diferenciação sutil */
            line-height: 1.2;
        }





    </style>
</head>
<body>
    <!-- Cabeçalho (Navbar) -->
    <!-- Navbar Fixa -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <a class="navbar-brand" href="#">IFCora - Portage</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mobileNavbar" aria-controls="mobileNavbar" aria-expanded="false" aria-label="Alternar navegação">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="mobileNavbar">
            <ul class="navbar-nav mr-auto">
                
                <!-- Adicione mais itens de navegação conforme necessário -->
            </ul>
            <ul class="navbar-nav">
                
                <li class="nav-item">
                    <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
                </li>
            </ul>
        </div>
    </nav>
    
    <div class="container-fluid">
        <h3>Checklist PORTAGE</h3>
        <p style="margin-top:-20px">Toque nas orientações para expandir dicas e informações adicionais.</p>

        <!-- Seção de Informações sobre a Criança, Profissional e Avaliação (Compacta com Accordion) -->
        <div class="info-section">
            <h5 data-toggle="collapse" href="#infoContent" role="button" aria-expanded="false" aria-controls="infoContent">
                <i class="fas fa-user"></i> Informações da Avaliação <i class="fas fa-chevron-down float-right"></i>
            </h5>
            <div class="collapse info-content" id="infoContent">
                <div class="row">
                    <!-- Informações da Criança -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-child"></i> Criança</h6>
                        <p><strong>Nome:</strong> João da Silva</p>
                        <p><strong>Data de Nascimento:</strong> 20/05/2018 (6 anos)</p>
                        <p><strong>Gênero:</strong> Masculino</p>
                    </div>
                    <!-- Informações do Profissional -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-user-md"></i> Profissional</h6>
                        <p><strong>Nome:</strong> Dr. Maria Oliveira</p>
                        <p><strong>Especialidade:</strong> Psicopedagoga</p>
                        <p><strong>Contato:</strong> maria.oliveira@clinicaportage.com</p>
                    </div>
                    <!-- Informações da Avaliação -->
                    <div class="col-md-4">
                        <h6><i class="fas fa-file-alt"></i> Avaliação</h6>
                        <p><strong>ID Avaliação:</strong> AV27490</p>
                        <p><strong>Data:</strong> 28/06/2024</p>
                        <p><strong>Status:</strong> Aberta</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Seção de Gerenciamento de Avaliações -->
        <div class="avaliacoes-container">
            <div class="checklist-left-section">
                <button type="button" class="btn-back" id="backBtn">
                    <i class="fas fa-arrow-left"></i> 
                </button>
                <button type="button" class="btn-load" id="loadBtn" data-toggle="modal" data-target="#loadAvaliacaoModal">
                    <i class="fas fa-folder-open"></i> Carregar Avaliação
                </button>
                <button type="button" class="btn-save" id="saveBtn">
                    <i class="fas fa-save"></i> Salvar
                </button>
                <button class="btn-export"><i class="fas fa-file-export"></i> Exportar PDF</button>
            </div>
        </div>
        
        <!-- Abas de áreas de desenvolvimento -->
        <ul class="nav nav-tabs" id="areaTabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" href="#social" data-toggle="tab" role="tab" aria-controls="social" aria-selected="false">Soc.</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#cognicao" data-toggle="tab" role="tab" aria-controls="cognicao" aria-selected="false">Cog.</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#linguagem" data-toggle="tab" role="tab" aria-controls="linguagem" aria-selected="false">Ling.</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#social" data-toggle="tab" role="tab" aria-controls="social" aria-selected="false">Aut.</a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="#motor" data-toggle="tab" role="tab" aria-controls="motor" aria-selected="true">Mot.</a>
            </li>
        </ul>

        <div class="tab-content nested-tab-content">
            <!-- Área Social -->
            <div id="social" class="tab-pane fade show active" role="tabpanel">
                <h4 class="mt-3">Social</h4>
                
                <!-- Sub-abas de faixas etárias para Social -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#social0_1" data-toggle="tab" role="tab" aria-controls="social0_1" aria-selected="true">0 - 1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social1_2" data-toggle="tab" role="tab" aria-controls="social1_2" aria-selected="false">1 - 2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social2_3" data-toggle="tab" role="tab" aria-controls="social2_3" aria-selected="false">2 - 3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social3_4" data-toggle="tab" role="tab" aria-controls="social3_4" aria-selected="false">3 - 4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social4_5" data-toggle="tab" role="tab" aria-controls="social4_5" aria-selected="false">4 - 5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#social5_6" data-toggle="tab" role="tab" aria-controls="social5_6" aria-selected="false">5 - 6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0 - 1 ano - Social -->
                    <div id="social0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0 - 1 ano</h5>
                        
                        <!-- Card 1 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S1 - Observa uma pessoa se movendo diretamente no seu campo visual.</div>
                          <div class="checkbox-interpretation">A criança deve olhar em direção e seguir com o olhar uma pessoa se movendo diretamente em seu campo visual dentro de 20 segundos após o início do movimento.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item1" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item1" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item1" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item1"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item1">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Colocar a criança deitada ou sentada, apoiada com almofadas, ou em um “bebê conforto”. Mover-se dentro do campo visual da criança, lentamente (ou seja, demorar de 3 a 4 segundos para mover-se uma distância de 30 cm). Mover-se dentro do campo visual da criança da direita para a esquerda ou vice-versa, ou aproximando-se e afastando-se dela.</p>
                            <p><strong>Resposta:</strong> Observar = olhar em direção e seguir com o olhar uma pessoa se movimentando diretamente em seu campo visual, dentro de 20 segundos após o início do movimento.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Olha em direção e segue com o olhar uma pessoa se movimentando diretamente em seu campo visual, dentro de 20 segundos após o início do movimento.</li>
                              <li><strong>AV:</strong> A criança não observa, mas pode estar em processo de desenvolvimento dessa habilidade.</li>
                              <li><strong>Não:</strong> Não observa uma pessoa se movimentando diretamente em seu campo visual.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 2 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S2 - Sorri em resposta à atenção do adulto.</div>
                          <div class="checkbox-interpretation">A criança deve sorrir dentro de 10 segundos após o adulto dar atenção a ela.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item2" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item2" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item2" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item2"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item2">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ao alimentar, trocar, acalentar ou colocar a criança no berço ou sentada, o adulto deve manter sua face distante de 20 a 25 cm do rosto da criança, sorrir e falar baixinho por 10 segundos.</p>
                            <p><strong>Resposta:</strong> Sorri em resposta à atenção = sorrir dentro de 10 segundos após o adulto dar atenção à criança.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Sorri em resposta à atenção do adulto dentro de 10 segundos após o adulto dar atenção à criança.</li>
                              <li><strong>AV:</strong> A criança pode não sorrir, mas está em processo de desenvolvimento dessa resposta.</li>
                              <li><strong>Não:</strong> Não sorri em resposta à atenção do adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 3 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S3 - Vocaliza em resposta à atenção do adulto.</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar dentro de 10 segundos após a atenção de um adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item3" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item3" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item3" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item3"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item3">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ao alimentar, trocar, acalentar ou colocar a criança no berço ou sentada, o adulto deve manter sua face distante de 20 a 25 cm do rosto da criança, sorrir e falar baixinho por 10 segundos.</p>
                            <p><strong>Resposta:</strong> Vocalizar em resposta à atenção = apresentar qualquer tipo de vocalização dentro de 10 segundos após a atenção de um adulto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Vocaliza em resposta à atenção do adulto dentro de 10 segundos após o adulto dar atenção à criança.</li>
                              <li><strong>AV:</strong> A criança não vocaliza, mas pode estar em processo de desenvolvimento dessa habilidade.</li>
                              <li><strong>Não:</strong> Não vocaliza em resposta à atenção do adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 4 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S4 - Olha para a própria mão, frequentemente, sorrindo ou vocalizando.</div>
                          <div class="checkbox-interpretation">A criança deve permanecer olhando em direção à sua mão por 5 segundos, sorrindo ou vocalizando pelo menos 1 vez em 3 tentativas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item4" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item4" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item4" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item4"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item4">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se necessário, mover as mãos da criança de um lado para outro, próximo a seu rosto. Segurar a mão da criança e, com seus dedos, mover os da criança para frente e para trás.</p>
                            <p><strong>Resposta:</strong> Permanecer olhando por 5 segundos em direção à sua mão, sorrindo ou vocalizando pelo menos 1 vez em 3 tentativas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Olha e permanece olhando para a própria mão por 5 segundos, sorrindo ou vocalizando pelo menos 1 vez em 3 tentativas.</li>
                              <li><strong>AV:</strong> A criança pode não olhar consistentemente, mas está desenvolvendo essa habilidade.</li>
                              <li><strong>Não:</strong> Não olha para a própria mão.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 5 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S5 - Responde a seu círculo familiar, sorrindo, vocalizando ou parando de chorar.</div>
                          <div class="checkbox-interpretation">A criança deve responder a seu círculo familiar sorrindo, vocalizando ou parando de chorar dentro de 10 segundos após a atenção do membro da família.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item5" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item5" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item5" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item5"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item5">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Observar a resposta da criança em relação a seus familiares.</p>
                            <p><strong>Resposta:</strong> Responder a seu círculo familiar = mãe, pai ou irmãos, sorrindo, vocalizando ou parando de chorar dentro de 10 segundos após a atenção do membro da família.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Responde a seu círculo familiar, sorrindo, vocalizando ou parando de chorar dentro de 10 segundos após a atenção do membro da família.</li>
                              <li><strong>AV:</strong> A resposta pode ser inconsistente, indicando desenvolvimento em andamento.</li>
                              <li><strong>Não:</strong> Não responde a seu círculo familiar.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 6 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S6 - Sorri em resposta à expressão facial dos outros.</div>
                          <div class="checkbox-interpretation">A criança deve sorrir em resposta à expressão facial dos outros dentro de 10 segundos após tal expressão.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item6" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item6" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item6" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item6"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item6">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ao atender a criança em suas necessidades diárias, o adulto deve manter sua face distante de 20 a 25 cm do rosto da criança e produzir expressões faciais ou caretas exageradas que indiquem surpresa e satisfação por 10 segundos (por exemplo: erguer a sobrancelha, fazer “beiço”, fazer um “ô” com os lábios).</p>
                            <p><strong>Resposta:</strong> Sorrir em resposta à expressão facial dos outros dentro de 10 segundos após tal expressão facial.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Sorri em resposta à expressão facial dos outros dentro de 10 segundos após a expressão.</li>
                              <li><strong>AV:</strong> A resposta pode ser inconsistente ou demorar mais de 10 segundos.</li>
                              <li><strong>Não:</strong> Não sorri em resposta à expressão facial dos outros.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 7 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S7 - Sorri e vocaliza ao ver sua imagem no espelho.</div>
                          <div class="checkbox-interpretation">A criança deve sorrir e vocalizar dentro de 10 segundos ao olhar em direção à sua imagem no espelho.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item7" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item7" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item7" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item7"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item7">
                            <p><strong>Recursos Materiais:</strong> Espelho.</p>
                            <p><strong>Condição:</strong> Colocar a criança de frente para o espelho.</p>
                            <p><strong>Resposta:</strong> Sorrir e vocalizar dentro de 10 segundos ao olhar em direção à sua imagem no espelho.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Sorri e vocaliza dentro de 10 segundos ao olhar em direção à sua imagem no espelho.</li>
                              <li><strong>AV:</strong> A criança pode mostrar interesse limitado ou respostas atrasadas.</li>
                              <li><strong>Não:</strong> Não sorri ou vocaliza ao ver sua imagem no espelho.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 8 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S8 - Acaricia ou toca no rosto de adultos.</div>
                          <div class="checkbox-interpretation">A criança deve acariciar, puxar cabelo ou óculos de adultos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item8" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item8" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item8" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item8"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item8">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> O rosto do adulto deve estar próximo da criança de 20 a 25 cm.</p>
                            <p><strong>Resposta:</strong> Acariciar = bater, dar tapinhas ou tocar no rosto do adulto, ou ainda puxar cabelo ou óculos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Acaricia, puxa cabelo ou óculos de adultos.</li>
                              <li><strong>AV:</strong> A criança pode tocar de forma esporádica ou insegura.</li>
                              <li><strong>Não:</strong> Não acaricia ou toca no rosto de um adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 9 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S9 - Estende a mão em direção a um objeto que lhe é oferecido.</div>
                          <div class="checkbox-interpretation">A criança deve estender a mão em direção a um objeto oferecido dentro de 20 segundos após a apresentação do mesmo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item9" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item9" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item9" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item9"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item9">
                            <p><strong>Recursos Materiais:</strong> Objetos atraentes, joias, brinquedos favoritos da criança, chupeta ou o próprio dedo do adulto.</p>
                            <p><strong>Condição:</strong> Apresentar os objetos próximos à mão da criança (15 a 20 cm). Se necessário, agitar o objeto para “chamar a atenção” da mesma.</p>
                            <p><strong>Resposta:</strong> Estender a mão em direção a um objeto que lhe é oferecido dentro de 20 segundos após a apresentação do mesmo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Estende a mão em direção a um objeto oferecido dentro de 20 segundos após a apresentação do mesmo.</li>
                              <li><strong>AV:</strong> A criança pode estender a mão de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não estende a mão em direção a um objeto que lhe é oferecido.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 10 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S10 - Estende os braços em direção a pessoas familiares.</div>
                          <div class="checkbox-interpretation">A criança deve estender os braços em direção a pelo menos 2 pessoas familiares diferentes dentro de 20 segundos após estas se aproximarem ou lhe darem atenção.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item10" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item10" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item10" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item10"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item10">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se necessário, o adulto pode estender os braços para a criança e dizer “vem no colo da(o)...”.</p>
                            <p><strong>Resposta:</strong> Estender os braços em direção a uma pessoa familiar dentro de 20 segundos após esta aproximar-se e/ou lhe dar atenção. Deve estender os braços para pelo menos 2 pessoas familiares diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Estende os braços para pelo menos 2 pessoas familiares dentro de 20 segundos após estas se aproximarem ou lhe darem atenção.</li>
                              <li><strong>AV:</strong> A criança pode estender os braços de forma inconsistente ou para menos de 2 pessoas.</li>
                              <li><strong>Não:</strong> Não estende os braços em direção a pessoas familiares.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 11 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S11 - Estende a mão e toca a sua imagem refletida no espelho ou estende a mão e toca outra criança.</div>
                          <div class="checkbox-interpretation">A criança deve estender a mão e tocar sua imagem no espelho ou tocar outra criança dentro de 20 segundos após a apresentação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item11" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item11" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item11" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item11"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item11">
                            <p><strong>Recursos Materiais:</strong> Espelho.</p>
                            <p><strong>Condição:</strong> Colocar a criança de frente para o espelho e perguntar “Cadê o nenê?” ou “Cadê a(o)...?”.</p>
                            <p><strong>Resposta:</strong> Estender a mão e tocar sua imagem refletida no espelho ou estender a mão e tocar outra criança, dentro de 20 segundos após ser colocada frente ao espelho ou após a aproximação de outra criança.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Estende a mão para tocar sua imagem refletida no espelho ou para tocar outra criança dentro de 20 segundos após a apresentação.</li>
                              <li><strong>AV:</strong> A criança pode tocar de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não estende a mão para tocar sua imagem refletida no espelho ou para tocar outra criança.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 12 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S12 - Segura e examina pelo menos por um minuto, um objeto que lhe foi dado.</div>
                          <div class="checkbox-interpretation">A criança deve segurar e examinar um objeto por pelo menos 1 minuto, iniciando a resposta dentro de 20 segundos após a apresentação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item12" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item12" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item12" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item12"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item12">
                            <p><strong>Recursos Materiais:</strong> Chocalho, brinquedo de fácil preensão ou objetos atraentes pela sua cor ou ruído.</p>
                            <p><strong>Condição:</strong> Oferecer um objeto para a criança.</p>
                            <p><strong>Resposta:</strong> Segurar e examinar (permanecer olhando e manipulando) um objeto que lhe foi dado, pelo menos por 1 minuto. A resposta deve ser iniciada dentro de 20 segundos após a apresentação do objeto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Segura e examina um objeto que lhe foi dado, por 1 minuto e inicia a resposta dentro de 20 segundos após a apresentação.</li>
                              <li><strong>AV:</strong> A criança pode segurar o objeto por menos tempo ou iniciar a resposta com atraso.</li>
                              <li><strong>Não:</strong> Não segura nem examina um objeto que lhe foi dado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 13 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S13 - Sacode ou aperta um objeto colocado em sua mão, produzindo sons involuntários.</div>
                          <div class="checkbox-interpretation">A criança deve sacudir ou apertar um objeto colocado em sua mão, produzindo sons involuntários.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item13" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item13" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item13" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item13"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item13">
                            <p><strong>Recursos Materiais:</strong> Chocalho ou bichinhos de borracha.</p>
                            <p><strong>Condição:</strong> Colocar o objeto na mão da criança.</p>
                            <p><strong>Resposta:</strong> Sacudir ou apertar um objeto colocado em sua mão, produzindo sons involuntários.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Sacode ou aperta um objeto colocado em sua mão, produzindo sons involuntários.</li>
                              <li><strong>AV:</strong> A criança pode sacudir o objeto de forma limitada ou sem produzir sons claros.</li>
                              <li><strong>Não:</strong> Não sacode ou aperta objetos colocados em sua mão.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 14 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S14 - Brinca sozinho por 10 minutos.</div>
                          <div class="checkbox-interpretation">A criança deve permanecer tocando ou manipulando brinquedos ou objetos sem destruí-los, sem choramingar ou reclamar pela presença de um adulto, por 10 minutos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item14" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item14" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item14" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item14"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item14">
                            <p><strong>Recursos Materiais:</strong> Bolas, colheres, bichinhos de borracha, xícaras plásticas, chocalho, rádio, etc.</p>
                            <p><strong>Condição:</strong> Colocar vários objetos próximos à criança, engajá-la em uma atividade, deixando-a em um local de onde possa ser observada.</p>
                            <p><strong>Resposta:</strong> Brincar sozinha = permanecer tocando ou manipulando brinquedos ou objetos sem destruí-los, sem choramingar ou reclamar pela presença de um adulto, por 10 minutos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca sozinha por 10 minutos.</li>
                              <li><strong>AV:</strong> A criança brinca por menos tempo ou com interrupções ocasionais.</li>
                              <li><strong>Não:</strong> Não brinca sozinha.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 15 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S15 - Procura contato visual, com frequência, quando alguém lhe dá atenção por dois a três minutos.</div>
                          <div class="checkbox-interpretation">A criança deve procurar olhar para os olhos do adulto pelo menos 5 vezes quando alguém lhe der atenção por 2 a 3 minutos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item15" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item15" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item15" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item15"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item15">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ao trocar, alimentar, dar banho, etc., na criança, colocar o rosto desta em frente ao rosto do adulto, enquanto este sorri, fala e/ou faz caretas à criança.</p>
                            <p><strong>Resposta:</strong> Procurar contato visual = procurar olhar para os olhos do adulto quando este lhe der “atenção” por 2 a 3 minutos. Deve procurar contato visual pelo menos 5 vezes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Procura contato visual por 2 a 3 minutos em pelo menos 5 vezes quando alguém lhe dá atenção.</li>
                              <li><strong>AV:</strong> A criança pode procurar contato visual de forma esporádica ou com menos frequência.</li>
                              <li><strong>Não:</strong> Não procura contato visual.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 16 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S16 - Brinca sozinho sem reclamar por 15 a 20 minutos, próximo de um adulto executando uma atividade.</div>
                          <div class="checkbox-interpretation">A criança deve brincar sozinha sem reclamar por 15 a 20 minutos, próximo de um adulto que está executando uma atividade.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item16" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item16" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item16" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item16"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item16">
                            <p><strong>Recursos Materiais:</strong> Bichinhos de borracha, chocalhos e objetos da casa, como por exemplo, utensílios de cozinha (panelas, pratos inquebráveis, colheres, xícaras, etc.) e/ou rádio ou aparelho de som ligado.</p>
                            <p><strong>Condição:</strong> Colocar os objetos próximos à criança e realizar uma atividade por 15 a 20 minutos próximo desta. A criança não precisa estar necessariamente dentro do campo visual do adulto, mas este deverá ir ver a criança ocasionalmente.</p>
                            <p><strong>Resposta:</strong> Brincar sozinho sem reclamar por 15 a 20 minutos, próximo de um adulto executando uma atividade.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca sozinho sem reclamar por 15 a 20 minutos, próximo de um adulto executando uma atividade.</li>
                              <li><strong>AV:</strong> A criança brinca sozinho por menos tempo ou com reclamações ocasionais.</li>
                              <li><strong>Não:</strong> Não brinca sozinho.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 17 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S17 - Vocaliza para obter atenção.</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar para obter atenção pelo menos 3 vezes na última semana, acompanhada por sinais de estar molhada ou ter fome.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item17" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item17" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item17" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item17"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item17">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com familiar.</p>
                            <p><strong>Resposta:</strong> Vocalizar para obter atenção = apresentar qualquer tipo de vocalização, acompanhada por evidência de estar molhada ou ter fome (exemplo: próximo às refeições). Deve ter vocalizado para obter atenção pelo menos 3 vezes na última semana.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Na última semana, vocalizou 3 vezes para obter atenção.</li>
                              <li><strong>AV:</strong> Vocalizou 2 vezes para obter atenção na última semana.</li>
                              <li><strong>Não:</strong> Não vocaliza para obter atenção.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 18 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S18 - Imita o adulto em brincadeira de “esconde-esconde”.</div>
                          <div class="checkbox-interpretation">A criança deve imitar o adulto em brincadeira de “esconde-esconde” dentro de 10 segundos após o modelo do adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item18" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item18" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item18" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item18"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item18">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar modelo, vedando os olhos com as mãos ou escondendo-se atrás de um móvel e “aparecer” e “desaparecer” para a criança. Esconder o rosto atrás de uma revista, manta, fralda. Dizer “achou” etc.</p>
                            <p><strong>Resposta:</strong> Imitar o adulto em brincadeira de “esconde-esconde”, dentro de 10 segundos após o modelo do adulto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Imitar o adulto em brincadeira de “esconde-esconde” dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança pode demorar mais de 10 segundos ou imitar parcialmente a brincadeira.</li>
                              <li><strong>Não:</strong> Não imita o adulto em brincadeira de “esconde-esconde”.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 19 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S19 - Bate palmas, imitando o adulto.</div>
                          <div class="checkbox-interpretation">A criança deve bater palmas dentro de 10 segundos após o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item19" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item19" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item19" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item19"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item19">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar modelo.</p>
                            <p><strong>Resposta:</strong> Bater palmas dentro de 10 segundos após o modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Bate palmas dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança bate palmas de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não bate palmas, imitando o adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 20 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S20 - Acena com a mão, dizendo adeus, imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve acenar com a mão, dizendo adeus, imitando o adulto dentro de 10 segundos após o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item20" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item20" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item20" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item20"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item20">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar modelo.</p>
                            <p><strong>Resposta:</strong> Acenar com a mão, dizendo adeus, imitando o adulto dentro de 10 segundos após o modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Acena com a mão, dizendo adeus, imitando o adulto dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança pode acenar de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não acena com a mão, dizendo adeus.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 21 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S21 - Ergue os braços para expressar “grande”, imitando o adulto.</div>
                          <div class="checkbox-interpretation">A criança deve erguer os braços e expressar “grande” dentro de 10 segundos após o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item21" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item21" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item21" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item21"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item21">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Erguer os braços verticalmente e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Erguer os braços e expressar “grande” dentro de 10 segundos após o modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Ergue os braços para expressar “grande” dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança pode erguer os braços de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não ergue os braços para expressar “grande”.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 22 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S22 - Oferece um brinquedo, objeto ou pedaço de comida a um adulto, mas nem sempre o entrega.</div>
                          <div class="checkbox-interpretation">A criança deve oferecer e entregar brinquedo/objeto ou alimento ao adulto pelo menos 1 vez em 4 tentativas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item22" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item22" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item22" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item22"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item22">
                            <p><strong>Recursos Materiais:</strong> Objeto, comida ou brinquedos.</p>
                            <p><strong>Condição:</strong> Pedir à criança “me dá (objeto)” quando estiver segurando o objeto.</p>
                            <p><strong>Resposta:</strong> Oferecer brinquedo, objeto ou pedaço de comida a um adulto = estender as mãos com o brinquedo/objeto ou alimento em direção ao adulto. Deve oferecer e entregar pelo menos 1 vez em 4 tentativas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Oferece brinquedo/objeto ou alimento ao adulto e entrega ao menos 1 vez em 4 tentativas.</li>
                              <li><strong>AV:</strong> A criança pode oferecer de forma inconsistente ou entregar menos de 1 vez em 4 tentativas.</li>
                              <li><strong>Não:</strong> Não oferece brinquedo/objeto ou alimento ao adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 23 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S23 - Abraça, acaricia ou beija familiares.</div>
                          <div class="checkbox-interpretation">A criança deve abraçar, acariciar ou beijar pelo menos 2 pessoas diferentes da família.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item23" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item23" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item23" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item23"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item23">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dizer à criança “dá um beijo na mamãe”, “faz carinho no papai” etc., dando modelo se necessário.</p>
                            <p><strong>Resposta:</strong> Abraçar/acariciar ou beijar/encostar o rosto e mandar beijos com as mãos para pessoas familiares. Deve abraçar, acariciar ou beijar pelo menos 2 pessoas diferentes da família.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Abraça/acaricia ou beija pelo menos 2 pessoas diferentes da família.</li>
                              <li><strong>AV:</strong> A criança pode abraçar ou beijar menos de 2 pessoas ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não abraça/acaricia ou beija familiares.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 24 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S24 - Responde ao próprio nome, olhando ou estendendo os braços para ser pego.</div>
                          <div class="checkbox-interpretation">A criança deve responder ao próprio nome, olhando em direção ao adulto ou estendendo os braços para ser pego, dentro de 20 segundos após a emissão de seu nome.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item24" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item24" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item24" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item24"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item24">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Chamar a criança pelo nome.</p>
                            <p><strong>Resposta:</strong> Responder ao próprio nome, olhando em direção ao adulto ou estendendo os braços para ser pego, dentro de 20 segundos após a emissão de seu nome.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Responde quando chamada pelo nome, olhando em direção ao adulto ou estendendo os braços para ser pego, dentro de 20 segundos após ser chamada.</li>
                              <li><strong>AV:</strong> A criança pode responder de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não responde quando chamada pelo nome.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 25 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S25 - Aperta ou sacode um brinquedo para produzir sons, em imitação.</div>
                          <div class="checkbox-interpretation">A criança deve apertar ou sacudir um brinquedo, produzindo sons, dentro de 10 segundos após o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item25" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item25" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item25" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item25"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item25">
                            <p><strong>Recursos Materiais:</strong> Chocalho, bichinhos de borracha, caixinhas com arroz, feijão ou pedrinhas.</p>
                            <p><strong>Condição:</strong> Dar modelo.</p>
                            <p><strong>Resposta:</strong> Apertar ou sacudir um brinquedo, produzindo sons, dentro de 10 segundos após o modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Aperta ou sacode um brinquedo para produzir sons, dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança pode apertar ou sacudir o brinquedo de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não aperta ou sacode um brinquedo para produzir sons.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 26 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S26 - Manipula brinquedo ou objeto.</div>
                          <div class="checkbox-interpretation">A criança deve manipular brinquedos ou objetos, como mover, balançar, rolar ou bater, conforme instruções.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item26" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item26" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item26" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item26"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item26">
                            <p><strong>Recursos Materiais:</strong> Carrinho, chocalho, tambor, bolas, blocos, botões que disparam uma buzina, contas, etc.</p>
                            <p><strong>Condição:</strong> Se necessário, dar modelo e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Manipular brinquedo ou objeto = mover (exemplo: mover um carrinho para frente e para trás sob uma superfície), balançar (chocalho, colheres, etc.), rolar (bola), bater com as mãos ou com outro objeto (exemplo: tambores) ou apertar botões que acionam buzina, luz ou som em um brinquedo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Manipula brinquedos ou objetos conforme instruído.</li>
                              <li><strong>AV:</strong> A criança pode manipular os objetos de forma limitada ou inconsistência.</li>
                              <li><strong>Não:</strong> Não manipula brinquedo ou objeto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 27 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S27 - Estende um brinquedo ou objeto a um adulto e o entrega.</div>
                          <div class="checkbox-interpretation">A criança deve estender um brinquedo ou objeto para o adulto e entregá-lo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item27" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item27" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item27" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item27"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item27">
                            <p><strong>Recursos Materiais:</strong> Brinquedos e objetos diversos.</p>
                            <p><strong>Condição:</strong> Apresentar vários brinquedos e objetos para a criança e, quando esta estiver segurando um deles, solicitar “me dá” ou colocar um objeto em sua mão e depois solicitá-lo.</p>
                            <p><strong>Resposta:</strong> Estender um brinquedo ou objeto para o adulto e entregá-lo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Estende e entrega o brinquedo ou objeto para o adulto.</li>
                              <li><strong>AV:</strong> A criança pode estender ou entregar o objeto de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não estende o brinquedo ou objeto para o adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 28 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S28 - Imita movimentos de outra criança ao brincar.</div>
                          <div class="checkbox-interpretation">A criança deve imitar movimentos de outra criança ao brincar, dentro de 10 segundos após o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social0_1_item28" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item28" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social0_1_item28" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social0_1_item28"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social0_1_item28">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> A criança deverá ter aproximadamente a mesma idade da outra. Assegurar-se que existam vários objetos iguais (exemplos: blocos, carros, contas, caixas).</p>
                            <p><strong>Resposta:</strong> Imitar movimentos de outra criança ao brincar, dentro de 10 segundos após ter sido dado o modelo pela outra criança. Movimentos = empurrar carrinhos, construir com blocos ou derrubá-los, passar por baixo de uma cadeira, colocar uma caixa sobre a cabeça, dar “tchau”, bater palmas, colocar a mão sobre a cabeça, ou sobre os dedos dos pés, colocar a cabeça no chão como se fosse dar cambalhotas ou dar voltas, ou ainda pegar objetos similares àqueles que a outra criança está brincando. Deve imitar pelo menos 2 movimentos diferentes de outra criança ao brincar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Imitar pelo menos 2 movimentos diferentes de outra criança ao brincar, dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança pode imitar movimentos de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não imita o adulto em brincadeira de “esconde-esconde”.</li> <!-- Nota: Critérios parecem incorretos conforme descrito anteriormente -->
                            </ul>
                          </div>
                        </div>

                    </div>

                    <!-- Faixa 1 - 2 anos - Social -->
                    <div id="social1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1 - 2 anos</h5>
                        
                        <!-- Card 29 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S29 - Imita um adulto em uma tarefa simples.</div>
                          <div class="checkbox-interpretation">A criança deve imitar um adulto em tarefas simples dentro de 10 segundos após o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item29" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item29" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item29" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item29"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item29">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Contexto natural ou criar situações que favoreçam a aplicação da tarefa.</p>
                            <p><strong>Resposta:</strong> Imitar um adulto em tarefas simples, dentro de 10 segundos após o modelo. Tarefas simples incluem: sacudir roupas, estender os lençóis na cama, segurar talheres, recolher e guardar brinquedos em uma caixa grande, enxaguar a banheira, colocar os copos plásticos e talheres na pia, varrer, tirar pó, lavar louça.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Imitar um adulto em tarefas simples dentro de 10 segundos após o modelo.</li>
                              <li><strong>AV:</strong> A criança pode imitar de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não imita um adulto em tarefas simples.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 30 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S30 - Brinca ao lado de outra criança, cada uma realizando uma tarefa diferente.</div>
                          <div class="checkbox-interpretation">A criança deve brincar (sem brigar) ao lado de outra criança, cada uma realizando uma tarefa diferente, por 15 a 20 minutos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item30" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item30" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item30" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item30"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item30">
                            <p><strong>Recursos Materiais:</strong> Blocos, caminhão, carrinho, trator, boneca, mamadeira, etc.</p>
                            <p><strong>Condição:</strong> Colocar a criança próxima a outra, com aproximadamente a mesma idade, e prover objetos em número suficiente para ambas.</p>
                            <p><strong>Resposta:</strong> Brincar (sem brigar) ao lado de outra criança, cada uma realizando uma tarefa diferente, por 15 a 20 minutos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca (sem brigar) ao lado de outra criança por 15 a 20 minutos.</li>
                              <li><strong>AV:</strong> A criança pode brigar ocasionalmente ou não manter a atividade por todo o período.</li>
                              <li><strong>Não:</strong> Não brinca ao lado de outra criança.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 31 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S31 - Toma parte em uma brincadeira com outra criança, por dois a cinco minutos.</div>
                          <div class="checkbox-interpretation">A criança deve tomar parte de uma brincadeira com outra criança, compartilhando o mesmo objeto, por 2 a 5 minutos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item31" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item31" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item31" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item31"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item31">
                            <p><strong>Recursos Materiais:</strong> Bola, carrinho, caminhão ou brinquedo de corda.</p>
                            <p><strong>Condição:</strong> Colocar a criança a aproximadamente um metro de outra criança da mesma idade e pedir para que empurrem um carrinho ou façam um brinquedo de corda ir de uma criança para outra.</p>
                            <p><strong>Resposta:</strong> Tomar parte de uma brincadeira com outra criança = permanecer 2 a 5 minutos compartilhando o mesmo objeto com outra criança.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Toma parte da brincadeira e permanece compartilhando o mesmo objeto por 2 a 5 minutos.</li>
                              <li><strong>AV:</strong> A criança pode participar de forma limitada ou com interrupções.</li>
                              <li><strong>Não:</strong> Não toma parte de uma brincadeira com outra criança.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 32 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S32 - Aceita a ausência dos pais, continuando suas atividades, embora possa reclamar momentaneamente.</div>
                          <div class="checkbox-interpretation">A criança deve permanecer por 1 hora na ausência dos pais, realizando atividades sob a supervisão de um adulto, mesmo que reclame momentaneamente.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item32" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item32" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item32" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item32"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item32">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Um familiar deve deixar a criança em um cômodo da casa com outro adulto, engajá-la em uma atividade com brinquedos e retirar-se.</p>
                            <p><strong>Resposta:</strong> Aceitar = permanecer por uma hora na ausência dos pais, realizando atividades sob a supervisão de um adulto familiar, embora possa reclamar momentaneamente (ou seja, chorar quando os pais saem).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Permanece por 1 hora na ausência dos pais, realizando atividades sob a supervisão de um adulto.</li>
                              <li><strong>AV:</strong> A criança pode não conseguir permanecer por todo o período ou mostrar sinais de ansiedade excessiva.</li>
                              <li><strong>Não:</strong> Não aceita a ausência dos pais.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 33 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S33 - Explora ativamente seu meio ambiente.</div>
                          <div class="checkbox-interpretation">A criança deve explorar ativamente seu meio ambiente, apresentando comportamentos como visitar locais, pegar objetos, ou tentar abrir pacotes, pelo menos uma vez na última semana.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item33" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item33" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item33" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item33"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item33">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Explorar seu meio ambiente = 
                              <ol>
                                <li>Ao visitar a casa de alguém, ir por conta própria até o banheiro e/ou abrir portas de quarto e/ou andar por corredores, etc.;</li>
                                <li>Ao passear, soltar a mão do adulto e olhar para objetos não familiares (ex.: pegar pedrinha no chão);</li>
                                <li>Tentar abrir pacotes fechados.</li>
                              </ol>
                              Ter apresentado a), b) ou c) pelo menos uma vez na última semana.
                            </p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Explora ativamente seu meio ambiente, apresentando pelo menos uma das ações descritas na última semana.</li>
                              <li><strong>AV:</strong> A criança pode explorar de forma limitada ou ocasional.</li>
                              <li><strong>Não:</strong> Não explora seu meio ambiente.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 34 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S34 - Toma parte de uma atividade manipulativa com outra pessoa (por exemplo: puxa barbante, vira uma maçaneta).</div>
                          <div class="checkbox-interpretation">A criança deve participar de uma atividade manipulativa com outra pessoa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item34" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item34" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item34" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item34"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item34">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Propiciar à criança uma atividade, como colocá-la atrás de uma porta, fechar a porta e abri-la virando o trinco. Ao achar a criança, dar risadas e, em seguida, a criança deverá fazer o mesmo.</p>
                            <p><strong>Resposta:</strong> Participar de uma atividade manipulativa com outra pessoa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Toma parte de uma atividade manipulativa com outra pessoa.</li>
                              <li><strong>AV:</strong> A criança pode participar de forma limitada ou com interrupções.</li>
                              <li><strong>Não:</strong> Não toma parte de uma atividade manipulativa.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 35 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S35 - Abraça e carrega uma boneca ou brinquedo macio.</div>
                          <div class="checkbox-interpretation">A criança deve dar pelo menos cinco passos, abraçando e carregando uma boneca ou carrinho ou brinquedo macio.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item35" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item35" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item35" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item35"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item35">
                            <p><strong>Recursos Materiais:</strong> Bonecas, almofadas ou pelúcias.</p>
                            <p><strong>Condição:</strong> Dar modelo e solicitar a resposta ou pedir à criança que “abrace a boneca/brinquedo e leve-a para dormir”.</p>
                            <p><strong>Resposta:</strong> Dar pelo menos cinco passos, abraçando e carregando uma boneca ou carrinho ou brinquedo macio.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Abraça e carrega um brinquedo dando pelo menos 5 passos.</li>
                              <li><strong>AV:</strong> A criança pode abraçar ou carregar o brinquedo por menos passos ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não abraça e carrega um brinquedo.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 36 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S36 - Repete ações que produzem risos e atenção.</div>
                          <div class="checkbox-interpretation">A criança deve repetir ações (motoras e/ou vocais) de modo proposital para provocar riso ou chamar atenção, em pelo menos 2 ocasiões diferentes.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item36" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item36" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item36" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item36"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item36">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Realizar brincadeiras que a criança gosta.</p>
                            <p><strong>Resposta:</strong> Repetir ações (motoras e/ou vocais) de modo proposital a provocar riso ou atenção da audiência. Deve ter repetido pelo menos em duas ocasiões diferentes ações que produzem riso ou atenção.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Repete ações de modo proposital para provocar riso ou chamar atenção, em pelo menos 2 ocasiões diferentes.</li>
                              <li><strong>AV:</strong> A criança pode repetir ações de forma limitada ou ocasional.</li>
                              <li><strong>Não:</strong> Não repete ações de modo proposital.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 37 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S37 - Dá um livro para que um adulto leia ou para que ambos o compartilhem.</div>
                          <div class="checkbox-interpretation">A criança deve dar um livro para um adulto e sentar-se ao lado deste por no mínimo 2 minutos, enquanto lê e ambos manipulam e folheiam o livro.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item37" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item37" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item37" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item37"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item37">
                            <p><strong>Recursos Materiais:</strong> Livros.</p>
                            <p><strong>Condição:</strong> Se necessário, solicitar à criança “me traga o livro”, “vamos contar histórias com o livro”, “vamos ver o livro” etc.</p>
                            <p><strong>Resposta:</strong> Dar um livro para um adulto e sentar-se ao lado deste por no mínimo 2 minutos, enquanto lê e ambos manipulam e folheiam o livro.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Dá um livro para que um adulto leia e senta-se ao lado deste por 2 minutos.</li>
                              <li><strong>AV:</strong> A criança pode dar o livro de forma inconsistente ou não permanecer pelo período completo.</li>
                              <li><strong>Não:</strong> Não dá um livro para que um adulto leia.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 38 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S38 - Puxa alguma pessoa para mostrar-lhe alguma ação ou objeto.</div>
                          <div class="checkbox-interpretation">A criança deve puxar uma pessoa e, em seguida, mostrar-lhe alguma ação ou objeto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item38" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item38" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item38" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item38"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item38">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se necessário, pedir à criança que vá buscar uma pessoa (que está em outro local da casa) para mostrar-lhe algo (por exemplo: uma nova flor no jardim, o caminhão de lixo, um cachorro, um gato, um aquário ou brinquedo novo etc.), ou desenho, uma atividade qualquer.</p>
                            <p><strong>Resposta:</strong> Puxar uma pessoa e, em seguida, mostrar-lhe alguma ação ou objeto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Puxa uma pessoa e mostra-lhe uma ação ou objeto.</li>
                              <li><strong>AV:</strong> A criança pode puxar a pessoa de forma inconsistente ou não mostrar o objeto adequadamente.</li>
                              <li><strong>Não:</strong> Não puxa uma pessoa para mostrar-lhe uma ação ou objeto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 39 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S39 - Retira a mão ou diz “não” quando está próximo de um objeto não permitido e alguém o lembra disso.</div>
                          <div class="checkbox-interpretation">A criança deve retirar a mão ou dizer “não” quando está próxima de um objeto não permitido, como objetos quebráveis, pontiagudos ou perigosos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item39" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item39" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item39" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item39"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item39">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural.</p>
                            <p><strong>Resposta:</strong> Retirar a mão ou dizer “não” quando está próxima de um objeto não permitido (objetos que quebram, pontiagudos como tesoura, ou perigosos como panela quente), quando lembrado por alguém.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Retira a mão ou diz “não” quando está próxima de um objeto não permitido.</li>
                              <li><strong>AV:</strong> A criança pode hesitar ou não responder consistentemente.</li>
                              <li><strong>Não:</strong> Não retira a mão ou diz “não” quando está próxima de um objeto não permitido.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 40 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S40 - Quando colocado em sua cadeira ou trocador, espera de 2 a 5 minutos para ser atendido (alimentado ou trocado).</div>
                          <div class="checkbox-interpretation">A criança deve esperar de 2 a 5 minutos para ser atendida (alimentada ou trocada) quando colocada em sua cadeira ou trocador.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item40" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item40" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item40" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item40"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item40">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural.</p>
                            <p><strong>Resposta:</strong> Quando colocado em sua cadeira ou trocador, espera de 2 a 5 minutos para ser atendido (alimentado ou trocado).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Espera de 2 a 5 minutos para ser atendido.</li>
                              <li><strong>AV:</strong> A criança pode esperar por menos tempo ou reclamar ocasionalmente.</li>
                              <li><strong>Não:</strong> Não espera para ser atendido.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 41 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S41 - Brinca com duas ou três crianças de sua idade.</div>
                          <div class="checkbox-interpretation">A criança deve brincar com duas ou três crianças de sua idade por 20 minutos sem brigar ou chorar, sem supervisão constante de um adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item41" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item41" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item41" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item41"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item41">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Propiciar atividades como empurrar e puxar brinquedos, jogar bola, olhar livros ilustrados, pintar com lápis de cor ou pincel, brincar na areia, piscina ou tanquinho.</p>
                            <p><strong>Resposta:</strong> Brincar com duas ou três crianças de sua idade por 20 minutos sem brigar ou chorar, sem supervisão constante de um adulto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca com 2 ou 3 crianças da sua idade por 20 minutos sem brigar ou chorar, sem supervisão constante de um adulto.</li>
                              <li><strong>AV:</strong> A criança pode brigar ocasionalmente ou não manter a atividade por todo o período.</li>
                              <li><strong>Não:</strong> Não brinca com 2 ou 3 crianças da sua idade.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 42 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S42 - Compartilhar um objeto ou alimento com outra criança, quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve dar um objeto ou alimento a uma outra criança quando solicitada, embora possa protestar momentaneamente.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item42" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item42" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item42" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item42"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item42">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar à criança uma bolacha, por exemplo, e dizer “dê um pedaço de bolacha para [nome da criança] e coma o resto”.</p>
                            <p><strong>Resposta:</strong> Compartilhar = dar um objeto ou alimento (ou parte deste) a uma outra criança quando solicitada, embora possa protestar momentaneamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Compartilha objeto ou alimento com outra criança quando solicitada.</li>
                              <li><strong>AV:</strong> A criança pode compartilhar de forma inconsistente ou com protestos ocasionais.</li>
                              <li><strong>Não:</strong> Não compartilha objeto ou alimento com outra criança quando solicitado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 43 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S43 - Cumprimenta colegas ou adultos familiares, quando lembrado.</div>
                          <div class="checkbox-interpretation">A criança deve cumprimentar pelo menos dois colegas ou adultos familiares quando lembrada.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social1_2_item43" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item43" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social1_2_item43" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social1_2_item43"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social1_2_item43">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural.</p>
                            <p><strong>Resposta:</strong> Cumprimentar colegas ou adultos familiares = dizer “Oi” ou “Como vai”, e/ou abraçar ou beijar, quando lembrado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Cumprimenta pelo menos 2 colegas ou 2 adultos familiares quando lembrado.</li>
                              <li><strong>AV:</strong> A criança pode cumprimentar menos de 2 pessoas ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não cumprimenta colegas ou adultos familiares.</li>
                            </ul>
                          </div>
                        </div>

                    </div>

                    <!-- Faixa 2 - 3 anos - Social -->
                    <div id="social2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2 - 3 anos</h5>
                        
                        <!-- Card 44 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S44 - Obedece a ordens dos pais pelo menos 50% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve obedecer a ordens simples dos pais pelo menos 50% das vezes, realizando a ação solicitada imediatamente após a ordem.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item44" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item44" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item44" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item44"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item44">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar. O familiar deverá apresentar à criança ordens simples (envolvendo uma ação de cada vez) e aguardar a resposta da criança sem repetir a ordem. Exemplos de ordens: “vá dormir”, “apague a luz”, “feche a gaveta”, “desligue a TV”, “pegue o livro”, “tire o sapato”, “vem cá”.</p>
                            <p><strong>Resposta:</strong> Obedecer = realizar a ação contida na ordem dada por um dos pais, imediatamente após a ordem e sem necessidade de o pai repeti-la.</p>
                            <p><strong>Critério:</strong> 50% das oportunidades = no dia anterior, a criança deve ter obedecido pelo menos 3 de 6 ordens dadas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Obedece pelo menos 50% das ordens dadas pelos pais.</li>
                              <li><strong>AV:</strong> Obedece menos de 50% das ordens ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não obedece às ordens simples dos pais.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 45 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S45 - Busca ou leva um objeto ou vai buscar uma pessoa em outra sala quando lhe dão instruções.</div>
                          <div class="checkbox-interpretation">A criança deve buscar ou levar um objeto ou ir buscar uma pessoa em outra sala quando receber instruções.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item45" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item45" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item45" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item45"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item45">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar à criança ordens do tipo “dê a revista para o papai”, “coloque isto na mesa, por favor”, “coloque isto no cesto”, “me dê o pano”, “chame seu pai” etc., assegurando-se que a criança terá que se locomover de um cômodo para outro da casa.</p>
                            <p><strong>Resposta:</strong> Busca ou leva um objeto ou vai buscar uma pessoa em outra sala quando lhe dão instruções.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Busca ou leva um objeto ou vai buscar uma pessoa em outra sala quando lhe dão instrução.</li>
                              <li><strong>AV:</strong> A criança pode buscar ou levar de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não busca ou leva um objeto ou vai buscar uma pessoa.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 46 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S46 - Presta atenção à história ou música por 5 a 10 minutos.</div>
                          <div class="checkbox-interpretation">A criança deve prestar atenção à história ou música por 5 a 10 minutos, respondendo ou acompanhando conforme esperado.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item46" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item46" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item46" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item46"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item46">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> O adulto deverá contar (e não ler) uma história, podendo utilizar-se ou não de ilustrações. Em relação à música, o adulto deverá cantá-la ou apresentar o áudio/gravação de músicas infantis.</p>
                            <p><strong>Resposta:</strong> 
                              <strong>Prestar atenção à história:</strong> Responder a uma questão simples de uma história contada por 5 minutos (exemplo: "Como era mesmo o nome do menino?");
                              <br>
                              <strong>Prestar atenção à música:</strong> Acompanhar uma música infantil por no mínimo 5 minutos, dançando, cantarolando, pulando, balançando braços ou pés, etc.
                            </p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Presta atenção a histórias ou músicas por 5 a 10 minutos.</li>
                              <li><strong>AV:</strong> A criança pode prestar atenção por menos tempo ou com interrupções ocasionais.</li>
                              <li><strong>Não:</strong> Não presta atenção a histórias ou músicas.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 47 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S47 - Diz “por favor” e “obrigado” quando lembrado.</div>
                          <div class="checkbox-interpretation">A criança deve dizer “por favor” e “obrigado” quando lembrada, em situações apropriadas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item47" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item47" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item47" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item47"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item47">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Propiciar uma situação onde a criança tenha que pedir ou receber um brinquedo/alimento/objeto, lembrá-la de dizer “por favor” ou “obrigado” e observar a resposta da criança.</p>
                            <p><strong>Resposta:</strong> Dizer “por favor” e “obrigado” quando lembrada.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Diz “por favor” e “obrigado” quando lembrada.</li>
                              <li><strong>AV:</strong> A criança pode dizer “por favor” ou “obrigado” de forma inconsistente ou com esquecimentos ocasionais.</li>
                              <li><strong>Não:</strong> Não diz “por favor” e “obrigado” mesmo quando lembrada.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 48 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S48 - Tenta ajudar os pais a executarem uma tarefa realizando parte da mesma.</div>
                          <div class="checkbox-interpretation">A criança deve tentar ajudar os pais a executarem uma tarefa, realizando parte da mesma.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item48" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item48" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item48" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item48"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item48">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar modelo e solicitar a resposta. Exemplos de tarefas: guardar os brinquedos, tirar o pó dos móveis, colocar seu próprio prato na pia/mesa, trocar a roupa de cama, guardar alimentos no armário, servir algo de comer ou beber a uma visita, regar plantas.</p>
                            <p><strong>Resposta:</strong> Tentar ajudar os pais a executarem uma tarefa realizando parte da mesma (por exemplo: segurando uma pá de lixo).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Tenta ajudar os pais a executarem uma tarefa.</li>
                              <li><strong>AV:</strong> A criança pode tentar de forma limitada ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não tenta ajudar os pais a executarem uma tarefa.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 49 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S49 - Brinca de usar roupas de adulto.</div>
                          <div class="checkbox-interpretation">A criança deve brincar de usar roupas de adulto, vestindo-se com peças de vestuário de adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item49" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item49" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item49" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item49"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item49">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se necessário, proporcionar à criança roupas usadas de pessoas da família e dizer: “Agora você vai ser a mamãe”.</p>
                            <p><strong>Resposta:</strong> Brincar de usar roupas de adulto = vestir-se com alguma peça de vestuário de adulto (sapatos de adulto, bolsa, colares, chapéu, gravata, vestido, paletó, etc.).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca de usar roupas de adulto.</li>
                              <li><strong>AV:</strong> A criança pode brincar de usar roupas de adulto de forma limitada ou esporádica.</li>
                              <li><strong>Não:</strong> Não brinca de usar roupas de adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 50 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S50 - Faz uma escolha quando indagado.</div>
                          <div class="checkbox-interpretation">A criança deve fazer uma escolha ao ser perguntada, selecionando entre duas opções apresentadas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item50" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item50" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item50" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item50"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item50">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Apresentar à criança duas opções (por exemplo: dois tipos de bebida, dois brinquedos ou dois alimentos) e perguntar: “Quer (leite ou suco)?”, “Quer (carro ou barquinho)?”.</p>
                            <p><strong>Resposta:</strong> Fazer uma escolha = pegar um dos objetos oferecidos e permanecer com tal objeto sem trocá-lo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Faz uma escolha quando indagado.</li>
                              <li><strong>AV:</strong> A criança pode hesitar ou escolher de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não faz uma escolha quando indagado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 51 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S51 - Demonstra entender sentimentos, expressando amor, tristeza, raiva, alegria, etc.</div>
                          <div class="checkbox-interpretation">A criança deve demonstrar entender sentimentos, utilizando palavras referentes a sentimentos diferentes.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social2_3_item51" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item51" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social2_3_item51" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social2_3_item51"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social2_3_item51">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar palavras que expressem sentimentos em suas verbalizações habituais, mostrar a ela figuras que demonstram nítidas expressões faciais (exemplos: um menino chorando) e perguntar: “Como o menino está se sentindo?”.</p>
                            <p><strong>Resposta:</strong> Demonstrar entender sentimentos, utilizando palavras referentes a sentimentos tais como: “amo/gosto”, “triste”, “bravo”, “alegre/contente”, etc.</p>
                            <p><strong>Critério:</strong> Emitir pelo menos duas palavras que expressem sentimentos diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Demonstra entender sentimentos, emitindo pelo menos 2 palavras que expressem sentimentos diferentes.</li>
                              <li><strong>AV:</strong> A criança pode emitir apenas uma palavra ou usar termos de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não demonstra entender sentimentos.</li>
                            </ul>
                          </div>
                        </div>
                        
                                                
                    </div>
                        
                    <!-- Faixa 3 - 4 anos - Social -->
                    <div id="social3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3 - 4 anos</h5>
                                                
                        <!-- Card 52 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S52 - Canta e dança ao ouvir música.</div>
                          <div class="checkbox-interpretation">A criança deve cantar e dançar ao ouvir música, emitindo sons rítmicos e movendo o corpo, a cabeça ou os braços ritmicamente.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item52" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item52" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item52" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item52"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item52">
                            <p><strong>Recursos Materiais:</strong> Músicas da preferência da criança.</p>
                            <p><strong>Condição:</strong> Ambiente natural, tocando músicas que a criança gosta.</p>
                            <p><strong>Resposta:</strong> Cantar e dançar ao ouvir música = emitir sons rítmicos e mover o corpo, a cabeça ou os braços ritmicamente ao “ouvir música”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Canta e dança ao ouvir música.</li>
                              <li><strong>AV:</strong> Canta ou dança de forma inconsistente ou com pouca frequência.</li>
                              <li><strong>Não:</strong> Não canta e dança ao ouvir música.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 53 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S53 - Segue regras de um jogo imitando ações de outras crianças.</div>
                          <div class="checkbox-interpretation">A criança deve seguir as regras de um jogo, imitando ações de outras crianças durante a brincadeira.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item53" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item53" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item53" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item53"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item53">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Propiciar às crianças brincadeiras de “roda”, “seguir o líder”, “lenço atrás” ou brincadeiras onde cada um faz uma ação e o outro imita, como: colocar areia em caminhões, montar um brinquedo de encaixe, subir em “trepa-trepa”, etc.</p>
                            <p><strong>Resposta:</strong> Seguir regras = sentar em círculo, seguir instruções, imitar o líder de fazer o mesmo que o resto do grupo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Segue regras de um jogo imitando ações de outras crianças.</li>
                              <li><strong>AV:</strong> A criança pode não seguir todas as regras ou imitar de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não segue regras em um jogo imitando ações de outras crianças.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 54 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S54 - Cumprimenta pessoas familiares sem ser lembrado.</div>
                          <div class="checkbox-interpretation">A criança deve cumprimentar pelo menos duas pessoas familiares em situações diferentes sem ser lembrada.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item54" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item54" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item54" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item54"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item54">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se a criança não cumprimentar pessoas familiares em suas atividades rotineiras, propiciar uma situação de brincadeira onde uma pessoa venha visitá-la e observar se a criança cumprimenta sem ser lembrada.</p>
                            <p><strong>Resposta:</strong> Cumprimentar pessoas familiares, sem ser lembrado, em pelo menos duas situações diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Cumprimenta pessoas familiares sem ser lembrada em pelo menos duas situações diferentes.</li>
                              <li><strong>AV:</strong> Cumprimenta menos de duas pessoas ou em menos situações.</li>
                              <li><strong>Não:</strong> Não cumprimenta pessoas familiares sem ser lembrada.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 55 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S55 - Segue regras em jogos de grupos dirigidos por adultos.</div>
                          <div class="checkbox-interpretation">A criança deve seguir as regras de jogos de grupo dirigidos por adultos, sem violar as regras, brigar ou desistir antes do término da brincadeira.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item55" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item55" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item55" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item55"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item55">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Participar de jogos diferentes dirigidos por um adulto, como pique, lenço atrás, esconde-esconde, brincadeira das cadeiras (com música).</p>
                            <p><strong>Resposta:</strong> Seguir regras em jogos de grupo dirigidos por adultos = participar de jogos sem violar suas regras, brigar ou desistir da brincadeira antes de terminar.</p>
                            <p><strong>Critério:</strong> Participar de pelo menos dois jogos diferentes dirigidos por um adulto sem violar as regras, brigar ou desistir antes do término.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Segue regras em jogos de grupos dirigidos por um adulto.</li>
                              <li><strong>AV:</strong> Pode não seguir todas as regras ou apresentar comportamentos conflitantes ocasionalmente.</li>
                              <li><strong>Não:</strong> Não segue regras em jogos dirigidos por um adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 56 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S56 - Pede permissão para brincar com um brinquedo que está sendo usado por outra criança.</div>
                          <div class="checkbox-interpretation">A criança deve pedir permissão para brincar com um brinquedo que está sendo usado por outra criança, utilizando expressões como “Por favor, me dá o [brinquedo]”, “Posso brincar com o [brinquedo]?”, “Me empresta o [brinquedo]?”.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item56" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item56" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item56" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item56"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item56">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se a criança não estiver apresentando tal comportamento em suas atividades de interação, apresentar um brinquedo de outra criança presente na situação e incentivar a criança a pedir permissão para brincar com o brinquedo.</p>
                            <p><strong>Resposta:</strong> Pedir permissão para usar um brinquedo que está sendo usado por outra criança = utilizar expressões como “Por favor, me dá o [brinquedo]”, “Posso brincar com o [brinquedo]?”, “Me empresta o [brinquedo]?”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Pede permissão para brincar com um brinquedo que está sendo usado por outra criança.</li>
                              <li><strong>AV:</strong> Pede permissão de forma inconsistente ou em poucas ocasiões.</li>
                              <li><strong>Não:</strong> Não pede permissão para brincar com um brinquedo que está sendo usado por outra criança.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 57 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S57 - Diz “por favor” ou “obrigado” sem ser lembrado 50% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve dizer “por favor” ou “obrigado” sem ser lembrada em pelo menos 50% das oportunidades.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item57" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item57" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item57" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item57"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item57">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com familiar.</p>
                            <p><strong>Resposta:</strong> No dia anterior, ter dito “por favor” ou “obrigado” sem ser lembrado em pelo menos três de seis oportunidades.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Diz “por favor” ou “obrigado” sem ser lembrado em pelo menos 50% das oportunidades.</li>
                              <li><strong>AV:</strong> Pode dizer apenas uma das expressões ou em menos de 50% das oportunidades.</li>
                              <li><strong>Não:</strong> Não diz “por favor” ou “obrigado” sem ser lembrado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 58 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S58 - Atende o telefone (fixo ou móvel), chamando um adulto ou falando com uma pessoa familiar.</div>
                          <div class="checkbox-interpretation">A criança deve atender o telefone, chamar um adulto ou falar com uma pessoa familiar, embora não seja capaz de transmitir recados para outros.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item58" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item58" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item58" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item58"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item58">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Anular este item caso a família não possua telefone.</p>
                            <p><strong>Resposta:</strong> Atender o telefone, chamar o adulto solicitado no telefone ou falar com uma pessoa familiar, embora não seja capaz de transmitir recados para outros.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Atende o telefone, chamando um adulto ou falando com uma pessoa familiar.</li>
                              <li><strong>AV:</strong> Pode atender de forma inconsistente ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não atende o telefone.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 59 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S59 - Espera a sua vez.</div>
                          <div class="checkbox-interpretation">A criança deve esperar a sua vez em atividades como ser servido à mesa, jogos (vídeo game) ou brincadeiras (balanço, gangorra, jogar bola, pular corda, dominó infantil, mico preto etc.) que envolvam três a quatro crianças.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item59" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item59" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item59" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item59"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item59">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural de brincadeiras.</p>
                            <p><strong>Resposta:</strong> Esperar sua vez = deixar que outra criança participe primeiro da atividade, sem reclamar ou dizer constantemente “sou eu”, “agora eu” ao ser servido à mesa ou em jogos/brincadeiras que envolvam três a quatro crianças.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Espera a sua vez.</li>
                              <li><strong>AV:</strong> Pode reclamar ocasionalmente ou não esperar de forma consistente.</li>
                              <li><strong>Não:</strong> Não espera a sua vez.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 60 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S60 - Segue regras em jogos dirigidos por uma criança mais velha.</div>
                          <div class="checkbox-interpretation">A criança deve seguir as regras de jogos dirigidos por uma criança mais velha, participando de pelo menos dois jogos diferentes sem violar as regras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item60" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item60" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item60" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item60"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item60">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Participar de jogos diferentes dirigidos por uma criança mais velha, como “esconde-esconde”, “dominó infantil”, “mico preto”, vídeo game, etc.</p>
                            <p><strong>Resposta:</strong> Seguir regras em jogos dirigidos por uma criança mais velha = seguir as regras de pelo menos dois jogos diferentes dirigidos por uma criança maior.</p>
                            <p><strong>Critério:</strong> Seguir as regras de pelo menos dois jogos diferentes dirigidos por uma criança mais velha.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Segue regras em jogos dirigidos por uma criança mais velha.</li>
                              <li><strong>AV:</strong> Pode não seguir todas as regras ou participar de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não segue regras em jogos dirigidos por uma criança maior.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 61 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S61 - Obedece às ordens de um adulto 75% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve obedecer às ordens de um adulto em 75% das oportunidades, realizando a ação solicitada dentro de 20 segundos após a emissão da ordem.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item61" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item61" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item61" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item61"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item61">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Observar a criança durante atividades diárias e solicitar ações simples.</p>
                            <p><strong>Resposta:</strong> Obedecer às ordens de um adulto = responder quando for chamado ou realizar a ação contida na ordem (“Marcos, vem cá”) ou deixar de fazer uma atividade quando adultos disserem “não”, dentro de 20 segundos após a emissão da ordem.</p>
                            <p><strong>Critério:</strong> 75% das vezes = obedecer a pelo menos três ou quatro ordens dadas por um adulto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Obedece às ordens dadas por um adulto em 75% das oportunidades.</li>
                              <li><strong>AV:</strong> Obedece menos de 75% das ordens ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não obedece às ordens dadas por um adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 62 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S62 - Permanece em seu próprio quintal ou jardim.</div>
                          <div class="checkbox-interpretation">A criança deve permanecer em seu próprio quintal ou jardim sem sair para a rua, mesmo com o portão destrancado.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item62" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item62" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item62" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item62"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item62">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, com o portão destrancado.</p>
                            <p><strong>Resposta:</strong> Permanecer em seu próprio quintal ou jardim sem sair para a rua.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Permanece em seu próprio quintal ou jardim, estando o portão destrancado.</li>
                              <li><strong>AV:</strong> Pode sair ocasionalmente para a rua ou não permanecer de forma consistente.</li>
                              <li><strong>Não:</strong> Não permanece em seu próprio quintal ou jardim.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 63 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S63 - Brinca perto de outras crianças, conversando com elas, enquanto trabalha em um projeto próprio (30 minutos).</div>
                          <div class="checkbox-interpretation">A criança deve brincar perto de outras crianças, conversando com elas, enquanto trabalha em um projeto próprio por 30 minutos sem brigar ou chorar e sem supervisão constante de um adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social3_4_item63" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item63" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social3_4_item63" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social3_4_item63"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social3_4_item63">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Proporcionar atividades como brincar em tanque de areia, brincar com blocos, desenhar ou pintar.</p>
                            <p><strong>Resposta:</strong> Brincar perto de outras crianças, conversando com elas, enquanto trabalha em um projeto próprio = participar de atividades próprias enquanto interage com outras crianças por 30 minutos sem brigar ou chorar, sem supervisão constante de um adulto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca perto de outras crianças, conversando com elas, enquanto trabalha em um projeto próprio por 30 minutos sem brigar ou chorar, sem supervisão constante de um adulto.</li>
                              <li><strong>AV:</strong> Pode brigar ocasionalmente ou não manter a atividade por todo o período.</li>
                              <li><strong>Não:</strong> Não brinca perto de outras crianças, conversando com elas, enquanto trabalha em um projeto próprio.</li>
                            </ul>
                          </div>
                        </div>

                    </div>

                    <!-- Faixa 4 - 5 anos - Social -->
                    <div id="social4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4 - 5 anos</h5>
                        
                        <!-- Card 64 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S64 - Pede ajuda quando está tendo dificuldades (por exemplo, para ir ao banheiro ou para conseguir algo para beber).</div>
                          <div class="checkbox-interpretation">A criança deve pedir ajuda a um adulto ou a uma criança maior quando está tendo dificuldades para realizar uma atividade, como ir ao banheiro ou conseguir algo para beber.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item64" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item64" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item64" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item64"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item64">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar. A família deverá observar se a criança pede ajuda quando enfrenta dificuldades em atividades diárias.</p>
                            <p><strong>Resposta:</strong> Pedir ajuda = solicitar a um adulto ou a uma criança maior que auxilie a realizar uma atividade quando não conseguir realizá-la sozinha (por exemplo, ir ao banheiro, conseguir algo para beber ou encontrar um objeto).</p>
                            <p><strong>Critério:</strong> Na última semana, ter pedido ajuda quando teve dificuldade, pelo menos uma vez.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Pede ajuda quando está tendo dificuldades.</li>
                              <li><strong>AV:</strong> Pede ajuda de forma inconsistente ou em menos de 50% das oportunidades.</li>
                              <li><strong>Não:</strong> Não pede ajuda quando está tendo dificuldades.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 65 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S65 - Contribui para a conversa de adultos.</div>
                          <div class="checkbox-interpretation">A criança deve contribuir para a conversa de adultos fazendo comentários relacionados ao tema da conversa, como relatar eventos, emitir opiniões, fazer perguntas ou responder perguntas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item65" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item65" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item65" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item65"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item65">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, durante conversas entre adultos.</p>
                            <p><strong>Resposta:</strong> Contribuir para a conversa = fazer comentários relacionados ao tema da conversa, como relatar eventos, emitir opiniões, fazer perguntas ou responder perguntas.</p>
                            <p><strong>Critério:</strong> Ter contribuído para uma conversa de adulto, em pelo menos duas ocasiões diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Contribui para a conversa de adultos em pelo menos duas ocasiões.</li>
                              <li><strong>AV:</strong> Pode contribuir em menos de duas ocasiões ou de forma limitada.</li>
                              <li><strong>Não:</strong> Não contribui para a conversa de adultos.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 66 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S66 - Repete rimas, canções ou dança para os adultos.</div>
                          <div class="checkbox-interpretation">A criança deve repetir rimas, canções ou dançar para os adultos, demonstrando memorização e imitação de atividades previamente aprendidas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item66" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item66" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item66" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item66"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item66">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Pedir à criança: recite “Batatinha quando nasce” para vovó; canta “Ciranda cirandinha” para a tia ver; dance uma música favorita, etc.</p>
                            <p><strong>Resposta:</strong> Ao ser solicitado, reproduzir uma rima ou canção (anteriormente aprendidas) ou dançar em frente a pessoas conhecidas (avós, tios ou amigos da família).</p>
                            <p><strong>Critério:</strong> Repetir rimas, canções ou dançar em pelo menos duas ocasiões diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Repete rimas, canções ou dança para adultos em pelo menos duas ocasiões diferentes.</li>
                              <li><strong>AV:</strong> Pode repetir apenas uma das expressões ou em menos de duas ocasiões.</li>
                              <li><strong>Não:</strong> Não repete rimas, canções ou dança para adultos.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 67 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S67 - Faz uma tarefa sozinho por 20 a 30 minutos.</div>
                          <div class="checkbox-interpretation">A criança deve realizar uma tarefa doméstica ou projeto sozinho por 20 a 30 minutos, demonstrando autonomia e habilidades motoras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item67" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item67" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item67" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item67"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item67">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, sem supervisão constante de um adulto.</p>
                            <p><strong>Resposta:</strong> Fazer uma tarefa sozinho por 20 a 30 minutos = realizar uma tarefa doméstica ou projeto sozinho, como tirar o pó, lavar o banheiro, formar bolas com massa de bolacha e colocar na assadeira, enrolar brigadeiros e colocá-los em forminhas, varrer um cômodo, lavar verduras, lavar louças inquebráveis, usar o aspirador de pó, separar talheres em lotes, guardar brinquedos, etc.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Faz uma tarefa sozinho por 20 a 30 minutos.</li>
                              <li><strong>AV:</strong> Pode fazer a tarefa por menos tempo ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não faz uma tarefa sozinho.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 68 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S68 - Pede desculpas (sem ser lembrado) 75% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve pedir desculpas sem ser lembrada em pelo menos 75% das oportunidades, demonstrando empatia e reconhecimento de erros.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item68" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item68" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item68" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item68"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item68">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Pedir desculpas = solicitar desculpas sem ser lembrado em situações de conflito ou erro, demonstrando empatia e reconhecimento de falhas.</p>
                            <p><strong>Critério:</strong> 75% das vezes na última semana, ter pedido desculpas sem ser lembrado em pelo menos três ou quatro oportunidades.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Pede desculpas sem ser lembrado, em pelo menos 75% das oportunidades.</li>
                              <li><strong>AV:</strong> Pode pedir desculpas em menos de 75% das oportunidades ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não pede desculpas sem ser lembrado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 69 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S69 - Espera sua vez numa brincadeira que envolva de oito a nove crianças.</div>
                          <div class="checkbox-interpretation">A criança deve esperar a sua vez em brincadeiras que envolvam de oito a nove crianças, demonstrando paciência e respeito às regras do grupo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item69" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item69" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item69" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item69"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item69">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Esperar sua vez = deixar que outra criança participe primeiro da atividade, sem reclamar ou dizer constantemente “sou eu”, “agora eu” ao ser servido à mesa ou em jogos (vídeo game) ou brincadeiras (balanço, gangorra, jogar bola, pular corda, dominó infantil, mico preto etc.) que envolvam oito a nove crianças.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Espera a sua vez numa brincadeira que envolva de oito a nove crianças.</li>
                              <li><strong>AV:</strong> Pode reclamar ocasionalmente ou não esperar de forma consistente.</li>
                              <li><strong>Não:</strong> Não espera a sua vez em brincadeiras que envolvam de 8 a 9 crianças.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 70 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S70 - Brinca com duas a três crianças, por 20 minutos, em uma atividade (projeto ou jogo) que envolva cooperação.</div>
                          <div class="checkbox-interpretation">A criança deve brincar com duas a três crianças por 20 minutos em uma atividade que envolva cooperação, demonstrando habilidades de trabalho em equipe.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item70" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item70" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item70" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item70"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item70">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> O adulto deve engajar as crianças na atividade e, em seguida, supervisioná-las.</p>
                            <p><strong>Resposta:</strong> Brincar com duas a três crianças por 20 minutos em uma atividade que envolva cooperação = participar de atividades como empurrar carrossel ou virar “rodas” de parque infantil, conduzir carrinhos pela rua, construir um brinquedo de encaixe com várias peças, etc.</p>
                            <p><strong>Critério:</strong> Brincar pelo menos uma vez, com duas a três crianças, por 20 minutos, em uma atividade que envolva cooperação.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca com duas a três crianças, por 20 minutos, em uma atividade (projeto ou jogo) que envolva cooperação.</li>
                              <li><strong>AV:</strong> Pode brincar por menos tempo ou com dificuldades na cooperação.</li>
                              <li><strong>Não:</strong> Não brinca com duas a três crianças, por 20 minutos, em uma atividade que envolva cooperação.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 71 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S71 - Quando em público, apresenta um comportamento socialmente aceitável.</div>
                          <div class="checkbox-interpretation">A criança deve apresentar comportamentos socialmente aceitáveis quando está em público, evitando comportamentos inadequados como gritar, fazer birra, agredir, isolar-se, etc.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item71" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item71" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item71" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item71"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item71">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Comportamento socialmente aceitável = ausência de comportamentos inadequados como gritar, fazer birra, agredir física ou verbalmente, despir-se, colocar o dedo no nariz, rir exageradamente, apresentar comportamentos autoestimulatórios, isolar-se, etc.</p>
                            <p><strong>Critério:</strong> Na última semana, ter apresentado um comportamento socialmente aceitável em todas as vezes que saiu de casa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Quando em público, apresenta comportamentos socialmente aceitáveis em todas as vezes que saiu de casa.</li>
                              <li><strong>AV:</strong> Pode apresentar comportamentos socialmente aceitáveis na maioria das vezes, mas com algumas exceções.</li>
                              <li><strong>Não:</strong> Quando em público, apresenta comportamentos inadequados.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 72 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S72 - Pede permissão para usar objetos dos outros 75% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve pedir permissão para usar objetos de outras pessoas em pelo menos 75% das oportunidades, demonstrando respeito pelos pertences alheios.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social4_5_item72" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item72" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social4_5_item72" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social4_5_item72"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social4_5_item72">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Pedir permissão para usar objetos de outros = solicitar permissão ao invés de tomar o objeto de outra pessoa, utilizando expressões como “Por favor, me dá o [objeto]”, “Posso usar o [objeto]?”, “Me empresta o [objeto]?”.</p>
                            <p><strong>Critério:</strong> 75% das vezes na última semana, ter pedido permissão para usar objetos de outras pessoas em pelo menos três de quatro oportunidades.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Pede permissão para usar os objetos de outros 75% das vezes.</li>
                              <li><strong>AV:</strong> Pode pedir permissão em menos de 75% das vezes ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não pede permissão para usar os objetos de outros.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 5 - 6 anos - Social -->
                    <div id="social5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5 - 6 anos</h5>
                        
                        <!-- Card 73 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S73 - Manifesta seus sentimentos: raiva, felicidade, amor.</div>
                          <div class="checkbox-interpretation">A criança deve manifestar pelo menos dois sentimentos diferentes, como raiva e felicidade/amor, através de comportamentos como sorrir, abraçar, beijar, chorar, esbravejar ou enraivecer.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item73" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item73" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item73" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item73"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item73">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, observando a criança em diferentes situações sociais.</p>
                            <p><strong>Resposta:</strong> Manifesta seus sentimentos = apresentar comportamentos como sorrir, abraçar, beijar, chorar, esbravejar ou enraivecer de acordo com a situação.</p>
                            <p><strong>Critério:</strong> Manifestar pelo menos dois sentimentos diferentes: raiva e felicidade/amor.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Manifesta pelo menos dois sentimentos diferentes: raiva e felicidade/amor.</li>
                              <li><strong>AV:</strong> Manifesta apenas um sentimento ou os sentimentos de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não manifesta seus sentimentos.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 74 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S74 - Brinca com quatro a cinco crianças, em uma atividade de cooperação sem supervisão constante.</div>
                          <div class="checkbox-interpretation">A criança deve brincar com quatro a cinco crianças por pelo menos 20 minutos em uma atividade que envolva cooperação, sem supervisão constante.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item74" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item74" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item74" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item74"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item74">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Brincar com quatro a cinco crianças, em uma atividade de cooperação sem supervisão constante.</p>
                            <p><strong>Critério:</strong> Ter brincado com quatro a cinco crianças, em uma atividade de cooperação, pelo menos por 20 minutos, sem supervisão constante, na última semana.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Brinca com quatro a cinco crianças, por 20 minutos, em uma atividade que envolva cooperação.</li>
                              <li><strong>AV:</strong> Pode brincar por menos tempo ou com dificuldades na cooperação.</li>
                              <li><strong>Não:</strong> Não brinca com quatro a cinco crianças, por 20 minutos, em uma atividade que envolva cooperação.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 75 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S75 - Explica aos outros as regras do jogo ou da atividade.</div>
                          <div class="checkbox-interpretation">A criança deve explicar as regras de um jogo ou atividade para pelo menos duas pessoas familiares diferentes, demonstrando compreensão e habilidade de comunicação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item75" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item75" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item75" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item75"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item75">
                            <p><strong>Recursos Materiais:</strong> Jogos.</p>
                            <p><strong>Condição:</strong> Propiciar para a criança situações de jogos onde alguém “não sabe brincar” e a criança precisa explicar como se joga.</p>
                            <p><strong>Resposta:</strong> Explicar as regras do jogo ou atividade para pelo menos duas pessoas familiares diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Explica às pelo menos duas pessoas familiares diferentes as regras de um jogo ou atividade.</li>
                              <li><strong>AV:</strong> Explica para menos de duas pessoas ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não explica aos outros as regras do jogo ou da atividade.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 76 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S76 - Imita papéis de adultos.</div>
                          <div class="checkbox-interpretation">A criança deve imitar pelo menos dois papéis diferentes de adultos, como pai e mãe, demonstrando habilidades de dramatização e compreensão de funções adultas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item76" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item76" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item76" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item76"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item76">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, durante brincadeiras de faz de conta.</p>
                            <p><strong>Resposta:</strong> Imitar papéis de adultos = vestir-se com roupas, sapatos ou qualquer outra peça de roupa de um adulto familiar e realizar ações típicas desse adulto, como guiar o carro, dar aula, arrumar a casa, brincar de ser mamãe, papai, médico, de lojinha, etc.</p>
                            <p><strong>Critério:</strong> Ter imitado pelo menos dois papéis diferentes de adultos (pai e mãe).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Ter imitado pelo menos dois papéis de adultos (pai e mãe).</li>
                              <li><strong>AV:</strong> Pode imitar apenas um papel ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não imita papéis de adultos.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 77 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S77 - Colabora para a conversa durante as refeições.</div>
                          <div class="checkbox-interpretation">A criança deve colaborar para a conversa durante as refeições, fazendo comentários relacionados ao tema da conversa, como relatar eventos, emitir opiniões, fazer perguntas ou responder perguntas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item77" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item77" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item77" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item77"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item77">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, durante as refeições.</p>
                            <p><strong>Resposta:</strong> Colaborar para a conversa durante as refeições = fazer comentários relacionados ao tema da conversa, como relatar eventos, emitir opiniões, fazer perguntas ou responder perguntas.</p>
                            <p><strong>Critérios:</strong> Ter colaborado para a conversa em todas as refeições do dia anterior.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> No dia anterior, ter colaborado para a conversa em todas as refeições.</li>
                              <li><strong>AV:</strong> Pode colaborar em algumas refeições, mas não em todas.</li>
                              <li><strong>Não:</strong> Não colabora para a conversa durante as refeições.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 78 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S78 - Segue regras de um jogo que envolva raciocínio verbal.</div>
                          <div class="checkbox-interpretation">A criança deve seguir as regras de jogos que envolvam raciocínio verbal, como jogos de perguntas ou adivinhação, demonstrando habilidades de pensamento lógico e comunicação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item78" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item78" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item78" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item78"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item78">
                            <p><strong>Recursos Materiais:</strong> Jogos.</p>
                            <p><strong>Condição:</strong> Propiciar jogos que envolvam raciocínio verbal, como perguntas do tipo: “Estou pensando em uma coisa vermelha que é uma fruta. O que é?”, ou jogos onde a criança precisa adivinhar quem ou o que o adulto está pensando, fazendo perguntas que só podem ser respondidas com "sim" ou "não".</p>
                            <p><strong>Resposta:</strong> Seguir regras de um jogo que envolva raciocínio verbal = responder a pelo menos duas questões que envolvam raciocínio verbal, acertar o jogo “das 20 perguntas”, ou, embora sem acertar, ter feito pelo menos 10 perguntas abrangentes.</p>
                            <p><strong>Critério:</strong> a) Responder a pelo menos duas questões que envolvam raciocínio verbal; b) acertar o jogo “das 20 perguntas”, ou c) embora sem acertar o jogo, ter feito pelo menos 10 perguntas abrangentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Segue regras de um jogo que envolva raciocínio verbal seguindo os critérios estabelecidos.</li>
                              <li><strong>AV:</strong> Pode não seguir todas as regras ou atingir apenas parte dos critérios.</li>
                              <li><strong>Não:</strong> Não segue regras de um jogo que envolva raciocínio verbal.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 79 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S79 - Conforta colegas quando estes estão tristes.</div>
                          <div class="checkbox-interpretation">A criança deve confortar colegas que estão tristes, demonstrando empatia e apoio através de abraços, carícias, palavras carinhosas ou oferecendo brinquedos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item79" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item79" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item79" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item79"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item79">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Confortar colegas quando estão tristes = abraçar, acariciar, falar carinhosamente ou dar um brinquedo ao amigo(a) quando este(a) estiver chorando (por exemplo, acabou de se machucar).</p>
                            <p><strong>Critério:</strong> Ter apresentado tal comportamento em pelo menos duas situações diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Conforta colegas quando estão tristes em pelo menos duas situações diferentes.</li>
                              <li><strong>AV:</strong> Pode confortar apenas em uma situação ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não conforta colegas quando estes estão tristes.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 80 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S80 - Escolhe seus próprios amigos.</div>
                          <div class="checkbox-interpretation">A criança deve escolher e expressar com quem gostaria de participar de brincadeiras, compartilhar alimentos ou brinquedos, convidar para festas, etc., demonstrando autonomia na escolha de suas amizades.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item80" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item80" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item80" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item80"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item80">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Entrevista com o familiar.</p>
                            <p><strong>Resposta:</strong> Escolher seus próprios amigos = escolher e dizer ao interessado com quem gostaria de participar de uma brincadeira, com quem quer sair, com quem gostaria de repartir um alimento ou brinquedo, ou convidar para uma festa, etc.</p>
                            <p><strong>Critério:</strong> Ter escolhido pelo menos dois amigos diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Ter escolhido pelo menos dois amigos diferentes.</li>
                              <li><strong>AV:</strong> Pode escolher apenas um amigo ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não escolhe seus próprios amigos.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 81 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S81 - Planeja e constrói, usando ferramentas simples (por exemplo, plano inclinado, alavanca, roldana).</div>
                          <div class="checkbox-interpretation">A criança deve planejar e construir utilizando ferramentas simples, demonstrando habilidades de pensamento lógico e coordenação motora.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item81" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item81" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item81" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item81"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item81">
                            <p><strong>Recursos Materiais:</strong> Ferramentas simples: martelo, serrote, lixa, cola para madeira, pregos com cabeça grande, blocos, corda, pedaços de madeira ou de isopor.</p>
                            <p><strong>Condição:</strong> Dar instrumentos para a criança, sem executar a atividade.</p>
                            <p><strong>Resposta:</strong> Planejar e construir, usando ferramentas simples = planejar e construir utilizando ferramentas como martelo, serrote, lixa, cola para madeira, pregos com cabeça grande, blocos, corda, pedaços de madeira ou de isopor.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Segue regras de um jogo que envolva raciocínio verbal seguindo os critérios estabelecidos.</li>
                              <li><strong>AV:</strong> Pode não seguir todas as regras ou atingir apenas parte dos critérios.</li>
                              <li><strong>Não:</strong> Não segue regras de um jogo que envolva raciocínio verbal.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 82 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S82 - Estabelece metas para si próprio e executa atividades para atingi-las.</div>
                          <div class="checkbox-interpretation">A criança deve estabelecer metas para si mesma e executar atividades para atingi-las, demonstrando planejamento e persistência.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item82" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item82" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item82" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item82"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item82">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente natural, incentivando a criança a verbalizar metas e realizar atividades relacionadas.</p>
                            <p><strong>Resposta:</strong> Estabelecer metas para si próprio e executar atividades para atingi-las = verbalizar publicamente uma meta para si próprio e executar todas as atividades para atingi-las, como escovar os dentes todas as noites, tomar banho, arrumar a cama, guardar os brinquedos todos os dias, fazer lições sem ser lembrado, dar descarga todas as vezes que for ao banheiro, comer “tudo” nas refeições, etc.</p>
                            <p><strong>Critério:</strong> Ter executado todas ou grande parte das atividades para atingir pelo menos duas metas diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Estabelece metas para si próprio e executa atividades para atingi-las conforme critério.</li>
                              <li><strong>AV:</strong> Pode estabelecer metas, mas não executa todas as atividades ou atinge apenas parte das metas.</li>
                              <li><strong>Não:</strong> Não estabelece metas para si próprio.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card 83 -->
                        <div class="portage-card">
                          <div class="checkbox-title">S83 - Dramatiza trechos de histórias, desempenhando um papel ou lidando com fantoches.</div>
                          <div class="checkbox-interpretation">A criança deve dramatizar trechos de histórias, desempenhando papéis ou manipulando fantoches, demonstrando habilidades de dramatização e compreensão narrativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="social5_6_item83" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item83" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="social5_6_item83" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_social5_6_item83"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_social5_6_item83">
                            <p><strong>Recursos Materiais:</strong> Fantoches, fantasias, materiais.</p>
                            <p><strong>Condição:</strong> Propor às crianças ou a um grupo um tema, fornecer materiais como papel crepom, maquiagem, fantasia, fantoches, e dar orientações quanto à dramatização.</p>
                            <p><strong>Resposta:</strong> Dramatizar trechos de histórias, desempenhando um papel ou lidando com fantoches = participar de dramatizações utilizando fantoches ou fantasias, representando personagens e cenas de histórias conhecidas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Dramatiza trechos de histórias, desempenhando um papel ou lidando com fantoches.</li>
                              <li><strong>AV:</strong> Pode dramatizar apenas parcialmente ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não dramatiza trechos de histórias, desempenhando um papel.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>
                    
                </div>
                
            </div>
            
            <!-- Área Cognição -->
            <div id="cognicao" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Cognição</h4>
                
                <!-- Sub-abas de faixas etárias para Cognição -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#cog0_1" data-toggle="tab" role="tab" aria-controls="cog0_1" aria-selected="true">0 - 1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog1_2" data-toggle="tab" role="tab" aria-controls="cog1_2" aria-selected="false">1 - 2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog2_3" data-toggle="tab" role="tab" aria-controls="cog2_3" aria-selected="false">2 - 3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog3_4" data-toggle="tab" role="tab" aria-controls="cog3_4" aria-selected="false">3 - 4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog4_5" data-toggle="tab" role="tab" aria-controls="cog4_5" aria-selected="false">4 - 5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#cog5_6" data-toggle="tab" role="tab" aria-controls="cog5_6" aria-selected="false">5 - 6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0 - 1 ano - Cognição -->
                    <div id="cog0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0 - 1 ano</h5>
                        
                        <!-- Card C1 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C1 - Remove um pano do rosto que escurece sua visão.</div>
                          <div class="checkbox-interpretation">A criança deve remover o pano que está cobrindo seu rosto, puxando ou retirando-o com a mão para que pelo menos os olhos fiquem descobertos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item1" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item1" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item1" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item1"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item1">
                            <p><strong>Recursos Materiais:</strong> Pano.</p>
                            <p><strong>Condição:</strong> Ambiente seguro onde a criança esteja coberta com o pano.</p>
                            <p><strong>Resposta:</strong> Remover = cada tentativa diz respeito a retirar e/ou puxar com a mão o pano que lhe cobre a visão, de forma que pelo menos os olhos fiquem descobertos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Remove um pano do rosto que escurece sua visão, puxando ou retirando, de modo a descobrir ao menos os olhos.</li>
                              <li><strong>AV:</strong> Remove o pano de forma inconsistente ou parcialmente.</li>
                              <li><strong>Não:</strong> Não remove um pano do rosto que escurece sua visão.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C2 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C2 - Procura, com o olhar, um objeto que foi retirado de seu campo visual.</div>
                          <div class="checkbox-interpretation">A criança deve percorrer com os olhos o percurso do objeto e/ou virar a cabeça em direção ao local onde o objeto está escondido após ser retirado de seu campo visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item2" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item2" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item2" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item2"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item2">
                            <p><strong>Recursos Materiais:</strong> Preferivelmente chocalho ou bichinhos de borracha de cores vivas que produzem sons.</p>
                            <p><strong>Condição:</strong> Colocar a criança deitada de costas ou sentada, apoiada com almofadas, e posicionar o objeto distante 15 a 20 cm da criança.</p>
                            <p><strong>Resposta:</strong> Percorrer com os olhos o percurso do objeto e/ou virar a cabeça em direção ao local em que o objeto está escondido.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Percorre com os olhos o percurso do objeto e/ou vira a cabeça em direção ao local em que o objeto está escondido.</li>
                              <li><strong>AV:</strong> Procura com o olhar de forma inconsistente ou com atraso.</li>
                              <li><strong>Não:</strong> Não procura com o olhar um objeto que foi retirado do seu campo visual.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C3 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C3 - Remove um objeto de um recipiente colocando a mão dentro do mesmo.</div>
                          <div class="checkbox-interpretation">A criança deve retirar objetos como cubos, bolinhas ou biscoitos de recipientes inquebráveis, utilizando as mãos para puxar ou retirar o objeto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item3" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item3" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item3" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item3"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item3">
                            <p><strong>Recursos Materiais:</strong> Recipientes inquebráveis: xícara, lata, caixas ou tigelas.</p>
                            <p><strong>Condição:</strong> O adulto deve cuidar para que a criança não coloque objetos pequenos na boca, evitando riscos de engasgo.</p>
                            <p><strong>Resposta:</strong> Retirar cubos de 2,5 cm, bolinhas, carretel, rolha, dados, bolachas ou biscoitos de dentro de recipientes inquebráveis.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Retira cubos de 2,5 cm, bolinhas, carretel, rolha, dados, bolachas ou biscoitos de dentro de recipientes inquebráveis.</li>
                              <li><strong>AV:</strong> Remove objetos de forma inconsistente ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não remove um objeto de dentro de um recipiente.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C4 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C4 - Coloca um objeto em um recipiente imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve imitar ações de adultos, colocando objetos em recipientes após observar o modelo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item4" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item4" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item4" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item4"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item4">
                            <p><strong>Recursos Materiais:</strong> Recipiente e objetos para colocar dentro.</p>
                            <p><strong>Condição:</strong> Dar modelo e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Colocar o objeto dentro de 60 segundos após a apresentação do modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Coloca um objeto em um recipiente imitando um adulto dentro de 60 segundos após o modelo.</li>
                              <li><strong>AV:</strong> Coloca o objeto com atraso ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não coloca um objeto em um recipiente imitando um adulto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C5 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C5 - Coloca um objeto em um recipiente quando recebe uma instrução.</div>
                          <div class="checkbox-interpretation">A criança deve colocar objetos em recipientes seguindo instruções verbais e gestuais fornecidas por um adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item5" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item5" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item5" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item5"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item5">
                            <p><strong>Recursos Materiais:</strong> Recipiente e objetos para colocar dentro.</p>
                            <p><strong>Condição:</strong> As instruções devem ser acompanhadas de gestos indicativos.</p>
                            <p><strong>Resposta:</strong> Colocar o objeto dentro do recipiente dentro de 60 segundos após a apresentação das instruções.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Coloca um objeto em um recipiente dentro de 60 segundos após a apresentação das instruções.</li>
                              <li><strong>AV:</strong> Coloca o objeto com atraso ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não coloca um objeto em um recipiente seguindo instruções.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C6 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C6 - Balança um brinquedo que produz som, pendurado em um barbante.</div>
                          <div class="checkbox-interpretation">A criança deve balançar um brinquedo que produz som, utilizando as mãos ou os pés, após a apresentação do brinquedo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item6" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item6" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item6" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item6"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item6">
                            <p><strong>Recursos Materiais:</strong> Chocalho, sino preso ao barbante e amarrado à cama.</p>
                            <p><strong>Condição:</strong> Colocar a criança deitada de costas ou sentada, apoiada por almofadas.</p>
                            <p><strong>Resposta:</strong> Balançar = tocar ou empurrar um objeto colocado 15 a 20 cm da criança, com as mãos ou pés, 20 segundos após sua apresentação.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Balança um brinquedo que produz som com as mãos ou pés, após 20 segundos de sua apresentação.</li>
                              <li><strong>AV:</strong> Balança o brinquedo de forma inconsistente ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não balança um brinquedo que produz som.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C7 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C7 - Coloca três objetos em um recipiente e o esvazia.</div>
                          <div class="checkbox-interpretation">A criança deve colocar três objetos em um recipiente e depois esvaziá-lo dentro de um prazo estabelecido.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item7" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item7" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item7" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item7"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item7">
                            <p><strong>Recursos Materiais:</strong> Recipiente e objetos para colocar dentro.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, com supervisão mínima para evitar que a criança coloque objetos na boca.</p>
                            <p><strong>Resposta:</strong> Colocar três objetos no recipiente e esvaziá-lo dentro de 60 segundos após a apresentação dos objetos e do recipiente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Coloca três objetos no recipiente e esvaziá-lo dentro de 60 segundos após a apresentação dos objetos e do recipiente.</li>
                              <li><strong>AV:</strong> Coloca menos de três objetos ou não esvazia o recipiente dentro do prazo.</li>
                              <li><strong>Não:</strong> Não coloca três objetos em um recipiente e o esvazia.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C8 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C8 - Transfere um objeto de uma mão à outra para apanhar outro objeto.</div>
                          <div class="checkbox-interpretation">A criança deve transferir um objeto de uma mão para outra e imediatamente apanhar outro objeto, demonstrando coordenação motora e compreensão de sequência de ações.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item8" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item8" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item8" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item8"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item8">
                            <p><strong>Recursos Materiais:</strong> Objetos leves e pequenos (por exemplo: cubos de 2,5 cm).</p>
                            <p><strong>Condição:</strong> Colocar a criança sentada, apoiada por almofadas, e oferecer um objeto por vez. Se necessário, colocar o objeto na mão da criança e observar a transferência.</p>
                            <p><strong>Observação:</strong> Cuidar para que a criança não coloque os objetos na boca, evitando riscos de engasgo.</p>
                            <p><strong>Resposta:</strong> Transferir um objeto de uma mão à outra e imediatamente apanhar outro objeto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Transfere um objeto de uma mão à outra e imediatamente apanha outro objeto.</li>
                              <li><strong>AV:</strong> Transfere objetos de forma inconsistente ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não transfere um objeto de uma mão à outra para apanhar outro objeto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C9 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C9 - Deixa cair e apanha um brinquedo.</div>
                          <div class="checkbox-interpretation">A criança deve deixar cair um brinquedo e apanhá-lo em seguida, demonstrando coordenação olho-mão e percepção espacial.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item9" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item9" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item9" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item9"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item9">
                            <p><strong>Recursos Materiais:</strong> Bichinhos de borracha, argolas, cubos, etc.</p>
                            <p><strong>Condição:</strong> Ambiente seguro onde a criança possa deixar cair e apanhar o brinquedo.</p>
                            <p><strong>Resposta:</strong> Deixar o brinquedo cair e em seguida apanhá-lo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Apanha um brinquedo que deixou cair.</li>
                              <li><strong>AV:</strong> Apanha o brinquedo com dificuldade ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não apanha um brinquedo que deixou cair.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C10 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C10 - Descobre um objeto escondido sob um recipiente.</div>
                          <div class="checkbox-interpretation">A criança deve remover o recipiente que encobre um objeto, encontrá-lo e deixá-lo à vista, demonstrando habilidades de resolução de problemas e percepção visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item10" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item10" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item10" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item10"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item10">
                            <p><strong>Recursos Materiais:</strong> Doces, brinquedos, copo ou xícara, caixa de papelão.</p>
                            <p><strong>Condição:</strong> Colocar a criança sentada, apoiada com almofadas, cadeiras ou carrinho para bebê.</p>
                            <p><strong>Resposta:</strong> Descobrir = remover o recipiente que encobre o objeto, encontrando-o e deixando-o à vista.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Remove o recipiente que encobre o objeto, encontrando-o e deixando-o à vista.</li>
                              <li><strong>AV:</strong> Remove o recipiente com dificuldade ou não encontra o objeto completamente.</li>
                              <li><strong>Não:</strong> Não remove o recipiente que encobre o objeto.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C11 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C11 - Empurra três blocos como se fossem trem.</div>
                          <div class="checkbox-interpretation">A criança deve empurrar três blocos mantendo-os juntos, como se fossem um trem, percorrendo uma distância mínima de 30 cm.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item11" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item11" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item11" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item11"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item11">
                            <p><strong>Recursos Materiais:</strong> Blocos.</p>
                            <p><strong>Condição:</strong> Colocar um bloco atrás do outro, de forma que fiquem enfileirados, sobre uma superfície. Dar modelo e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Empurrar três blocos mantendo-os juntos “como se fossem um trem” de modo que estes percorram uma distância mínima de 30 cm.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Empurra três blocos mantendo-os juntos “como se fossem um trem” de modo que estes percorram uma distância mínima de 30 cm.</li>
                              <li><strong>AV:</strong> Empurra menos de três blocos ou não percorre a distância mínima.</li>
                              <li><strong>Não:</strong> Não empurra três blocos como se fossem trem.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C12 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C12 - Remove um círculo de uma prancha.</div>
                          <div class="checkbox-interpretation">A criança deve remover um círculo de uma prancha de madeira simples, seguindo o modelo e instrução fornecidos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item12" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item12" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item12" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item12"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item12">
                            <p><strong>Recursos Materiais:</strong> Prancha de madeira simples (contendo apenas o círculo).</p>
                            <p><strong>Condição:</strong> Dar modelo à criança, acompanhado de instrução.</p>
                            <p><strong>Resposta:</strong> Remove um círculo de uma prancha.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Remove um círculo de uma prancha seguindo modelo e instrução.</li>
                              <li><strong>AV:</strong> Remove o círculo de forma inconsistente ou com dificuldades.</li>
                              <li><strong>Não:</strong> Não remove um círculo de uma prancha.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C13 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C13 - Coloca um pino redondo em uma prancha de pinos, dada a ordem.</div>
                          <div class="checkbox-interpretation">A criança deve colocar um pino redondo em uma prancha de pinos seguindo as instruções verbais fornecidas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item13" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item13" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item13" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item13"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item13">
                            <p><strong>Recursos Materiais:</strong> Pino redondo de aproximadamente 2,5 cm de largura.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, com instruções claras.</p>
                            <p><strong>Resposta:</strong> Colocar um pino redondo em uma prancha de pinos, dada a ordem.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Coloca um pino redondo em uma prancha de pinos, dada a ordem.</li>
                              <li><strong>AV:</strong> Coloca o pino com dificuldade ou não segue completamente a ordem.</li>
                              <li><strong>Não:</strong> Não coloca um pino redondo em uma prancha de pinos.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C14 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C14 - Executa gestos simples quando requisitados.</div>
                          <div class="checkbox-interpretation">A criança deve executar gestos simples, como bater palmas ou imitar ações específicas, quando solicitado por um adulto.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao0_1_item14" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item14" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao0_1_item14" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao0_1_item14"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao0_1_item14">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Dar modelo e solicitar resposta.</p>
                            <p><strong>Resposta:</strong> Executar gestos simples = bater palmas ou imitar gestos tais como: tirar o telefone do gancho, cheirar uma flor, mover um brinquedo no ar, fingir que bebe de um copo, pegar um bloco em cada mão e batê-los, tossir, etc.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Executa gestos simples quando requisitado.</li>
                              <li><strong>AV:</strong> Executa apenas alguns gestos ou de forma inconsistente.</li>
                              <li><strong>Não:</strong> Não executa gestos simples quando requisitado.</li>
                            </ul>
                          </div>
                        </div>

                    </div>

                    <!-- Faixa 1 - 2 anos - Cognição -->
                    <div id="cog1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1 - 2 anos</h5>
                        
                        <!-- Card C15 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C15 - Retira 6 objetos de um recipiente, um de cada vez.</div>
                          <div class="checkbox-interpretation">A criança deve retirar seis objetos de um recipiente, um após o outro, demonstrando coordenação motora e compreensão de sequência de ações.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item15" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item15" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item15" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item15"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item15">
                            <p><strong>Recursos Materiais:</strong> Blocos coloridos e grandes, bichinhos; Recipiente: caixa, cesto ou bolsas.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, supervisionando para evitar que a criança coloque objetos pequenos na boca.</p>
                            <p><strong>Resposta:</strong> Remover seis objetos de um recipiente, um após o outro, no máximo 60 segundos após a apresentação dos mesmos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não remove objetos de um recipiente.</li>
                              <li><strong>Às Vezes:</strong> Remove seis objetos de um recipiente, um após o outro, dentro de 60 segundos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C16 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C16 - Aponta para uma parte do corpo.</div>
                          <div class="checkbox-interpretation">A criança deve apontar para uma parte do corpo específica quando solicitado, demonstrando reconhecimento e identificação das partes do corpo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item16" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item16" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item16" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item16"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item16">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, podendo utilizar espelho ou fotografias para auxiliar.</p>
                            <p><strong>Resposta:</strong> Apontar para uma parte do corpo dentro de 20 segundos após ter sido dada a instrução. Partes do corpo: nariz, olhos, ouvido, boca, cabeça ou cabelo, mão, pé, perna ou barriga, de si mesmo, boneca ou outra pessoa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para si mesmo frente à pergunta “Cadê o ... (nome)?”.</li>
                              <li><strong>Às Vezes:</strong> Aponta para uma parte do corpo após 20 segundos ter sido dada a instrução.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C17 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C17 - Empilha três blocos dada uma ordem.</div>
                          <div class="checkbox-interpretation">A criança deve empilhar três blocos de tamanhos diferentes seguindo a ordem dada, demonstrando habilidades de coordenação motora e compreensão de instruções sequenciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item17" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item17" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item17" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item17"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item17">
                            <p><strong>Recursos Materiais:</strong> Blocos grandes de tamanhos diferentes, sendo cada um significativamente maior que o outro.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, dando modelo e solicitando a resposta.</p>
                            <p><strong>Resposta:</strong> Empilhar três blocos = colocar um bloco sobre o outro de forma que, ao colocar o terceiro bloco, a “pilha” permaneça de pé pelo menos um segundo. A resposta deverá ocorrer dentro de 20 segundos após os blocos terem sido apresentados.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não empilha três blocos.</li>
                              <li><strong>Às Vezes:</strong> Empilha três blocos de maneira que permanece em pé por pelo menos 1 segundo, emitindo a resposta dentro de 20 segundos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C18 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C18 - Emparelha objetos semelhantes.</div>
                          <div class="checkbox-interpretation">A criança deve emparelhar objetos semelhantes, demonstrando reconhecimento de características comuns e habilidades de categorização.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item18" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item18" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item18" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item18"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item18">
                            <p><strong>Recursos Materiais:</strong> Duas bolas, duas bonecas, duas colheres, duas camisetas da mesma cor, duas frutas iguais.</p>
                            <p><strong>Condição:</strong> Para diminuir a complexidade da tarefa, não apresentar objetos com dimensões diferentes (cor, tamanho, forma, textura). Dispor objetos que servirão como modelo (ex.: uma bola, uma boneca, uma colher) e entregar seus respectivos pares à criança solicitando a resposta de emparelhar.</p>
                            <p><strong>Resposta:</strong> Emparelhar = cada tentativa corresponde a colocar um objeto próximo do seu objeto semelhante.</p>
                            <p><strong>Critério:</strong> Emparelhar pelo menos três diferentes pares de objetos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha objetos semelhantes.</li>
                              <li><strong>Às Vezes:</strong> Emparelha pelo menos 3 diferentes pares de objetos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C19 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C19 - Faz rabiscos no papel.</div>
                          <div class="checkbox-interpretation">A criança deve fazer rabiscos no papel, demonstrando habilidades motoras finas e expressão criativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item19" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item19" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item19" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item19"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item19">
                            <p><strong>Recursos Materiais:</strong> Se necessário, utilizar lápis de cera.</p>
                            <p><strong>Condição:</strong> Dar modelo e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Rabisco = qualquer tipo de traço produzido sobre o papel.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não faz rabiscos no papel.</li>
                              <li><strong>Às Vezes:</strong> Faz rabiscos no papel.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C20 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C20 - Aponta para si mesmo frente à pergunta: “Cadê o... (nome)?”</div>
                          <div class="checkbox-interpretation">A criança deve apontar para si mesma quando perguntada sobre a localização de uma parte do corpo ou objeto, demonstrando reconhecimento e autoconsciência.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item20" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item20" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item20" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item20"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item20">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Se necessário, fazer a pergunta colocando a criança frente ao espelho ou apresentando-lhe uma fotografia de si mesma.</p>
                            <p><strong>Resposta:</strong> Apontar = colocar o dedo ou a mão sobre a figura nomeada dentro de 20 segundos após a emissão verbal da mesma.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para si mesmo frente à pergunta “Cadê o ... (nome)?”.</li>
                              <li><strong>Às Vezes:</strong> Aponta para si mesmo frente à pergunta: “Cadê o... (nome)?”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C21 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C21 - Coloca cinco pinos redondos em uma prancha dada uma ordem.</div>
                          <div class="checkbox-interpretation">A criança deve colocar cinco pinos redondos em uma prancha seguindo a ordem dada, demonstrando habilidades de coordenação motora fina e compreensão de instruções.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item21" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item21" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item21" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item21"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item21">
                            <p><strong>Recursos Materiais:</strong> Não exige material.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, dando modelo e instruções claras.</p>
                            <p><strong>Resposta:</strong> Colocar cinco pinos redondos em uma prancha dentro de 60 segundos após a apresentação dos mesmos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não coloca cinco pinos redondos em uma prancha.</li>
                              <li><strong>Às Vezes:</strong> Coloca cinco pinos redondos em uma prancha dentro de 60 segundos após a apresentação dos mesmos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C22 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C22 - Emparelha objetos com a figura do mesmo objeto.</div>
                          <div class="checkbox-interpretation">A criança deve emparelhar objetos físicos com suas respectivas figuras, demonstrando habilidades de reconhecimento e correspondência visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item22" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item22" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item22" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item22"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item22">
                            <p><strong>Recursos Materiais:</strong> Brinquedos (bola, boneca, doce etc.) e suas respectivas figuras em livros ou revistas. As figuras deverão ser bastante nítidas e facilmente identificáveis.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando objetos e figuras de forma clara.</p>
                            <p><strong>Resposta:</strong> Cada tentativa diz respeito a colocar um objeto próximo de sua figura correspondente.</p>
                            <p><strong>Critério:</strong> Emparelhar no mínimo três objetos diferentes com suas respectivas figuras.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha objetos com figuras.</li>
                              <li><strong>Às Vezes:</strong> Emparelha ao menos 3 objetos diferentes com suas respectivas figuras.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C23 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C23 - Aponta para figura nomeada.</div>
                          <div class="checkbox-interpretation">A criança deve apontar para uma figura específica quando nomeada, demonstrando reconhecimento de objetos e habilidades de localização visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item23" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item23" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item23" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item23"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item23">
                            <p><strong>Recursos Materiais:</strong> Fotografias grandes da família, ilustrações de livros infantis ou figuras de revistas de comestíveis, roupa, animais ou utensílios domésticos.</p>
                            <p><strong>Condição:</strong> Fazer perguntas do tipo: “Me mostra o (papai)?” “Onde está o (au-au)?” “Me mostra a (bola)?”.</p>
                            <p><strong>Resposta:</strong> Apontar = colocar o dedo ou a mão sobre a figura nomeada dentro de 20 segundos após a emissão verbal da mesma.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para figuras nomeadas.</li>
                              <li><strong>Às Vezes:</strong> Aponta ou coloca o dedo sobre a figura nomeada, dentro de 20 segundos após emissão verbal.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C24 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C24 - Vira as páginas de um livro (duas a três de cada vez) para encontrar a figura nomeada.</div>
                          <div class="checkbox-interpretation">A criança deve virar as páginas de um livro, duas a três de cada vez, para localizar e identificar uma figura específica, demonstrando habilidades de leitura e atenção.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao1_2_item24" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item24" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao1_2_item24" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao1_2_item24"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao1_2_item24">
                            <p><strong>Recursos Materiais:</strong> Livro = preferencialmente livros de histórias infantis com páginas de papel comum e com ilustrações grandes e coloridas.</p>
                            <p><strong>Condição:</strong> Mostrar e nomear uma figura distinta de um livro infantil. Em seguida, fechar o livro e solicitar a resposta da criança.</p>
                            <p><strong>Resposta:</strong> Virar as páginas de um livro (duas a três de cada vez) e, em seguida, encontrar a figura nomeada.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não vira as páginas de um livro para encontrar a figura nomeada.</li>
                              <li><strong>Às Vezes:</strong> Vira as páginas de um livro (duas a três de cada vez) e, em seguida, encontra a figura nomeada.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 2 - 3 anos - Cognição -->
                    <div id="cog2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2 - 3 anos</h5>
                        
                        <!-- Card C25 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C25 - Encontra um determinado livro quando requisitado.</div>
                          <div class="checkbox-interpretation">A criança deve localizar e pegar um livro específico quando solicitado, demonstrando habilidades de reconhecimento e busca.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item25" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item25" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item25" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item25"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item25">
                            <p><strong>Recursos Materiais:</strong> Livros com ilustrações e conteúdos diferentes (animais, carros e gente).</p>
                            <p><strong>Condição:</strong> Os livros devem ser colocados em um lugar acessível à criança, na mesma sala em que ela se encontra.</p>
                            <p><strong>Resposta:</strong> Encontrar um determinado livro = ir em direção ao local onde está o livro solicitado e pegá-lo, ou apanhar ou pegar o livro solicitado, dentre vários, 30 segundos após a instrução.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não encontra um determinado livro quando solicitado.</li>
                              <li><strong>Às Vezes:</strong> Encontra um determinado livro quando solicitado, dentro de 30 segundos após a instrução.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C26 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C26 - Completa um quebra-cabeças de encaixe de três peças.</div>
                          <div class="checkbox-interpretation">A criança deve montar um quebra-cabeças de três peças, demonstrando habilidades de resolução de problemas e coordenação motora.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item26" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item26" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item26" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item26"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item26">
                            <p><strong>Recursos Materiais:</strong> Quebra-cabeças de encaixe de três peças = tabuleiro com as formas círculo, quadrado e triângulo, manipuláveis.</p>
                            <p><strong>Condição:</strong> Dar para a criança uma peça por vez, começando pelo círculo, depois o quadrado e por último o triângulo. Se necessário, dar modelo.</p>
                            <p><strong>Resposta:</strong> Completar um quebra-cabeças de encaixe de três peças.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não completa um quebra-cabeças de encaixe de três peças.</li>
                              <li><strong>Às Vezes:</strong> Completa um quebra-cabeças de encaixe de três peças.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C27 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C27 - Nomeia quatro objetos comuns em figuras.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear quatro objetos comuns apresentados em figuras, demonstrando reconhecimento e vocabulário.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item27" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item27" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item27" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item27"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item27">
                            <p><strong>Recursos Materiais:</strong> Figuras de comestíveis (biscoito, água, banana, leite, suco) ou de móveis ou utensílios (mesa, cama, cadeira, colher, copo, livro, lápis).</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando figuras claras e distintas.</p>
                            <p><strong>Resposta:</strong> Nomear quatro objetos comuns em figuras 20 segundos após a apresentação de cada figura e a pergunta: “O que é isto?”</p>
                            <p><strong>Critério:</strong> Dizer o nome de pelo menos quatro objetos comuns em figuras. Caso a nomeação da criança seja diferente dos padrões da comunidade verbal (por exemplo: apresentando erros articulatórios), o critério para adequação da resposta será a identificação do objeto por três pessoas diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia quatro objetos comuns em figuras.</li>
                              <li><strong>Às Vezes:</strong> Nomeia quatro objetos comuns em figuras dentro de 20 segundos após a apresentação de cada figura e a pergunta: “O que é isto?”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C28 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C28 - Desenha uma linha vertical imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve desenhar uma linha vertical seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e imitação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item28" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item28" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item28" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item28"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item28">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> O modelo da linha vertical dado pelo adulto não deve exceder 5 cm. O adulto deverá traçar a linha diante da criança chamando sua atenção para a direção do seu traçado que deverá começar de cima para baixo.</p>
                            <p><strong>Resposta:</strong> Critério: O traço da criança pode ser maior que o do adulto, mas deverá ter no mínimo 3 cm de comprimento. A dimensão a ser avaliada é a verticalidade do traçado, ou seja, que este não se desvie do modo mais do que 30 graus. Não faz mal se a criança traçar mais de uma linha e essas não precisam ser perfeitamente retas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não desenha uma linha vertical imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Desenha uma linha vertical de pelo menos 3 cm, imitando um adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C29 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C29 - Desenha uma linha horizontal imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve desenhar uma linha horizontal seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e imitação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item29" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item29" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item29" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item29"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item29">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> O modelo da linha horizontal dado pelo adulto não deve exceder 5 cm. O adulto deverá traçar a linha diante da criança chamando sua atenção para a direção do seu traçado que deverá começar da esquerda para a direita.</p>
                            <p><strong>Resposta:</strong> Critério: O traço da criança pode ser maior que o do adulto, mas deverá ter no mínimo 3 cm de comprimento. A dimensão a ser avaliada é a horizontalidade do traçado, ou seja, que este não se desvie do modo mais do que 30 graus. Não faz mal se a criança traçar mais de uma linha e essas não precisam ser perfeitamente retas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não desenha uma linha horizontal imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Desenha uma linha horizontal de pelo menos 3 cm, imitando um adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C30 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C30 - Copia um círculo.</div>
                          <div class="checkbox-interpretation">A criança deve copiar um círculo apresentado por um adulto, demonstrando habilidades de coordenação motora e reconhecimento de formas geométricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item30" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item30" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item30" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item30"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item30">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma folha de papel com um círculo já desenhado (cerca de 4 cm de diâmetro). Pedir para a criança copiar um desenho igual, sem dar sugestões adicionais (por exemplo: sem nomear ou mover dedos ou lápis).</p>
                            <p><strong>Resposta:</strong> Traçar qualquer forma ovalada fechada, que não seja acompanhada por movimentos concêntricos contínuos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não copia um círculo.</li>
                              <li><strong>Às Vezes:</strong> Copia um círculo, traçando qualquer forma ovalada fechada.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C31 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C31 - Emparelha objetos com a mesma textura.</div>
                          <div class="checkbox-interpretation">A criança deve emparelhar objetos que possuem a mesma textura, demonstrando habilidades de percepção tátil e categorização.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item31" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item31" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item31" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item31"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item31">
                            <p><strong>Recursos Materiais:</strong> Texturas = ásperas, lisas, macias e peludas.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando objetos com texturas distintas e claras.</p>
                            <p><strong>Resposta:</strong> Cada tentativa diz respeito a colocar um objeto próximo de outro com a mesma textura.</p>
                            <p><strong>Critério:</strong> Emparelhar pelo menos três texturas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha objetos com a mesma textura.</li>
                              <li><strong>Às Vezes:</strong> Emparelha objetos de pelo menos 3 texturas diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C32 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C32 - Aponta para o “pequeno” e o “grande” quando requisitado.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar para objetos que são "pequenos" ou "grandes", demonstrando compreensão de conceitos de tamanho e comparação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item32" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item32" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item32" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item32"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item32">
                            <p><strong>Recursos Materiais:</strong> Lápis, pedras, sapatos, casacos, pratos, bolachas, doces, bolas, livros, cadeiras, semelhantes em todos os aspectos, porém contrastando quanto ao tamanho.</p>
                            <p><strong>Condição:</strong> A cada resposta da criança, alterar a posição espacial dos objetos, de forma que ela discrimine a dimensão tamanho e não posição.</p>
                            <p><strong>Resposta:</strong> Cada tentativa diz respeito a apontar um objeto grande ou um objeto pequeno quando solicitado.</p>
                            <p><strong>Critério:</strong> Apontar pelo menos três objetos diferentes, pequenos e grandes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para “pequeno” e “grande” quando solicitado.</li>
                              <li><strong>Às Vezes:</strong> Aponta pelo menos 3 objetos diferentes, pequenos e grandes, quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C33 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C33 - Desenha (+) imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve desenhar o sinal de mais (+) seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e imitação de formas geométricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item33" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item33" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item33" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item33"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item33">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> O modelo do sinal (+) feito pelo adulto não deverá ser maior que 4 cm. Realizar o traçado na frente da criança.</p>
                            <p><strong>Resposta:</strong> Critério: Desenhar um (+) imitando de forma que as duas linhas se intersectem. As linhas não necessariamente precisam ser retas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não desenha (+) imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Desenha (+) de forma que duas linhas se intersectem, imitando um adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C34 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C34 - Emparelha três cores.</div>
                          <div class="checkbox-interpretation">A criança deve emparelhar objetos que possuem a mesma cor, demonstrando habilidades de reconhecimento de cores e categorização.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item34" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item34" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item34" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item34"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item34">
                            <p><strong>Recursos Materiais:</strong> Círculos ou brinquedos vermelhos, amarelos e azuis.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando objetos com cores primárias distintas.</p>
                            <p><strong>Resposta:</strong> Cada tentativa diz respeito a colocar próximo dois objetos da mesma cor, sendo que pelo menos três cores primárias diferentes devem ser utilizadas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha objetos por cores.</li>
                              <li><strong>Às Vezes:</strong> Emparelha objetos da mesma cor, sendo pelo menos 3 cores primárias diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C35 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C35 - Coloca objetos dentro, em cima e embaixo de um recipiente dada uma ordem.</div>
                          <div class="checkbox-interpretation">A criança deve colocar objetos dentro, em cima e embaixo de um recipiente seguindo a ordem especificada, demonstrando compreensão de posições espaciais e sequência de ações.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item35" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item35" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item35" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item35"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item35">
                            <p><strong>Recursos Materiais:</strong> Cubos de 2.5 cm; Recipiente = xícara ou caixa.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, dando modelo e instruções claras.</p>
                            <p><strong>Resposta:</strong> Colocar o objeto dentro, em cima e embaixo de um recipiente dada as respectivas ordens a cada tentativa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não coloca objetos dentro, em cima e embaixo de um recipiente.</li>
                              <li><strong>Às Vezes:</strong> Coloca o objeto dentro, em cima e embaixo de um recipiente dadas as respectivas ordens.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C36 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C36 - Nomeia objetos que fazem barulho.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear objetos ou animais que produzem sons, demonstrando reconhecimento auditivo e vocabulário.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item36" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item36" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item36" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item36"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item36">
                            <p><strong>Recursos Materiais:</strong> Telefone, despertador, campainha, trator aspirador, latido de cachorro, avião, miado de gato, mugido de vaca, porta batendo, piano, buzina de carro.</p>
                            <p><strong>Condição:</strong> Provocar o barulho (por exemplo: bater uma porta) e pedir à criança para nomear o objeto que produziu ou imitar sons de animais e pedir à criança que os identifique.</p>
                            <p><strong>Resposta:</strong> Nomear = dizer o nome do objeto ou do animal de onde provém o som, 20 segundos após a solicitação de cada uma das respostas, por tentativa.</p>
                            <p><strong>Critério:</strong> Nomear pelo menos cinco diferentes objetos/animais que fazem barulho. Se houver discrepâncias articulatórias, o critério para adequação da resposta será a identificação do objeto/animal por três pessoas diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia objetos que fazem barulhos.</li>
                              <li><strong>Às Vezes:</strong> Nomeia pelo menos 5 objetos/animais que fazem barulho, dentro de 20 segundos após a solicitação.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C37 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C37 - Monta um brinquedo de encaixe de quatro peças.</div>
                          <div class="checkbox-interpretation">A criança deve montar um brinquedo de encaixe com quatro peças, demonstrando habilidades de coordenação motora e resolução de problemas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item37" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item37" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item37" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item37"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item37">
                            <p><strong>Recursos Materiais:</strong> Brinquedos de fácil encaixe, por pressão ou não, de forma que possam unir peças para construir um todo.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, dando modelo e instruções claras.</p>
                            <p><strong>Resposta:</strong> Montar = colocar uma peça dentro da outra ou encaixá-las a fim de formar um brinquedo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não monta um brinquedo de encaixe de 4 peças.</li>
                              <li><strong>Às Vezes:</strong> Monta um brinquedo de encaixe de quatro peças.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C38 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C38 - Nomeia ações em figuras.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear ações representadas em figuras, demonstrando compreensão de atividades e vocabulário ativo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item38" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item38" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item38" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item38"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item38">
                            <p><strong>Recursos Materiais:</strong> Figuras que envolvam ações nítidas tais como: lavar, cozinhar, andar de bicicleta, chorar, correr, passar a ferro, costurar, saltar, caminhar etc.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando figuras claras e distintas.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “O que ... está fazendo?” nomear a ação correspondente à figura dentro de 20 segundos após a apresentação de cada figura.</p>
                            <p><strong>Critério:</strong> Nomear, pelo menos, três ações diferentes em figuras. Se houver discrepâncias articulatórias, o critério para adequação da resposta será a identificação da ação por três pessoas diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia ações em figuras.</li>
                              <li><strong>Às Vezes:</strong> Nomeia pelo menos 3 ações diferentes em figuras, dentro de 20 segundos após a pergunta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C39 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C39 - Emparelha uma forma geométrica com a figura da mesma.</div>
                          <div class="checkbox-interpretation">A criança deve emparelhar uma forma geométrica com a figura correspondente, demonstrando habilidades de reconhecimento e correspondência visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item39" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item39" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item39" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item39"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item39">
                            <p><strong>Recursos Materiais:</strong> Formas geométricas = círculos, quadrados ou triângulos.</p>
                            <p><strong>Condição:</strong> Apresentar uma figura de um círculo, por exemplo, e em seguida, apresentar formas de círculos, quadrados e triângulos, solicitando a resposta de emparelhar.</p>
                            <p><strong>Resposta:</strong> Emparelhar uma forma geométrica com a figura da mesma.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha uma forma geométrica com sua figura.</li>
                              <li><strong>Às Vezes:</strong> Emparelha uma forma geométrica com sua figura.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C40 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C40 - Empilha cinco ou mais argolas em uma vara na ordem correta.</div>
                          <div class="checkbox-interpretation">A criança deve empilhar cinco ou mais argolas em uma vara seguindo a ordem correta de tamanho, demonstrando habilidades de coordenação motora e compreensão de sequência.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao2_3_item40" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item40" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao2_3_item40" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao2_3_item40"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao2_3_item40">
                            <p><strong>Recursos Materiais:</strong> Argolas ou aros de tamanhos significativamente diferentes.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando argolas de diferentes tamanhos.</p>
                            <p><strong>Resposta:</strong> Empilhar cinco ou mais argolas em uma vara na ordem correta.</p>
                            <p><strong>Critério:</strong> Ordem correta = tamanho maior para o menor ou vice-versa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não empilha argolas em uma vara.</li>
                              <li><strong>Às Vezes:</strong> Empilha cinco ou mais argolas em uma vara na ordem correta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 3 - 4 anos - Cognição -->
                    <div id="cog3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3 - 4 anos</h5>
                        
                        <!-- Card C41 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C41 - Nomeia objetos como sendo “grandes” ou “pequenos”.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear objetos como "grandes" ou "pequenos", demonstrando compreensão dos conceitos de tamanho.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item41" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item41" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item41" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item41"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item41">
                            <p><strong>Recursos Materiais:</strong> Círculos de 15 cm e 7 cm, blocos, bolas e outros objetos que diferem no tamanho, mas não na cor ou forma.</p>
                            <p><strong>Condição:</strong> Apresentar os objetos à criança e perguntar, por exemplo: “Este círculo é grande ou pequeno?”, “Esta bola é pequena ou grande?”. Variar a ordem das palavras "pequeno" e "grande" nas perguntas para não dar sugestões adicionais à criança.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “(isto) é grande ou pequeno?”, responder adequadamente, dizendo a palavra "grande" ou "pequeno", dentro de 20 segundos após cada pergunta.</p>
                            <p><strong>Critério:</strong> Responder adequadamente a pelo menos três perguntas envolvendo três diferentes objetos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia objetos como sendo “grandes” ou “pequenos”.</li>
                              <li><strong>Às Vezes:</strong> Nomeia objetos como sendo “grandes” ou “pequenos”, dentro de 20 segundos após cada pergunta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C42 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C42 - Aponta para dez partes do corpo quando requisitado.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar para dez partes diferentes do corpo, demonstrando conhecimento anatômico básico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item42" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item42" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item42" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item42"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item42">
                            <p><strong>Recursos Materiais:</strong> Não exige material específico.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, podendo utilizar espelho, fotografias ou bonecos para auxiliar na identificação das partes do corpo.</p>
                            <p><strong>Resposta:</strong> Apontar para dez partes do corpo = olhos, mãos, pés, pescoço, orelhas, nariz, boca, cabelo ou cabeça, braços, pernas ou barriga, tanto em si mesmo quanto em bonecos ou outras pessoas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para 10 partes do corpo quando requisitado.</li>
                              <li><strong>Às Vezes:</strong> Aponta para 10 partes do corpo quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C43 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C43 - Aponta para um menino e uma menina, dada uma ordem.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar para figuras representando um menino e uma menina quando solicitado, demonstrando discriminação de gênero.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item43" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item43" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item43" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item43"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item43">
                            <p><strong>Recursos Materiais:</strong> Figuras de menino e menina reais, ilustradas ou em bonecos.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, apresentando as figuras de forma clara e distinta.</p>
                            <p><strong>Resposta:</strong> Apontar adequadamente para o menino e a menina por tentativa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta adequadamente para menino e menina.</li>
                              <li><strong>Às Vezes:</strong> Aponta adequadamente para menino e menina.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C44 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C44 - Diz se um objeto é pesado ou leve.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e classificar objetos como "pesados" ou "leves", demonstrando compreensão dos conceitos de peso.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item44" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item44" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item44" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item44"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item44">
                            <p><strong>Recursos Materiais:</strong> Objetos com contraste de peso, com diferença maior que dois quilogramas (por exemplo: um pacote de arroz e um chumaço de algodão).</p>
                            <p><strong>Condição:</strong> Apresentar à criança o par de objetos e perguntar, por exemplo: “O algodão é leve ou pesado?”. Variar a ordem das palavras "leve" e "pesado" nas perguntas para não dar sugestões adicionais à criança.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “(isto) é leve ou pesado?”, responder adequadamente (dizer a palavra "leve" ou "pesado") dentro de 20 segundos após cada pergunta.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde adequadamente se um objeto é leve ou pesado.</li>
                              <li><strong>Às Vezes:</strong> Responde adequadamente se um objeto é leve ou pesado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C45 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C45 - Une duas partes de uma figura para formar o todo.</div>
                          <div class="checkbox-interpretation">A criança deve combinar duas partes de uma figura para formar a figura completa, demonstrando habilidades de correspondência e resolução de problemas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item45" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item45" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item45" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item45"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item45">
                            <p><strong>Recursos Materiais:</strong> Figuras geométricas, ilustrações de animais ou de objetos cortados pela metade, peças de quebra-cabeça.</p>
                            <p><strong>Condição:</strong> Dispor ambas as partes da figura sobre a mesa, sendo que uma delas deveria estar invertida. Solicitar à criança que una as duas partes de forma que a figura fique inteira.</p>
                            <p><strong>Resposta:</strong> Unir duas partes de uma figura para formar o todo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não une duas partes de uma figura para formar um todo.</li>
                              <li><strong>Às Vezes:</strong> Une duas partes de uma figura para formar o todo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C46 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C46 - Descreve dois eventos ou personagens de uma história familiar ou programa de televisão.</div>
                          <div class="checkbox-interpretation">A criança deve relatar dois acontecimentos ou identificar dois personagens de uma história familiar ou programa de televisão, demonstrando compreensão e memória de narrativas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item46" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item46" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item46" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item46"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item46">
                            <p><strong>Recursos Materiais:</strong> História familiar ou programa de televisão a ser especificado pelo mediador, com base na preferência da criança.</p>
                            <p><strong>Condição:</strong> Fazer perguntas à criança semelhantes a: “O que acontece na história/programa X, quando...?”, “Quem aparece no programa/história X?”, “Como é o nome do (personagem)?”, “Como ele é?”, etc.</p>
                            <p><strong>Resposta:</strong> Descrever dois eventos = relatar pelo menos dois acontecimentos, duas ações ou situações de uma história familiar ou programa de televisão. Descrever dois personagens = identificar o nome de dois personagens e/ou relatar pelo menos uma característica de cada personagem.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não descreve dois eventos ou personagens de uma história familiar.</li>
                              <li><strong>Às Vezes:</strong> Descreve dois eventos ou personagens de uma história familiar ou programa de televisão.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C47 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C47 - Repete brincadeiras (rimas ou canções) que envolvam movimentos coordenados (ou gestos).</div>
                          <div class="checkbox-interpretation">A criança deve reproduzir rimas ou canções acompanhadas de movimentos coordenados ou gestos, demonstrando memorização e coordenação motora.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item47" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item47" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item47" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item47"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item47">
                            <p><strong>Recursos Materiais:</strong> Rimas ou canções infantis que envolvam movimentos coordenados ou gestos.</p>
                            <p><strong>Condição:</strong> Dar o modelo à criança, cantando a canção e emitindo gestos (por exemplo: “Pirulito que bate-bate” ou qualquer outra canção infantil acompanhada de gestos). Se necessário, envolver outro adulto ou criança mais velha ao dar o modelo.</p>
                            <p><strong>Resposta:</strong> Repetir uma rima ou canção produzindo movimentos coordenados ou gestos.</p>
                            <p><strong>Critério:</strong> Reproduzir toda a rima ou canção acompanhada de gestos à medida que recebe o modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não repete uma rima ou canção produzindo movimentos coordenados ou gestos.</li>
                              <li><strong>Às Vezes:</strong> Repete uma rima ou canção reproduzindo toda a rima ou canção acompanhada de gestos à medida que recebe o modelo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C48 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C48 - Emparelha três ou mais objetos.</div>
                          <div class="checkbox-interpretation">A criança deve emparelhar três ou mais objetos que pertencem à mesma categoria, demonstrando habilidades de categorização e correspondência.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item48" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item48" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item48" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item48"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item48">
                            <p><strong>Recursos Materiais:</strong> Objetos de diversos tipos, sendo que no mínimo três deles devem formar par, por exemplo: escova de dente e pasta, meia e sapato, pires e xícara, garfo e faca (ou colher), cadeira e mesa.</p>
                            <p><strong>Condição:</strong> Colocar sobre uma superfície três ou mais objetos (por exemplo: um sapato, uma escova e um pires) e pedir à criança para retirar, de um segundo agrupamento de objetos, aqueles que formam par, por exemplo, colocando a meia próxima ao sapato.</p>
                            <p><strong>Resposta:</strong> Dado três ou mais objetos, a criança deverá emparelhá-los (colocando próximo à) com seus respectivos pares, dentro de 60 segundos por tentativa.</p>
                            <p><strong>Critério:</strong> Emparelhar três ou mais objetos associados, dentro de 60 segundos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha objetos associados.</li>
                              <li><strong>Às Vezes:</strong> Emparelha três ou mais objetos, colocando-os próximos aos seus respectivos pares, dentro de 60 segundos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C49 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C49 - Aponta para objetos compridos e curtos.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar para objetos que são "compridos" ou "curtos", demonstrando compreensão dos conceitos de comprimento.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item49" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item49" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item49" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item49"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item49">
                            <p><strong>Recursos Materiais:</strong> Lápis, régua, macarrão, meia, etc., semelhantes em todos os aspectos, mas contrastando quanto ao comprimento (por exemplo: um palito de 5 cm e outro de 6,5 cm).</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “Me mostre a meia comprida”, “Qual o macarrão curto?”. Não usar as palavras "grande/maior" ou "menor". A cada resposta da criança, alterar a posição espacial dos objetos, de forma que ela discrimine a dimensão comprimento e não posição.</p>
                            <p><strong>Resposta:</strong> Uma tentativa diz respeito a apontar para um objeto comprido e um objeto curto quando requisitado.</p>
                            <p><strong>Critério:</strong> Apontar pelo menos três objetos diferentes, compridos e curtos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para objetos compridos e curtos.</li>
                              <li><strong>Às Vezes:</strong> Aponta pelo menos 3 objetos diferentes, compridos e curtos quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C50 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C50 - Diz quais objetos aparecem frequentemente juntos.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear pares de objetos que costumam aparecer juntos, demonstrando conhecimento sobre associações comuns.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item50" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item50" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item50" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item50"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item50">
                            <p><strong>Recursos Materiais:</strong> Objetos que frequentemente aparecem juntos, como copo e prato, meia e sapato, lápis e papel, pente e escova, chaveiro e chave, etc.</p>
                            <p><strong>Condição:</strong> Dispor três objetos por tentativa (sendo dois destes objetos que formam par e um terceiro diferente). Perguntar à criança: “Quais destes objetos aparecem sempre juntos?”.</p>
                            <p><strong>Resposta:</strong> Dizer qual objeto aparece frequentemente junto a outro (dentre vários objetos) por tentativa.</p>
                            <p><strong>Critério:</strong> Dizer no mínimo três diferentes objetos que aparecem frequentemente juntos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz quais objetos aparecem frequentemente juntos.</li>
                              <li><strong>Às Vezes:</strong> Diz no mínimo 3 diferentes objetos que aparecem frequentemente juntos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C51 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C51 - Conta até três imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve contar até três seguindo o modelo verbal de um adulto, demonstrando habilidades de contagem e imitação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item51" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item51" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item51" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item51"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item51">
                            <p><strong>Recursos Materiais:</strong> Blocos, contas, feijão, milho, brinquedos, doces, figuras de animais, etc., em número até três.</p>
                            <p><strong>Condição:</strong> Dispor três objetos frente à criança e dar o modelo verbal para contar.</p>
                            <p><strong>Resposta:</strong> Dado o modelo verbal “um, dois, três” ao contar objetos, a criança deve reproduzi-lo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta até 3 imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Conta até 3, dado o modelo verbal do adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C52 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C52 - Agrupa objetos em categorias.</div>
                          <div class="checkbox-interpretation">A criança deve classificar objetos em diferentes categorias, demonstrando habilidades de categorização e organização.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item52" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item52" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item52" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item52"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item52">
                            <p><strong>Recursos Materiais:</strong> Categorias de objetos = brinquedos, mobílias, roupas, frutas, utensílios de cozinha, animais, etc., podendo utilizar os próprios objetos ou ilustrações destes.</p>
                            <p><strong>Condição:</strong> Apresentar à criança diversos objetos, envolvendo categorias diferentes, e solicitar resposta para agrupá-los.</p>
                            <p><strong>Resposta:</strong> Agrupar ou separar objetos que fazem parte de uma categoria por tentativa.</p>
                            <p><strong>Critério:</strong> Agrupar objetos em pelo menos três categorias diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não agrupa objetos em categorias.</li>
                              <li><strong>Às Vezes:</strong> Agrupa objetos em pelo menos 3 categorias diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C53 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C53 - Traça (V) em imitação.</div>
                          <div class="checkbox-interpretation">A criança deve desenhar a letra "V" seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e imitação de formas geométricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item53" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item53" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item53" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item53"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item53">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Traçar um "V" diante da criança, sendo que tal traçado não deve exceder 4 cm.</p>
                            <p><strong>Resposta:</strong> Critério: Traçar um "V" em imitação de forma que as linhas se unam, formando um ângulo menor que 45°. A posição do traçado deve corresponder ao modelo, ou seja, não ser de cabeça para baixo ou virado de lado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não traça "V" seguindo o modelo.</li>
                              <li><strong>Às Vezes:</strong> Traça "V" seguindo o modelo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C54 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C54 - Traça uma linha diagonal ligando os dois cantos de um papel de 10 cm.</div>
                          <div class="checkbox-interpretation">A criança deve desenhar uma linha diagonal que conecta os dois cantos de um papel de 10 cm, demonstrando habilidades de coordenação motora e compreensão de direções.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item54" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item54" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item54" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item54"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item54">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Dar modelo à criança, realizando o traçado à sua frente.</p>
                            <p><strong>Resposta:</strong> Traçar uma linha diagonal ligando os dois cantos de um papel de 10 cm.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não traça uma linha diagonal ligando os dois cantos de um papel de 10 cm.</li>
                              <li><strong>Às Vezes:</strong> Traça uma linha diagonal ligando os dois cantos de um papel de 10 cm.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C55 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C55 - Conta até dez objetos imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve contar até dez seguindo o modelo verbal de um adulto, demonstrando habilidades de contagem e imitação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item55" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item55" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item55" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item55"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item55">
                            <p><strong>Recursos Materiais:</strong> Blocos, contas, feijão, milho, brinquedos, doces, figuras de animais, etc., em número até dez.</p>
                            <p><strong>Condição:</strong> Apresentar à criança até dez objetos e dar o modelo verbal para contar.</p>
                            <p><strong>Resposta:</strong> Dado o modelo verbal “um, dois, três, quatro... dez” ao contar objetos, a criança deverá reproduzi-lo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta até 10 imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Conta até 10, dado o modelo verbal do adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C56 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C56 - Constrói uma ponte com três blocos imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve montar uma ponte utilizando três blocos, seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e imitação.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item56" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item56" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item56" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item56"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item56">
                            <p><strong>Recursos Materiais:</strong> Blocos de tamanhos diferentes que possam ser facilmente encaixados ou empilhados.</p>
                            <p><strong>Condição:</strong> Colocar um bloco ao lado do outro, deixando um espaço menor que um bloco. Colocar o terceiro bloco em cima sem dar pistas adicionais à criança (por exemplo: apontar para a abertura entre os blocos).</p>
                            <p><strong>Resposta:</strong> Construir uma ponte de três blocos = colocar um bloco ao lado do outro e o terceiro em cima desses dois, de tal forma que a ponte permaneça de pé por pelo menos um segundo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não constrói uma ponte de três blocos imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Constrói uma ponte de três blocos imitando um adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C57 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C57 - Emparelha uma sequência ou padrão (tamanho, cor) de blocos ou contas.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e reproduzir sequências ou padrões de objetos baseados em características como tamanho ou cor, demonstrando habilidades de reconhecimento de padrões e coordenação motora.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item57" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item57" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item57" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item57"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item57">
                            <p><strong>Recursos Materiais:</strong> Blocos ou contas de tamanhos e cores diferentes.</p>
                            <p><strong>Condição:</strong> Estabelecer como modelo uma sequência de blocos ou contas de tamanhos ou cores diferentes (por exemplo: uma conta grande vermelha, uma conta pequena azul, uma conta grande vermelha, e assim por diante). Em seguida, apresentar um grupo de contas de cores e tamanhos variados e solicitar à criança que reproduza a sequência modelo.</p>
                            <p><strong>Resposta:</strong> Emparelhar uma sequência padrão (tamanho, cor) de no mínimo 4 contas dentro de 60 segundos por tentativa.</p>
                            <p><strong>Critério:</strong> Emparelhar uma sequência padrão de no mínimo 4 contas dentro de 60 segundos por tentativa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha uma sequência padrão.</li>
                              <li><strong>Às Vezes:</strong> Emparelha uma sequência padrão de no mínimo 4 contas dentro de 60 segundos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C58 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C58 - Copia uma série de (Vs) interligados.</div>
                          <div class="checkbox-interpretation">A criança deve copiar uma série de letras "V" interligadas, demonstrando habilidades avançadas de coordenação motora e reconhecimento de padrões.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item58" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item58" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item58" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item58"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item58">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma folha de papel com uma pauta de 2 cm, contendo nove (Vs) previamente traçados e interligados. Solicitar à criança que reproduza o modelo em uma pauta da mesma folha. Se necessário, dar pistas à criança para completar seu traçado com o mesmo número de (Vs) do modelo.</p>
                            <p><strong>Resposta:</strong> Cada tentativa consiste em copiar uma série de no mínimo nove (Vs) interligados.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não copia uma série de (Vs) interligados.</li>
                              <li><strong>Às Vezes:</strong> Copia uma série de no mínimo 9 (Vs) interligados.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C59 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C59 - Acrescenta perna ou braço em um desenho incompleto de figura humana.</div>
                          <div class="checkbox-interpretation">A criança deve completar um desenho de figura humana acrescentando uma perna ou um braço que está faltando, demonstrando habilidades de desenho e reconhecimento anatômico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item59" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item59" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item59" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item59"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item59">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Apresentar à criança um desenho de figura humana incompleto (com uma perna ou um braço ausente) e solicitar que desenhe o que está faltando.</p>
                            <p><strong>Resposta:</strong> Acrescentar perna ou braço em um desenho incompleto de figura humana.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não acrescenta perna ou braço em um desenho incompleto de figura humana.</li>
                              <li><strong>Às Vezes:</strong> Acrescenta perna ou braço em um desenho incompleto de figura humana.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C60 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C60 - Completa um quebra-cabeças de seis peças sem ensaio e erro.</div>
                          <div class="checkbox-interpretation">A criança deve montar um quebra-cabeças de seis peças de forma eficiente, sem recorrer a tentativas e erros, demonstrando habilidades avançadas de resolução de problemas e reconhecimento de padrões.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item60" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item60" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item60" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item60"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item60">
                            <p><strong>Recursos Materiais:</strong> Quebra-cabeças compostos por uma figura recortada em seis partes de igual tamanho, com linhas retas.</p>
                            <p><strong>Condição:</strong> Ambiente seguro, dando instruções claras para completar o quebra-cabeças sem recorrer a tentativas e erros.</p>
                            <p><strong>Resposta:</strong> Completar um quebra-cabeças de seis peças sem ensaio e erro dentro de 60 segundos por tentativa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não completa um quebra-cabeças de 6 peças.</li>
                              <li><strong>Às Vezes:</strong> Completa um quebra-cabeças de 6 peças, sem ensaio e erro, dentro de 60 segundos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C61 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C61 - Indica se os objetos são iguais ou diferentes.</div>
                          <div class="checkbox-interpretation">A criança deve avaliar e indicar se dois objetos apresentados são iguais ou diferentes, demonstrando habilidades de comparação e discriminação visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item61" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item61" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item61" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item61"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item61">
                            <p><strong>Recursos Materiais:</strong> Dois garfos, dois blocos, dois pentes, etc.</p>
                            <p><strong>Condição:</strong> Apresentar dois objetos à criança, sendo iguais ou diferentes, e em seguida, fazer a pergunta: “Isto é igual a isto?”.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “Isto é igual a isto?”, responder corretamente, afirmando ou negando conforme a situação, dentro de 20 segundos após cada pergunta.</p>
                            <p><strong>Critério:</strong> Apresentar respostas corretas a pelo menos três pares de objetos, sendo pelo menos um dos pares diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não indica se os objetos são iguais ou diferentes.</li>
                              <li><strong>Às Vezes:</strong> Indica se os objetos são iguais ou diferentes em pelo menos 3 pares de objetos, sendo pelo menos 1 dos pares diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C62 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C62 - Desenha um quadrado imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve desenhar a forma geométrica de um quadrado seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e reconhecimento de formas geométricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item62" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item62" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item62" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item62"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item62">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Traçar um quadrado de 2 cm diante da criança, seguindo o modelo de um adulto. O traçado não deve exceder 4 cm e deve ser feito de forma que as linhas se unam formando ângulos aproximadamente retos (L).</p>
                            <p><strong>Resposta:</strong> Traçar um quadrado em imitação de forma que apresente quatro cantos; os ângulos devem ser aproximadamente retos (L) e não redondos (()) ou pontiagudos (V). O quadrado poderá ser maior ou menor que o modelo, desde que tenha pelo menos quatro cantos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não desenha um quadrado imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Desenha um quadrado imitando um adulto, com quatro cantos e ângulos aproximadamente retos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C63 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C63 - Nomeia três cores sendo requisitado.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear três cores diferentes quando solicitado, demonstrando conhecimento básico de cores primárias.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item63" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item63" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item63" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item63"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item63">
                            <p><strong>Recursos Materiais:</strong> Objetos com cores primárias (vermelho, amarelo, azul).</p>
                            <p><strong>Condição:</strong> Apresentar à criança objetos com cores primárias e perguntar: “De que cor é (isto)?”.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “De que cor é (isto)?”, nomear adequadamente, dentro de 20 segundos após cada pergunta.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia adequadamente 3 cores quando solicitado.</li>
                              <li><strong>Às Vezes:</strong> Nomeia adequadamente 3 cores quando solicitado, dentro de 20 segundos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C64 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C64 - Nomeia três formas geométricas: (quadrado, círculo, triângulo).</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear três formas geométricas diferentes quando solicitado, demonstrando reconhecimento de formas básicas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao3_4_item64" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item64" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao3_4_item64" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao3_4_item64"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao3_4_item64">
                            <p><strong>Recursos Materiais:</strong> Formas geométricas = quadrados, círculos e triângulos.</p>
                            <p><strong>Condição:</strong> Apresentar à criança as três formas geométricas e perguntar: “Que forma é essa?” ou “O que é isto?”.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “Que forma é essa?” ou “O que é isto?”, nomear adequadamente, dentro de 20 segundos após cada pergunta por tentativa.</p>
                            <p><strong>Critério:</strong> Nomear três formas geométricas (quadrado, triângulo e círculo) de forma que três pessoas diferentes identifiquem a forma geométrica nomeada.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia adequadamente 3 formas geométricas.</li>
                              <li><strong>Às Vezes:</strong> Nomeia adequadamente 3 formas geométricas, dentro de 20 segundos após a pergunta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 4 - 5 anos - Cognição -->
                    <div id="cog4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4 - 5 anos</h5>
                        
                        <!-- Card C65 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C65 - Apanha um determinado número de objetos ao ser requisitado (de 1 a 5).</div>
                          <div class="checkbox-interpretation">A criança deve pegar um número específico de objetos (entre 1 e 5) quando solicitado, demonstrando compreensão de números e habilidades motoras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item65" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item65" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item65" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item65"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item65">
                            <p><strong>Recursos Materiais:</strong> Contas, doces, bolachas, guardanapos, pratos, xícaras, etc., em número de cinco.</p>
                            <p><strong>Condição:</strong> Pedir à criança que apanhe um determinado número de objetos, sem seguir a sequência numérica (por exemplo, solicitar primeiro três objetos, depois um, cinco, etc.).</p>
                            <p><strong>Resposta:</strong> Apanhar significa pegar com uma ou ambas as mãos, de um a cinco objetos, conforme solicitado.</p>
                            <p><strong>Critério:</strong> Apanhar pelo menos três diferentes números de objetos (de um a cinco) quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não apanha um determinado número de objetos ao ser requisitado.</li>
                              <li><strong>Às Vezes:</strong> Apanha pelo menos 3 diferentes números de objetos de 1 a 5, quando requisitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C66 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C66 - Nomeia cinco texturas diferentes.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear cinco texturas distintas de objetos, demonstrando habilidades de percepção tátil e vocabulário.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item66" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item66" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item66" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item66"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item66">
                            <p><strong>Recursos Materiais:</strong> Objetos com texturas diferentes: lisa, áspera, macia, dura, peluda, sem pelo, mole, etc.</p>
                            <p><strong>Condição:</strong> Apresentar objetos de texturas variadas, pedir para a criança tocar os objetos e perguntar: “Este objeto é liso ou áspero?”, “Este objeto é duro ou macio?”, etc.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “Este objeto é duro ou macio?”, responder adequadamente dentro de 20 segundos após cada pergunta.</p>
                            <p><strong>Critério:</strong> Nomear cinco texturas diferentes de forma que três pessoas identifiquem a textura nomeada.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia 5 texturas diferentes.</li>
                              <li><strong>Às Vezes:</strong> Nomeia 5 texturas diferentes dentro de 20 segundos após cada pergunta, de forma que 3 pessoas identifiquem a textura nomeada.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C67 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C67 - Copia um triângulo ao ser requisitado.</div>
                          <div class="checkbox-interpretation">A criança deve reproduzir um desenho de triângulo apresentado por um adulto, demonstrando habilidades de coordenação motora e reconhecimento de formas geométricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item67" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item67" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item67" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item67"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item67">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Dar à criança um papel com um desenho de um triângulo equilátero (linhas de quatro cm) previamente traçado. Pedir à criança que reproduza o modelo.</p>
                            <p><strong>Resposta:</strong> O triângulo pode ser maior ou menor que o modelo. Deve apresentar três cantos, com ângulos de aproximadamente 45º, composto por linhas pontiagudas e não redondas. A figura deve ser fechada, sem interrupções.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não copia um triângulo ao ser requisitado.</li>
                              <li><strong>Às Vezes:</strong> Copia um triângulo ao ser requisitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C68 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C68 - Recorda-se de quatro objetos que haviam sido vistos em uma figura.</div>
                          <div class="checkbox-interpretation">A criança deve lembrar e nomear quatro objetos que foram apresentados em uma figura anteriormente mostrada, demonstrando habilidades de memória e reconhecimento.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item68" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item68" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item68" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item68"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item68">
                            <p><strong>Recursos Materiais:</strong> Figuras de livros infantis ou revistas.</p>
                            <p><strong>Condição:</strong> Mostrar à criança a figura por 30 segundos, esconder a figura ou fechar o livro, e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Recordar-se significa nomear quatro objetos de uma figura que foi retirada de seu campo visual.</p>
                            <p><strong>Critério:</strong> Nomear quatro objetos que haviam sido vistos em uma figura, de forma que três pessoas diferentes identifiquem o objeto nomeado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia objetos que foram vistos em uma figura que foi retirada de seu campo visual.</li>
                              <li><strong>Às Vezes:</strong> Nomeia 4 objetos que foram vistos em uma figura que foi retirada de seu campo visual, de forma que 3 pessoas identifiquem o objeto nomeado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C69 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C69 - Diz o momento do dia associado a cada atividade.</div>
                          <div class="checkbox-interpretation">A criança deve associar atividades específicas aos momentos do dia (dia ou noite), demonstrando compreensão temporal e rotina diária.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item69" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item69" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item69" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item69"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item69">
                            <p><strong>Recursos Materiais:</strong> Não especificados. Sugere-se utilizar figuras ou cartões representando atividades diurnas e noturnas.</p>
                            <p><strong>Condição:</strong> Pedir à criança que associe atividades específicas aos momentos do dia, variando a ordem das palavras "dia" e "noite" nas perguntas.</p>
                            <p><strong>Resposta:</strong> Dizer o momento do dia associado a uma atividade, como "dia" ou "noite". Exemplos de atividades: acordar, brincar, dormir, ir à escola, chegar do trabalho, etc.</p>
                            <p><strong>Critério:</strong> Dizer pelo menos duas atividades, sendo que cada uma deve estar associada com momentos: dia e noite.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz o momento do dia associado a uma atividade.</li>
                              <li><strong>Às Vezes:</strong> Diz pelo menos duas atividades, sendo que cada uma deve estar associada com momentos: dia e noite.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C70 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C70 - Repete rimas familiares.</div>
                          <div class="checkbox-interpretation">A criança deve repetir rimas ou canções familiares, demonstrando memorização e habilidades linguísticas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item70" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item70" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item70" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item70"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item70">
                            <p><strong>Recursos Materiais:</strong> Não exige material específico. Utilizar rimas ou canções familiares à criança, como “Um, dois, feijão com arroz” ou “Parabéns a você”.</p>
                            <p><strong>Condição:</strong> Pedir ao familiar que identifique quais rimas ou canções são familiares à criança. Dar o modelo verbal, pelo menos duas vezes à criança, e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Repetir rimas familiares, ou seja, repetir pelo menos de oito a dez palavras de uma rima, canção infantil familiar ou comercial de TV, por tentativa.</p>
                            <p><strong>Critério:</strong> Repetir pelo menos duas rimas diferentes familiares ou canções de tal forma que três pessoas identifiquem as mesmas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não repete rimas familiares.</li>
                              <li><strong>Às Vezes:</strong> Repete pelo menos de 8 a 10 palavras de rimas familiares em pelo menos 2 rimas diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C71 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C71 - Emparelha símbolos (letras e números).</div>
                          <div class="checkbox-interpretation">A criança deve combinar símbolos iguais de letras e números, demonstrando reconhecimento de caracteres alfanuméricos e habilidades de correspondência.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item71" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item71" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item71" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item71"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item71">
                            <p><strong>Recursos Materiais:</strong> Conjuntos iguais de pelo menos cinco cartões de números e letras.</p>
                            <p><strong>Condição:</strong> Apresentar à criança um conjunto de cinco cartões de números ou letras (por exemplo: 2, 3, 4, 5, 1). Em seguida, entregar à criança um conjunto idêntico, pedindo que emparelhe (colocando juntos os cartões idênticos). A cada tentativa, alterar a posição de todos os cartões.</p>
                            <p><strong>Resposta:</strong> Emparelhar pelo menos cinco símbolos (letras e números) dentro de 60 segundos por tentativa.</p>
                            <p><strong>Critério:</strong> Emparelhar, no total de três tentativas, 15 símbolos, sendo pelo menos um conjunto de cinco símbolos referente a números e outro conjunto referente a letras.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha símbolos.</li>
                              <li><strong>Às Vezes:</strong> Emparelha pelo menos 15 símbolos, sendo um conjunto de 5 letras, outro de 5 números e o outro conjunto fica a critério do avaliador.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C72 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C72 - Desenha a figura humana (cabeça, tronco, quatro membros).</div>
                          <div class="checkbox-interpretation">A criança deve desenhar uma figura humana completa, incluindo cabeça, tronco e quatro membros, demonstrando habilidades de desenho e reconhecimento anatômico básico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item72" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item72" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item72" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item72"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item72">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Providenciar lápis e papel à criança e solicitar que desenhe a figura humana. Se necessário, fornecer um modelo.</p>
                            <p><strong>Resposta:</strong> O desenho da figura humana deve conter: cabeça com cabelo, dois olhos, nariz e boca, um tronco e quatro membros. A figura deve ser facilmente identificável como um ser humano, com os membros ligados ao tronco. Os membros não precisam estar em duas dimensões.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não desenha a figura humana.</li>
                              <li><strong>Às Vezes:</strong> Desenha uma figura humana identificável com todos os membros ligados ao tronco.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C73 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C73 - Identifica o objeto que está colocado no meio, em primeiro e em último lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição dos objetos em uma sequência (meio, primeiro e último), demonstrando compreensão de posições espaciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item73" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item73" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item73" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item73"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item73">
                            <p><strong>Recursos Materiais:</strong> Livro de três páginas ou brinquedos enfileirados.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos enfileirados e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear o objeto que está colocado no meio, em primeiro e em último lugar por tentativa.</p>
                            <p><strong>Critérios:</strong> Não indica a posição dos objetos quando solicitado; Indica a posição correta do objeto quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C74 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C74 - Identifica o objeto que está colocado no meio, em primeiro e em último lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição dos objetos em uma sequência (meio, primeiro e último), demonstrando compreensão de posições espaciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item74" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item74" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item74" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item74"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item74">
                            <p><strong>Recursos Materiais:</strong> Não especificados. Sugere-se utilizar objetos ou brinquedos enfileirados ou figuras em sequência.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos enfileirados e solicitar que identifique qual está no meio, qual está em primeiro e qual está em último lugar.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear o objeto que está colocado no meio, em primeiro e em último lugar por tentativa.</p>
                            <p><strong>Critérios:</strong> Não identifica a posição dos objetos quando solicitado; Indica a posição correta do objeto quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C75 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C75 - Emparelha símbolos (letras e números).</div>
                          <div class="checkbox-interpretation">A criança deve combinar símbolos iguais de letras e números, demonstrando reconhecimento de caracteres alfanuméricos e habilidades de correspondência.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item75" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item75" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item75" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item75"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item75">
                            <p><strong>Recursos Materiais:</strong> Conjuntos iguais de pelo menos cinco cartões de números e letras.</p>
                            <p><strong>Condição:</strong> Apresentar à criança um conjunto de cinco cartões de números ou letras (por exemplo: 2, 3, 4, 5, 1). Em seguida, entregar à criança um conjunto idêntico, pedindo que emparelhe (colocando juntos os cartões idênticos). A cada tentativa, alterar a posição de todos os cartões.</p>
                            <p><strong>Resposta:</strong> Emparelhar pelo menos cinco símbolos (letras e números) dentro de 60 segundos por tentativa.</p>
                            <p><strong>Critério:</strong> Emparelhar, no total de três tentativas, 15 símbolos, sendo pelo menos um conjunto de cinco símbolos referente a números e outro conjunto referente a letras.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha símbolos.</li>
                              <li><strong>Às Vezes:</strong> Emparelha pelo menos 15 símbolos, sendo um conjunto de 5 letras, outro de 5 números e o outro conjunto fica a critério do avaliador.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C76 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C76 - Identifica o objeto que está colocado no meio, em primeiro e em último lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição dos objetos em uma sequência (meio, primeiro e último), demonstrando compreensão de posições espaciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item76" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item76" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item76" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item76"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item76">
                            <p><strong>Recursos Materiais:</strong> Livro de três páginas ou brinquedos enfileirados.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos enfileirados e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear o objeto que está colocado no meio, em primeiro e em último lugar por tentativa.</p>
                            <p><strong>Critérios:</strong> Não identifica a posição dos objetos quando solicitado; Identifica a posição correta do objeto quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C77 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C77 - Relata cinco principais fatos de uma história contada três vezes.</div>
                          <div class="checkbox-interpretation">A criança deve lembrar e descrever cinco fatos importantes de uma história familiar ou programa de televisão, demonstrando habilidades de compreensão e memória narrativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item77" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item77" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item77" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item77"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item77">
                            <p><strong>Recursos Materiais:</strong> Histórias infantis familiares como “Chapeuzinho Vermelho”, “Os Três Porquinhos”, “João e Maria”, etc.</p>
                            <p><strong>Condição:</strong> Após contar uma pequena história três vezes, fazer perguntas à criança do tipo: “Quem a Chapeuzinho encontrou deitado na cama da vovozinha?”, etc.</p>
                            <p><strong>Resposta:</strong> Relatar cinco principais fatos, ou seja, cinco acontecimentos, cinco ações ou situações de uma história contada três vezes, dentro de 20 segundos após cada pergunta realizada pelo adulto, por tentativa.</p>
                            <p><strong>Critério:</strong> Relatar cinco principais fatos de uma história que foi contada três vezes, dentro de 20 segundos após cada pergunta.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não relata principais fatos de uma história.</li>
                              <li><strong>Às Vezes:</strong> Relata 5 principais fatos de uma história que foi contada 3 vezes, dentro de 20 segundos após cada pergunta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C78 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C78 - Desenha a figura humana (cabeça, tronco, quatro membros).</div>
                          <div class="checkbox-interpretation">A criança deve desenhar uma figura humana completa, incluindo cabeça, tronco e quatro membros, demonstrando habilidades de desenho e reconhecimento anatômico básico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item78" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item78" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item78" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item78"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item78">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Providenciar lápis e papel à criança e solicitar que desenhe a figura humana. Se necessário, fornecer um modelo.</p>
                            <p><strong>Resposta:</strong> O desenho da figura humana deve conter: cabeça com cabelo, dois olhos, nariz e boca, um tronco e quatro membros. A figura deve ser facilmente identificável como um ser humano, com os membros ligados ao tronco. Os membros não precisam estar em duas dimensões.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não desenha a figura humana.</li>
                              <li><strong>Às Vezes:</strong> Desenha uma figura humana identificável com todos os membros ligados ao tronco.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C79 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C79 - Canta cinco estrofes de uma canção.</div>
                          <div class="checkbox-interpretation">A criança deve cantar cinco estrofes de uma canção familiar, demonstrando memorização e habilidades linguísticas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item79" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item79" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item79" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item79"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item79">
                            <p><strong>Recursos Materiais:</strong> Não exige material específico. Utilizar canções familiares como “Atirei o pau no gato” ou “Ciranda, cirandinha”.</p>
                            <p><strong>Condição:</strong> Pedir à criança que cante uma canção familiar. Exemplo: “Atirei o pau no gato”, “Ciranda, cirandinha”.</p>
                            <p><strong>Resposta:</strong> Cantar cinco estrofes de uma canção.</p>
                            <p><strong>Critério:</strong> Cantar pelo menos cinco estrofes de uma canção familiar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não canta estrofes de uma canção.</li>
                              <li><strong>Às Vezes:</strong> Canta 5 estrofes de uma canção familiar.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C80 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C80 - Constrói uma pirâmide de dez blocos imitando um adulto.</div>
                          <div class="checkbox-interpretation">A criança deve montar uma pirâmide utilizando dez blocos, seguindo o modelo de um adulto, demonstrando habilidades de coordenação motora e compreensão de estruturas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item80" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item80" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item80" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item80"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item80">
                            <p><strong>Recursos Materiais:</strong> Blocos de 5 a 7 cm de tamanho.</p>
                            <p><strong>Condição:</strong> Pedir à criança que construa uma pirâmide de dez blocos, imitando o modelo de um adulto. A pirâmide deve ser construída da seguinte forma: colocar quatro blocos lado a lado, depois três blocos acima desses, seguidos por dois e, por fim, um bloco no topo, de forma que a pirâmide permaneça de pé por pelo menos um segundo.</p>
                            <p><strong>Resposta:</strong> Construir uma pirâmide de dez blocos = colocar um bloco ao lado do outro e os demais em camadas superiores, seguindo a ordem correta.</p>
                            <p><strong>Critério:</strong> Constrói uma pirâmide com 10 blocos, imitando um adulto, de forma que permaneça em pé por pelo menos 1 segundo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não constrói uma pirâmide imitando um adulto.</li>
                              <li><strong>Às Vezes:</strong> Constrói uma pirâmide com 10 blocos, imitando um adulto, de forma que permaneça em pé por pelo menos 1 segundo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C81 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C81 - Nomeia ou aponta para a parte ausente na figura de um objeto.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e indicar qual parte está faltando em uma figura de objeto ou animal, demonstrando habilidades de observação e compreensão estrutural.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item81" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item81" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item81" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item81"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item81">
                            <p><strong>Recursos Materiais:</strong> Figuras ou desenhos de animais (sem cabeça ou sem uma das partes ou sem rabo) ou objetos com partes ausentes (como uma casa sem teto).</p>
                            <p><strong>Condição:</strong> Pedir à criança que nomeie ou aponte para a parte ausente na figura de um objeto.</p>
                            <p><strong>Resposta:</strong> Nomear ou apontar para a parte ausente na figura de um objeto.</p>
                            <p><strong>Critérios:</strong> Não nomeia ou aponta para a parte ausente na figura de um objeto; Nomeia ou aponta para a parte ausente na figura de um objeto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia ou aponta para a parte ausente na figura de um objeto.</li>
                              <li><strong>Às Vezes:</strong> Nomeia ou aponta para a parte ausente na figura de um objeto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C82 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C82 - Conta de 1 a 20.</div>
                          <div class="checkbox-interpretation">A criança deve contar de 1 a 20, demonstrando habilidades avançadas de contagem e reconhecimento numérico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item82" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item82" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item82" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item82"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item82">
                            <p><strong>Recursos Materiais:</strong> 20 objetos para contar (como blocos, contas, feijão, milho, brinquedos, doces, figuras de animais, etc.).</p>
                            <p><strong>Condição:</strong> Apresentar à criança 20 objetos para serem contados.</p>
                            <p><strong>Resposta:</strong> A criança deverá apontar ou separar cada um dos objetos ao contá-lo.</p>
                            <p><strong>Critério:</strong> Conta objetos de 1 a 20, apontando ou separando ao contar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta de 1 a 20.</li>
                              <li><strong>Às Vezes:</strong> Conta objetos de 1 a 20, apontando ou separando ao contar.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C83 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C83 - Identifica o objeto que está colocado no meio, em primeiro e em último lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição dos objetos em uma sequência (meio, primeiro e último), demonstrando compreensão de posições espaciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item83" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item83" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item83" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item83"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item83">
                            <p><strong>Recursos Materiais:</strong> Livro de três páginas ou brinquedos enfileirados.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos enfileirados e solicitar a resposta.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear o objeto que está colocado no meio, em primeiro e em último lugar por tentativa.</p>
                            <p><strong>Critérios:</strong> Não identifica a posição dos objetos quando solicitado; Identifica a posição correta do objeto quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C84 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C84 - Nomeia ou aponta para a parte ausente na figura de um objeto.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e indicar qual parte está faltando em uma figura de objeto ou animal, demonstrando habilidades de observação e compreensão estrutural.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item84" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item84" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item84" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item84"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item84">
                            <p><strong>Recursos Materiais:</strong> Figuras ou desenhos de animais (sem cabeça, sem uma das partes ou sem rabo) ou objetos com partes ausentes (como uma casa sem teto).</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma figura de um objeto ou animal com uma parte ausente e solicitar que nomeie ou aponte para a parte que está faltando.</p>
                            <p><strong>Resposta:</strong> Nomear ou apontar para a parte ausente na figura de um objeto.</p>
                            <p><strong>Critério:</strong> Responder adequadamente, nomeando ou apontando para a parte ausente na figura de um objeto.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia ou aponta para a parte ausente na figura de um objeto.</li>
                              <li><strong>Às Vezes:</strong> Nomeia ou aponta para a parte ausente na figura de um objeto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C85 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C85 - Conta de 1 a 20.</div>
                          <div class="checkbox-interpretation">A criança deve contar de 1 a 20, demonstrando habilidades avançadas de contagem e reconhecimento numérico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item85" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item85" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item85" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item85"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item85">
                            <p><strong>Recursos Materiais:</strong> 20 objetos para contar (como blocos, contas, feijão, milho, brinquedos, doces, figuras de animais, etc.).</p>
                            <p><strong>Condição:</strong> Apresentar à criança 20 objetos para serem contados.</p>
                            <p><strong>Resposta:</strong> A criança deverá apontar ou separar cada um dos objetos ao contá-lo.</p>
                            <p><strong>Critério:</strong> Conta objetos de 1 a 20, apontando ou separando ao contar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta de 1 a 20.</li>
                              <li><strong>Às Vezes:</strong> Conta objetos de 1 a 20, apontando ou separando ao contar.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C86 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C86 - Identifica o objeto que está colocado no meio, em primeiro e em último lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição dos objetos em uma sequência (meio, primeiro e último), demonstrando compreensão de posições espaciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao4_5_item86" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item86" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao4_5_item86" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao4_5_item86"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao4_5_item86">
                            <p><strong>Recursos Materiais:</strong> Livro de três páginas ou brinquedos enfileirados.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos enfileirados e solicitar que identifique qual está no meio, qual está em primeiro e qual está em último lugar.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear o objeto que está colocado no meio, em primeiro e em último lugar por tentativa.</p>
                            <p><strong>Critério:</strong> Identificar a posição correta dos objetos quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 5 - 6 anos - Cognição -->
                    <div id="cog5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5 - 6 anos</h5>
                        
                        <!-- Card C87 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C87 - Conta até 20 objetos e responde adequadamente à pergunta: “Quantos objetos você contou?”.</div>
                          <div class="checkbox-interpretation">A criança deve contar até 20 objetos e responder corretamente à pergunta sobre a quantidade contada, demonstrando habilidades avançadas de contagem e memória.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item87" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item87" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item87" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item87"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item87">
                            <p><strong>Recursos Materiais:</strong> 20 pedaços de esponja, 20 tampas de garrafa, 20 blocos de madeira, etc.</p>
                            <p><strong>Condição:</strong> Apresentar 20 objetos à criança e pedir que ela os conte. Após a contagem, perguntar: “Quantos objetos você contou?”. Variar os objetos a serem contados para garantir a generalização da habilidade.</p>
                            <p><strong>Resposta:</strong> Contar até 20 objetos e responder adequadamente à pergunta: “Quantos objetos você contou?”.</p>
                            <p><strong>Critério:</strong> Responder adequadamente à pergunta, contando até 20 objetos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta até 20 e não responde à pergunta “quantos você contou?”.</li>
                              <li><strong>Às Vezes:</strong> Conta até 20 e responde adequadamente à pergunta “quantos você contou?”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C88 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C88 - Nomeia 10 numerais.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear os numerais de 1 a 10, demonstrando reconhecimento numérico e vocabulário avançado.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item88" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item88" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item88" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item88"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item88">
                            <p><strong>Recursos Materiais:</strong> Numerais de 1 a 10 escritos ou colocados em cartões ou colados em blocos.</p>
                            <p><strong>Condição:</strong> Apresentar à criança um cartão com um numeral e perguntar: “Que número é este?”. Os cartões devem ser apresentados sem uma ordem numérica para evitar dicas adicionais.</p>
                            <p><strong>Resposta:</strong> Nomear os numerais de 1 a 10 escritos em cartões, dentro de 20 segundos após cada pergunta do adulto, por tentativa.</p>
                            <p><strong>Critério:</strong> Nomear 10 numerais corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia numerais de 1 a 10.</li>
                              <li><strong>Às Vezes:</strong> Nomeia os numerais de 1 a 10, dentro de 20 segundos após a pergunta do adulto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C89 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C89 - Identifica qual a sua esquerda e qual sua direita.</div>
                          <div class="checkbox-interpretation">A criança deve distinguir e identificar corretamente os lados esquerdo e direito de si mesma, demonstrando compreensão de orientações espaciais básicas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item89" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item89" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item89" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item89"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item89">
                            <p><strong>Recursos Materiais:</strong> Não requer materiais específicos.</p>
                            <p><strong>Condição:</strong> Pedir à criança que identifique qual lado é a esquerda e qual é a direita, podendo utilizar gestos ou solicitações específicas como: “Leve o braço direito para cima”, “Mostre o pé esquerdo”.</p>
                            <p><strong>Resposta:</strong> Identificar significa nomear, apontar ou levantar o braço ou perna direita e esquerda por tentativa.</p>
                            <p><strong>Critério:</strong> Identificar corretamente ambos os lados esquerdo e direito quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica qual a sua esquerda e qual a sua direita.</li>
                              <li><strong>Às Vezes:</strong> Identifica qual a sua esquerda e qual a sua direita.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C90 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C90 - Diz as vogais em ordem.</div>
                          <div class="checkbox-interpretation">A criança deve recitar as vogais (A, E, I, O, U) em ordem correta, demonstrando reconhecimento fonético e habilidades linguísticas avançadas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item90" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item90" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item90" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item90"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item90">
                            <p><strong>Recursos Materiais:</strong> Não requer materiais específicos.</p>
                            <p><strong>Condição:</strong> Pedir à criança que recite as vogais em ordem, por exemplo: “A, E, I, O, U”. Caso a criança não consiga recitar em ordem, fornecer pistas ou ajudar a sequência.</p>
                            <p><strong>Resposta:</strong> Dizer as vogais em ordem corretamente, por tentativa.</p>
                            <p><strong>Critério:</strong> Dizer as vogais em ordem corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz as vogais em ordem.</li>
                              <li><strong>Às Vezes:</strong> Diz as vogais em ordem corretamente.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C91 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C91 - Escreve seu nome em letra de forma.</div>
                          <div class="checkbox-interpretation">A criança deve escrever seu próprio nome utilizando letras de forma (maiúsculas), demonstrando habilidades de escrita básica e reconhecimento das letras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item91" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item91" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item91" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item91"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item91">
                            <p><strong>Recursos Materiais:</strong> Lápis e papel.</p>
                            <p><strong>Condição:</strong> Providenciar lápis e papel à criança e solicitar que escreva seu próprio nome em letra de forma. Se necessário, fornecer um modelo para a criança copiar.</p>
                            <p><strong>Resposta:</strong> Escrever seu nome em letra de forma.</p>
                            <p><strong>Critério:</strong> Escrever seu nome em letra de forma corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não escreve seu nome em letra de forma.</li>
                              <li><strong>Às Vezes:</strong> Escreve seu nome em letra de forma.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C92 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C92 - Nomeia cinco letras do alfabeto.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear cinco letras do alfabeto, demonstrando reconhecimento das letras e habilidades linguísticas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item92" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item92" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item92" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item92"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item92">
                            <p><strong>Recursos Materiais:</strong> Letras do alfabeto com as quais a criança está familiarizada ou que sejam muito diferentes (por exemplo: um cartão com a letra O, outro com T, M, B, A).</p>
                            <p><strong>Condição:</strong> Apresentar cartões com letras à criança e perguntar: “Que letra é esta?” ou “O que está escrito aqui?”. Os cartões devem ser apresentados sem ordem numérica para evitar dicas adicionais.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “Que letra é essa?”, responder adequadamente dentro de 20 segundos após cada pergunta, por tentativa.</p>
                            <p><strong>Critério:</strong> Nomear cinco letras do alfabeto corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia 5 letras do alfabeto.</li>
                              <li><strong>Às Vezes:</strong> Nomeia 5 letras do alfabeto, dentro de 20 segundos após a pergunta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C93 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C93 - Ordena objetos em sequência de comprimento e largura.</div>
                          <div class="checkbox-interpretation">A criança deve organizar objetos em ordem crescente ou decrescente com base em suas dimensões de comprimento e largura, demonstrando habilidades de classificação e reconhecimento espacial.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item93" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item93" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item93" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item93"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item93">
                            <p><strong>Recursos Materiais:</strong> Tiras de papel, macarrão, palha de milho.</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma série de objetos com diferentes comprimentos e larguras. Pedir que ordene os objetos do maior para o menor ou vice-versa, com base em comprimento e largura.</p>
                            <p><strong>Resposta:</strong> Ordenar dez objetos que aumentem de 1,5 cm de largura e comprimento em sequência do maior para o menor ou vice-versa, por tentativa.</p>
                            <p><strong>Critério:</strong> Ordenar objetos por comprimento e largura corretamente, tanto do maior para o menor quanto do menor para o maior.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não ordena objetos em sequência de comprimento e largura.</li>
                              <li><strong>Às Vezes:</strong> Ordena objetos por comprimento e largura do maior para o menor e vice-versa.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C94 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C94 - Nomeia as letras maiúsculas do alfabeto.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear as letras maiúsculas do alfabeto, demonstrando reconhecimento de caracteres alfanuméricos em forma maiúscula.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item94" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item94" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item94" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item94"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item94">
                            <p><strong>Recursos Materiais:</strong> Cartões com letras do alfabeto em maiúsculas.</p>
                            <p><strong>Condição:</strong> Apresentar cada cartão à criança com a pergunta: “Que letra é essa?”. Os cartões devem ser apresentados de forma aleatória para evitar a memorização por ordem.</p>
                            <p><strong>Resposta:</strong> Nomear todas as letras maiúsculas do alfabeto, dentro de 20 segundos após cada apresentação de letra.</p>
                            <p><strong>Critério:</strong> Nomear todas as letras maiúsculas do alfabeto corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia as letras do alfabeto.</li>
                              <li><strong>Às Vezes:</strong> Nomeia todas as letras maiúsculas do alfabeto, dentro de 20 segundos após a apresentação de cada letra.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C95 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C95 - Coloca numerais de 1 a 10 na sequência correta.</div>
                          <div class="checkbox-interpretation">A criança deve ordenar os numerais de 1 a 10 na sequência correta, demonstrando compreensão da ordem numérica e habilidades de organização.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item95" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item95" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item95" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item95"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item95">
                            <p><strong>Recursos Materiais:</strong> Numerais de 1 a 10 escritos em cartões separados.</p>
                            <p><strong>Condição:</strong> Apresentar os cartões de numerais misturados à criança e pedir para ela ordená-los na sequência correta de 1 a 10.</p>
                            <p><strong>Resposta:</strong> Colocar numerais de 1 a 10 na sequência correta.</p>
                            <p><strong>Critério:</strong> Colocar numerais de 1 a 10 na sequência correta.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não coloca numerais de 1 a 10 na sequência correta.</li>
                              <li><strong>Às Vezes:</strong> Coloca numerais de 1 a 10 na sequência correta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C96 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C96 - Identifica a posição de objetos como estando em 1º, 2º e 3º lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição de objetos em uma sequência específica (primeiro, segundo e terceiro lugar), demonstrando habilidades de reconhecimento de ordem e posição.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item96" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item96" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item96" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item96"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item96">
                            <p><strong>Recursos Materiais:</strong> Sequência de três ilustrações ou objetos enfileirados.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos ou ilustrações enfileirados e solicitar que identifique qual está em 1º, 2º e 3º lugar.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear a posição de objetos como estando em 1º, 2º e 3º lugar por tentativa.</p>
                            <p><strong>Critério:</strong> Identificar corretamente a posição dos objetos quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C97 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C97 - Nomeia as letras minúsculas do alfabeto.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear as letras minúsculas do alfabeto, demonstrando reconhecimento de caracteres alfanuméricos em forma minúscula.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item97" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item97" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item97" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item97"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item97">
                            <p><strong>Recursos Materiais:</strong> Cartões com letras do alfabeto em minúsculas.</p>
                            <p><strong>Condição:</strong> Apresentar cada cartão à criança com a pergunta: “Que letra é esta?”. Os cartões devem ser apresentados de forma aleatória para evitar a memorização por ordem.</p>
                            <p><strong>Resposta:</strong> Nomear todas as letras minúsculas do alfabeto, dentro de 20 segundos após cada pergunta.</p>
                            <p><strong>Critério:</strong> Nomear todas as letras minúsculas do alfabeto corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia as letras do alfabeto.</li>
                              <li><strong>Às Vezes:</strong> Nomeia todas as letras minúsculas do alfabeto, dentro de 20 segundos após a apresentação de cada letra.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C98 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C98 - Emparelha letras maiúsculas com minúsculas.</div>
                          <div class="checkbox-interpretation">A criança deve combinar corretamente as letras maiúsculas com suas correspondentes minúsculas, demonstrando reconhecimento alfabético e habilidades de correspondência visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item98" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item98" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item98" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item98"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item98">
                            <p><strong>Recursos Materiais:</strong> 23 cartões com as letras maiúsculas e 23 cartões com as letras minúsculas.</p>
                            <p><strong>Condição:</strong> Apresentar à criança um conjunto de cartões com letras maiúsculas e minúsculas misturadas, e solicitar que emparelhe cada letra maiúscula com sua correspondente minúscula.</p>
                            <p><strong>Resposta:</strong> Emparelhar significa colocar os cartões com letras maiúsculas próximos aos cartões com as letras minúsculas correspondentes.</p>
                            <p><strong>Critério:</strong> Emparelhar corretamente todas as letras maiúsculas com suas correspondentes minúsculas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emparelha letras maiúsculas e minúsculas.</li>
                              <li><strong>Às Vezes:</strong> Emparelha letras maiúsculas e minúsculas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C99 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C99 - Aponta para numerais de 1 a 25.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente os numerais de 1 a 25 quando solicitado, demonstrando reconhecimento numérico e habilidades de correspondência visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item99" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item99" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item99" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item99"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item99">
                            <p><strong>Recursos Materiais:</strong> Numerais de 1 a 25 escritos em cartões separados.</p>
                            <p><strong>Condição:</strong> Apresentar os cartões de numerais à criança e fazer perguntas como: “Me mostre o número 18.”, “Aponte para o número 6”.</p>
                            <p><strong>Resposta:</strong> Frente à ordem verbal: “Aponte para o número X”, responder adequadamente, dentro de 20 segundos após cada pergunta.</p>
                            <p><strong>Critério:</strong> Apontar para numerais de 1 a 25 corretamente, dentro de 20 segundos após a pergunta.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para numerais de 1 a 25.</li>
                              <li><strong>Às Vezes:</strong> Aponta para numerais de 1 a 25 corretamente, dentro de 20 segundos após a pergunta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C100 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C100 - Copia um losango.</div>
                          <div class="checkbox-interpretation">A criança deve reproduzir um desenho de losango, demonstrando habilidades de coordenação motora fina e reconhecimento de formas geométricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item100" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item100" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item100" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item100"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item100">
                            <p><strong>Recursos Materiais:</strong> Folha com desenho de um losango de 4 cm.</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma folha de papel com um losango de 4 cm, previamente traçado, e solicitar que ela copie o desenho.</p>
                            <p><strong>Resposta:</strong> O losango deverá ser formado por linhas que se interceptam, com ângulos nítidos. A dimensão importante a ser avaliada é se o losango repousa sobre uma das pontas. O desenho deve ter ângulos pontiagudos, não redondos ou obtusos.</p>
                            <p><strong>Critério:</strong> Copiar um losango corretamente, seguindo o modelo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não copia um losango.</li>
                              <li><strong>Às Vezes:</strong> Copia um losango corretamente.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C101 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C101 - Completa um labirinto simples.</div>
                          <div class="checkbox-interpretation">A criança deve completar um labirinto simples, demonstrando habilidades de resolução de problemas e coordenação motora fina.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item101" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item101" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item101" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item101"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item101">
                            <p><strong>Recursos Materiais:</strong> Folha com labirinto simples.</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma folha com um labirinto simples e solicitar que ela o complete.</p>
                            <p><strong>Resposta:</strong> Completar um labirinto simples, seguindo as linhas corretas para alcançar o final.</p>
                            <p><strong>Critério:</strong> Completar um labirinto simples corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não completa um labirinto simples.</li>
                              <li><strong>Às Vezes:</strong> Completa um labirinto simples.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C102 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C102 - Diz os dias da semana em ordem.</div>
                          <div class="checkbox-interpretation">A criança deve recitar os dias da semana na ordem correta, demonstrando compreensão temporal e conhecimento sobre a rotina semanal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item102" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item102" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item102" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item102"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item102">
                            <p><strong>Recursos Materiais:</strong> Não requer materiais específicos.</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “Quais são os dias da semana em ordem?”. Se a criança não responder em ordem, dar pistas como: “Que dia vem depois de terça?”.</p>
                            <p><strong>Resposta:</strong> Dizer os dias da semana em ordem corretamente.</p>
                            <p><strong>Critério:</strong> Diz os dias da semana em ordem corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz os dias da semana em ordem.</li>
                              <li><strong>Às Vezes:</strong> Diz os dias da semana em ordem corretamente.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C103 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C103 - Soma e subtrai combinações de até três elementos.</div>
                          <div class="checkbox-interpretation">A criança deve realizar operações de soma e subtração com até três elementos, demonstrando habilidades matemáticas básicas e compreensão de operações aritméticas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item103" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item103" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item103" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item103"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item103">
                            <p><strong>Recursos Materiais:</strong> Blocos, doces, passas, brinquedos, etc., em número de até três.</p>
                            <p><strong>Condição:</strong> Dispor três objetos sobre uma superfície e realizar operações de adição ou subtração. Por exemplo, retirar dois objetos de um grupo de três e perguntar: “Quantos objetos sobraram?”. Ou adicionar dois objetos a um grupo de um e perguntar: “Quantos objetos temos agora?”. Variar o número de objetos para garantir a generalização das habilidades.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta do adulto, responder adequadamente, somando e subtraindo combinações de até três elementos, dentro de 20 segundos após a pergunta.</p>
                            <p><strong>Critério:</strong> Responder pelo menos duas perguntas (uma de adição e uma de subtração).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não soma e subtrai combinações de até 3 elementos.</li>
                              <li><strong>Às Vezes:</strong> Soma e subtrai combinações de até 3 elementos, dentro de 20 segundos após a pergunta, respondendo pelo menos 1 de adição e 1 de subtração.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C104 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C104 - Diz o mês e o dia de seu aniversário.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e dizer corretamente o mês e o dia em que comemora seu aniversário, demonstrando compreensão temporal e conhecimento sobre datas pessoais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item104" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item104" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item104" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item104"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item104">
                            <p><strong>Recursos Materiais:</strong> Não requer materiais específicos.</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “Quando você faz aniversário?”. Isso pode ser feito em diversas ocasiões para reforçar a resposta correta.</p>
                            <p><strong>Resposta:</strong> Dizer o mês e o dia de seu aniversário.</p>
                            <p><strong>Critério:</strong> Dizer o mês e o dia de seu aniversário corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz o mês e o dia de seu aniversário.</li>
                              <li><strong>Às Vezes:</strong> Diz o mês e o dia de seu aniversário.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C105 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C105 - Lê 10 palavras impressas.</div>
                          <div class="checkbox-interpretation">A criança deve ler corretamente 10 palavras que são familiares ou simples, demonstrando habilidades de leitura e reconhecimento de palavras básicas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item105" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item105" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item105" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item105"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item105">
                            <p><strong>Recursos Materiais:</strong> Palavras impressas conhecidas da criança, como seu nome, vaca, ovo, uva, eu, vovó, oi, etc.</p>
                            <p><strong>Condição:</strong> Apresentar à criança 10 palavras conhecidas impressas em cartões separados e solicitar que ela as leia em voz alta.</p>
                            <p><strong>Resposta:</strong> Ler 10 palavras conhecidas impressas.</p>
                            <p><strong>Critério:</strong> Ler 10 palavras conhecidas corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não lê palavras conhecidas.</li>
                              <li><strong>Às Vezes:</strong> Lê 10 palavras conhecidas impressas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C106 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C106 - Identifica o objeto que está colocado no meio, em primeiro e em último lugar.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente a posição de objetos em uma sequência específica (primeiro, segundo e terceiro lugar), demonstrando habilidades de reconhecimento de ordem e posição.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item106" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item106" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item106" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item106"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item106">
                            <p><strong>Recursos Materiais:</strong> Sequência de três ilustrações ou objetos enfileirados.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três objetos ou ilustrações enfileirados e solicitar que identifique qual está em 1º, 2º e 3º lugar.</p>
                            <p><strong>Resposta:</strong> Identificar significa apontar ou nomear a posição de objetos como estando em 1º, 2º e 3º lugar por tentativa.</p>
                            <p><strong>Critério:</strong> Identificar corretamente a posição dos objetos quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a posição dos objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a posição do objeto quando o avaliador solicita a resposta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C107 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C107 - Aponta para objetos inteiros e partidos ao meio.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente objetos que estão inteiros e aqueles que foram partidos ao meio, demonstrando habilidades de observação e discriminação visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item107" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item107" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item107" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item107"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item107">
                            <p><strong>Recursos Materiais:</strong> Frutas, verduras, papéis inteiros e/ou cortados ao meio.</p>
                            <p><strong>Condição:</strong> Apresentar à criança uma mistura de objetos inteiros e objetos que foram partidos ao meio. Pedir que ela aponte para quais objetos estão inteiros e quais estão partidos.</p>
                            <p><strong>Resposta:</strong> Apontar para objetos inteiros e partidos ao meio.</p>
                            <p><strong>Critério:</strong> Apontar corretamente para objetos inteiros e partidos ao meio.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para objetos inteiros e partidos ao meio.</li>
                              <li><strong>Às Vezes:</strong> Aponta para objetos inteiros e partidos ao meio.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card C108 -->
                        <div class="portage-card">
                          <div class="checkbox-title">C108 - Conta de memória de 1 a 100.</div>
                          <div class="checkbox-interpretation">A criança deve contar de memória de 1 a 100 corretamente, demonstrando habilidades avançadas de contagem e memorização de sequências numéricas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="cognicao5_6_item108" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item108" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="cognicao5_6_item108" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_cognicao5_6_item108"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_cognicao5_6_item108">
                            <p><strong>Recursos Materiais:</strong> Não requer materiais específicos.</p>
                            <p><strong>Condição:</strong> Pedir à criança que conte até 100. Se a criança não apresentar erros por volta da 3ª dezena (30), interrompê-la e pedir que continue a partir do 80.</p>
                            <p><strong>Resposta:</strong> Contar de memória de 1 a 100.</p>
                            <p><strong>Critério:</strong> Contar de memória de 1 a 100 corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta de memória de 1 a 100.</li>
                              <li><strong>Às Vezes:</strong> Conta de memória de 1 a 100 corretamente.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>
                </div>
            </div>
            
            <!-- Área Linguagem -->
            <div id="linguagem" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Linguagem</h4>
                
                <!-- Sub-abas de faixas etárias para Linguagem -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#ling0_1" data-toggle="tab" role="tab" aria-controls="ling0_1" aria-selected="true">0 - 1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling1_2" data-toggle="tab" role="tab" aria-controls="ling1_2" aria-selected="false">1 - 2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling2_3" data-toggle="tab" role="tab" aria-controls="ling2_3" aria-selected="false">2 - 3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling3_4" data-toggle="tab" role="tab" aria-controls="ling3_4" aria-selected="false">3 - 4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling4_5" data-toggle="tab" role="tab" aria-controls="ling4_5" aria-selected="false">4 - 5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ling5_6" data-toggle="tab" role="tab" aria-controls="ling5_6" aria-selected="false">5 - 6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0 - 1 ano - Linguagem -->
                    <div id="ling0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0 - 1 ano</h5>
                        
                        <!-- Card L1 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L1 - Repete sons emitidos por outras pessoas.</div>
                          <div class="checkbox-interpretation">A criança deve repetir sons emitidos por outras pessoas, demonstrando habilidades de imitação vocal e reconhecimento de sons básicos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item1" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item1" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item1" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item1"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item1">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Com a criança no colo e face com o adulto, produzir sons curtos uma ou duas vezes, podendo ser sons já emitidos pela criança (gú, ah – gu – ga), sons vocálicos (a, ê, é, i, ô, ó, u) ou labiais (pa, ma, ba), e dar o devido tempo à criança para que os repita.</p>
                            <p><strong>Resposta:</strong> Repetir sons semelhantes ao modelo dentro de um minuto.</p>
                            <p><strong>Critério:</strong> Repetir pelo menos dois sons diferentes emitidos por outras pessoas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não repete sons emitidos por outra pessoa.</li>
                              <li><strong>Às Vezes:</strong> Repete sons emitidos por outras pessoas dentro de 1 minuto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L2 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L2 - Repete a mesma sílaba duas a três vezes (ma, ma, ma).</div>
                          <div class="checkbox-interpretation">A criança deve repetir a mesma sílaba duas a três vezes, demonstrando habilidades iniciais de vocalização e repetição.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item2" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item2" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item2" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item2"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item2">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Levantar, junto ao familiar, quais sons a criança produz espontaneamente (exemplo: ba, ca, etc.). Tendo levantado os sons mais frequentes, dar o modelo e dar tempo à criança para que ela emita a resposta.</p>
                            <p><strong>Resposta:</strong> Repetir a mesma sílaba produzida por si própria duas a três vezes.</p>
                            <p><strong>Critérios:</strong> Repetir a mesma sílaba produzida por si própria 2 a 3 vezes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não repete a mesma sílaba produzida por si própria.</li>
                              <li><strong>Às Vezes:</strong> Repete a mesma sílaba produzida por si própria 2 a 3 vezes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L3 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L3 - Responde a gestos com gestos.</div>
                          <div class="checkbox-interpretation">A criança deve responder a gestos de outras pessoas com gestos próprios, demonstrando habilidades de comunicação não verbal e imitação de ações simples.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item3" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item3" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item3" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item3"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item3">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Emitir gestos simples, como dar tchau, aplaudir, mover a cabeça negativamente para “não”, estender os braços para ser pego, jogar um beijo, etc., e observar se a criança imita esses gestos.</p>
                            <p><strong>Resposta:</strong> Responder a gestos com gestos, imitando uma ação simples.</p>
                            <p><strong>Critério:</strong> Responder a pelo menos dois gestos diferentes com gestos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde a gestos com gestos.</li>
                              <li><strong>Às Vezes:</strong> Responde a pelo menos 2 gestos diferentes com gestos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L4 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L4 - Obedece a uma ordem simples, quando acompanhada de gestos indicativos.</div>
                          <div class="checkbox-interpretation">A criança deve obedecer a ordens simples quando acompanhadas de gestos, demonstrando compreensão básica de instruções e comunicação multimodal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item4" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item4" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item4" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item4"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item4">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Dar uma ordem simples à criança, como “vem cá” ou “me dá o...”, acompanhada de gestos indicativos, como apontar para o objeto ou realizar a ação desejada.</p>
                            <p><strong>Resposta:</strong> Obedecer a uma ordem simples, realizando a ação proposta quando acompanhada de gestos indicativos.</p>
                            <p><strong>Critérios:</strong> Obedecer a uma ordem simples, quando acompanhada de gestos indicativos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não obedece a uma ordem simples, quando acompanhada de gestos indicativos.</li>
                              <li><strong>Às Vezes:</strong> Obedece a uma ordem simples, quando acompanhada de gestos indicativos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L5 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L5 - Interrompe a atividade, pelo menos momentaneamente, quando lhe dizem “não”, 75% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve interromper uma atividade quando instruída com a palavra “não”, demonstrando compreensão de instruções negativas e autocontrole básico.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item5" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item5" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item5" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item5"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item5">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Emitir a palavra “não” durante uma atividade e observar se a criança interrompe a atividade momentaneamente em aproximadamente 75% das vezes.</p>
                            <p><strong>Resposta:</strong> Interromper a atividade, pelo menos momentaneamente, quando instruída com a palavra “não”, 75% das vezes.</p>
                            <p><strong>Critérios:</strong> Interromper a atividade, pelo menos momentaneamente, quando lhe dizem “não”, 75% das vezes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não interrompe a atividade quando lhe dizem “não”.</li>
                              <li><strong>Às Vezes:</strong> Interrompe a atividade, pelo menos momentaneamente, quando lhe dizem “não”, 75% das vezes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L6 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L6 - Responde perguntas simples com respostas não verbais.</div>
                          <div class="checkbox-interpretation">A criança deve responder a perguntas simples utilizando respostas não verbais, como apontar ou gesticular, demonstrando habilidades de comunicação não verbal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item6" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item6" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item6" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item6"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item6">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas simples à criança, como “Onde está (objeto)?”, “Quer (alimento)?”, “Cadê (objeto)?”, e observar se ela responde com gestos não vocais, como apontar com a mão ou afirmar/negacionar com a cabeça.</p>
                            <p><strong>Resposta:</strong> Responder a pelo menos duas perguntas simples diferentes utilizando respostas não verbais.</p>
                            <p><strong>Critérios:</strong> Responder a pelo menos duas perguntas simples diferentes com respostas não vocais.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde perguntas simples com respostas não verbais.</li>
                              <li><strong>Às Vezes:</strong> Responde a pelo menos 2 perguntas simples diferentes com respostas não verbais.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L7 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L7 - Combina duas sílabas diferentes em suas tentativas de verbalizações.</div>
                          <div class="checkbox-interpretation">A criança deve combinar duas sílabas diferentes ao vocalizar, demonstrando habilidades iniciais de formação de palavras e coordenação vocal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item7" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item7" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item7" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item7"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item7">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Identificar junto ao familiar quais sílabas a criança produz espontaneamente (exemplo: ba, ca, etc.). Tendo identificado os sons mais frequentes, dar o modelo e dar tempo à criança para que ela combine duas sílabas diferentes em suas tentativas de verbalização.</p>
                            <p><strong>Resposta:</strong> Combinar duas sílabas diferentes em suas tentativas de verbalizações.</p>
                            <p><strong>Critérios:</strong> Combinar 2 sílabas diferentes em suas tentativas de vocalizações.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não combina 2 sílabas diferentes em duas tentativas de vocalizações.</li>
                              <li><strong>Às Vezes:</strong> Combina 2 sílabas diferentes em suas tentativas de vocalizações.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L8 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L8 - Imita padrões de entonação da voz de outras pessoas.</div>
                          <div class="checkbox-interpretation">A criança deve imitar diferentes padrões de entonação da voz de outras pessoas, como gritar, sussurrar ou falar em voz normal, demonstrando habilidades de comunicação vocal avançadas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item8" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item8" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item8" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item8"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item8">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Dar o modelo verbal de padrões de entonação ou cantar, produzindo inflexões e variações como gritar, sussurrar e falar em voz normal, e solicitar que a criança imite esses padrões.</p>
                            <p><strong>Resposta:</strong> Imitar pelo menos dois padrões de entonação de voz diferentes.</p>
                            <p><strong>Critérios:</strong> Imitar pelo menos dois padrões de entonação de voz diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não imita padrões de entonação da voz de outras pessoas.</li>
                              <li><strong>Às Vezes:</strong> Imitar pelo menos 2 padrões de entonação de voz diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L9 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L9 - Usa uma palavra funcionalmente para indicar objeto ou pessoa.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar palavras de forma funcional para indicar objetos ou pessoas, demonstrando compreensão e uso pragmático da linguagem.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item9" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item9" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item9" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item9"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item9">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Identificar junto ao familiar quais palavras a criança utiliza funcionalmente e, em seguida, testar a utilização dessas palavras perguntando: “Quem é?”, “O que é isto?”, etc., em relação a objetos ou pessoas específicos.</p>
                            <p><strong>Resposta:</strong> Usar uma palavra funcionalmente para indicar objeto ou pessoa, nomeando adequadamente o objeto ou pessoa correspondente.</p>
                            <p><strong>Critérios:</strong> Usar uma palavra funcionalmente para indicar objeto ou pessoa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa uma palavra funcionalmente para indicar objeto ou pessoa.</li>
                              <li><strong>Às Vezes:</strong> Usa uma palavra funcionalmente para indicar objeto ou pessoa.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L10 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L10 - Vocaliza em resposta à fala de outra pessoa.</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar em resposta à fala de outras pessoas, demonstrando habilidades de comunicação básica e interação social verbal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem0_1_item10" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item10" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem0_1_item10" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem0_1_item10"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem0_1_item10">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Emitir uma fala para a criança e observar se ela vocaliza em resposta dentro de 1 a 2 segundos.</p>
                            <p><strong>Resposta:</strong> Vocalizar em resposta à fala de outra pessoa dentro de 1 a 2 segundos.</p>
                            <p><strong>Critérios:</strong> Apresentar qualquer tipo de vocalização de 1 a 2 segundos após a fala de outra pessoa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não vocaliza em resposta à fala de outra pessoa.</li>
                              <li><strong>Às Vezes:</strong> Apresenta qualquer tipo de vocalização de 1 a 2 segundos após a fala de outra pessoa.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>

                        
                    </div>

                    <!-- Faixa 1 - 2 anos - Linguagem -->
                    <div id="ling1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1 - 2 anos</h5>
                        
                        <!-- Card L11 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L11 - Diz cinco palavras diferentes (pode usar a mesma palavra para se referir a diferentes objetos).</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar cinco palavras diferentes, podendo reutilizar a mesma palavra para se referir a diferentes objetos, demonstrando expansão do vocabulário e flexibilidade no uso de palavras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item11" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item11" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item11" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item11"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item11">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Estimular a criança a vocalizar cinco palavras diferentes, permitindo que ela use a mesma palavra para se referir a diferentes objetos ou situações.</p>
                            <p><strong>Resposta:</strong> Dizer cinco palavras diferentes como, por exemplo, “bola”, “au-au”, “mamãe”, “papai”, “vovó”, etc. A criança poderá usar a mesma palavra para se referir a diferentes situações (exemplo: dizer “papá” frente ao pai, quando aponta para o pai ou quando a criança vê um objeto que pertence ao pai).</p>
                            <p><strong>Critério:</strong> Dizer pelo menos duas palavras diferentes emitidas por outras pessoas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz 5 palavras diferentes.</li>
                              <li><strong>Às Vezes:</strong> Diz 5 palavras diferentes, podendo usar a mesma palavra para se referir a diferentes objetos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L12 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L12 - Pede “mais”.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar a palavra “mais” para solicitar continuidade em atividades como alimentação, brincadeiras ou histórias, demonstrando habilidades de comunicação funcional.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item12" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item12" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item12" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item12"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item12">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Observar situações em que a criança possa desejar continuar uma atividade, como durante a alimentação, recebendo bebidas, brincando ou ouvindo uma história.</p>
                            <p><strong>Resposta:</strong> Pedir mais = dizer “mais” nas seguintes situações: quando deseja continuar a ser alimentado, continuar a receber uma bebida, continuar a realizar uma brincadeira, ou desejar que um adulto continue a contar uma história.</p>
                            <p><strong>Critérios:</strong> Pede “mais” em diferentes situações.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não pede “mais”.</li>
                              <li><strong>Às Vezes:</strong> Pede “mais” em diferentes situações.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L13 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L13 - Diz acabou (“cabo”).</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar a palavra “acabou” ou “cabo” quando uma atividade ou objeto for finalizado, demonstrando compreensão de finalizações e habilidades de comunicação verbal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item13" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item13" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item13" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item13"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item13">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Observar situações em que uma atividade é finalizada, como terminar de comer, beber ou quando um dispositivo (TV, rádio, aspirador) é desligado.</p>
                            <p><strong>Resposta:</strong> Dizer “acabou” ou “cabo” quando, por exemplo, terminar de comer, beber ou quando cessar um determinado evento (TV, rádio ou aspirador forem desligados).</p>
                            <p><strong>Critérios:</strong> Diz “acabou” quando algo foi finalizado, em diferentes situações.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz “acabou” quando algo foi finalizado.</li>
                              <li><strong>Às Vezes:</strong> Diz “acabou” quando algo foi finalizado, em diferentes situações.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L14 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L14 - Obedece a três ordens diferentes, que não são acompanhadas de gestos indicativos.</div>
                          <div class="checkbox-interpretation">A criança deve seguir três ordens diferentes que não são acompanhadas de gestos, demonstrando compreensão de instruções verbais e habilidades de execução de comandos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item14" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item14" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item14" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item14"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item14">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Dar três ordens diferentes à criança que não são acompanhadas de gestos indicativos, como “senta”, “vem cá”, “me dá”, “rola a bola”, “marcha”, “aponta um objeto”, “levanta os braços”, “traz um objeto”, etc.</p>
                            <p><strong>Resposta:</strong> Obedecer a uma ordem simples, realizando a ação proposta.</p>
                            <p><strong>Critérios:</strong> Obedece a 3 ordens diferentes que não são acompanhadas de gestos indicativos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não obedece a 3 ordens diferentes que não são acompanhadas de gestos indicativos.</li>
                              <li><strong>Às Vezes:</strong> Obedece a 3 ordens diferentes, que não são acompanhadas de gestos indicativos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L15 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L15 - Consegue “dar” ou “mostrar” quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve responder adequadamente às solicitações de “dar” ou “mostrar” objetos, utilizando a linguagem funcional para interagir e comunicar suas necessidades.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item15" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item15" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item15" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item15"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item15">
                            <p><strong>Recursos Materiais:</strong> Objetos conhecidos e seguros para a criança manipular.</p>
                            <p><strong>Condição:</strong> Na presença de um objeto conhecido, perguntar à criança: “Me dá o (objeto)”, “Me mostre o (objeto)”, etc.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “me dá” ou “me mostre (objeto, brinquedo, alimento)”, a criança deverá entregar o objeto ou permitir que o adulto veja.</p>
                            <p><strong>Critérios:</strong> Consegue “dar” ou “mostrar” um objeto quando requisitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não “dá” ou “mostra” quando requisitado.</li>
                              <li><strong>Às Vezes:</strong> Consegue “dar” ou “mostrar” um objeto quando requisitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L16 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L16 - Aponta para 12 objetos conhecidos quando nomeados.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente para 12 objetos conhecidos quando forem nomeados, demonstrando reconhecimento de objetos e habilidades de correspondência visual.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item16" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item16" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item16" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item16"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item16">
                            <p><strong>Recursos Materiais:</strong> Objetos conhecidos da criança, como janela, porta, xícara, colher, caixa, prato, bola, livro, boneca, lápis, cobertor, escova de dente, bolacha ou biscoito, cadeira, árvore, pedra, flor, camisa, sapato, meia, calça, vestido, casaco, gato, cachorro (“au-au”), vaca, carneiro, porco, cavalo, pato, galinha (“có-có”).</p>
                            <p><strong>Condição:</strong> Apresentar vários objetos conhecidos à criança e perguntar: “Aponte o (objeto)”, “Cadê o (objeto)”, etc.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “Aponte o (objeto)” ou “Cadê o (objeto)”, a criança deverá responder corretamente, apontando para o objeto nomeado.</p>
                            <p><strong>Critérios:</strong> Aponta para 12 objetos conhecidos quando nomeados.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para objetos conhecidos quando nomeados.</li>
                              <li><strong>Às Vezes:</strong> Aponta para 12 objetos conhecidos quando nomeados.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L17 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L17 - Aponta para três a cinco figuras de um livro quando nomeadas.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente para três a cinco figuras de um livro quando forem nomeadas, demonstrando habilidades de leitura visual e reconhecimento de figuras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item17" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item17" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item17" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item17"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item17">
                            <p><strong>Recursos Materiais:</strong> Livros infantis, revistas ou “álbuns” de recortes contendo ilustrações nítidas de objetos conhecidos pela criança, como gato, pássaro, cavalo, cachorro, homem, carro, casa, bola.</p>
                            <p><strong>Condição:</strong> Apresentar à criança três a cinco figuras de um livro e perguntar: “Cadê o (figura)?” ou “Me mostre o (figura)”.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “Cadê o (figura)?” ou “Me mostre o (figura)”, apontar adequadamente para três a cinco figuras nomeadas de um livro.</p>
                            <p><strong>Critérios:</strong> Aponta para 3 a 5 figuras de um livro quando nomeadas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para figuras de um livro quando nomeadas.</li>
                              <li><strong>Às Vezes:</strong> Aponta para 3 a 5 figuras de um livro quando nomeadas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L18 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L18 - Aponta para três partes de seu próprio corpo.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente para três partes de seu próprio corpo quando solicitado, demonstrando conhecimento corporal e habilidades de correspondência verbal com ações físicas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item18" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item18" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item18" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item18"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item18">
                            <p><strong>Recursos Materiais:</strong> Boneca ou outra pessoa.</p>
                            <p><strong>Condição:</strong> Perguntar à criança “O que é isto?” ao mesmo tempo em que se aponta uma parte do próprio corpo ou do corpo de uma boneca.</p>
                            <p><strong>Resposta:</strong> Partes do corpo = olho, ouvido, nariz, boca, cabelo ou cabeça, mão, braço, pé, perna, barriga.</p>
                            <p><strong>Critérios:</strong> Aponta para 3 partes de seu próprio corpo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para partes de seu próprio corpo.</li>
                              <li><strong>Às Vezes:</strong> Aponta para 3 partes de seu próprio corpo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L19 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L19 - Diz seu nome ou apelido quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar seu próprio nome ou apelido quando solicitado, demonstrando reconhecimento de identidade e habilidades de autocontato verbal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item19" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item19" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item19" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item19"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item19">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “Qual é o seu nome?” ou “Como você se chama?”.</p>
                            <p><strong>Resposta:</strong> Dizer seu nome ou apelido quando solicitado.</p>
                            <p><strong>Critérios:</strong> Diz seu nome ou apelido quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz seu nome ou apelido quando solicitado.</li>
                              <li><strong>Às Vezes:</strong> Diz seu nome ou apelido quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L20 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L20 - Responde à pergunta “o que é isto?” com o nome do objeto.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear corretamente objetos conhecidos quando perguntado, demonstrando reconhecimento e vocabulário expandido.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item20" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item20" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item20" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item20"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item20">
                            <p><strong>Recursos Materiais:</strong> Objetos conhecidos da criança.</p>
                            <p><strong>Condição:</strong> Mostrar para a criança um dentre vários objetos conhecidos e perguntar: “O que é isto?”.</p>
                            <p><strong>Resposta:</strong> Responder à pergunta “o que é isto?” com o nome do objeto.</p>
                            <p><strong>Critérios:</strong> Responde corretamente o nome de objetos conhecidos quando questionado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde corretamente o nome de objetos conhecidos quando questionado.</li>
                              <li><strong>Às Vezes:</strong> Responde corretamente o nome de objetos conhecidos quando questionado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L21 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L21 - Combina palavras e gestos para indicar seus objetos.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar simultaneamente palavras e gestos para indicar ou solicitar objetos, demonstrando habilidades de comunicação multimodal e interação social.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item21" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item21" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item21" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item21"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item21">
                            <p><strong>Recursos Materiais:</strong> Objetos prováveis de serem requisitados pela criança, como biscoito, guaraná, brinquedos.</p>
                            <p><strong>Condição:</strong> Colocar próximo à criança (por exemplo, sobre uma mesa) objetos prováveis de serem requisitados por ela e observar suas interações.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta “O que você quer?”, a criança deverá responder combinando palavras (tais como: “eu”, seu nome, “quero”) e gestos (tais como: olhar em direção e apontar para o objeto ou levar a pessoa até o objeto).</p>
                            <p><strong>Critérios:</strong> Combina palavras e gestos para indicar seus objetos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não combina palavras e gestos para indicar seus objetos.</li>
                              <li><strong>Às Vezes:</strong> Combina palavras e gestos para indicar seus objetos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L22 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L22 - Nomeia cinco outros membros da família incluindo animais domésticos.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear cinco membros da família, incluindo animais domésticos, demonstrando reconhecimento de relações familiares e pertencimento.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item22" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item22" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item22" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item22"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item22">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Na presença de cinco membros da família, incluindo animais domésticos, e frente à pergunta “Quem é?”, a criança deve identificar cada um deles.</p>
                            <p><strong>Resposta:</strong> Na presença de cinco membros da família e frente à pergunta “Quem é?”, responder adequadamente dizendo, por exemplo: mamãe, papai, nome do irmão, da irmã, do cachorro, etc. (observação: se a família não apresentar cinco elementos, poderão ser considerados vovó, vovô, titio, titia, etc.).</p>
                            <p><strong>Critérios:</strong> Nomeia 5 membros da família incluindo animais domésticos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia membros da família.</li>
                              <li><strong>Às Vezes:</strong> Nomeia 5 membros da família incluindo animais domésticos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L23 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L23 - Nomeia quatro brinquedos.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear corretamente quatro brinquedos conhecidos, demonstrando reconhecimento de objetos de brincadeira e expansão do vocabulário.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item23" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item23" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item23" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item23"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item23">
                            <p><strong>Recursos Materiais:</strong> Brinquedos como bola, carro, boneca, telefone, patinho, podendo ser aceito “nenê” para boneca ou bichinho de pelúcia. Os brinquedos devem pertencer, preferencialmente, à própria criança.</p>
                            <p><strong>Condição:</strong> Na presença de quatro brinquedos e frente à pergunta: “O que é isto?” ou “Quem é?”, a criança deve nomear corretamente o brinquedo.</p>
                            <p><strong>Resposta:</strong> Na presença de quatro brinquedos e frente à pergunta: “O que é isto?” ou “Quem é?”, responder com o nome do brinquedo.</p>
                            <p><strong>Critérios:</strong> Nomeia 4 brinquedos quando solicitado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia brinquedos.</li>
                              <li><strong>Às Vezes:</strong> Nomeia 4 brinquedos quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L24 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L24 - Produz sons de animais ou usa os sons para nomear animais (cachorro é “au-au”).</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar sons de animais ou associar corretamente sons específicos aos nomes dos animais, demonstrando habilidades de reconhecimento fonético e correspondência entre sons e objetos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item24" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item24" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item24" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item24"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item24">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Observar situações em que a criança está exposta a sons de animais, ou mesmo apresentar imagens de animais e pedir que a criança associe os sons correspondentes.</p>
                            <p><strong>Resposta:</strong> Produzir pelo menos dois sons de diferentes animais ou usar pelo menos dois sons para nomear dois diferentes animais.</p>
                            <p><strong>Critérios:</strong> Produz pelo menos dois sons de diferentes animais ou usa pelo menos dois sons para nomear dois diferentes animais.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não produz sons de animais ou usa sons para nomear animais.</li>
                              <li><strong>Às Vezes:</strong> Produz pelo menos 2 sons de animais diferentes ou usa pelo menos 2 sons para nomear 2 animais diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L25 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L25 - Pede alimentos conhecidos pelo nome, quando mostrados (leite, bolacha ou biscoito, pão).</div>
                          <div class="checkbox-interpretation">A criança deve solicitar alimentos conhecidos utilizando seus nomes específicos quando apresentados, demonstrando habilidades de comunicação funcional e reconhecimento de objetos de interesse.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item25" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item25" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item25" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item25"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item25">
                            <p><strong>Recursos Materiais:</strong> Alimentos conhecidos como leite, bolacha ou biscoito, pão.</p>
                            <p><strong>Condição:</strong> Apresentar um alimento conhecido à criança e solicitar que ela o peça utilizando seu nome específico.</p>
                            <p><strong>Resposta:</strong> Na presença de um alimento conhecido, a criança deverá solicitá-lo, chamando-o por seu nome: “mamá”, “água” ou “quero biscoito”, “dá pão”, “dá guaraná”.</p>
                            <p><strong>Critérios:</strong> Pede pelo menos dois alimentos diferentes pelo nome.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não pede alimentos conhecidos pelo nome.</li>
                              <li><strong>Às Vezes:</strong> Pede pelo menos 2 alimentos diferentes pelo nome.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L26 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L26 - Faz perguntas variando a entonação da voz.</div>
                          <div class="checkbox-interpretation">A criança deve formular perguntas utilizando variações na entonação da voz, como elevações no final da frase, demonstrando habilidades de comunicação verbal e interação social.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item26" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item26" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item26" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item26"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item26">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Estimular a criança a fazer perguntas simples utilizando variações na entonação da voz, como elevar a voz no final da palavra ou da frase.</p>
                            <p><strong>Resposta:</strong> Fazer perguntas com uma ou duas palavras variando a entonação da voz, ou seja, elevando a voz no final da palavra ou da frase, por exemplo: “quer?”, “dá?”.</p>
                            <p><strong>Critério:</strong> Fazer pelo menos duas perguntas em situações diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não faz perguntas variando a entonação de voz.</li>
                              <li><strong>Às Vezes:</strong> Faz pelo menos 2 perguntas, variando a entonação de voz, em situações diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L27 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L27 - Nomeia três partes do corpo em uma boneca ou em outra pessoa.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e nomear três partes do corpo em uma boneca ou em outra pessoa, demonstrando conhecimento corporal e habilidades de comunicação verbal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item27" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item27" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item27" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item27"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item27">
                            <p><strong>Recursos Materiais:</strong> Boneca ou outra pessoa.</p>
                            <p><strong>Condição:</strong> Perguntar à criança “O que é isto?” ao mesmo tempo em que se aponta uma parte do próprio corpo ou do corpo de uma boneca.</p>
                            <p><strong>Resposta:</strong> Partes do corpo = olho, ouvido, nariz, boca, cabelo ou cabeça, mão, braço, pé, perna, barriga.</p>
                            <p><strong>Critérios:</strong> Nomeia 3 partes do corpo em uma boneca ou em outra pessoa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia partes do corpo em uma boneca ou em outra pessoa.</li>
                              <li><strong>Às Vezes:</strong> Nomeia 3 partes do corpo em uma boneca ou em outra pessoa.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L28 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L28 - Responde a perguntas do tipo sim/não com respostas afirmativas ou negativas.</div>
                          <div class="checkbox-interpretation">A criança deve responder adequadamente a perguntas simples do tipo sim/não utilizando respostas afirmativas ou negativas, demonstrando compreensão de perguntas binárias e habilidades de comunicação funcional.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem1_2_item28" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item28" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem1_2_item28" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem1_2_item28"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem1_2_item28">
                            <p><strong>Recursos Materiais:</strong> Alimentos conhecidos.</p>
                            <p><strong>Condição:</strong> Fazer perguntas à criança empregando vocabulário sobre pessoas, alimentos, objetos e experiências que lhe são conhecidos, por exemplo: “Isto é uma xícara?”, “Você tem nome?”, “Você está cansado?”.</p>
                            <p><strong>Resposta:</strong> Responder duas perguntas diferentes do tipo sim/não, sendo uma resposta afirmativa e uma negativa.</p>
                            <p><strong>Critérios:</strong> Responde pelo menos duas perguntas diferentes do tipo sim/não, sendo uma resposta afirmativa/negativa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde corretamente perguntas de sim/não.</li>
                              <li><strong>Às Vezes:</strong> Responde pelo menos 2 perguntas diferentes de sim/não, sendo uma de cada.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 2 - 3 anos - Linguagem -->
                    <div id="ling2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2 - 3 anos</h5>
                        
                        <!-- Card L29 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L29 - Combina substantivos ou adjetivos e substantivos em frases de duas palavras (bola cadeira) (minha bola).</div>
                          <div class="checkbox-interpretation">A criança deve apresentar pelo menos três frases que combinem substantivos ou adjetivos e substantivos, formando frases de duas palavras (exemplo: “minha bola”).</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item29" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item29" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item29" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item29"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item29">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se necessário, fazer perguntas à criança que possam levá-la à elaboração de frases (exemplo: “De quem é a bola?”, “Onde está a bola?”).</p>
                            <p><strong>Resposta:</strong> Critério: apresentar pelo menos três frases de duas palavras que combinem substantivos ou adjetivos e substantivos, como “bola cadeira”, “minha bola”, etc.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não combina substantivos ou adjetivos e substantivos em frases.</li>
                              <li><strong>Às Vezes:</strong> Apresenta pelo menos 3 frases que combinem substantivos ou adjetivos e substantivos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L30 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L30 - Combina substantivo e verbo em frases de duas palavras (papai vai).</div>
                          <div class="checkbox-interpretation">A criança deve combinar um substantivo e um verbo em frases de duas palavras, demonstrando a capacidade de descrever ações básicas (exemplo: “papai come”).</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item30" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item30" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item30" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item30"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item30">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas como: “O que ele/ela está fazendo?” para que a criança responda usando um substantivo e um verbo (exemplo: “papai come”).</p>
                            <p><strong>Resposta:</strong> Critério: apresentar pelo menos três frases de duas palavras que combinem substantivo e verbo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não combina substantivo e verbo em frases.</li>
                              <li><strong>Às Vezes:</strong> Apresenta pelo menos 3 frases de 2 palavras que combinem substantivo e verbo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L31 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L31 - Usa uma palavra para indicar que quer ir ao banheiro.</div>
                          <div class="checkbox-interpretation">A criança deve usar uma palavra específica (como “xixi” ou “cocô”) para indicar que deseja ir ao banheiro, demonstrando habilidades de comunicação funcional e consciência corporal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item31" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item31" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item31" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item31"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item31">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário. Entrevista com o familiar.</p>
                            <p><strong>Condição:</strong> Observar, no último dia ou na última semana, se a criança utilizou alguma palavra para indicar que quer ir ao banheiro (“xixi”, “cocô”, etc.).</p>
                            <p><strong>Resposta:</strong> Critério: no último dia, ter utilizado uma palavra para indicar ida ao banheiro pelo menos uma vez, ou na última semana pelo menos três vezes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa uma palavra para indicar que quer ir ao banheiro.</li>
                              <li><strong>Às Vezes:</strong> Usa uma palavra para indicar que quer ir ao banheiro pelo menos 1x no último dia ou 3x na última semana.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L32 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L32 - Combina verbo ou substantivo com “lá” ou “aqui” em uma frase de duas palavras (cadeira aqui).</div>
                          <div class="checkbox-interpretation">A criança deve usar “lá” ou “aqui” em combinação com um verbo ou substantivo para formar uma frase de duas palavras, demonstrando habilidades iniciais de localização espacial na fala.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item32" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item32" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item32" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item32"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item32">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns do ambiente.</p>
                            <p><strong>Condição:</strong> Perguntar: “Onde está (objeto)?” e observar se a criança responde com um verbo ou substantivo acompanhado de “lá” ou “aqui” (exemplo: “bola aqui”).</p>
                            <p><strong>Resposta:</strong> Combinar verbo ou substantivo com “lá” ou “aqui” em 1 frase de duas palavras.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não combina verbo ou substantivo com “lá” ou “aqui” em frases.</li>
                              <li><strong>Às Vezes:</strong> Combina verbo ou substantivo com “lá” ou “aqui” em 1 frase de 2 palavras.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L33 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L33 - Combina duas palavras para expressar posse (carro papai).</div>
                          <div class="checkbox-interpretation">A criança deve expressar posse utilizando duas palavras em frases curtas (exemplo: “carro papai”, “bola minha”), demonstrando habilidades de linguagem relacionadas a posse e propriedade.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item33" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item33" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item33" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item33"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item33">
                            <p><strong>Recursos Materiais:</strong> Objetos conhecidos pela criança.</p>
                            <p><strong>Condição:</strong> Frente à pergunta: “De quem é isto?” a criança deve responder com o nome do objeto e o de seu possuidor ou pronome indicativo de posse (exemplo: “bola minha”, “carro papai”).</p>
                            <p><strong>Resposta:</strong> Combinar duas palavras para expressar posse.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não combina palavras para expressar posse.</li>
                              <li><strong>Às Vezes:</strong> Combina duas palavras para expressar posse.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L34 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L34 - Emprega “não” na fala.</div>
                          <div class="checkbox-interpretation">A criança deve usar “não” em suas frases de duas a três palavras, demonstrando habilidades de negação e construção linguística mais complexa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item34" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item34" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item34" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item34"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item34">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se necessário, fazer perguntas que envolvam alta probabilidade de respostas contendo “não”, como “Você quer dormir?” ou “A mamãe está comendo agora?”</p>
                            <p><strong>Resposta:</strong> Formar frases de duas a três palavras contendo a palavra “não”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega “não” na fala.</li>
                              <li><strong>Às Vezes:</strong> Forma frases de 2 a 3 palavras contendo a palavra “não”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L35 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L35 - Responde à pergunta “o que... está fazendo?” para atividades habituais.</div>
                          <div class="checkbox-interpretation">A criança deve descrever brevemente a ação que está ocorrendo quando perguntada “o que você (ou outra pessoa) está fazendo?”, demonstrando habilidades de linguagem expressiva.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item35" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item35" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item35" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item35"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item35">
                            <p><strong>Recursos Materiais:</strong> Situações naturais ou objetos que facilitem a descrição da ação (comer, beber, andar, pular, etc.).</p>
                            <p><strong>Condição:</strong> Perguntar “o que você está fazendo?” quando a criança estiver engajada em atividades rotineiras, como andar, saltar, tomar banho, comer, trocar de roupa, lavar, etc.</p>
                            <p><strong>Resposta:</strong> Responder indicando a ação que está ocorrendo naquele momento.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde à perguntas “o que está fazendo?” para atividades habituais.</li>
                              <li><strong>Às Vezes:</strong> Responde à perguntas “o que está fazendo?” indicando a ação que está ocorrendo no momento.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L36 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L36 - Responde a perguntas do tipo: “Onde?”.</div>
                          <div class="checkbox-interpretation">A criança deve responder corretamente a perguntas que iniciam com “Onde?”, demonstrando compreensão de localização e uso de expressões espaciais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item36" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item36" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item36" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item36"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item36">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns, pequenas caixas, xícaras, pratos, etc.</p>
                            <p><strong>Condição:</strong> Colocar na frente da criança uma caixa, uma xícara e um prato com objetos dentro, ou pedir aos familiares que fiquem em diferentes locais. Perguntar: “Onde está (objeto/pessoa)?”.</p>
                            <p><strong>Resposta:</strong> Responder dizendo o local onde se encontra o objeto/pessoa.</p>
                            <p><strong>Critério:</strong> Responder a três diferentes perguntas do tipo “onde?”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde a perguntas do tipo “onde”.</li>
                              <li><strong>Às Vezes:</strong> Responde a 3 perguntas diferentes do tipo “onde”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L37 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L37 - Nomeia sons ambientais familiares.</div>
                          <div class="checkbox-interpretation">A criança deve reproduzir ou nomear pelo menos três sons ambientais familiares (por exemplo, telefone, campainha, buzina), demonstrando reconhecimento auditivo.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item37" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item37" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item37" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item37"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item37">
                            <p><strong>Recursos Materiais:</strong> Sons ambientais comuns (telefone, avião, campainha, carro, buzina, animais domésticos, etc.).</p>
                            <p><strong>Condição:</strong> Perguntar: “Que som faz (objeto/animal)?” e esperar que a criança reproduza ou nomeie o som correspondente.</p>
                            <p><strong>Resposta:</strong> Nomear pelo menos três sons ambientais familiares.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não reproduz os sons ambientais familiares.</li>
                              <li><strong>Às Vezes:</strong> Reproduz pelo menos 3 sons ambientais familiares.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L38 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L38 - Dá mais de um objeto quando se usa a forma plural na solicitação (blocos).</div>
                          <div class="checkbox-interpretation">A criança deve entregar mais de um objeto quando a solicitação é feita no plural, demonstrando compreensão das formas plurais na fala.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item38" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item38" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item38" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item38"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item38">
                            <p><strong>Recursos Materiais:</strong> Brinquedos e objetos comuns em quantidade maior do que um (blocos, xícaras, colheres, bolas, etc.).</p>
                            <p><strong>Condição:</strong> Apresentar várias quantidades de objetos e solicitar à criança: “Me dê os blocos”, “Me dê as bolas”, etc.</p>
                            <p><strong>Resposta:</strong> Dar mais de um objeto quando se usa a forma plural na solicitação.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não dá mais de um objeto quando solicitado na forma plural.</li>
                              <li><strong>Às Vezes:</strong> Dá mais de um objeto quando se usa a forma plural na solicitação.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L39 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L39 - Ao falar, refere-se a si próprio pelo nome.</div>
                          <div class="checkbox-interpretation">A criança deve, ao falar, usar seu próprio nome ou pronomes pessoais (eu, meu, mim) para se referir a si mesma, demonstrando consciência de identidade e habilidades de linguagem expressiva.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item39" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item39" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item39" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item39"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item39">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Frente a um pedido da criança, o adulto pergunta “Quem quer (pedido)?”, ou “De quem é este (objeto)?”.</p>
                            <p><strong>Resposta:</strong> A criança deve referir-se a si mesma pelo próprio nome ou utilizar pronomes (“eu”, “meu”, “mim”) ao falar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não se refere a si próprio pelo nome.</li>
                              <li><strong>Às Vezes:</strong> Ao falar, refere-se a si próprio pelo nome (ou usa pronomes como “eu”, “mim”, “meu”).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L40 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L40 - Aponta para figuras de objetos comuns descritos pelo uso (até dez objetos).</div>
                          <div class="checkbox-interpretation">A criança deve identificar e apontar corretamente para até dez figuras de objetos comuns descritos pelo uso (exemplo: o que usamos para varrer, para beber etc.).</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item40" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item40" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item40" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item40"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item40">
                            <p><strong>Recursos Materiais:</strong> Figuras de objetos comuns (bola, colher, xícara, vassoura, sabonete, escova de dentes, cadeira, faca, torneira, relógio etc.).</p>
                            <p><strong>Condição:</strong> Apresentar à criança figuras de objetos e perguntar: “Qual objeto usamos para varrer?”, “Qual objeto usamos para beber?”, etc.</p>
                            <p><strong>Resposta:</strong> Critério: apontar corretamente para, pelo menos, dez figuras de objetos comuns descritos pelo uso.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para figuras de objetos comuns descritos pelo uso.</li>
                              <li><strong>Às Vezes:</strong> Aponta para figuras de objetos comuns descritos pelo uso (até 10 objetos).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L41 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L41 - Mostra a idade pelos dedos.</div>
                          <div class="checkbox-interpretation">A criança deve indicar quantos anos tem por meio dos dedos, demonstrando compreensão numérica básica e consciência etária.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item41" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item41" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item41" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item41"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item41">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “Me mostre com os dedos quantos anos você tem”.</p>
                            <p><strong>Resposta:</strong> Mostrar a idade pelos dedos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não mostra a idade pelos dedos.</li>
                              <li><strong>Às Vezes:</strong> Mostra a idade pelos dedos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L42 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L42 - Diz seu sexo quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve identificar corretamente se é menino ou menina, homem ou mulher, demonstrando consciência de gênero.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item42" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item42" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item42" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item42"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item42">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar: “Você é menino ou menina?”, ou “Você é homem ou mulher?”.</p>
                            <p><strong>Resposta:</strong> Responder adequadamente dizendo menino ou menina, homem ou mulher, de acordo com seu sexo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz seu sexo quando solicitado.</li>
                              <li><strong>Às Vezes:</strong> Diz corretamente seu sexo quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L43 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L43 - Obedece à sequência de duas ordens relacionadas.</div>
                          <div class="checkbox-interpretation">A criança deve realizar duas ações sequenciais relacionadas quando solicitadas, demonstrando compreensão de instruções compostas e capacidade de executar sequência de comandos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item43" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item43" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item43" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item43"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item43">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns.</p>
                            <p><strong>Condição:</strong> Fornecer uma ordem composta de duas ações relacionadas (exemplo: “Beba o leite e limpe a boca”, “Coloque a bola no chão e chute a bola”, “Pegue o lápis e traga-o aqui”, etc.).</p>
                            <p><strong>Resposta:</strong> Realizar as ações contidas na sequência de duas ordens relacionadas.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não obedece à sequência de duas ordens solicitadas.</li>
                              <li><strong>Às Vezes:</strong> Obedece à sequência de duas ordens relacionadas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L44 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L44 - Usa a forma do verbo no gerúndio (correndo, comendo).</div>
                          <div class="checkbox-interpretation">A criança deve empregar corretamente o verbo no gerúndio para indicar ações em andamento (exemplo: “estou correndo”, “ele está comendo”), demonstrando desenvolvimento de aspectos gramaticais mais complexos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item44" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item44" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item44" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item44"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item44">
                            <p><strong>Recursos Materiais:</strong> Ambiente natural ou figuras de ações.</p>
                            <p><strong>Condição:</strong> Perguntar “O que você/ele está fazendo?” e observar se a criança responde utilizando o gerúndio (“estou correndo”, “ele está comendo”).</p>
                            <p><strong>Resposta:</strong> Usar a forma do verbo no gerúndio para indicar ações em andamento.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa a forma do verbo no gerúndio.</li>
                              <li><strong>Às Vezes:</strong> Usa a forma do verbo no gerúndio.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L45 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L45 - Emprega formas regulares no plural (livro/livros).</div>
                          <div class="checkbox-interpretation">A criança deve usar corretamente as formas regulares de plural, demonstrando compreensão do número gramatical ao falar (exemplo: “livro/livros”, “bola/bolas”).</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item45" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item45" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item45" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item45"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item45">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns em quantidade maior do que um, como livros, blocos, bolas, etc.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar em sua conversa habitual exemplos de emprego de formas regulares no plural, propor questões que a levem, com alta probabilidade, à emissão de tais formas. Por exemplo: “Quantos blocos você tem aí?”.</p>
                            <p><strong>Resposta:</strong> Empregar formas regulares no plural (livro/livros).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega formas regulares do plural.</li>
                              <li><strong>Às Vezes:</strong> Emprega formas regulares do plural.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L46 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L46 - Emprega algumas formas irregulares de verbos no passado de forma sistemática (foi, fez, era).</div>
                          <div class="checkbox-interpretation">A criança deve demonstrar uso de algumas formas irregulares de verbos no passado (exemplo: “foi”, “fez”, “era”) em suas falas, indicando desenvolvimento das estruturas verbais mais complexas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item46" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item46" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item46" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item46"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item46">
                            <p><strong>Recursos Materiais:</strong> Ilustrações de situações que favoreçam o uso de verbos no passado (ex.: sequência de ações).</p>
                            <p><strong>Condição:</strong> Criar situações em que a criança observe uma sequência de ações ou ilustrações e perguntar: “O que aconteceu nesta história?” para que ela utilize verbos no passado.</p>
                            <p><strong>Resposta:</strong> Formar frases ou responder a perguntas utilizando pelo menos três formas diferentes de verbos no passado de forma sistemática (exemplo: ir, fazer, ser).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega algumas formas irregulares de verbos no passado.</li>
                              <li><strong>Às Vezes:</strong> Emprega algumas formas irregulares de verbos no passado de forma sistemática.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L47 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L47 - Faz perguntas do tipo “O que é (isso)?”.</div>
                          <div class="checkbox-interpretation">A criança deve formular perguntas do tipo “O que é isso?” ou “O que é isto?” em diferentes situações, demonstrando curiosidade e uso de linguagem interrogativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item47" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item47" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item47" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item47"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item47">
                            <p><strong>Recursos Materiais:</strong> Situação natural ou jogos com objetos/desenhos.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar em suas verbalizações habituais perguntas como “O que é isso?”, propor situações de jogos onde ela deva perguntar “O que é isto/isso?”.</p>
                            <p><strong>Resposta:</strong> Fazer pelo menos três perguntas diferentes do tipo “O que é isto/isso?”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não faz perguntas do tipo “o que é isso?”.</li>
                              <li><strong>Às Vezes:</strong> Faz pelo menos 3 perguntas do tipo “o que é isso?”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L48 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L48 - Controla o volume da voz 90% das vezes.</div>
                          <div class="checkbox-interpretation">A criança deve demonstrar controle do volume da voz em situações que exijam falar mais alto ou mais baixo, atendendo pedidos ou circunstâncias específicas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item48" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item48" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item48" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item48"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item48">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Solicitar que a criança fale alto ou baixo, ou criar brincadeiras que exijam alternar volume de voz (falar alto/baixinho).</p>
                            <p><strong>Resposta:</strong> Critério: controlar o volume da voz de acordo com a ordem dada em pelo menos cinco de seis tentativas, sendo que pelo menos duas deverão envolver falar baixo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não controla o volume de voz.</li>
                              <li><strong>Às Vezes:</strong> Controla o volume de voz em pelo menos 5 de 6 tentativas, sendo que pelo menos 2 deverão envolver falar baixo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L49 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L49 - Usa “este/esta” (“esse/essa”) e “aquele/aquela” na fala.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar corretamente os demonstrativos “este/esta (esse/essa)” e “aquele/aquela” para diferenciar objetos próximos ou distantes, demonstrando habilidades de referência espacial na fala.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item49" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item49" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item49" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item49"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item49">
                            <p><strong>Recursos Materiais:</strong> Brinquedos e objetos comuns posicionados em distâncias diferentes da criança.</p>
                            <p><strong>Condição:</strong> Pedir à criança que escolha ou aponte xícaras, camisas, brinquedos, comidas etc., variando a distância para que a criança possa usar “este/essa” e “aquele/aquela” adequadamente.</p>
                            <p><strong>Resposta:</strong> Usar “este/esta” (“esse/essa”) e “aquele/aquela” na fala.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa “este/esta (esse/essa)” e “aquele/aquela”.</li>
                              <li><strong>Às Vezes:</strong> Usa “este/esta” (“esse/essa”) e “aquele/aquela” na fala.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L50 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L50 - Emprega “é” e “está” em frases simples (isto é uma bola; a bola está aqui).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar os verbos “ser” e “estar” em frases curtas para descrever objetos e sua localização, demonstrando estruturação básica de frases.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item50" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item50" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item50" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item50"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item50">
                            <p><strong>Recursos Materiais:</strong> Brinquedos e objetos comuns.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar espontaneamente uso de frases simples com “é” e “está”, fazer perguntas como: “Onde está a bola?”, “De quem é a bola?”, “De que cor é a bola?”.</p>
                            <p><strong>Resposta:</strong> Empregar “é” ou “está” em pelo menos três frases simples, sendo que pelo menos uma frase deva envolver o verbo ser/estar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega “é” e “está” em frases simples.</li>
                              <li><strong>Às Vezes:</strong> Emprega “é” ou “está” em pelo menos 3 frases simples.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L51 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L51 - Diz “eu”, “mim”, “meu” ao invés do próprio nome.</div>
                          <div class="checkbox-interpretation">A criança deve começar a usar pronomes pessoais e possessivos em lugar do próprio nome ao se referir a si mesma ou seus pertences, demonstrando progressão na aquisição de pronomes.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item51" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item51" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item51" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item51"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item51">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas como: “De quem é o brinquedo?”, “Quem quer uma bolacha?”, “Quem é você?”, etc. e observar se a criança utiliza “eu”, “mim”, “meu” ao responder.</p>
                            <p><strong>Resposta:</strong> Dizer “eu”, “mim”, “meu” ao invés do próprio nome.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz “eu”, “mim”, “meu” ao invés do próprio nome.</li>
                              <li><strong>Às Vezes:</strong> Diz “eu”, “mim”, “meu” ao invés do próprio nome.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L52 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L52 - Aponta para o objeto que “não é...” (não é uma bola).</div>
                          <div class="checkbox-interpretation">A criança deve demonstrar compreensão do conceito de negação ao identificar entre dois objetos qual “não é” o objeto mencionado, revelando entendimento semântico e cognitivo de exclusão.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item52" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item52" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item52" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item52"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item52">
                            <p><strong>Recursos Materiais:</strong> Objetos conhecidos pela criança, em grupos de dois.</p>
                            <p><strong>Condição:</strong> Apresentar à criança dois objetos (exemplo: uma bola e uma xícara) e pedir que ela aponte para o que “não é bola”.</p>
                            <p><strong>Resposta:</strong> Apontar para o objeto que “não é ...” (por exemplo, “não é uma bola”).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para o objeto que “não é...”</li>
                              <li><strong>Às Vezes:</strong> Aponta para o objeto que “não é...”</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L53 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L53 - Responde à pergunta “quem?” dando um nome.</div>
                          <div class="checkbox-interpretation">A criança deve responder à pergunta “quem?” identificando a pessoa ou personagem pelo nome, demonstrando habilidades linguísticas de referência a agentes específicos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item53" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item53" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item53" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item53"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item53">
                            <p><strong>Recursos Materiais:</strong> Situação no ambiente natural ou uso de ilustrações com pessoas/animais.</p>
                            <p><strong>Condição:</strong> Perguntar “Quem é ...?” ou “Quem está ...?” e observar se a criança responde dando um nome (exemplo: “É o papai”, “É a mamãe”).</p>
                            <p><strong>Resposta:</strong> Responder à pergunta “quem?” dando um nome.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde à pergunta “quem?” dando um nome.</li>
                              <li><strong>Às Vezes:</strong> Responde à pergunta “quem?” dando um nome.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L54 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L54 - Emprega a forma possessiva dos substantivos (do papai).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar a forma possessiva dos substantivos em frases, indicando de quem é determinado objeto (exemplo: “do papai”, “da mamãe”).</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item54" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item54" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item54" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item54"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item54">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar “De quem é este (objeto)?”, observando se a criança responde usando a forma possessiva (ex.: “do papai”).</p>
                            <p><strong>Resposta:</strong> Empregar a forma possessiva dos substantivos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega a forma possessiva dos substantivos.</li>
                              <li><strong>Às Vezes:</strong> Emprega a forma possessiva dos substantivos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L55 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L55 - Usa artigos ao falar: o, a, os, as, um, uma, uns, umas.</div>
                          <div class="checkbox-interpretation">A criança deve empregar ao menos um artigo definido e um indefinido ao falar, demonstrando desenvolvimento de estruturas gramaticais de artigos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item55" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item55" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item55" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item55"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item55">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não empregar artigos em sua fala habitual, fazer perguntas como: “O que é isso?” apontando um objeto (mesa, brinquedo, livro) ou “De que cor é o sol?” etc.</p>
                            <p><strong>Resposta:</strong> Critério: usar pelo menos um artigo definido e um indefinido ao falar.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa artigos ao falar.</li>
                              <li><strong>Às Vezes:</strong> Usa ao menos 1 artigo definido e 1 artigo indefinido ao falar.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L56 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L56 - Usa alguns substantivos que indicam grupo ou categoria (brinquedo, animal, comida).</div>
                          <div class="checkbox-interpretation">A criança deve usar palavras genéricas que descrevem categorias (exemplo: “brinquedo”, “animal”, “comida”), demonstrando habilidades de classificação semântica.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item56" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item56" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item56" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item56"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item56">
                            <p><strong>Recursos Materiais:</strong> Ilustrações ou objetos de várias categorias (brinquedos, animais, comidas, etc.).</p>
                            <p><strong>Condição:</strong> Misturar ilustrações ou objetos de várias categorias e mostrar um objeto à criança, pedindo que ela diga se é brinquedo, animal ou comida.</p>
                            <p><strong>Resposta:</strong> Usar pelo menos três substantivos diferentes que indiquem grupo ou categoria.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa alguns substantivos que indicam grupo ou categoria.</li>
                              <li><strong>Às Vezes:</strong> Usa ao menos 3 substantivos diferentes que indiquem grupo ou categoria.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L57 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L57 - Usa verbos “ser”, “estar” e “ter” no presente, cometendo poucos erros.</div>
                          <div class="checkbox-interpretation">A criança deve empregar corretamente os verbos “ser”, “estar” e “ter” no presente do indicativo, demonstrando aquisição de estruturas verbais fundamentais.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item57" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item57" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item57" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item57"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item57">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar: “Quem é você?”, “Onde você está?”, “O que você tem na mão?” e observar se a criança responde adequadamente: “Sou...”, “Estou na...”, “Tenho...”.</p>
                            <p><strong>Resposta:</strong> Usar verbos “ser/estar/ter” no presente com poucos erros.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa verbos “ser/estar” no presente.</li>
                              <li><strong>Às Vezes:</strong> Usa verbos “ser/estar” no presente cometendo poucos erros.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L58 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L58 - Diz se os objetos estão “abertos” ou “fechados”.</div>
                          <div class="checkbox-interpretation">A criança deve identificar e expressar se os objetos (frascos, caixas, portas etc.) estão abertos ou fechados, demonstrando compreensão de estados físicos e uso de adjetivos apropriados.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem2_3_item58" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item58" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem2_3_item58" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem2_3_item58"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem2_3_item58">
                            <p><strong>Recursos Materiais:</strong> Frascos, caixas, portas etc., que possam ser abertos ou fechados.</p>
                            <p><strong>Condição:</strong> Abrir ou fechar os objetos e perguntar à criança: “(tal objeto) está aberto ou fechado?”</p>
                            <p><strong>Resposta:</strong> Dizer se os objetos estão “abertos” ou “fechados”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz se os objetos estão abertos ou fechados.</li>
                              <li><strong>Às Vezes:</strong> Diz se os objetos estão abertos ou fechados.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 3 - 4 anos - Linguagem -->
                    <div id="ling3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3 - 4 anos</h5>
                        
                        <!-- Card L59 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L59 - Expressa diminutivos e aumentativos quando fala?</div>
                          <div class="checkbox-interpretation">A criança deve responder perguntas usando diminutivos e aumentativos, demonstrando compreensão de variações de tamanho e intensidade na linguagem.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item59" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item59" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item59" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item59"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item59">
                            <p><strong>Recursos Materiais:</strong> Ilustrações com imagens de tamanhos nitidamente grande e pequenos.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar diminutivos e aumentativos em suas verbalizações habituais, propor perguntas que levem a respostas envolvendo aumentativos e diminutivos com alta probabilidade. Por exemplo: apresentar à criança uma ilustração contendo um cachorro do tamanho normal, um cachorro nitidamente grande e um nitidamente pequeno e pedir que ela diga o que está vendo. Se necessário, dar instruções adicionais, tais como: “Que outra maneira existe para se referir quando um cachorro é pequeno?”.</p>
                            <p><strong>Resposta:</strong> Critério: responder perguntas com frases ou palavras que apresentem pelo menos um diminutivo e um aumentativo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não expressa diminutivos e aumentativos.</li>
                              <li><strong>Às Vezes:</strong> Responde perguntas com frases ou palavras que apresentem pelo menos 1 aumentativo e 1 diminutivo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L60 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L60 - Presta atenção durante cinco minutos a uma história lida.</div>
                          <div class="checkbox-interpretation">A criança deve permanecer atenta a uma história lida e responder adequadamente a perguntas simples sobre a mesma, demonstrando habilidades de escuta e compreensão.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item60" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item60" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item60" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item60"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item60">
                            <p><strong>Recursos Materiais:</strong> Livro infantil com figuras, contendo cerca de três a quatro sentenças por página.</p>
                            <p><strong>Condição:</strong> </p>
                            <p><strong>Resposta:</strong> Prestar atenção = permanecer sentado “ouvindo” a história e responder adequadamente a pelo menos três questões simples a respeito da história lida.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não presta atenção durante 5 minutos a uma história lida.</li>
                              <li><strong>Às Vezes:</strong> Presta atenção durante 5 minutos e responde adequadamente pelo menos 3 perguntas simples a respeito da história.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L61 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L61 - Obedece a uma sequência de duas ordens não relacionadas.</div>
                          <div class="checkbox-interpretation">A criança deve realizar duas ações sequenciais não relacionadas quando solicitadas, demonstrando compreensão de instruções compostas e capacidade de executar múltiplas tarefas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item61" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item61" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item61" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item61"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item61">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Apresentar à criança ordens do tipo “Traga um livro e feche a caixa de brinquedos” ou “Traga a bola e feche a porta” ou “Abre a boca e feche os olhos”.</p>
                            <p><strong>Resposta:</strong> Obedecer a uma sequência de duas ordens não relacionadas, ou seja, ordens que envolvam dois objetos diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não obedece a uma sequência de duas ordens não relacionadas.</li>
                              <li><strong>Às Vezes:</strong> Obedece a uma sequência de duas ordens não relacionadas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L62 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L62 - Diz seu nome completo quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar seu nome completo (nome e pelo menos um sobrenome) quando solicitado, demonstrando reconhecimento de identidade pessoal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item62" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item62" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item62" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item62"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item62">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> </p>
                            <p><strong>Resposta:</strong> Nome completo = nome(s) ou apelido e pelo menos um dos sobrenomes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz seu nome completo.</li>
                              <li><strong>Às Vezes:</strong> Diz seu nome completo quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L63 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L63 - Responde a perguntas simples envolvendo “Como?”.</div>
                          <div class="checkbox-interpretation">A criança deve responder adequadamente a perguntas iniciadas com “Como?”, demonstrando compreensão de procedimentos e capacidade de descrever processos simples.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item63" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item63" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item63" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item63"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item63">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas à criança envolvendo “como” para atividades diárias (exemplo: “Como a gente toma banho?”, “Como abrimos a porta?”) ou para se referir a contos com ilustrações (exemplo: “Como Joãozinho fez para encontrar o caminho de volta para casa?”).</p>
                            <p><strong>Resposta:</strong> Responder a perguntas simples envolvendo “como” com frases de duas a quatro palavras.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde a perguntas simples envolvendo “como”.</li>
                              <li><strong>Às Vezes:</strong> Responde a perguntas simples envolvendo “como” com frases de 2 a 4 palavras.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L64 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L64 - Emprega verbos regulares no passado (pulou, pulava).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar corretamente verbos regulares no passado, demonstrando compreensão de tempo verbal e capacidade de narrar ações passadas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item64" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item64" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item64" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item64"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item64">
                            <p><strong>Recursos Materiais:</strong> Ilustrações que representem ações no passado.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar verbos regulares no passado em suas verbalizações habituais, fazer perguntas, baseadas ou não em ilustrações, como: “O que o gato fez quando viu o rato?”, etc.</p>
                            <p><strong>Resposta:</strong> Empregar verbos regulares no passado (pulou, pulava).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega verbos regulares no passado.</li>
                              <li><strong>Às Vezes:</strong> Emprega verbos regulares no passado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L65 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L65 - Relata experiências imediatas.</div>
                          <div class="checkbox-interpretation">A criança deve descrever ações que estão ocorrendo no momento, demonstrando habilidade de relatar experiências presentes e imediatas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item65" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item65" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item65" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item65"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item65">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas do tipo: “O que você está fazendo?”, “O que o papai está fazendo com o livro?”, “O que você está fazendo na TV?”.</p>
                            <p><strong>Resposta:</strong> Experiências imediatas = experiências que estão ocorrendo no mesmo momento em que a questão é feita.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não relata experiências imediatas.</li>
                              <li><strong>Às Vezes:</strong> Relata experiências imediatas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L66 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L66 - Diz como são usados objetos comuns.</div>
                          <div class="checkbox-interpretation">A criança deve descrever a função de objetos comuns, demonstrando compreensão do uso funcional e vocabulário relacionado a objetos do cotidiano.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item66" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item66" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item66" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item66"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item66">
                            <p><strong>Recursos Materiais:</strong> Martelo, tesoura, carro, xícara, lápis, etc.</p>
                            <p><strong>Condição:</strong> Mostrar à criança um objeto e perguntar a ela: “O que fazemos com isto?” ou “Para que serve isto?”.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “Para que serve um (martelo)?”, responder identificando adequadamente a função do objeto.</p>
                            <p><strong>Critério:</strong> Dizer como são usados pelo menos três objetos comuns diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz como são usados objetos comuns.</li>
                              <li><strong>Às Vezes:</strong> Diz como são usados pelo menos 3 objetos comuns diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L67 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L67 - Expressa ações futuras empregando os verbos “ir”, “ter”, “querer” (Vou comer).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos que indicam ações futuras, demonstrando capacidade de planejar e expressar intenções futuras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item67" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item67" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item67" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item67"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item67">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não expressar ações futuras empregando verbos “ir”, “ter”, “querer” em suas verbalizações habituais, imediatamente (cinco a dez minutos) antes de realizar uma atividade (tomar banho, comer, ir à loja, etc.) pedir a ela o que diga o que vai acontecer ou fazer. Exemplo: “O que você vai fazer agora?”, “O que tem que fazer agora?”, “O que você vai querer comer no almoço?”.</p>
                            <p><strong>Resposta:</strong> Critério: expressar pelo menos duas ações futuras empregando os verbos “ter” ou “querer” e “ir”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não expressa ações futuras empregando os verbos “ir/ter/querer”.</li>
                              <li><strong>Às Vezes:</strong> Expressa pelo menos duas ações futuras empregando os verbos “ter” ou “querer” e “ir”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L68 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L68 - Utiliza adequadamente masculino e feminino na fala.</div>
                          <div class="checkbox-interpretation">A criança deve diferenciar e utilizar corretamente os gêneros masculino e feminino ao falar, demonstrando compreensão de concordância de gênero na linguagem.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item68" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item68" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item68" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item68"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item68">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não utilizar adequadamente masculino e feminino em suas verbalizações habituais, fazer questões (com ou sem ajuda de ilustrações) do tipo: “Como chama o ‘marido’ da vaca?”, “E a ‘mulher’ do gato?”, “E o ‘marido’ da galinha?”, etc.</p>
                            <p><strong>Resposta:</strong> Utilizar adequadamente masculino e feminino na fala.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não utiliza adequadamente o masculino e feminino na fala.</li>
                              <li><strong>Às Vezes:</strong> Utiliza adequadamente masculino e feminino na fala.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L69 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L69 - Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos no modo condicional para expressar possibilidades ou hipóteses, demonstrando habilidades de linguagem mais avançadas e pensamento hipotético.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item69" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item69" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item69" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item69"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item69">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não empregar verbos em seu tempo condicional em suas verbalizações habituais, fazer perguntas do tipo: “O que você faria se estivesse andando de bicicleta e caísse?”, “O que você faria se fosse ao supermercado comprar algo para sua mãe e perdesse o dinheiro no caminho?”, “O que você faria se fosse convidado para uma festa e não tivesse roupa para ir?”.
                        
                            </p>
                            <p><strong>Resposta:</strong> Dada uma pergunta envolvendo o uso de condicional, responder utilizando ou fazendo referência a um tempo condicional do verbo, ou já ter empregado ao falar pelo menos 1 frase com o uso do condicional.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega o condicional ao falar.</li>
                              <li><strong>Às Vezes:</strong> Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L70 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L70 - Conta dois fatos na ordem de ocorrência.</div>
                          <div class="checkbox-interpretation">A criança deve narrar duas ações em sequência cronológica correta, demonstrando habilidades narrativas e compreensão temporal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item70" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item70" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item70" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item70"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item70">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer com que a criança observe realizando duas atividades (por exemplo: dando palmadas na cabeça e em seguida batendo palmas) e pedir à criança que descreva o que você fez na ordem correta.</p>
                            <p><strong>Resposta:</strong> Contar dois fatos na ordem de ocorrência.</p>
                            <p><strong>Critérios:</strong> X= Não conta dois fatos na ordem de ocorrência; V= Conta dois fatos na ordem de ocorrência; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta dois fatos na ordem de ocorrência.</li>
                              <li><strong>Às Vezes:</strong> Conta dois fatos na ordem de ocorrência.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 4 - 5 anos - Linguagem -->
                    <div id="ling4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4 - 5 anos</h5>
                        
                        <!-- Card L59 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L59 - Expressa diminutivos e aumentativos quando fala?</div>
                          <div class="checkbox-interpretation">A criança deve responder a perguntas ou elaborar frases utilizando diminutivos e aumentativos, demonstrando compreensão e aplicação desses aumentos e reduções de tamanho na linguagem.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item59" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item59" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item59" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item59"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item59">
                            <p><strong>Recursos Materiais:</strong> Ilustrações com imagens de tamanhos nitidamente grandes e pequenos.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar diminutivos e aumentativos em suas verbalizações habituais, propor perguntas que levem a respostas envolvendo aumentativos e diminutivos com alta probabilidade. Por exemplo: apresentar à criança uma ilustração contendo um cachorro do tamanho normal, um cachorro nitidamente grande e um nitidamente pequeno e pedir que ela diga o que está vendo. Se necessário, dar instruções adicionais, tais como: “Que outra maneira existe para se referir quando um cachorro é pequeno?”.</p>
                            <p><strong>Resposta:</strong> Critério: responder perguntas com frases ou palavras que apresentem pelo menos um diminutivo e um aumentativo.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não expressa diminutivos e aumentativos.</li>
                              <li><strong>Às Vezes:</strong> Responde perguntas com frases ou palavras que apresentem pelo menos 1 aumentativo e 1 diminutivo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L60 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L60 - Presta atenção durante cinco minutos a uma história lida.</div>
                          <div class="checkbox-interpretation">A criança deve permanecer concentrada durante a leitura de uma história e responder adequadamente a questões simples sobre o conteúdo, demonstrando habilidades de escuta e compreensão narrativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item60" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item60" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item60" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item60"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item60">
                            <p><strong>Recursos Materiais:</strong> Livro infantil com figuras, contendo cerca de três a quatro sentenças por página.</p>
                            <p><strong>Condição:</strong> Ler uma história para a criança e observar sua atenção durante cinco minutos, além de fazer perguntas simples sobre a história para avaliar a compreensão.</p>
                            <p><strong>Resposta:</strong> Prestar atenção = permanecer sentado “ouvindo” a história e responder adequadamente a pelo menos três questões simples a respeito da história lida.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não presta atenção durante 5 minutos a uma história lida.</li>
                              <li><strong>Às Vezes:</strong> Presta atenção durante 5 minutos e responde adequadamente pelo menos 3 perguntas simples a respeito da história.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L61 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L61 - Obedece a uma sequência de duas ordens não relacionadas.</div>
                          <div class="checkbox-interpretation">A criança deve realizar duas ações sequenciais que envolvem objetos ou contextos diferentes, demonstrando capacidade de seguir instruções compostas que não estão diretamente relacionadas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item61" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item61" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item61" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item61"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item61">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Apresentar à criança ordens do tipo “Traga um livro e feche a caixa de brinquedos” ou “Traga a bola e feche a porta” ou “Abre a boca e feche os olhos”.</p>
                            <p><strong>Resposta:</strong> Obedecer a uma sequência de duas ordens não relacionadas, ou seja, ordens que envolvam dois objetos diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não obedece a uma sequência de duas ordens não relacionadas.</li>
                              <li><strong>Às Vezes:</strong> Obedece a uma sequência de duas ordens não relacionadas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L62 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L62 - Diz seu nome completo quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve vocalizar seu nome completo ou incluir seu(s) sobrenome(s) quando solicitado, demonstrando reconhecimento de sua identidade plena.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item62" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item62" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item62" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item62"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item62">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Quando solicitado, pedir à criança que diga seu nome completo.</p>
                            <p><strong>Resposta:</strong> Dizer seu nome completo = nome(s) ou apelido e pelo menos um dos sobrenomes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz seu nome completo.</li>
                              <li><strong>Às Vezes:</strong> Diz seu nome completo quando solicitado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L63 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L63 - Responde a perguntas simples envolvendo “Como?”.</div>
                          <div class="checkbox-interpretation">A criança deve responder a perguntas que iniciam com “Como?”, utilizando frases de duas a quatro palavras, demonstrando compreensão de processos e métodos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item63" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item63" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item63" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item63"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item63">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas à criança envolvendo “como” para atividades diárias (exemplo: “Como a gente toma banho?”, “Como abrimos a porta?”) ou para se referir a contos com ilustrações (exemplo: “Como Joãozinho fez para encontrar o caminho de volta para casa?”).</p>
                            <p><strong>Resposta:</strong> Responder a perguntas simples envolvendo “como” com frases de duas a quatro palavras.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde a perguntas simples envolvendo “como”.</li>
                              <li><strong>Às Vezes:</strong> Responde a perguntas simples envolvendo “como” com frases de 2 a 4 palavras.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L64 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L64 - Emprega verbos regulares no passado (pulou, pulava).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos regulares no passado em suas frases, demonstrando compreensão e aplicação das conjugações verbais em tempos passados.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item64" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item64" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item64" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item64"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item64">
                            <p><strong>Recursos Materiais:</strong> Ilustrações de ações no passado.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar verbos regulares no passado em suas verbalizações habituais, fazer perguntas baseadas ou não em ilustrações, por exemplo: “O que o gato fez quando viu o rato?”.</p>
                            <p><strong>Resposta:</strong> Empregar verbos regulares no passado (pulou, pulava).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega verbos regulares no passado.</li>
                              <li><strong>Às Vezes:</strong> Emprega verbos regulares no passado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L65 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L65 - Relata experiências imediatas.</div>
                          <div class="checkbox-interpretation">A criança deve descrever ações ou eventos que estão ocorrendo no mesmo momento em que são questionadas, demonstrando capacidade de referência temporal presente.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item65" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item65" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item65" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item65"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item65">
                            <p><strong>Recursos Materiais:</strong> Situações naturais ou objetos que facilitem a descrição da ação (comer, beber, andar, pular, etc.).</p>
                            <p><strong>Condição:</strong> Fazer perguntas do tipo: “O que você está fazendo?”, “O que o papai está fazendo com o livro?”, “O que você está fazendo na TV?”.</p>
                            <p><strong>Resposta:</strong> Relatar experiências imediatas = experiências que estão ocorrendo no mesmo momento em que a questão é feita.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não relata experiências imediatas.</li>
                              <li><strong>Às Vezes:</strong> Relata experiências imediatas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L66 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L66 - Diz como são usados objetos comuns.</div>
                          <div class="checkbox-interpretation">A criança deve descrever a função ou o uso de objetos cotidianos, demonstrando compreensão semântica e funcional dos itens ao seu redor.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item66" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item66" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item66" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item66"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item66">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns como martelo, tesoura, carro, xícara, lápis, etc.</p>
                            <p><strong>Condição:</strong> Mostrar à criança um objeto e perguntar a ela: “O que fazemos com isto?” ou “Para que serve isto?”.</p>
                            <p><strong>Resposta:</strong> Frente à pergunta: “Para que serve um (martelo)?”, responder identificando adequadamente a função do objeto.</p>
                            <p><strong>Critério:</strong> Dizer como são usados pelo menos três objetos comuns diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz como são usados objetos comuns.</li>
                              <li><strong>Às Vezes:</strong> Diz como são usados pelo menos 3 objetos comuns diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L67 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L67 - Expressa ações futuras empregando os verbos “ir”, “ter”, “querer” (Vou comer).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos que indicam ações futuras, como “ir”, “ter” e “querer”, para descrever o que planeja fazer, demonstrando entendimento de planos e intenções futuras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item67" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item67" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item67" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item67"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item67">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não expressar ações futuras empregando verbos “ir”, “ter”, “querer” em suas verbalizações habituais, imediatamente (cinco a dez minutos) antes de realizar uma atividade (tomar banho, comer, ir à loja, etc.) pedir a ela o que diga o que vai acontecer ou fazer. Exemplo: “O que você vai fazer agora?”, “O que tem que fazer agora?”, “O que você vai querer comer no almoço?”.</p>
                            <p><strong>Resposta:</strong> Critério: expressar pelo menos duas ações futuras empregando os verbos “ter” ou “querer” e “ir”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não expressa ações futuras empregando os verbos “ir/ter/querer”.</li>
                              <li><strong>Às Vezes:</strong> Expressa pelo menos duas ações futuras empregando os verbos “ter” ou “querer” e “ir”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L68 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L68 - Utiliza adequadamente masculino e feminino na fala.</div>
                          <div class="checkbox-interpretation">A criança deve usar corretamente os gêneros masculino e feminino ao falar, demonstrando compreensão das categorias gramaticais de gênero.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item68" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item68" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item68" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item68"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item68">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não utilizar adequadamente masculino e feminino nas suas verbalizações habituais, fazer questões (com ajuda ou não de ilustrações) do tipo: “Como chama o ‘marido’ da vaca?”, “E a ‘mulher’ do gato?”, “E o ‘marido’ da galinha?” etc.</p>
                            <p><strong>Resposta:</strong> Utilizar adequadamente masculino e feminino na fala.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não utiliza adequadamente o masculino e feminino na fala.</li>
                              <li><strong>Às Vezes:</strong> Utiliza adequadamente masculino e feminino na fala.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L69 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L69 - Emprega formas imperativas do verbo ao pedir favores.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar corretamente as formas imperativas dos verbos ao solicitar favores ou fazer pedidos, demonstrando habilidades de comunicação assertiva.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item69" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item69" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item69" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item69"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item69">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não usa formas imperativas de verbos em suas verbalizações habituais (“Me passa o café” na hora da refeição, etc.), proporcionar uma situação de um jogo ou brincadeira de loja ou “vendinha” em que, após o modelo, a criança deverá ser o freguês pedindo coisas, por exemplo: “Me mostre as laranjas”, “Me pese ½ quilo de tomate”, “Me dê o troco”.</p>
                            <p><strong>Resposta:</strong> Usar formas imperativas do verbo ao pedir favores.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa formas imperativas do verbo ao pedir favores.</li>
                              <li><strong>Às Vezes:</strong> Usa formas imperativas do verbo ao pedir favores.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L70 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L70 - Conta dois fatos na ordem de ocorrência.</div>
                          <div class="checkbox-interpretation">A criança deve relatar dois eventos em sequência correta, demonstrando compreensão de temporalidade e capacidade de organizar narrativas simples.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem3_4_item70" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item70" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem3_4_item70" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem3_4_item70"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem3_4_item70">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer com que a criança observe realizando duas atividades (por exemplo: dando palmadas na cabeça e em seguida batendo palmas) e pedir à criança que descreva o que você fez na ordem correta.</p>
                            <p><strong>Resposta:</strong> Contar dois fatos na ordem de ocorrência.</p>
                            <p><strong>Critérios:</strong> X= Não conta dois fatos na ordem de ocorrência; V= Conta dois fatos na ordem de ocorrência; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta dois fatos na ordem de ocorrência.</li>
                              <li><strong>Às Vezes:</strong> Conta dois fatos na ordem de ocorrência.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L71 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L71 - Obedece a uma sequência envolvendo três ordens.</div>
                          <div class="checkbox-interpretation">A criança deve seguir uma sequência de três instruções que envolvem diferentes objetos, demonstrando capacidade de entender e executar comandos complexos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item71" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item71" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item71" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item71"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item71">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Propor à criança uma sequência de três ordens, por exemplo: “Vista a camisa, sente-se e calce os sapatos” ou “Pegue a bola, ponha a bola em cima da mesa e me traga o livro”.</p>
                            <p><strong>Resposta:</strong> Obedecer a uma sequência de três ordens que envolva pelo menos mais de um objeto.</p>
                            <p><strong>Critérios:</strong> X= Não obedece a uma sequência envolvendo 3 ordens; V= Obedece a uma sequência de 3 ordens que envolva pelo menos mais de 1 objeto; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não obedece a uma sequência envolvendo 3 ordens.</li>
                              <li><strong>Às Vezes:</strong> Obedece a uma sequência de 3 ordens que envolva pelo menos mais de 1 objeto.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L72 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L72 - Demonstra compreensão elementar de verbos reflexivos usando-os ocasionalmente ao falar (ela se machucou).</div>
                          <div class="checkbox-interpretation">A criança deve entender e utilizar verbos reflexivos em suas frases, demonstrando conhecimento sobre ações que afetam o próprio sujeito.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item72" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item72" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item72" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item72"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item72">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não tiver apresentado, em suas verbalizações habituais, uma frase com verbo reflexivo, contar uma pequena história, por exemplo: “Pedro e Maria foram ao cinema. Na saída Maria caiu e se machucou.” e perguntar: “Quem se machucou?”.</p>
                            <p><strong>Resposta:</strong> Dada uma frase envolvendo um verbo reflexivo e uma pergunta do tipo “Quem ...?”, identificar que a pessoa sofreu a ação do verbo. Ou, já ter empregado, ao falar, pelo menos uma frase com verbo reflexivo.</p>
                            <p><strong>Critérios:</strong> X= Não demonstra compreensão elementar de verbos reflexivos; V= Demonstra compreensão elementar de verbos reflexivos usando-os ocasionalmente ao falar (ela se machucou); O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não demonstra compreensão elementar de verbos reflexivos.</li>
                              <li><strong>Às Vezes:</strong> Demonstra compreensão elementar de verbos reflexivos usando-os ocasionalmente ao falar (ela se machucou).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L73 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L73 - Consegue identificar objetos/figuras que formem par, sob solicitação.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de identificar e agrupar objetos ou figuras que formam pares, demonstrando habilidades de categorização e reconhecimento de duplicatas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item73" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item73" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item73" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item73"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item73">
                            <p><strong>Recursos Materiais:</strong> Objetos ou figuras de dois objetos idênticos: um par de sapatos, um par de luvas, de meias, etc.</p>
                            <p><strong>Condição:</strong> Apresentar os pares de objetos ou figuras misturadas e pedir à criança que:</p>
                            <ul>
                              <li>a) Coloque todos os pares juntos;</li>
                              <li>b) Aponte para um dos elementos de um determinado par de objetos;</li>
                              <li>c) Dê um par de objetos.</li>
                            </ul>
                            <p><strong>Resposta:</strong> Conseguir identificar objetos/figuras que formem par, sob solicitação.</p>
                            <p><strong>Critérios:</strong> X= Não consegue identificar objetos/figuras que formem par; V= Consegue identificar objetos/figuras que formem par, sob solicitação; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não consegue identificar objetos/figuras que formem par.</li>
                              <li><strong>Às Vezes:</strong> Consegue identificar objetos/figuras que formem par, sob solicitação.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L74 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L74 - Emprega verbos regulares no passado (pulou, pulava).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos regulares no passado em suas frases, demonstrando compreensão e aplicação das conjugações verbais em tempos passados.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item74" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item74" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item74" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item74"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item74">
                            <p><strong>Recursos Materiais:</strong> Ilustrações de ações no passado.</p>
                            <p><strong>Condição:</strong> Se a criança não apresentar verbos regulares no passado em suas verbalizações habituais, fazer perguntas baseadas ou não em ilustrações, por exemplo: “O que o gato fez quando viu o rato?”.</p>
                            <p><strong>Resposta:</strong> Empregar verbos regulares no passado (pulou, pulava).</p>
                            <p><strong>Critérios:</strong> X= Não emprega verbos regulares no passado; V= Emprega verbos regulares no passado; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega verbos regulares no passado.</li>
                              <li><strong>Às Vezes:</strong> Emprega verbos regulares no passado.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L75 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L75 - Relata uma história conhecida, sem ajuda de figuras.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de contar uma história que já conhece sem a necessidade de apoio visual, demonstrando memorização e capacidade de narração.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item75" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item75" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item75" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item75"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item75">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Levantar junto ao familiar quais histórias são conhecidas pela criança. Contar para a criança essa história três vezes e, em seguida, pedir que ela a repita.</p>
                            <p><strong>Resposta:</strong> Relatar uma história conhecida, sem ajuda de figuras.</p>
                            <p><strong>Critérios:</strong> X= Não relata uma história conhecida, sem ajuda de figuras; V= Relata uma história conhecida, sem ajuda de figuras; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não relata uma história conhecida, sem ajuda de figuras.</li>
                              <li><strong>Às Vezes:</strong> Relata uma história conhecida, sem ajuda de figuras.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L76 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L76 - Consegue identificar a parte de cima e de baixo de objetos, quando solicitado.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de distinguir e identificar corretamente as partes superiores e inferiores de objetos comuns, demonstrando compreensão de orientação espacial.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item76" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item76" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item76" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item76"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item76">
                            <p><strong>Recursos Materiais:</strong> Garrafas, camisas, mesa, cama, etc.</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “Me mostre a parte de cima da mesa” ou “Onde está a parte de baixo da garrafa?”.</p>
                            <p><strong>Resposta:</strong> Conseguir identificar = apontar a parte de cima e de baixo de objetos quando solicitado.</p>
                            <p><strong>Critério:</strong> Conseguir identificar a parte de cima e de baixo de pelo menos 3 objetos diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não identifica a parte de cima e de baixo de objetos.</li>
                              <li><strong>Às Vezes:</strong> Identifica a parte de cima e de baixo de pelo menos 3 objetos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L77 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L77 - Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos no tempo condicional em suas frases, demonstrando entendimento de possibilidades e hipóteses.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item77" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item77" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item77" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item77"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item77">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não empregar verbos em seu tempo condicional em suas verbalizações habituais, fazer perguntas do tipo: “O que você faria se estivesse andando de bicicleta e caísse?”, “O que você faria se fosse ao supermercado comprar algo para sua mãe e perdesse o dinheiro no caminho?”, “O que você faria se fosse convidado para uma festa e não tivesse roupa para ir?”.</p>
                            <p><strong>Resposta:</strong> Dada uma pergunta envolvendo o uso de condicional, responder utilizando ou fazendo referência a um tempo condicional do verbo, ou já ter empregado ao falar pelo menos 1 frase com o uso do condicional.</p>
                            <p><strong>Critérios:</strong> X= Não emprega o condicional ao falar; V= Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria); O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega o condicional ao falar.</li>
                              <li><strong>Às Vezes:</strong> Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L78 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L78 - Consegue identificar objetos/figuras que formem par, sob solicitação.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de identificar e agrupar objetos ou figuras que formam pares, demonstrando habilidades de categorização e reconhecimento de duplicatas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item78" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item78" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item78" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item78"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item78">
                            <p><strong>Recursos Materiais:</strong> Ilustrações de situações absurdas, por exemplo: um ninho de passarinhos em cima de uma árvore e um cachorro voando em direção ao ninho.</p>
                            <p><strong>Condição:</strong> Pedir à criança que nomeie o objeto que não pertence a uma determinada categoria (o que não é bicho).</p>
                            <p><strong>Resposta:</strong> Nomear o objeto que não pertence a uma determinada categoria (o que não é bicho).</p>
                            <p><strong>Critérios:</strong> X= Não nomeia o objeto que não pertence a uma determinada categoria; V= Nomeia o objeto que não pertence a determinada categoria; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não nomeia o objeto que não pertence a uma determinada categoria.</li>
                              <li><strong>Às Vezes:</strong> Nomeia o objeto que não pertence a determinada categoria.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L79 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L79 - Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria).</div>
                          <div class="checkbox-interpretation">A criança deve utilizar verbos no tempo condicional em suas frases, demonstrando entendimento de possibilidades e hipóteses.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item79" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item79" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item79" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item79"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item79">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não empregar verbos em seu tempo condicional em suas verbalizações habituais, fazer perguntas do tipo: “O que você faria se estivesse andando de bicicleta e caísse?”, “O que você faria se fosse ao supermercado comprar algo para sua mãe e perdesse o dinheiro no caminho?”, “O que você faria se fosse convidado para uma festa e não tivesse roupa para ir?”.</p>
                            <p><strong>Resposta:</strong> Dada uma pergunta envolvendo o uso de condicional, responder utilizando ou fazendo referência a um tempo condicional do verbo, ou já ter empregado ao falar pelo menos 1 frase com o uso do condicional.</p>
                            <p><strong>Critérios:</strong> X= Não emprega o condicional ao falar; V= Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria); O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega o condicional ao falar.</li>
                              <li><strong>Às Vezes:</strong> Emprega, ocasionalmente, o condicional, ao falar (poderia, pudesse, iria, ia, seria, faria).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L80 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L80 - Usa orações compostas por coordenação (“Chutei a bola e ela foi parar na rua.”).</div>
                          <div class="checkbox-interpretation">A criança deve formar orações compostas utilizando coordenação, conectando duas ou mais ações de forma coesa, demonstrando complexidade linguística.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item80" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item80" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item80" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item80"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item80">
                            <p><strong>Recursos Materiais:</strong> Ilustrações ou jogos que envolvam sequências de ações.</p>
                            <p><strong>Condição:</strong> Se a criança não usar orações compostas por coordenação em suas verbalizações habituais, propiciar situações (tais como ilustrações ou jogos) que envolvam diversas sequências de ações (por exemplo: ilustrações de um menino jogando bola e outra indo para o meio da rua) que possibilitem, com alta probabilidade, a emissão de orações compostas por coordenação. Se necessário, perguntar à criança: “Por que o menino está tomando banho?”.</p>
                            <p><strong>Resposta:</strong> Critério: apresentar pelo menos duas orações diferentes compostas por coordenação.</p>
                            <p><strong>Critérios:</strong> X= Não usa orações compostas por coordenação; V= Apresenta pelo menos 2 orações diferentes compostas por coordenação; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa orações compostas por coordenação.</li>
                              <li><strong>Às Vezes:</strong> Apresenta pelo menos 2 orações diferentes compostas por coordenação.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L81 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L81 - Emprega as seguintes palavras: irmão, irmã, avô, avó.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar as palavras “irmão”, “irmã”, “avô” e “avó” em suas frases, demonstrando compreensão e uso correto de termos familiares relacionados à família.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item81" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item81" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item81" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item81"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item81">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não empregar as palavras: irmão, irmã, avô, avó em suas verbalizações habituais, fazer perguntas envolvendo tais palavras, como por exemplo: “O que (nome do irmão) é seu?”. Assegurar que a criança na resposta diga a palavra: irmã, irmão, avô, avó.</p>
                            <p><strong>Resposta:</strong> Critério: empregar pelo menos uma vez a palavra irmão(ã) e pelo menos uma vez avô(ó).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não emprega as palavras irmão, irmã, avô, avó.</li>
                              <li><strong>Às Vezes:</strong> Emprega pelo menos uma vez a palavra irmão(ã) e pelo menos uma vez avô(ó).</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L82 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L82 - Completa frases com antônimos (o irmão é homem e a irmã é ...).</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de completar frases com palavras que são antônimos, demonstrando compreensão de oposição semântica.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item82" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item82" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item82" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item82"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item82">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Apresentar à criança frases que precisam ser completadas com antônimos. Por exemplo: “O irmão é homem e a irmã é ...”, “No verão faz calor, no inverno faz ...”, “Nós ficamos acordado durante o dia, nós dormimos à ...”, “O dia é claro, a noite é ...”.</p>
                            <p><strong>Resposta:</strong> Critério: completar pelo menos três frases diferentes com antônimos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não completa frases com antônimos.</li>
                              <li><strong>Às Vezes:</strong> Completa pelo menos três frases diferentes com antônimos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L83 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L83 - Diz se duas palavras rimam ou não.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de identificar se duas palavras rimam, demonstrando consciência fonológica e habilidades de percepção auditiva.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item83" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item83" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item83" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item83"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item83">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas à criança do tipo: “Cassa rima com asa?”, “Pão rima com sapato?”, “Pão rima com limão?”.</p>
                            <p><strong>Resposta:</strong> Dizer se duas palavras rimam ou não.</p>
                            <p><strong>Critérios:</strong> X= Não diz se duas palavras rimam ou não; V= Diz se duas palavras rimam ou não; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz se duas palavras rimam ou não.</li>
                              <li><strong>Às Vezes:</strong> Diz se duas palavras rimam ou não.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L84 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L84 - Usa orações compostas por subordinação (“Ela quer que eu entre porque”).</div>
                          <div class="checkbox-interpretation">A criança deve formar orações complexas usando subordinação, conectando uma oração principal a uma subordinada, demonstrando habilidades avançadas de estruturação de frases.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item84" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item84" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item84" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item84"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item84">
                            <p><strong>Recursos Materiais:</strong> Ilustrações ou jogos que envolvam sequências de ações.</p>
                            <p><strong>Condição:</strong> Se a criança não usar orações compostas por subordinação em suas verbalizações habituais, propiciar a ela situações (tais como ilustrações ou jogos) que envolvam diversas sequências de ações (por exemplo: ilustrações de um menino brincando, outra ilustração de um menino bem sujo e outra do menino tomando banho) e que apresentem, com alta probabilidade, a emissão de orações compostas por subordinações. Se necessário, perguntar à criança “Por que o menino está tomando banho?”.</p>
                            <p><strong>Resposta:</strong> Critério: usar pelo menos duas frases complexas compostas por subordinação.</p>
                            <p><strong>Critérios:</strong> X= Não usa frases complexas, compostas por subordinação; V= Usa pelo menos 2 frases complexas compostas por subordinação; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa frases complexas, compostas por subordinação.</li>
                              <li><strong>Às Vezes:</strong> Usa pelo menos 2 frases complexas compostas por subordinação.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L85 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L85 - Diz se um som é forte ou fraco.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de avaliar e descrever a intensidade de um som, demonstrando habilidades de discriminação auditiva e uso adequado de adjetivos para descrever características sonoras.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem4_5_item85" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item85" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem4_5_item85" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem4_5_item85"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem4_5_item85">
                            <p><strong>Recursos Materiais:</strong> Instrumentos musicais ou objetos que produzam sons variados, como rádio, porta que pode ser batida com força ou fechada suavemente, mesa que pode ser batida com um objeto ou deixar cair um objeto.</p>
                            <p><strong>Condição:</strong> Produzir um som (com instrumentos musicais ou objetos do tipo rádio, bater a porta com força ou fechá-la suavemente, golpear a mesa com um objeto ou deixar cair um objeto) e perguntar: “Este som (barulho) é forte ou fraco?”. Variar a posição das palavras forte/fraco de modo a não dar sugestões adicionais à criança.</p>
                            <p><strong>Resposta:</strong> Dizer se um som é forte ou fraco.</p>
                            <p><strong>Critérios:</strong> X= Não diz se um som é forte ou fraco; V= Diz se um som é forte ou fraco; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz se um som é forte ou fraco.</li>
                              <li><strong>Às Vezes:</strong> Diz se um som é forte ou fraco.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>

                    <!-- Faixa 5 - 6 anos - Linguagem -->
                    <div id="ling5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5 - 6 anos</h5>
                        
                        <!-- Card L86 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L86 - Consegue indicar alguns, muitos, vários elementos.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de identificar e diferenciar quantidades utilizando termos como "alguns", "muitos" e "vários", demonstrando compreensão de conceitos quantitativos básicos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item86" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item86" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item86" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item86"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item86">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns.</p>
                            <p><strong>Condição:</strong> Mostrar à criança grupos de objetos com quantidades diferentes de elementos: alguns (dois ou três objetos), muitos (mais ou menos dez objetos), vários (cinco a seis objetos) e pedir que ela aponte o grupo onde tem alguns, vários ou muitos objetos.</p>
                            <p><strong>Resposta:</strong> Conseguir indicar alguns, muitos, vários elementos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não consegue indicar alguns, muitos e vários elementos.</li>
                              <li><strong>Às Vezes:</strong> Consegue indicar alguns, muitos e vários elementos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L87 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L87 - Diz seu endereço.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de vocalizar seu endereço completo, incluindo nome da rua, número da casa/apartamento e bairro ou cidade, demonstrando consciência de sua localização geográfica pessoal.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item87" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item87" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item87" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item87"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item87">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Quando solicitado, pedir à criança que diga seu endereço.</p>
                            <p><strong>Resposta:</strong> Dizer seu endereço = dizer o nome da rua, o número da casa/apartamento e bairro ou cidade por tentativa.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz seu endereço.</li>
                              <li><strong>Às Vezes:</strong> Diz seu endereço completo.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L88 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L88 - Diz o número de seu telefone (fixo ou móvel).</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de vocalizar o número de seu telefone, seja fixo ou móvel, demonstrando familiaridade com informações pessoais importantes.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item88" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item88" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item88" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item88"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item88">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Observar que a família possui celular ou telefone fixo. Caso contrário, anular este item.</p>
                            <p><strong>Resposta:</strong> Dizer o número de seu telefone (fixo ou móvel).</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não diz o número de seu telefone.</li>
                              <li><strong>Às Vezes:</strong> Diz o número de seu telefone.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L89 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L89 - Aponta para o conjunto que tem mais, menos, poucos elementos.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de comparar grupos de objetos e identificar qual possui mais, menos ou poucos elementos, demonstrando habilidades de comparação e compreensão de quantidades relativas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item89" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item89" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item89" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item89"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item89">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns.</p>
                            <p><strong>Condição:</strong> Apresentar à criança, por exemplo, quatro grupos de elementos pequenos (sendo um conjunto de dez elementos, outro de oito, 15 e três elementos). Em seguida, tendo como referência o grupo de dez elementos, pedir a ela que aponte o grupo que tem mais, menos e poucos elementos.</p>
                            <p><strong>Resposta:</strong> Apontar para o conjunto que tem mais, menos, poucos elementos.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não aponta para mais, menos e poucos.</li>
                              <li><strong>Às Vezes:</strong> Aponta para o conjunto que tem mais, menos, poucos elementos.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L90 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L90 - Conta piadas simples.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de contar piadas ou fatos engraçados de forma intencional para provocar risos, demonstrando senso de humor e habilidades de narrativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item90" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item90" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item90" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item90"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item90">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não contar piadas em suas verbalizações habituais, pedir a ela que conte uma piada ou uma história muito engraçada.</p>
                            <p><strong>Resposta:</strong> Contar piadas simples = contar propositadamente piadas ou fatos “engraçados” para provocar risos da audiência.</p>
                            <p><strong>Critério:</strong> Contar no mínimo duas piadas ou fatos engraçados.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não conta piadas simples.</li>
                              <li><strong>Às Vezes:</strong> Conta piadas simples.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L91 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L91 - Relata experiências diárias.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de descrever atividades que realizou ao longo do dia, demonstrando consciência temporal e habilidades de narração de eventos cotidianos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item91" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item91" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item91" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item91"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item91">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar à criança “O que você fez hoje?”. Se esta não relatar uma experiência diária, perguntar, por exemplo: “Você foi à escola?” ou “O que você fez lá?”, “Você foi a padaria ou supermercado? O que fez lá?”, “Você foi ao parque hoje?” etc.</p>
                            <p><strong>Resposta:</strong> Relatar experiências diárias = identificar um local em que tenha ido e descrever o que fez nesse local.</p>
                            <p><strong>Critério:</strong> Relatar pelo menos duas experiências diárias diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não relata experiências diárias.</li>
                              <li><strong>Às Vezes:</strong> Relata pelo menos 2 experiências diárias.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L92 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L92 - Descreve um local ou movimento: entre, longe de, de/desde ... para, por cima de, até ...</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de descrever a localização ou o movimento de objetos usando preposições espaciais, demonstrando compreensão de relações espaciais e capacidade de expressá-las verbalmente.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item92" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item92" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item92" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item92"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item92">
                            <p><strong>Recursos Materiais:</strong> Objetos comuns.</p>
                            <p><strong>Condição:</strong> Se a criança não descrever um local ou movimento: entre, longe de, de/desde ... para, por cima de, até ... em suas verbalizações habituais, planejar situações de brinquedo, por exemplo com carros e caminhões, posto de gasolina, túneis, pontes, etc., e deixar a criança dar a direção para onde você deve mover o objeto. Exemplo: dirigir o carro em cima da ponte, o carro pelo túnel, o carro foi até o posto de gasolina, etc.</p>
                            <p><strong>Resposta:</strong> Descrever um local ou movimento: entre, longe de, de/desde ... para, por cima de, até ...</p>
                            <p><strong>Critério:</strong> Descrever um local ou movimento: entre, longe de, de/desde ... para, por cima de, até ...</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não descreve um local ou movimento.</li>
                              <li><strong>Às Vezes:</strong> Descreve um local ou movimento: entre, longe de, de/desde ... para, por cima de, até ...;</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L93 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L93 - Responde à pergunta “por quê?” com uma explicação.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de fornecer justificativas ou razões quando questionada sobre o motivo de algo, demonstrando habilidades de pensamento causal e expressões explicativas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item93" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item93" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item93" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item93"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item93">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas usando “por que” para a criança, sobre suas atividades diárias. Exemplo: “Por que a mamãe foi à padaria?”, “Por que a gente precisa comer?”, “Por que a gente precisa tomar banho?” etc.</p>
                            <p><strong>Resposta:</strong> Critério: a resposta da criança será considerada correta quando ela der uma explicação (identificando uma possível causa) e não quando responder “porque sim/não”.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde à perguntas “por que” com uma explicação.</li>
                              <li><strong>Às Vezes:</strong> Responde à pergunta “por quê?” com uma explicação.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L94 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L94 - Ordena e conta uma história de dois a cinco episódios na sequência correta.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de organizar e narrar uma história composta por múltiplos eventos em ordem cronológica correta, demonstrando habilidades de sequência lógica e memória narrativa.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item94" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item94" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item94" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item94"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item94">
                            <p><strong>Recursos Materiais:</strong> Contos com ilustrações organizadas em sequência temporal de dois a cinco episódios.</p>
                            <p><strong>Condição:</strong> Utilizar contos com ilustrações organizadas em sequência temporal de dois a cinco episódios. Misturar os episódios e pedir à criança para ordenar e contar a história. Se necessário, dar indicações verbais: “E depois, o que aconteceu?”.</p>
                            <p><strong>Resposta:</strong> Ordenar e contar uma história de dois a cinco episódios na sequência correta.</p>
                            <p><strong>Critérios:</strong> X= Não ordena e conta uma história; V= Ordena e conta uma história de dois a cinco episódios na sequência correta; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não ordena e conta uma história.</li>
                              <li><strong>Às Vezes:</strong> Ordena e conta uma história de dois a cinco episódios na sequência correta.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L95 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L95 - Define palavras.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de fornecer definições ou descrições de palavras, demonstrando compreensão semântica e capacidade de expressar significados de termos específicos.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item95" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item95" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item95" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item95"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item95">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Pedir à criança que defina palavras tais como: bolo, chapéu, casa, banana, cadeira, bicicleta, faca, carta, guarda-chuva, almofada, etc.</p>
                            <p><strong>Resposta:</strong> Definir palavras, descrevendo o objeto ou identificando sua função.</p>
                            <p><strong>Critério:</strong> Definir pelo menos três palavras diferentes.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não define palavras.</li>
                              <li><strong>Às Vezes:</strong> Define pelo menos 3 palavras diferentes.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L96 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L96 - Responde adequadamente à pergunta: “Qual o contrário de ...”.</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de identificar e fornecer antônimos corretos para palavras, demonstrando compreensão de oposições semânticas.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item96" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item96" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item96" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item96"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item96">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Fazer perguntas à criança do tipo: “Qual o contrário de frio/quente?”, “Qual o contrário de grande/pequeno? gordo/magro, feio/bonito, dia/noite, menino/menina?”.</p>
                            <p><strong>Resposta:</strong> Responder adequadamente à pergunta: “Qual o contrário de ...”.</p>
                            <p><strong>Critérios:</strong> X= Não responde adequadamente à pergunta “qual o contrário de ...”; V= Responde adequadamente à pergunta “qual o contrário de ...”; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde adequadamente à pergunta “qual o contrário de ...”.</li>
                              <li><strong>Às Vezes:</strong> Responde adequadamente à pergunta “qual o contrário de ...”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L97 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L97 - Responde à pergunta “o que acontece se ...” (você deixar cair o ovo?).</div>
                          <div class="checkbox-interpretation">A criança deve ser capaz de prever ou explicar consequências de ações hipotéticas, demonstrando compreensão de causa e efeito.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item97" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item97" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item97" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item97"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item97">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Perguntar à criança: “O que acontece se você deixar cair o ovo?”, observando se ela identifica adequadamente pelo menos um efeito consequente.</p>
                            <p><strong>Resposta:</strong> Responder adequadamente à pergunta “o que acontece se ...” identificando pelo menos um efeito consequente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não responde adequadamente à pergunta “o que acontece se ...”.</li>
                              <li><strong>Às Vezes:</strong> Responde adequadamente à pergunta “o que acontece se ...”.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L98 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L98 - Usa “ontem” e “amanhã” corretamente.</div>
                          <div class="checkbox-interpretation">A criança deve utilizar corretamente os termos temporais “ontem” e “amanhã” em suas frases, demonstrando compreensão de passado e futuro.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item98" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item98" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item98" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item98"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item98">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não usa “ontem” e “amanhã” corretamente em suas verbalizações habituais, fazer perguntas a ela do tipo: “Quando você foi/vai para a escola/passear?”, “Quando você tomou banho/jantou?”.</p>
                            <p><strong>Resposta:</strong> Critério: Usa “ontem” e “amanhã” corretamente.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não usa “ontem” e “amanhã” corretamente.</li>
                              <li><strong>Às Vezes:</strong> Usa “ontem” e “amanhã” corretamente.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                        <!-- Card L99 -->
                        <div class="portage-card">
                          <div class="checkbox-title">L99 - Pergunta o significado de palavras novas ou desconhecidas.</div>
                          <div class="checkbox-interpretation">A criança deve demonstrar curiosidade e iniciativa em ampliar seu vocabulário ao perguntar sobre o significado de palavras que não conhece, indicando habilidades de autoaprendizagem e interesse pelo idioma.</div>
                          <div class="skill-actions">
                            <div class="option"><label><input type="radio" name="linguagem5_6_item99" value="Sim">Sim</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item99" value="AV">Às Vezes</label></div>
                            <div class="option"><label><input type="radio" name="linguagem5_6_item99" value="Não">Não</label></div>
                          </div>
                          <div class="portage-orientation-toggle" data-target="orient_linguagem5_6_item99"><i class="fas fa-chevron-down"></i> Orientações</div>
                          <div class="portage-orientation-text" id="orient_linguagem5_6_item99">
                            <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
                            <p><strong>Condição:</strong> Se a criança não faz perguntas sobre o significado de palavras novas ou desconhecidas em suas verbalizações habituais, ler para ela um conto contendo algumas palavras-chave desconhecidas e observar se ela pergunta: “O que é isto?”, “Que quer dizer ...?”.</p>
                            <p><strong>Resposta:</strong> Perguntar o significado de palavras novas ou desconhecidas.</p>
                            <p><strong>Critérios:</strong> X= Não pergunta o significado de palavras novas ou desconhecidas; V= Pergunta o significado de palavras novas ou desconhecidas; O= Item anulado.</p>
                            <strong>Critérios:</strong><br>
                            <ul>
                              <li><strong>Sim:</strong> Não pergunta o significado de palavras novas ou desconhecidas.</li>
                              <li><strong>Às Vezes:</strong> Pergunta o significado de palavras novas ou desconhecidas.</li>
                              <li><strong>Não:</strong> Item anulado.</li>
                            </ul>
                          </div>
                        </div>
                        
                    </div>
                </div>
            </div>
            
            <!-- Área Autocuidado ok -->
            <div id="autocuidado" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Autocuidado</h4>
                
                <!-- Sub-abas de faixas etárias para autocuidado -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#autocuidado0_1" data-toggle="tab" role="tab" aria-controls="autocuidado0_1" aria-selected="true">0 - 1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#autocuidado1_2" data-toggle="tab" role="tab" aria-controls="autocuidado1_2" aria-selected="false">1 - 2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#autocuidado2_3" data-toggle="tab" role="tab" aria-controls="autocuidado2_3" aria-selected="false">2 - 3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#autocuidado3_4" data-toggle="tab" role="tab" aria-controls="autocuidado3_4" aria-selected="false">3 - 4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#autocuidado4_5" data-toggle="tab" role="tab" aria-controls="autocuidado4_5" aria-selected="false">4 - 5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#autocuidado5_6" data-toggle="tab" role="tab" aria-controls="autocuidado5_6" aria-selected="false">5 - 6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0 - 1 ano - Autocuidado -->
                    <div id="autocuidado0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0 - 1 ano</h5>
                        
                       <!-- Card A1 -->
<div class="portage-card">
  <div class="checkbox-title">A1 - Suga e deglute líquidos.</div>
  <div class="checkbox-interpretation">Demonstra habilidade na ingestão de líquidos de forma segura, evidenciando coordenação motora fina e controle durante a alimentação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item1" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item1" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item1" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item1"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item1">
    <p><strong>Recursos Materiais:</strong> Líquidos = leite, chá, água, sucos que já fazem parte da alimentação da criança.</p>
    <p><strong>Condição:</strong> O líquido deverá ser apresentado em mamadeira (ou “chuquinha”). Cada tentativa consiste na introdução do bico da mamadeira na boca da criança.</p>
    <p><strong>Resposta:</strong> Sugar e deglutir líquidos sem engasgar ou perder o fôlego, sem morder o bico da mamadeira e/ou projetar a língua.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não suga e deglute líquidos.</li>
      <li><strong>Às Vezes:</strong> Suga e deglute líquidos sem engasgar ou perder o fôlego, sem morder o bico e/ou projetar a língua.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A2 -->
<div class="portage-card">
  <div class="checkbox-title">A2 - Toma mingau/sopinha.</div>
  <div class="checkbox-interpretation">Ingere mingau ou sopa de forma segura, evidenciando habilidades motoras adequadas para alimentação com colher.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item2" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item2" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item2" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item2"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item2">
    <p><strong>Recursos Materiais:</strong> Mingau ou sopa.</p>
    <p><strong>Condição:</strong> Colocar uma colher pequena (por tentativa), com sopinha habitual da criança, em sua boca.</p>
    <p><strong>Resposta:</strong> Ingerir o mingau/sopa, sem engasgar ou perder o fôlego, sem morder a colher e/ou projetar a língua.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não toma mingau/sopinha.</li>
      <li><strong>Às Vezes:</strong> Ingere o mingau/sopa, sem engasgar ou perder o fôlego, sem morder a colher e/ou projetar a língua.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A3 -->
<div class="portage-card">
  <div class="checkbox-title">A3 - Estende as mãos em direção à mamadeira, tentando pegá-la.</div>
  <div class="checkbox-interpretation">Mostra intenção de pegar objetos, evidenciando coordenação motora e habilidades de alcance.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item3" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item3" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item3" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item3"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item3">
    <p><strong>Recursos Materiais:</strong> Mamadeira.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Estender as mãos em direção a uma mamadeira distante cerca de 20 cm da criança.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não estende as mãos em direção à mamadeira para pegá-la.</li>
      <li><strong>Às Vezes:</strong> Estende as mãos em direção à mamadeira, tentando pegá-la.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A4 -->
<div class="portage-card">
  <div class="checkbox-title">A4 - Come alimento peneirado (papinha) dado pelos pais.</div>
  <div class="checkbox-interpretation">Ingere papinha de forma segura, demonstrando habilidades motoras adequadas para alimentos mais consistentes.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item4" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item4" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item4" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item4"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item4">
    <p><strong>Recursos Materiais:</strong> Alimento peneirado ou, se necessário, passado no liquidificador.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Ingerir uma colher pequena de papinha por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não ingere uma colher pequena de papinha.</li>
      <li><strong>Às Vezes:</strong> Ingere uma colher pequena de papinha por tentativa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A5 -->
<div class="portage-card">
  <div class="checkbox-title">A5 - Segura mamadeira, sem ajuda, enquanto bebe.</div>
  <div class="checkbox-interpretation">Mantém a mamadeira firmemente, evidenciando coordenação motora e independência durante a alimentação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item5" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item5" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item5" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item5"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item5">
    <p><strong>Recursos Materiais:</strong> Mamadeira.</p>
    <p><strong>Condição:</strong> Introduzir o bico da mamadeira na boca da criança e segurá-la no colo.</p>
    <p><strong>Resposta:</strong> Segurar a mamadeira sem ajuda, o tempo suficiente para beber 120 gramas de líquido.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não segura a mamadeira, sem ajuda.</li>
      <li><strong>Às Vezes:</strong> Segura a mamadeira sem ajuda, o tempo suficiente para beber 120 gramas de líquido.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A6 -->
<div class="portage-card">
  <div class="checkbox-title">A6 - Leva a mamadeira até a boca ou a recusa, empurrando-a.</div>
  <div class="checkbox-interpretation">Comunica necessidades de alimentação ou recusa através de ações com a mamadeira, evidenciando habilidades de comunicação e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item6" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item6" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item6" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item6"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item6">
    <p><strong>Recursos Materiais:</strong> Mamadeira.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Segura a mamadeira e a direciona até a boca, introduzindo o bico da mamadeira na boca, sem ensaio e erro ou empurra a mamadeira com as mãos, recusando-a.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não leva a mamadeira a boca ou a recusa, empurrando-a.</li>
      <li><strong>Às Vezes:</strong> Segura a mamadeira e a direciona até a boca, introduzindo o bico da mamadeira na boca, sem ensaio e erro ou empurra a mamadeira com as mãos, recusando-a.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A7 -->
<div class="portage-card">
  <div class="checkbox-title">A7 - Come alimentos amassados, dados pelos pais.</div>
  <div class="checkbox-interpretation">Ingere alimentos amassados de forma segura, demonstrando habilidades de mastigação e deglutição adequadas.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item7" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item7" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item7" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item7"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item7">
    <p><strong>Recursos Materiais:</strong> Alimentos amassados = papinha que ao invés de peneirada seja amassada com o garfo, ou frutas amassadas com o garfo.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Ingerir uma colher por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não come alimentos amassados, dados pelos pais.</li>
      <li><strong>Às Vezes:</strong> Come alimentos amassados, dados pelos pais.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A8 -->
<div class="portage-card">
  <div class="checkbox-title">A8 - Bebe em uma xícara, segurada pelos pais.</div>
  <div class="checkbox-interpretation">Mantém o controle da xícara enquanto bebe, evidenciando coordenação motora e habilidades de ingestão.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item8" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item8" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item8" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item8"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item8">
    <p><strong>Recursos Materiais:</strong> Xícara com líquido.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa será considerada como um gole da criança, que deverá beber sem engasgar, sem perder o fôlego, sem morder a borda da xícara e/ou projetar a língua.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não bebe de uma xícara, segurada pelos pais.</li>
      <li><strong>Às Vezes:</strong> Bebe de uma xícara, segurada pelos pais, sem engasgar ou perder o fôlego, morder a borda da xícara ou projetar a língua.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A9 -->
<div class="portage-card">
  <div class="checkbox-title">A9 - Come alimentos semissólidos dados pelos pais.</div>
  <div class="checkbox-interpretation">Ingere alimentos semissólidos de forma segura, demonstrando habilidades de mastigação e deglutição adequadas.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item9" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item9" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item9" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item9"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item9">
    <p><strong>Recursos Materiais:</strong> Alimentos semissólidos = biscoito, bolacha, pão, torrada ou bolo, banana.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a uma porção ou pedaço de alimento semissólido ingerido, sendo que no mínimo dois alimentos diferentes devem ser apresentados.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não come alimentos semissólidos, dados pelos pais.</li>
      <li><strong>Às Vezes:</strong> Come alimentos semissólidos, dados pelos pais.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A10 -->
<div class="portage-card">
  <div class="checkbox-title">A10 - Alimenta-se sozinho, usando os dedos.</div>
  <div class="checkbox-interpretation">Apanha e ingere alimentos com os dedos de forma independente, demonstrando coordenação motora fina e habilidades de autoalimentação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item10" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item10" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item10" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item10"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item10">
    <p><strong>Recursos Materiais:</strong> Alimentos = legumes, carne, pão, biscoito, bolacha.</p>
    <p><strong>Condição:</strong> Cortar previamente os alimentos em pedaços.</p>
    <p><strong>Resposta:</strong> Cada tentativa significa uma porção de alimento ingerido, tendo sido apanhado pelos dedos.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se alimenta sozinho, usando os dedos.</li>
      <li><strong>Às Vezes:</strong> Alimenta-se sozinho, usando os dedos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A11 -->
<div class="portage-card">
  <div class="checkbox-title">A11 - Segura a xícara com ambas as mãos e bebe.</div>
  <div class="checkbox-interpretation">Mantém o controle da xícara durante a ingestão, evidenciando coordenação motora e habilidades de beber de recipientes.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item11" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item11" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item11" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item11"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item11">
    <p><strong>Recursos Materiais:</strong> Xícara com líquido.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Segurar a xícara com ambas as mãos e dar um gole (por tentativa) sem derramar excessivamente o líquido.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não segura a xícara com ambas as mãos e bebe.</li>
      <li><strong>Às Vezes:</strong> Segura a xícara com ambas as mãos e bebe sem derramar excessivamente o líquido.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A12 -->
<div class="portage-card">
  <div class="checkbox-title">A12 - Leva a colher cheia de comida até a boca, com ajuda.</div>
  <div class="checkbox-interpretation">Transfere alimentos para a boca com assistência, evidenciando desenvolvimento de habilidades motoras e autocuidado na alimentação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item12" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item12" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item12" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item12"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item12">
    <p><strong>Recursos Materiais:</strong> Almoço ou jantar.</p>
    <p><strong>Condição:</strong> Ajuda = segurar a mão da criança com a colher e direcioná-la até a sua boca.</p>
    <p><strong>Resposta:</strong> Critério: levar a colher cheia de comida até a boca, com ajuda, pelo menos dez tentativas durante uma refeição.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não leva a colher até a boca, com ajuda.</li>
      <li><strong>Às Vezes:</strong> Leva a colher cheia de comida até a boca, com ajuda, pelo menos 10x.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A13 -->
<div class="portage-card">
  <div class="checkbox-title">A13 - Estica os braços e pernas ao ser vestido.</div>
  <div class="checkbox-interpretation">Realiza movimentos coordenados ao ser vestido, evidenciando habilidades motoras e controle muscular.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado0_1_item13" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item13" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado0_1_item13" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado0_1_item13"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado0_1_item13">
    <p><strong>Recursos Materiais:</strong> Calça, short e blusa, macacão.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Esticar pelo menos um dos braços ou mão e pelo menos uma das pernas ou pé ao ser vestido, por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não estica os braços e pernas ao ser vestido.</li>
      <li><strong>Às Vezes:</strong> Estica pelo menos um dos braços ou mão e pelo menos uma das pernas ou pé ao ser vestido, por tentativa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>
                        
                    </div>

                    <!-- Faixa 1 - 2 anos - Linguagem -->
                    <div id="autocuidado1_2" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">1 - 2 anos</h5>
                        
                        <!-- Card A14 -->
<div class="portage-card">
  <div class="checkbox-title">A14 - Come com colher, de modo independente.</div>
  <div class="checkbox-interpretation">Utiliza a colher de forma autônoma para se alimentar, evidenciando coordenação motora e habilidades de autoalimentação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item14" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item14" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item14" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item14"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item14">
    <p><strong>Recursos Materiais:</strong> Almoço ou jantar.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Comer com colher, de modo independente sem derramar excessivamente o alimento em cada colherada.</p>
    <p><strong>Critério:</strong> Comer com colher, de modo independente, por 10 tentativas em uma refeição.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não come com colher, de modo independente.</li>
      <li><strong>Às Vezes:</strong> Come de modo independente, por 10 tentativas em uma refeição.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A15 -->
<div class="portage-card">
  <div class="checkbox-title">A15 - Segura a xícara com uma só mão e bebe.</div>
  <div class="checkbox-interpretation">Mantém a xícara firmemente com uma mão durante a ingestão, evidenciando controle motor e coordenação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item15" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item15" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item15" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item15"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item15">
    <p><strong>Recursos Materiais:</strong> Xícara com líquido.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Segurar a xícara com uma só mão e dar um gole (por tentativa) sem derramar excessivamente o líquido.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não segura a xícara com uma só mão e bebe.</li>
      <li><strong>Às Vezes:</strong> Segura a xícara com uma só mão e dá um gole (por tentativa) sem derramar excessivamente o líquido.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A16 -->
<div class="portage-card">
  <div class="checkbox-title">A16 - Coloca a mão na água e dá tapinhas no rosto (com as mãos molhadas) imitando alguém.</div>
  <div class="checkbox-interpretation">Imita ações como colocar a mão na água e dar tapinhas no rosto, demonstrando coordenação motora e habilidades de imitação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item16" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item16" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item16" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item16"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item16">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Colocar a mão na água e dar tapinhas no rosto (com as mãos molhadas) imitando alguém.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não coloca a mão na água e dá tapinhas no rosto (com as mãos molhadas) imitando alguém.</li>
      <li><strong>Às Vezes:</strong> Coloca a mão na água e dá tapinhas no rosto (com as mãos molhadas) imitando alguém.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A17 -->
<div class="portage-card">
  <div class="checkbox-title">A17 - Senta-se em um penico infantil (redutor de assento ou troninho) por cinco minutos.</div>
  <div class="checkbox-interpretation">Senta-se no penico por cinco minutos, evidenciando controle dos esfíncteres e progresso no treinamento para uso do banheiro.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item17" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item17" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item17" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item17"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item17">
    <p><strong>Recursos Materiais:</strong> Troninho, penico ou assento redutor.</p>
    <p><strong>Condição:</strong> Colocar a criança sentada no penico ou privada infantil.</p>
    <p><strong>Resposta:</strong> Senta-se em um penico infantil (redutor de assento ou troninho) por cinco minutos.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não senta-se em um penico infantil.</li>
      <li><strong>Às Vezes:</strong> Senta-se em um penico infantil (redutor de assento ou troninho) por cinco minutos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A18 -->
<div class="portage-card">
  <div class="checkbox-title">A18 - Coloca um chapéu na cabeça e o remove.</div>
  <div class="checkbox-interpretation">Manipula objetos como chapéus, demonstrando coordenação motora e habilidades de vestir.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item18" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item18" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item18" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item18"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item18">
    <p><strong>Recursos Materiais:</strong> Chapéu pode ser substituído por caixa de papelão, cesta ou chapéu de cartolina confeccionado para festas infantis.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Colocar um chapéu na cabeça e o remover.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não coloca e remove um chapéu da cabeça.</li>
      <li><strong>Às Vezes:</strong> Coloca um chapéu na cabeça e o remove.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A19 -->
<div class="portage-card">
  <div class="checkbox-title">A19 - Tira as meias.</div>
  <div class="checkbox-interpretation">Remove as meias de forma independente, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item19" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item19" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item19" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item19"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item19">
    <p><strong>Recursos Materiais:</strong> Meias.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Retirar uma das meias por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não retira as meias.</li>
      <li><strong>Às Vezes:</strong> Retira uma das meias por tentativa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A20 -->
<div class="portage-card">
  <div class="checkbox-title">A20 - Empurra os braços pelas mangas e os pés pelas pernas das calças.</div>
  <div class="checkbox-interpretation">Realiza movimentos coordenados ao vestir-se, evidenciando habilidades motoras e controle corporal.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item20" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item20" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item20" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item20"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item20">
    <p><strong>Recursos Materiais:</strong> Roupas.</p>
    <p><strong>Condição:</strong> Segurar firmemente a camisa sendo que o braço da criança foi previamente colocado na cava da manga, de modo que a própria criança execute o movimento de vestir-se. Fazer o mesmo com a calça por tentativa.</p>
    <p><strong>Resposta:</strong> Empurrar os braços pelas mangas e os pés pelas pernas das calças de modo a executar o movimento de vestir-se.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não empurra os braços pelas mangas e os pés pelas pernas das calças de modo a executar o movimento de vestir-se.</li>
      <li><strong>Às Vezes:</strong> Empurra os braços pelas mangas e os pés pelas pernas das calças de modo a executar o movimento de vestir-se.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A21 -->
<div class="portage-card">
  <div class="checkbox-title">A21 - Tira os sapatos quando o cadarço (ou velcro) estiver desamarrado e frouxo.</div>
  <div class="checkbox-interpretation">Remove os sapatos de forma independente quando os cadarços ou velcros estiverem desamarrados, evidenciando habilidades de autocuidado e independência.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item21" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item21" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item21" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item21"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item21">
    <p><strong>Recursos Materiais:</strong> Sapatos de cadarço ou velcro.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Retirar um dos sapatos por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não retira os sapatos.</li>
      <li><strong>Às Vezes:</strong> Retira um dos sapatos, por tentativa) quando o cadarço (ou velcro) estiver desamarrado e frouxo.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A22 -->
<div class="portage-card">
  <div class="checkbox-title">A22 - Tira o casaco quando desabotoado.</div>
  <div class="checkbox-interpretation">Remove o casaco de forma independente quando desabotoado, demonstrando habilidades de vestir e despir.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item22" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item22" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item22" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item22"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item22">
    <p><strong>Recursos Materiais:</strong> Casaco de botão.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Tira o casaco quando desabotoado.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não tira o casaco quando desabotoado.</li>
      <li><strong>Às Vezes:</strong> Tira o casaco quando desabotoado.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A23 -->
<div class="portage-card">
  <div class="checkbox-title">A23 - Tira a calça quando desabotoada.</div>
  <div class="checkbox-interpretation">Remove a calça de forma independente quando desabotoada, evidenciando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item23" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item23" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item23" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item23"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item23">
    <p><strong>Recursos Materiais:</strong> Pode ser calça com elástico na cintura.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Tira a calça quando desabotoada.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não tira a calça quando desabotoada.</li>
      <li><strong>Às Vezes:</strong> Tira a calça quando desabotoada.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A24 -->
<div class="portage-card">
  <div class="checkbox-title">A24 - Puxa um zíper grande, para cima e para baixo, que já está encaixado.</div>
  <div class="checkbox-interpretation">Opera zíperes de forma coordenada, demonstrando habilidades motoras finas e controle durante o vestir-se.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item24" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item24" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item24" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item24"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item24">
    <p><strong>Recursos Materiais:</strong> Zíper grande = de 15 a 20 cm de tamanho.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Puxar um zíper grande, para cima e para baixo, que já esteja encaixado, sem enroscá-lo na roupa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não puxa um zíper grande, para cima e para baixo.</li>
      <li><strong>Às Vezes:</strong> Puxa um zíper grande, para cima e para baixo, que já esteja encaixado, sem enroscá-lo na roupa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A25 -->
<div class="portage-card">
  <div class="checkbox-title">A25 - Utiliza palavras e gestos indicando necessidade de ir ao banheiro.</div>
  <div class="checkbox-interpretation">Comunica de forma eficaz a necessidade de ir ao banheiro através de palavras e gestos, evidenciando desenvolvimento de habilidades de comunicação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado1_2_item25" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item25" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado1_2_item25" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado1_2_item25"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado1_2_item25">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Diz “xixi” ou “cocô” (ou emite aproximações destes sons) e aponta para o banheiro ou para a calça/fralda, embora já possa estar molhada.</p>
    <p><strong>Critério:</strong> No dia anterior, ter apresentado tal comportamento pelo menos duas vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não diz “xixi/cocô” e aponta para o banheiro ou calça/fralda.</li>
      <li><strong>Às Vezes:</strong> Diz “xixi/cocô” e aponta para o banheiro ou calça/fralda, pelo menos 2x no dia anterior.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>
                        
                    </div>

                    <!-- Faixa 2 - 3 anos - Linguagem -->
                    <div id="autocuidado2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2 - 3 anos</h5>
                        
                        <!-- Card A26 -->
<div class="portage-card">
  <div class="checkbox-title">A26 - Alimenta-se sozinho, usando colher e xícara, derrubando um pouco a comida ou derrubando pouco líquido.</div>
  <div class="checkbox-interpretation">Utiliza colher e xícara de forma independente, mesmo que haja pequenos derramamentos, evidenciando habilidades motoras finas e coordenação durante a alimentação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item26" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item26" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item26" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item26"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item26">
    <p><strong>Recursos Materiais:</strong> Almoço ou jantar.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em um gole e uma colherada, iniciada dentro de 15 segundos após a apresentação da bebida e do alimento.</p>
    <p><strong>Critério:</strong> Alimentar-se de tal forma, pelo menos 10 tentativas de uma refeição.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se alimenta sozinho, usando colher e xícara.</li>
      <li><strong>Às Vezes:</strong> Alimenta-se sozinho, usando colher e xícara, em pelo menos 10 tentativas.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A27 -->
<div class="portage-card">
  <div class="checkbox-title">A27 - Recebe uma toalha de um adulto, enxugando as mãos e o rosto.</div>
  <div class="checkbox-interpretation">Recebe e utiliza uma toalha de um adulto para secar mãos e rosto, demonstrando habilidades de autocuidado e interação social.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item27" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item27" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item27" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item27"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item27">
    <p><strong>Recursos Materiais:</strong> Toalha.</p>
    <p><strong>Condição:</strong> Dar ajuda guiando a mão da criança.</p>
    <p><strong>Resposta:</strong> Enxugar as mãos e o rosto com ajuda.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não enxuga as mãos e o rosto com ajuda.</li>
      <li><strong>Às Vezes:</strong> Enxuga as mãos e o rosto com ajuda.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A28 -->
<div class="portage-card">
  <div class="checkbox-title">A28 - Suga líquido do copo ou xícara usando canudinho.</div>
  <div class="checkbox-interpretation">Utiliza canudinho para sugar líquidos de um copo ou xícara de forma segura, demonstrando coordenação motora e habilidades de ingestão.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item28" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item28" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item28" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item28"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item28">
    <p><strong>Recursos Materiais:</strong> Preferencialmente xícara ou copo, manufaturado com canudinho.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Bebe com canudinho sem engasgar, sem perder o fôlego, sem morder o canudinho e/ou sem projetar a língua.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não bebe usando canudinho.</li>
      <li><strong>Às Vezes:</strong> Bebe usando canudinho sem engasgar, sem morder e/ou sem projetar a língua.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A29 -->
<div class="portage-card">
  <div class="checkbox-title">A29 - Dá garfada.</div>
  <div class="checkbox-interpretation">Usa garfo para pegar alimentos e levá-los à boca, demonstrando habilidades de alimentação independente e coordenação motora fina.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item29" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item29" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item29" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item29"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item29">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Se necessário, dar instruções.</p>
    <p><strong>Resposta:</strong> Coloca alimento no garfo, levando uma porção até a boca, por tentativa. Uma garfada deve ser iniciada dentro de 15 segundos após a apresentação do alimento.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não dá garfadas.</li>
      <li><strong>Às Vezes:</strong> Dá garfadas, levando o alimento até a boca, dentro de 15 segundos após a apresentação do alimento.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A30 -->
<div class="portage-card">
  <div class="checkbox-title">A30 - Mastiga e engole apenas substâncias comestíveis.</div>
  <div class="checkbox-interpretation">Mastiga e engole apenas alimentos comestíveis, evitando substâncias não comestíveis, demonstrando consciência de segurança alimentar.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item30" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item30" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item30" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item30"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item30">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Apresentar à criança uma amostra de várias substâncias comestíveis e não comestíveis (terra, mato ou planta, pedregulho, tampinhas) e solicitar à criança que coloque na boca o que é de comer. Cada vez que a criança levar uma substância é considerada uma tentativa. Se a criança levar à boca uma substância não comestível, interromper sua ação antes de chegar à boca.</p>
    <p><strong>Resposta:</strong> Mastiga e engole apenas substâncias comestíveis.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não mastiga e engole substâncias comestíveis.</li>
      <li><strong>Às Vezes:</strong> Mastiga e engole apenas substâncias comestíveis.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A31 -->
<div class="portage-card">
  <div class="checkbox-title">A31 - Enxuga as mãos sem ajuda, ao lhe darem uma toalha.</div>
  <div class="checkbox-interpretation">Enxuga as mãos de forma independente ao receber uma toalha, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item31" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item31" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item31" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item31"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item31">
    <p><strong>Recursos Materiais:</strong> Toalha.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Mão secas.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não enxuga as mãos sem ajudas.</li>
      <li><strong>Às Vezes:</strong> Enxuga as mãos sem ajudas.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A32 -->
<div class="portage-card">
  <div class="checkbox-title">A32 - Avisa que quer ir ao banheiro, mesmo sendo tarde demais.</div>
  <div class="checkbox-interpretation">Comunica a necessidade de ir ao banheiro, mesmo em situações de urgência, demonstrando consciência de suas necessidades fisiológicas.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item32" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item32" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item32" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item32"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item32">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: no dia anterior, ter apresentado tal comportamento pelo menos três vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não avisa que quer ir ao banheiro.</li>
      <li><strong>Às Vezes:</strong> Avisa que quer ir ao banheiro, pelo menos 3x.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A33 -->
<div class="portage-card">
  <div class="checkbox-title">A33 - Controla a baba.</div>
  <div class="checkbox-interpretation">Controla a produção de saliva, permanecendo seca durante o período de vigília, demonstrando habilidade no manejo da saliva.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item33" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item33" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item33" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item33"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item33">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Permanecer todo o período de vigília sem babar.</p>
    <p><strong>Critério:</strong> Não necessita do uso de babadores, não precisa que lhe enxuguem o queixo ou mantém a camiseta/roupa seca.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não controla a baba.</li>
      <li><strong>Às Vezes:</strong> Controla a baba.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A34 -->
<div class="portage-card">
  <div class="checkbox-title">A34 - Urina ou defeca quando colocado no penico infantil, pelo menos três vezes por semana.</div>
  <div class="checkbox-interpretation">Usa o penico infantil para urinar ou defecar de forma consistente, com no mínimo três ocorrências semanais, demonstrando progresso no treinamento para uso do banheiro.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item34" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item34" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item34" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item34"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item34">
    <p><strong>Recursos Materiais:</strong> Pinico infantil.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. O familiar deverá colocar a criança no pinico infantil pelo menos uma vez por dia.</p>
    <p><strong>Resposta:</strong> Critério: na última semana, a criança deverá ter urinado ou defecado no pinico infantil, pelo menos três vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não urina/defeca no pinico infantil.</li>
      <li><strong>Às Vezes:</strong> Urina/defeca no pinico infantil pelo menos 3x na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A35 -->
<div class="portage-card">
  <div class="checkbox-title">A35 - Calça os sapatos.</div>
  <div class="checkbox-interpretation">Calça seus próprios sapatos de forma adequada, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item35" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item35" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item35" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item35"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item35">
    <p><strong>Recursos Materiais:</strong> Sapatos.</p>
    <p><strong>Condição:</strong> Cada tentativa envolve calçar adequadamente o par de sapatos, que já devem estar previamente desabotoados ou desamarrados.</p>
    <p><strong>Resposta:</strong> Colocar cada um dos sapatos em seu respectivo pé direito e esquerdo.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não calça seus sapatos.</li>
      <li><strong>Às Vezes:</strong> Calça seus sapatos adequadamente.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A36 -->
<div class="portage-card">
  <div class="checkbox-title">A36 - Escova os dentes imitando um adulto.</div>
  <div class="checkbox-interpretation">Imita o ato de escovar os dentes, demonstrando habilidades de higiene bucal e imitação de comportamentos adultos.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item36" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item36" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item36" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item36"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item36">
    <p><strong>Recursos Materiais:</strong> Escova de dentes.</p>
    <p><strong>Condição:</strong> Abrir a torneira, dar para a criança a escova de dentes com pasta, em seguida, dar modelo, solicitando a resposta.</p>
    <p><strong>Resposta:</strong> Cada tentativa é constituída por pegar a escova na posição correta, molhar as cerdas da escova, movimentar as cerdas da escova pelos dentes e enxaguar a boca.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não escova os dentes imitando um adulto.</li>
      <li><strong>Às Vezes:</strong> Escova os dentes imitando um adulto.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A37 -->
<div class="portage-card">
  <div class="checkbox-title">A37 - Retira roupas simples que foram desabotoadas.</div>
  <div class="checkbox-interpretation">Remove roupas simples desabotoadas de forma independente, demonstrando habilidades de vestir e despir.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item37" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item37" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item37" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item37"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item37">
    <p><strong>Recursos Materiais:</strong> Roupas simples = vestido ou calças fáceis de serem vestidas.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Retirar roupas simples que foram desabotoadas.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não retira roupas simples que foram desabotoadas.</li>
      <li><strong>Às Vezes:</strong> Retira roupas simples que foram desabotoadas.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A38 -->
<div class="portage-card">
  <div class="checkbox-title">A38 - Usa o banheiro para defecar, apenas um acidente diurno por semana.</div>
  <div class="checkbox-interpretation">Usa o banheiro para defecar de forma consistente, com no máximo um acidente diurno por semana, demonstrando controle dos esfíncteres e progresso no treinamento para uso do banheiro.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item38" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item38" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item38" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item38"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item38">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Usa o banheiro para defecar, embora possa precisar de ajuda para tirar a roupa, sentar e usar o papel higiênico.</p>
    <p><strong>Critério:</strong> Na semana anterior, a criança deverá ter tido apenas um acidente diurno.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não usa o banheiro para defecar.</li>
      <li><strong>Às Vezes:</strong> Usa o banheiro para defecar, apresentando apenas 1 acidente diurno na semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A39 -->
<div class="portage-card">
  <div class="checkbox-title">A39 - Obtém água de uma torneira (ou filtro) sem ajuda, quando lhe dão um banquinho.</div>
  <div class="checkbox-interpretation">Obtém água de uma torneira ou filtro de forma independente usando um banquinho para alcançar a torneira, demonstrando habilidades motoras e de autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item39" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item39" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item39" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item39"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item39">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Uma tentativa constitui em pegar o copo, abrir a torneira, encher pelo menos ¼ do copo com água e fechar a torneira.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não obtém água de uma torneira.</li>
      <li><strong>Às Vezes:</strong> Obtém água da torneira, enchendo pelo menos ¼ do copo de água.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A40 -->
<div class="portage-card">
  <div class="checkbox-title">A40 - Lava as mãos e o rosto com sabonete, quando um adulto regula a água.</div>
  <div class="checkbox-interpretation">Lava as mãos e o rosto com sabonete adequadamente seguindo instruções, demonstrando habilidades de higiene pessoal.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item40" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item40" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item40" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item40"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item40">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Lavar as mãos = cada tentativa é constituída por molhar as mãos, pegar o sabonete, esfregar uma mão na outra e enxaguar as mãos.</p>
    <p><strong>Resposta (Rosto):</strong> Lavar o rosto = cada tentativa é constituída por molhar as mãos, pegar o sabonete, esfregar o sabonete nas mãos, colocar o sabonete no lugar, passar as mãos ensaboadas no rosto, bochecha, queixo e testa e enxaguar o rosto.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não lava as mãos e rosto com sabonete.</li>
      <li><strong>Às Vezes:</strong> Lava as mãos e o rosto com sabonete.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A41 -->
<div class="portage-card">
  <div class="checkbox-title">A41 - Avisa que quer ir ao banheiro, durante o dia, a tempo.</div>
  <div class="checkbox-interpretation">Comunica a necessidade de ir ao banheiro de forma oportuna, evitando acidentes, demonstrando habilidades de autocuidado e comunicação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item41" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item41" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item41" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item41"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item41">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. O familiar deverá ter ajudado a criança (encaminhando-a até o banheiro, etc.) todas as vezes em que esta lhe “avisou” que queria ir ao banheiro.</p>
    <p><strong>Resposta:</strong> Pedir ou fazer gestos indicativos de ir ao banheiro (não vale apenas ficar pulando).</p>
    <p><strong>Critério:</strong> Nenhum acidente por dia durante a semana anterior.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não avisa que quer ir ao banheiro.</li>
      <li><strong>Às Vezes:</strong> Avisa que quer ir ao banheiro, pedindo ou fazendo gestos indicativos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A42 -->
<div class="portage-card">
  <div class="checkbox-title">A42 - Pendura o casaco em um gancho colocado à sua altura.</div>
  <div class="checkbox-interpretation">Pendurara o próprio casaco em um gancho à sua altura, demonstrando habilidades de organização e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item42" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item42" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item42" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item42"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item42">
    <p><strong>Recursos Materiais:</strong> Gancho.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Pendurar o casaco em um gancho colocado à sua altura.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não pendura o casaco em um gancho.</li>
      <li><strong>Às Vezes:</strong> Pendura o casaco em um gancho colocado à sua altura.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A43 -->
<div class="portage-card">
  <div class="checkbox-title">A43 - Permanece seco ao dormir durante o dia.</div>
  <div class="checkbox-interpretation">Dorme sem episódios de incontinência durante o dia, demonstrando controle dos esfíncteres e progresso no treinamento para uso do banheiro.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item43" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item43" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item43" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item43"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item43">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: ter acordado seco em todas as vezes que dormiu durante o dia naquele período.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não permanece seco ao dormir durante o dia.</li>
      <li><strong>Às Vezes:</strong> Acorda seco em todas as vezes que dormiu durante o dia naquela semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A44 -->
<div class="portage-card">
  <div class="checkbox-title">A44 - Evita riscos como pontas de mobília, escadas sem corrimão.</div>
  <div class="checkbox-interpretation">Identifica e evita riscos domésticos como pontas de mobília e escadas sem corrimão, demonstrando consciência de segurança e habilidades preventivas.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item44" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item44" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item44" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item44"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item44">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevistas com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: não ter se machucado em pontas de mobílias e não ter utilizado sozinho, dada a oportunidade, escadas sem corrimão, na última semana; e/ou não ter havido necessidade de o familiar lembrar frequentemente à criança para evitar tais riscos.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não evita riscos como pontas de mobília e escadas sem corrimão.</li>
      <li><strong>Às Vezes:</strong> Evita riscos como pontas de mobília e escadas sem corrimão.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A45 -->
<div class="portage-card">
  <div class="checkbox-title">A45 - Usa guardanapo quando assim aconselhado.</div>
  <div class="checkbox-interpretation">Utiliza guardanapo durante as refeições quando solicitado, demonstrando habilidades de autocuidado e higiene pessoal.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item45" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item45" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item45" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item45"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item45">
    <p><strong>Recursos Materiais:</strong> Guardanapo.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. O familiar precisaria já ter aconselhado a criança a usar o guardanapo para que este item seja avaliado.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a: dado o lembrete para usar guardanapo, a criança ter atendido à ordem, sendo que usar o guardanapo = passar o guardanapo na boca.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não usa guardanapo quando assim aconselhado.</li>
      <li><strong>Às Vezes:</strong> Usa guardanapo quando assim solicitado.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A46 -->
<div class="portage-card">
  <div class="checkbox-title">A46 - Espeta o garfo na comida levando-a à boca.</div>
  <div class="checkbox-interpretation">Espeta alimentos com um garfo e os leva à boca de forma coordenada, demonstrando habilidades de alimentação independente e coordenação motora fina.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item46" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item46" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item46" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item46"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item46">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Espetar com o garfo dentro de 15 segundos após a apresentação do alimento.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não espeta com o garfo e leva a comida à boca.</li>
      <li><strong>Às Vezes:</strong> Espeta com o garfo, levando a comida à boca.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A47 -->
<div class="portage-card">
  <div class="checkbox-title">A47 - Despeja líquidos de uma pequena jarra (1/4 de litro) para o copo, sem ajuda.</div>
  <div class="checkbox-interpretation">Despeja líquidos de uma jarra para um copo de forma independente, sem derramar excessivamente, demonstrando habilidades motoras e de autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item47" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item47" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item47" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item47"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item47">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Despejar líquido da jarra para o copo, sem derramá-lo excessivamente.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não despeja líquidos de uma jarra para o copo.</li>
      <li><strong>Às Vezes:</strong> Despeja líquido da jarra para o copo, sem derramá-lo excessivamente.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A48 -->
<div class="portage-card">
  <div class="checkbox-title">A48 - Desprende roupas presas com o fecho de pressão.</div>
  <div class="checkbox-interpretation">Desprende roupas com fechos de pressão de forma independente, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item48" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item48" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item48" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item48"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item48">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Cada tentativa envolve a apresentação de roupa com um fecho de pressão, acompanhada de instruções.</p>
    <p><strong>Resposta:</strong> Desprender roupas presas com o fecho de pressão.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não desprende roupas presas com o fecho de pressão.</li>
      <li><strong>Às Vezes:</strong> Desprende roupas presas com o fecho de pressão.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A49 -->
<div class="portage-card">
  <div class="checkbox-title">A49 - Lava seus braços e pernas ao lhe darem banho.</div>
  <div class="checkbox-interpretation">Lava seus próprios braços e pernas durante o banho, seguindo instruções e demonstrando habilidades de higiene pessoal.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item49" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item49" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item49" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item49"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item49">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. O familiar precisa ter dado oportunidade à criança de lavar seus próprios braços e pernas.</p>
    <p><strong>Resposta:</strong> Passar sabonete e/ou bucha ou esponja com espuma, movimentando o sabonete ou esponja por todo o braço e perna, em seguida retirar a espuma jogando água.</p>
    <p><strong>Critério:</strong> Na semana anterior, a criança deveria ter lavado os braços e pernas pelo menos em três banhos diferentes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não lava seus braços e pernas ao lhe darem banho.</li>
      <li><strong>Às Vezes:</strong> Lava seus braços e pernas em pelo menos 3 banhos diferentes.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A50 -->
<div class="portage-card">
  <div class="checkbox-title">A50 - Coloca meias.</div>
  <div class="checkbox-interpretation">Coloca suas próprias meias de forma independente, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item50" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item50" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item50" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item50"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item50">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa diz respeito ao par de meias.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não coloca meias.</li>
      <li><strong>Às Vezes:</strong> Coloca meias.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A51 -->
<div class="portage-card">
  <div class="checkbox-title">A51 - Veste casaco, malha ou camisa.</div>
  <div class="checkbox-interpretation">Veste-se adequadamente com casaco, malha ou camisa, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item51" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item51" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item51" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item51"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item51">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Dar camisa, casaco ou malha para a criança, podendo dar pistas sobre qual a frente da roupa ou qual o modo mais fácil de iniciar o movimento.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a colocar adequadamente um casaco, camisa ou malha.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não veste casaco, malha ou camisa.</li>
      <li><strong>Às Vezes:</strong> Veste adequadamente casaco, malha ou camisa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A52 -->
<div class="portage-card">
  <div class="checkbox-title">A52 - Identifica qual é a parte dianteira da roupa.</div>
  <div class="checkbox-interpretation">Identifica a parte dianteira de uma peça de roupa, demonstrando compreensão de orientação espacial e reconhecimento de partes da roupa.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado2_3_item52" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item52" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado2_3_item52" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado2_3_item52"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado2_3_item52">
    <p><strong>Recursos Materiais:</strong> Camisas, calças, blusões, jaquetas ou qualquer peça de roupa.</p>
    <p><strong>Condição:</strong> A peça de roupa deve ter algum sinal tal como: botão, bolso, zíper, etc., que assinale a diferença entre as duas partes: dianteira e traseira.</p>
    <p><strong>Resposta:</strong> Identificar = apontar ou verbalizar qual a frente da roupa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não identifica qual é a parte dianteira da roupa.</li>
      <li><strong>Às Vezes:</strong> Identifica qual é a parte dianteira da roupa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

                        
                    </div>

                    <!-- Faixa 3 - 4 anos - Linguagem -->
                    <div id="autocuidado3_4" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">3 - 4 anos</h5>
                        <!-- Card A53 -->
<div class="portage-card">
  <div class="checkbox-title">A53 - Alimenta-se sozinho por toda a refeição.</div>
  <div class="checkbox-interpretation">Alimenta-se de forma independente durante toda a refeição, usando utensílios apropriados e esvaziando o prato ou a maior parte dele, demonstrando habilidades avançadas de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item53" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item53" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item53" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item53"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item53">
    <p><strong>Recursos Materiais:</strong> Almoço ou jantar.</p>
    <p><strong>Condição:</strong> A comida deve estar no prato, cortada em pedaços pequenos. Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Alimentar-se sozinho = esvaziar o prato (ou a maior parte deste), levando à boca a colher/garfo de forma independente durante a refeição.</p>
    <p><strong>Critério:</strong> Deverá ter se alimentado independentemente em pelo menos uma refeição por dia na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se alimenta sozinho por toda a refeição.</li>
      <li><strong>Às Vezes:</strong> Alimenta-se sozinho por toda a refeição, pelo menos 1x ao dia na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A54 -->
<div class="portage-card">
  <div class="checkbox-title">A54 - Veste-se sozinho, apenas precisando de ajuda quanto a malhas ou camisetas com golas cerradas ou roupas com botões ou fechos.</div>
  <div class="checkbox-interpretation">Veste-se de forma independente, necessitando ajuda apenas para peças mais complexas (golas fechadas, botões, fechos), demonstrando habilidades avançadas de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item54" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item54" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item54" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item54"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item54">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Vestir-se sozinho = colocar cueca, calça, camisa ou calcinha e vestido sem ajuda.</p>
    <p><strong>Critério:</strong> Na semana anterior, ter precisado de ajuda apenas com malhas, camisetas de gola cerrada ou roupas com botões/fechos em todas as ocasiões em que teve oportunidade de se vestir.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se veste sozinho.</li>
      <li><strong>Às Vezes:</strong> Veste-se sozinho, apenas precisando de ajuda com malhas ou camisetas de gola cerrada, botões ou fechos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A55 -->
<div class="portage-card">
  <div class="checkbox-title">A55 - Enxuga o nariz quando lembrado.</div>
  <div class="checkbox-interpretation">Enxuga o nariz de forma independente quando lembrado, demonstrando habilidades de autocuidado e higiene pessoal.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item55" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item55" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item55" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item55"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item55">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Propiciar lenço ou papel quando o nariz da criança estiver escorrendo. Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: ter enxugado o nariz todas as vezes em que foi lembrado.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não enxuga o nariz quando lembrado.</li>
      <li><strong>Às Vezes:</strong> Enxuga o nariz sempre que é lembrado.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A56 -->
<div class="portage-card">
  <div class="checkbox-title">A56 - Acorda seco duas manhãs em uma semana.</div>
  <div class="checkbox-interpretation">Acorda sem episódios de incontinência em pelo menos duas manhãs na semana, demonstrando controle dos esfíncteres e progresso no treinamento para uso do banheiro.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item56" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item56" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item56" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item56"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item56">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Acordar seco duas manhãs em uma semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não acorda seco duas manhãs em uma semana.</li>
      <li><strong>Às Vezes:</strong> Acorda seco duas manhãs em uma semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A57 -->
<div class="portage-card">
  <div class="checkbox-title">A57 - Se do sexo masculino, urina na privada, em pé.</div>
  <div class="checkbox-interpretation">Urina em pé na privada, demonstrando habilidades de autocuidado e controle dos esfíncteres. (Se for do sexo feminino, este item é anulado.)</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item57" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item57" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item57" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item57"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item57">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. Se necessário, ajudar a criança a abaixar e erguer a calça.</p>
    <p><strong>Resposta:</strong> De pé, frente ao vaso sanitário ou penico infantil, segurar o pênis e urinar com direção.</p>
    <p><strong>Critério:</strong> Ter urinado em pé, na privada, pelo menos três vezes na semana anterior.</p>
    <p><strong>Observação:</strong> Se do sexo feminino, anular esse item.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não urina em pé.</li>
      <li><strong>Às Vezes:</strong> Urina em pé, na privada, pelo menos 3x na semana anterior.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A58 -->
<div class="portage-card">
  <div class="checkbox-title">A58 - Veste-se e desveste-se sozinho, exceto quanto a botões e fechos, em 75% das vezes.</div>
  <div class="checkbox-interpretation">Veste-se e desveste-se de forma independente na maioria das vezes, precisando de ajuda apenas com botões e fechos, demonstrando habilidades avançadas de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item58" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item58" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item58" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item58"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item58">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Desvestir sozinho = retirar cueca, calça, camisas/malhas com golas cerradas ou calcinha e vestido sem ajuda.</p>
    <p><strong>Critério:</strong> Na semana anterior, ter precisado de ajuda para vestir e desvestir somente quanto a botões e fechos, pelo menos em quatro dias diferentes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se veste e desveste sozinho.</li>
      <li><strong>Às Vezes:</strong> Veste-se e desveste-se sozinho, exceto quanto a botões e fechos, em 75% das vezes.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A59 -->
<div class="portage-card">
  <div class="checkbox-title">A59 - Fecha a roupa com fechos de pressão ou de gancho.</div>
  <div class="checkbox-interpretation">Fecha roupas com fechos de pressão ou ganchos de forma independente, demonstrando habilidades avançadas de coordenação motora e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item59" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item59" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item59" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item59"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item59">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa deve consistir em fechar um fecho de pressão ou gancho de roupa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não fecha a roupa com fechos de pressão ou de gancho.</li>
      <li><strong>Às Vezes:</strong> Fecha a roupa com fechos de pressão ou de gancho.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A60 -->
<div class="portage-card">
  <div class="checkbox-title">A60 - Assoa o nariz quando lembrado.</div>
  <div class="checkbox-interpretation">Assoa o nariz de forma independente ao receber um lembrete, demonstrando habilidades de higiene pessoal e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item60" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item60" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item60" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item60"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item60">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Dar um lenço para a criança e pedir para que ela assoe o nariz. Fazer isto a cada tentativa.</p>
    <p><strong>Resposta:</strong> Assoar o nariz = de posse de um lenço, limpá-lo de forma que o muco seja expelido.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não assoa o nariz.</li>
      <li><strong>Às Vezes:</strong> Assoa o nariz quando é lembrado.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A61 -->
<div class="portage-card">
  <div class="checkbox-title">A61 - Evita perigos corriqueiros (por exemplo, caco de vidro).</div>
  <div class="checkbox-interpretation">Identifica e evita riscos comuns em ambientes domésticos (cacos de vidro, garrafas, fogo, panelas quentes, janelas abertas etc.), demonstrando consciência de segurança e prevenção de acidentes.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item61" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item61" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item61" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item61"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item61">
    <p><strong>Recursos Materiais:</strong> Caco de vidro, garrafas, fogo, panelas quentes, janelas abertas, interruptores, lugares altos, animais desconhecidos.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Evitar perigos corriqueiros, dada a oportunidade, sem machucar-se.</p>
    <p><strong>Critério:</strong> Não ter se machucado na última semana com os objetos acima, e/ou ter evitado escadas sem corrimão ou lugares altos, sem excessivas recomendações do adulto.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não evita perigos corriqueiros.</li>
      <li><strong>Às Vezes:</strong> Evita perigos corriqueiros.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A62 -->
<div class="portage-card">
  <div class="checkbox-title">A62 - Coloca agasalho em cabide e pendura o cabide em uma barra baixa, quando lhe dão instruções.</div>
  <div class="checkbox-interpretation">Organiza seu agasalho no cabide e o pendura em uma barra baixa seguindo instruções, demonstrando habilidades de organização e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item62" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item62" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item62" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item62"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item62">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Colocar o agasalho em um cabide e pendurar o cabide em uma barra baixa, seguindo instruções.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não coloca o agasalho no cabide e o pendura.</li>
      <li><strong>Às Vezes:</strong> Coloca o agasalho no cabide e o pendura em barra baixa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A63 -->
<div class="portage-card">
  <div class="checkbox-title">A63 - Escova os dentes quando recebe instruções.</div>
  <div class="checkbox-interpretation">Escova os dentes de forma independente ao receber instruções (sem modelo), demonstrando habilidades de higiene bucal e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item63" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item63" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item63" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item63"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item63">
    <p><strong>Recursos Materiais:</strong> Escova de dentes e pasta.</p>
    <p><strong>Condição:</strong> Dar para a criança a escova com pasta e, em seguida, apenas instruir.</p>
    <p><strong>Resposta:</strong> Cada tentativa é constituída por: abrir a torneira, pegar a escova na posição correta, molhar as cerdas, movimentar as cerdas pelos dentes, enxaguar a boca e fechar a torneira.</p>
    <p><strong>Critério:</strong> Escovar os dentes quando recebe instruções, pelo menos uma vez por dia.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não escova os dentes quando recebe instruções.</li>
      <li><strong>Às Vezes:</strong> Escova os dentes pelo menos 1x por dia quando recebe instruções.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A64 -->
<div class="portage-card">
  <div class="checkbox-title">A64 - Coloca luvas.</div>
  <div class="checkbox-interpretation">Coloca suas próprias luvas de forma independente, demonstrando habilidades de autocuidado e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item64" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item64" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item64" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item64"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item64">
    <p><strong>Recursos Materiais:</strong> Luvas.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a colocar uma das luvas.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não coloca luvas.</li>
      <li><strong>Às Vezes:</strong> Coloca luvas.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A65 -->
<div class="portage-card">
  <div class="checkbox-title">A65 - Desabotoa botões grandes em um agasalho ou em pranchas de botões colocadas sobre a mesa.</div>
  <div class="checkbox-interpretation">Desabotoa botões grandes de forma independente, demonstrando habilidades de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item65" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item65" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item65" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item65"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item65">
    <p><strong>Recursos Materiais:</strong> Agasalho com botões grandes ou prancha de botões.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a desabotoar um botão.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não desabotoa botões.</li>
      <li><strong>Às Vezes:</strong> Desabotoa botões grandes em um agasalho ou prancha de botões.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A66 -->
<div class="portage-card">
  <div class="checkbox-title">A66 - Abotoa botões grandes em um agasalho ou em prancha de botões colocada sobre a mesa.</div>
  <div class="checkbox-interpretation">Abotoa botões grandes de forma independente, demonstrando habilidades de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item66" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item66" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item66" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item66"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item66">
    <p><strong>Recursos Materiais:</strong> Agasalho com botões grandes ou prancha de botões.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a abotoar um botão, não necessariamente em sua casa correspondente.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não abotoa botões.</li>
      <li><strong>Às Vezes:</strong> Abotoa botões grandes em agasalho ou prancha de botões.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A67 -->
<div class="portage-card">
  <div class="checkbox-title">A67 - Calça botas.</div>
  <div class="checkbox-interpretation">Calça botas ou calçados similares de forma independente, demonstrando habilidades de coordenação motora e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado3_4_item67" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item67" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado3_4_item67" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado3_4_item67"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado3_4_item67">
    <p><strong>Recursos Materiais:</strong> Bota ou equivalente (galocha, botina ou tênis com cano alto).</p>
    <p><strong>Condição:</strong> Estar usando meias. O adulto deverá afrouxar (se for o caso) previamente os cordões da bota.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em calçar adequadamente o par de botas.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não calça botas.</li>
      <li><strong>Às Vezes:</strong> Calça botas.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>
                                                
                    </div>
                    
                    <!-- Faixa 4 - 5 anos - Linguagem -->
                    <div id="autocuidado4_5" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">4 - 5 anos</h5>
                        <!-- Card A68 -->
<div class="portage-card">
  <div class="checkbox-title">A68 - Limpa o que derramou, indo buscar um pano por conta própria.</div>
  <div class="checkbox-interpretation">Limpa qualquer derramamento de forma independente, buscando um pano e secando a área, demonstrando habilidades de autocuidado e responsabilidade.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item68" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item68" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item68" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item68"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item68">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Ir buscar um pano e passá-lo sobre a superfície molhada/suja, deixando-a seca/limpa.</p>
    <p><strong>Critério:</strong> Na semana anterior, ter feito isso, dada a oportunidade.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não limpa o que derramou.</li>
      <li><strong>Às Vezes:</strong> Limpa o que derramou, indo buscar um pano por conta própria.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A69 -->
<div class="portage-card">
  <div class="checkbox-title">A69 - Evita veneno e todas as substâncias prejudiciais.</div>
  <div class="checkbox-interpretation">Identifica e evita substâncias tóxicas ou perigosas (produtos de limpeza, medicamentos), demonstrando consciência de segurança e prevenção de acidentes.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item69" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item69" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item69" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item69"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item69">
    <p><strong>Recursos Materiais:</strong> Substâncias prejudiciais = produtos tóxicos (detergente, álcool etc.) ou medicamentos.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Evitar = não manipular e/ou não ingerir substâncias prejudiciais.</p>
    <p><strong>Critério:</strong> Ter evitado tais substâncias, dada a oportunidade na última semana, sem recomendações excessivas do adulto.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não evita substâncias prejudiciais.</li>
      <li><strong>Às Vezes:</strong> Evita substâncias prejudiciais.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A70 -->
<div class="portage-card">
  <div class="checkbox-title">A70 - Desabotoa sua roupa.</div>
  <div class="checkbox-interpretation">Desabotoa as próprias roupas de forma independente, demonstrando habilidades de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item70" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item70" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item70" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item70"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item70">
    <p><strong>Recursos Materiais:</strong> Roupa = camisa, casaco e/ou vestido com botões dianteiros.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em desabotoar todos os botões da roupa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não desabotoa sua roupa.</li>
      <li><strong>Às Vezes:</strong> Desabotoa botões de sua roupa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A71 -->
<div class="portage-card">
  <div class="checkbox-title">A71 - Abotoa sua roupa.</div>
  <div class="checkbox-interpretation">Abotoa as próprias roupas de forma independente, demonstrando habilidades de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item71" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item71" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item71" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item71"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item71">
    <p><strong>Recursos Materiais:</strong> Roupa = camisa, casaco e/ou vestido com botões dianteiros.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em abotoar praticamente todos os botões de roupa (podendo deixar de abotoar um ou dois botões finais).</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não abotoa sua roupa.</li>
      <li><strong>Às Vezes:</strong> Abotoa botões de sua roupa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A72 -->
<div class="portage-card">
  <div class="checkbox-title">A72 - Retira prato e talheres da mesa.</div>
  <div class="checkbox-interpretation">Retira seus próprios pratos e talheres da mesa após a refeição, demonstrando habilidades de organização e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item72" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item72" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item72" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item72"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item72">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em retirar o próprio prato e talheres da mesa, levando-os até a pia ou local indicado.</p>
    <p><strong>Critério:</strong> Ter apresentado tal comportamento pelo menos três vezes, dada a oportunidade, na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não retira prato e talheres da mesa.</li>
      <li><strong>Às Vezes:</strong> Retira pratos e talheres, pelo menos 3x na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A73 -->
<div class="portage-card">
  <div class="checkbox-title">A73 - Encaixa zíper em sua terminação.</div>
  <div class="checkbox-interpretation">Encaixa o zíper das próprias roupas de forma independente, demonstrando habilidades de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item73" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item73" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item73" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item73"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item73">
    <p><strong>Recursos Materiais:</strong> Zíper de pelo menos 15 cm ou blusão contendo zíper a ser encaixado.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em encaixar adequadamente o zíper uma vez.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não encaixa zíper em sua terminação.</li>
      <li><strong>Às Vezes:</strong> Encaixa zíper em sua terminação.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A74 -->
<div class="portage-card">
  <div class="checkbox-title">A74 - Lava as mãos e rosto.</div>
  <div class="checkbox-interpretation">Realiza a sequência completa para lavar as mãos e rosto de forma independente, demonstrando habilidades avançadas de higiene pessoal e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item74" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item74" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item74" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item74"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item74">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Dar apenas instruções.</p>
    <p><strong>Resposta:</strong>
    <ul>
      <li><strong>Lavar as mãos:</strong> abrir a torneira, molhar as mãos, pegar o sabonete, esfregar o sabonete nas mãos, colocar o sabonete de volta, esfregar uma mão na outra, enxaguar, fechar a torneira e enxugar as mãos.</li>
      <li><strong>Lavar o rosto:</strong> abrir a torneira, molhar as mãos, pegar o sabonete, esfregar o sabonete nas mãos, colocar o sabonete de volta, passar as mãos ensaboadas no rosto (bochecha, queixo, testa), enxaguar o rosto, fechar a torneira e enxugar o rosto.</li>
    </ul>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não lava as mãos e rosto.</li>
      <li><strong>Às Vezes:</strong> Lava as mãos e rosto.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A75 -->
<div class="portage-card">
  <div class="checkbox-title">A75 - Usa talher apropriado para se alimentar.</div>
  <div class="checkbox-interpretation">Utiliza garfo, colher e, se necessário, faca, de forma adequada e sem lembretes, demonstrando habilidades avançadas de coordenação motora e autocuidado durante as refeições.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item75" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item75" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item75" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item75"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item75">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a, numa refeição, a criança usar o garfo para sólidos, colher para semissólidos/líquidos e faca para cortar, sem lembretes.</p>
    <p><strong>Critério:</strong> Ter feito isso em pelo menos três refeições na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não usa talher apropriado para se alimentar.</li>
      <li><strong>Às Vezes:</strong> Usa talher apropriado em 3 refeições na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A76 -->
<div class="portage-card">
  <div class="checkbox-title">A76 - Toma banho sozinho precisando de ajuda apenas para lavar as costas, pescoço e orelhas.</div>
  <div class="checkbox-interpretation">Toma banho de forma praticamente independente, necessitando ajuda apenas em áreas de difícil alcance, demonstrando habilidades avançadas de higiene e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item76" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item76" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item76" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item76"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item76">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Cada tentativa inclui ensaboar o corpo (exceto costas, pescoço e orelhas) e enxaguar. Também secar-se ao final.</p>
    <p><strong>Critério:</strong> Todas as vezes na última semana, desde que haja supervisão apenas para as áreas de difícil alcance.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não toma banho sozinho.</li>
      <li><strong>Às Vezes:</strong> Toma banho sozinho em todas as vezes que teve oportunidade.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A77 -->
<div class="portage-card">
  <div class="checkbox-title">A77 - Limpa e assoa o nariz em 75% das vezes, sem lembretes.</div>
  <div class="checkbox-interpretation">Limpa e assoa o nariz de forma independente na maioria das vezes, sem necessitar lembretes, demonstrando habilidades avançadas de higiene pessoal e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item77" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item77" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item77" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item77"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item77">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: na última semana, em quatro oportunidades diferentes, ter limpado o nariz sem lembretes ao menos três vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não limpa e assoa o nariz sem lembretes.</li>
      <li><strong>Às Vezes:</strong> Limpa e assoa o nariz em 75% das vezes, sem lembretes.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A78 -->
<div class="portage-card">
  <div class="checkbox-title">A78 - Vai até o banheiro a tempo, retira a roupa, usa papel higiênico, dá descarga e veste-se sem ajuda.</div>
  <div class="checkbox-interpretation">Utiliza o banheiro de forma completa e independente (retira a roupa, usa papel, dá descarga, veste-se), demonstrando habilidades de autocuidado e controle dos esfíncteres.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item78" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item78" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item78" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item78"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item78">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: ter apresentado essa sequência de forma independente a semana toda, podendo falhar em dar descarga uma ou duas vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não realiza toda a sequência sozinha.</li>
      <li><strong>Às Vezes:</strong> Realiza a sequência completa sem ajuda.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A79 -->
<div class="portage-card">
  <div class="checkbox-title">A79 - Usa faca para espalhar manteiga no pão.</div>
  <div class="checkbox-interpretation">Espalha manteiga ou equivalente no pão de forma independente, demonstrando habilidades avançadas de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item79" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item79" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item79" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item79"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item79">
    <p><strong>Recursos Materiais:</strong> Manteiga ou equivalente (margarina, geleia, mel, requeijão). Pão ou torrada/bolacha.</p>
    <p><strong>Condição:</strong> Manteigueira aberta e disponível, manteiga mole, pão fatiado.</p>
    <p><strong>Resposta:</strong> Pegar a faca corretamente, introduzir na manteiga, passar sobre a fatia de pão. Uma tentativa = cobrir a fatia toda.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não usa faca para espalhar manteiga.</li>
      <li><strong>Às Vezes:</strong> Usa faca para espalhar manteiga no pão.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A80 -->
<div class="portage-card">
  <div class="checkbox-title">A80 - Aperta e afrouxa cintos e fivelas nos vestidos ou calças e sapatos.</div>
  <div class="checkbox-interpretation">Aperta e afrouxa cintos/fivelas em roupas e sapatos de forma independente, demonstrando habilidades avançadas de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item80" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item80" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item80" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item80"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item80">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a apertar e afrouxar uma vez o cinto ou a fivela.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não aperta/afrouxa cintos ou fivelas.</li>
      <li><strong>Às Vezes:</strong> Aperta e afrouxa cintos/fivelas pelo menos 1x.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A81 -->
<div class="portage-card">
  <div class="checkbox-title">A81 - Veste-se sozinho, incluindo botões, fechos, cintos e fivelas dianteiros, mas não dá laços.</div>
  <div class="checkbox-interpretation">Veste-se de forma completa e independente, incluindo botões, fechos, cintos e fivelas na parte dianteira, precisando ajuda apenas para laços, demonstrando habilidades avançadas de coordenação e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item81" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item81" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item81" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item81"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item81">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Na semana anterior, vestir-se sozinho(a) todas as vezes, precisando ajuda apenas para amarrar laços.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se veste sozinho.</li>
      <li><strong>Às Vezes:</strong> Veste-se sozinho, incluindo botões, fechos, cintos e fivelas, sem dar laços.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A82 -->
<div class="portage-card">
  <div class="checkbox-title">A82 - Serve-se à mesa, enquanto um dos pais segura a travessa de comida.</div>
  <div class="checkbox-interpretation">Serve-se de forma independente de uma travessa para o seu prato, enquanto um adulto apenas segura a travessa, demonstrando habilidades avançadas de coordenação motora e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item82" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item82" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item82" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item82"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item82">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Pegar uma porção de alimento da travessa e colocá-la em seu prato, sem derramar muito.</p>
    <p><strong>Critério:</strong> Na última semana, ter feito isso pelo menos três vezes, dada a oportunidade.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não serve-se à mesa.</li>
      <li><strong>Às Vezes:</strong> Serve-se à mesa pelo menos 3x na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A83 -->
<div class="portage-card">
  <div class="checkbox-title">A83 - Ajuda a pôr a mesa, colocando corretamente pratos, talheres e guardanapos, quando recebe instruções.</div>
  <div class="checkbox-interpretation">Auxilia na organização da mesa, posicionando pratos, talheres e guardanapos conforme instruções, demonstrando habilidades de cooperação e coordenação motora.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item83" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item83" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item83" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item83"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item83">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. Pratos, talheres e guardanapos devem estar acessíveis.</p>
    <p><strong>Resposta:</strong> Pegar o número de pratos necessários e colocá-los na mesa, distribuir talheres e guardanapos ao lado dos pratos.</p>
    <p><strong>Critério:</strong> Ter ajudado a pôr a mesa ao menos 3x na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não ajuda a pôr a mesa.</li>
      <li><strong>Às Vezes:</strong> Ajuda a pôr a mesa pelo menos 3x na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A84 -->
<div class="portage-card">
  <div class="checkbox-title">A84 - Escova os dentes.</div>
  <div class="checkbox-interpretation">Escova os dentes de forma completa e independente, seguindo a sequência adequada, demonstrando habilidades avançadas de higiene e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item84" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item84" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item84" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item84"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item84">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Cada tentativa inclui: abrir o tubo de pasta, colocar pasta na escova, fechar o tubo, abrir a torneira, molhar as cerdas, movimentar a escova nos dentes, enxaguar a boca, lavar a escova, fechar a torneira e enxugar lábios/mãos.</p>
    <p><strong>Critério:</strong> Ter escovado os dentes pelo menos seis vezes na última semana (espontaneamente ou sendo lembrado).</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não escova os dentes.</li>
      <li><strong>Às Vezes:</strong> Escova os dentes (pelo menos 6x na última semana).</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A85 -->
<div class="portage-card">
  <div class="checkbox-title">A85 - Vai até o banheiro a tempo, retira a roupa, usa papel higiênico, dá descarga e veste-se sem ajuda.</div>
  <div class="checkbox-interpretation">Utiliza o banheiro de forma completa e independente em todas as etapas, demonstrando habilidades avançadas de autocuidado e controle dos esfíncteres.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item85" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item85" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item85" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item85"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item85">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Ter apresentado essa sequência durante toda a semana, podendo falhar ao dar descarga uma ou duas vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não realiza a sequência completa.</li>
      <li><strong>Às Vezes:</strong> Realiza a sequência (banheiro, roupa, papel, descarga, vestir) sem ajuda.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A86 -->
<div class="portage-card">
  <div class="checkbox-title">A86 - Penteia ou escova cabelos compridos.</div>
  <div class="checkbox-interpretation">Penteia ou escova seus próprios cabelos compridos de forma independente, demonstrando habilidades avançadas de coordenação motora e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item86" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item86" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item86" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item86"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item86">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Pegar o pente ou escova na posição correta, pentear seu próprio cabelo (frente, trás, lados) por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não penteia/escova cabelos compridos.</li>
      <li><strong>Às Vezes:</strong> Penteia ou escova cabelos compridos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A87 -->
<div class="portage-card">
  <div class="checkbox-title">A87 - Pendura roupas em cabides.</div>
  <div class="checkbox-interpretation">Pendura suas próprias roupas em cabides de forma organizada, demonstrando habilidades de coordenação motora e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item87" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item87" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item87" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item87"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item87">
    <p><strong>Recursos Materiais:</strong> Roupas = calças ou vestido e camisa.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a colocar adequadamente uma calça/vestido e uma camisa em um cabide.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não pendura roupas em cabides.</li>
      <li><strong>Às Vezes:</strong> Pendura roupas em cabides.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A88 -->
<div class="portage-card">
  <div class="checkbox-title">A88 - Anda pela vizinhança sem constante supervisão.</div>
  <div class="checkbox-interpretation">Desloca-se pela vizinhança de forma independente, sem supervisão constante, demonstrando confiança, responsabilidade e segurança ao se locomover.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item88" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item88" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item88" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item88"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item88">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Caminhar pelo quarteirão de sua casa sem a presença constante do adulto.</p>
    <p><strong>Critério:</strong> Ter feito isso ao menos 3x na última semana, dada a oportunidade.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não anda pela vizinhança sem constante supervisão.</li>
      <li><strong>Às Vezes:</strong> Anda pela vizinhança sem constante supervisão.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A89 -->
<div class="portage-card">
  <div class="checkbox-title">A89 - Enfia cordões em sapatos/tênis.</div>
  <div class="checkbox-interpretation">Entrelaça cordões nos orifícios de sapatos ou tênis, demonstrando habilidades avançadas de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item89" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item89" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item89" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item89"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item89">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Passar o cordão adequadamente por todos os orifícios, formando o entrelaçado. Uma tentativa = fazer isso para um sapato.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não entrelaça cordões de sapatos/tênis.</li>
      <li><strong>Às Vezes:</strong> Entrelaça cordões de sapatos/tênis.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A90 -->
<div class="portage-card">
  <div class="checkbox-title">A90 - Amarra ou dá laços nos cordões dos sapatos/tênis.</div>
  <div class="checkbox-interpretation">Amarra ou dá laços nos próprios sapatos ou tênis de forma independente, demonstrando habilidades avançadas de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado4_5_item90" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item90" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado4_5_item90" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado4_5_item90"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado4_5_item90">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Amarrar = dar nó ou laço (mesmo que frouxo) nos cordões de sapato. Cada tentativa equivale a um nó/laço.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não amarra ou dá laços nos cordões dos sapatos.</li>
      <li><strong>Às Vezes:</strong> Amarra ou dá laços nos cordões dos sapatos/tênis.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>
                    
                    </div>
                        
                    <!-- Faixa 5 - 6 anos - Linguagem -->
                    <div id="autocuidado5_6" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">5 - 6 anos</h5>
                                                
                        <!-- Card A91 -->
<div class="portage-card">
  <div class="checkbox-title">A91 - É responsável por uma tarefa semanal em casa e a executa ao ser lembrado.</div>
  <div class="checkbox-interpretation">Assume a responsabilidade por uma tarefa semanal em casa e a realiza quando lembrado, demonstrando habilidades de organização e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item91" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item91" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item91" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item91"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item91">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. A família precisa ter previamente estipulado a tarefa semanal.</p>
    <p><strong>Resposta:</strong> Tarefa semanal a ser definida pelo familiar (por exemplo: varrer a sala, colocar livros na estante, arrumar o quarto, guardar brinquedos etc.).</p>
    <p><strong>Critério:</strong> Ter executado a tarefa na última semana. A tarefa não deverá precisar ser feita pelo familiar.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não executa uma tarefa da qual é responsável.</li>
      <li><strong>Às Vezes:</strong> Ter executado uma tarefa da qual é responsável, na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A92 -->
<div class="portage-card">
  <div class="checkbox-title">A92 - Seleciona roupas apropriadas ao clima e ocasião.</div>
  <div class="checkbox-interpretation">Escolhe roupas adequadas conforme o clima e a ocasião, demonstrando habilidades avançadas de autocuidado e tomada de decisões sobre vestimenta.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item92" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item92" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item92" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item92"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item92">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Selecionar roupas = selecionar e usar agasalhos em dias frios e roupas leves em dias quentes. Além disso, selecionar e usar roupas “velhas” para ficar em casa e roupas “novas” para sair.</p>
    <p><strong>Critério:</strong> Ter apresentado tal comportamento em pelo menos 6 dias da última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não seleciona roupas apropriadas ao clima e ocasião.</li>
      <li><strong>Às Vezes:</strong> Seleciona roupas apropriadas ao clima e ocasião.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A93 -->
<div class="portage-card">
  <div class="checkbox-title">A93 - Para na calçada, olha para ambos os lados e atravessa a rua sem precisar ser lembrado.</div>
  <div class="checkbox-interpretation">Atravessa a rua de forma segura e independente, parando na calçada, observando o tráfego e cruzando sem necessidade de lembretes, demonstrando habilidades de segurança e responsabilidade.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item93" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item93" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item93" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item93"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item93">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: ter parado na calçada, olhado para ambos os lados e atravessado a rua sem precisar ser lembrado, todas as vezes em que foi dada a oportunidade, na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não para na calçada, olha para ambos os lados e atravessa a rua sem precisar ser lembrado.</li>
      <li><strong>Às Vezes:</strong> Para na calçada, olha para ambos os lados e atravessa a rua sem precisar ser lembrado.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A94 -->
<div class="portage-card">
  <div class="checkbox-title">A94 - Serve-se à mesa e passa aos demais a travessa com comida.</div>
  <div class="checkbox-interpretation">Serve-se à mesa de forma independente e compartilha a comida com os demais, demonstrando habilidades avançadas de coordenação motora, organização e cooperação durante as refeições.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item94" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item94" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item94" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item94"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item94">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Receber a travessa, colocar a travessa ao seu lado, sobre a mesa, e servir-se, pegando com a colher, porções do alimento e colocando em seu prato, até obter a quantidade desejada. Colocar a colher sobre a travessa e passar para outra pessoa. Cada tentativa equivale a servir-se de uma travessa e passá-la para outra pessoa.</p>
    <p><strong>Critério:</strong> Ter apresentado tal comportamento, pelo menos, três vezes em uma refeição na semana anterior.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se serve à mesa e passa aos demais a travessa com comida.</li>
      <li><strong>Às Vezes:</strong> Serve-se à mesa e passa aos demais a travessa com comida, pelo menos 3x em uma refeição.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A95 -->
<div class="portage-card">
  <div class="checkbox-title">A95 - Prepara sua própria xícara de café com leite.</div>
  <div class="checkbox-interpretation">Prepara sua própria xícara de café com leite de forma independente, demonstrando habilidades avançadas de coordenação motora e autocuidado durante as atividades matinais.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item95" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item95" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item95" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item95"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item95">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Despejar leite em uma xícara colocada sobre uma mesa, de forma a encher de leite pelo menos metade da xícara, colocar a leiteira na mesa, pegar o bule de café ou garrafa térmica e desejar um pouco de café sobre o leite, recolocar o bule ou a garrafa sobre a mesa, (se necessário colocar açúcar na xícara) e mexer com a colher. Fazer isto a cada tentativa. Xícara de café com leite pode ser substituída por xícara de leite e chocolate em pó.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não prepara sua própria xícara de café com leite.</li>
      <li><strong>Às Vezes:</strong> Prepara sua própria xícara de café com leite.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A96 -->
<div class="portage-card">
  <div class="checkbox-title">A96 - É responsável por uma tarefa diária em casa (pôr a mesa, levar o lixo).</div>
  <div class="checkbox-interpretation">Assume a responsabilidade por uma tarefa diária em casa e a realiza de forma consistente, demonstrando habilidades de organização e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item96" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item96" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item96" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item96"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item96">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar, que deverá previamente ter estabelecido a tarefa.</p>
    <p><strong>Resposta:</strong> Critério: ter realizado a tarefa, diariamente, na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não realiza uma tarefa diária estabelecida pelo familiar.</li>
      <li><strong>Às Vezes:</strong> Ter realizado a tarefa, diariamente, na última semana.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A97 -->
<div class="portage-card">
  <div class="checkbox-title">A97 - Ajusta a temperatura da água para o banho.</div>
  <div class="checkbox-interpretation">Ajusta a temperatura da água do banho de forma independente, garantindo uma temperatura confortável e segura, demonstrando habilidades avançadas de autocuidado e segurança pessoal.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item97" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item97" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item97" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item97"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item97">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Ajustar a temperatura significa virar a torneira de forma que a água do banho fique em temperatura agradável, sem ser excessivamente quente ou fria.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não ajusta a temperatura da água para o banho.</li>
      <li><strong>Às Vezes:</strong> Ajusta a temperatura da água para o banho.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A98 -->
<div class="portage-card">
  <div class="checkbox-title">A98 - Prepara seu próprio sanduíche ou merenda.</div>
  <div class="checkbox-interpretation">Prepara seu próprio sanduíche ou lanche de forma independente, escolhendo os ingredientes e montando a refeição, demonstrando habilidades avançadas de coordenação motora e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item98" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item98" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item98" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item98"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item98">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Pegar alimentos corretos do armário ou refrigerador e colocá-los no pão.</p>
    <p><strong>Critério:</strong> Na última semana, dada a oportunidade, ter preparado seu próprio lanche pelo menos três vezes.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não prepara seu próprio sanduíche ou merenda.</li>
      <li><strong>Às Vezes:</strong> Prepara seu próprio sanduíche ou merenda.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A99 -->
<div class="portage-card">
  <div class="checkbox-title">A99 - Anda sozinho para a escola, parque ou mercearia a suas quadras de casa.</div>
  <div class="checkbox-interpretation">Vai a locais próximos, como escola, parque ou mercearia, de forma independente e segura, demonstrando confiança e habilidades de navegação pela vizinhança.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item99" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item99" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item99" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item99"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item99">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: ter apresentado tal comportamento, dada a oportunidade, pelo menos três vezes na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não anda sozinho para a escola, parque ou mercearia a suas quadras de casa.</li>
      <li><strong>Às Vezes:</strong> Anda sozinho para a escola, parque ou mercearia a suas quadras de casa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A100 -->
<div class="portage-card">
  <div class="checkbox-title">A100 - Corta alimentos tenros com faca (por exemplo, salsicha, banana, batata cozida).</div>
  <div class="checkbox-interpretation">Corta alimentos tenros com uma faca de forma independente, demonstrando habilidades avançadas de coordenação motora fina e segurança alimentar.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item100" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item100" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item100" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item100"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item100">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa consiste em cortar com a faca todo o alimento em pedaços pequenos.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não corta alimentos tenros com faca.</li>
      <li><strong>Às Vezes:</strong> Corta alimentos tenros com faca.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A101 -->
<div class="portage-card">
  <div class="checkbox-title">A101 - Encontra o banheiro correto em local público.</div>
  <div class="checkbox-interpretation">Identifica e utiliza o banheiro apropriado (masculino ou feminino) em locais públicos de forma independente, demonstrando habilidades de orientação e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item101" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item101" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item101" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item101"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item101">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Entrar por conta própria no banheiro masculino ou feminino, conforme seu sexo.</p>
    <p><strong>Critério:</strong> Apresentar tal comportamento todas as vezes, dada a oportunidade.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não encontra o banheiro correto em local público.</li>
      <li><strong>Às Vezes:</strong> Encontra o banheiro correto em local público.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A102 -->
<div class="portage-card">
  <div class="checkbox-title">A102 - Abre a embalagem de leite.</div>
  <div class="checkbox-interpretation">Abre embalagens de leite de forma independente, demonstrando habilidades avançadas de coordenação motora fina e autonomia nas atividades diárias.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item102" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item102" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item102" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item102"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item102">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Embalagem de plástico poderá estar em um suporte plástico.</p>
    <p><strong>Resposta:</strong> Abrir = cortar com a tesoura infantil a embalagem aluminizada do leite (ou saco plástico), fazendo um pequeno orifício por tentativa.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não abre a embalagem de leite.</li>
      <li><strong>Às Vezes:</strong> Abre a embalagem de leite.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A103 -->
<div class="portage-card">
  <div class="checkbox-title">A103 - Apanha uma bandeja com comida, levando-a e colocando-a sobre a mesa.</div>
  <div class="checkbox-interpretation">Pega uma bandeja com comida, transporta-a até a mesa e a coloca adequadamente, demonstrando habilidades avançadas de coordenação motora e responsabilidade durante as refeições.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item103" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item103" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item103" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item103"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item103">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar.</p>
    <p><strong>Resposta:</strong> Critério: ter apresentado tal comportamento, pelo menos três vezes na semana anterior, dada a oportunidade.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não apanha uma bandeja com comida, levando-a e colocando-a sobre a mesa.</li>
      <li><strong>Às Vezes:</strong> Apanha uma bandeja com comida, levando-a e colocando-a sobre a mesa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A104 -->
<div class="portage-card">
  <div class="checkbox-title">A104 - Amarra os cordões em agasalho com capuz.</div>
  <div class="checkbox-interpretation">Amarra os cordões de um agasalho com capuz de forma independente, demonstrando habilidades avançadas de coordenação motora fina e autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item104" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item104" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item104" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item104"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item104">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Cada tentativa equivale a dar um nó em cordões de agasalho com capuz.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não amarra os cordões em agasalho com capuz.</li>
      <li><strong>Às Vezes:</strong> Amarra os cordões em agasalho com capuz.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card A105 -->
<div class="portage-card">
  <div class="checkbox-title">A105 - Aperta o cinto de segurança em automóvel.</div>
  <div class="checkbox-interpretation">Aperta o cinto de segurança em automóvel de forma independente, demonstrando compreensão de segurança veicular e habilidades de autocuidado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="autocuidado5_6_item105" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item105" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="autocuidado5_6_item105" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_autocuidado5_6_item105"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_autocuidado5_6_item105">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Entrevista com o familiar. Anular o item se a família não possuir carro.</p>
    <p><strong>Resposta:</strong> Apertar o cinto de segurança em automóvel.</p>
    <p><strong>Critérios:</strong> Ter apertado o cinto de segurança em automóvel na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não aperta o cinto de segurança em automóvel.</li>
      <li><strong>Às Vezes:</strong> Aperta o cinto de segurança em automóvel.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

                        
                    </div>
                </div>
            </div>
            
            <!-- Área Motor ok -->
            <div id="motor" class="tab-pane fade" role="tabpanel">
                <h4 class="mt-3">Motor</h4>
                
                <!-- Sub-abas de faixas etárias para Motor -->
                <ul class="nav nav-tabs mt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" href="#motor0_1" data-toggle="tab" role="tab" aria-controls="motor0_1" aria-selected="true">0 - 1</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor1_2" data-toggle="tab" role="tab" aria-controls="motor1_2" aria-selected="false">1 - 2</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor2_3" data-toggle="tab" role="tab" aria-controls="motor2_3" aria-selected="false">2 - 3</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor3_4" data-toggle="tab" role="tab" aria-controls="motor3_4" aria-selected="false">3 - 4</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor4_5" data-toggle="tab" role="tab" aria-controls="motor4_5" aria-selected="false">4 - 5</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#motor5_6" data-toggle="tab" role="tab" aria-controls="motor5_6" aria-selected="false">5 - 6</a>
                    </li>
                </ul>

                <div class="tab-content nested-tab-content" style="margin-top: -15px">
                    <!-- Faixa 0 - 1 ano - Motor -->
                    <div id="motor0_1" class="tab-pane fade show active" role="tabpanel">
                        <h5 class="mt-3">0 - 1 ano</h5>
                        
                        <!-- Faixa 0 - 1 ano - Motor -->
<div id="motor0_1" class="tab-pane fade show active" role="tabpanel">
    <h5 class="mt-3">0 - 1 ano</h5>
    
    <!-- Card DM1 -->
    <div class="portage-card">
      <div class="checkbox-title">DM1 - Alcança um objeto colocado à sua frente (distância de 15 a 20 cm).</div>
      <div class="checkbox-interpretation">Demonstra a habilidade de estender os braços para alcançar objetos próximos, sinalizando o início da coordenação motora fina e grossa.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item1" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item1" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item1" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item1"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item1">
        <p><strong>Recursos Materiais:</strong> Preferivelmente brinquedo ou alimento. Evite usar itens nocivos à criança tais como objetos pontiagudos.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Alcançar = tocar ou encostar dedos/mão no objeto, no máximo 20 segundos após a apresentação do objeto.</p>
        <p><strong>Critério:</strong> Ter alcançado o objeto na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não alcança um objeto colocado à sua frente.</li>
          <li><strong>Às Vezes:</strong> Alcança um objeto colocado à sua frente, dentro de no máximo 20 segundos após sua apresentação.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM2 -->
    <div class="portage-card">
      <div class="checkbox-title">DM2 - Apanha um objeto colocado à sua frente (8 cm).</div>
      <div class="checkbox-interpretation">Mostra a capacidade de agarrar objetos próximos, refletindo o desenvolvimento inicial da preensão e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item2" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item2" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item2" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item2"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item2">
        <p><strong>Recursos Materiais:</strong> Preferivelmente um objeto de fácil preensão, leve e macio (bichinho de borracha).</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Apanhar = segurar o objeto com uma ou ambas as mãos, de forma a erguer-lo, mesmo que este caia logo em seguida.</p>
        <p><strong>Critério:</strong> Ter apanhado o objeto na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não apanha um objeto colocado à sua frente.</li>
          <li><strong>Às Vezes:</strong> Apanha um objeto colocado à sua frente.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM3 -->
    <div class="portage-card">
      <div class="checkbox-title">DM3 - Estende os braços em direção a um objeto colocado à sua frente e o apanha.</div>
      <div class="checkbox-interpretation">Combina movimentos de estender os braços com a preensão de objetos, evidenciando coordenação motora grossa e fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item3" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item3" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item3" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item3"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item3">
        <p><strong>Recursos Materiais:</strong> Preferivelmente um objeto de fácil preensão, leve e macio (bichinho de borracha).</p>
        <p><strong>Condição:</strong> O objeto deve estar colocado cerca de 15 a 20 cm da criança.</p>
        <p><strong>Resposta:</strong> Estender os braços em direção a um objeto colocado à sua frente e o apanhar.</p>
        <p><strong>Critério:</strong> Ter realizado a ação na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não estende os braços e apanha um objeto colocado à sua frente.</li>
          <li><strong>Às Vezes:</strong> Estende os braços em direção a um objeto colocado à sua frente e o apanha.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM4 -->
    <div class="portage-card">
      <div class="checkbox-title">DM4 - Alcança um objeto preferido.</div>
      <div class="checkbox-interpretation">Identifica e alcança objetos favoritos, demonstrando foco e motivação para interagir com brinquedos preferidos.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item4" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item4" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item4" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item4"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item4">
        <p><strong>Recursos Materiais:</strong> Preferência definida pelo familiar. Caso a criança não apresente preferência, apresentar brinquedos de cores vivas, desenho do rosto humano, um aro ou argola.</p>
        <p><strong>Condição:</strong> Criança deitada, objeto colocado acima de sua cabeça numa distância de 15 a 20 cm.</p>
        <p><strong>Resposta:</strong> Alcançar um objeto preferido.</p>
        <p><strong>Critério:</strong> Ter alcançado o objeto preferido na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não alcança um objeto preferido.</li>
          <li><strong>Às Vezes:</strong> Alcança um objeto preferido.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM5 -->
    <div class="portage-card">
      <div class="checkbox-title">DM5 - Coloca objetos na boca.</div>
      <div class="checkbox-interpretation">Explora objetos inserindo-os na boca, uma etapa comum de exploração sensorial e desenvolvimento motor na primeira infância.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item5" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item5" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item5" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item5"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item5">
        <p><strong>Recursos Materiais:</strong> Preferivelmente brinquedo leve, macio e de fácil preensão.</p>
        <p><strong>Condição:</strong> Colocar o objeto próximo à criança ou em sua mão.</p>
        <p><strong>Resposta:</strong> Colocar objetos na boca.</p>
        <p><strong>Critério:</strong> Ter colocado objetos na boca na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não coloca objetos na boca.</li>
          <li><strong>Às Vezes:</strong> Coloca objetos na boca.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM6 -->
    <div class="portage-card">
      <div class="checkbox-title">DM6 - Eleva a cabeça e o tronco, apoiando-se nos braços, ao estar deitado de barriga para baixo.</div>
      <div class="checkbox-interpretation">Fortalece os músculos do pescoço e do tronco ao levantar a cabeça e o tronco apoiando-se nos braços, demonstrando controle corporal.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item6" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item6" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item6" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item6"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item6">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Colocar um objeto no campo visual da criança e erguê-lo acima de sua cabeça.</p>
        <p><strong>Resposta:</strong> Elevar a cabeça e o tronco apoiando-se nos braços por cerca de cinco segundos.</p>
        <p><strong>Critério:</strong> Manter a posição por pelo menos 5 segundos.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não eleva a cabeça e o tronco.</li>
          <li><strong>Às Vezes:</strong> Eleva a cabeça e o tronco apoiando-se nos braços por cerca de 5 segundos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM7 -->
    <div class="portage-card">
      <div class="checkbox-title">DM7 - Levanta a cabeça e o tronco apoiando-se em um só braço.</div>
      <div class="checkbox-interpretation">Aumenta a força muscular ao levantar a cabeça e o tronco utilizando apenas um braço, evidenciando maior controle motor.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item7" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item7" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item7" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item7"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item7">
        <p><strong>Recursos Materiais:</strong> Brinquedo de cores vivas.</p>
        <p><strong>Condição:</strong> Colocar a criança deitada de barriga para baixo. Para aumentar a probabilidade de emissão da resposta, segurar um brinquedo de cores vivas ao lado ou acima da criança.</p>
        <p><strong>Resposta:</strong> Levantar a cabeça e o tronco, apoiando-se em um só braço, por cinco segundos.</p>
        <p><strong>Critério:</strong> Manter a posição por pelo menos 5 segundos.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não levanta a cabeça e o tronco se apoiando em um só braço.</li>
          <li><strong>Às Vezes:</strong> Levanta a cabeça e o tronco apoiando-se em um só braço.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM8 -->
    <div class="portage-card">
      <div class="checkbox-title">DM8 - Toca e explora objetos com a boca.</div>
      <div class="checkbox-interpretation">Explora objetos utilizando a boca, uma forma natural de investigação sensorial e desenvolvimento motor na primeira infância.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item8" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item8" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item8" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item8"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item8">
        <p><strong>Recursos Materiais:</strong> Preferivelmente objetos de borracha ou mordedor.</p>
        <p><strong>Condição:</strong> Objetos colocados próximos ou na mão da criança.</p>
        <p><strong>Resposta:</strong> Explorar objetos com a boca = morder, lamber ou segurar objetos com a boca.</p>
        <p><strong>Critério:</strong> Ter explorado objetos com a boca na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não explora objetos com a boca.</li>
          <li><strong>Às Vezes:</strong> Explora objetos com a boca.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM9 -->
    <div class="portage-card">
      <div class="checkbox-title">DM9 - Estando de barriga para baixo, vira de lado e mantém esta posição em 50% das vezes.</div>
      <div class="checkbox-interpretation">Realiza a rotação corporal de barriga para baixo para o lado, mostrando habilidades de movimentação e controle motor.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item9" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item9" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item9" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item9"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item9">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Colocar a criança de barriga para baixo, mostrando-lhe um brinquedo e segurá-lo sobre a linha média do corpo da criança.</p>
        <p><strong>Resposta:</strong> Virar de lado no máximo um minuto após a apresentação do brinquedo.</p>
        <p><strong>Critérios:</strong> Ter rolado para o lado na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não vira de lado, quando colocado de barriga para baixo.</li>
          <li><strong>Às Vezes:</strong> Vira para o lado, quando colocado de barriga para baixo, 50% das oportunidades.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM10 -->
    <div class="portage-card">
      <div class="checkbox-title">DM10 - Estando de barriga para baixo, virar de costas.</div>
      <div class="checkbox-interpretation">Realiza a rotação corporal de barriga para baixo para as costas, indicando avanço no controle motor e habilidades de movimentação.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item10" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item10" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item10" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item10"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item10">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Colocar um objeto no campo visual da criança e movê-lo para o lado oposto a seu rosto.</p>
        <p><strong>Resposta:</strong> Virar de costas no máximo dentro de um minuto após a apresentação de um brinquedo.</p>
        <p><strong>Critérios:</strong> Ter virado de costas na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não vira de costas, quando colocado de barriga para baixo.</li>
          <li><strong>Às Vezes:</strong> Vira de costas, quando colocado de barriga para baixo, dentro de 1 minuto após apresentação de um brinquedo.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM11 -->
    <div class="portage-card">
      <div class="checkbox-title">DM11 - Estando de barriga para baixo, move-se para frente (o equivalente à altura de seu corpo).</div>
      <div class="checkbox-interpretation">Avança rastejando uma distância maior que sua altura corporal, demonstrando coordenação motora grossa e habilidades de locomoção.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item11" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item11" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item11" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item11"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item11">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Mover-se para frente, no máximo dentro de um minuto após a apresentação de um brinquedo.</p>
        <p><strong>Critérios:</strong> Ter se movido para frente na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não se move para frente, quando colocado de barriga para baixo.</li>
          <li><strong>Às Vezes:</strong> Move-se para frente, quando colocado de barriga para baixo, dentro de 1 minuto após apresentação de um brinquedo.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM12 -->
    <div class="portage-card">
      <div class="checkbox-title">DM12 - Deitado de costas, rola para o lado.</div>
      <div class="checkbox-interpretation">Executa a rotação corporal de costas para o lado, demonstrando controle motor e habilidades de movimentação.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item12" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item12" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item12" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item12"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item12">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Colocar um objeto no campo visual da criança e movê-lo para o lado oposto de seu rosto.</p>
        <p><strong>Resposta:</strong> Rolar para o lado, no máximo um minuto após a apresentação de um brinquedo.</p>
        <p><strong>Critérios:</strong> Ter rolado para o lado na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não rola para o lado, quando deitado de costas.</li>
          <li><strong>Às Vezes:</strong> Rola para o lado, quando deitado de costas, dentro de no máximo 1 minuto após a apresentação do brinquedo.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM13 -->
    <div class="portage-card">
      <div class="checkbox-title">DM13 - Deitado de costas, vira de barriga para baixo.</div>
      <div class="checkbox-interpretation">Realiza a rotação corporal de costas para barriga para baixo, evidenciando desenvolvimento motor e controle de movimentação.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item13" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item13" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item13" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item13"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item13">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Colocar um objeto no campo visual da criança e movê-lo para o lado oposto de seu rosto.</p>
        <p><strong>Resposta:</strong> Virar de barriga para baixo, no máximo dentro de 1 minuto após a apresentação de um brinquedo.</p>
        <p><strong>Critérios:</strong> Ter virado de barriga para baixo na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não vira de barriga para baixo, quando deitado de costas.</li>
          <li><strong>Às Vezes:</strong> Vira de barriga para baixo, quando deitado de costas, dentro de 1 minuto após apresentação de um brinquedo.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM14 -->
    <div class="portage-card">
      <div class="checkbox-title">DM14 - Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</div>
      <div class="checkbox-interpretation">Inicia a posição sentada apoiando-se nos dedos de um adulto, demonstrando controle motor e transição de posições.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item14" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item14" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item14" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item14"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item14">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Colocar a criança deitada.</p>
        <p><strong>Resposta:</strong> Fazer esforço para sentar-se, dentro de um minuto após o adulto tocar com os dedos, a mão da criança.</p>
        <p><strong>Critérios:</strong> Ter sentado-se na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não faz esforço para se sentar.</li>
          <li><strong>Às Vezes:</strong> Faz esforço para sentar-se, segurando-se nos dedos de um adulto.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM15 -->
    <div class="portage-card">
      <div class="checkbox-title">DM15 - Vira a cabeça com facilidade quando o corpo está apoiado.</div>
      <div class="checkbox-interpretation">Rotaciona a cabeça facilmente enquanto o corpo está apoiado, refletindo flexibilidade e controle motor da parte superior do corpo.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item15" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item15" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item15" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item15"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item15">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Estando a criança sentada (apoiada com almofadas, carrinho, cadeira infantil ou em um “bebê conforto”), movimenta-se de um lado para o outro à sua frente.</p>
        <p><strong>Resposta:</strong> Virar a cabeça para a direita ou esquerda, sem tombá-la para frente ou para trás.</p>
        <p><strong>Critérios:</strong> Ter virado a cabeça com facilidade na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não vira a cabeça com facilidade.</li>
          <li><strong>Às Vezes:</strong> Vira a cabeça com facilidade quando o corpo está apoiado.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM16 -->
    <div class="portage-card">
      <div class="checkbox-title">DM16 - Mantém-se sentado por dois minutos.</div>
      <div class="checkbox-interpretation">Consegue permanecer na posição sentada por um período prolongado, demonstrando controle postural e estabilidade.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item16" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item16" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item16" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item16"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item16">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Permanecer sentado por dois minutos, apoiando-se ocasionalmente nas mãos (sem apoio de almofadas).</p>
        <p><strong>Critérios:</strong> Permanecer sentado por dois minutos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não se senta sem apoiar as mãos.</li>
          <li><strong>Às Vezes:</strong> Senta-se sem apoiar as mãos e permanece sentado por 2 minutos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM17 -->
    <div class="portage-card">
      <div class="checkbox-title">DM17 - Transfere objetos de uma mão para outra, estando sentado.</div>
      <div class="checkbox-interpretation">Move objetos entre as mãos enquanto está sentado, evidenciando habilidades de preensão e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item17" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item17" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item17" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item17"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item17">
        <p><strong>Recursos Materiais:</strong> Brinquedos.</p>
        <p><strong>Condição:</strong> Colocar um objeto na mão da criança e, em seguida, apresentar outro objeto próximo à mesma mão.</p>
        <p><strong>Resposta:</strong> Transferir objetos = passar um objeto da mão esquerda para a direita e/ou vice-versa.</p>
        <p><strong>Critérios:</strong> Ter transferido objetos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não transfere objetos de uma mão para outra.</li>
          <li><strong>Às Vezes:</strong> Transfere objetos de uma mão para outra, estando sentado.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM18 -->
    <div class="portage-card">
      <div class="checkbox-title">DM18 - Apanha e deixa cair um objeto propositadamente.</div>
      <div class="checkbox-interpretation">Controla a ação de pegar e soltar objetos intencionalmente, demonstrando compreensão de causa e efeito e coordenação motora.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item18" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item18" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item18" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item18"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item18">
        <p><strong>Recursos Materiais:</strong> Brinquedos.</p>
        <p><strong>Condição:</strong> Criança sentada no berço, em um cadeirão de bebê ou no colo.</p>
        <p><strong>Resposta:</strong> Apanhar e deixar cair um objeto propositadamente.</p>
        <p><strong>Critérios:</strong> Ter apanhado e deixado cair um objeto na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não apanha e deixa cair um objeto propositadamente.</li>
          <li><strong>Às Vezes:</strong> Apanha e deixa cair um objeto propositadamente.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM19 -->
    <div class="portage-card">
      <div class="checkbox-title">DM19 - Fica em pé com o máximo de apoio.</div>
      <div class="checkbox-interpretation">Mantém a posição de pé com suporte significativo, refletindo o início do desenvolvimento do equilíbrio e força muscular.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item19" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item19" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item19" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item19"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item19">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Máximo de apoio = criança segurada por um adulto (com ambas as mãos) pela cintura ou sob os ombros.</p>
        <p><strong>Resposta:</strong> Ficar em pé = manter pernas eretas, por dez segundos, sendo que as plantas dos pés devem tocar o chão.</p>
        <p><strong>Critérios:</strong> Ter ficado em pé com apoio na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não fica em pé com o máximo de apoio.</li>
          <li><strong>Às Vezes:</strong> Fica em pé com o máximo de apoio.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM20 -->
    <div class="portage-card">
      <div class="checkbox-title">DM20 - Estando de pé, apoiando-se em algo, pula para cima e para baixo.</div>
      <div class="checkbox-interpretation">Realiza movimentos de pular para cima e para baixo enquanto está de pé com suporte, demonstrando coordenação motora grossa.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item20" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item20" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item20" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item20"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item20">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Apoio = criança segurada com ambas as mãos em sua cintura ou sob os ombros.</p>
        <p><strong>Resposta:</strong> Estando de pé, com apoio, pular para cima e para baixo.</p>
        <p><strong>Critérios:</strong> Ter pulado na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não pula para cima e para baixo (com apoio).</li>
          <li><strong>Às Vezes:</strong> Pula para cima e para baixo, estando de pé e com apoio.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>

    <!-- Card DM21 -->
    <div class="portage-card">
      <div class="checkbox-title">DM21 - Engatinha para apanhar um objeto (distância igual à altura do corpo).</div>
      <div class="checkbox-interpretation">Move-se rastejando para alcançar objetos distantes, demonstrando desenvolvimento da coordenação motora grossa e habilidades de exploração.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item21" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item21" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item21" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item21"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item21">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Engatinhar = apoiando-se nas mãos e nos joelhos, movimentar-se para a frente, alternando os membros (diferente, portanto, de arrastar-se).</p>
        <p><strong>Critérios:</strong> Ter engatinhado para apanhar um objeto na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não engatinha para apanhar um objeto.</li>
          <li><strong>Às Vezes:</strong> Engatinha para apanhar um objeto.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM22 -->
    <div class="portage-card">
      <div class="checkbox-title">DM22 - Senta-se, apoiando-se sozinho.</div>
      <div class="checkbox-interpretation">Mantém a posição sentada sem necessidade de suporte externo, indicando controle postural e estabilidade.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item22" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item22" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item22" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item22"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item22">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Colocar a criança de gatinhas (com mãos e joelhos apoiados sobre o piso em que está).</p>
        <p><strong>Resposta:</strong> Sentar-se apoiando-se sozinho.</p>
        <p><strong>Critérios:</strong> Ter se sentado na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não se senta, se apoiando sozinha.</li>
          <li><strong>Às Vezes:</strong> Senta-se, apoiando-se sozinho.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM23 -->
    <div class="portage-card">
      <div class="checkbox-title">DM23 - Estando sentado, vira de gatinhas (com mãos e joelhos apoiados sobre o piso em que está).</div>
      <div class="checkbox-interpretation">Realiza a rotação corporal enquanto está na posição de gatinhas, evidenciando coordenação motora e habilidades de movimentação.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item23" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item23" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item23" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item23"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item23">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Colocar no chão um brinquedo numa distância equivalente à altura do corpo.</p>
        <p><strong>Resposta:</strong> Virar de gatinhas (mãos e joelhos apoiados sobre o piso em que está).</p>
        <p><strong>Critérios:</strong> Ter virado de gatinhas na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não vira de gatinhas, quando sentado.</li>
          <li><strong>Às Vezes:</strong> Vira de gatinhas, quando sentado.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM24 -->
    <div class="portage-card">
      <div class="checkbox-title">DM24 - Estando de barriga para baixo, consegue sentar-se.</div>
      <div class="checkbox-interpretation">Consegue se sentar sozinho a partir da posição de barriga para baixo, demonstrando controle motor e fortalecimento muscular.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item24" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item24" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item24" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item24"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item24">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Adulto ajoelhado, próximo à criança, apresentando-lhe um brinquedo.</p>
        <p><strong>Resposta:</strong> Estando de barriga para baixo, consegue sentar-se.</p>
        <p><strong>Critérios:</strong> Ter sentado-se na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não consegue se sentar, quando de barriga para baixo.</li>
          <li><strong>Às Vezes:</strong> Estando de barriga para baixo, consegue sentar-se.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM25 -->
    <div class="portage-card">
      <div class="checkbox-title">DM25 - Senta-se sem apoiar as mãos.</div>
      <div class="checkbox-interpretation">Mantém-se na posição sentada sem apoio das mãos, demonstrando maior controle postural e estabilidade.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item25" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item25" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item25" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item25"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item25">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Permanecer sentado por dois minutos sem apoiar-se nas mãos.</p>
        <p><strong>Critérios:</strong> Ter permanecido sentado por dois minutos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não se senta sem apoiar as mãos.</li>
          <li><strong>Às Vezes:</strong> Senta-se sem apoiar as mãos e permanece sentado por 2 minutos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM26 -->
    <div class="portage-card">
      <div class="checkbox-title">DM26 - Atira objetos ao acaso.</div>
      <div class="checkbox-interpretation">Lança objetos de maneira aleatória, demonstrando habilidades de coordenação motora grossa e manipulação de objetos.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item26" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item26" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item26" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item26"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item26">
        <p><strong>Recursos Materiais:</strong> Bola, bichinho de borracha, brinquedos leves.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Atirar objetos ao acaso = sem direção.</p>
        <p><strong>Critérios:</strong> Ter atirado objetos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não atira objetos ao acaso.</li>
          <li><strong>Às Vezes:</strong> Atira objetos ao acaso.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM27 -->
    <div class="portage-card">
      <div class="checkbox-title">DM27 - Balança para frente e para trás, estando de gatinhas (mãos e joelhos apoiados sobre o piso).</div>
      <div class="checkbox-interpretation">Movimenta o corpo para frente e para trás enquanto está em posição de gatinhas, evidenciando coordenação motora e equilíbrio.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item27" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item27" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item27" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item27"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item27">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Entrevista com o familiar.</p>
        <p><strong>Resposta:</strong> Balançar para frente e para trás, estando de gatinhas (mãos e joelhos apoiados sobre o piso).</p>
        <p><strong>Critérios:</strong> Ter balançado para frente e para trás pelo menos uma vez na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não balança para frente e para trás, quando está de gatinhas.</li>
          <li><strong>Às Vezes:</strong> Balança para frente e para trás, estando de gatinhas.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM28 -->
    <div class="portage-card">
      <div class="checkbox-title">DM28 - Transfere objetos de uma mão para outra, estando sentado.</div>
      <div class="checkbox-interpretation">Move objetos entre as mãos enquanto está sentado, evidenciando habilidades de preensão e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item28" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item28" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item28" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item28"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item28">
        <p><strong>Recursos Materiais:</strong> Brinquedos.</p>
        <p><strong>Condição:</strong> Colocar um objeto na mão da criança e, em seguida, apresentar outro objeto próximo à mesma mão.</p>
        <p><strong>Resposta:</strong> Transferir objetos = passar um objeto da mão esquerda para a direita e/ou vice-versa.</p>
        <p><strong>Critérios:</strong> Ter transferido objetos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não transfere objetos de uma mão para outra.</li>
          <li><strong>Às Vezes:</strong> Transfere objetos de uma mão para outra, estando sentado.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM29 -->
    <div class="portage-card">
      <div class="checkbox-title">DM29 - Retém em uma mão, dois cubos de 2,5 cm.</div>
      <div class="checkbox-interpretation">Segura dois cubos pequenos em uma única mão por alguns segundos, demonstrando habilidades de preensão e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item29" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item29" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item29" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item29"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item29">
        <p><strong>Recursos Materiais:</strong> Cubos de 2,5 cm.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Reter os objetos por cinco segundos.</p>
        <p><strong>Critérios:</strong> Reter 2 cubos de 2,5 cm em uma mão por 5 segundos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não retém objetos em uma mão.</li>
          <li><strong>Às Vezes:</strong> Retém 2 cubos de 2,5 cm em uma mão por 5 segundos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM30 -->
    <div class="portage-card">
      <div class="checkbox-title">DM30 - Fica de joelhos.</div>
      <div class="checkbox-interpretation">Adota a posição de joelhos, demonstrando equilíbrio inicial e coordenação motora.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item30" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item30" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item30" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item30"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item30">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Estando de pé, sentada ou de gatinhas, ajoelha-se.</p>
        <p><strong>Critérios:</strong> Ter ficado de joelhos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não fica de joelhos.</li>
          <li><strong>Às Vezes:</strong> Estando de pé, sentada ou de gatinhas, ajoelha-se.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM31 -->
    <div class="portage-card">
      <div class="checkbox-title">DM31 - Fica em pé, apoiando-se em algo.</div>
      <div class="checkbox-interpretation">Mantém-se na posição de pé com suporte de um objeto, demonstrando habilidades iniciais de equilíbrio e força muscular.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item31" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item31" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item31" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item31"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item31">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Estando sentada, deitada, de joelhos ou de gatinhas, colocar-se em pé, apoiando-se em algo. Algo = grade do berço ou quadrado, sofá, mesa ou cadeira.</p>
        <p><strong>Critério:</strong> Ter ficado em pé com apoio na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não fica em pé, apoiando-se em algo.</li>
          <li><strong>Às Vezes:</strong> Fica em pé, apoiando-se em algo.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM32 -->
    <div class="portage-card">
      <div class="checkbox-title">DM32 - Usa preensão de pinça para pegar objetos.</div>
      <div class="checkbox-interpretation">Utiliza a preensão de pinça (dedo indicador e polegar) para pegar objetos pequenos, refletindo desenvolvimento da coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item32" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item32" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item32" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item32"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item32">
        <p><strong>Recursos Materiais:</strong> Objetos pequenos (uva passa, grão de feijão, milho, contas, botões).</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> No máximo dentro de um minuto após a apresentação dos objetos.</p>
        <p><strong>Observação:</strong> Muita atenção para que a criança não coloque o objeto na boca, nariz ou ouvido.</p>
        <p><strong>Critérios:</strong> Ter usado preensão de pinça na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não usa preensão de pinça para pegar objetos pequenos.</li>
          <li><strong>Às Vezes:</strong> Usa preensão de pinça para pegar objetos pequenos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM33 -->
    <div class="portage-card">
      <div class="checkbox-title">DM33 - Engatinha.</div>
      <div class="checkbox-interpretation">Avança rastejando uma distância maior que sua altura corporal, demonstrando coordenação motora grossa e habilidades de movimentação.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item33" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item33" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item33" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item33"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item33">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Para se considerar uma resposta correta, a criança deverá engatinhar uma distância maior do que a altura de seu corpo.</p>
        <p><strong>Critérios:</strong> Ter engatinhado na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não engatinha.</li>
          <li><strong>Às Vezes:</strong> Engatinha.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM34 -->
    <div class="portage-card">
      <div class="checkbox-title">DM34 - Estando de gatinhas, estende uma das mãos para o alto tentando alcançar algo.</div>
      <div class="checkbox-interpretation">Estende uma das mãos para o alto enquanto está em posição de gatinhas, demonstrando habilidades de alcance e coordenação motora grossa.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item34" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item34" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item34" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item34"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item34">
        <p><strong>Recursos Materiais:</strong> Brinquedo.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Estando de gatinhas, estender uma das mãos para o alto tentando alcançar algo.</p>
        <p><strong>Critérios:</strong> Ter estendido a mão na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não tenta alcançar algo, estendendo a mão, quando está de gatinhas.</li>
          <li><strong>Às Vezes:</strong> Estando de gatinhas, estende uma das mãos para o alto tentando alcançar algo.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM35 -->
    <div class="portage-card">
      <div class="checkbox-title">DM35 - Fica em pé com o mínimo de apoio.</div>
      <div class="checkbox-interpretation">Mantém-se na posição de pé com suporte mínimo, refletindo progresso no equilíbrio e força muscular.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item35" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item35" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item35" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item35"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item35">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Mínimo de apoio = apoiando-se em um móvel com uma só mão ou dando apenas uma das mãos para o adulto.</p>
        <p><strong>Resposta:</strong> Permanece em pé durante 30 segundos.</p>
        <p><strong>Critérios:</strong> Ter permanecido em pé com apoio na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não fica em pé com o mínimo de apoio.</li>
          <li><strong>Às Vezes:</strong> Permanece em pé com o mínimo de apoio durante 30 segundos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM36 -->
    <div class="portage-card">
      <div class="checkbox-title">DM36 - Lambe a comida ao redor da boca.</div>
      <div class="checkbox-interpretation">Utiliza a língua para limpar a comida ao redor da boca, demonstrando coordenação motora fina e desenvolvimento de hábitos alimentares.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item36" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item36" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item36" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item36"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item36">
        <p><strong>Recursos Materiais:</strong> Comida = se necessário utilizar alimento pastoso que a criança aprecia.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Lamber a comida ao redor da boca.</p>
        <p><strong>Critérios:</strong> Ter lambido a comida na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não lambe a comida ao redor da boca.</li>
          <li><strong>Às Vezes:</strong> Lambe a comida ao redor da boca.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM37 -->
    <div class="portage-card">
      <div class="checkbox-title">DM37 - Mantém-se em pé sozinho, por um minuto.</div>
      <div class="checkbox-interpretation">Consegue permanecer na posição de pé de forma independente por um minuto, demonstrando controle postural e equilíbrio avançado.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item37" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item37" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item37" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item37"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item37">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Manter-se em pé sozinho, por um minuto.</p>
        <p><strong>Critérios:</strong> Ter permanecido em pé sozinho por um minuto na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não se mantém em pé sozinho.</li>
          <li><strong>Às Vezes:</strong> Mantém-se em pé sozinho por 1 minuto.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM38 -->
    <div class="portage-card">
      <div class="checkbox-title">DM38 - Derruba um objeto que está dentro de um recipiente.</div>
      <div class="checkbox-interpretation">Intenciona derrubar objetos colocados dentro de recipientes, demonstrando habilidades de manipulação e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item38" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item38" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item38" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item38"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item38">
        <p><strong>Recursos Materiais:</strong> Objeto pequeno, tal como um cubinho ou bala.</p>
        <p><strong>Recipiente:</strong> Xícara inquebrável.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Derrubar um objeto que está dentro de um recipiente.</p>
        <p><strong>Critérios:</strong> Ter derrubado um objeto na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não derruba um objeto que está dentro de um recipiente.</li>
          <li><strong>Às Vezes:</strong> Derruba um objeto que está dentro de um recipiente.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM39 -->
    <div class="portage-card">
      <div class="checkbox-title">DM39 - Vira páginas de um livro (várias ao mesmo tempo).</div>
      <div class="checkbox-interpretation">Vira múltiplas páginas de um livro rapidamente, evidenciando interesse por atividades de leitura e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item39" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item39" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item39" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item39"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item39">
        <p><strong>Recursos Materiais:</strong> Livro = preferivelmente livros de histórias infantis, com páginas grossas.</p>
        <p><strong>Condição:</strong> Se necessário, o adulto pode segurar o livro para a criança.</p>
        <p><strong>Resposta:</strong> Virar páginas de um livro (várias ao mesmo tempo).</p>
        <p><strong>Critérios:</strong> Ter virado páginas na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não vira páginas de um livro.</li>
          <li><strong>Às Vezes:</strong> Vira páginas de um livro.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM40 -->
    <div class="portage-card">
      <div class="checkbox-title">DM40 - Escava com uma colher ou pá.</div>
      <div class="checkbox-interpretation">Utiliza uma colher ou pá para escavar em um recipiente, demonstrando manipulação e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item40" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item40" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item40" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item40"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item40">
        <p><strong>Recursos Materiais:</strong> Colher ou pá, alimento ou areia/terra.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Escavar = inserir colher ou pá em um prato com alimento semissólido ou monte de areia/terra e retirá-la de forma que esta contenha um pouco de alimento ou areia.</p>
        <p><strong>Critérios:</strong> Ter escavado na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não escava com uma colher ou pá.</li>
          <li><strong>Às Vezes:</strong> Escava com uma colher ou pá.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM41 -->
    <div class="portage-card">
      <div class="checkbox-title">DM41 - Coloca pequenos objetos dentro de um recipiente.</div>
      <div class="checkbox-interpretation">Insere pequenos objetos em recipientes, demonstrando habilidades de manipulação e coordenação motora fina.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item41" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item41" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item41" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item41"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item41">
        <p><strong>Recursos Materiais:</strong> Pequenos blocos, lego, uva passa, por exemplo. Recipiente = xícara inquebrável.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> No máximo, dentro de um minuto após apresentação dos objetos.</p>
        <p><strong>Critérios:</strong> Ter colocado objetos na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não coloca pequenos objetos dentro de um recipiente.</li>
          <li><strong>Às Vezes:</strong> Coloca pequenos objetos dentro de um recipiente, dentro de 1 minuto após a apresentação dos objetos.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
    <!-- Card DM42 -->
    <div class="portage-card">
      <div class="checkbox-title">DM42 - Estando de pé, abaixa-se e senta-se.</div>
      <div class="checkbox-interpretation">Executa a transição de pé para sentado de forma controlada, evidenciando equilíbrio e coordenação motora.</div>
      <div class="skill-actions">
        <div class="option"><label><input type="radio" name="motor0_1_item42" value="Sim">Sim</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item42" value="AV">Às Vezes</label></div>
        <div class="option"><label><input type="radio" name="motor0_1_item42" value="Não">Não</label></div>
      </div>
      <div class="portage-orientation-toggle" data-target="orient_motor0_1_item42"><i class="fas fa-chevron-down"></i> Orientações</div>
      <div class="portage-orientation-text" id="orient_motor0_1_item42">
        <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
        <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
        <p><strong>Resposta:</strong> Estando de pé, abaixar-se e sentar-se.</p>
        <p><strong>Critérios:</strong> Ter realizado a ação na última semana.</p>
        <strong>Critérios:</strong><br>
        <ul>
          <li><strong>Sim:</strong> Não se abaixa e senta, estando de pé.</li>
          <li><strong>Às Vezes:</strong> Estando de pé, abaixa-se e senta-se.</li>
          <li><strong>Não:</strong> Item anulado.</li>
        </ul>
      </div>
    </div>
    
</div>

<!-- Card DM43 -->
<div class="portage-card">
  <div class="checkbox-title">DM43 - Bate palmas.</div>
  <div class="checkbox-interpretation">Demonstra habilidades de coordenação motora fina e imitação ao bater palmas seguindo o modelo do adulto.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor0_1_item43" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor0_1_item43" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor0_1_item43" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor0_1_item43"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor0_1_item43">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Sentar frente à criança, bater palmas (modelo) e pedir para que ela o faça.</p>
    <p><strong>Resposta:</strong> Bater palmas.</p>
    <p><strong>Critérios:</strong> Ter batido palmas na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não bate palmas.</li>
      <li><strong>Às Vezes:</strong> Bate palmas, seguindo o modelo.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM44 -->
<div class="portage-card">
  <div class="checkbox-title">DM44 - Anda com o mínimo de apoio.</div>
  <div class="checkbox-interpretation">Exibe desenvolvimento da coordenação motora grossa e habilidades de locomoção independente ao caminhar com o mínimo de apoio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor0_1_item44" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor0_1_item44" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor0_1_item44" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor0_1_item44"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor0_1_item44">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Anda com o mínimo de apoio.</p>
    <p><strong>Critérios:</strong> Ter andado com apoio na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não anda com o mínimo de apoio.</li>
      <li><strong>Às Vezes:</strong> Anda com o mínimo de apoio.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM45 -->
<div class="portage-card">
  <div class="checkbox-title">DM45 - Dá alguns passos sem apoio.</div>
  <div class="checkbox-interpretation">Mostra desenvolvimento da coordenação motora grossa e equilíbrio ao dar alguns passos de forma independente.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor0_1_item45" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor0_1_item45" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor0_1_item45" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor0_1_item45"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor0_1_item45">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Dar alguns passos = dar cinco passos em um minuto.</p>
    <p><strong>Critérios:</strong> Ter dado 5 passos na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não dá passos sem apoio.</li>
      <li><strong>Às Vezes:</strong> Dá 5 passos sem apoio em 1 minuto.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>
    
                        </div>
    
                        <!-- Faixa 1 - 2 anos - Motor -->
                        <div id="motor1_2" class="tab-pane fade" role="tabpanel">
                            <h5 class="mt-3">1 - 2 anos</h5>
                            
<!-- Card DM46 -->
<div class="portage-card">
  <div class="checkbox-title">DM46 - Sobe escadas engatinhando.</div>
  <div class="checkbox-interpretation">Demonstra habilidades de coordenação motora grossa e navegação em ambientes tridimensionais ao subir escadas engatinhando.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item46" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item46" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item46" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item46"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item46">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Subir escadas engatinhando = percorrer pelo menos 4 degraus de uma escada, apoiando-se sobre as mãos e joelhos.</p>
    <p><strong>Critérios:</strong> Ter subido escadas engatinhando na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não sobe escadas engatinhando.</li>
      <li><strong>Às Vezes:</strong> Sobe pelo menos 4 degraus de uma escada, engatinhando.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM47 -->
<div class="portage-card">
  <div class="checkbox-title">DM47 - Coloca-se em pé, estando sentado.</div>
  <div class="checkbox-interpretation">Realiza a transição da posição sentada para de pé de forma independente, demonstrando equilíbrio e força muscular.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item47" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item47" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item47" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item47"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item47">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Sem apoiar-se em algo.</p>
    <p><strong>Critérios:</strong> Ter colocado-se em pé na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se coloca em pé, estando sentado.</li>
      <li><strong>Às Vezes:</strong> Coloca-se em pé, estando sentado, sem apoiar-se em algo.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM48 -->
<div class="portage-card">
  <div class="checkbox-title">DM48 - Rola uma bola imitando um adulto.</div>
  <div class="checkbox-interpretation">Imita movimentos circulares ao rolar uma bola, demonstrando coordenação motora grossa e habilidades de imitação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item48" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item48" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item48" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item48"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item48">
    <p><strong>Recursos Materiais:</strong> Brinquedo com rodas, amarrado por um barbante ou carrinho infantil (carrinho de feira).</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Rolar uma bola = empurrar uma bola de forma que ela percorra uma distância de meio metro, sem necessariamente apresentar direção.</p>
    <p><strong>Critérios:</strong> Ter rolado uma bola na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não rola uma bola imitando um adulto.</li>
      <li><strong>Às Vezes:</strong> Rola uma bola imitando um adulto.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM49 -->
<div class="portage-card">
  <div class="checkbox-title">DM49 - Sobe em uma cadeira de adulto, vira-se e senta-se.</div>
  <div class="checkbox-interpretation">Subir em uma cadeira de adulto, virar-se e sentar-se de forma controlada, demonstrando coordenação motora grossa e equilíbrio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item49" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item49" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item49" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item49"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item49">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Subir em uma cadeira de adulto, virar-se e sentar-se.</p>
    <p><strong>Critérios:</strong> Ter realizado a ação na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não sobe em uma cadeira de adulto, vira-se e senta-se.</li>
      <li><strong>Às Vezes:</strong> Sobe em uma cadeira de adulto, vira-se e senta-se.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM50 -->
<div class="portage-card">
  <div class="checkbox-title">DM50 - Coloca quatro aros em uma pequena estaca.</div>
  <div class="checkbox-interpretation">Empilha quatro aros em uma estaca, demonstrando coordenação motora fina e compreensão de equilíbrio espacial.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item50" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item50" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item50" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item50"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item50">
    <p><strong>Recursos Materiais:</strong> Três blocos de tamanhos diferentes sendo cada um significativamente maior que o outro.</p>
    <p><strong>Condição:</strong> Dar modelo e solicitar a criança realizar a atividade.</p>
    <p><strong>Resposta:</strong> Construir torre de três blocos = colocar um bloco sobre o outro de forma que ao colocar o 3º bloco a torre permaneça de pé pelo menos por um segundo. A resposta deverá ocorrer dentro de 20 segundos após os blocos terem sido apresentados.</p>
    <p><strong>Critérios:</strong> Ter construído uma torre de três blocos na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não constrói uma torre de três blocos.</li>
      <li><strong>Às Vezes:</strong> Constrói uma torre de três blocos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM51 -->
<div class="portage-card">
  <div class="checkbox-title">DM51 - Retira pinos de 2,5 cm de uma prancha ou tabuleiro de encaixe.</div>
  <div class="checkbox-interpretation">Retira pinos de uma prancha ou tabuleiro de encaixe sem ajuda, demonstrando habilidades de preensão e coordenação motora fina.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item51" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item51" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item51" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item51"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item51">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Retirar um pino sem ajuda a cada tentativa.</p>
    <p><strong>Critérios:</strong> Ter retirado pinos na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não retira pinos de uma prancha ou tabuleiro de encaixe.</li>
      <li><strong>Às Vezes:</strong> Retira um pino sem ajuda a cada tentativa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM52 -->
<div class="portage-card">
  <div class="checkbox-title">DM52 - Encaixa pinos de 2,5 cm em uma prancha de encaixe.</div>
  <div class="checkbox-interpretation">Insere pinos em uma prancha de encaixe sem ajuda, demonstrando habilidades de preensão e coordenação motora fina.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item52" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item52" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item52" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item52"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item52">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Encaixar pinos = encaixar um pino na prancha, sem ajuda, por tentativa.</p>
    <p><strong>Critérios:</strong> Ter encaixado pinos na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não encaixa pinos em uma prancha ou tabuleiro de encaixe.</li>
      <li><strong>Às Vezes:</strong> Encaixa um pino em uma prancha, sem ajuda, por tentativa.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM53 -->
<div class="portage-card">
  <div class="checkbox-title">DM53 - Constrói uma torre de três blocos.</div>
  <div class="checkbox-interpretation">Empilha três blocos de tamanhos diferentes de forma que a torre permaneça de pé, demonstrando coordenação motora fina e compreensão de equilíbrio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item53" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item53" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item53" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item53"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item53">
    <p><strong>Recursos Materiais:</strong> Três blocos de tamanhos diferentes sendo cada um significativamente maior que o outro.</p>
    <p><strong>Condição:</strong> Dar modelo e solicitar a criança realizar a atividade.</p>
    <p><strong>Resposta:</strong> Construir torre de três blocos = colocar um bloco sobre o outro de forma que ao colocar o 3º bloco a torre permaneça de pé pelo menos por um segundo. A resposta deverá ocorrer dentro de 20 segundos após os blocos terem sido apresentados.</p>
    <p><strong>Critérios:</strong> Ter construído uma torre de três blocos na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não constrói uma torre de três blocos.</li>
      <li><strong>Às Vezes:</strong> Constrói uma torre de três blocos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM54 -->
<div class="portage-card">
  <div class="checkbox-title">DM54 - Faz traços no papel com lápis ou lápis/giz de cera.</div>
  <div class="checkbox-interpretation">Realiza movimentos de traço no papel utilizando lápis ou giz de cera, evidenciando coordenação motora fina e preparação para habilidades de escrita.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item54" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item54" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item54" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item54"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item54">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Dar modelo e solicitar a resposta.</p>
    <p><strong>Resposta:</strong> Fazer traços no papel com lápis ou lápis/giz de cera.</p>
    <p><strong>Critérios:</strong> Ter feito traços na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não faz traços no papel.</li>
      <li><strong>Às Vezes:</strong> Faz traços no papel com lápis/giz de cera.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM55 -->
<div class="portage-card">
  <div class="checkbox-title">DM55 - Anda sozinho.</div>
  <div class="checkbox-interpretation">Caminha de forma independente, demonstrando habilidades avançadas de coordenação motora grossa e equilíbrio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item55" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item55" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item55" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item55"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item55">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Andar de forma independente, dando dez passos dentro de um minuto sem cair, sem tropeçar ou bater em objetos.</p>
    <p><strong>Critérios:</strong> Ter andado sozinho na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não anda sozinho.</li>
      <li><strong>Às Vezes:</strong> Anda sozinho.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM56 -->
<div class="portage-card">
  <div class="checkbox-title">DM56 - Desce escadas sentado, colocando primeiro os pés.</div>
  <div class="checkbox-interpretation">Desce escadas de forma segura enquanto está sentado, colocando os pés primeiro, demonstrando coordenação motora grossa e segurança.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item56" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item56" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item56" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item56"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item56">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Descer escadas = descer, pelo menos 4 degraus sentada, colocando primeiramente os pés.</p>
    <p><strong>Critérios:</strong> Ter descido escadas na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não desce escadas sentado.</li>
      <li><strong>Às Vezes:</strong> Desce escadas sentado, colocando primeiro os pés.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM57 -->
<div class="portage-card">
  <div class="checkbox-title">DM57 - Senta-se em uma cadeirinha.</div>
  <div class="checkbox-interpretation">Mantém-se sentado de forma confortável e segura em uma cadeirinha, demonstrando coordenação motora grossa e controle postural.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item57" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item57" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item57" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item57"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item57">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Sentar-se em uma cadeirinha.</p>
    <p><strong>Critérios:</strong> Ter sentado-se na cadeirinha na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se senta em uma cadeirinha.</li>
      <li><strong>Às Vezes:</strong> Sentar-se em uma cadeirinha.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM58 -->
<div class="portage-card">
  <div class="checkbox-title">DM58 - Agacha-se e volta a ficar de pé.</div>
  <div class="checkbox-interpretation">Realiza a transição de agachamento para a posição de pé de forma controlada, demonstrando coordenação motora grossa e equilíbrio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item58" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item58" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item58" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item58"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item58">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Estando de pé, agachar-se (sentar sobre os calcanhares) e voltar a ficar de pé sem cair.</p>
    <p><strong>Critérios:</strong> Ter realizado a ação na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não se agacha e volta a ficar de pé.</li>
      <li><strong>Às Vezes:</strong> Estando de pé, agacha-se e volta a ficar de pé, sem cair.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM59 -->
<div class="portage-card">
  <div class="checkbox-title">DM59 - Empurra e puxa brinquedos ao andar.</div>
  <div class="checkbox-interpretation">Empurra e puxa brinquedos enquanto caminha, demonstrando coordenação motora grossa e habilidades de manipulação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item59" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item59" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item59" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item59"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item59">
    <p><strong>Recursos Materiais:</strong> Brinquedo com rodas, amarrado por um barbante ou carrinho infantil (carrinho de feira).</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Empurrar e puxar brinquedos = percorrer uma distância de meio metro, ora empurrando (segurando um brinquedo de rodas caminhando para frente), ora puxando-o (segurando o brinquedo e caminhando para trás).</p>
    <p><strong>Critérios:</strong> Ter empurrado e puxado brinquedos na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não empurra e puxa brinquedos ao andar.</li>
      <li><strong>Às Vezes:</strong> Empurra e puxa brinquedos ao andar.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM60 -->
<div class="portage-card">
  <div class="checkbox-title">DM60 - Usa cadeira ou cavalo de balanço.</div>
  <div class="checkbox-interpretation">Utiliza uma cadeira ou cavalo de balanço para se movimentar, demonstrando coordenação motora grossa e compreensão de causa e efeito.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item60" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item60" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item60" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item60"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item60">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Sentado na cadeira (ou cavalo de balanço), movimenta o corpo para frente e para trás (no mínimo duas vezes), de forma a balançar-se.</p>
    <p><strong>Critérios:</strong> Ter usado cadeira ou cavalo de balanço na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não usa cadeira ou cavalo de balanço.</li>
      <li><strong>Às Vezes:</strong> Usa cadeira ou cavalo de balanço.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM61 -->
<div class="portage-card">
  <div class="checkbox-title">DM61 - Sobe escadas com ajuda.</div>
  <div class="checkbox-interpretation">Sube escadas com a assistência de um adulto, demonstrando coordenação motora grossa e habilidades de equilíbrio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item61" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item61" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item61" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item61"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item61">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Com ajuda = segurar uma das mãos da criança, podendo segurar no corrimão com a outra mão.</p>
    <p><strong>Resposta:</strong> Subir escadas = subir pelo menos quatro degraus sem se sentar ou apoiar-se nas mãos, sem pular degraus, colocando os dois pés em um degrau antes de prosseguir para o próximo.</p>
    <p><strong>Critérios:</strong> Ter subido escadas com ajuda na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não sobe escadas com ajuda.</li>
      <li><strong>Às Vezes:</strong> Sobe pelo menos 4 degraus com ajuda.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM62 -->
<div class="portage-card">
  <div class="checkbox-title">DM62 - Dobra o corpo, sem cair, para apanhar objetos no chão.</div>
  <div class="checkbox-interpretation">Flexiona o corpo de forma controlada para apanhar objetos no chão, demonstrando flexibilidade e coordenação motora grossa.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item62" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item62" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item62" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item62"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item62">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Dobra o corpo = estando de pé apanha um objeto do chão sem se ajoelhar, sentar ou cair.</p>
    <p><strong>Critérios:</strong> Ter dobrado o corpo na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não dobra o corpo, sem cair, para apanhar objetos do chão.</li>
      <li><strong>Às Vezes:</strong> Dobra o corpo, sem cair, para apanhar objetos no chão.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM63 -->
<div class="portage-card">
  <div class="checkbox-title">DM63 - Imita um movimento circular.</div>
  <div class="checkbox-interpretation">Repete movimentos circulares com os dedos, evidenciando coordenação motora fina e habilidades de imitação.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor1_2_item63" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item63" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor1_2_item63" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor1_2_item63"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor1_2_item63">
    <p><strong>Recursos Materiais:</strong> Areia, terra, tinta ou alimento semissólido.</p>
    <p><strong>Condição:</strong> Nenhuma condição específica fornecida.</p>
    <p><strong>Resposta:</strong> Imita um movimento circular = desenha um semicírculo, com os dedos.</p>
    <p><strong>Critérios:</strong> Ter imitado um movimento circular na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não imita um movimento circular.</li>
      <li><strong>Às Vezes:</strong> Imita um movimento circular.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

                            
                    </div>

                    <!-- Faixa 2 - 3 anos - Motor -->
                    <div id="motor2_3" class="tab-pane fade" role="tabpanel">
                        <h5 class="mt-3">2 - 3 anos</h5>
                        
                        <!-- Card DM64 -->
<div class="portage-card">
  <div class="checkbox-title">DM64 - Enfia quatro contas grandes em um cordão, em dois minutos.</div>
  <div class="checkbox-interpretation">Demonstra coordenação motora fina e concentração ao enfiar quatro contas grandes em um cordão dentro do tempo estipulado.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor2_3_item64" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor2_3_item64" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor2_3_item64" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor2_3_item64"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor2_3_item64">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Dar modelo e solicitar resposta.</p>
    <p><strong>Resposta:</strong> Enfiar quatro contas grandes em um cordão, em dois minutos.</p>
    <p><strong>Critérios:</strong> Ter enfiado quatro contas na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não enfia quatro contas em um cordão.</li>
      <li><strong>Às Vezes:</strong> Enfia quatro contas em um cordão, em 2 minutos.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM65 -->
<div class="portage-card">
  <div class="checkbox-title">DM65 - Vira trincos ou maçanetas em portas.</div>
  <div class="checkbox-interpretation">Manipula trincos ou maçanetas para abrir portas, demonstrando coordenação motora fina e compreensão de causa e efeito.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor2_3_item65" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor2_3_item65" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="radio" name="motor2_3_item65" value="Não">Não</label></div>
  </div>
  <div class="portage-orientation-toggle" data-target="orient_motor2_3_item65"><i class="fas fa-chevron-down"></i> Orientações</div>
  <div class="portage-orientation-text" id="orient_motor2_3_item65">
    <p><strong>Recursos Materiais:</strong> Nenhum material específico necessário.</p>
    <p><strong>Condição:</strong> Se necessário, auxiliar a criança a alcançar a altura do trinco, colocando-a sobre um banquinho.</p>
    <p><strong>Resposta:</strong> Virar trincos = virar um trinco ou uma maçaneta de forma que a porta se abra.</p>
    <p><strong>Critérios:</strong> Ter virado trincos ou maçanetas na última semana.</p>
    <strong>Critérios:</strong><br>
    <ul>
      <li><strong>Sim:</strong> Não vira trincos ou maçanetas em portas.</li>
      <li><strong>Às Vezes:</strong> Vira trincos e maçanetas, de forma que a porta se abra.</li>
      <li><strong>Não:</strong> Item anulado.</li>
    </ul>
  </div>
</div>

<!-- Card DM66 -->
<div class="portage-card">
  <div class="checkbox-title">DM66 - Salta no mesmo local com ambos os pés.</div>
  <div class="checkbox-interpretation">Realiza saltos no mesmo local, levantando ambos os pés simultaneamente, demonstrando coordenação motora grossa e equilíbrio.</div>
  <div class="skill-actions">
    <div class="option"><label><input type="radio" name="motor2_3_item66" value="Sim">Sim</label></div>
    <div class="option"><label><input type="radio" name="motor2_3_item66" value="AV">Às Vezes</label></div>
    <div class="option"><label><input type="ra