<?php
header('Content-Type: application/json');

// Lê e decodifica o JSON recebido
$data = json_decode(file_get_contents('php://input'), true);

// Validação dos campos obrigatórios
$requiredFields = [
    'cod', 'area', 'item', 'condicao', 
    'contexto'
];

foreach ($requiredFields as $field) {
    if (!isset($data[$field]) || trim($data[$field]) === '') {
        echo json_encode(['error' => "Campo obrigatório '$field' ausente."]);
        exit;
    }
}

// Função para substituir texto entre aspas duplas por aspas simples
function substituirAspasInternas($texto) {
    return preg_replace('/"([^"]+)"/', '"$1"', $texto);
}

// Função que determina a área
function getAreaFromInput($area) {
    switch($area) {
        case 'ATENÇÃO COMPARTILHADA':
            return 'Atenção Compartilhada';
        default:
            return 'Desconhecida';
    }
}

// Formatação do arquivo de saída
$estrutura = [
    "codigo"    => substituirAspasInternas(trim($data['cod'])),
    "area"      => getAreaFromInput($data['area']),
    "item"      => substituirAspasInternas(trim($data['item'])),
    "condicao"  => substituirAspasInternas(trim($data['condicao'])),
    "contexto"  => substituirAspasInternas(trim($data['contexto']))
];

// Geração da estrutura do arquivo
$saida = "{\n";
foreach ($estrutura as $chave => $valor) {
    $saida .= "  $chave: \"" . addslashes($valor) . "\",\n";
}
$saida .= "},\n";

// Define o nome do arquivo de saída
$arquivo = 'respostas.json';

// Salva o conteúdo gerado no arquivo
if (file_put_contents($arquivo, $saida, FILE_APPEND) !== false) {
    echo json_encode(['status' => 'Sucesso']);
} else {
    echo json_encode(['error' => 'Não foi possível escrever no arquivo.']);
}
?>
