<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <title>Plano de Intervenção - Sistema IFCora</title>
    <!-- Fonte e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- CSS Personalizado -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
            margin: 20px;
        }

        h1 {
            color: #08C89E;
            font-size: 24px;
            margin-bottom: 15px;
        }

        p {
            font-size: 14px;
            color: #4a5568;
        }

        /* Estilização dos Cartões de Itens */
        .ippl-portage-card {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .ippl-classe {
            font-weight: 600;
            margin-bottom: 10px;
            color: #2d3748;
        }

        .ippl-checkbox-title {
            display: flex;
            align-items: center;
            justify-content: space-between;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .ippl-resposta {
            margin-left: 10px;
            font-size: 14px;
        }

        .ippl-resposta.falha {
            color: #e53e3e; /* Vermelho Pastel */
        }
        .ippl-resposta.av {
            color: #ed8936; /* Laranja Suave */
        }

        /* Estilização do Toggle Switch */
        .switch {
            position: relative;
            display: inline-block;
            width: 40px;
            height: 20px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 16px;
            width: 16px;
            left: 2px;
            bottom: 2px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #08C89E;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #08C89E;
        }

        input:checked + .slider:before {
            transform: translateX(20px);
        }

        /* Botão Toggle Orientações */
        .ippl-orient-toggle {
            cursor: pointer;
            color: #3182ce;
            display: inline-flex;
            align-items: center;
            margin-bottom: 10px;
        }
        .ippl-orient-toggle:hover {
            color: #2b6cb0;
        }
        .ippl-orient-toggle i {
            margin-right: 5px;
            transition: transform 0.3s;
        }

        .ippl-orient-text {
            display: none;
            margin-bottom: 10px;
            font-size: 14px;
        }

        /* Destaque quando selecionado */
        .selected-item {
            background-color: #e6fffa; /* Azul Claro */
            border-radius: 4px;
        }

        /* Contadores */
        .ippl-resposta-contadores {
            display: flex;
            gap: 20px;
            font-size: 14px;
            margin-top: 10px;
        }
        .ippl-contador {
            display: flex;
            align-items: center;
        }
        .ippl-contador-label {
            font-weight: 600;
            margin-right: 5px;
        }

        /* Textarea para Instruções */
        .ippl-instrucoes-personalizadas {
            margin-top: 10px;
        }
        .ippl-instrucoes-personalizadas label {
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }
        .ippl-instrucoes-personalizadas textarea {
            width: 100%;
            resize: vertical;
            min-height: 80px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            font-size: 14px;
            color: #2d3748;
        }

        /* Botões de Salvar Instruções */
        .btn-salvar-instrucao {
            background-color: #3182ce;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 6px 12px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            margin-top: 5px;
        }
        .btn-salvar-instrucao:hover {
            background-color: #2b6cb0;
        }

        /* Botão Salvar Seleção */
        .btn-salvar {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
            margin-top: 20px;
        }
        .btn-salvar:hover {
            background-color: #06b287;
        }

        /* Toasts */
        .toast-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1055;
        }

        /* Responsividade */
        @media(max-width: 768px) {
            .ippl-resposta-contadores {
                flex-direction: column;
                gap: 10px;
            }

            .btn-salvar {
                width: 100%;
                text-align: center;
            }
        }
    </style>

    <script>
        // Função para mostrar/ocultar orientações
        function toggleOrientation(id) {
            const orientText = document.getElementById(id);
            const toggleIcon = document.querySelector(`[onclick="toggleOrientation('${id}')"] i`);

            if (orientText.style.display === "block") {
                orientText.style.display = "none";
                toggleIcon.style.transform = "rotate(0deg)";
            } else {
                orientText.style.display = "block";
                toggleIcon.style.transform = "rotate(180deg)";
            }
        }

        // Função para mostrar toasts de notificações
        function showToast(title, message, type = 'success') {
            const toastId = 'toast_' + Date.now();
            let headerClass = 'text-success';
            if (type === 'error') {
                headerClass = 'text-danger';
            } else if (type === 'info') {
                headerClass = 'text-info';
            }

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="4000">
                    <div class="toast-header">
                        <strong class="mr-auto ${headerClass}">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;

            document.querySelector('.toast-container').insertAdjacentHTML('beforeend', toastHTML);
            const newToast = document.getElementById(toastId);
            $(newToast).toast('show');
            $(newToast).on('hidden.bs.toast', function() {
                newToast.remove();
            });
        }

        // Destacar itens selecionados e salvar instruções personalizadas
        document.addEventListener('DOMContentLoaded', () => {
            // Destacar itens selecionados
            document.querySelectorAll('input[name="items[]"]').forEach((checkbox) => {
                checkbox.addEventListener('change', function() {
                    const cardId = this.getAttribute('data-card-id');
                    const card = document.getElementById(cardId);

                    if (this.checked) {
                        card.classList.add('selected-item');
                    } else {
                        card.classList.remove('selected-item');
                    }
                });
            });

            // Botões de salvar instruções personalizadas
            document.querySelectorAll('.btn-salvar-instrucao').forEach((button) => {
                button.addEventListener('click', function(event) {
                    event.preventDefault();
                    const card = this.closest('.ippl-portage-card');
                    const textarea = card.querySelector('textarea');
                    const instructions = textarea.value.trim();
                    const itemValue = card.querySelector('input[name="items[]"]').value;

                    if (!card.querySelector('input[name="items[]"]').checked) {
                        showToast('Erro', 'Selecione o item antes de salvar as instruções.', 'error');
                        return;
                    }

                    if (instructions === "") {
                        showToast('Erro', 'Por favor, adicione suas instruções personalizadas antes de salvar.', 'error');
                        return;
                    }

                    // Aqui você pode adicionar a lógica para salvar as instruções no backend via AJAX
                    // Por enquanto, vamos simular o salvamento com um toast
                    showToast('Sucesso', `Instruções para "${itemValue}" salvas com sucesso!`, 'success');
                });
            });
        });

        // Submeter formulário
        function handleSubmitForm(event) {
            event.preventDefault();

            // Recuperar itens selecionados
            const selectedCheckboxes = Array.from(document.querySelectorAll('input[name="items[]"]:checked'));
            if (selectedCheckboxes.length === 0) {
                showToast('Erro', 'Nenhum item foi selecionado. Por favor, marque ao menos um item.', 'error');
                return;
            }

            // Verificar se todas as instruções estão preenchidas
            let incompleteInstructions = [];
            selectedCheckboxes.forEach((checkbox) => {
                const itemValue = checkbox.value;
                const textareaName = "instrucoes_" + itemValue;
                const instructionsTextarea = document.querySelector(`textarea[name="${textareaName}"]`);
                const instructions = instructionsTextarea ? instructionsTextarea.value.trim() : '';

                if (instructions === "") {
                    incompleteInstructions.push(itemValue);
                }
            });

            if (incompleteInstructions.length > 0) {
                showToast('Erro', `Por favor, preencha as instruções personalizadas para os itens: ${incompleteInstructions.join(', ')}.`, 'error');
                return;
            }

            // Montar dados
            let payload = [];
            selectedCheckboxes.forEach((checkbox) => {
                // ID do item (value do checkbox)
                const itemValue = checkbox.value;

                // Nome do textarea de instruções personalizadas
                const textareaName = "instrucoes_" + itemValue;
                const instructionsTextarea = document.querySelector(`textarea[name="${textareaName}"]`);
                const instructions = instructionsTextarea ? instructionsTextarea.value.trim() : '';

                payload.push({
                    item: itemValue,
                    instrucoesPersonalizadas: instructions
                });
            });

            // Exibir payload no console (ou enviar via AJAX)
            console.log("Itens selecionados:", payload);

            // Aqui poderia haver lógica de envio AJAX para o backend
            // Por ora, vamos apenas exibir um toast de sucesso
            showToast(
                'Sucesso',
                `Você selecionou ${payload.length} item(ns). As instruções personalizadas foram registradas.`,
                'success'
            );

            // Opcional: Limpar seleção após confirmação
            // document.getElementById('formIntervencao').reset();
            // Remover destaque visual
            // document.querySelectorAll('.selected-item').forEach(function(div) {
            //     div.classList.remove('selected-item');
            // });
        }
    </script>
</head>
<body>
    <h1>Itens em Atraso</h1>
    <p>Listamos abaixo apenas os itens que apresentaram "<strong>Não</strong>" ou "<strong>Às vezes</strong>". Selecione quais deseja trabalhar e adicione instruções personalizadas para cada um.</p>

    <!-- Formulário Único -->
    <form id="formIntervencao" onsubmit="handleSubmitForm(event)">
        <!-- Área 1: Cognitiva -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>1. Cognitiva</h4>
            </div>
            <div class="card-body">
                <!-- Faixa Etária 0-1 ano -->
                <p class="age-group">0-1 ano</p>
                <hr>
                <!-- Item 1 -->
                <div class="ippl-portage-card" id="cardItem1">
                    <!-- Classe do Item -->
                    <div class="ippl-classe">Classe: 1 - Discriminação visual</div>

                    <!-- Título do Item + Switch -->
                    <div class="ippl-checkbox-title">
                        <span>
                            S1 <span class="ippl-resposta av">(Às vezes)</span>
                            A criança acompanha o movimento de uma pessoa com os olhos.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S1_Discriminacao_Visual"
                                data-card-id="cardItem1"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <!-- Botão Toggle Orientações -->
                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem1')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem1">
                        <ol>
                            <li>Movimente-se em torno do bebê para verificar se ele acompanha visualmente.</li>
                            <li>Use objetos coloridos que chacoalhem para atrair a atenção do bebê.</li>
                            <li>Varie a distância e o ângulo de aproximação para estimular o acompanhamento visual.</li>
                        </ol>

                        
                    </div>
                    
                    <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S1_Discriminacao_Visual"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>

                    <!-- Contadores -->
                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">3</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">2</span>
                        </div>
                    </div>
                </div>

                <!-- Item 2 -->
                <div class="ippl-portage-card" id="cardItem2">
                    <div class="ippl-classe">Classe: 1 - Discriminação visual</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S2 <span class="ippl-resposta falha">(Não)</span>
                            A criança tem dificuldade em reconhecer cores básicas.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S2_Reconhecimento_Cores"
                                data-card-id="cardItem2"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem2')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem2">
                        <ol>
                            <li>Utilize brinquedos coloridos e chame a atenção da criança para cada cor durante as brincadeiras.</li>
                            <li>Associe cores a objetos do dia a dia para facilitar o reconhecimento (ex: maçã - vermelha, banana - amarela).</li>
                            <li>Realize atividades de pintura e desenho, incentivando a criança a usar e identificar diferentes cores.</li>
                        </ol>

                        
                    </div>
                    
                    <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S2_Reconhecimento_Cores"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">1</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">4</span>
                        </div>
                    </div>
                </div>
                <!-- Adicione mais itens conforme necessário -->
            </div>
        </div>

        <!-- Área 2: Motora -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>2. Motora</h4>
            </div>
            <div class="card-body">
                <!-- Faixa Etária 0-1 ano -->
                <p class="age-group">0-1 ano</p>
                <hr>
                <!-- Item 3 -->
                <div class="ippl-portage-card" id="cardItem3">
                    <div class="ippl-classe">Classe: 2 - Coordenação Motora</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S1 <span class="ippl-resposta av">(Às vezes)</span>
                            A criança consegue empurrar um brinquedo pesado.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S1_Coord_Motora_Grossa"
                                data-card-id="cardItem3"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem3')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem3">
                        <ol>
                            <li>Ofereça brinquedos adequados que a criança possa empurrar ou puxar.</li>
                            <li>Estimule a criança a se movimentar em diferentes direções para fortalecer os músculos.</li>
                            <li>Brinque de empurrar brinquedos juntos para encorajar a coordenação motora.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S1_Coord_Motora_Grossa"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">2</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">3</span>
                        </div>
                    </div>
                </div>

                <!-- Item 4 -->
                <div class="ippl-portage-card" id="cardItem4">
                    <div class="ippl-classe">Classe: 2 - Coordenação Motora</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S2 <span class="ippl-resposta falha">(Não)</span>
                            A criança tem dificuldade em manipular objetos pequenos.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S2_Coord_Motora_Fina"
                                data-card-id="cardItem4"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem4')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem4">
                        <ol>
                            <li>Ofereça brinquedos com diferentes texturas e tamanhos para estimular a manipulação.</li>
                            <li>Pratique atividades que envolvam pegar e soltar objetos, como empilhar blocos.</li>
                            <li>Brinque de encaixar peças para melhorar a coordenação motora fina.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S2_Coord_Motora_Fina"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">1</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">4</span>
                        </div>
                    </div>
                </div>
                <!-- Adicione mais itens conforme necessário -->
            </div>
        </div>

        <!-- Área 3: Comportamental -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>3. Comportamental</h4>
            </div>
            <div class="card-body">
                <!-- Faixa Etária 0-1 ano -->
                <p class="age-group">0-1 ano</p>
                <hr>
                <!-- Item 5 -->
                <div class="ippl-portage-card" id="cardItem5">
                    <div class="ippl-classe">Classe: 3 - Controle de Impulsos</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S1 <span class="ippl-resposta av">(Às vezes)</span>
                            A criança consegue controlar seus impulsos durante brincadeiras estruturadas.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S1_Controle_Impulsos"
                                data-card-id="cardItem5"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem5')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem5">
                        <ol>
                            <li>Estabeleça rotinas claras para ajudar a criança a antecipar o que vai acontecer.</li>
                            <li>Use reforços positivos quando a criança controlar seus impulsos.</li>
                            <li>Pratique jogos que envolvam esperar a vez para desenvolver o autocontrole.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S1_Controle_Impulsos"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">2</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">3</span>
                        </div>
                    </div>
                </div>

                <!-- Item 6 -->
                <div class="ippl-portage-card" id="cardItem6">
                    <div class="ippl-classe">Classe: 3 - Controle de Impulsos</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S2 <span class="ippl-resposta falha">(Não)</span>
                            A criança demonstra dificuldade em interagir socialmente, evitando contato visual e respondendo de forma limitada.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S2_Interacao_Social"
                                data-card-id="cardItem6"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem6')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem6">
                        <ol>
                            <li>Promova atividades em grupo para incentivar a interação com outras crianças.</li>
                            <li>Use jogos e brincadeiras que envolvam turnos e cooperação.</li>
                            <li>Elogie comportamentos positivos de interação social.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S2_Interacao_Social"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">1</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">4</span>
                        </div>
                    </div>
                </div>
                <!-- Adicione mais itens conforme necessário -->
            </div>
        </div>

        <!-- Área 4: Social -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>4. Social</h4>
            </div>
            <div class="card-body">
                <!-- Faixa Etária 0-1 ano -->
                <p class="age-group">0-1 ano</p>
                <hr>
                <!-- Item 7 -->
                <div class="ippl-portage-card" id="cardItem7">
                    <div class="ippl-classe">Classe: 4 - Empatia</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S1 <span class="ippl-resposta av">(Às vezes)</span>
                            A criança mostra empatia respondendo ao choro de um colega.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S1_Empatia"
                                data-card-id="cardItem7"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem7')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem7">
                        <ol>
                            <li>Ensine a criança a reconhecer as emoções dos outros através de expressões faciais.</li>
                            <li>Modelagem: Demonstre como oferecer conforto a alguém que está triste.</li>
                            <li>Use histórias ou brinquedos para ilustrar situações que envolvem empatia.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S1_Empatia"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">2</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">3</span>
                        </div>
                    </div>
                </div>

                <!-- Item 8 -->
                <div class="ippl-portage-card" id="cardItem8">
                    <div class="ippl-classe">Classe: 4 - Trabalho em Equipe</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S2 <span class="ippl-resposta falha">(Não)</span>
                            A criança tem dificuldade em trabalhar em grupo, preferindo atividades individuais.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S2_Trabalho_Equipe"
                                data-card-id="cardItem8"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem8')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem8">
                        <ol>
                            <li>Incentive a participação em atividades que exijam colaboração.</li>
                            <li>Use jogos que envolvam turnos e cooperação para ensinar a importância do trabalho em equipe.</li>
                            <li>Elogie e recompense comportamentos positivos de cooperação.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S2_Trabalho_Equipe"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">1</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">4</span>
                        </div>
                    </div>
                </div>
                <!-- Adicione mais itens conforme necessário -->
            </div>
        </div>

        <!-- Área 5: Adaptativa -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>5. Adaptativa</h4>
            </div>
            <div class="card-body">
                <!-- Faixa Etária 0-1 ano -->
                <p class="age-group">0-1 ano</p>
                <hr>
                <!-- Item 9 -->
                <div class="ippl-portage-card" id="cardItem9">
                    <div class="ippl-classe">Classe: 5 - Independência Pessoal</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S1 <span class="ippl-resposta av">(Às vezes)</span>
                            A criança tenta se alimentar sozinha com auxílio.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S1_Independencia_Pessoal"
                                data-card-id="cardItem9"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem9')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem9">
                        <ol>
                            <li>Ofereça utensílios apropriados para a idade, como colher e garfo de plástico.</li>
                            <li>Incentive a criança a tentar se alimentar sozinha, mesmo que precise de ajuda.</li>
                            <li>Elogie os esforços da criança, reforçando comportamentos de independência.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S1_Independencia_Pessoal"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">2</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">3</span>
                        </div>
                    </div>
                </div>

                <!-- Item 10 -->
                <div class="ippl-portage-card" id="cardItem10">
                    <div class="ippl-classe">Classe: 5 - Habilidades de Vida Diária</div>

                    <div class="ippl-checkbox-title">
                        <span>
                            S2 <span class="ippl-resposta falha">(Não)</span>
                            A criança ainda depende completamente de um adulto para atividades básicas.
                        </span>
                        <label class="switch">
                            <input
                                type="checkbox"
                                name="items[]"
                                value="S2_Habilidades_Vida_Diaria"
                                data-card-id="cardItem10"
                            >
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="ippl-orient-toggle" onclick="toggleOrientation('orientItem10')">
                        <i class="fas fa-chevron-down"></i> Orientações
                    </div>
                    <div class="ippl-orient-text" id="orientItem10">
                        <ol>
                            <li>Envolva a criança em atividades diárias, como vestir-se com supervisão.</li>
                            <li>Use jogos que simulem tarefas domésticas para ensinar habilidades básicas.</li>
                            <li>Elogie e recompense a criança por tentar realizar atividades sozinha.</li>
                        </ol>

                        <!-- Instruções Personalizadas -->
                        <div class="ippl-instrucoes-personalizadas">
                            <label>Instruções Personalizadas:</label>
                            <textarea
                                name="instrucoes_S2_Habilidades_Vida_Diaria"
                                placeholder="Digite aqui suas orientações extras..."
                            ></textarea>
                            <button class="btn-salvar-instrucao">
                                <i class="fas fa-save"></i> Salvar Instruções
                            </button>
                        </div>
                    </div>

                    <div class="ippl-resposta-contadores">
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Passou:</span>
                            <span class="ippl-contador-valor">1</span>
                        </div>
                        <div class="ippl-contador">
                            <span class="ippl-contador-label">Falha:</span>
                            <span class="ippl-contador-valor">4</span>
                        </div>
                    </div>
                </div>
                <!-- Adicione mais itens conforme necessário -->
            </div>
        </div>

        <!-- Botão de Salvar Seleção -->
        <button type="submit" class="btn-salvar">
            <i class="fas fa-check"></i> Salvar Seleção
        </button>
    </form>

    <!-- Container para Toasts -->
    <div class="toast-container"></div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <!-- Bootstrap Bundle para funcionalidades de modal e toast -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Função para mostrar/ocultar orientações
        function toggleOrientation(id) {
            const orientText = document.getElementById(id);
            const toggleIcon = document.querySelector(`[onclick="toggleOrientation('${id}')"] i`);

            if (orientText.style.display === "block") {
                orientText.style.display = "none";
                toggleIcon.style.transform = "rotate(0deg)";
            } else {
                orientText.style.display = "block";
                toggleIcon.style.transform = "rotate(180deg)";
            }
        }

        // Função para mostrar toasts de notificações
        function showToast(title, message, type = 'success') {
            const toastId = 'toast_' + Date.now();
            let headerClass = 'text-success';
            if (type === 'error') {
                headerClass = 'text-danger';
            } else if (type === 'info') {
                headerClass = 'text-info';
            }

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="4000">
                    <div class="toast-header">
                        <strong class="mr-auto ${headerClass}">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;

            document.querySelector('.toast-container').insertAdjacentHTML('beforeend', toastHTML);
            const newToast = document.getElementById(toastId);
            $(newToast).toast('show');
            $(newToast).on('hidden.bs.toast', function() {
                newToast.remove();
            });
        }

        // Destacar itens selecionados e salvar instruções personalizadas
        document.addEventListener('DOMContentLoaded', () => {
            // Destacar itens selecionados
            document.querySelectorAll('input[name="items[]"]').forEach((checkbox) => {
                checkbox.addEventListener('change', function() {
                    const cardId = this.getAttribute('data-card-id');
                    const card = document.getElementById(cardId);

                    if (this.checked) {
                        card.classList.add('selected-item');
                    } else {
                        card.classList.remove('selected-item');
                    }
                });
            });

            // Botões de salvar instruções personalizadas
            document.querySelectorAll('.btn-salvar-instrucao').forEach((button) => {
                button.addEventListener('click', function(event) {
                    event.preventDefault();
                    const card = this.closest('.ippl-portage-card');
                    const textarea = card.querySelector('textarea');
                    const instructions = textarea.value.trim();
                    const itemValue = card.querySelector('input[name="items[]"]').value;

                    if (!card.querySelector('input[name="items[]"]').checked) {
                        showToast('Erro', 'Selecione o item antes de salvar as instruções.', 'error');
                        return;
                    }

                    if (instructions === "") {
                        showToast('Erro', 'Por favor, adicione suas instruções personalizadas antes de salvar.', 'error');
                        return;
                    }

                    // Aqui você pode adicionar a lógica para salvar as instruções no backend via AJAX
                    // Por enquanto, vamos simular o salvamento com um toast
                    showToast('Sucesso', `Instruções para "${itemValue}" salvas com sucesso!`, 'success');
                });
            });
        });

        // Submeter formulário
        function handleSubmitForm(event) {
            event.preventDefault();

            // Recuperar itens selecionados
            const selectedCheckboxes = Array.from(document.querySelectorAll('input[name="items[]"]:checked'));
            if (selectedCheckboxes.length === 0) {
                showToast('Erro', 'Nenhum item foi selecionado. Por favor, marque ao menos um item.', 'error');
                return;
            }

            // Verificar se todas as instruções estão preenchidas
            let incompleteInstructions = [];
            selectedCheckboxes.forEach((checkbox) => {
                const itemValue = checkbox.value;
                const textareaName = "instrucoes_" + itemValue;
                const instructionsTextarea = document.querySelector(`textarea[name="${textareaName}"]`);
                const instructions = instructionsTextarea ? instructionsTextarea.value.trim() : '';

                if (instructions === "") {
                    incompleteInstructions.push(itemValue);
                }
            });

            if (incompleteInstructions.length > 0) {
                showToast('Erro', `Por favor, preencha as instruções personalizadas para os itens: ${incompleteInstructions.join(', ')}.`, 'error');
                return;
            }

            // Montar dados
            let payload = [];
            selectedCheckboxes.forEach((checkbox) => {
                // ID do item (value do checkbox)
                const itemValue = checkbox.value;

                // Nome do textarea de instruções personalizadas
                const textareaName = "instrucoes_" + itemValue;
                const instructionsTextarea = document.querySelector(`textarea[name="${textareaName}"]`);
                const instructions = instructionsTextarea ? instructionsTextarea.value.trim() : '';

                payload.push({
                    item: itemValue,
                    instrucoesPersonalizadas: instructions
                });
            });

            // Exibir payload no console (ou enviar via AJAX)
            console.log("Itens selecionados:", payload);

            // Aqui poderia haver lógica de envio AJAX para o backend
            // Por ora, vamos apenas exibir um toast de sucesso
            showToast(
                'Sucesso',
                `Você selecionou ${payload.length} item(ns). As instruções personalizadas foram registradas.`,
                'success'
            );

            // Opcional: Limpar seleção após confirmação
            // document.getElementById('formIntervencao').reset();
            // Remover destaque visual
            // document.querySelectorAll('.selected-item').forEach(function(div) {
            //     div.classList.remove('selected-item');
            // });
        }
    </script>
</body>
</html>