<?php
define('OPENAI_API_KEY', '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');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['item'])) {
    header('Content-Type: application/json');
    $item = trim($_POST['item']);

    // Prompt refinado com raciocínio clínico e linguagem acessível
    $systemPrompt = <<<EOPROMPT
Você é um terapeuta infantil especialista em desenvolvimento de crianças de 0 a 6 anos. Dado um item de avaliação do desenvolvimento infantil, sua tarefa é gerar etapas terapêuticas progressivas para desenvolver a habilidade descrita, utilizando raciocínio clínico considerando que algumas habilidades exigem pré-requisitos, como manter atenção compartilhada, locomoção, ou compreensão de comandos simples.

Para cada etapa a ser criada, siga as diretrizes abaixo:

Regras de construção da etapa:
- Escreva uma descrição clara e concisa.
- Use linguagem acessível e direta.
- Cada etapa deve ser compreensível de forma independente.
- Todas as etapas devem ser pensadas para o contexto terapêutico de uma clinica.
- Gere o menor numero de etapas possivel (máximo 5).

Estrutura técnica de cada etapa:
- Para cada objeto da lista de etapas, preencha os seguintes campos:
codigo: código identificador sequencial, como "S44E01", "S44E02", etc.
- descricao: instrução clara e completa da atividade terapêutica.
- nivelSuporte: nível de apoio necessário, escolhendo apenas um dos seguintes valores:
• "SFT": Suporte Físico Total
• "SFT+SV": Suporte Físico Total + Suporte Verbal
• "SFT+SG": Suporte Físico Total + Suporte Gestual
• "SFP": Suporte Físico Parcial
• "SFP+SV": Suporte Físico Parcial + Suporte Verbal
• "SFP+SG": Suporte Físico Parcial + Suporte Gestual
• "SV": Suporte Verbal
• "SG": Suporte Gestual
• "Independente": sem qualquer suporte
- frequencia: número ideal de oportunidades por sessão em que essa etapa deve ser aplicada (ex: 6).

Lógica de progressão:
- As etapas devem progredir do maior para o menor nível de suporte, até chegar à execução independente da habilidade.
- Respeite a ordem terapêutica: habilidades mais simples ou com maior apoio devem vir antes das mais complexas ou autônomas.
- Pense em aplicabilidade prática realista, alinhada ao que acontece nas sessões com crianças pequenas.

Formato do retorno:
Imoprtante! Retorne a nova string JSON completa, ou seja,  exatamente como foi enviada mas com o campo etapas preenchido.
EOPROMPT;

    $data = [
        "model" => "gpt-4o",
        "messages" => [
            [
                "role" => "system",
                "content" => $systemPrompt
            ],
            [
                "role" => "user",
                "content" => $item
            ]
        ],
        "max_tokens" => 800,
        "temperature" => 0.2
    ];

    $ch = curl_init('https://api.openai.com/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . OPENAI_API_KEY
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $result = curl_exec($ch);
    curl_close($ch);

    $result_json = json_decode($result, true);
    if (isset($result_json['choices'][0]['message']['content'])) {
        echo json_encode([
            'ok' => true,
            'content' => trim($result_json['choices'][0]['message']['content'])
        ]);
    } else {
        echo json_encode([
            'ok' => false,
            'error' => $result_json['error']['message'] ?? 'Erro desconhecido'
        ]);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Processador de Strings IFCora</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 40px; }
        textarea, input { width: 100%; font-family: monospace; }
        textarea { min-height: 80px; }
        label { font-weight: bold; }
        .container { max-width: 900px; margin: 0 auto; }
        .json-bloco { background: #f8f9fa; border: 1px solid #ccc; padding: 10px; margin-bottom: 10px; }
        .resultado { background: #eaffea; border: 1px solid #bbddb6; padding: 10px; min-height: 60px; margin-top: 5px; }
        .erro { background: #ffeaea; border: 1px solid #eebbba; color: #b80000; padding: 10px; }
        .waiting { color: #6e6e6e; font-style: italic; }
        #saida_final, #saida_compilada { min-height: 120px; }
        .mt20 { margin-top: 20px; }
    </style>
</head>
<body>
<div class="container">
    <h2>Processador em Lote de Strings IFCora</h2>
    <label for="input_strings">Cole aqui as strings JSON dos itens, separadas por vírgula:</label>
    <textarea id="input_strings"></textarea>
    <button id="separarBtn" type="button">Separar Strings</button>
    <div id="blocos"></div>
    <button id="gerarBtn" type="button" style="display:none;">Gerar Etapas para Todos</button>
    
    <div class="mt20" id="resultados_agrupados" style="display:none;">
        <label for="saida_final">Resultados individuais (copie se quiser cada um):</label>
        <textarea id="saida_final" readonly></textarea>
        <br>
        <label for="saida_compilada" style="margin-top:8px;">Resultado compilado (todos juntos, separados por vírgula):</label>
        <textarea id="saida_compilada" readonly></textarea>
    </div>
</div>
<script>
function separarJsons(texto) {
    let blocos = [];
    let nivel = 0;
    let inicio = null;
    for (let i = 0; i < texto.length; i++) {
        if (texto[i] === '{') {
            if (nivel === 0) inicio = i;
            nivel++;
        }
        if (texto[i] === '}') {
            nivel--;
            if (nivel === 0 && inicio !== null) {
                blocos.push(texto.substring(inicio, i + 1).trim());
                inicio = null;
            }
        }
    }
    return blocos;
}

document.getElementById('separarBtn').onclick = function() {
    let texto = document.getElementById('input_strings').value.trim();
    if (!texto) return;
    let blocos = separarJsons(texto);
    let html = '';
    blocos.forEach((bloco, i) => {
        html += `
        <div class="json-bloco" data-idx="${i}">
            <label>Item ${i+1}</label>
            <textarea readonly>${bloco}</textarea>
            <div class="resultado waiting" id="resultado_${i}">Aguardando...</div>
        </div>`;
    });
    document.getElementById('blocos').innerHTML = html;
    document.getElementById('gerarBtn').style.display = 'inline-block';
    document.getElementById('resultados_agrupados').style.display = 'none';
};

document.getElementById('gerarBtn').onclick = async function() {
    let blocosDivs = document.querySelectorAll('.json-bloco');
    let resultados = [];
    let resultados_individuais = [];
    for (let i=0; i<blocosDivs.length; i++) {
        let blocoDiv = blocosDivs[i];
        let txt = blocoDiv.querySelector('textarea').value;
        let resultDiv = blocoDiv.querySelector('.resultado');
        resultDiv.innerHTML = 'Processando...';
        try {
            let resp = await fetch('', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'item=' + encodeURIComponent(txt)
            });
            let dados = await resp.json();
            if (dados.ok) {
                let jsonOnly = dados.content.match(/\{[\s\S]*\}/);
                let finalJson = jsonOnly ? jsonOnly[0] : dados.content;
                resultDiv.innerHTML = `<pre>${finalJson}</pre>`;
                resultados.push(finalJson);
                resultados_individuais.push(finalJson);
            } else {
                resultDiv.innerHTML = `<div class="erro">Erro: ${dados.error}</div>`;
                resultados.push('');
            }
        } catch (e) {
            resultDiv.innerHTML = `<div class="erro">Falha na requisição.</div>`;
            resultados.push('');
        }
        // Aguarda 3 segundos antes de ir para o próximo
        await new Promise(resolve => setTimeout(resolve, 3000));
    }
    // Exibe todos no formato {...},{...}
    document.getElementById('resultados_agrupados').style.display = 'block';
    document.getElementById('saida_final').value = resultados_individuais.join('\n\n');
    document.getElementById('saida_compilada').value = resultados_individuais.join(',');
};
</script>
</body>
</html>
