<?php
function removerAspasDasChaves($inputJson) {
    // Remove aspas das chaves (mantém aspas nos valores)
    return preg_replace('/"(\w+)"\s*:/', '$1:', $inputJson);
}

$resultado = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['jsonInput'])) {
    $entrada = $_POST['jsonInput'];
    $resultado = removerAspasDasChaves($entrada);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Remover Aspas das Chaves</title>
    <style>
        body {
            font-family: sans-serif;
            padding: 2rem;
            background: #f3f4f6;
        }
        textarea {
            width: 100%;
            min-height: 200px;
            padding: 10px;
            font-family: monospace;
            font-size: 14px;
            border-radius: 5px;
            border: 1px solid #ccc;
            box-sizing: border-box;
        }
        .btn {
            background: #2563eb;
            color: white;
            padding: 10px 20px;
            border: none;
            margin-top: 10px;
            cursor: pointer;
            border-radius: 5px;
        }
        .btn:hover {
            background: #1d4ed8;
        }
        .output {
            margin-top: 20px;
        }
        pre {
            background: #fff;
            padding: 1rem;
            border-radius: 5px;
            white-space: pre-wrap;
            word-wrap: break-word;
            position: relative;
        }
        .copy-btn {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #10b981;
            border: none;
            color: white;
            padding: 5px 10px;
            font-size: 12px;
            cursor: pointer;
            border-radius: 4px;
        }
        .copy-btn:hover {
            background: #059669;
        }
    </style>
</head>
<body>

    <h2>Remover Aspas das Chaves do JSON</h2>
    <form method="post">
        <label for="jsonInput">Cole seu JSON abaixo:</label><br>
        <textarea name="jsonInput" id="jsonInput"><?php echo isset($_POST['jsonInput']) ? htmlspecialchars($_POST['jsonInput']) : ''; ?></textarea><br>
        <button type="submit" class="btn">Gerar</button>
    </form>

    <?php if (!empty($resultado)): ?>
        <div class="output">
            <h3>Resultado:</h3>
            <pre id="resultadoJson">
                <?php echo htmlspecialchars($resultado); ?>
                <button class="copy-btn" onclick="copiarResultado()">Copiar</button>
            </pre>
        </div>
    <?php endif; ?>

    <script>
        function copiarResultado() {
            const pre = document.getElementById('resultadoJson');
            const text = pre.innerText.trim();

            navigator.clipboard.writeText(text).then(() => {
                alert("Resultado copiado para a área de transferência!");
            }).catch(err => {
                alert("Erro ao copiar: " + err);
            });
        }
    </script>

</body>
</html>
