<?php

// Definir o cabeçalho para permitir requisições de qualquer origem (CORS)
header('Content-Type: application/json');

// Receber o corpo da requisição (dados brutos)
$inputData = file_get_contents("php://input");

// Definir o diretório de logs
$logDirectory = 'logs/';

// Verificar se o diretório de logs existe, caso contrário, criá-lo
if (!is_dir($logDirectory)) {
    mkdir($logDirectory, 0777, true); // Cria o diretório com permissões adequadas
}

// Definir o caminho do arquivo de log
$logFile = $logDirectory . 'logs.txt';

// Salvar os dados brutos recebidos no arquivo de log com timestamp
file_put_contents($logFile, date('Y-m-d H:i:s') . ": " . $inputData . "\n", FILE_APPEND);

// Confirmar que os dados foram recebidos e salvos
echo json_encode(["status" => "success", "message" => "Log recebido"]);
?>
