<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <!-- Fonte personalizada e Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <link rel="stylesheet" href="css/styles.css">
    
    <style>
        /* Estilos para as abas */
        .tabs-container {
            width: 100%;
        }

        .tabs {
            display: flex;
            border-bottom: 2px solid #ddd;
        }

        .tab {
            padding: 10px 20px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .tab:hover {
            background-color: #f1f1f1;
        }

        .tab.active {
            border-bottom: 2px solid #08C89E;
            color: #08C89E;
            font-weight: 600;
        }

        .tab-content {
            display: none;
            padding: 20px 0;
        }

        .tab-content.active {
            display: block;
        }

        /* Estilos para filtros e tabelas */
        .filters {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
        }

        .filters div {
            display: flex;
            flex-direction: column;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 12px;
            text-align: left;
        }

        th {
            background-color: #f9f9f9;
        }

        /* Estilos para botões */
        .btn {
            padding: 8px 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
        }

        .btn.copy {
            background-color: #08C89E;
            color: white;
        }

        .btn.delete {
            background-color: transparent;
            color: red;
        }

        .btn.create-invite {
            background-color: #08C89E;
            color: white;
        }

        /* Estilos para o modal */
        .modal {
            display: none; 
            position: fixed; 
            z-index: 1000; 
            left: 0;
            top: 0;
            width: 100%; 
            height: 100%; 
            overflow: auto; 
            background-color: rgba(0,0,0,0.5); 
        }

        .modal-content {
            background-color: #fefefe;
            margin: 10% auto; 
            padding: 20px;
            border: 1px solid #888;
            width: 400px; 
            border-radius: 8px;
            position: relative;
        }

        .close {
            color: #aaa;
            position: absolute;
            top: 10px;
            right: 20px;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .close:hover,
        .close:focus {
            color: black;
        }

        /* Estilos para seções de histórico e detalhes */
        .summary-section {
            margin-bottom: 20px;
        }

        .section {
            margin-top: 20px;
        }

        /* Responsividade */
        @media (max-width: 768px) {
            .filters {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos">
            <h2>Sistema de Avaliação - IFCora</h2>
        </div>
        <nav class="user-menu">
            <a href="#" title="Notificações"><i class="fas fa-bell"></i></a>
            <a href="#" title="Configurações"><i class="fas fa-cog"></i></a>
            <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>
        </nav>
    </header>
    <!-- Sidebar -->
    <?php include 'includes/sidebar-painel-profissional-profissionais.php'; ?>
    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1 style="color: #08C89E">Profissionais</h1>
        </div>

        <!-- Seção das Abas -->
        <div class="tabs-container">
            <div class="tabs">
                <div class="tab active" data-tab="profissionais-tab">
                    <i class="fas fa-user-md"></i> Profissionais
                </div>
                <div class="tab" data-tab="convites-tab">
                    <i class="fas fa-envelope"></i> Convites
                </div>
                <div class="tab" data-tab="parceiras-tab">
                    <i class="fas fa-handshake"></i> Parcerias
                </div>
            </div>

            <!-- Aba Profissionais -->
            <div id="profissionais-tab" class="tab-content active">
                <h2 style="color: #08C89E">Gerenciamento de Profissionais</h2>
                <p style="margin-top: -30px"><small>Gerencie os profissionais atribuídos às suas clínicas.</small></p>
                <hr />

                <div class="filters">
                    <div>
                        <label for="clinicSelect">Selecione a Clínica</label>
                        <select id="clinicSelect" onchange="filterTable('professionalsTable', this.value, 'clinic')">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchProfessional">Pesquisar Profissional</label>
                        <input type="text" id="searchProfessional" onkeyup="searchTable('professionalsTable', this.value)" placeholder="Nome, Profissão ou Email do profissional...">
                    </div>
                </div>
                <table id="professionalsTable">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Profissão</th>
                            <th>Email</th>
                            <th>Clínica</th>
                            <th>Ações</th>
                            <th>Excluir</th> <!-- Nova Coluna para Excluir -->
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Mariana Santos</td>
                            <td>Fonoaudióloga</td>
                            <td>mariana.santos@example.com</td>
                            <td>Clínica Sertãozinho</td>
                            <td><a href="#" class="btn copy"><i class="fas fa-unlock"></i> Desvincular</a></td>
                            <td><button class="btn delete" onclick="confirmDelete('mariana.santos@example.com')"><i class="fas fa-trash-alt"></i></button></td>
                        </tr>
                        <!-- Adicione mais linhas conforme necessário -->
                    </tbody>
                </table>
            </div>

            <!-- Aba Convites -->
            <div id="convites-tab" class="tab-content">
                <h2 style="color: #08C89E">Gerenciamento de Convites</h2>
                
                <p style="margin-top: -30px"><small>Crie e gerencie convites para outros profissionais participarem das suas clínicas.</small></p>
                
                <!-- Botão Criar acima dos filtros -->
                <button class="btn create-invite" id="openModalBtn" style="margin-bottom: 10px;">
                    <i class="fas fa-plus"></i> Criar Novo Convite
                </button>
                <hr />
                
                <div class="filters">
                    <div>
                        <label for="clinicFilterConvites">Selecione a Clínica</label>
                        <select id="clinicFilterConvites" onchange="filterTable('pendingInvitesTable', this.value, 'clinic')">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchConviteName">Pesquisar por Nome</label>
                        <input type="text" id="searchConviteName" onkeyup="searchTable('pendingInvitesTable', this.value)" placeholder="Nome do convidado...">
                    </div>
                </div>
                
                <table id="pendingInvitesTable">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Email</th>
                            <th>Clínica</th>
                            <th>Código</th>
                            <th>Status</th>
                            <th>Ações</th>
                            <th>Excluir</th> <!-- Nova Coluna para Excluir -->
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Ana Silva</td>
                            <td>ana.silva@example.com</td>
                            <td>Clínica Sertãozinho</td>
                            <td>ABC123</td>
                            <td style="color:#08C89E; font-weight:bold;">Pendente</td>
                            <td><button class="btn copy" onclick="copyCode('ABC123')"><i class="fas fa-copy"></i> Copiar Código</button></td>
                            <td><button class="btn delete" onclick="confirmDeleteInvite('ABC123')"><i class="fas fa-trash-alt"></i></button></td>
                        </tr>
                        <!-- Adicione mais linhas conforme necessário -->
                    </tbody>
                </table>
            </div>

            <!-- Aba Parcerias -->
            <div id="parceiras-tab" class="tab-content">
                <h2 style="color: #08C89E">Gerenciamento de Parcerias</h2>
                <p style="margin-top: -30px"><small>Carregue um código de convite para participar de outras clínicas como convidado.</small></p>

                
                <div class="summary-section">
                
                <form id="acceptPartnerInviteForm" style="display: flex; align-items: center; gap: 10px;" onsubmit="handlePartnerInvite(event)">
                    <label for="partnerInviteCodeInput">Código de Convite:</label>
                    <input 
                        type="text" 
                        id="partnerInviteCodeInput" 
                        required 
                        style="
                            width: 150px; 
                            padding: 8px 16px; 
                            border: 2px solid #08C89E; 
                            border-radius: 8px; 
                            font-size: 16px;" 
                        placeholder="ABC123">
                    <button 
                        type="submit" 
                        class="btn create-invite" 
                        style="
                            padding: 8px 16px; 
                            border: none; 
                            border-radius: 8px; 
                            background-color: #08C89E; 
                            color: white; 
                            font-size: 16px; 
                            cursor: pointer;">
                        Carregar Convite
                    </button>
                </form>

                <div id="parceirasInviteDetails" style="display: none; text-align: center; margin-top: 20px;">
                    <p>Convite para a clínica: <strong id="parceirasClinicName"></strong></p>
                    <p>Convidado por: <strong id="parceirasInviterName"></strong></p>
                    <div style="display: flex; align-items: center; margin-top: 10px;">
                        <button class="btn accept" id="parceirasAcceptButton" style="
                            padding: 8px 16px; 
                            border: none; 
                            border-radius: 8px; 
                            background-color: #08C89E; 
                            color: white; 
                            font-size: 16px; 
                            cursor: pointer;">
                            <i class="fas fa-thumbs-up"></i> Aceitar
                        </button>
                        <button class="btn decline" id="parceirasDeclineButton" style="
                            padding: 8px 16px; 
                            border: none; 
                            border-radius: 8px; 
                            background-color: #E74C3C; 
                            color: white; 
                            font-size: 16px; 
                            cursor: pointer; 
                            margin-left: 10px;">
                            <i class="fas fa-thumbs-down"></i> Recusar
                        </button>
                    </div>
                </div>
                
                </div>
                <hr />

                <!-- Seção Histórico de Convites -->
                <div class="section">
                    
                    <div class="filters">
                        <div>
                            <label for="clinicFilterParceirasHistory">Selecione a Clínica</label>
                            <select id="clinicFilterParceirasHistory" onchange="filterTable('inviteHistoryTable', this.value, 'clinic')">
                                <option value="">Todas</option>
                                <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                                <option value="Clínica Central">Clínica Central</option>
                                <option value="Clínica do Norte">Clínica do Norte</option>
                            </select>
                        </div>
                        <div>
                            <label for="searchParceirasHistoryName">Pesquisar por Nome</label>
                            <input type="text" id="searchParceirasHistoryName" onkeyup="searchTable('inviteHistoryTable', this.value)" placeholder="Nome...">
                        </div>
                    </div>
                    <table id="inviteHistoryTable">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Clínica</th>
                                <th>Status</th>
                                <th>Data</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Carlos Souza</td>
                                <td>carlos.souza@example.com</td>
                                <td>Clínica Sertãozinho</td>
                                <td>Aceito</td>
                                <td>01/10/2023</td>
                                <td><button class="btn copy" onclick="encerrarConvite('Carlos Souza')"><i class="fas fa-times"></i> Encerrar</button></td>
                            </tr>
                            <!-- Adicione mais linhas conforme necessário -->
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

    </main>

    <!-- Modal Criar Convite -->
    <div id="inviteModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Criar Novo Convite</h2>
            <form id="inviteForm" onsubmit="handleInviteForm(event)">
                <label for="inviteName">Nome do Profissional</label>
                <input type="text" id="inviteName" name="inviteName" required>
                <label for="inviteEmail">Email do Profissional</label>
                <input type="email" id="inviteEmail" name="inviteEmail" required>
                <label for="inviteClinic">Clínica</label>
                <select id="inviteClinic" name="inviteClinic" required>
                    <option value="">Selecione uma clínica</option>
                    <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                    <option value="Clínica Central">Clínica Central</option>
                    <option value="Clínica do Norte">Clínica do Norte</option>
                </select>
                <button type="submit" class="btn create-invite">
                    <i class="fas fa-paper-plane"></i> Gerar Convite
                </button>
            </form>
            <div id="inviteCodeSection" style="display: none; text-align: center; margin-top: 20px;">
                <p>O código de convite é:</p>
                <h3 id="inviteCode"></h3>
                <button class="btn copy" id="copyInviteCodeBtn">
                    <i class="fas fa-copy"></i> Copiar Código
                </button>
                <p>Envie este código para o profissional convidado.</p>
            </div>
        </div>
    </div>

    <script>
        // Funções para filtros e busca
        function filterTable(tableId, filterValue, column) {
            const table = document.getElementById(tableId);
            const tr = table.getElementsByTagName("tr");
            for (let i = 1; i < tr.length; i++) {
                const td = tr[i].getElementsByTagName("td")[column === 'clinic' ? 3 : 2];
                if (td) {
                    const txtValue = td.textContent || td.innerText;
                    tr[i].style.display = txtValue === filterValue || filterValue === "" ? "" : "none";
                }
            }
        }

        function searchTable(tableId, searchValue) {
            searchValue = searchValue.toLowerCase();
            const table = document.getElementById(tableId);
            const tr = table.getElementsByTagName("tr");
            for (let i = 1; i < tr.length; i++) {
                const tds = tr[i].getElementsByTagName("td");
                let match = false;
                for (let j = 0; j < tds.length; j++) {
                    const td = tds[j];
                    if (td) {
                        const txtValue = td.textContent || td.innerText;
                        if (txtValue.toLowerCase().indexOf(searchValue) > -1) {
                            match = true;
                            break;
                        }
                    }
                }
                tr[i].style.display = match || searchValue === "" ? "" : "none";
            }
        }

        // Funções para confirmação de exclusão
        function confirmDelete(email) {
            if(confirm('Tem certeza que deseja remover este profissional?')) {
                // Implementar a lógica de remoção
                alert('Profissional removido com sucesso.');
            }
        }

        function confirmDeleteInvite(code) {
            if(confirm('Tem certeza que deseja excluir este convite?')) {
                // Implementar a lógica de exclusão
                alert('Convite excluído com sucesso.');
            }
        }

        function encerrarConvite(name) {
            if(confirm('Tem certeza que deseja encerrar este convite?')) {
                // Implementar a lógica de encerramento
                alert('Convite de ' + name + ' encerrado.');
            }
        }

        // Função para copiar código
        function copyCode(code) {
            navigator.clipboard.writeText(code).then(() => {
                alert('Código copiado: ' + code);
            }).catch(err => {
                alert('Erro ao copiar o código');
            });
        }

        // Modal
        const modal = document.getElementById('inviteModal');
        const openModalBtn = document.getElementById('openModalBtn');
        const closeModalBtn = document.getElementsByClassName('close')[0];

        openModalBtn.onclick = function() {
            modal.style.display = 'block';
        }
        closeModalBtn.onclick = function() {
            modal.style.display = 'none';
            resetInviteModal();
        }
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = 'none';
                resetInviteModal();
            }
        }

        function handleInviteForm(event) {
            event.preventDefault();
            const name = document.getElementById('inviteName').value;
            const email = document.getElementById('inviteEmail').value;
            const clinic = document.getElementById('inviteClinic').value;

            const code = generateInviteCode();
            document.getElementById('inviteCode').textContent = code;
            document.getElementById('inviteCodeSection').style.display = 'block';
            document.getElementById('inviteForm').style.display = 'none';
        }

        function handlePartnerInvite(event) {
            event.preventDefault();
            const codeInput = document.getElementById('partnerInviteCodeInput').value.toUpperCase();
            // Implementar a lógica para verificar o código
            // Simulação:
            if(codeInput === 'ABC123') {
                document.getElementById('parceirasClinicName').textContent = 'Clínica Sertãozinho';
                document.getElementById('parceirasInviterName').textContent = 'Ana Silva';
                document.getElementById('parceirasInviteDetails').style.display = 'block';
            } else {
                alert('Convite não encontrado ou já processado.');
                document.getElementById('parceirasInviteDetails').style.display = 'none';
            }
        }

        function generateInviteCode() {
            return Math.random().toString(36).substring(2,8).toUpperCase();
        }

        function copyInviteCode() {
            const code = document.getElementById('inviteCode').textContent;
            navigator.clipboard.writeText(code).then(() => {
                alert('Código copiado: ' + code);
            }).catch(err => {
                alert('Erro ao copiar o código');
            });
        }

        function resetInviteModal() {
            document.getElementById('inviteForm').style.display = 'block';
            document.getElementById('inviteCodeSection').style.display = 'none';
            document.getElementById('inviteForm').reset();
        }

        // Atualizar o botão de copiar no modal
        document.getElementById('copyInviteCodeBtn').onclick = copyInviteCode;

        // Funcionalidade de aceitar e recusar convites de parceria
        document.getElementById('parceirasAcceptButton').addEventListener('click', function() {
            alert('Convite aceito com sucesso!');
            document.getElementById('parceirasInviteDetails').style.display = 'none';
            document.getElementById('acceptPartnerInviteForm').reset();
        });

        document.getElementById('parceirasDeclineButton').addEventListener('click', function() {
            alert('Convite recusado.');
            document.getElementById('parceirasInviteDetails').style.display = 'none';
            document.getElementById('acceptPartnerInviteForm').reset();
        });

        // Função para alternar abas com CSS
        document.querySelectorAll('.tab').forEach(tab => {
            tab.addEventListener('click', function() {
                document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(tc => tc.classList.remove('active'));

                this.classList.add('active');
                document.getElementById(this.getAttribute('data-tab')).classList.add('active');
            });
        });
    </script>
</body>
</html>
