<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Perfil - Sistema de Avaliação IFCora</title>
    <!-- Fonte personalizada e Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <link rel="stylesheet" href="css/styles.css">
    <!-- Estilos CSS -->

</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos">
            <h2>Sistema de Avaliação - IFCora</h2>
        </div>
        <nav class="user-menu">
            <a href="#" title="Notificações"><i class="fas fa-bell"></i></a>
            <a href="#" title="Configurações"><i class="fas fa-cog"></i></a>
            <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>
        </nav>
    </header>
    <!-- Sidebar -->
    <?php include 'includes/sidebar-painel-profissional-perfil.php'; ?>
    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1 style="margin-top: -20px; margin-bottom: -10px; color: #08C89E" >Gerenciar Perfil</h1>
        </div>
        <!-- Formulário de Perfil -->
        <div class="profile-form">
            <h2 style="text-align: left">Atualize suas informações</h2>
            <form id="profileForm">
                <!-- Primeira Coluna: Dados Pessoais com Avatar -->
                <div class="column">
                    <h3>Dados Pessoais</h3>
                    <div class="avatar-wrapper">
                        <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                        <label class="upload-button" for="upload-photo" aria-label="Upload de Foto">
                            <i class="fas fa-camera"></i>
                            <input type="file" id="upload-photo" accept="image/*" aria-hidden="true">
                        </label>
                    </div>
                    <div class="form-group">
                        <label for="profileName">Nome Completo</label>
                        <input type="text" id="profileName" name="profileName" value="Coralina Matos" required>
                    </div>
                    <div class="form-group">
                        <label for="profileProfession">Profissão</label>
                        <input type="text" id="profileProfession" name="profileProfession" value="Terapeuta Ocupacional">
                    </div>
                    <div class="form-group">
                        <label for="profileRegistration">Registro Profissional</label>
                        <input type="text" id="profileRegistration" name="profileRegistration" value="CREFITO: 12.132-TO">
                    </div>
                    
                    <div class="form-group">
                        <label for="profileEmail">Email</label>
                        <input type="email" id="profileEmail" name="profileEmail" value="coralina.matos@example.com" readonly>
                    </div>
                    <div class="form-group">
                        <label for="profilePhone">Telefone</label>
                        <input type="tel" id="profilePhone" name="profilePhone" value="(99) 99999-9999">
                    </div>
                    
                    <button type="button" class="btn save" id="savePersonalInfo">Salvar Informações</button>
                </div>
                <!-- Segunda Coluna: Contato com Endereço -->
                <div class="column">
                    <h3>Endereço</h3>
                    
                    <!-- Campos de Endereço -->
                    <div class="form-group">
                        <label for="profileStreet">Endereço</label>
                        <input type="text" id="profileStreet" name="profileStreet" placeholder="Rua Exemplo" required>
                    </div>
                    <div class="form-group">
                        <label for="profileNumber">Número</label>
                        <input type="text" id="profileNumber" name="profileNumber" placeholder="123" required>
                    </div>
                    <div class="form-group">
                        <label for="profileComplement">Complemento</label>
                        <input type="text" id="profileComplement" name="profileComplement" placeholder="Apto 45">
                    </div>
                    <div class="form-group">
                        <label for="profileNeighborhood">Bairro</label>
                        <input type="text" id="profileNeighborhood" name="profileNeighborhood" placeholder="Bairro Exemplo" required>
                    </div>
                    <div class="form-group">
                        <label for="profileCity">Cidade</label>
                        <input type="text" id="profileCity" name="profileCity" placeholder="Cidade Exemplo" required>
                    </div>
                    <div class="form-group">
                        <label for="profileState">Estado</label>
                        <select id="profileState" name="profileState" required>
                            <option value="">Selecione</option>
                            <option value="AC">Acre (AC)</option>
                            <option value="AL">Alagoas (AL)</option>
                            <option value="AP">Amapá (AP)</option>
                            <option value="AM">Amazonas (AM)</option>
                            <option value="BA">Bahia (BA)</option>
                            <option value="CE">Ceará (CE)</option>
                            <option value="DF">Distrito Federal (DF)</option>
                            <option value="ES">Espírito Santo (ES)</option>
                            <option value="GO">Goiás (GO)</option>
                            <option value="MA">Maranhão (MA)</option>
                            <option value="MT">Mato Grosso (MT)</option>
                            <option value="MS">Mato Grosso do Sul (MS)</option>
                            <option value="MG">Minas Gerais (MG)</option>
                            <option value="PA">Pará (PA)</option>
                            <option value="PB">Paraíba (PB)</option>
                            <option value="PR">Paraná (PR)</option>
                            <option value="PE">Pernambuco (PE)</option>
                            <option value="PI">Piauí (PI)</option>
                            <option value="RJ">Rio de Janeiro (RJ)</option>
                            <option value="RN">Rio Grande do Norte (RN)</option>
                            <option value="RS">Rio Grande do Sul (RS)</option>
                            <option value="RO">Rondônia (RO)</option>
                            <option value="RR">Roraima (RR)</option>
                            <option value="SC">Santa Catarina (SC)</option>
                            <option value="SP">São Paulo (SP)</option>
                            <option value="SE">Sergipe (SE)</option>
                            <option value="TO">Tocantins (TO)</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="profileCEP">CEP</label>
                        <input type="text" id="profileCEP" name="profileCEP" placeholder="12345-678" required>
                    </div>
                    <button type="button" class="btn save" id="saveContactInfo">Salvar Endereço</button>
                </div>
                <!-- Terceira Coluna: Alterar Senha -->
                <div class="column">
                    <h3>Alterar Senha</h3>
                    <div class="form-group">
                        <label for="currentPassword">Senha Atual</label>
                        <input type="password" id="currentPassword" name="currentPassword" required>
                    </div>
                    <div class="form-group">
                        <label for="newPassword">Nova Senha</label>
                        <input type="password" id="newPassword" name="newPassword" required>
                    </div>
                    <div class="form-group">
                        <label for="confirmPassword">Repetir Nova Senha</label>
                        <input type="password" id="confirmPassword" name="confirmPassword" required>
                    </div>
                    <button type="submit" class="btn save">Salvar Senha</button>
                </div>
            </form>
        </div>
    </main>
    <!-- Scripts -->
    <script>
        // Evento para salvar informações pessoais
        document.getElementById('savePersonalInfo').addEventListener('click', function() {
            // Aqui você pode adicionar a lógica para salvar as informações pessoais no servidor
            alert('Informações pessoais salvas com sucesso!');
        });

        // Evento para salvar informações de contato
        document.getElementById('saveContactInfo').addEventListener('click', function() {
            // Aqui você pode adicionar a lógica para salvar as informações de contato e endereço no servidor
            alert('Informações de contato e endereço salvas com sucesso!');
        });

        // Evento para o formulário de senha
        document.getElementById('profileForm').addEventListener('submit', function(event) {
            event.preventDefault();
            // Validação básica para verificar se as senhas coincidem
            const currentPassword = document.getElementById('currentPassword').value;
            const newPassword = document.getElementById('newPassword').value;
            const confirmPassword = document.getElementById('confirmPassword').value;

            if (newPassword !== confirmPassword) {
                alert('As novas senhas não coincidem. Por favor, verifique.');
                return;
            }

            if (newPassword.length < 6) {
                alert('A nova senha deve ter pelo menos 6 caracteres.');
                return;
            }

            // Aqui você pode adicionar a lógica para alterar a senha no servidor
            alert('Senha alterada com sucesso!');
            // Opcional: limpar os campos de senha
            document.getElementById('currentPassword').value = '';
            document.getElementById('newPassword').value = '';
            document.getElementById('confirmPassword').value = '';
        });

        // Pré-visualização da foto de perfil
        const uploadPhotoInput = document.getElementById('upload-photo');
        const avatarImage = document.getElementById('avatar');

        uploadPhotoInput.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    avatarImage.src = e.target.result;
                }
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>
</html>
