<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    
    <meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate, post-check=0, pre-check=0">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"> -->
    <link rel="stylesheet" href="css/global_v4.css">
    <link rel="stylesheet" href="css/header_v4.css">
    <link rel="stylesheet" href="css/sidebar_v4.css">
    
    <style>
/* Container Principal da Seção de Parcerias */
        .partnership-management {
            background-color: #FFFFFF;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        /* Contêiner Flex para as Sub-seções */
        .partnership-container {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            align-items: flex-start; /* Alinha as sub-seções ao topo */
        }

        /* Sub-seção: Criar Nova Clínica */
        .create-clinic {
            flex: 1 1 200px; 
            background-color: #F9FAFB;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 100px;
        }

        /* Sub-seção: Aceitar Convite de Parceria */
        .accept-invite {
            flex: 3 1 600px; 
            background-color: #F9FAFB;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 100px;
        }

        .partnership-item h2 {
            font-size: 18px;
            color: #08C89E;
            margin-bottom: -10px;
            margin-top: -10px;
        }

        .partnership-item p {
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 20px;
            flex-grow: 1;
            margin-bottom: -5px;
        }
        
        
        
        /* Cards */
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 20px;
        }

        .card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            padding: 20px;
            display: flex;
            flex-direction: column;
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }
        .partner-clinic {
            border: 2px solid #08C89E; /* Borda verde para diferenciar */
            box-shadow: 0 4px 12px rgba(8, 200, 158, 0.2); /* Sombra leve */
            position: relative;
        }

        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .card-header .icon {
            font-size: 40px;
            color: #F6AD55;
            margin-right: 15px;
        }

        .card-header h3 {
            font-size: 22px;
            color: #08C89E;
            margin: 0;
        }

        .partner-badge {
            position: absolute;
            top: -10px;
            right: -10px;
            background-color: #08C89E;
            color: white;
            font-size: 12px;
            font-weight: bold;
            padding: 5px 10px;
            border-radius: 20px;
            text-transform: uppercase;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }

        .card-content p {
            margin: 5px 0;
            font-size: 15px;
            color: #4a5568;
             margin-top: -10px;
        }

        .card-content p b {
            color: #2d3748;
           
        }

        .card-footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 20px;
        }
        
        /* Formulário de Aceitação de Convite */
        .accept-invite .invite-form {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        .accept-invite .form-group {
            display: flex;
            flex-direction: column;
            gap: 5px;
            flex: 1;
            min-width: 150px;
        }

        .accept-invite .form-group label {
            font-size: 14px;
            color: #2d3748;
            font-weight: 600;
        }
    
    </style>

<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-clinicas.php'; ?>
    
    <main>
        <div class="content">
            <div class="header-content">
                <h1 style="color: #08C89E; margin-left: 20px">Gerenciar Clínicas Ativas</h1>
            </div>
           

            <!-- Seção de Gerenciamento de Parcerias -->
            <section class="partnership-management">
                <div class="partnership-container">
                    <!-- Sub-seção: Criar Nova Clínica -->
                    <div class="partnership-item create-clinic">
                        <h2>Cadastre Sua Clínica</h2>
                        <p style="margin-bottom: 10px">Cadastre sua clínica para começar a usar o sistema.</p>
                        <button class="btn add-new" id="openCreateClinicModal">
                            <i class="fas fa-plus"></i>Cadastrar Nova Clínica</button>
                    </div>

                    <!-- Sub-seção: Aceitar Convite de Parceria -->
                    <div class="partnership-item accept-invite">
                        <h2>Aceitar Convite Para Parceria</h2>
                        <p style="margin-bottom: 5px">Inserir código de convite para se tornar parceiro de uma clínica existente.</p>
                        
                        <form id="acceptPartnerInviteForm" class="invite-form" aria-labelledby="inviteTitle">
                            <div class="form-group">
                                <label for="partnerInviteCodeInput">Digite o código de convite:</label>
                                <input type="text" id="partnerInviteCodeInput" name="partnerInviteCodeInput" 
                                    required placeholder="Ex: ABC123" aria-required="true">
                            </div>
                            <button type="submit" class="btn add-new">
                                <i class="fas fa-upload"></i> Carregar Convite
                            </button>
                        </form>

                        <div id="parceirasInviteDetails" class="invite-details" aria-live="polite">
                            <p><strong>Convite encontrado:</strong></p>
                            <hr class="invite-divider" />
                            <p><strong>Convite para a clínica:</strong> <span id="parceirasClinicName"></span></p>
                            <p><strong>Convite enviado por:</strong> <span id="parceirasInviterName"></span></p>
                            <p><strong>Perfil atribuído:</strong> <span id="parceirasInviterPerfil"></span></p>
                            
                            <div class="parceiras-action-buttons">
                                <button class="btn save" id="parceirasAcceptButton">Confirmar Convite</button>
                                <button class="btn decline" id="parceirasDeclineButton">Cancelar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <div class="cards">
                <!-- Card de Clínica -->
                <div class="card">
                    <div>
                        <div class="card-header">
                            <span class="icon"><i class="fas fa-hospital"></i></span>
                            <h3>Clínica Sertãozinho</h3>
                        </div>
                        <div class="card-content">
                            
                            <p><b>Plano:</b> Plano Básico <span style="color: #08C89E;">(Ativo)</span></p>
                            <p><b>Crianças cadastradas:</b> 20/10</p>
                            <p style="margin-top: 0px; margin-bottom: 10px"><hr /></p>
                        </div>
                        <div class="card-footer">
                            <button onclick="window.location.href='painel-p-clinca-gerenciar.php'" class="btn edit manage-button">
                                <i class="fas fa-edit"></i> Gerenciar Clínica
                            </button>
                            <button onclick="window.location.href='painel-clinica-crianças.php'" class="btn link access-button"><i class="fas fa-arrow-right"></i>Acessar</button>
                        </div>
                    </div>
                </div>

                <!-- Outro Card -->
                <div class="card partner-clinic">
                    <div>
                        <div class="card-header">
                            <span class="icon"><i class="fas fa-hospital"></i></span>
                            <h3>Clínica Central</h3>
                            <span class="partner-badge">Parceira</span>
                        </div>
                        <div class="card-content">
                            <p><b>Plano:</b> Enterprise Gold <span style="color: #F6AD55;">(Suspenso)</span></p>
                            <p><b>Crianças cadastradas:</b> 120/200</p>
                            <p style="margin-top: 0px; margin-bottom: 10px"><hr /></p>
                        </div>
                        <div class="card-footer">
                            <button onclick="window.location.href='painel-clinica-crianças.php'" class="btn link access-button"><i class="fas fa-arrow-right"></i>Acessar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    
    <script>
        
    </script>
</body>
</html>