<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <!-- Fonte personalizada e Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f7fafc;
            color: #2d3748;
            margin: 0;
            padding: 0;
        }
        a {
            text-decoration: none;
            color: inherit;
        }

        /* Header */
        .header {
            background-color: #fff;
            height: 60px;
            width: 100%;
            position: fixed;
            top: 0;
            border-bottom: 1px solid #e2e8f0;
            z-index: 100;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
        }
        .header .logo {
            display: flex;
            align-items: center;
        }
        .header .logo img {
            height: 40px;
            margin-right: 10px;
        }
        .header .logo h2 {
            font-size: 20px;
            color: #2d3748;
        }
        .header .user-menu a {
            font-size: 18px;
            margin-left: 20px;
            color: #2d3748;
        }

        /* Sidebar */
        .sidebar {
            width: 240px;
            height: calc(100vh - 60px);
            background-color: #fff;
            border-right: 1px solid #e2e8f0;
            position: fixed;
            top: 60px;
            left: 0;
            padding: 2rem 1rem;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .sidebar .profile {
            text-align: center;
            margin-bottom: 2rem;
        }
        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            border: 3px solid #08C89E;
        }
        .sidebar h3 {
            margin-top: 10px;
            font-size: 18px;
            color: #2d3748;
        }
        .sidebar small {
            background-color: #08C89E;
            color: #fff;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            display:inline-block;
            margin-top:5px;
        }
        .sidebar .menu {
            margin-top:30px;
        }
        .sidebar .menu a {
            font-size:16px;
            display:flex;
            align-items:center;
            padding:12px 20px;
            border-radius:8px;
            transition: background 0.3s;
            color:#2d3748;
            margin-bottom:10px;
        }
        .sidebar .menu a:hover {
            background-color:#f1f5f9;
        }
        .sidebar .menu a.active {
            background-color:#e6fffa;
            color:#08C89E;
            font-weight:600;
        }
        .sidebar .menu a i {
            margin-right:15px;
            font-size:18px;
        }
        .logout {
            margin-top:auto;
        }
        .logout a {
            font-size:16px;
            display:flex;
            align-items:center;
            padding:12px 20px;
            border-radius:8px;
            transition:background 0.3s;
            color:#e53e3e;
        }
        .logout a:hover {
            background-color:#ffe5e5;
        }
        .logout a i {
            margin-right:15px;
            font-size:18px;
        }

        /* Conteúdo */
        .content {
            margin-top:80px;
            margin-left:260px;
            padding:20px 30px;
        }

        .header-content {
            margin-bottom:20px;
        }
        .header-content h1 {
            font-size:28px;
            color:#2d3748;
            margin-bottom:5px;
            margin-top: -20px;
        }

        /* Abas Internas */
        .tabs-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom:20px;
        }
        .tabs {
            display:flex;
            border-bottom:1px solid #e2e8f0;
            margin-bottom:20px;
        }
        .tab {
            padding:10px 20px;
            cursor:pointer;
            font-size:16px;
            color:#2d3748;
            background-color:#f7fafc;
            border-top-left-radius:6px;
            border-top-right-radius:6px;
            margin-right:5px;
            display: flex;
            align-items: center; /* Alinha ícones e texto verticalmente */
            transition: background-color 0.3s, color 0.3s;
        }
        .tab i {
            margin-right:10px; /* Espaço entre ícone e texto */
            font-size:18px;
        }
        .tab.active {
            background-color:#08C89E;
            color:#fff;
            font-weight:600;
            border-bottom:2px solid #08C89E;
        }

        .tab-content {
            display:none;
        }
        .tab-content.active {
            display:block;
        }

        /* Seção Resumo (tokens-summary equivalente) */
        .summary-section {
            background-color: #f1f5f9;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            margin-bottom:20px;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        .summary-section h2 {
            font-size:20px;
            color:#2d3748;
            margin-bottom:10px;
        }

        /* Tabelas internas */
        table {
            width:100%;
            border-collapse:collapse;
            margin-top:10px;
        }
        th, td {
            text-align:left;
            padding:10px;
            border-bottom:1px solid #e2e8f0;
            font-size:16px;
        }
        th {
            background-color:#f7fafc;
            color:#2d3748;
        }

        /* Campos */
        .filters {
            display:flex;
            align-items:center;
            gap:20px;
            flex-wrap:wrap;
            margin-bottom:20px;
        }
        .filters label {
            font-size:14px;
            font-weight:600;
            display:block;
            margin-bottom:5px;
        }
        .filters select, .filters input {
            padding:8px 12px;
            border:1px solid #e2e8f0;
            border-radius:8px;
            font-size:14px;
        }

        .btn {
            padding:8px 16px;
            border:none;
            border-radius:8px;
            cursor:pointer;
            font-size:14px;
            transition:background 0.3s;
            display: flex;
            align-items: center;
        }
        .btn.create-invite {
            background-color:#08C89E;
            color:#fff;
            padding:10px 16px;
        }
        .btn.create-invite i {
            margin-right:5px;
        }
        .btn.create-invite:hover {
            background-color:#06b287;
        }

        .btn.copy {
            background-color:#F6AD55;
            color:#fff;
        }
        .btn.copy i {
            margin-right:5px;
        }
        .btn.copy:hover {
            background-color:#dd6b20;
        }
        .btn.accept {
            background-color:#08C89E;
            color:#fff;
        }
        .btn.accept i {
            margin-right:5px;
        }
        .btn.accept:hover {
            background-color:#06b287;
        }
        .btn.decline {
            background-color:#e53e3e;
            color:#fff;
        }
        .btn.decline i {
            margin-right:5px;
        }
        .btn.decline:hover {
            background-color:#c53030;
        }

        /* Modal */
        .modal {
            display:none;
            position:fixed;
            z-index:200;
            top:0;
            left:0;
            width:100%;
            height:100%;
            overflow-y:auto;
            background-color:rgba(0,0,0,0.5);
        }
        .modal-content {
            background-color:#fff;
            margin:5% auto;
            padding:20px;
            border-radius:12px;
            width:80%;
            max-width:600px;
            position:relative;
            animation:fadeIn 0.3s ease-in-out;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        }
        .modal-content h2 {
            font-size:24px;
            margin-bottom:15px;
            color:#08C89E;
        }
        .modal-content label {
            display:block;
            margin:10px 0 5px;
            font-size:14px;
            color:#4a5568;
        }
        .modal-content input,
        .modal-content select {
            width:100%;
            padding:10px;
            margin-bottom:15px;
            border:1px solid #e2e8f0;
            border-radius:8px;
            font-size:14px;
            box-sizing:border-box;
        }
        .modal-content button {
            width:100%;
            padding:10px 15px;
            border:none;
            border-radius:8px;
            font-size:14px;
            cursor:pointer;
            background-color:#08C89E;
            color:#fff;
            transition:background 0.3s ease-in-out;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .modal-content button i {
            margin-right:5px;
        }
        .modal-content button:hover {
            background-color:#06b287;
        }
        .close {
            color:#aaa;
            position:absolute;
            right:20px;
            top:15px;
            font-size:28px;
            font-weight:bold;
            cursor:pointer;
        }
        .close:hover {
            color:black;
        }
        @keyframes fadeIn {
            from { opacity:0; transform:translateY(-10%); }
            to { opacity:1; transform:translateY(0); }
        }

        @media (max-width:768px) {
            .sidebar {
                width:100%;
                height:auto;
                position:relative;
                padding:10px 20px;
                top:60px;
                flex-direction:row;
                justify-content:space-between;
                align-items:center;
            }
            .sidebar .profile {
                display:none;
            }
            .sidebar .menu {
                flex-direction:row;
                margin-top:0;
            }
            .sidebar .menu a {
                font-size:14px;
                padding:10px;
                margin-bottom:0;
            }
            .sidebar .menu a i {
                margin-right:5px;
            }
            .header {
                justify-content:space-between;
            }
            .header .logo h2 {
                font-size:18px;
            }
            .content {
                margin-left:0;
                margin-top:80px;
            }
            .tabs {
                flex-direction: column;
            }
            .tab {
                margin-right:0;
                margin-bottom:5px;
            }
            .tab.active {
                border-bottom: none;
                border-left:2px solid #08C89E;
            }
            .summary-section {
                flex-direction: column;
            }
        }

        /* Botão Excluir */
        .btn.delete {
            background-color: #e53e3e;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
        }
        .btn.delete:hover {
            background-color: #c53030;
        }
        .btn.delete i {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="logo">
            <img src="includes/logo.webp" alt="Logo Sistema Coralina Matos">
            <h2>Sistema de Avaliação - IFCora</h2>
        </div>
        <nav class="user-menu">
            <a href="#" title="Notificações"><i class="fas fa-bell"></i></a>
            <a href="#" title="Configurações"><i class="fas fa-cog"></i></a>
            <a href="#" title="Suporte"><i class="fas fa-headset"></i></a>
        </nav>
    </header>
    <!-- Sidebar -->
    <?php include 'includes/sidebar-painel-profissional.php'; ?>
    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1 style="color: #08C89E">Profissionais</h1>
        </div>

        <!-- Seção das Abas -->
        <div class="tabs-container">
            <div class="tabs">
                <div class="tab active" data-tab="profissionais-tab">
                    <i class="fas fa-user-md"></i> Profissionais
                </div>
                <div class="tab" data-tab="convites-tab">
                    <i class="fas fa-envelope"></i> Convites
                </div>
                <div class="tab" data-tab="parceiras-tab">
                    <i class="fas fa-handshake"></i> Parcerias
                </div>
            </div>

            <!-- Aba Profissionais -->
            <div id="profissionais-tab" class="tab-content active">
                <h2 style="color: #08C89E">Gerenciamento de Profissionais</h2>
                <p style="margin-top: -30px"><small>Gerencie os profissionais atribuídos às suas clínicas.</small></p>
                <hr />

                <div class="filters">
                    <div>
                        <label for="clinicSelect">Selecione a Clínica</label>
                        <select id="clinicSelect">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchProfessional">Pesquisar Profissional</label>
                        <input type="text" id="searchProfessional" placeholder="Nome, Profissão ou Email do profissional...">
                    </div>
                </div>
                <table id="professionalsTable">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Profissão</th>
                            <th>Email</th>
                            <th>Clínica</th>
                            <th>Ações</th>
                            <th>Excluir</th> <!-- Nova Coluna para Excluir -->
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Profissionais via JS -->
                    </tbody>
                </table>
            </div>

            <!-- Aba Convites -->
            <div id="convites-tab" class="tab-content">
                <h2 style="color: #08C89E">Gerenciamento de Convites</h2>
                
                <p style="margin-top: -30px"><small>Crie e gerencie convites para outros profissionais participarem das suas clínicas.</small></p>
                
                <!-- Botão Criar acima dos filtros -->
                <button class="btn create-invite" id="openModalBtn" style="margin-bottom: 10px;">
                    <i class="fas fa-plus"></i> Criar Novo Convite
                </button>
                <hr />
                
                <div class="filters">
                    <div>
                        <label for="clinicFilterConvites">Selecione a Clínica</label>
                        <select id="clinicFilterConvites">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchConviteName">Pesquisar por Nome</label>
                        <input type="text" id="searchConviteName" placeholder="Nome do convidado...">
                    </div>
                </div>
                
                <table id="pendingInvitesTable">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Email</th>
                            <th>Clínica</th>
                            <th>Código</th>
                            <th>Status</th>
                            <th>Ações</th>
                            <th>Excluir</th> <!-- Nova Coluna para Excluir -->
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Pendentes via JS -->
                    </tbody>
                </table>
            </div>

            <!-- Aba Parcerias -->
            <div id="parceiras-tab" class="tab-content">
                <h2 style="color: #08C89E">gerenciamento de Parcerias</h2>
                <p style="margin-top: -30px"><small>Carregue um código de convite para participar de outras clínicas como convidado.</small></p>

                
                <div class="summary-section">
                
                <form id="acceptPartnerInviteForm" style="display: flex; align-items: center; gap: 10px;">
                    <label for="partnerInviteCodeInput">Código de Convite:</label>
                    <input 
                        type="text" 
                        id="partnerInviteCodeInput" 
                        required 
                        style="
                            width: 150px; 
                            padding: 8px 16px; 
                            border: 2px solid #08C89E; 
                            border-radius: 8px; 
                            font-size: 16px;" 
                        placeholder="ABC123">
                    <button 
                        type="submit" 
                        class="btn create-invite" 
                        style="
                            padding: 8px 16px; 
                            border: none; 
                            border-radius: 8px; 
                            background-color: #08C89E; 
                            color: white; 
                            font-size: 16px; 
                            cursor: pointer;">
                        Carregar Convite
                    </button>
                </form>

                <div id="parceirasInviteDetails" style="display: none;">
                    <p>Convite para a clínica: <strong id="parceirasClinicName"></strong></p>
                    <p>Convidado por: <strong id="parceirasInviterName"></strong></p>
                    <div style="display: flex; align-items: center; margin-top: 10px;">
                        <button class="btn accept" id="parceirasAcceptButton" style="
                            padding: 8px 16px; 
                            border: none; 
                            border-radius: 8px; 
                            background-color: #08C89E; 
                            color: white; 
                            font-size: 16px; 
                            cursor: pointer;">
                            <i class="fas fa-thumbs-up"></i> Aceitar
                        </button>
                        <button class="btn decline" id="parceirasDeclineButton" style="
                            padding: 8px 16px; 
                            border: none; 
                            border-radius: 8px; 
                            background-color: #E74C3C; 
                            color: white; 
                            font-size: 16px; 
                            cursor: pointer; 
                            margin-left: 10px;">
                            <i class="fas fa-thumbs-down"></i> Recusar
                        </button>
                    </div>
                </div>
                
                
                
                
                </div>
                <hr />

                <!-- Seção Histórico de Convites -->
                <div class="section">
                    
                    <div class="filters">
                        <div>
                            <label for="clinicFilterParceirasHistory">Selecione a Clínica</label>
                            <select id="clinicFilterParceirasHistory">
                                <option value="">Todas</option>
                                <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                                <option value="Clínica Central">Clínica Central</option>
                                <option value="Clínica do Norte">Clínica do Norte</option>
                            </select>
                        </div>
                        <div>
                            <label for="searchParceirasHistoryName">Pesquisar por Nome</label>
                            <input type="text" id="searchParceirasHistoryName" placeholder="Nome...">
                        </div>
                    </div>
                    <table id="inviteHistoryTable">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Clínica</th>
                                <th>Status</th>
                                <th>Data</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Histórico via JS -->
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

    </main>

    <!-- Modal Criar Convite -->
    <div id="inviteModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Criar Novo Convite</h2>
            <form id="inviteForm">
                <label for="inviteName">Nome do Profissional</label>
                <input type="text" id="inviteName" name="inviteName" required>
                <label for="inviteEmail">Email do Profissional</label>
                <input type="email" id="inviteEmail" name="inviteEmail" required>
                <label for="inviteClinic">Clínica</label>
                <select id="inviteClinic" name="inviteClinic" required>
                    <option value="">Selecione uma clínica</option>
                    <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                    <option value="Clínica Central">Clínica Central</option>
                    <option value="Clínica do Norte">Clínica do Norte</option>
                </select>
                <button type="submit" class="btn create-invite">
                    <i class="fas fa-paper-plane"></i> Gerar Convite
                </button>
            </form>
            <div id="inviteCodeSection" style="display: none; text-align: center; margin-top: 20px;">
                <p>O código de convite é:</p>
                <h3 id="inviteCode"></h3>
                <button class="btn copy" id="copyInviteCodeBtn">
                    <i class="fas fa-copy"></i> Copiar Código
                </button>
                <p>Envie este código para o profissional convidado.</p>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Seleção de abas
            const tabs = document.querySelectorAll('.tab');
            const tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    tabs.forEach(t => t.classList.remove('active'));
                    tabContents.forEach(c => c.classList.remove('active'));

                    tab.classList.add('active');
                    document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
                });
            });

            // Dados exemplo
            let professionals = [
                { name: 'Mariana Santos', profession: 'Fonoaudióloga', email: 'mariana.santos@example.com', clinic: 'Clínica Sertãozinho' },
                { name: 'Pedro Oliveira', profession: 'Psicólogo', email: 'pedro.oliveira@example.com', clinic: 'Clínica Central' },
                { name: 'Camila Rocha', profession: 'Nutricionista', email: 'camila.rocha@example.com', clinic: 'Clínica Sertãozinho' },
                { name: 'Beatriz Souza', profession: 'Terapeuta Ocupacional', email: 'beatriz.souza@example.com', clinic: 'Clínica Central' },
                { name: 'Felipe Costa', profession: 'Fisioterapeuta', email: 'felipe.costa@example.com', clinic: 'Clínica do Norte' },
                { name: 'Juliana Lima', profession: 'Enfermeira', email: 'juliana.lima@example.com', clinic: 'Clínica Sertãozinho' },
                { name: 'Ricardo Pinto', profession: 'Nutricionista', email: 'ricardo.pinto@example.com', clinic: 'Clínica Central' },
                { name: 'Gustavo Ribeiro', profession: 'Terapeuta Ocupacional', email: 'gustavo.ribeiro@example.com', clinic: 'Clínica do Norte' },
            ];

            let pendingInvites = [
                { name: 'Ana Silva', email: 'ana.silva@example.com', clinic: 'Clínica Sertãozinho', code: 'ABC123', status: 'Pendente' },
                { name: 'Bruno Lima', email: 'bruno.lima@example.com', clinic: 'Clínica Central', code: 'DEF456', status: 'Pendente' },
                { name: 'Carla Mendes', email: 'carla.mendes@example.com', clinic: 'Clínica do Norte', code: 'GHI789', status: 'Expirado' }
            ];

            let inviteHistory = [
    { name: 'Carlos Souza', email: 'carlos.souza@example.com', clinic: 'Clínica Sertãozinho', status: 'Aceito', date: '01/10/2023' },
    { name: 'Daniela Pereira', email: 'daniela.pereira@example.com', clinic: 'Clínica Central', status: 'Recusado', date: '15/09/2023' },
    { name: 'Eduardo Martins', email: 'eduardo.martins@example.com', clinic: 'Clínica do Norte', status: 'Aceito', date: '20/10/2023' },
    { name: 'Fernanda Costa', email: 'fernanda.costa@example.com', clinic: 'Clínica Central', status: 'Encerrado', date: '25/10/2023' },
    { name: 'Gabriel Silva', email: 'gabriel.silva@example.com', clinic: 'Clínica Sertãozinho', status: 'Recusado', date: '30/09/2023' },
    { name: 'Helena Rocha', email: 'helena.rocha@example.com', clinic: 'Clínica do Norte', status: 'Aceito', date: '05/11/2023' },
];


            // Profissionais
            function updateProfessionalsTable() {
                const clinicFilter = document.getElementById('clinicSelect').value;
                const searchFilter = document.getElementById('searchProfessional').value.toLowerCase();
                const tableBody = document.querySelector('#professionalsTable tbody');
                tableBody.innerHTML = '';

                const filtered = professionals.filter(prof => {
                    const matchClinic = !clinicFilter || prof.clinic === clinicFilter;
                    const matchSearch = prof.name.toLowerCase().includes(searchFilter) ||
                                        prof.profession.toLowerCase().includes(searchFilter) ||
                                        prof.email.toLowerCase().includes(searchFilter);
                    return matchClinic && matchSearch;
                });

                filtered.forEach(prof => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${prof.name}</td>
                        <td>${prof.profession}</td>
                        <td>${prof.email}</td>
                        <td>${prof.clinic}</td>
                        <td><a href="#" class="btn copy" onclick="removeProfessional('${prof.email}')"><i class="fas fa-unlock"></i></i> Desvincular</a></td>
                        <td>
                            <button class="btn " onclick="deleteProfessional('${prof.email}')" style="background: transparent; border: none; cursor: pointer; color: red">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            document.getElementById('clinicSelect').addEventListener('change', updateProfessionalsTable);
            document.getElementById('searchProfessional').addEventListener('input', updateProfessionalsTable);
            updateProfessionalsTable();

            // Função para remover profissional
            window.removeProfessional = function(email) {
                if(confirm('Tem certeza que deseja remover este profissional?')) {
                    professionals = professionals.filter(prof => prof.email !== email);
                    updateProfessionalsTable();
                    alert('Profissional removido com sucesso.');
                }
            }

            // Função para deletar profissional via botão de lixeira
            window.deleteProfessional = function(email) {
                if(confirm('Tem certeza que deseja remover este profissional?')) {
                    professionals = professionals.filter(prof => prof.email !== email);
                    updateProfessionalsTable();
                    alert('Profissional removido com sucesso.');
                }
            }

            // Função cor de status
            function getStatusColor(status) {
                if (status === 'Pendente') return '#08C89E';
                if (status === 'Aceito') return '#4A5568';
                if (status === 'Expirado') return '#E53E3E';
                if (status === 'Recusado') return '#E53E3E';
                return '#2d3748';
            }

            // Convites - Pendentes
            function updatePendingInvitesTable() {
                const clinicFilter = document.getElementById('clinicFilterConvites').value;
                const searchNameFilter = document.getElementById('searchConviteName').value.toLowerCase();
                const tableBody = document.querySelector('#pendingInvitesTable tbody');
                tableBody.innerHTML = '';

                const filtered = pendingInvites.filter(invite => {
                    const matchClinic = !clinicFilter || invite.clinic === clinicFilter;
                    const matchName = invite.name.toLowerCase().includes(searchNameFilter);
                    return matchClinic && matchName;
                });

                filtered.forEach(invite => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${invite.name}</td>
                        <td>${invite.email}</td>
                        <td>${invite.clinic}</td>
                        <td>${invite.code}</td>
                        <td style="color:${getStatusColor(invite.status)}; font-weight:bold;">${invite.status}</td>
                        <td>
                            <button class="btn copy" onclick="copyCode('${invite.code}')">
                                <i class="fas fa-copy"></i> Copiar Código
                            </button>
                        </td>
                        <td>
                            <button class="btn delete" onclick="deleteInvite('${invite.code}')" style="background: transparent; border: none; cursor: pointer;">
    <i class="fas fa-trash-alt" style="color: red; align-items: center;"></i>
</button>

                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }
            document.getElementById('clinicFilterConvites').addEventListener('change', updatePendingInvitesTable);
            document.getElementById('searchConviteName').addEventListener('input', updatePendingInvitesTable);
            updatePendingInvitesTable();

            // Função para deletar convite
            window.deleteInvite = function(code) {
                if(confirm('Tem certeza que deseja excluir este convite?')) {
                    pendingInvites = pendingInvites.filter(inv => inv.code !== code);
                    updatePendingInvitesTable();
                    alert('Convite excluído com sucesso.');
                }
            }

            // Histórico de Convites
            function updateInviteHistoryTable() {
    const clinicFilter = document.getElementById('clinicFilterParceirasHistory').value;
    const searchNameFilter = document.getElementById('searchParceirasHistoryName').value.toLowerCase();

    const tableBody = document.querySelector('#inviteHistoryTable tbody');
    tableBody.innerHTML = '';

    const filtered = inviteHistory.filter(invite => {
        const matchClinic = !clinicFilter || invite.clinic === clinicFilter;
        const matchName = invite.name.toLowerCase().includes(searchNameFilter);
        return matchClinic && matchName;
    });

    filtered.forEach(invite => {
        const row = document.createElement('tr');
        
        // Determinar o botão de ação com base no status
        let actionButton = '';
        if (invite.status === 'Aceito') {
            actionButton = `
                <button class="btn copy" onclick="encerrarConvite('${invite.name}', '${invite.email}')">
                    <i class="fas fa-times"></i> Encerrar
                </button>
            `;
        } else if (invite.status === 'Recusado' || invite.status === 'Encerrado') {
            actionButton = `
                <button class="btn delete" onclick="excluirConvite('${invite.email}')">
                    <i class="fas fa-trash-alt"></i> Excluir
                </button>
            `;
        }

        row.innerHTML = `
            <td>${invite.name}</td>
            <td>${invite.email}</td>
            <td>${invite.clinic}</td>
            <td>${invite.status}</td>
            <td>${invite.date}</td>
            <td>
                ${actionButton}
            </td>
        `;
        tableBody.appendChild(row);
    });
}


            document.getElementById('clinicFilterParceirasHistory').addEventListener('change', updateInviteHistoryTable);
            document.getElementById('searchParceirasHistoryName').addEventListener('input', updateInviteHistoryTable);
            updateInviteHistoryTable();

            function encerrarConvite(name) {
                if(confirm('Tem certeza que deseja encerrar este convite?')) {
                    // Simulação: Atualizar status no histórico
                    alert('Convite de ' + name + ' encerrado.');
                    // Lógica para encerrar o convite no backend pode ser adicionada aqui
                }
            }

            // Modal Convites
            const modal = document.getElementById('inviteModal');
            const openModalBtn = document.getElementById('openModalBtn');
            const closeModalBtn = document.getElementsByClassName('close')[0];
            const inviteForm = document.getElementById('inviteForm');
            const inviteCodeSection = document.getElementById('inviteCodeSection');
            const inviteCodeDisplay = document.getElementById('inviteCode');
            const copyInviteCodeBtn = document.getElementById('copyInviteCodeBtn');

            openModalBtn.onclick = function() {
                modal.style.display = 'block';
            }
            closeModalBtn.onclick = function() {
                modal.style.display = 'none';
                inviteForm.style.display = 'block';
                inviteCodeSection.style.display = 'none';
                inviteForm.reset();
            }
            window.onclick = function(event) {
                if (event.target == modal) {
                    modal.style.display = 'none';
                    inviteForm.style.display = 'block';
                    inviteCodeSection.style.display = 'none';
                    inviteForm.reset();
                }
            }

            inviteForm.onsubmit = function(event) {
                event.preventDefault();
                const name = document.getElementById('inviteName').value;
                const email = document.getElementById('inviteEmail').value;
                const clinic = document.getElementById('inviteClinic').value;

                const code = Math.random().toString(36).substring(2,8).toUpperCase();
                const newInvite = {
                    name: name,
                    email: email,
                    clinic: clinic,
                    code: code,
                    status: 'Pendente'
                };
                pendingInvites.push(newInvite);
                updatePendingInvitesTable();

                inviteForm.style.display='none';
                inviteCodeDisplay.textContent = code;
                inviteCodeSection.style.display = 'block';
            };

            copyInviteCodeBtn.onclick = function() {
                const code = inviteCodeDisplay.textContent;
                navigator.clipboard.writeText(code).then(() => {
                    alert('Código copiado: ' + code);
                }).catch(err => {
                    alert('Erro ao copiar o código');
                });
            }

            function copyCode(code) {
                navigator.clipboard.writeText(code).then(() => {
                    alert('Código copiado: ' + code);
                }).catch(err => {
                    alert('Erro ao copiar o código');
                });
            }

            // Parcerias - Aceitar Convito
            const acceptPartnerInviteForm = document.getElementById('acceptPartnerInviteForm');
            const partnerInviteCodeInput = document.getElementById('partnerInviteCodeInput');
            const parceirasInviteDetails = document.getElementById('parceirasInviteDetails');
            const parceirasClinicName = document.getElementById('parceirasClinicName');
            const parceirasInviterName = document.getElementById('parceirasInviterName');
            const parceirasAcceptButton = document.getElementById('parceirasAcceptButton');
            const parceirasDeclineButton = document.getElementById('parceirasDeclineButton');

            let currentInvite = null;

            acceptPartnerInviteForm.addEventListener('submit', function(event) {
                event.preventDefault();
                const codeInput = partnerInviteCodeInput.value.toUpperCase();

                const invite = pendingInvites.find(inv => inv.code === codeInput && inv.status === 'Pendente');
                if(invite) {
                    parceirasClinicName.textContent = invite.clinic;
                    parceirasInviterName.textContent = invite.name;
                    parceirasInviteDetails.style.display = 'block';
                    currentInvite = invite;
                } else {
                    alert('Convite não encontrado ou já processado.');
                    parceirasInviteDetails.style.display = 'none';
                    currentInvite = null;
                }
            });

            parceirasAcceptButton.addEventListener('click', function() {
                if(currentInvite) {
                    currentInvite.status = 'Aceito';
                    currentInvite.date = new Date().toLocaleDateString();
                    inviteHistory.push({
                        name: currentInvite.name,
                        email: currentInvite.email,
                        clinic: currentInvite.clinic,
                        status: 'Aceito',
                        date: currentInvite.date
                    });
                    pendingInvites = pendingInvites.filter(inv => inv !== currentInvite);
                    updatePendingInvitesTable();
                    updateInviteHistoryTable();
                    parceirasInviteDetails.style.display = 'none';
                    acceptPartnerInviteForm.reset();
                    currentInvite = null;
                    alert('Convite aceito com sucesso!');
                }
            });

            parceirasDeclineButton.addEventListener('click', function() {
                if(currentInvite) {
                    currentInvite.status = 'Recusado';
                    currentInvite.date = new Date().toLocaleDateString();
                    inviteHistory.push({
                        name: currentInvite.name,
                        email: currentInvite.email,
                        clinic: currentInvite.clinic,
                        status: 'Recusado',
                        date: currentInvite.date
                    });
                    pendingInvites = pendingInvites.filter(inv => inv !== currentInvite);
                    updatePendingInvitesTable();
                    updateInviteHistoryTable();
                    parceirasInviteDetails.style.display = 'none';
                    acceptPartnerInviteForm.reset();
                    currentInvite = null;
                    alert('Convite recusado.');
                }
            });
        });
    </script>
</body>
</html>
