<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Bem-vindo ao Sistema Coralina Matos</title>
  <!-- Fonte personalizada -->
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Nunito', sans-serif;
      background-color: #f0f2f5;
      color: #333;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }

    .container {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      overflow: hidden;
      max-width: 900px;
      width: 100%;
      display: flex;
      flex-direction: row;
    }

    .left {
      background: linear-gradient(to bottom right, #08CA9D, #234EA1);
      color: #fff;
      padding: 50px;
      width: 50%;
      display: flex;
      flex-direction: column;
      justify-content: center;
    }

    .left h1 {
      font-size: 2.5rem;
      margin-bottom: 20px;
    }

    .left p {
      font-size: 1.2rem;
      line-height: 1.5;
    }

    .right {
      padding: 50px;
      width: 50%;
      display: flex;
      flex-direction: column;
      justify-content: center;
    }

    .logo img {
      width: 80px;
      margin-bottom: 30px;
    }

    .form-group {
      margin-bottom: 20px;
      position: relative;
    }

    .form-group label {
      position: absolute;
      top: -10px;
      left: 15px;
      background: #fff;
      padding: 0 5px;
      font-size: 0.9rem;
      color: #888;
    }

    .form-group input {
      width: 100%;
      padding: 15px;
      border: 2px solid #ddd;
      border-radius: 10px;
      font-size: 1rem;
      transition: border-color 0.3s;
    }

    .form-group input:focus {
      border-color: #08CA9D;
      outline: none;
    }

    .btn-primary {
      width: 100%;
      padding: 15px;
      background: #08CA9D;
      border: none;
      color: white;
      font-size: 1rem;
      font-weight: bold;
      border-radius: 10px;
      cursor: pointer;
      transition: background 0.3s;
      margin-top: 10px;
    }

    .btn-primary:hover {
      background: #06b487;
    }

    .link {
      display: block;
      margin-top: 20px;
      font-size: 0.9rem;
      color: #08CA9D;
      text-decoration: none;
      text-align: center;
    }

    .link:hover {
      text-decoration: underline;
    }

    .footer {
      margin-top: 20px;
      text-align: center;
      
    }

    .footer p {
      font-size: 0.9rem;
      color: #555;
      margin-bottom: 15px;
      
    }

    .btn-secondary {
      padding: 12px 25px;
      border: 2px solid #08CA9D;
      color: #08CA9D;
      font-size: 0.9rem;
      border-radius: 10px;
      text-decoration: none;
      cursor: pointer;
      transition: background 0.3s, color 0.3s;
    }

    .btn-secondary:hover {
      background: #08CA9D;
      color: white;
    }

    /* Responsividade */
    @media (max-width: 768px) {
      .container {
        flex-direction: column;
      }

      .left, .right {
        width: 100%;
      }

      .left {
        padding: 30px;
        text-align: center;
      }

      .left h1 {
        font-size: 2rem;
      }

      .left p {
        font-size: 1rem;
      }

      .right {
        padding: 30px;
      }

      .logo img {
        width: 80px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="left">
      <h1>Bem-vindo!</h1>
      <p>Conecte-se ao Sistema de Avaliação IFCora e continue transformando vidas.</p>
    </div>

    <div class="right">
      <div class="logo">
        <img src="includes/logo.webp" alt="Sistema Coralina Matos">
      </div>

      <form action="processa_login.php" method="POST">
        <div class="form-group">
          <label for="email">E-mail</label>
          <input type="email" id="email" name="email" placeholder="Digite seu e-mail" required>
          <p style="margin: 0px;"><a href="painel-p-clinicas.php">user@mail.com</a> / <a href="painel-superadmin-dashboard.php">admin@mail.com</a></p>
            <p style="margin: 0px;"><a href="painel-responsavel-listar-criancas.php">responsavel@mail.com</a> / <a href="painel-assistente-crian&ccedil;as.php">assistente@mail.com</a></p>
        </div>
        <div class="form-group">
          <label for="password">Senha</label>
          <input type="password" id="password" name="password" placeholder="Digite sua senha" required>
        </div>

        <!-- Campo honeypot -->
        <div style="display: none;">
          <label for="honeypot">Se você é humano, não preencha este campo:</label>
          <input type="text" id="honeypot" name="honeypot">
        </div>

        <!-- CAPTCHA Matemático -->
        <div class="form-group">
          <label for="captcha">Quanto é 3 + 5?</label>
          <input type="text" id="captcha" name="captcha" placeholder="Digite a resposta" value="8" required>
        </div>

        <!-- Campo de Tempo -->
        <input type="hidden" name="form_start_time" value="<?php echo time(); ?>">

        <!-- Campo oculto para verificação -->
        <input type="hidden" name="captcha_verified" id="captcha_verified" value="">

        <button type="submit" class="btn-primary">Entrar</button>
      </form>

      <a href="recuperar_senha.php" class="link">Esqueceu sua senha?</a>
        
      <div class="footer">
          <hr />
        <p>Não possui uma conta ainda?</p>
        <a href="cadastro.php" class="btn-secondary">Criar Conta</a>
      </div>
    </div>
  </div>

  <script>
    // Preenche automaticamente o campo de verificação ao carregar a página
    document.addEventListener("DOMContentLoaded", function () {
      document.getElementById('captcha_verified').value = 'true';
    });
  </script>
</body>
</html>
