<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
    .cards {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 20px;
        }
        .card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            padding: 20px;
            display: flex;
            flex-direction: column;
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }
        .card-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        .card-header .icon {
            font-size: 28px;
            color: #F6AD55;
            margin-right: 10px;
        }
        .card-header h3 {
            font-size: 22px;
            color: #08C89E;
            margin: 0;
        }
        .card-content p {
            margin: 5px 0;
            font-size: 15px;
            color: #4a5568;
        }
        .card-content p b {
            color: #2d3748;
        }
        .card-footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 20px;
        }
        .card-footer .btn {
            background-color: #EDF2F7;
            color: #2d3748;
            padding: 10px 15px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
            display: flex;
            align-items: center;
            margin-left: 10px;
        }
        .card-footer .btn i {
            margin-right: 5px;
        }
        .btn.edit {
            background-color: #F6AD55;
            color: #fff;
        }
        .btn.delete {
            background-color: #E53E3E;
            color: #fff;
        }
        .btn.link {
            background-color: #08C89E;
            color: #fff;
        }
        .btn.edit:hover {
            background-color: #dd6b20;
        }
        .btn.delete:hover {
            background-color: #c53030;
        }
        .btn.link:hover {
            background-color: #06b287;
        }
        
        .actions {
            display: flex;
            align-items: center;
            flex-wrap: wrap;
            margin: 20px 0px;
        }
        .actions .add-new {
            background-color: #08C89E;
            color: #fff;
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 14px;
            border: none;
            cursor: pointer;
            display: flex;
            align-items: center;
            margin-right: 10px;
        }
        .actions .add-new i {
            margin-right: 8px;
        }
        .actions .search-input {
            padding: 10px 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            width: 300px;
            max-width: 100%;
        }
        </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-clinica-crianças-1.php'; ?>

    <main class="content">
        <div class="header-content">
            <!-- <h1 style="color: #08C89E; margin-left: 0px"><i class="fa-solid fa-children" style="margin-right: 8px"></i>Início</h1> -->

            <h1 style="margin-left: 0px"><i class="fa-solid fa-child" style="margin-right: 8px"></i>Pacientes - <span style="color: #F6AD55">Clínica Sertãozinho</span></h1>
            <!--  <p style="margin-top: -5px; margin-bottom: -5px">Aqui você pode visualizar e acessar os registros das crianças atribuidas a seu perfil.</p> -->
            <hr />
        </div>
        <div class="header-content">
            
            <div class="actions" style="margin-top: 10px">
                <!-- <h3>Buscar Criança:</h3> -->
                <input type="text" placeholder="Pesquisar por nome..." class="search-input">
            </div>
        </div>
        
        <div class="cards">
            <!-- Exemplo de Card de Criança -->
            <div class="card">
                <div>
                    <div class="card-header">
                        <span class="icon"><i class="fas fa-child"></i></span>
                        <h3>João Pedro</h3>
                    </div>
                    <div class="card-content">
                        <p style="margin-top: -20px; "><b>Cód. da Criança:</b> PCZ12345</p>
                        <p style="margin-top: -5px;"><b>Responsável:</b> Ana Pereira</p>
                        <hr />
                    </div>
                </div>
                <div class="card-footer" style="margin-top: 0px;">
                    <button onclick="window.location.href='painel-clinica-perfil-criança.php'" class="btn link">Acessar</button>
                </div>
            </div>
            <!-- Outros cards podem ser adicionados aqui -->
            <!-- Card 2 -->
            <div class="card">
                <div>
                    <div class="card-header">
                        <span class="icon"><i class="fas fa-child"></i></span>
                        <h3>Maria Clara</h3>
                    </div>
                    <div class="card-content">
                        <p style="margin-top: -20px; "><b>ID da Criança:</b> PCN67890</p>
                        <p style="margin-top: -5px; "><b>Responsável:</b> Carlos Silva</p>
                        <hr />
                    </div>
                </div>
                <div class="card-footer" style="margin-top: 0px;">
                    <button onclick="window.location.href='painel-clinica-perfil-criança.php'" class="btn link"></i>Acessar</button>
                </div>
            </div>
        </div>
    </main>
</body>
</html>