<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Anamnese - Sistema de Avaliação IFCora</title>
    <!-- Fontes e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Estilos Globais -->
        <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f1f5f9;
            margin: 0;
            padding: 0;
            display: flex;
        }

        

        /* Conteúdo Principal */
        .content {
            margin-top: 60px;
            margin-left: 250px;
            padding: 20px;
            flex: 1;
            box-sizing: border-box;
        }

        .anamnese-container {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .anamnese-container h1 {
            color: #08C89E;
            margin-bottom: 20px;
        }

        /* Perfil do Paciente */
        .perfil-paciente {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .perfil-paciente img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            object-fit: cover;
            margin-right: 20px;
            border: 2px solid #08C89E;
        }

        .perfil-paciente .info-paciente {
            display: flex;
            flex-direction: column;
        }

        .info-paciente span {
            font-size: 16px;
            color: #2d3748;
            margin-bottom: 5px;
        }

        /* Abas */
        .tab-container {
            margin-top: 20px;
        }

        .tabs {
            display: flex;
            border-bottom: 1px solid #e2e8f0;
            margin-bottom: 20px;
        }

        .tab {
            padding: 10px 20px;
            cursor: pointer;
            font-weight: 600;
            color: #4a5568;
            transition: background-color 0.3s, color 0.3s;
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
            margin-right: 5px;
        }

        .tab.active {
            background-color: #08C89E;
            color: #ffffff;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Formulário de Anamnese */
        .anamnese-form fieldset {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }

        .anamnese-form legend {
            font-size: 18px;
            font-weight: bold;
            color: #08C89E;
            padding: 0 10px;
        }

        .anamnese-form .form-group {
            margin-bottom: 15px;
            display: flex;
            flex-direction: column;
        }

        .anamnese-form label {
            font-size: 14px;
            font-weight: normal;
            color: #2d3748;
            margin-bottom: 5px;
        }

        .anamnese-form input,
        .anamnese-form select,
        .anamnese-form textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
            background-color: #fff;
        }

        .anamnese-form input:focus,
        .anamnese-form select:focus,
        .anamnese-form textarea:focus {
            outline: none;
            border-color: #08C89E;
            box-shadow: 0 0 0 1px #08C89E;
        }

        .anamnese-form .radio-group {
            display: flex;
            gap: 20px;
            align-items: center;
        }

        .anamnese-form .radio-group input {
            margin-right: 5px;
        }

        .anamnese-form .submit-btn {
            background-color: #08C89E;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
            align-self: flex-start;
        }

        .anamnese-form .submit-btn:hover {
            background-color: #06b287;
        }

        /* Área de Texto da Anamnese */
        .anamnese-text-area {
            display: flex;
            flex-direction: column;
        }

        .anamnese-text-area textarea {
            width: 100%;
            height: 400px;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            resize: vertical;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
            background-color: #fff;
        }

        .anamnese-text-area textarea[readonly] {
            background-color: #f7fafc;
            cursor: not-allowed;
        }

        .anamnese-text-area .botao-editar {
            align-self: flex-end;
            background-color: #4a5568;
            color: #fff;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            margin-top: 10px;
            transition: background 0.3s;
        }

        .anamnese-text-area .botao-editar:hover {
            background-color: #2d3748;
        }

        .anamnese-text-area .save-btn {
            align-self: flex-end;
            background-color: #08C89E;
            color: #fff;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            margin-top: 10px;
            transition: background 0.3s;
            display: none;
        }

        .anamnese-text-area .save-btn:hover {
            background-color: #06b287;
        }

        /* Responsividade */
        @media (max-width: 768px) {
            .sidebar {
                width: 200px;
            }

            .tabs {
                flex-direction: column;
            }

            .tab {
                margin-right: 0;
                margin-bottom: 5px;
            }

            .perfil-paciente {
                flex-direction: column;
                align-items: flex-start;
            }

            .perfil-paciente img {
                margin-bottom: 10px;
            }
        }
    </style>
</head>
<body>
        <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-anamnese.php'; ?>

    <!-- Conteúdo Principal -->
    <main class="content">
        <div class="anamnese-container">
            <h1>Anamnese do Paciente: <span id="paciente-nome">João Silva</span></h1>

            <!-- Perfil do Paciente -->
            <div class="perfil-paciente">
                <img src="https://via.placeholder.com/100" alt="Avatar do Paciente" id="avatar-paciente">
                <div class="info-paciente">
                    <span><strong>ID:</strong> PATIENT123</span>
                    <span><strong>Endereço:</strong> Rua das Flores, 123, São Paulo, SP</span>
                    <span><strong>Telefone:</strong> (11) 91234-5678</span>
                </div>
            </div>

            <div class="tab-container">
                <div class="tabs">
                    <div class="tab active" data-tab="formulario">Formulário de Anamnese</div>
                    <div class="tab" data-tab="texto">Texto da Anamnese</div>
                </div>
                <!-- Conteúdo das Abas -->
                <div id="formulario" class="tab-content active">
                    <form class="anamnese-form" id="anamnese-form">
                        <!-- 1. Identificação da Criança -->
                        <fieldset>
                            <legend>1. Identificação da Criança</legend>

                            <div class="form-group">
                                <label for="nome_crianca">Nome completo:</label>
                                <input type="text" id="nome_crianca" name="nome_crianca" value="João Silva" required>
                            </div>

                            <div class="form-group">
                                <label for="data_nascimento">Data de nascimento:</label>
                                <input type="date" id="data_nascimento" name="data_nascimento" value="2015-05-20" required>
                            </div>

                            <div class="form-group">
                                <label for="idade_atual">Idade atual:</label>
                                <input type="number" id="idade_atual" name="idade_atual" min="0" value="8" required>
                            </div>

                            <div class="form-group">
                                <label for="sexo">Sexo:</label>
                                <select id="sexo" name="sexo" required>
                                    <option value="">Selecione</option>
                                    <option value="masculino" selected>Masculino</option>
                                    <option value="feminino">Feminino</option>
                                    <option value="outro">Outro</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="responsaveis">Nome e contato dos responsáveis:</label>
                                <textarea id="responsaveis" name="responsaveis" rows="3" required>Maria Silva (mãe) - (11) 99999-9999; Pedro Silva (pai) - (11) 98888-8888</textarea>
                            </div>
                        </fieldset>

                        <!-- 2. Histórico Familiar -->
                        <fieldset>
                            <legend>2. Histórico Familiar</legend>

                            <div class="form-group">
                                <label for="composicao_familiar">Composição familiar (nome, idade, relação com a criança):</label>
                                <textarea id="composicao_familiar" name="composicao_familiar" rows="5" required>Maria Silva, 35 anos, mãe; Pedro Silva, 37 anos, pai; Ana Silva, 10 anos, irmã</textarea>
                            </div>

                            <div class="form-group">
                                <label>Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes?</label>
                                <div class="radio-group">
                                    <input type="radio" id="historico_sim" name="historico_familiar" value="sim" checked>
                                    <label for="historico_sim">Sim</label>

                                    <input type="radio" id="historico_nao" name="historico_familiar" value="nao">
                                    <label for="historico_nao">Não</label>
                                </div>
                            </div>

                            <div class="form-group" id="detalhes_historico_group">
                                <label for="detalhes_historico">Se sim, especifique quais e em quais familiares:</label>
                                <textarea id="detalhes_historico" name="detalhes_historico" rows="3">Maria Silva, mãe, possui diagnóstico de transtorno de déficit de atenção e hiperatividade (TDAH).</textarea>
                            </div>
                        </fieldset>

                        <!-- 3. Histórico Gestacional e Neonatal -->
                        <fieldset>
                            <legend>3. Histórico Gestacional e Neonatal</legend>

                            <div class="form-group">
                                <label>A gestação foi planejada?</label>
                                <div class="radio-group">
                                    <input type="radio" id="gestacao_sim" name="gestacao_planejada" value="sim" checked>
                                    <label for="gestacao_sim">Sim</label>

                                    <input type="radio" id="gestacao_nao" name="gestacao_planejada" value="nao">
                                    <label for="gestacao_nao">Não</label>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="complicacoes_gestacao">Houve complicações durante a gravidez? Se sim, quais?</label>
                                <textarea id="complicacoes_gestacao" name="complicacoes_gestacao" rows="3">Nenhuma complicação significativa.</textarea>
                            </div>

                            <div class="form-group">
                                <label>Tipo de parto:</label>
                                <select id="tipo_parto" name="tipo_parto">
                                    <option value="">Selecione</option>
                                    <option value="normal" selected>Normal</option>
                                    <option value="cesarea">Cesárea</option>
                                    <option value="prematuro">Prematuro</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="semanas_gestacao">Quantas semanas de gestação?</label>
                                <input type="number" id="semanas_gestacao" name="semanas_gestacao" min="20" max="42" value="39">
                            </div>

                            <div class="form-group">
                                <label>A criança necessitou de cuidados especiais ao nascer (ex.: UTI neonatal)?</label>
                                <div class="radio-group">
                                    <input type="radio" id="cuidados_sim" name="cuidados_especiais" value="sim">
                                    <label for="cuidados_sim">Sim</label>

                                    <input type="radio" id="cuidados_nao" name="cuidados_especiais" value="nao" checked>
                                    <label for="cuidados_nao">Não</label>
                                </div>
                            </div>

                            <div class="form-group" id="detalhes_cuidados_group" style="display: none;">
                                <label for="detalhes_cuidados">Se sim, quais cuidados?</label>
                                <textarea id="detalhes_cuidados" name="detalhes_cuidados" rows="3">Nenhum cuidado especial necessário.</textarea>
                            </div>
                        </fieldset>

                        <!-- 4. Histórico Médico e Saúde Geral -->
                        <fieldset>
                            <legend>4. Histórico Médico e Saúde Geral</legend>

                            <div class="form-group">
                                <label for="diagnostico_medico">A criança possui algum diagnóstico médico atual (ex.: epilepsia, alergias, problemas auditivos ou visuais)?</label>
                                <textarea id="diagnostico_medico" name="diagnostico_medico" rows="3">Nenhum diagnóstico médico atual.</textarea>
                            </div>

                            <div class="form-group">
                                <label for="internacoes">Já foi internada ou submetida a cirurgias? Se sim, quando e por quê?</label>
                                <textarea id="internacoes" name="internacoes" rows="3">Não.</textarea>
                            </div>

                            <div class="form-group">
                                <label for="medicamentos">Faz uso de medicação contínua? Se sim, quais?</label>
                                <textarea id="medicamentos" name="medicamentos" rows="3">Não.</textarea>
                            </div>
                        </fieldset>

                        <!-- 5. Rotina e Ambiente -->
                        <fieldset>
                            <legend>5. Rotina e Ambiente</legend>

                            <div class="form-group">
                                <label for="cuidador_principal">Quem é o principal cuidador da criança?</label>
                                <input type="text" id="cuidador_principal" name="cuidador_principal" value="Maria Silva (mãe)">
                            </div>

                            <div class="form-group">
                                <label>A criança frequenta escola ou creche?</label>
                                <div class="radio-group">
                                    <input type="radio" id="escola_sim" name="frequenta_escola" value="sim" checked>
                                    <label for="escola_sim">Sim</label>

                                    <input type="radio" id="escola_nao" name="frequenta_escola" value="nao">
                                    <label for="escola_nao">Não</label>
                                </div>
                            </div>

                            <div class="form-group" id="nome_instituicao_group">
                                <label for="nome_instituicao">Se sim, qual instituição e em que período?</label>
                                <textarea id="nome_instituicao" name="nome_instituicao" rows="2">Escola Infantil ABC, período da manhã.</textarea>
                            </div>

                            <div class="form-group">
                                <label for="exposicao_estresse">Há exposição a fatores estressantes no ambiente familiar (ex.: conflitos, mudanças frequentes, perdas recentes)?</label>
                                <textarea id="exposicao_estresse" name="exposicao_estresse" rows="3">Não há exposição a fatores estressantes significativos.</textarea>
                            </div>
                        </fieldset>

                        <!-- 6. Histórico Escolar (se aplicável) -->
                        <fieldset>
                            <legend>6. Histórico Escolar (se aplicável)</legend>

                            <div class="form-group">
                                <label for="comportamento_escola">Como é o comportamento da criança na escola ou creche?</label>
                                <textarea id="comportamento_escola" name="comportamento_escola" rows="3">João é participativo e interage bem com os colegas.</textarea>
                            </div>

                            <div class="form-group">
                                <label for="preocupacao_escola">A instituição já sinalizou alguma preocupação com a criança?</label>
                                <textarea id="preocupacao_escola" name="preocupacao_escola" rows="3">A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.</textarea>
                            </div>
                        </fieldset>

                        <!-- 7. Motivo da Avaliação -->
                        <fieldset>
                            <legend>7. Motivo da Avaliação</legend>

                            <div class="form-group">
                                <label for="motivo_avaliacao">O que motivou a busca por avaliação?</label>
                                <textarea id="motivo_avaliacao" name="motivo_avaliacao" rows="3">Preocupação com a dificuldade de atenção e concentração.</textarea>
                            </div>

                            <div class="form-group">
                                <label for="preocupacoes_especificas">Há preocupações específicas com o comportamento ou desenvolvimento da criança?</label>
                                <textarea id="preocupacoes_especificas" name="preocupacoes_especificas" rows="3">Dificuldade em concluir tarefas que exigem foco por mais tempo.</textarea>
                            </div>
                        </fieldset>

                        <!-- 8. Observações Adicionais -->
                        <fieldset>
                            <legend>8. Observações Adicionais</legend>

                            <div class="form-group">
                                <label for="observacoes">Espaço para anotações relevantes dos responsáveis:</label>
                                <textarea id="observacoes" name="observacoes" rows="5">João tem demonstrado interesse em esportes e atividades ao ar livre.</textarea>
                            </div>
                        </fieldset>

                        <!-- Botão de Enviar -->
                        <button type="submit" class="submit-btn"><i class="fas fa-paper-plane"></i> Enviar</button>
                    </form>
                </div>

                <div id="texto" class="tab-content">
                    <div class="anamnese-text-area">
                        <label for="anamnese_texto"><strong>Texto da Anamnese:</strong></label>
                        <textarea id="anamnese_texto" name="anamnese_texto" rows="20" readonly>
Anamnese do Paciente: João Silva

1. Identificação da Criança:
   - Data de Nascimento: 2015-05-20
   - Idade Atual: 8 anos
   - Sexo: Masculino
   - Responsáveis: Maria Silva (mãe) - (11) 99999-9999; Pedro Silva (pai) - (11) 98888-8888

2. Histórico Familiar:
   - Composição Familiar: Maria Silva, 35 anos, mãe; Pedro Silva, 37 anos, pai; Ana Silva, 10 anos, irmã
   - Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes? Sim
   - Detalhes: Maria Silva, mãe, possui diagnóstico de transtorno de déficit de atenção e hiperatividade (TDAH).

3. Histórico Gestacional e Neonatal:
   - Gestação foi planejada? Sim
   - Complicações durante a gravidez: Nenhuma complicação significativa.
   - Tipo de Parto: Normal
   - Quantas semanas de gestação? 39 semanas
   - A criança necessitou de cuidados especiais ao nascer? Não

4. Histórico Médico e Saúde Geral:
   - Diagnóstico Médico Atual: Nenhum diagnóstico médico atual.
   - Internações ou Cirurgias: Não.
   - Uso de Medicação Contínua: Não.

5. Rotina e Ambiente:
   - Principal Cuidador: Maria Silva (mãe)
   - Frequência na Escola ou Creche: Sim
   - Nome da Instituição e Período: Escola Infantil ABC, período da manhã.
   - Exposição a Fatores Estressantes no Ambiente Familiar: Não há exposição a fatores estressantes significativos.

6. Histórico Escolar:
   - Comportamento na Escola ou Creche: João é participativo e interage bem com os colegas.
   - Preocupações Sinalizadas pela Instituição: A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.

7. Motivo da Avaliação:
   - Motivo da Busca por Avaliação: Preocupação com a dificuldade de atenção e concentração.
   - Preocupações Específicas com o Comportamento ou Desenvolvimento: Dificuldade em concluir tarefas que exigem foco por mais tempo.

8. Observações Adicionais:
   - João tem demonstrado interesse em esportes e atividades ao ar livre.
                        </textarea>
                        <button class="botao-editar" id="editar_anamnese_texto"><i class="fas fa-edit"></i> Editar</button>
                        <button class="save-btn" id="save_anamnese_texto"><i class="fas fa-save"></i> Salvar Alterações</button>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Scripts Específicos para Anamnese -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Seleção das abas
            const tabs = document.querySelectorAll('.tab');
            const tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    // Remover a classe 'active' de todas as abas e conteúdos
                    tabs.forEach(item => item.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    // Adicionar a classe 'active' na aba clicada e no conteúdo correspondente
                    tab.classList.add('active');
                    document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
                });
            });

            // Mostrar/ocultar detalhes do histórico familiar
            const historicoFamiliaSim = document.getElementById('historico_sim');
            const historicoFamiliaNao = document.getElementById('historico_nao');
            const detalhesHistoricoGroup = document.getElementById('detalhes_historico_group');

            historicoFamiliaSim.addEventListener('change', function() {
                if (this.checked) {
                    detalhesHistoricoGroup.style.display = 'block';
                }
            });

            historicoFamiliaNao.addEventListener('change', function() {
                if (this.checked) {
                    detalhesHistoricoGroup.style.display = 'none';
                    document.getElementById('detalhes_historico').value = '';
                }
            });

            // Mostrar/ocultar detalhes dos cuidados especiais
            const cuidadosSim = document.getElementById('cuidados_sim');
            const cuidadosNao = document.getElementById('cuidados_nao');
            const detalhesCuidadosGroup = document.getElementById('detalhes_cuidados_group');

            cuidadosSim.addEventListener('change', function() {
                if (this.checked) {
                    detalhesCuidadosGroup.style.display = 'block';
                }
            });

            cuidadosNao.addEventListener('change', function() {
                if (this.checked) {
                    detalhesCuidadosGroup.style.display = 'none';
                    document.getElementById('detalhes_cuidados').value = '';
                }
            });

            // Mostrar/ocultar nome da instituição
            const frequentaEscolaSim = document.getElementById('escola_sim');
            const frequentaEscolaNao = document.getElementById('escola_nao');
            const nomeInstituicaoGroup = document.getElementById('nome_instituicao_group');

            frequentaEscolaSim.addEventListener('change', function() {
                if (this.checked) {
                    nomeInstituicaoGroup.style.display = 'block';
                }
            });

            frequentaEscolaNao.addEventListener('change', function() {
                if (this.checked) {
                    nomeInstituicaoGroup.style.display = 'none';
                    document.getElementById('nome_instituicao').value = '';
                }
            });

            // Lógica para gerar o texto da anamnese ao submeter o formulário
            const anamneseForm = document.getElementById('anamnese-form');
            const anamneseTexto = document.getElementById('anamnese_texto');

            anamneseForm.addEventListener('submit', (e) => {
                e.preventDefault(); // Evita o envio real do formulário

                // Obter valores do formulário
                const nome_crianca = document.getElementById('nome_crianca').value.trim();
                const data_nascimento = document.getElementById('data_nascimento').value;
                const idade_atual = document.getElementById('idade_atual').value;
                const sexo = document.getElementById('sexo').value;
                const responsaveis = document.getElementById('responsaveis').value.trim();
                const composicao_familiar = document.getElementById('composicao_familiar').value.trim();
                const historico_familiar = historicoFamiliaSim.checked ? 'Sim' : 'Não';
                const detalhes_historico = document.getElementById('detalhes_historico').value.trim();
                const gestacao_planejada = document.querySelector('input[name="gestacao_planejada"]:checked').value;
                const complicacoes_gestacao = document.getElementById('complicacoes_gestacao').value.trim();
                const tipo_parto = document.getElementById('tipo_parto').value;
                const semanas_gestacao = document.getElementById('semanas_gestacao').value;
                const cuidados_especiais = document.querySelector('input[name="cuidados_especiais"]:checked').value;
                const detalhes_cuidados = document.getElementById('detalhes_cuidados').value.trim();
                const diagnostico_medico = document.getElementById('diagnostico_medico').value.trim();
                const internacoes = document.getElementById('internacoes').value.trim();
                const medicamentos = document.getElementById('medicamentos').value.trim();
                const cuidador_principal = document.getElementById('cuidador_principal').value.trim();
                const frequenta_escola = document.querySelector('input[name="frequenta_escola"]:checked').value;
                const nome_instituicao = document.getElementById('nome_instituicao').value.trim();
                const exposicao_estresse = document.getElementById('exposicao_estresse').value.trim();
                const comportamento_escola = document.getElementById('comportamento_escola').value.trim();
                const preocupacao_escola = document.getElementById('preocupacao_escola').value.trim();
                const motivo_avaliacao = document.getElementById('motivo_avaliacao').value.trim();
                const preocupacoes_especificas = document.getElementById('preocupacoes_especificas').value.trim();
                const observacoes = document.getElementById('observacoes').value.trim();

                // Gerar o texto da anamnese
                let texto = `
Anamnese do Paciente: ${nome_crianca}

1. Identificação da Criança:
   - Data de Nascimento: ${data_nascimento}
   - Idade Atual: ${idade_atual} anos
   - Sexo: ${sexo}
   - Responsáveis: ${responsaveis}

2. Histórico Familiar:
   - Composição Familiar: ${composicao_familiar}
   - Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes? ${historico_familiar}
   ${historico_familiar === 'Sim' ? '- Detalhes: ' + detalhes_historico : ''}

3. Histórico Gestacional e Neonatal:
   - Gestação foi planejada? ${gestacao_planejada}
   - Complicações durante a gravidez: ${complicacoes_gestacao}
   - Tipo de Parto: ${tipo_parto}
   - Quantas semanas de gestação? ${semanas_gestacao} semanas
   - A criança necessitou de cuidados especiais ao nascer? ${cuidados_especiais}
   ${cuidados_especiais === 'sim' ? '- Detalhes dos cuidados: ' + detalhes_cuidados : ''}

4. Histórico Médico e Saúde Geral:
   - Diagnóstico Médico Atual: ${diagnostico_medico}
   - Internações ou Cirurgias: ${internacoes}
   - Uso de Medicação Contínua: ${medicamentos}

5. Rotina e Ambiente:
   - Principal Cuidador: ${cuidador_principal}
   - Frequência na Escola ou Creche: ${frequenta_escola}
   ${frequenta_escola === 'sim' ? '- Nome da Instituição e Período: ' + nome_instituicao : ''}
   - Exposição a Fatores Estressantes no Ambiente Familiar: ${exposicao_estresse}

6. Histórico Escolar:
   - Comportamento na Escola ou Creche: ${comportamento_escola}
   - Preocupações Sinalizadas pela Instituição: ${preocupacao_escola}

7. Motivo da Avaliação:
   - Motivo da Busca por Avaliação: ${motivo_avaliacao}
   - Preocupações Específicas com o Comportamento ou Desenvolvimento: ${preocupacoes_especificas}

8. Observações Adicionais:
   - ${observacoes}
                `;

                // Atualizar o texto na aba "Texto da Anamnese"
                anamneseTexto.value = texto;

                // Salvar o texto no LocalStorage (simulação de persistência)
                localStorage.setItem('anamnese_texto', texto);

                // Trocar para a aba "Texto da Anamnese"
                tabs.forEach(item => item.classList.remove('active'));
                tabContents.forEach(content => content.classList.remove('active'));

                document.querySelector('.tab[data-tab="texto"]').classList.add('active');
                document.getElementById('texto').classList.add('active');
            });

            // Carregar o texto da anamnese do LocalStorage, se existir
            const savedAnamnese = localStorage.getItem('anamnese_texto');
            if (savedAnamnese) {
                anamneseTexto.value = savedAnamnese;
            }

            // Lógica para editar o texto da anamnese
            const editarAnamneseBtn = document.getElementById('editar_anamnese_texto');
            const saveAnamneseBtn = document.getElementById('save_anamnese_texto');

            editarAnamneseBtn.addEventListener('click', () => {
                anamneseTexto.removeAttribute('readonly');
                anamneseTexto.focus();
                editarAnamneseBtn.style.display = 'none';
                saveAnamneseBtn.style.display = 'block';
            });

            // Lógica para salvar o texto editado
            saveAnamneseBtn.addEventListener('click', () => {
                const texto = anamneseTexto.value.trim();

                if (texto === '') {
                    alert('O texto da anamnese não pode estar vazio.');
                    return;
                }

                // Salvar o texto no LocalStorage
                localStorage.setItem('anamnese_texto', texto);

                // Tornar a textarea readonly novamente
                anamneseTexto.setAttribute('readonly', true);
                editarAnamneseBtn.style.display = 'block';
                saveAnamneseBtn.style.display = 'none';

                alert('Anamnese salva com sucesso!');
            });
        });
    </script>
</body>
</html>
