<?php
// painel-clinica-perfil-criança-avaliacoes-mobile.php

session_start();



// Simulação de dados (substitua com consultas ao banco de dados)
$clinics = [
    ['id' => 'CL001', 'name' => 'Clínica Primavera'],
    ['id' => 'CL002', 'name' => 'Clínica Verão'],
    // Adicione mais clínicas conforme necessário
];

$children = [
    ['id' => 'CH001', 'name' => 'João da Silva', 'birthdate' => '2018-05-20', 'gender' => 'Masculino', 'contact' => '(11) 99999-9999', 'clinic_id' => 'CL001'],
    ['id' => 'CH002', 'name' => 'Pedro Santos', 'birthdate' => '2019-07-25', 'gender' => 'Masculino', 'contact' => '(31) 97777-7777', 'clinic_id' => 'CL002'],
    ['id' => 'CH003', 'name' => 'Ana Souza', 'birthdate' => '2016-11-30', 'gender' => 'Feminino', 'contact' => '(41) 96666-6666', 'clinic_id' => 'CL001'],
    // Adicione mais crianças conforme necessário
];

// Simulação de avaliações (substitua com consultas ao banco de dados)
$evaluations = [
    ['id' => 'AV001', 'child_id' => 'CH001', 'name' => 'Avaliação Inicial - Portage', 'type' => 'inicial', 'date' => '2023-02-15', 'results' => 'Desenvolvimento dentro do esperado para a idade.'],
    ['id' => 'AV002', 'child_id' => 'CH001', 'name' => 'Reavaliação Intermediária', 'type' => 'reavaliacao', 'date' => '2023-06-20', 'results' => 'Pequena melhora na coordenação motora fina.'],
    ['id' => 'AV003', 'child_id' => 'CH002', 'name' => 'Avaliação Inicial - Portage', 'type' => 'inicial', 'date' => '2023-03-20', 'results' => 'Desenvolvimento dentro do esperado para a idade.'],
    // Adicione mais avaliações conforme necessário
];

// Obter o ID do profissional logado (simulação)
$currentProfessionalId = 'PROF123'; // Este valor deveria vir da sessão do usuário autenticado

// Filtrar clínicas atribuídas ao profissional (simulação)
$userClinics = $clinics; // Substitua com lógica real de filtragem

// Filtrar crianças atribuídas ao profissional nas clínicas selecionadas (simulação)
$userChildren = $children; // Substitua com lógica real de filtragem

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <title>Avaliações - Sistema IFCora (Mobile)</title>
    <!-- Meta Tags para Responsividade -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Fonte e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- CSS Personalizado -->
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
            padding-top: 56px; /* Espaço para a navbar fixa */
        }

        /* Navbar Customizada */
        .navbar {
            background-color: #08C89E;
        }

        .navbar-brand, .navbar-nav .nav-link, .navbar-toggler-icon {
            color: #fff !important;
        }

        /* Container Principal */
        .container-page {
            padding: 15px;
        }

        h1 {
            color: #fff;
            background-color: #08C89E;
            padding: 10px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }

        /* Botão para criar nova avaliação */
        .new-evaluation-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            width: 100%;
            margin-bottom: 20px;
        }

        .new-evaluation-btn:hover {
            background-color: #06b287;
        }

        /* Seção de Filtros e Pesquisa */
        .filter-section {
            margin-bottom: 20px;
        }

        .filter-section .form-control {
            border-radius: 6px;
            border: 1px solid #e2e8f0;
        }

        /* Card das Avaliações */
        .evaluation-card {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            background-color: #fff;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            margin-bottom: 15px;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .evaluation-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .evaluation-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }

        .evaluation-header h5 {
            margin: 0;
            color: #2d3748;
            font-size: 18px;
        }

        .badge {
            font-size: 12px;
        }

        .evaluation-info p {
            margin: 5px 0;
            font-size: 14px;
        }

        .evaluation-actions {
            margin-top: 10px;
            display: flex;
            justify-content: space-around;
        }

        .action-btn {
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 6px;
            padding: 8px 12px;
            font-size: 12px;
            cursor: pointer;
            transition: background 0.3s;
            width: 30%;
            text-align: center;
        }

        .action-btn:hover {
            background-color: #06b287;
        }

        /* Informações da Linha do Tempo e da Criança */
        .timeline-info, .child-info {
            background-color: #f7fafc;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 15px;
        }

        .timeline-info h6, .child-info h6 {
            color: #08C89E;
            margin-bottom: 10px;
            font-size: 16px;
        }

        .timeline-info p, .child-info p {
            margin: 0;
            font-size: 14px;
        }

        /* Modal Estilização */
        .modal-header {
            border-bottom: 1px solid #e2e8f0;
        }

        .modal-title {
            font-weight: 600;
            color: #08C89E;
            font-size: 18px;
        }

        .modal-footer {
            border-top: 1px solid #e2e8f0;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
        }

        .form-control {
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
        }

        /* Toasts */
        .toast-container {
            position: fixed;
            top: 70px;
            right: 15px;
            z-index: 1055;
        }

        /* Responsividade */
        @media(max-width: 576px) {
            .evaluation-header h5 {
                font-size: 16px;
            }

            .action-btn {
                padding: 6px 8px;
                font-size: 10px;
                width: 30%;
            }

            .filter-section .form-control {
                font-size: 12px;
            }

            h1 {
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar Fixa -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <a class="navbar-brand" href="#">IFCora</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#mobileNavbar" aria-controls="mobileNavbar" aria-expanded="false" aria-label="Alternar navegação">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="mobileNavbar">
            <ul class="navbar-nav mr-auto">
                <li class="nav-item active">
                    <a class="nav-link" href="#">Avaliações</a>
                </li>
                <!-- Adicione mais itens de navegação conforme necessário -->
            </ul>
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" href="#"><i class="fas fa-user-circle"></i> Perfil</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="logout.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
                </li>
            </ul>
        </div>
    </nav>

    <div class="container-page">
        <h1>Avaliações da Linha do Tempo</h1>
        
        <!-- Seção para Seleção de Clínica -->
        <div class="form-group">
            <label for="selectClinic"><i class="fas fa-hospital"></i> Selecione a Clínica</label>
            <select id="selectClinic" class="form-control">
                <option value="" disabled selected>-- Escolha uma Clínica --</option>
                <?php foreach($userClinics as $clinic): ?>
                    <option value="<?php echo $clinic['id']; ?>"><?php echo $clinic['name']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Seção para Listar Crianças Atribuídas -->
        <div id="childrenSection" style="display:none;">
            <div class="form-group">
                <label for="selectChild"><i class="fas fa-child"></i> Selecione a Criança</label>
                <select id="selectChild" class="form-control">
                    <option value="" disabled selected>-- Escolha uma Criança --</option>
                    <!-- Opções serão adicionadas dinamicamente -->
                </select>
            </div>
        </div>

        <!-- Informações da Linha do Tempo e da Criança -->
        <div id="infoSection" style="display:none;">
            <div class="timeline-info">
                <h6><i class="fas fa-stream"></i> Informações da Linha do Tempo</h6>
                <p><strong>ID da Linha do Tempo:</strong> <span id="timelineId">TL001</span></p>
                <p><strong>Data de Criação:</strong> <span id="creationDate">10/01/2023</span></p>
                <p><strong>Última Atualização:</strong> <span id="lastUpdate">15/02/2023</span></p>
            </div>

            <div class="child-info">
                <h6><i class="fas fa-child"></i> Informações da Criança</h6>
                <p><strong>Nome:</strong> <span id="childName">João da Silva</span></p>
                <p><strong>Data de Nascimento:</strong> <span id="childBirthdate">20/05/2018</span> (<span id="childAge">6</span> anos)</p>
                <p><strong>Gênero:</strong> <span id="childGender">Masculino</span></p>
                <p><strong>Responsável:</strong> <span id="childContact">Maria da Silva (Mãe) - (11) 99999-9999</span></p>
            </div>
        </div>

        <!-- Botão para criar nova avaliação -->
        <div id="actionButtons" style="display:none;">
            <button class="new-evaluation-btn" data-toggle="modal" data-target="#createEvaluationModal">
                <i class="fas fa-plus"></i> Nova Avaliação
            </button>
        </div>

        <!-- Seção de Filtros e Pesquisa -->
        <div id="evaluationsSection" style="display:none;">
            <div class="filter-section">
                <div class="form-row">
                    <div class="form-group col-12">
                        <input type="text" id="evalSearchInput" class="form-control" placeholder="Pesquisar por nome da avaliação...">
                    </div>
                    <div class="form-group col-6">
                        <select id="evalFilterDate" class="form-control">
                            <option value="">Filtrar por Ano</option>
                            <option value="2023">2023</option>
                            <option value="2024">2024</option>
                            <!-- Adicione mais opções conforme necessário -->
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <select id="evalFilterType" class="form-control">
                            <option value="">Tipo de Avaliação</option>
                            <option value="inicial">Avaliação Inicial</option>
                            <option value="reavaliacao">Reavaliação</option>
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <button class="action-btn btn-block" id="evalSearchBtn"><i class="fas fa-search"></i> Pesquisar</button>
                    </div>
                    <div class="form-group col-6">
                        <button class="action-btn btn-block" id="evalResetBtn"><i class="fas fa-undo"></i> Resetar</button>
                    </div>
                </div>
            </div>

            <!-- Lista de Avaliações -->
            <div id="evaluationsContainer">
                <!-- Avaliação Exemplo 1 -->
                <div class="evaluation-card">
                    <div class="evaluation-header">
                        <h5>Avaliação Inicial - Portage</h5>
                        <span class="badge badge-info">Inicial</span>
                    </div>
                    <div class="evaluation-info">
                        <p><strong>ID Avaliação:</strong> AV001</p>
                        <p><strong>Data da Avaliação:</strong> 15/02/2023</p>
                        <p><strong>Resultados:</strong> Desenvolvimento dentro do esperado para a idade.</p>
                    </div>
                    <div class="evaluation-actions">
                        <button class="action-btn" onclick="accessEvaluation('AV001')"><i class="fas fa-arrow-right"></i> Acessar</button>
                        <button class="action-btn" onclick="editEvaluation('AV001')"><i class="fas fa-edit"></i> Editar</button>
                        <button class="action-btn" onclick="deleteEvaluation('AV001')"><i class="fas fa-trash-alt"></i> Excluir</button>
                    </div>
                </div>

                <!-- Avaliação Exemplo 2 -->
                <div class="evaluation-card">
                    <div class="evaluation-header">
                        <h5>Reavaliação Intermediária</h5>
                        <span class="badge badge-warning">Reavaliação</span>
                    </div>
                    <div class="evaluation-info">
                        <p><strong>ID Avaliação:</strong> AV002</p>
                        <p><strong>Data da Avaliação:</strong> 20/06/2023</p>
                        <p><strong>Resultados:</strong> Pequena melhora na coordenação motora fina.</p>
                    </div>
                    <div class="evaluation-actions">
                        <button class="action-btn" onclick="accessEvaluation('AV002')"><i class="fas fa-arrow-right"></i> Acessar</button>
                        <button class="action-btn" onclick="editEvaluation('AV002')"><i class="fas fa-edit"></i> Editar</button>
                        <button class="action-btn" onclick="deleteEvaluation('AV002')"><i class="fas fa-trash-alt"></i> Excluir</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Nova Avaliação -->
    <div class="modal fade" id="createEvaluationModal" tabindex="-1" role="dialog" aria-labelledby="createEvaluationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="createEvaluationModalLabel">Nova Avaliação</h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Fechar" style="border:none;background:none;font-size:20px;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="evaluationForm">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="evaluationName">Nome da Avaliação</label>
                            <input type="text" id="evaluationName" name="evaluationName" class="form-control" placeholder="Ex: Avaliação Intermediária" required>
                        </div>
                        <div class="form-group">
                            <label for="evaluationDate">Data da Avaliação</label>
                            <input type="date" id="evaluationDate" name="evaluationDate" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="evaluationType">Tipo de Avaliação</label>
                            <select id="evaluationType" name="evaluationType" class="form-control" required>
                                <option value="" disabled selected>Selecione o Tipo</option>
                                <option value="inicial">Avaliação Inicial</option>
                                <option value="reavaliacao">Reavaliação</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="evaluationResults">Resultados / Observações</label>
                            <textarea id="evaluationResults" name="evaluationResults" class="form-control" rows="3" placeholder="Descreva aqui os resultados da avaliação..." required></textarea>
                        </div>
                        <p class="text-muted" style="font-size:12px;">Somente você terá acesso a esta avaliação, outros profissionais não terão acesso.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="action-btn" style="background-color:#e53e3e;" data-dismiss="modal"><i class="fas fa-times"></i> Cancelar</button>
                        <button type="submit" class="action-btn" style="background-color:#08C89E;"><i class="fas fa-save"></i> Criar Avaliação</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Container para Toasts -->
    <div class="toast-container" aria-live="polite" aria-atomic="true">
        <!-- Toasts via JavaScript -->
    </div>

    <!-- Scripts Bootstrap -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Script para Gerenciar Avaliações -->
    <script>
        // Simulação de dados dinâmicos (substitua com consultas reais via AJAX ou PHP)
        const allChildren = <?php echo json_encode($children); ?>;
        const allEvaluations = <?php echo json_encode($evaluations); ?>;

        // Função para calcular a idade atual da criança
        function calculateAge(birthDate) {
            const today = new Date();
            const birth = new Date(birthDate);
            let age = today.getFullYear() - birth.getFullYear();
            const m = today.getMonth() - birth.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birth.getDate())) {
                age--;
            }
            return age;
        }

        // Função para formatar a data no formato dd/mm/yyyy
        function formatDate(dateString) {
            const options = { year: 'numeric', month: '2-digit', day: '2-digit' };
            return new Date(dateString).toLocaleDateString('pt-BR', options);
        }

        // Manipular seleção de clínica
        document.getElementById('selectClinic').addEventListener('change', function() {
            const selectedClinicId = this.value;
            const childrenSection = document.getElementById('childrenSection');
            const selectChild = document.getElementById('selectChild');
            selectChild.innerHTML = '<option value="" disabled selected>-- Escolha uma Criança --</option>';

            // Filtrar crianças da clínica selecionada
            const filteredChildren = allChildren.filter(child => child.clinic_id === selectedClinicId);

            if(filteredChildren.length > 0){
                filteredChildren.forEach(child => {
                    const option = document.createElement('option');
                    option.value = child.id;
                    option.textContent = child.name;
                    selectChild.appendChild(option);
                });
                childrenSection.style.display = 'block';
            } else {
                childrenSection.style.display = 'none';
                alert('Nenhuma criança atribuída a esta clínica.');
            }

            // Limpar as seções de informações e avaliações
            document.getElementById('infoSection').style.display = 'none';
            document.getElementById('actionButtons').style.display = 'none';
            document.getElementById('evaluationsSection').style.display = 'none';
            document.getElementById('evaluationsContainer').innerHTML = '';
        });

        // Manipular seleção de criança
        document.getElementById('selectChild').addEventListener('change', function() {
            const selectedChildId = this.value;
            const selectedChild = allChildren.find(child => child.id === selectedChildId);

            if(selectedChild){
                // Atualizar informações da criança
                document.getElementById('childName').textContent = selectedChild.name;
                document.getElementById('childBirthdate').textContent = formatDate(selectedChild.birthdate);
                document.getElementById('childAge').textContent = calculateAge(selectedChild.birthdate);
                document.getElementById('childGender').textContent = selectedChild.gender;
                document.getElementById('childContact').textContent = selectedChild.contact;

                // Atualizar informações da linha do tempo (simulação)
                document.getElementById('timelineId').textContent = 'TL' + selectedChild.id.substring(2);
                document.getElementById('creationDate').textContent = formatDate(selectedChild.birthdate);
                document.getElementById('lastUpdate').textContent = formatDate(selectedChild.birthdate);

                // Mostrar informações e botões de ação
                document.getElementById('infoSection').style.display = 'block';
                document.getElementById('actionButtons').style.display = 'block';
                document.getElementById('evaluationsSection').style.display = 'block';

                // Filtrar avaliações da criança selecionada
                const childEvaluations = allEvaluations.filter(eval => eval.child_id === selectedChildId);
                const evaluationsContainer = document.getElementById('evaluationsContainer');
                evaluationsContainer.innerHTML = '';

                if(childEvaluations.length > 0){
                    childEvaluations.forEach(evalItem => {
                        const card = document.createElement('div');
                        card.className = 'evaluation-card';
                        card.innerHTML = `
                            <div class="evaluation-header">
                                <h5>${evalItem.name}</h5>
                                <span class="badge badge-${evalItem.type === 'inicial' ? 'info' : 'warning'}">${evalItem.type === 'inicial' ? 'Inicial' : 'Reavaliação'}</span>
                            </div>
                            <div class="evaluation-info">
                                <p><strong>ID Avaliação:</strong> ${evalItem.id}</p>
                                <p><strong>Data da Avaliação:</strong> ${formatDate(evalItem.date)}</p>
                                <p><strong>Resultados:</strong> ${evalItem.results}</p>
                            </div>
                            <div class="evaluation-actions">
                                <button class="action-btn" onclick="accessEvaluation('${evalItem.id}')"><i class="fas fa-arrow-right"></i> Acessar</button>
                                <button class="action-btn" onclick="editEvaluation('${evalItem.id}')"><i class="fas fa-edit"></i> Editar</button>
                                <button class="action-btn" onclick="deleteEvaluation('${evalItem.id}')"><i class="fas fa-trash-alt"></i> Excluir</button>
                            </div>
                        `;
                        evaluationsContainer.appendChild(card);
                    });
                } else {
                    evaluationsContainer.innerHTML = '<p class="text-center">Nenhuma avaliação encontrada.</p>';
                }
            }
        });

        // Função para acessar uma avaliação específica
        function accessEvaluation(evalId) {
            // Redirecionar para a página de detalhes da avaliação
            window.location.href = 'pagina-avaliacao.php?evalId=' + evalId;
        }

        // Função para editar avaliação
        function editEvaluation(evalId) {
            // Encontrar a avaliação no array
            const evaluation = allEvaluations.find(eval => eval.id === evalId);
            if(evaluation){
                // Preencher o formulário do modal com os dados da avaliação
                document.getElementById('evaluationName').value = evaluation.name;
                document.getElementById('evaluationDate').value = evaluation.date;
                document.getElementById('evaluationType').value = evaluation.type;
                document.getElementById('evaluationResults').value = evaluation.results;

                // Alterar o título e o botão do modal
                document.getElementById('createEvaluationModalLabel').textContent = 'Editar Avaliação';
                document.querySelector('#evaluationForm .modal-footer button[type="submit"]').innerHTML = '<i class="fas fa-save"></i> Salvar Alterações';

                // Adicionar um atributo para identificar que é uma edição
                document.getElementById('evaluationForm').setAttribute('data-editing', evalId);
                
                // Abrir o modal
                $('#createEvaluationModal').modal('show');
            }
        }

        // Evento para criar ou editar avaliação
        document.getElementById('evaluationForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const evaluationName = document.getElementById('evaluationName').value.trim();
            const evaluationDate = document.getElementById('evaluationDate').value;
            const evaluationType = document.getElementById('evaluationType').value;
            const evaluationResults = document.getElementById('evaluationResults').value.trim();

            if(evaluationName === '' || evaluationDate === '' || evaluationType === '' || evaluationResults === ''){
                showToast('Erro', 'Preencha todos os campos para criar a avaliação.');
                return;
            }

            const isEditing = this.getAttribute('data-editing');
            let newEvalId;

            if(isEditing){
                // Edição de avaliação
                newEvalId = isEditing;
                // Atualizar a avaliação no array (simulação)
                const evalIndex = allEvaluations.findIndex(eval => eval.id === newEvalId);
                if(evalIndex !== -1){
                    allEvaluations[evalIndex].name = evaluationName;
                    allEvaluations[evalIndex].date = evaluationDate;
                    allEvaluations[evalIndex].type = evaluationType;
                    allEvaluations[evalIndex].results = evaluationResults;

                    // Atualizar o card no DOM
                    const cards = document.querySelectorAll('.evaluation-card');
                    cards.forEach(card => {
                        if(card.innerHTML.includes(newEvalId)){
                            card.querySelector('.evaluation-header h5').textContent = evaluationName;
                            card.querySelector('.badge').className = `badge badge-${evaluationType === 'inicial' ? 'info' : 'warning'}`;
                            card.querySelector('.badge').textContent = evaluationType === 'inicial' ? 'Inicial' : 'Reavaliação';
                            card.querySelector('.evaluation-info p:nth-child(1)').innerHTML = `<strong>ID Avaliação:</strong> ${newEvalId}`;
                            card.querySelector('.evaluation-info p:nth-child(2)').innerHTML = `<strong>Data da Avaliação:</strong> ${formatDate(evaluationDate)}`;
                            card.querySelector('.evaluation-info p:nth-child(3)').innerHTML = `<strong>Resultados:</strong> ${evaluationResults}`;
                        }
                    });

                    showToast('Sucesso', 'Avaliação atualizada com sucesso!');
                }

                // Resetar o formulário e o modal
                this.reset();
                this.removeAttribute('data-editing');
                document.getElementById('createEvaluationModalLabel').textContent = 'Nova Avaliação';
                document.querySelector('#evaluationForm .modal-footer button[type="submit"]').innerHTML = '<i class="fas fa-save"></i> Criar Avaliação';
            } else {
                // Criação de nova avaliação
                newEvalId = 'AV' + (allEvaluations.length + 1).toString().padStart(3,'0');
                const selectedChildId = document.getElementById('selectChild').value;

                // Adicionar a nova avaliação no array (simulação)
                const newEvaluation = {
                    id: newEvalId,
                    child_id: selectedChildId,
                    name: evaluationName,
                    type: evaluationType,
                    date: evaluationDate,
                    results: evaluationResults
                };
                allEvaluations.push(newEvaluation);

                // Criar novo card de avaliação no DOM
                const evaluationsContainer = document.getElementById('evaluationsContainer');
                const card = document.createElement('div');
                card.className = 'evaluation-card';
                card.innerHTML = `
                    <div class="evaluation-header">
                        <h5>${evaluationName}</h5>
                        <span class="badge badge-${evaluationType === 'inicial' ? 'info' : 'warning'}">${evaluationType === 'inicial' ? 'Inicial' : 'Reavaliação'}</span>
                    </div>
                    <div class="evaluation-info">
                        <p><strong>ID Avaliação:</strong> ${newEvalId}</p>
                        <p><strong>Data da Avaliação:</strong> ${formatDate(evaluationDate)}</p>
                        <p><strong>Resultados:</strong> ${evaluationResults}</p>
                    </div>
                    <div class="evaluation-actions">
                        <button class="action-btn" onclick="accessEvaluation('${newEvalId}')"><i class="fas fa-arrow-right"></i> Acessar</button>
                        <button class="action-btn" onclick="editEvaluation('${newEvalId}')"><i class="fas fa-edit"></i> Editar</button>
                        <button class="action-btn" onclick="deleteEvaluation('${newEvalId}')"><i class="fas fa-trash-alt"></i> Excluir</button>
                    </div>
                `;
                evaluationsContainer.appendChild(card);

                showToast('Sucesso', 'Nova avaliação criada com sucesso!');

                // Fechar o modal e resetar o formulário
                $('#createEvaluationModal').modal('hide');
                this.reset();
            }
        });

        // Função para deletar avaliação
        function deleteEvaluation(evalId) {
            if(confirm('Tem certeza que deseja excluir a avaliação ' + evalId + '?')) {
                // Remover a avaliação do array (simulação)
                const evalIndex = allEvaluations.findIndex(eval => eval.id === evalId);
                if(evalIndex !== -1){
                    allEvaluations.splice(evalIndex, 1);

                    // Remover o card do DOM
                    const cards = document.querySelectorAll('.evaluation-card');
                    cards.forEach(card => {
                        if(card.innerHTML.includes(evalId)){
                            card.remove();
                        }
                    });

                    showToast('Avaliação Excluída', 'A avaliação foi excluída com sucesso.');
                }
            }
        }

        // Função para acessar uma avaliação específica
        function accessEvaluation(evalId) {
            // Redirecionar para a página de detalhes da avaliação
            window.location.href = 'pagina-avaliacao.php?evalId=' + evalId;
        }

        // Função para mostrar toasts de notificações
        function showToast(title, message) {
            const toastContainer = document.querySelector('.toast-container');
            const toastId = 'toast' + Date.now();

            const toastHTML = `
                <div class="toast" id="${toastId}" role="alert" aria-live="assertive" aria-atomic="true" data-delay="3000">
                    <div class="toast-header">
                        <strong class="mr-auto text-success">${title}</strong>
                        <small>Agora</small>
                        <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Fechar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="toast-body">
                        ${message}
                    </div>
                </div>
            `;

            toastContainer.innerHTML += toastHTML;
            $('#' + toastId).toast('show');

            // Remover o toast do DOM após ocultar
            $('#' + toastId).on('hidden.bs.toast', function () {
                this.remove();
            });
        }

        // Função para filtrar avaliações
        function filterEvaluations() {
            const searchTerm = document.getElementById('evalSearchInput').value.trim().toLowerCase();
            const filterYear = document.getElementById('evalFilterDate').value;
            const filterType = document.getElementById('evalFilterType').value;

            const cards = document.querySelectorAll('.evaluation-card');
            cards.forEach(card => {
                const evalName = card.querySelector('.evaluation-header h5').textContent.toLowerCase();
                const evalDateText = card.querySelector('.evaluation-info p:nth-child(2)').textContent.replace('Data da Avaliação:', '').trim();
                const evalDate = new Date(evalDateText);
                const evalYear = evalDate.getFullYear().toString();

                const badge = card.querySelector('.evaluation-header .badge');
                let evalType = '';
                if(badge) {
                    evalType = badge.textContent.trim().toLowerCase() === 'inicial' ? 'inicial' : 'reavaliacao';
                }

                const matchesSearch = evalName.includes(searchTerm);
                const matchesYear = filterYear === '' || evalYear === filterYear;
                const matchesType = filterType === '' || evalType === filterType;

                if(matchesSearch && matchesYear && matchesType) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        }

        // Evento para pesquisar
        document.getElementById('evalSearchBtn').addEventListener('click', filterEvaluations);

        // Evento para resetar filtros
        document.getElementById('evalResetBtn').addEventListener('click', () => {
            document.getElementById('evalSearchInput').value = '';
            document.getElementById('evalFilterDate').value = '';
            document.getElementById('evalFilterType').value = '';
            filterEvaluations();
        });
    </script>
</body>
</html>
