<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Processa Avaliação - Sistema Coralina Matos</title>
  <style>
    /* Reset */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Arial', sans-serif;
      background: linear-gradient(to bottom right, #08CA9D, #234EA1);
      color: #333;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      overflow: hidden;
    }

    .container {
      width: 100%;
      max-width: 420px;
      background: #ffffff;
      border-radius: 10px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
      padding: 40px 30px;
      text-align: center;
      animation: fadeIn 1s ease-in-out;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .logo img {
      width: 80px;
      margin-bottom: 20px;
    }

    h1 {
      font-size: 1.8rem;
      font-weight: bold;
      color: #234EA1;
      margin-bottom: 10px;
    }

    p.subheading {
      font-size: 1rem;
      color: #555;
      margin-bottom: 30px;
    }

    .form-group {
      margin-bottom: 15px;
      text-align: left;
    }

    .form-group label {
      font-size: 0.9rem;
      color: #555;
      display: block;
      margin-bottom: 5px;
    }

    .form-group input {
      width: 100%;
      padding: 12px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 1rem;
      background: #f9f9f9;
      transition: all 0.3s ease;
    }

    .form-group input:focus {
      border-color: #08CA9D;
      background: #fff;
      outline: none;
      box-shadow: 0 0 5px rgba(8, 202, 157, 0.5);
    }

    .btn-primary {
      width: 100%;
      padding: 12px;
      background: linear-gradient(to right, #08CA9D, #234EA1);
      border: none;
      color: white;
      font-size: 1rem;
      font-weight: bold;
      border-radius: 5px;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .btn-primary:hover {
      background: linear-gradient(to right, #06b487, #1e3f8c);
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
    }

    .link {
      display: block;
      margin-top: 15px;
      font-size: 0.9rem;
      color: #08CA9D;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .link:hover {
      color: #234EA1;
      text-decoration: underline;
    }

    .footer {
      margin-top: 25px;
    }

    .footer p {
      font-size: 0.9rem;
      color: #555;
      margin-bottom: 10px;
    }

    .btn-secondary {
      padding: 10px 20px;
      border: 2px solid #08CA9D;
      color: #08CA9D;
      font-size: 0.9rem;
      border-radius: 5px;
      text-decoration: none;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .btn-secondary:hover {
      background: #08CA9D;
      color: white;
      box-shadow: 0 0 10px rgba(8, 202, 157, 0.5);
    }

    /* Mensagem de Erro */
    .error-message {
      color: #E53E3E;
      font-size: 0.9rem;
      margin-top: 10px;
    }

    /* Responsividade */
    @media(max-width: 768px) {
      .container {
        padding: 30px 20px;
      }

      h1 {
        font-size: 1.6rem;
      }

      .form-group input {
        padding: 10px;
      }

      .btn-primary {
        padding: 10px;
        font-size: 0.9rem;
      }

      .link {
        font-size: 0.8rem;
      }

      .btn-secondary {
        padding: 8px 16px;
        font-size: 0.8rem;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Logo -->
    <div class="logo">
      <img src="includes/logo.webp" alt="Sistema Coralina Matos">
    </div>

    <!-- Heading -->
    <h1>Inventário Portage</h1>
    <p class="subheading">Insira o ID da Avaliação e o Código para acessar o checklist.</p>

    <!-- Login Form -->
    <form id="processEvaluationForm">
      <div class="form-group">
        <label for="evalId">ID da Avaliação</label>
        <input type="text" id="evalId" placeholder="Ex: AV001" required>
      </div>
      <div class="form-group">
        <label for="code">Chave de acesso:</label>
        <input type="text" id="code" placeholder="Digite a chave" required>
      </div>
      <button type="submit" class="btn-primary">Acessar Avaliação</button>
      <div id="errorMessage" class="error-message"></div>
    </form>

    
  </div>

  <script>
    // Simulação de Avaliações Existentes
    const evaluations = {
      'AV001': 'GHI13579',
      'AV002': 'DEF67890',
      'AV003': 'ABC12345'
    };

    /**
     * Função para obter parâmetros da URL
     * @returns {URLSearchParams} Objeto URLSearchParams com os parâmetros da URL
     */
    function getURLParameters() {
      return new URLSearchParams(window.location.search);
    }

    /**
     * Função para mapear evalId para o caminho de redirecionamento
     * Exemplo: 'AV003' → 'av3'
     * @param {string} evalId - ID da Avaliação (ex: 'AV003')
     * @returns {string} - Caminho formatado (ex: 'av3')
     */
    function mapEvalIdToPath(evalId) {
      const numericPart = evalId.replace('AV', '');
      const numericValue = parseInt(numericPart, 10);
      return `av${numericValue}`;
    }

    /**
     * Função para validar as credenciais e redirecionar o usuário
     * @param {string} evalId - ID da Avaliação
     * @param {string} code - Código da Avaliação
     */
    function validateAndRedirect(evalId, code) {
      const errorMessage = document.getElementById('errorMessage');

      // Limpar mensagem de erro anterior
      errorMessage.textContent = '';

      // Verificar se o evalId existe
      if(evaluations.hasOwnProperty(evalId)) {
        // Verificar se o código está correto
        if(evaluations[evalId] === code) {
          // Mapear evalId para caminho
          const path = mapEvalIdToPath(evalId);
          // Construir a URL de redirecionamento
          const checklistURL = `painel-clinica-perfil-criança-portage-novo-url.php`;
          // Redirecionar para a página de avaliação
          window.location.href = checklistURL;
        } else {
          // Código incorreto
          errorMessage.textContent = 'Código incorreto. Por favor, verifique os dados e tente novamente.';
        }
      } else {
        // evalId não encontrado
        errorMessage.textContent = 'ID da Avaliação não encontrado. Por favor, verifique os dados e tente novamente.';
      }
    }

    /**
     * Função para preencher automaticamente o campo evalId se o parâmetro estiver presente na URL
     * E redirecionar automaticamente se os parâmetros evalId e password estiverem presentes e corretos
     */
    function prefillAndRedirect() {
      const urlParams = getURLParameters();
      const evalIdFromURL = urlParams.get('evalId');
      const passwordFromURL = urlParams.get('password');
      
      if (evalIdFromURL) {
        const evalIdInput = document.getElementById('evalId');
        evalIdInput.value = evalIdFromURL;

        // Se a senha também estiver presente, preenche e tenta redirecionar
        if (passwordFromURL) {
          const codeInput = document.getElementById('code');
          codeInput.value = passwordFromURL;

          // Validar automaticamente e redirecionar se válido
          validateAndRedirect(evalIdFromURL, passwordFromURL);
        } else {
          // Opcional: Focar no campo "Código" para melhorar a usabilidade
          document.getElementById('code').focus();
        }
      }
    }

    /**
     * Função para validar e processar a avaliação ao submeter o formulário
     * @param {Event} e - Evento de submissão do formulário
     */
    function processEvaluation(e) {
      e.preventDefault();

      const evalIdInput = document.getElementById('evalId').value.trim();
      const codeInput = document.getElementById('code').value.trim();
      const errorMessage = document.getElementById('errorMessage');

      // Limpar mensagem de erro anterior
      errorMessage.textContent = '';

      // Validar e redirecionar
      validateAndRedirect(evalIdInput, codeInput);
    }

    // Inicializar a página
    document.addEventListener('DOMContentLoaded', () => {
      prefillAndRedirect();
      document.getElementById('processEvaluationForm').addEventListener('submit', processEvaluation);
    });
  </script>
</body>
</html>
