<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Inventário PORTAGE - Sistema IFCora</title>
    <!-- Fonte e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- <link rel="stylesheet" href="css/global.css"> -->
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
            color: #2d3748;
        }

        .container {
            margin-top: 60px;
            margin-left: 220px;
            padding: 20px;
            min-width: 1300PX;
        }

        /* Estilos das Abas Principais */
        .nav-tabs .nav-link {
            font-weight: 600;
            color: #4a5568;
            transition: color 0.3s, border-bottom 0.3s;
        }

        .nav-tabs .nav-link:hover {
            color: #08C89E;
        }

        .nav-tabs .nav-link.active {
            color: #08C89E !important;
            border-bottom: 3px solid #08C89E !important;
            font-weight: 600;
            
        }

        .tab-content {
            padding: 20px;
            border: 1px solid #e2e8f0;
            border-top: none;
            background: #fff;
            border-radius: 0 0 8px 8px;
        }

        .nested-tab-content {
            padding-top: 20px;
        }

        /* Cabeçalho e separação visual */
        h3, h4 {
            color: #08C89E;
            margin-bottom: 15px;
        }

        hr {
            margin: 20px 0;
            border: none;
            border-top: 1px solid #e2e8f0;
        }

        /* Ajustes para as seções */
        .data-section {
            margin-bottom: 20px;
        }

        .data-section label {
            font-weight: 600;
            margin-bottom: 5px;
            display: block;
        }

        .data-section input,
        .data-section select,
        .data-section textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            font-size: 14px;
            color: #2d3748;
            margin-bottom: 15px;
        }

        .data-section textarea {
            resize: vertical;
        }

        /* Tabelas de dados */
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
            color: #4a5568;
            margin-bottom: 20px;
        }

        table th, table td {
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            vertical-align: middle;
        }

        table th {
            background: #f7fafc;
            color: #2d3748;
            font-weight: 600;
            text-align: center;
        }

        tr:hover td {
            background: #f1f5f9;
        }

        /* Estilos para títulos e descrições das habilidades */
        .checkbox-title {
            font-weight: 600;
        }

        .skill-description {
            font-size: 13px;
            color: #4a5568;
        }

        .age-hint {
            font-size: 12px;
            color: #718096;
        }

        /* Estilos para respostas (Sim, AV, Não, X) */
        .skill-actions .form-check {
            display: inline-block;
            margin-right: 10px;
        }

        .skill-actions .form-check-input {
            margin-top: 0.3rem;
            margin-left: 0.3rem;
        }

        
        
        .tabela-planilha {
            border-collapse: collapse;
            width: 100%;
            text-align: center;
        }
        .tabela-planilha th, .tabela-planilha td {
            border: 1px solid black;
            padding: 0px 5px;
            font-size: 11px;
            white-space: nowrap;
            overflow: hidden; 
            text-overflow: ellipsis;
            max-width: 200px;
        }
        
        
        
        
        
        .custom-checkbox {
            /* Ocultar o checkbox padrão */
            position: relative;
            cursor: pointer;
            transition: background-color 0.3s, border-color 0.3s;
            vertical-align: middle; /* Alinhar verticalmente com o texto */
            margin-right: 3px;
        }
        
        .titulo-cabecalho {
            font-weight: bold;
        }
        .titulo-centralizado {
            font-size: 18px;
            font-weight: bold;
        }
        
        /* Seção de Avaliações */
        .checklist-avaliacoes-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap; /* Responsivo para telas menores */
            margin-bottom: 20px;
        }

        .checklist-left-section {
            display: flex;
            align-items: center;
            gap: 10px; /* Espaçamento entre os elementos */
            flex-wrap: wrap; /* Responsivo para telas menores */
            min-width: 500px;
        }

        .checklist-editar-btn {
            background-color: #3182ce; /* Azul */
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
        }

        .checklist-editar-btn:hover {
            background-color: #2c5282;
        }

        .checklist-avaliacao-select {
            min-width: 200px;
            max-width: 350px;
        }

        .checklist-criar-novo-btn {
            background-color: #38a169; /* Verde */
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
        }

        .checklist-criar-novo-btn:hover {
            background-color: #2f855a;
        }

        
        /* Estilo para estado de edição */
        .editing .checklist-avaliacao-select,
        .editing .checklist-editar-btn {
            pointer-events: none;
            opacity: 0.6;
        }

        /* Botão Salvar e Cancelar */
        .action-buttons {
            display: none;
            gap: 10px;
        }

        .editing .action-buttons {
            display: flex;
        }

        .checklist-salvar-btn,
        .checklist-cancelar-btn {
            background-color: #38a169; /* Verde para salvar */
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
        }

        .checklist-salvar-btn:hover {
            background-color: #2f855a;
        }

        .checklist-cancelar-btn {
            background-color: #e53e3e; /* Vermelho para cancelar */
        }

        .checklist-cancelar-btn:hover {
            background-color: #c53030;
        }
    </style>
</head>
<body>
    <!-- Cabeçalho e Sidebar padrão do sistema (já incluídos em outros arquivos, caso necessário) -->
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-clinica-crianças.php'; ?>

    <div class="container">
        <div class="panel">
            <div class="panel-body">

                <!-- Abas Principais -->
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="ficha-tab" href="#ficha" data-toggle="tab" role="tab" aria-controls="ficha" aria-selected="true">Ficha</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="checklist-tab" href="#checklist" data-toggle="tab" role="tab" aria-controls="checklist" aria-selected="false">Portage</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="esferas-tab" href="#esferas" data-toggle="tab" role="tab" aria-controls="esferas" aria-selected="false">Gráficos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="calculo-tab" href="#calculo" data-toggle="tab" role="tab" aria-controls="calculo" aria-selected="false">Cálculo de Desenvolvimento</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="plano-tab" href="#plano" data-toggle="tab" role="tab" aria-controls="plano" aria-selected="false">Plano</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="coleta-tab" href="#coleta" data-toggle="tab" role="tab" aria-controls="coleta" aria-selected="false">Coleta de Dados</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="notas-tab" href="#notas" data-toggle="tab" role="tab" aria-controls="notas" aria-selected="false">Notas</a>
                    </li>
                </ul>

                <div class="tab-content">
                    <!-- Aba Ficha -->
                    <div id="ficha" class="tab-pane fade show active" role="tabpanel" aria-labelledby="ficha-tab">
                        <h3>Ficha</h3>
                        <!-- Modelo de dados no HTML -->
                        <div class="data-section">
                            <label for="nomeC">Nome da Criança</label>
                            <input type="text" id="nomeC" value="João da Silva">

                            <label for="dataNasc">Data de Nascimento</label>
                            <input type="date" id="dataNasc" value="2018-05-20">

                            <label for="responsavel">Responsável</label>
                            <input type="text" id="responsavel" value="Maria da Silva">

                            <label for="observacoes">Anamnese</label>
                            <textarea id="anamnese_texto" name="anamnese_texto" rows="20" readonly="true">Anamnese do Paciente: João Silva

1. Identificação da Criança:
   - Data de Nascimento: 2015-05-20
   - Idade Atual: 8 anos
   - Sexo: Masculino
   - Responsáveis: Maria Silva (mãe) - (11) 99999-9999; Pedro Silva (pai) - (11) 98888-8888

2. Histórico Familiar:
   - Composição Familiar: Maria Silva, 35 anos, mãe; Pedro Silva, 37 anos, pai; Ana Silva, 10 anos, irmã
   - Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes? Sim
   - Detalhes: Maria Silva, mãe, possui diagnóstico de transtorno de déficit de atenção e hiperatividade (TDAH).

3. Histórico Gestacional e Neonatal:
   - Gestação foi planejada? Sim
   - Complicações durante a gravidez: Nenhuma complicação significativa.
   - Tipo de Parto: Normal
   - Quantas semanas de gestação? 39 semanas
   - A criança necessitou de cuidados especiais ao nascer? Não

4. Histórico Médico e Saúde Geral:
   - Diagnóstico Médico Atual: Nenhum diagnóstico médico atual.
   - Internações ou Cirurgias: Não.
   - Uso de Medicação Contínua: Não.

5. Rotina e Ambiente:
   - Principal Cuidador: Maria Silva (mãe)
   - Frequência na Escola ou Creche: Sim
   - Nome da Instituição e Período: Escola Infantil ABC, período da manhã.
   - Exposição a Fatores Estressantes no Ambiente Familiar: Não há exposição a fatores estressantes significativos.

6. Histórico Escolar:
   - Comportamento na Escola ou Creche: João é participativo e interage bem com os colegas.
   - Preocupações Sinalizadas pela Instituição: A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.

7. Motivo da Avaliação:
   - Motivo da Busca por Avaliação: Preocupação com a dificuldade de atenção e concentração.
   - Preocupações Específicas com o Comportamento ou Desenvolvimento: Dificuldade em concluir tarefas que exigem foco por mais tempo.

8. Observações Adicionais:
   - João tem demonstrado interesse em esportes e atividades ao ar livre.
                        </textarea>
                        </div>
                    </div>

                    <!-- Aba Checklist -->
                    <div id="checklist" class="tab-pane fade" role="tabpanel" aria-labelledby="checklist-tab">
                        <!-- <h3>Checklist do Inventário PORTAGE</h3> -->
                        <p style="margin-top:-15px">Abaixo estão divididas as habilidades por áreas de desenvolvimento e faixas etárias.</p>
                        
                        <!-- Seção de Gerenciamento de Avaliações -->
                        <div class="checklist-avaliacoes-container">
                            <div class="checklist-left-section">
                                
                                <select class="form-control checklist-avaliacao-select">
                                    <option value="0: 27490">Atual: 28/06/2024 Cod. 27490</option>
                                    <option value="1: 26263">Anterior: 05/02/2024 Cod. 26263</option>
                                    <option value="2: 25198">Anterior: 03/10/2023 Cod. 25198</option>
                                    <option value="3: 23583">Anterior: 11/05/2023 Cod. 23583</option>
                                    <option value="4: 22306">Anterior: 27/01/2023 Cod. 22306</option>
                                    <option value="5: 20733">Anterior: 28/09/2022 Cod. 20733</option>
                                    <option value="6: 19078">Anterior: 17/06/2022 Cod. 19078</option>
                                    <option value="7: 16912">Anterior: 08/02/2022 Cod. 16912</option>
                                    <option value="8: 14482">Anterior: 17/09/2021 Cod. 14482</option>
                                    <option value="9: 12432">Anterior: 07/06/2021 Cod. 12432</option>
                                </select>
                                <button type="button" class="btn btn-primary checklist-editar-btn" id="editarBtn">Editar</button>
                            </div>
                            <div class="action-buttons">
                                <button type="button" class="checklist-salvar-btn" id="salvarBtn">Salvar</button>
                                <button type="button" class="checklist-cancelar-btn" id="cancelarBtn">Cancelar</button>
                            </div>
                        </div>
                        
                        <!-- Abas de áreas de desenvolvimento -->
                        <ul class="nav nav-tabs" id="areaTabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="social-tab" href="#social" data-toggle="tab" role="tab" aria-controls="social" aria-selected="false"><i class="fa-solid fa-users"></i> Socialização</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="cognicao-tab" href="#cognicao" data-toggle="tab" role="tab" aria-controls="cognicao" aria-selected="false"><i class="fa-solid fa-brain"></i> Cognição</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="linguagem-tab" href="#linguagem" data-toggle="tab" role="tab" aria-controls="linguagem" aria-selected="false"><i class="fa-solid fa-comment-dots"></i> Linguagem</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="autocuidado-tab" href="#autocuidado" data-toggle="tab" role="tab" aria-controls="autocuidado" aria-selected="false"><i class="fa-solid fa-tooth"></i> Autocuidado</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="motor-tab" href="#motor" data-toggle="tab" role="tab" aria-controls="motor" aria-selected="true"><i class="fa-solid fa-running"></i> Desenvolvimento Motor</a>
                            </li>
                        </ul>

                        <div class="tab-content nested-tab-content">
                            <?php include 'ch_portage.php'; ?>
                        </div>
                    </div>

                    <!-- Aba Esferas -->
                    <div id="esferas" class="tab-pane fade" role="tabpanel" aria-labelledby="esferas-tab">
                        <h3>Representação das Esferas</h3>
                        <p>Gráficos e indicadores sobre o desenvolvimento da criança (Exemplo de dados):</p>
                        <table>
                            <thead>
                                <tr>
                                    <th>Área</th>
                                    <th>Índice de Desenvolvimento</th>
                                    <th>Data da Avaliação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Social</td>
                                    <td>85%</td>
                                    <td>20/05/2023</td>
                                </tr>
                                <tr>
                                    <td>Linguagem</td>
                                    <td>78%</td>
                                    <td>20/05/2023</td>
                                </tr>
                                <tr>
                                    <td>Motor</td>
                                    <td>90%</td>
                                    <td>20/05/2023</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Aba Cálculo de Desenvolvimento -->
                    <div id="calculo" class="tab-pane fade" role="tabpanel" aria-labelledby="calculo-tab">
                        <h3>Cálculo de Desenvolvimento</h3>
                        <p>Matriz de cálculo do estágio de desenvolvimento:</p>
                        <table>
                            <thead>
                                <tr>
                                    <th>Habilidade</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Reconhece o próprio nome</td>
                                    <td>Concluída</td>
                                </tr>
                                <tr>
                                    <td>Anda sem apoio</td>
                                    <td>Em Avaliação</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Aba Plano -->
                    <div id="plano" class="tab-pane fade" role="tabpanel" aria-labelledby="plano-tab">
                        <h3>Plano</h3>
                        <p>Definição de estratégias para potencializar o desenvolvimento:</p>
                        <div class="data-section">
                            <label for="objetivos">Objetivos:</label>
                            <textarea id="objetivos" rows="3" placeholder="Descreva os objetivos do plano..."></textarea>

                            <label for="acoes">Ações:</label>
                            <textarea id="acoes" rows="3" placeholder="Descreva as ações a serem tomadas..."></textarea>

                            <label for="responsaveisPlano">Responsáveis:</label>
                            <input type="text" id="responsaveisPlano" value="Terapeuta e Responsável">

                            <label for="prazoPlano">Prazo:</label>
                            <input type="date" id="prazoPlano" value="2023-12-31">

                            <button class="btn btn-success">Salvar Plano</button>
                        </div>
                    </div>

                    <!-- Aba Coleta de Dados -->
                    <div id="coleta" class="tab-pane fade" role="tabpanel" aria-labelledby="coleta-tab">
                        <h3>Coleta de Dados</h3>
                        <p>Registros periódicos do progresso:</p>
                        <table>
                            <thead>
                                <tr>
                                    <th>Data</th>
                                    <th>Observações</th>
                                    <th>Avaliado por</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>10/06/2023</td>
                                    <td>Avanço significativo na fala</td>
                                    <td>Fonoaudióloga</td>
                                </tr>
                                <tr>
                                    <td>25/06/2023</td>
                                    <td>Maior coordenação ao segurar objetos</td>
                                    <td>Terapeuta Ocupacional</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Aba Notas -->
                    <div id="notas" class="tab-pane fade" role="tabpanel" aria-labelledby="notas-tab">
                        <h3>Notas</h3>
                        <textarea class="form-control" rows="5" placeholder="Insira suas notas aqui..."></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Scripts Bootstrap -->
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

        <!-- Script para Gerenciar Respostas das Habilidades -->
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const editarBtn = document.getElementById('editarBtn');
                const salvarBtn = document.getElementById('salvarBtn');
                const cancelarBtn = document.getElementById('cancelarBtn');
                const checklistContainer = document.querySelector('.checklist-avaliacoes-container');
                const checklistContent = document.querySelector('#checklist');

                let isEditing = false;

                // Função para habilitar/desabilitar radio buttons
                function toggleEditing(edit) {
                    const radios = checklistContent.querySelectorAll('input[type="radio"]');
                    radios.forEach(radio => {
                        radio.disabled = !edit;
                    });

                    if (edit) {
                        checklistContainer.classList.add('editing');
                        editarBtn.style.display = 'none';
                        document.querySelector('.action-buttons').style.display = 'flex';
                    } else {
                        checklistContainer.classList.remove('editing');
                        editarBtn.style.display = 'block';
                        document.querySelector('.action-buttons').style.display = 'none';
                    }
                }

                // Carregar respostas salvas do localStorage
                function carregarRespostas() {
                    const respostas = JSON.parse(localStorage.getItem('avaliacaoAtual')) || {};

                    const radios = checklistContent.querySelectorAll('input[type="radio"]');
                    radios.forEach(radio => {
                        if (respostas[radio.name] === radio.value) {
                            radio.checked = true;
                        } else {
                            radio.checked = false;
                        }
                    });
                }

                // Salvar respostas no localStorage
                function salvarRespostas() {
                    const respostas = {};
                    const radios = checklistContent.querySelectorAll('input[type="radio"]');
                    radios.forEach(radio => {
                        if (radio.checked) {
                            respostas[radio.name] = radio.value;
                        }
                    });

                    localStorage.setItem('avaliacaoAtual', JSON.stringify(respostas));
                }

                // Evento do botão Editar
                editarBtn.addEventListener('click', () => {
                    isEditing = true;
                    toggleEditing(true);
                });

                // Evento do botão Salvar
                salvarBtn.addEventListener('click', () => {
                    salvarRespostas();
                    isEditing = false;
                    toggleEditing(false);
                    alert('Respostas salvas com sucesso!');
                });

                // Evento do botão Cancelar
                cancelarBtn.addEventListener('click', () => {
                    carregarRespostas();
                    isEditing = false;
                    toggleEditing(false);
                    alert('Edição cancelada.');
                });

                // Inicializar checklist como não editável
                toggleEditing(false);
                carregarRespostas();

                // Função para salvar as respostas das habilidades
                const checklistTabs = document.querySelectorAll('#checklist .tab-content .tab-pane');

                checklistTabs.forEach(tab => {
                    const radios = tab.querySelectorAll('input[type="radio"]');
                    radios.forEach(radio => {
                        radio.addEventListener('change', (e) => {
                            const habilidade = e.target.name;
                            const resposta = e.target.value.toUpperCase();
                            console.log(`Habilidade: ${habilidade}, Resposta: ${resposta}`);
                            // Aqui você pode adicionar lógica para salvar as respostas no backend ou localmente
                        });
                    });
                });

                // Função para salvar Plano
                const planoButton = document.querySelector('#plano button');
                planoButton.addEventListener('click', () => {
                    const objetivos = document.getElementById('objetivos').value.trim();
                    const acoes = document.getElementById('acoes').value.trim();
                    const responsaveis = document.getElementById('responsaveisPlano').value.trim();
                    const prazo = document.getElementById('prazoPlano').value;

                    if(objetivos === '' || acoes === '' || responsaveis === '' || prazo === '') {
                        alert('Por favor, preencha todos os campos do plano.');
                        return;
                    }

                    // Lógica para salvar o plano (ex: enviar para o backend)
                    alert('Plano salvo com sucesso!');
                    // Resetar os campos após salvar
                    document.getElementById('objetivos').value = '';
                    document.getElementById('acoes').value = '';
                    document.getElementById('responsaveisPlano').value = '';
                    document.getElementById('prazoPlano').value = '';
                });

                // Função para salvar Informações do Paciente (ficha)
                const fichaForm = document.querySelector('#ficha .data-section');
                fichaForm.addEventListener('change', () => {
                    // Lógica para salvar as informações da ficha
                    console.log('Informações da ficha atualizadas');
                    // Exemplo: Enviar dados para o backend
                });
            });
        </script>
    </div>
</body>
</html>
