<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Informações da Criança */
        .child-info {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 0px 15px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
        }
        .child-info img {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
            object-fit: cover;
        }
        .child-info div {
            font-size: 16px;
        }
        .child-info div p {
            margin-bottom: 5px;
            color: #2d3748;
        }
        /* Histórico de Avaliações */
        .history {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .history h2 {
            font-size: 22px;
            color: #08C89E;
            margin-bottom: 15px;
        }
        .history table {
            width: 100%;
            border-collapse: collapse;
        }
        .history th, .history td {
            text-align: left;
            padding: 0px 10px 0px 10px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 16px;
        }
        .history th {
            background-color: #f7fafc;
            color: #2d3748;
        }
        .history tr:first-child {
            background-color: #f0fff4; /* Destaque para o registro mais recente */
        }
        .history td a {
            color: #08C89E;
            text-decoration: underline;
            cursor: pointer;
        }
        /* Área de Anotações Clínicas */
        .clinical-records {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            display: none; /* Inicialmente oculta */
        }
        .clinical-records h2 {
            font-size: 24px;
            color: #08C89E;
            margin-bottom: 20px;
        }
        .clinical-records textarea {
            width: 97%;
            height: 300px;
            padding: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 16px;
            resize: vertical;
            transition: border-color 0.3s, box-shadow 0.3s, background-color 0.3s;
            background-color: #f5f5f5; /* Fundo padrão quando não está editando */
            margin-top: 10px;
        }
        .clinical-records textarea:focus {
            border-color: #08C89E;
            outline: none;
            box-shadow: 0 0 5px rgba(8, 202, 157, 0.5);
        }
        /* Botões de Ação */
        .form-actions {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-top: 20px;
        }
        .form-actions .action-buttons {
            gap: 10px;
            display: flex;
            justify-content: space-between;
            width: 100%; /* ou a largura que você deseja para a div */
            
        }
        /* Alteração: Botão "Cancelar" à esquerda */
        .form-actions .action-buttons .cancel-button {
            order: 1; /* Primeiro na ordem */
            background-color: #e53e3e;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }
        .form-actions .action-buttons .cancel-button:hover {
            background-color: #c53030;
        }
        .form-actions .action-buttons .save-button {
            order: 2; /* Segundo na ordem */
            background-color: #08C89E;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }
        .form-actions .action-buttons .save-button:hover {
            background-color: #06b287;
        }
        .form-actions .edit-button {
            background-color: #4A5568;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
            display: none; /* Inicialmente oculta */
        }
        .form-actions .edit-button:hover {
            background-color: #2d3748;
        }
        /* Botão Visualizar */
        .view-button {
            display: inline-block;
            color: #08C89E;
            padding: 2px 4px;
            border-radius: 8px;
            text-align: center;
            text-decoration: none;
            font-size: 14px;
            transition: background 0.3s, color 0.3s;
            cursor: pointer;
        }
        .remove-button {
            font-size: 14px;
            }
        }
        
        /* Estilos para o botão "Nova Avaliação" */
        .new-evaluation-button {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 10px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
            margin-bottom: 10px;
        }
        .new-evaluation-button:hover {
            background-color: #06b287;
        }
        /* Mensagens de Feedback */
        .success-message {
            color: #38A169;
            font-size: 0.9rem;
            margin-top: 10px;
        }
        .error-message {
            color: #E53E3E;
            font-size: 0.9rem;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <?php include 'includes/header1.php'; ?>
    <?php include 'includes/sidebar-rg-clinicos.php'; ?>

    <!-- Conteúdo Principal -->
    <main class="content">
        <div class="header-content">
            <!--  <h1>Registro de Avaliação</h1> -->
            <h1 style="color: #08C89E; margin-left: 15px"><i class="fa-solid fa-calendar-check" style="margin-right: 8px"></i>Registros Clinicos</h1>

        </div>
        <!-- Informações da Criança -->
        <!-- <div class="child-info">
            <img src="https://api.dicebear.com/6.x/pixel-art/svg?seed=avatar007" alt="Foto da Criança">

                <p ><b>Nome:</b> Luís Gustavo<b> - Idade:</b> 7 anos - <b>Data de Nascimento:</b> 20/05/2018 - <b> Responsável:</b> Maria da Silva</b></p>

            </div>
        </div> -->
        <!-- Histórico de Avaliações -->
        <div class="history" style="margin-top:0px;">
            <p style="margin-top:-10px; margin-bottom:15px">Registre e Acompanhe o Progresso das Avaliações: Sua Ferramenta para Monitoramento Efetivo</p>
            
            <button type="button" class="btn save" id="new-evaluation-button" > <i class="fa-solid fa-plus" style="margin-right: 8px"></i> Adicionar Registro</button>
            <hr />
            <table class="table-section">
                <thead>
                    <tr>
                        <th>ORD</th>
                        <th>Código</th>
                        <th>Data</th>
                        <th>Título</th>
                        <th>Ações</th>
                        <th>Remover</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>RCD003</td>
                        <td>10/02/2023</td>
                        <td>Resumo Aval. Sensorial</td>
                        <td>
                            <a href="#" class="view-button" data-eval-id="AV003" data-password="ABC12345">Visualizar</a>
                        </td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>RCA002</td>
                        <td>17/02/2024</td>
                        <td>Planejamento Terapêutico</td>
                        <td>
                            <a href="#" class="view-button" data-eval-id="AV002" data-password="DEF67890">Visualizar</a>
                        </td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>RCB001</td>
                        <td>18/02/2022</td>
                        <td>Revisão Metas Longo Prazo</td>
                        <td>
                            <a href="#" class="view-button" data-eval-id="AV001" data-password="GHI13579">Visualizar</a>
                        </td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <td>RCB001</td>
                        <td>18/02/2022</td>
                        <td>Revisão Metas Longo Prazo</td>
                        <td>
                            <a href="#" class="view-button" data-eval-id="AV001" data-password="GHI13579">Visualizar</a>
                        </td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <tr>
                        <td>5</td>
                        <td>RCB001</td>
                        <td>18/02/2022</td>
                        <td>Revisão Metas Longo Prazo</td>
                        <td>
                            <a href="#" class="view-button" data-eval-id="AV001" data-password="GHI13579">Visualizar</a>
                        </td>
                        <td><a href="#" class="remove-button">Remover</a></td>
                    </tr>
                    <!-- Outras avaliações podem ser listadas aqui -->
                </tbody>
            </table>
            
            <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
            
        </div>
        <!-- Botão "Nova Avaliação" -->
        <!-- Área de Anotações Clínicas -->
        <div class="clinical-records" id="clinical-records">
            <h2>Anotações Clínicas</h2>
            <form id="clinicalRecordsForm">
                <input type="text" class="icora-note-title" id="icora-noteTitle" placeholder="Título da anotação" style="background-color: rgb(245, 245, 245);" disabled="" value="Resumo Aval. Sensorial">
                <textarea id="clinicalNotes" placeholder="Digite suas anotações clínicas aqui..." required disabled></textarea>
                <div class="form-actions">
                    <!-- Botões de Ação -->
                    <div class="action-buttons">
                        <button type="button" class="cancel-button">Cancelar</button>
                        <button type="submit" class="save-button">Salvar</button>
                    </div>
                    <!-- Botão Editar -->
                    <button type="button" class="edit-button">Editar</button>
                </div>
            </form>
            <!-- Mensagem de Sucesso -->
            <div id="successMessage" class="success-message" style="display: none;">
                Anotações salvas com sucesso!
            </div>
            <!-- Mensagem de Erro -->
            <div id="saveErrorMessage" class="error-message"></div>
        </div>
    </main>

    

    <!-- Script para as funcionalidades -->
    <script>
        // Simulação de Avaliações Existentes com Anotações Estruturadas e Informações do Profissional
        const evaluations = {
            'AV001': {
                password: 'GHI13579',
                notes: `1. Observações clínicas:
- Desenvolvimento motor adequado.
- Resposta social positiva.
- Comportamento tranquilo durante a avaliação.

2. Orientações:
- Continuar monitorando o desenvolvimento social.
- Incentivar atividades físicas regulares.

3. Orientações à família:
- Participar de sessões de terapia familiar.
- Promover interações sociais com outras crianças.

4. Observações gerais:
- Nenhum indicativo de TEA no momento.
- Recomenda-se acompanhamento periódico.`,
                profissionalName: 'Dr. Pedro Silva',
                profissionalFormacao: 'Neurologista Pediátrico'
            },
            'AV002': {
                password: 'DEF67890',
                notes: `1. Observações clínicas:
- Dificuldade em manter contato visual.
- Respostas verbais limitadas.
- Comportamento repetitivo observado.

2. Orientações:
- Iniciar terapia comportamental.
- Monitorar progresso nas habilidades sociais.

3. Orientações à família:
- Participar de treinamentos para manejo comportamental.
- Criar um ambiente estruturado em casa.

4. Observações gerais:
- Indicativos de TEA de risco moderado.
- Recomenda-se avaliação especializada.`,
                profissionalName: 'Sra. Ana Costa',
                profissionalFormacao: 'Psicóloga Clínica'
            },
            'AV003': {
                password: 'ABC12345',
                notes: `1. Observações clínicas:
- Excelente desenvolvimento cognitivo.
- Habilidades motoras finas e grossas dentro do esperado.
- Interação social limitada com colegas.

2. Orientações:
- Incentivar participação em atividades de grupo.
- Desenvolver habilidades de comunicação.

3. Orientações à família:
- Estimular brincadeiras cooperativas.
- Acompanhar e reforçar interações sociais.

4. Observações gerais:
- Baixo risco de TEA.
- Recomenda-se continuar acompanhamento regular.`,
                profissionalName: 'Dr. João Pereira',
                profissionalFormacao: 'Psiquiatra Infantil'
            }
        };

        // Elementos do DOM
        const viewButtons = document.querySelectorAll('.view-button');
        const clinicalRecordsDiv = document.getElementById('clinical-records');
        const clinicalRecordsForm = document.getElementById('clinicalRecordsForm');
        const clinicalNotes = document.getElementById('clinicalNotes');
        const successMessage = document.getElementById('successMessage');
        const saveErrorMessage = document.getElementById('saveErrorMessage');
        const cancelButtons = document.querySelectorAll('.cancel-button');
        const editButtons = document.querySelectorAll('.edit-button');
        const newEvaluationButton = document.getElementById('new-evaluation-button');

        // Variáveis para armazenar o evalId e password atual
        let currentEvalId = null;
        let currentPassword = null;

        /**
         * Função para carregar as anotações no textarea
         * @param {string} evalId - ID da Avaliação
         * @param {string} password - Senha da Avaliação
         */
        function loadClinicalNotes(evalId, password) {
            // Limpar mensagens anteriores
            successMessage.style.display = 'none';
            saveErrorMessage.textContent = '';

            // Verificar se a avaliação existe
            if (evaluations.hasOwnProperty(evalId)) {
                // Verificar se a senha está correta
                if (evaluations[evalId].password === password) {
                    // Atualizar variáveis de estado
                    currentEvalId = evalId;
                    currentPassword = password;

                    // Carregar as anotações no textarea
                    clinicalNotes.value = evaluations[evalId].notes || '';

                    // Bloquear o textarea para edição
                    clinicalNotes.disabled = true;
                    // Restaurar o fundo padrão do textarea
                    clinicalNotes.style.backgroundColor = '#f5f5f5';

                    // Exibir a área de anotações
                    clinicalRecordsDiv.style.display = 'block';

                    // Mostrar ou esconder os botões de acordo com o estado de salvamento
                    // Agora, todas as ações são "Visualizar", portanto, sempre exibir o botão "Editar"
                    document.querySelector('.action-buttons').style.display = 'none';
                    document.querySelector('.edit-button').style.display = 'block';
                } else {
                    // Senha incorreta
                    alert('Senha incorreta para a Avaliação selecionada.');
                }
            } else {
                // Avaliação não encontrada
                alert('Avaliação não encontrada.');
            }
        }

        /**
         * Função para resetar o estado atual
         */
        function resetCurrentEval() {
            currentEvalId = null;
            currentPassword = null;
        }

        /**
         * Função para atualizar o evalId e password atuais
         * @param {HTMLElement} button - Botão clicado
         */
        function updateCurrentEval(button) {
            currentEvalId = button.getAttribute('data-eval-id');
            currentPassword = button.getAttribute('data-password');
        }

        // Adicionar eventos aos botões "Visualizar"
        viewButtons.forEach(button => {
            button.addEventListener('click', function(event) {
                event.preventDefault();
                updateCurrentEval(this);
                const evalId = this.getAttribute('data-eval-id');
                const password = this.getAttribute('data-password');
                loadClinicalNotes(evalId, password);
            });
        });

        // Botão "Nova Avaliação" abre uma nova área de anotações vazia com tópicos modelo
        newEvaluationButton.addEventListener('click', function() {
            // Preencher o textarea com os tópicos modelo
            const template = `1. Observações clínicas:
- 

2. Orientações 
- 

3. Orientações à família
- 

4. Observações gerais
- `;
            clinicalNotes.value = template;

            // Habilitar o textarea para edição
            clinicalNotes.disabled = false;
            // Mudar o fundo do textarea para branco
            clinicalNotes.style.backgroundColor = '#ffffff';

            // Exibir a área de anotações
            clinicalRecordsDiv.style.display = 'block';

            // Limpar mensagens de erro e sucesso
            successMessage.style.display = 'none';
            saveErrorMessage.textContent = '';

            // Resetar estado atual
            resetCurrentEval();

            // Mostrar os botões de ação para nova avaliação
            document.querySelector('.action-buttons').style.display = 'flex';
            document.querySelector('.edit-button').style.display = 'none';
        });

        // Formulário de Anotações Clínicas - Salvar
        clinicalRecordsForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const notes = clinicalNotes.value.trim();

            // Limpar mensagens anteriores
            successMessage.style.display = 'none';
            saveErrorMessage.textContent = '';

            if (notes === '') {
                saveErrorMessage.textContent = 'O campo de anotações não pode estar vazio.';
                return;
            }

            if (currentEvalId && currentPassword) {
                // Atualizar as anotações na simulação
                evaluations[currentEvalId].notes = notes;
                successMessage.style.display = 'block';
                // Atualizar os botões
                document.querySelector('.action-buttons').style.display = 'none';
                document.querySelector('.edit-button').style.display = 'block';
                // Bloquear novamente o textarea
                clinicalNotes.disabled = true;
                // Restaurar o fundo padrão do textarea
                clinicalNotes.style.backgroundColor = '#f5f5f5';
            } else {
                // Nova Avaliação
                // Aqui você pode implementar a lógica para salvar uma nova avaliação
                // Por exemplo, enviar os dados para o servidor via AJAX
                // Simulando o salvamento
                const newEvalId = `AV${Object.keys(evaluations).length + 1}`;
                evaluations[newEvalId] = {
                    password: 'NEWPASS123',
                    notes: notes,
                    profissionalName: 'Novo Profissional',
                    profissionalFormacao: 'Nova Formação'
                };
                successMessage.style.display = 'block';
                clinicalNotes.value = '';
                // Atualizar os botões
                document.querySelector('.action-buttons').style.display = 'none';
                document.querySelector('.edit-button').style.display = 'block';
                // Bloquear novamente o textarea
                clinicalNotes.disabled = true;
                // Restaurar o fundo padrão do textarea
                clinicalNotes.style.backgroundColor = '#f5f5f5';
                // Resetar estado atual
                resetCurrentEval();
                // Opcional: Atualizar a tabela de histórico de avaliações dinamicamente
                alert(`Nova Avaliação ${newEvalId} criada com sucesso!`);
            }
        });

        // Botão "Editar"
        editButtons.forEach(button => {
            button.addEventListener('click', function() {
                if (currentEvalId && currentPassword) {
                    // Desbloquear o textarea para edição
                    clinicalNotes.disabled = false;
                    // Mudar o fundo do textarea para branco
                    clinicalNotes.style.backgroundColor = '#ffffff';
                    // Mostrar os botões de ação (Cancelar e Salvar)
                    document.querySelector('.action-buttons').style.display = 'flex';
                    // Esconder o botão "Editar"
                    document.querySelector('.edit-button').style.display = 'none';
                }
            });
        });

        // Botão "Cancelar" - Limpar e ocultar a área de anotações
        cancelButtons.forEach(button => {
            button.addEventListener('click', function() {
                if (currentEvalId && currentPassword) {
                    // Recarregar as anotações originais
                    clinicalNotes.value = evaluations[currentEvalId].notes || '';
                    // Bloquear o textarea novamente
                    clinicalNotes.disabled = true;
                    // Restaurar o fundo padrão do textarea
                    clinicalNotes.style.backgroundColor = '#f5f5f5';
                    // Ocultar os botões de ação
                    document.querySelector('.action-buttons').style.display = 'none';
                    // Exibir o botão "Editar"
                    document.querySelector('.edit-button').style.display = 'block';
                } else {
                    // Se for uma nova avaliação, limpar e ocultar
                    clinicalNotes.value = '';
                    clinicalRecordsDiv.style.display = 'none';
                }
                // Limpar mensagens de erro e sucesso
                successMessage.style.display = 'none';
                saveErrorMessage.textContent = '';
                // Resetar estado atual se for uma nova avaliação
                if (!currentEvalId) {
                    resetCurrentEval();
                }
            });
        });

        // Modal para Visualizar Resultado
        const modal = document.getElementById('result-modal');
        const closeModal = document.getElementsByClassName('close')[0];
        const copyButton = document.getElementById('copy-button');

        // Fechar o modal ao clicar no "X"
        closeModal.onclick = function() {
            modal.style.display = 'none';
        }

        // Fechar o modal ao clicar fora dele
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        }

        // Copiar texto do modal
        copyButton.addEventListener('click', function() {
            const textToCopy = modal.querySelector('p').innerText;
            navigator.clipboard.writeText(textToCopy).then(function() {
                alert('Texto copiado para a área de transferência.');
            }, function() {
                alert('Erro ao copiar o texto.');
            });
        });
    </script>
</body>
</html>
