<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Profissionais - Registros Clínicos</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <!-- Inclua seus arquivos CSS existentes -->
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Estilos Adicionais para os Cards */

        main.content {
            padding: 20px;
            background-color: #f9fafb;
        }

        h1 {
            color: #08C89E;
            margin-bottom: 20px;
        }

        .cards-container {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        .card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            width: calc(25% - 20px); /* Ajuste conforme necessário */
            padding: 10px;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .card img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            object-fit: cover;
            margin-bottom: -10px;
        }

        .card h2 {
            font-size: 18px;
            color: #2d3748;
            margin-bottom: -10px;
            text-align: center;
        }

        .card p {
            font-size: 14px;
            color: #4a5568;
            text-align: center;
            margin-bottom: 0px;
        }

        

        .card .no-records {
            font-size: 14px;
            color: #718096;
            margin-bottom: 15px;
        }

        .card button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s;
            display: block;
        }

        .card button:hover {
            background-color: #06b287;
        }

    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-rg-clinicos.php'; ?>

    <!-- Conteúdo Principal -->
    <main class="content">
        <h1 style="margin-top: -30px; margin-bottom: -20px">Profissionais com Registros Clínicos</h1>
        <p>Lista de profissionais</p>
        <hr />
        <div class="cards-container" id="professionalsContainer">
            <!-- Cards dos profissionais -->
            <div class="card">
                <img src="https://api.dicebear.com/6.x/pixel-art/svg?seed=prof002" alt="Foto do profissional">
                <h2>Sra. Ana Costa</h2>
                <p>Psicóloga Clínica</p>
                <button onclick="window.location.href='painel-clinica-perfil-criança-registro-clinico.php?profId=prof002'">Acessar</button>
            </div>

            
        </div>
    </main>
</body>
</html>
