<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        .summary-section {
            background-color: #f1f5f9;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            margin-bottom: 20px;
            display: flex;
            flex-direction: column;
            gap: 15px;
            border: 1px solid #e2e8f0;
        }
        
        .summary-section h2 {
            font-size: 20px;
            color: #2d3748;
            margin-bottom: 10px;
        }

        /* Formulário de Aceitação de Convite de Parceira */
        #acceptPartnerInviteForm {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        #acceptPartnerInviteForm input[type="text"] {
            width: 150px;
            padding: 8px 16px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 16px;
        }
        
        /* Detalhes do Convite de Parceira */
        #parceirasInviteDetails {
            display: none;
            
        }
        
        .parceiras-action-buttons .btn:hover {
            /* As pseudo-classes já estão definidas nas classes existentes */
        }

        /* Status Cores */
        .status-pendente {
            color: #08C89E;
            font-weight: bold;
        }

        .status-aceito {
            color: #4A5568;
            font-weight: bold;
        }

        .status-encerrado {
            color: #FFA500; /* Laranja */
            font-weight: bold;
        }

        .status-expirado {
            color: #E53E3E; /* Vermelho */
            font-weight: bold;
        }

        /* Adicionando estilos para o formulário de perfil */
        #invitePerfil {
            padding: 8px 16px;
            border: 2px solid #08C89E;
            border-radius: 8px;
            font-size: 16px;
        }

        /* Modal Overlay */
.modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(0, 0, 0, 0.6);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    transition: opacity 0.3s ease;
}

/* Modal Container */
.modal-container {
    background-color: #ffffff;
    border-radius: 16px;
    padding: 24px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.2); /* Sombra mais suave */
    display: flex;
    flex-direction: column;
    gap: 16px;
    animation: fadeIn 0.3s ease;
    box-sizing: border-box;
    overflow: hidden;
}

/* Header */
.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-bottom: 8px;
    background-color: #08C89E; /* Fundo expandido */
    border-radius: 8px 8px 0 0; /* Arredonda apenas os cantos superiores */
    padding: 16px;
}

.modal-title h2 {
    font-size: 20px;
    font-weight: bold;
    color: #ffffff;
    margin: 0;
}

.btn-close {
    background: none;
    border: none;
    font-size: 20px;
    cursor: pointer;
    color: #ffffff;
}

.btn-close:hover {
    color: #e53e3e;
}

/* Form Fields */
.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

label {
    font-size: 14px;
    font-weight: bold;
    color: #2d3748;
}

/* Inputs */
input[type="text"], input[type="email"], input[type="number"], select {
    width: 100%;
    max-width: 100%;
    padding: 10px 14px;
    border: 1.5px solid #e2e8f0;
    border-radius: 8px;
    font-size: 14px;
    outline: none;
    transition: border-color 0.2s;
    box-sizing: border-box;
}

input:focus {
    border-color: #08C89E;
    box-shadow: 0 0 0 3px rgba(8, 200, 158, 0.2);
}

/* Footer */
.modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 12px;
    border-top: 1px solid #e2e8f0;
    padding-top: 12px;
}

.btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    cursor: pointer;
    border: none;
    transition: background-color 0.2s, transform 0.2s;
}

.btn.cancel {
    background-color: #edf2f7;
    color: #2d3748;
}

.btn.cancel:hover {
    background-color: #e2e8f0;
}

.btn.save {
    background-color: #08C89E;
    color: #ffffff;
}

.btn.save:hover {
    background-color: #06b287;
}

.btn:active {
    transform: scale(0.95);
}

/* Estilos para Botões Específicos no InviteModal */
.btn.create-invite {
    background-color: #48BB78; /* Verde para criar convite */
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 16px;
}

.btn.create-invite:hover {
    background-color: #38A169;
}

.btn.copy {
    background-color: #4299E1; /* Azul para copiar código */
    color: #fff;
    border: none;
    padding: 8px 16px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
}

.btn.copy:hover {
    background-color: #3182CE;
}


        .close-edit-perfil,
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            position: absolute;
            right: 20px;
            top: 10px;
            cursor: pointer;
        }

        .close-edit-perfil:hover,
        .close:hover,
        .close-edit-perfil:focus,
        .close:focus {
            color: black;
            text-decoration: none;
        }

        /* Estilos para os ícones na tabela */
        .action-icons {
            display: flex;
            align-items: center;
            gap: 8px; /* Espaçamento entre os ícones */
        }

        .action-icons button {
            background: transparent;
            border: none;
            cursor: pointer;
            padding: 4px; /* Redução do padding */
            font-size: 16px; /* Redução do tamanho dos ícones */
            color: #4A5568;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-icons button:last-child {
            margin-right: 0;
        }

        .action-icons button:hover {
            color: #08C89E;
        }

        .action-icons .icon-trash:hover {
            color: red;
        }

        /* Garantir que os ícones não ultrapassem o tamanho da célula */
        #professionalsTable td.action-icons,
        #inviteHistoryTable td.action-icons {
            white-space: nowrap;
            overflow: hidden;
        }

        /* Estilos para o Modal de Gerenciamento de Profissional */
        #manageProfessionalModal .modal-content {
            width: 500px; /* Mantido */
        }

        #manageProfessionalModal h2 {
            margin-bottom: 5px;
            color: #2d3748;
        }

        #manageProfessionalModal .prof-info {
            font-size: 14px;
            color: #4A5568;
        }

        #manageProfessionalModal .prof-info div {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        #manageProfessionalModal .modal-actions {
            margin-top: 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        #manageProfessionalModal .modal-actions .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            color: #fff;
        }

        #manageProfessionalModal .modal-actions .btn.save {
            background-color: #48BB78;
        }

        #manageProfessionalModal .modal-actions .btn#manageProfUnlinkButton {
            background-color: #ED8936; /* Laranja para Desvincular */
        }

        #manageProfessionalModal .modal-actions .btn.delete {
            background-color: #E53E3E;
        }

        #manageProfessionalModal .modal-actions .btn.cancel {
            background-color: #A0AEC0;
        }

        /* Estilização das Classes de Status */
        .status-ativo {
            color: #38A169; /* Verde para Ativo */
        }

        .status-desvinculado {
            color: #ED8936; /* Laranja para Desvinculado */
        }

        .status-inativo {
            color: #E53E3E; /* Vermelho para Inativo */
        }

        /* Melhorando os Ícones nos Botões */
        #manageProfessionalModal .modal-actions .btn i {
            margin-right: 5px;
        }
        
        
        /* Estilos para as Tabelas */
        .history table, .table-section {
            width: 100%;
            border-collapse: collapse;
        }
        .history th, .history td, .table-section th, .table-section td {
            text-align: left;
            padding: 5px;
            border-bottom: 1px solid #e2e8f0;
            font-size: 14px;
        }
        .history th, .table-section th {
            background-color: #f7fafc;
            color: #2d3748;
            cursor: pointer;
        }
        .history tr:nth-child(even), .table-section tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .table-section tr:hover {
            background-color: #f1f5f9;
        }
        
        
        
        /* Estilos para a Nova Aba "Perfil" */
        .profile-form {
            background-color: #ffffff;
            max-width: 100%;
            box-sizing: border-box;
        }
        
        .profile-form h2 {
            font-size: 24px;
            color: #08C89E;
            margin-bottom: 10px;
            margin-top: -10px;
            text-align: left;
        }
        
        .profile-form form {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }
        
        .profile-form .column {
            background-color: #f9fafb;
            padding: 15px;
            border-radius: 8px;
            box-sizing: border-box;
            border: 1px solid #e2e8f0;
            display: flex;
            flex-direction: column;
        }
        
        .profile-form .column h3 {
            font-size: 18px;
            color: #2d3748;
            margin-bottom: 15px;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 10px;
        }
        
        .profile-form .avatar-wrapper {
            text-align: center;
            margin-bottom: 15px;
            gap: 10px;
            position: relative;
        }
        
        .profile-form .avatar-wrapper img {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            border: 3px solid #08C89E;
            object-fit: cover;
            margin: 10px;
        }
        
        .profile-form .upload-button {
            position: absolute;
            bottom: 0;
            right: calc(50% - 60px);
            background-color: #08C89E;
            border: none;
            border-radius: 50%;
            padding: 10px;
            cursor: pointer;
            color: #fff;
            transition: background 0.3s;
        }
        
        .profile-form .upload-button:hover {
            background-color: #06b287;
        }
        
        .profile-form .upload-button input[type="file"] {
            display: none;
        }
        
        .profile-form label {
            display: block;
            font-size: 16px;
            color: #4a5568;
            margin-bottom: -10px;
        }
        
        .profile-form input,
        .profile-form select,
        .profile-form textarea {
            width: 100%;
            max-width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1.5px solid #e2e8f0;
            border-radius: 8px;
            font-size: 16px;
            color: #2d3748;
            box-sizing: border-box;
        }
        
        .profile-form input[readonly] {
            background-color: #edf2f7;
            cursor: not-allowed;
        }
        
        /* Grupos de Formulário */
        .form-group {
            margin-bottom: 0px;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-configuracoes.php'; ?>

    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content" style="margin-top: 0px">
                <h1 style="color: #08C89E; margin-left: 0px; "><i class="fas fa-cog" style="margin-right: 8px"></i>Configurações</h1>
                <p style="margin-top: -5px">Aqui você pode gerenciar os profissionais associados às suas clínicas.</p>
            </div>
        
        

        <!-- Seção das Abas -->
        <div class="tabs-container">
            
            <div class="tabs">
                <div class="tab active" data-tab="colaboradores-tab">
                    <i class="fas fa-user-md"></i> Profissionais
                </div>
                <div class="tab" data-tab="convites-tab">
                    <i class="fas fa-envelope"></i> Convites
                </div>
                <div class="tab" data-tab="parceiras-tab">
                    <i class="fas fa-handshake"></i> Parcerias
                </div>
                <div class="tab" data-tab="perfil-tab">
                    <i class="fas fa-user"></i> Meu Perfil
                </div>
            </div>

            <!-- Aba Profissionais -->
            <div id="colaboradores-tab" class="tab-content active">

                <p style="margin-top: -20px"><small>Gerencie os profissionais atribuídos às suas clínicas.</small></p>
                <p style="margin-top: -25px"><small><b>OBS: </b>Use a aba <b>Convites</b> para convidar novos colaboradores.</small></p>
                <hr />

                <div class="filters">
                    <div>
                        <label for="clinicSelect">Selecione a Clínica:</label>
                        <select id="clinicSelect" style="width: 200px">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchProfessional">Pesquisar por Nome/E-mail (Profissional):</label>
                        <input style="width: 300px" type="text" id="searchProfessional" placeholder="Nome ou Email do profissional...">
                    </div>
                </div>
                <table id="professionalsTable" class="table-section">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Nome</th>
                            <th>Formação</th>
                            <th>Email</th>
                            <th>Clínica</th>
                            <th>Perfil</th>
                            <th>Status</th> <!-- Nova Coluna para Status -->
                            <th>#</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Profissionais via JS -->
                    </tbody>
                </table>
                <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
            </div>

            <!-- Aba Convites -->
            <div id="convites-tab" class="tab-content">
                
                <p style="margin-top: -20px"><small>Crie e gerencie convites para outros profissionais participarem das suas clínicas.</small></p>
                
                <!-- Botão Criar acima dos filtros -->

                <button id="openInviteModalBtn" class="btn save">Criar Novo Convite</button>

                
                
                <hr />
                
                <div class="filters">
                    <div>
                        <label for="clinicFilterConvites">Selecione a Clínica:</label>
                        <select id="clinicFilterConvites" style="width: 200px;">
                            <option value="">Todas</option>
                            <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                            <option value="Clínica Central">Clínica Central</option>
                            <option value="Clínica do Norte">Clínica do Norte</option>
                        </select>
                    </div>
                    <div>
                        <label for="searchConviteName">Pesquisar por Nome (Convidado):</label>
                        <input type="text" id="searchConviteName" placeholder="Nome do convidado..." style="width: 300px;">
                    </div>
                </div>
                
                <table id="pendingInvitesTable" class="table-section">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Nome</th>
                            <th>Email</th>
                            <th>Clínica</th>
                            <th>Perfil</th>
                            <th>Convite</th>
                            <th>Status</th>
                            <th>Ações</th>
                            <th>Excluir</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Pendentes via JS -->
                    </tbody>
                </table>
                <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
            </div>

            <!-- Aba Parcerias -->
            <div id="parceiras-tab" class="tab-content">
                <p style="margin-top: -20px"><small>Carregue um código de convite para participar de outras clínicas como convidado.</small></p>


                <div class="summary-section">
                
                <form id="acceptPartnerInviteForm" style="display: flex; align-items: center; gap: 10px;">
                    <label for="partnerInviteCodeInput">Código de Convite:</label>
                    <input type="text" id="partnerInviteCodeInput" required placeholder="ABC123">
                    <button type="submit" class="btn save" >Carregar Convite</button>
                </form>

                <div id="parceirasInviteDetails" style="display: none;">
                    <hr />
                    <p style="margin-top: -10px; margin-bottom: -20px;">Convite para a clínica: <strong id="parceirasClinicName"></strong></p>
                    <p >Convidado por: <strong id="parceirasInviterName"></strong></p>
                    <p style="margin-top: -20px;">Perfil: <strong > Colaborador</strong></p>
                    <div style="display: flex; align-items: center; margin-top: 10px;">
                        <button class="btn save" id="parceirasAcceptButton" >Aceitar Convite</button>
                        <button class="btn decline" id="parceirasDeclineButton" >Cancelar</button>
                    </div>
                </div>
                
                </div>
                <hr />

                <!-- Seção Histórico de Convites -->
                <div class="section">
                    
                    <div class="filters">
                        <div>
                            <label for="clinicFilterParceirasHistory">Selecione a Clínica:</label>
                            <select id="clinicFilterParceirasHistory" style="width: 200px;">
                                <option value="">Todas</option>
                                <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                                <option value="Clínica Central">Clínica Central</option>
                                <option value="Clínica do Norte">Clínica do Norte</option>
                            </select>
                        </div>
                        <div>
                            <label for="searchParceirasHistoryName">Pesquisar por Nome (Administrador):</label>
                            <input type="text" id="searchParceirasHistoryName" placeholder="Nome do administrador..." style="width: 300px;">
                        </div>
                    </div>
                    <table id="inviteHistoryTable" class="table-section">
                        <thead>
                            <tr>
                                <th>ID da Clínica</th>
                                <th>Nome da Clínica</th>
                                <th>Administrador</th>
                                <th>Meu Perfil</th>
                                <th>Status</th>
                                <th>#</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Histórico via JS -->
                        </tbody>
                    </table>
                    <!-- Paginação para Profissionais -->
                    <div class="pagination" style="text-align: center; margin-top: 20px;">
                        <a href="#" class="active">1</a>
                        <a href="#">2</a>
                        <a href="#">3</a>
                        <a href="#">4</a>
                        <a href="#">Próximo &raquo;</a>
                    </div>
                </div>
               
                
            </div>
            
            
            <!-- Nova Aba "Perfil" -->
            <div id="perfil-tab" class="tab-content">
                <!-- Conteúdo da Aba "Perfil" -->
                
                <!-- Formulário de Perfil -->
                <div class="profile-form">
                    <form id="profileForm">
                        <!-- Primeira Coluna: Dados Pessoais com Avatar -->
                        <div class="column">
                            <h3 style="margin-top: -10px; margin-bottom:-15px">Selecione um avatar</h3>
                            <div class="avatar-wrapper">
                                <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                                <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                                <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                                <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                                <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                                <img id="avatar" src="https://api.dicebear.com/6.x/pixel-art/svg?seed=example" alt="Avatar">
                            </div>
                            <div class="form-group" style="margin-top: -15px;">
                                <label for="profileName">Nome Completo:</label>
                                <input type="text" id="profileName" name="profileName" value="Coralina Da Silva Matos Simon" required>
                            </div>
                            <div style="display: grid; grid-template-columns: repeat(2, 1fr);gap: 20px;">
                                <div class="form-group">
                                    <label for="profileName">Código Profissional:</label>
                                    <input type="text" id="profileName" name="profileName" value="PRA001" readonly>
                                </div>
                                <div class="form-group">
                                    <label for="profileName">Nome profissional:</label>
                                    <input type="text" id="profileName" name="profileName" value="Coralina Matos" required>
                                </div>
                            </div>
                            <div style="display: grid; grid-template-columns: repeat(2, 1fr);gap: 20px;">
                                <div class="form-group">
                                    <label for="profileProfession">Profissão:</label>
                                    <input type="text" id="profileProfession" name="profileProfession" value="Terapeuta Ocupacional">
                                </div>
                                <div class="form-group">
                                    <label for="profileRegistration">Registro Profissional:</label>
                                    <input type="text" id="profileRegistration" name="profileRegistration" value="CREFITO: 12.132-TO">
                                </div>
                            </div>
                            <div style="display: grid; grid-template-columns: repeat(2, 1fr);gap: 20px;">
                                <div class="form-group" style="width: 350px;">
                                    <label for="profileEmail">Email:</label>
                                    <input type="email" id="profileEmail" name="profileEmail" value="coralina.matos@example.com" readonly>
                                </div>
                                <div class="form-group">
                                    <label for="profilePhone">Telefone:</label>
                                    <input type="tel" id="profilePhone" name="profilePhone" value="(99) 99999-9999">
                                </div>
                            </div>
                            
                            <button type="button" class="btn save" id="savePersonalInfo">Salvar Informações</button>
                        </div>
                        
                        <!-- Terceira Coluna: Alterar Senha -->
                        <div class="column" >
                            <h3 style="margin-top: -10px; margin-bottom:-0px">Alterar Senha</h3>
                            <div class="form-group">
                                <label for="currentPassword">Senha Atual:</label>
                                <input type="password" id="currentPassword" name="currentPassword" required>
                            </div>
                            <div class="form-group">
                                <label for="newPassword">Nova Senha:</label>
                                <input type="password" id="newPassword" name="newPassword" required>
                            </div>
                            <div class="form-group">
                                <label for="confirmPassword">Repetir Nova Senha:</label>
                                <input type="password" id="confirmPassword" name="confirmPassword" required>
                            </div>
                            <button type="submit" class="btn save">Salvar Senha</button>
                        </div>
                    </form>
                </div>

        </div>

    </main>

    <!-- Modal Criar Convite Padronizado -->
<div class="modal-overlay" id="inviteModalOverlay">
    <div class="modal-container">
        <header class="modal-header">
            <div class="modal-title">
                <h2>Criar Novo Convite</h2>
            </div>
            <button type="button" class="btn-close" id="closeInviteModal" aria-label="Fechar">&times;</button>
        </header>
        <form id="inviteForm">
            <div class="form-group">
                <label for="inviteName">Nome do Profissional</label>
                <input type="text" id="inviteName" name="inviteName" required placeholder="Ex: Maria Silva">
            </div>
            <div class="form-group">
                <label for="inviteEmail">Email do Profissional</label>
                <input type="email" id="inviteEmail" name="inviteEmail" required placeholder="Ex: maria.silva@example.com">
            </div>
            <div class="form-group">
                <label for="inviteClinic">Clínica</label>
                <select id="inviteClinic" name="inviteClinic" required>
                    <option value="">Selecione uma clínica</option>
                    <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                    <option value="Clínica Central">Clínica Central</option>
                    <option value="Clínica do Norte">Clínica do Norte</option>
                </select>
            </div>
            <div class="form-group">
                <label for="invitePerfil">Perfil</label> <!-- Novo Campo de Perfil -->
                <select id="invitePerfil" name="invitePerfil" required>
                    <option value="">Selecione o perfil</option>
                    <option value="Co-Administrador">Co-Administrador (Co-Admin)</option>
                    <option value="Supervisor">Supervisor</option>
                    <option value="Colaborador">Colaborador</option>
                </select>
            </div>
            
            <!-- Seção de Notas sobre o Perfil Selecionado -->
            <div class="form-group" id="profileNotes" style="display: none; margin-top: 10px">
                <label >Informações sobre o Perfil Selecionado:</label>
                <div id="profileNoteContent" style="background-color: #f9fafb; padding: 10px; border-radius: 8px; border-left: 4px solid #08C89E;">
                    <!-- Conteúdo dinâmico será inserido aqui -->
                </div>
            </div>
            
            <footer class="modal-footer">
                <button type="button" class="btn cancel" id="cancelInviteModal">Cancelar</button>
                <button type="submit" class="btn save">Gerar Convite</button>
            </footer>
        </form>
        <div id="inviteCodeSection" style="display: none; text-align: center; margin-top: 20px;">
            <p>O código de convite é:</p>
            <h3 id="inviteCode"></h3>
            <button class="btn copy" id="copyInviteCodeBtn">
                <i class="fas fa-copy"></i> Copiar Código
            </button>
            <p>Envie este código para o profissional convidado.</p>
        </div>
    </div>
</div>



    <!-- Modal Editar Perfil -->
    <div id="editPerfilModal" class="modal">
        <div class="modal-content">
            <span class="close-edit-perfil">&times;</span>
            <h2>Editar Perfil do Profissional</h2>
            <form id="editPerfilForm">
                <input type="hidden" id="editPerfilEmail" name="editPerfilEmail">
                <label for="newPerfil">Novo Perfil:</label>
                <select id="newPerfil" name="newPerfil" required>
                    <option value="">Selecione o novo perfil</option>
                    <option value="Administrador">Co-Admin</option>
                    <option value="Colaborador">Supervisor</option>
                    <option value="Colaborador">Colaborador</option>
                </select>
                <button type="submit" class="btn save">Salvar Alterações</button>
            </form>
        </div>
    </div>

    <!-- Modal Gerenciamento de Profissional -->
    <div id="manageProfessionalModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Gerenciar Profissional</h2>
            <p style="color: #4A5568; font-size: 14px; margin-top: -5px;">
                Aqui você pode visualizar as informações do profissional selecionado e realizar ações de gerenciamento.
            </p>
            
            <hr style="margin: 15px 0; border: none; border-top: 1px solid #e2e8f0;" />
    
            <h3 id="manageProfName" style="font-size: 20px; color: #2d3748; margin-bottom: 10px;"></h3>
    
            <div class="prof-info" style="display: flex; flex-direction: column; ; font-size: 14px; color: #4A5568;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-briefcase" title="Profissão"></i>
                    <strong>Profissão:</strong> <span id="manageProfProfession"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-envelope" title="Email"></i>
                    <strong>Email:</strong> <span id="manageProfEmail"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-hospital-user" title="Clínica"></i>
                    <strong>Clínica:</strong> <span id="manageProfClinic"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-user-tag" title="Perfil"></i>
                    <strong>Perfil:</strong> <span id="manageProfPerfil"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-info-circle" title="Status"></i>
                    <strong>Status:</strong> <span id="manageProfStatus"></span>
                </div>
            </div>
    
            <hr style="margin: 20px 0; border: none; border-top: 1px solid #e2e8f0;" />
    
            <div class="modal-actions" style="display: flex; justify-content: flex-end; gap: 10px;">
                <button class="btn save" id="manageProfEditButton" style="background-color: #48BB78;">
                    <i class="fas fa-user-edit"></i> Editar Perfil
                </button>
                <button class="btn" id="manageProfUnlinkButton" style="background-color: #ED8936;">
                    <!-- O conteúdo deste botão será atualizado dinamicamente para "Desvincular" ou "Vincular" -->
                </button>
                <button class="btn delete" id="manageProfDeleteButton" style="background-color: #E53E3E; display: none;">
                    <i class="fas fa-trash-alt"></i> Excluir
                </button>
                <button class="btn cancel" id="manageProfCancelButton" style="background-color: #A0AEC0;">
                    <i class="fas fa-times"></i> Cancelar
                </button>
            </div>
        </div>
    </div>

    <!-- Scripts Separados por Funcionalidade -->

    <!-- 1. Funcionalidade das Abas -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const tabs = document.querySelectorAll('.tab');
            const tabContents = document.querySelectorAll('.tab-content');

            tabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    tabs.forEach(t => t.classList.remove('active'));
                    tabContents.forEach(c => c.classList.remove('active'));

                    tab.classList.add('active');
                    document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
                });
            });
        });
    </script>

    <!-- 2. Gerenciamento de Profissionais -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Função para gerar códigos únicos para profissionais
            function generateProfessionalCode(index) {
                return 'PRF' + String(index + 1).padStart(3, '0'); // Exemplo: PRF001, PRF002, etc.
            }

            // Função para atualizar a tabela de profissionais
            function updateProfessionalsTable() {
                const clinicFilter = document.getElementById('clinicSelect').value;
                const searchFilter = document.getElementById('searchProfessional').value.toLowerCase();
                const tableBody = document.querySelector('#professionalsTable tbody');
                tableBody.innerHTML = '';

                const filtered = professionals.filter(prof => {
                    const matchClinic = !clinicFilter || prof.clinic === clinicFilter;
                    const matchSearch = prof.name.toLowerCase().includes(searchFilter) ||
                                        prof.profession.toLowerCase().includes(searchFilter) ||
                                        prof.email.toLowerCase().includes(searchFilter);
                    return matchClinic && matchSearch;
                });

                filtered.forEach(prof => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${prof.code}</td> <!-- Exibir Código -->
                        <td>${prof.name}</td>
                        <td>${prof.profession}</td>
                        <td>${prof.email}</td>
                        <td>${prof.clinic}</td>
                        <td>${prof.perfil}</td> <!-- Exibir Perfil -->
                        <td class="status-${prof.status.toLowerCase()}">${prof.status}</td> <!-- Exibir Status -->
                        <td class="action-icons">
                            <button class="btn manage-icon" onclick="openManageProfessionalModal('${prof.email}')">
                                <i class="fas fa-cog" title="Gerenciar"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicSelect').addEventListener('change', updateProfessionalsTable);
            document.getElementById('searchProfessional').addEventListener('input', updateProfessionalsTable);
            updateProfessionalsTable();

            // Função para abrir o modal de gerenciamento
            window.openManageProfessionalModal = function(email) {
                const professional = professionals.find(prof => prof.email === email);
                if (professional) {
                    document.getElementById('manageProfName').textContent = professional.name;
                    document.getElementById('manageProfProfession').textContent = professional.profession;
                    document.getElementById('manageProfEmail').textContent = professional.email;
                    document.getElementById('manageProfClinic').textContent = professional.clinic;
                    document.getElementById('manageProfPerfil').textContent = professional.perfil;
                    document.getElementById('manageProfStatus').textContent = professional.status;

                    // Armazenar o email do profissional no botão para referência
                    document.getElementById('manageProfEditButton').dataset.email = email;
                    document.getElementById('manageProfUnlinkButton').dataset.email = email;
                    document.getElementById('manageProfDeleteButton').dataset.email = email;

                    // Atualizar Botões de Ação com base no Status
                    updateManageModalActions(professional.status);

                    // Abrir o modal
                    document.getElementById('manageProfessionalModal').style.display = 'block';
                } else {
                    alert('Profissional não encontrado.');
                }
            }

            // Função para atualizar os botões de ação no modal com base no status
            function updateManageModalActions(status) {
                const editButton = document.getElementById('manageProfEditButton');
                const unlinkButton = document.getElementById('manageProfUnlinkButton');
                const deleteButton = document.getElementById('manageProfDeleteButton');

                if (status.toLowerCase() === 'ativo') {
                    // Situação 1 e 2
                    unlinkButton.style.display = 'inline-flex';
                    unlinkButton.innerHTML = `<i class="fas fa-unlink"></i> Inativar`;
                    deleteButton.style.display = 'none'; // Não permite excluir enquanto estiver ativo
                } else if (status.toLowerCase() === 'inativo') {
                    // Situação 3 e 4
                    unlinkButton.style.display = 'inline-flex';
                    unlinkButton.innerHTML = `<i class="fas fa-link"></i> Reativar`;
                    deleteButton.style.display = 'inline-flex'; // Permite excluir apenas se desvinculado
                } else {
                    // Outros statuses, se houver
                    unlinkButton.style.display = 'none';
                    deleteButton.style.display = 'none';
                }
            }

            // Função para fechar o modal de gerenciamento
            window.closeManageProfessionalModal = function() {
                document.getElementById('manageProfessionalModal').style.display = 'none';
                // Resetar dados no modal
                document.getElementById('manageProfName').textContent = '';
                document.getElementById('manageProfProfession').textContent = '';
                document.getElementById('manageProfEmail').textContent = '';
                document.getElementById('manageProfClinic').textContent = '';
                document.getElementById('manageProfPerfil').textContent = '';
                document.getElementById('manageProfStatus').textContent = '';
            }

            // Eventos para fechar o modal
            const manageProfModal = document.getElementById('manageProfessionalModal');
            const manageProfCloseBtn = manageProfModal.querySelector('.close');
            const manageProfCancelBtn = document.getElementById('manageProfCancelButton');

            manageProfCloseBtn.onclick = function() {
                closeManageProfessionalModal();
            }

            manageProfCancelBtn.onclick = function() {
                closeManageProfessionalModal();
            }

            window.onclick = function(event) {
                if (event.target == manageProfModal) {
                    closeManageProfessionalModal();
                }
            }

            // Função para editar perfil a partir do modal
            document.getElementById('manageProfEditButton').addEventListener('click', function() {
                const email = this.dataset.email;
                openEditPerfilModal(email);
                closeManageProfessionalModal();
            });

            // Função para desvincular ou vincular profissional a partir do modal
            document.getElementById('manageProfUnlinkButton').addEventListener('click', function() {
                const email = this.dataset.email;
                const professional = professionals.find(prof => prof.email === email);

                if (!professional) {
                    alert('Profissional não encontrado.');
                    return;
                }

                if (professional.status.toLowerCase() === 'ativo') {
                    // Situação 2: Desvincular
                    if (confirm('Tem certeza que deseja desvincular este profissional?')) {
                        professional.status = 'Inativo';
                        updateProfessionalsTable();
                        updateInviteHistoryTable(); // Atualizar histórico se necessário
                        alert('Profissional desvinculado com sucesso.');
                        closeManageProfessionalModal();
                    }
                } else if (professional.status.toLowerCase() === 'inativo') {
                    // Situação 3: Vincular
                    if (confirm('Tem certeza que deseja vincular este profissional novamente?')) {
                        professional.status = 'Ativo';
                        updateProfessionalsTable();
                        updateInviteHistoryTable(); // Atualizar histórico se necessário
                        alert('Profissional vinculado novamente com sucesso.');
                        closeManageProfessionalModal();
                    }
                }
            });

            // Função para excluir profissional a partir do modal
            document.getElementById('manageProfDeleteButton').addEventListener('click', function() {
                const email = this.dataset.email;
                const professional = professionals.find(prof => prof.email === email);

                if (!professional) {
                    alert('Profissional não encontrado.');
                    return;
                }

                if (professional.status.toLowerCase() !== 'inativo') {
                    alert('Para excluir, o profissional deve estar desvinculado.');
                    return;
                }

                if (confirm('Tem certeza que deseja excluir este profissional?')) {
                    professionals = professionals.filter(prof => prof.email !== email);
                    updateProfessionalsTable();
                    alert('Profissional excluído com sucesso.');
                    closeManageProfessionalModal();
                }
            });
        });
    </script>

    <!-- 3. Gerenciamento de Convites Pendentes -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Função para gerar IDs únicos para convites
            let inviteIdCounter = pendingInvites.length ? Math.max(...pendingInvites.map(inv => parseInt(inv.id.replace('INV', '')))) : 0;
            function generateInviteId() {
                inviteIdCounter += 1;
                return 'INV' + String(inviteIdCounter).padStart(3, '0'); // Exemplo: INV001, INV002, etc.
            }

            // Função para atualizar a tabela de convites pendentes
            function updatePendingInvitesTable() {
                const clinicFilter = document.getElementById('clinicFilterConvites').value;
                const searchNameFilter = document.getElementById('searchConviteName').value.toLowerCase();
                const tableBody = document.querySelector('#pendingInvitesTable tbody');
                tableBody.innerHTML = '';

                const filtered = pendingInvites.filter(invite => {
                    const matchClinic = !clinicFilter || invite.clinic === clinicFilter;
                    const matchName = invite.name.toLowerCase().includes(searchNameFilter);
                    return matchClinic && matchName;
                });

                filtered.forEach(invite => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${invite.id}</td> <!-- Exibir ID do Convite -->
                        <td>${invite.name}</td>
                        <td>${invite.email}</td>
                        <td>${invite.clinic}</td>
                        <td>${invite.perfil}</td> <!-- Exibir Perfil -->
                        <td>${invite.code}</td>
                        <td class="status-${invite.status.toLowerCase()}">${invite.status}</td>
                        <td>
                            <button class="btn copy" onclick="copyCode('${invite.code}')">
                                <i class="fas fa-copy" title="Copiar Código"></i>
                            </button>
                        </td>
                        <td>
                            <button class="btn excluir" onclick="deleteInvite('${invite.id}')">
                                <i class="fas fa-trash-alt" title="Excluir Convite"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicFilterConvites').addEventListener('change', updatePendingInvitesTable);
            document.getElementById('searchConviteName').addEventListener('input', updatePendingInvitesTable);
            updatePendingInvitesTable();

            // Função para deletar convite
            window.deleteInvite = function(id) {
                if(confirm('Tem certeza que deseja excluir este convite?')) {
                    pendingInvites = pendingInvites.filter(inv => inv.id !== id);
                    updatePendingInvitesTable();
                    alert('Convite excluído com sucesso.');
                }
            }

            // Função para copiar o código para a área de transferência
            window.copyCode = function(code) {
            const inviteText = `Olá, você foi convidado(a) para atuar na clínica [Nome da Clínica]!

Para se juntar a nós, siga os passos abaixo:
1 - Acesse o nosso sistema no link: [URL do Sistema] 
2 - Caso ainda não tenha uma conta, clique em ‘Cadastrar’ e selecione o perfil “Profissional/Empresa”. Preencha suas informações. 
    • Se você já possui uma conta, basta fazer o login normalmente. 
3 - Após logar-se no sistema, acesse o menu “Clínicas”. 
4 - Siga as instruções na página para carregar o convite: 
    Código do Convite: ${code}
            
Após inserir o código, você será vinculado(a) à nossa clínica. O seu papel (Co-Admin, Supervisor ou Colaborador) já foi definido pelo Administrador.

Bem-vindo(a) à equipe!`;
            
            navigator.clipboard.writeText(inviteText).then(() => {
                alert('Texto copiado para a área de transferência!');
            }).catch(err => {
                alert('Erro ao copiar o texto: ' + err);
            });
        }
});
    </script>

    <!-- 4. Gerenciamento do Histórico de Convites -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Função para atualizar a tabela de histórico de convites
            function updateInviteHistoryTable() {
                const clinicFilter = document.getElementById('clinicFilterParceirasHistory').value;
                const searchNameFilter = document.getElementById('searchParceirasHistoryName').value.toLowerCase();
            
                const tableBody = document.querySelector('#inviteHistoryTable tbody');
                tableBody.innerHTML = '';
            
                const filtered = inviteHistory.filter(invite => {
                    const matchClinic = !clinicFilter || invite.clinicName === clinicFilter;
                    const matchName = invite.administrator.toLowerCase().includes(searchNameFilter) ||
                                      invite.clinicName.toLowerCase().includes(searchNameFilter);
                    return matchClinic && matchName;
                });
            
                filtered.forEach(invite => {
                    let actionButton = '';
                    if (invite.status === 'Aceito') {
                        actionButton = `<button class="btn encerrar" onclick="encerrarConvite('${invite.clinicId}')">
                                            <i class="fas fa-stop-circle" title="Encerrar Convite"></i>
                                        </button>`;
                    } else if (invite.status === 'Encerrado') {
                        actionButton = `<button class="btn excluir" onclick="excluirConvite('${invite.clinicId}')">
                                            <i class="fas fa-trash-alt" title="Excluir Convite"></i>
                                        </button>`;
                    }

                    const statusClass = invite.status.toLowerCase();

                    const row = document.createElement('tr');
                    
                    row.innerHTML = `
                        <td>${invite.clinicId}</td>
                        <td>${invite.clinicName}</td>
                        <td class="admin-name">${invite.administrator}</td>
                        <td>${invite.perfil}</td> <!-- Exibir Perfil -->
                        <td class="status-${statusClass}">${invite.status}</td>
                        <td class="action-icons">
                            ${actionButton}
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicFilterParceirasHistory').addEventListener('change', updateInviteHistoryTable);
            document.getElementById('searchParceirasHistoryName').addEventListener('input', updateInviteHistoryTable);
            updateInviteHistoryTable();

            // Função para encerrar convite
            window.encerrarConvite = function(clinicId) {
                if(confirm('Tem certeza que deseja encerrar este convite?')) {
                    const invite = inviteHistory.find(inv => inv.clinicId === clinicId && inv.status === 'Aceito');
                    if(invite) {
                        invite.status = 'Encerrado';
                        invite.date = new Date().toLocaleDateString();
                        updateInviteHistoryTable();
                        alert('Convite encerrado com sucesso.');
                    }
                }
            }
            
            // Função para excluir convite do histórico
            window.excluirConvite = function(clinicId) {
                if(confirm('Tem certeza que deseja excluir este convite?')) {
                    inviteHistory = inviteHistory.filter(inv => inv.clinicId !== clinicId);
                    updateInviteHistoryTable();
                    alert('Convite excluído com sucesso.');
                }
            }
            
            // Função para gerar ID da Clínica baseado no nome (Exemplo Simples)
            function generateClinicId(clinicName) {
                const clinicIds = {
                    'Clínica Sertãozinho': 'CL001',
                    'Clínica Central': 'CL002',
                    'Clínica do Norte': 'CL003'
                };
                return clinicIds[clinicName] || 'CL000';
            }
            
            // Função para obter o Administrador baseado no nome da clínica (Exemplo Simples)
            function getAdministrator(clinicName) {
                const administrators = {
                    'Clínica Sertãozinho': 'José Almeida',
                    'Clínica Central': 'Luiz Gustavo',
                    'Clínica do Norte': 'Maria Fernanda'
                };
                return administrators[clinicName] || 'Administrador Desconhecido';
            }
        });
    </script>

    <!-- 5. Gerenciamento do Modal de Convites -->
    <script>
        // Modal Criar Convite Padronizado
document.addEventListener('DOMContentLoaded', () => {
    const inviteModalOverlay = document.getElementById('inviteModalOverlay');
    const closeInviteModalBtn = document.getElementById('closeInviteModal');
    const cancelInviteModalBtn = document.getElementById('cancelInviteModal');
    const inviteForm = document.getElementById('inviteForm');
    const inviteCodeSection = document.getElementById('inviteCodeSection');
    const inviteCodeDisplay = document.getElementById('inviteCode');
    const copyInviteCodeBtn = document.getElementById('copyInviteCodeBtn');
    const invitePerfilSelect = document.getElementById('invitePerfil');
    const profileNotesSection = document.getElementById('profileNotes');
    const profileNoteContent = document.getElementById('profileNoteContent');

    // Definição dos perfis e suas respectivas notas
    const profileNotes = {
    "Co-Administrador": `
        <strong style="font-size: 11px;">Co-Administrador (Co-Admin): Gestão e Acesso Completo</strong>
        <ul style="font-size: 10px; margin-top: 5px;">
            <li>Gerencie a clínica: convide profissionais e defina suas funções.</li>
            <li>Cadastre novos pacientes com facilidade.</li>
            <li>Tenha acesso total para aplicar e consultar avaliações e intervenções de todos os pacientes.</li>
        </ul>
    `,
    "Supervisor": `
        <strong style="font-size: 11px;">Supervisor: Acesso Clínico Total, Sem Gestão Administrativa</strong>
        <ul style="font-size: 10px; margin-top: 5px;">
            <li>Visualize e gerencie o atendimento de todos os pacientes da clínica.</li>
            <li>Realize e consulte avaliações e intervenções clínicas.</li>
            <li>Foque no atendimento sem lidar com tarefas administrativas (como convites ou assinaturas).</li>
        </ul>
    `,
    "Colaborador": `
        <strong style="font-size: 11px;">Colaborador: Acesso Limitado aos Pacientes Atribuídos</strong>
        <ul style="font-size: 10px; margin-top: 5px;">
            <li>Acesse apenas os pacientes designados pelo Admin, Co-Admin ou Supervisor.</li>
            <li>Realize e acompanhe avaliações exclusivamente nos pacientes atribuídos.</li>
            <li>Ideal para especialistas que atendem casos específicos.</li>
            <li>Sem acesso a configurações administrativas ou gestão de outros profissionais.</li>
        </ul>
    `
};


    // Abrir Modal ao clicar no botão correspondente
    const openInviteModalBtn = document.getElementById('openInviteModalBtn'); // Certifique-se de ter um botão com este ID para abrir o modal
    if (openInviteModalBtn) {
        openInviteModalBtn.addEventListener('click', () => {
            inviteModalOverlay.style.display = 'flex';
        });
    }

    // Fechar Modal ao clicar no 'x'
    closeInviteModalBtn.addEventListener('click', () => {
        closeInviteModal();
    });

    // Fechar Modal ao clicar no botão 'Cancelar'
    cancelInviteModalBtn.addEventListener('click', () => {
        closeInviteModal();
    });

    // Fechar Modal ao clicar fora do container do modal
    inviteModalOverlay.addEventListener('click', (e) => {
        if (e.target === inviteModalOverlay) {
            closeInviteModal();
        }
    });

    // Função para fechar o modal e resetar o formulário
    function closeInviteModal() {
        inviteModalOverlay.style.display = 'none';
        inviteForm.reset();
        inviteCodeSection.style.display = 'none';
        inviteForm.style.display = 'block';
        profileNotesSection.style.display = 'none';
        profileNoteContent.innerHTML = '';
    }

    // Manipulação do Formulário de Convite
    inviteForm.addEventListener('submit', function(event) {
        event.preventDefault();
        const name = document.getElementById('inviteName').value.trim();
        const email = document.getElementById('inviteEmail').value.trim();
        const clinic = document.getElementById('inviteClinic').value;
        const perfil = document.getElementById('invitePerfil').value;

        // Validação adicional
        if (!name || !email || !clinic || !perfil) {
            alert('Por favor, preencha todos os campos.');
            return;
        }

        // Geração de código único para o convite
        const code = generateInviteCode();
        const id = generateInviteId(); // Função para gerar ID único

        const newInvite = {
            id: id,
            name: name,
            email: email,
            clinic: clinic,
            perfil: perfil,
            code: code,
            status: 'Pendente'
        };

        // Adiciona o novo convite à lista de convites pendentes
        pendingInvites.push(newInvite);

        // Atualiza a tabela de convites pendentes
        updatePendingInvitesTable();

        // Exibe o código gerado
        inviteForm.style.display = 'none';
        inviteCodeDisplay.textContent = code;
        inviteCodeSection.style.display = 'block';
    });

    // Função para copiar o código de convite
    copyInviteCodeBtn.addEventListener('click', function() {
        const code = inviteCodeDisplay.textContent;
        if (code) {
            navigator.clipboard.writeText(code).then(() => {
                alert('Código copiado: ' + code);
            }).catch(err => {
                alert('Erro ao copiar o código');
            });
        } else {
            alert('Nenhum código para copiar.');
        }
    });

    // Função para gerar IDs únicos para convites
    let inviteIdCounter = pendingInvites.length ? Math.max(...pendingInvites.map(inv => parseInt(inv.id.replace('INV', '')))) : 0;
    function generateInviteId() {
        inviteIdCounter += 1;
        return 'INV' + String(inviteIdCounter).padStart(3, '0'); // Exemplo: INV001, INV002, etc.
    }

    // Função para gerar um código de convite único
    function generateInviteCode() {
        return Math.random().toString(36).substring(2, 8).toUpperCase(); // Gera um código de 6 caracteres
    }

    // Event Listener para o campo de Perfil
    invitePerfilSelect.addEventListener('change', function() {
        const selectedPerfil = this.value;
        if (profileNotes[selectedPerfil]) {
            profileNoteContent.innerHTML = profileNotes[selectedPerfil];
            profileNotesSection.style.display = 'block';
        } else {
            profileNoteContent.innerHTML = '';
            profileNotesSection.style.display = 'none';
        }
    });
});


    </script>

    <!-- 6. Gerenciamento de Parcerias -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Elementos do Formulário de Aceitação de Convite
            const acceptPartnerInviteForm = document.getElementById('acceptPartnerInviteForm');
            const partnerInviteCodeInput = document.getElementById('partnerInviteCodeInput');
            const parceirasInviteDetails = document.getElementById('parceirasInviteDetails');
            const parceirasClinicName = document.getElementById('parceirasClinicName');
            const parceirasInviterName = document.getElementById('parceirasInviterName');
            const parceirasAcceptButton = document.getElementById('parceirasAcceptButton');
            const parceirasDeclineButton = document.getElementById('parceirasDeclineButton');

            let currentInvite = null;

            // Manipulação do Formulário de Aceitação de Convite
            acceptPartnerInviteForm.addEventListener('submit', function(event) {
                event.preventDefault();
                const codeInput = partnerInviteCodeInput.value.toUpperCase();

                const invite = pendingInvites.find(inv => inv.code === codeInput && inv.status === 'Pendente');
                if(invite) {
                    parceirasClinicName.textContent = invite.clinic;
                    parceirasInviterName.textContent = invite.name;
                    parceirasInviteDetails.style.display = 'block';
                    currentInvite = invite;
                } else {
                    alert('Convite não encontrado ou já processado.');
                    parceirasInviteDetails.style.display = 'none';
                    currentInvite = null;
                }
            });

            // Aceitar Convite de Parceria
            parceirasAcceptButton.addEventListener('click', function() {
                if(currentInvite) {
                    currentInvite.status = 'Aceito';
                    currentInvite.date = new Date().toLocaleDateString();
                    
                    // Adicionar ao Histórico de Convites
                    inviteHistory.push({
                        clinicId: generateClinicId(currentInvite.clinic),
                        clinicName: currentInvite.clinic,
                        administrator: getAdministrator(currentInvite.clinic),
                        perfil: currentInvite.perfil, // Adicionar perfil ao histórico
                        status: 'Aceito',
                        date: currentInvite.date
                    });

                    // Adicionar ao Profissionais
                    const newProfessionalCode = generateProfessionalCode(professionals.length);
                    const newProfessional = {
                        name: currentInvite.name,
                        profession: 'Profissão Indefinida', // Você pode ajustar isso conforme necessário
                        email: currentInvite.email,
                        clinic: currentInvite.clinic,
                        perfil: currentInvite.perfil,
                        status: 'Ativo',
                        code: newProfessionalCode
                    };
                    professionals.push(newProfessional);

                    // Remover do Convites Pendentes
                    pendingInvites = pendingInvites.filter(inv => inv !== currentInvite);
                    
                    // Atualizar Tabelas
                    updatePendingInvitesTable();
                    updateInviteHistoryTable();
                    updateProfessionalsTable();

                    // Resetar Formulário e Estado
                    parceirasInviteDetails.style.display = 'none';
                    acceptPartnerInviteForm.reset();
                    currentInvite = null;

                    alert('Convite aceito e profissional adicionado com sucesso!');
                }
            });


            // Cancelar Aceitação de Convite de Parceria
            parceirasDeclineButton.addEventListener('click', function() {
                if(currentInvite) {
                    // Apenas cancelar a operação sem alterar registros
                    parceirasInviteDetails.style.display = 'none';
                    acceptPartnerInviteForm.reset();
                    currentInvite = null;
                    alert('Operação cancelada.');
                }
            });
        });
    </script>

    <!-- 7. Dados Compartilhados Entre Scripts -->
    <script>
        // Inicializa os dados globais que serão usados por múltiplos scripts
        // Profissionais
        let professionals = [
            { name: 'Mariana Santos', profession: 'Fonoaudióloga', email: 'mariana.santos@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Administrador', status: 'Ativo', code: 'PRF001' },
            { name: 'Pedro Oliveira', profession: 'Psicólogo', email: 'pedro.oliveira@example.com', clinic: 'Clínica Central', perfil: 'Colaborador', status: 'Ativo', code: 'PRF002' },
            { name: 'Camila Rocha', profession: 'Nutricionista', email: 'camila.rocha@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', status: 'Ativo', code: 'PRF003' },
            { name: 'Beatriz Souza', profession: 'Terapeuta Ocupacional', email: 'beatriz.souza@example.com', clinic: 'Clínica Central', perfil: 'Administrador', status: 'Ativo', code: 'PRF004' },
            { name: 'Felipe Costa', profession: 'Fisioterapeuta', email: 'felipe.costa@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', status: 'Ativo', code: 'PRF005' },
            { name: 'Juliana Lima', profession: 'Enfermeira', email: 'juliana.lima@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', status: 'Ativo', code: 'PRF006' },
            { name: 'Ricardo Pinto', profession: 'Nutricionista', email: 'ricardo.pinto@example.com', clinic: 'Clínica Central', perfil: 'Administrador', status: 'Ativo', code: 'PRF007' },
            { name: 'Gustavo Ribeiro', profession: 'Terapeuta Ocupacional', email: 'gustavo.ribeiro@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', status: 'Ativo', code: 'PRF008' },
        ];

        // Convites Pendentes
        let pendingInvites = [
            { id: 'INV001', name: 'Ana Silva', email: 'ana.silva@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', code: 'ABC123', status: 'Pendente' },
            { id: 'INV002', name: 'Bruno Lima', email: 'bruno.lima@example.com', clinic: 'Clínica Central', perfil: 'Administrador', code: 'DEF456', status: 'Pendente' },
            { id: 'INV003', name: 'Carla Mendes', email: 'carla.mendes@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', code: 'GHI789', status: 'Expirado' }
        ];

        // Histórico de Convites
        let inviteHistory = [
            { clinicId: 'CL001', clinicName: 'Clínica Sertãozinho', administrator: 'José Almeida', perfil: 'Administrador', status: 'Aceito', date: '01/10/2023' },
            { clinicId: 'CL002', clinicName: 'Clínica Central', administrator: 'Luiz Gustavo', perfil: 'Administrador', status: 'Aceito', date: '20/10/2023' },
            { clinicId: 'CL003', clinicName: 'Clínica do Norte', administrator: 'Maria Fernanda', perfil: 'Administrador', status: 'Encerrado', date: '25/10/2023' },
            { clinicId: 'CL003', clinicName: 'Clínica do Norte', administrator: 'Ana Paula', perfil: 'Colaborador', status: 'Aceito', date: '05/11/2023' },
        ];
    </script>

    <!-- 8. Gerenciamento da Edição de Perfil -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Elementos do Modal Editar Perfil
            const editPerfilModal = document.getElementById('editPerfilModal');
            const closeEditPerfilBtn = document.querySelector('.close-edit-perfil');
            const editPerfilForm = document.getElementById('editPerfilForm');
            const editPerfilEmailInput = document.getElementById('editPerfilEmail');
            const newPerfilSelect = document.getElementById('newPerfil');

            // Função para abrir o modal de editar perfil
            window.openEditPerfilModal = function(email) {
                // Encontrar o profissional pelo email
                const professional = professionals.find(prof => prof.email === email);
                if(professional) {
                    editPerfilEmailInput.value = email;
                    newPerfilSelect.value = ''; // Resetar seleção
                    editPerfilModal.style.display = 'block';
                } else {
                    alert('Profissional não encontrado.');
                }
            }

            // Fechar o modal ao clicar no 'x'
            closeEditPerfilBtn.onclick = function() {
                editPerfilModal.style.display = 'none';
                editPerfilForm.reset();
            }

            // Fechar o modal ao clicar fora dele
            window.onclick = function(event) {
                if (event.target == editPerfilModal) {
                    editPerfilModal.style.display = 'none';
                    editPerfilForm.reset();
                }
            }

            // Manipular o envio do formulário de edição de perfil
            editPerfilForm.addEventListener('submit', function(event) {
                event.preventDefault();
                const email = editPerfilEmailInput.value;
                const newPerfil = newPerfilSelect.value;

                if(newPerfil === '') {
                    alert('Por favor, selecione um novo perfil.');
                    return;
                }

                // Encontrar o profissional e atualizar o perfil
                const professional = professionals.find(prof => prof.email === email);
                if(professional) {
                    professional.perfil = newPerfil;
                    updateProfessionalsTable();
                    editPerfilModal.style.display = 'none';
                    editPerfilForm.reset();
                    alert('Perfil atualizado com sucesso.');
                } else {
                    alert('Profissional não encontrado.');
                }
            });
        });
    </script>

    <!-- 9. Gerenciamento do Modal de Profissional -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Elementos do Modal Gerenciar Profissional já foram tratados no script 2
            // Não há necessidade de adicionar mais aqui, pois já foi integrado no script 2
        });
    </script>

</body>
</html>
