<?php
// profissionais.php
// Inclua o arquivo de dados se estiver utilizando uma abordagem centralizada
// <?php include 'includes/data.php'; ?>
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Profissionais - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Estilos específicos para Profissionais */
        .filters {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .filters label {
            font-weight: bold;
            margin-bottom: 5px;
            display: block;
        }

        .table-section {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .table-section th, .table-section td {
            padding: 10px;
            border-bottom: 1px solid #e2e8f0;
            text-align: left;
            font-size: 14px;
        }

        .table-section th {
            background-color: #f7fafc;
            color: #2d3748;
        }

        .status-ativo {
            color: #38A169; /* Verde para Ativo */
            font-weight: bold;
        }

        .status-desvinculado {
            color: #ED8936; /* Laranja para Desvinculado */
            font-weight: bold;
        }

        .status-inativo {
            color: #E53E3E; /* Vermelho para Inativo */
            font-weight: bold;
        }

        .action-icons {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .action-icons button {
            background: transparent;
            border: none;
            cursor: pointer;
            padding: 4px;
            font-size: 16px;
            color: #4A5568;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-icons button:hover {
            color: #08C89E;
        }

        .action-icons .icon-trash:hover {
            color: red;
        }

        /* Modal de Gerenciamento de Profissional */
        #manageProfessionalModal .modal-content {
            width: 500px;
            max-width: 90%;
        }

        #manageProfessionalModal h2 {
            margin-bottom: 5px;
            color: #2d3748;
        }

        #manageProfessionalModal .prof-info {
            font-size: 14px;
            color: #4A5568;
        }

        #manageProfessionalModal .prof-info div {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        #manageProfessionalModal .modal-actions {
            margin-top: 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        #manageProfessionalModal .modal-actions .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            color: #fff;
        }

        #manageProfessionalModal .modal-actions .btn.save {
            background-color: #48BB78;
        }

        #manageProfessionalModal .modal-actions .btn#manageProfUnlinkButton {
            background-color: #ED8936; /* Laranja para Desvincular */
        }

        #manageProfessionalModal .modal-actions .btn.delete {
            background-color: #E53E3E;
        }

        #manageProfessionalModal .modal-actions .btn.cancel {
            background-color: #A0AEC0;
        }

        #manageProfessionalModal .modal-actions .btn i {
            margin-right: 5px;
        }
        
        
    }
    
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-profissional-profissionais-1.php'; ?>

    <!-- Conteúdo -->
    
    
        <main class="content">
            <div class="header-content" style="margin-top: -55px">
                <h1 style="color: #08C89E; margin-left: 0px; "><i class="fas fa-user-md" style="margin-right: 8px"></i>Profissionais</h1>
                                <p style="margin-top: -5px">Aqui você pode gerenciar os profissionais associados às suas clínicas.</p>

            </div>
            <div class="tabs-container">

    
            <div class="filters">
                <div>
                    <label for="clinicSelect">Selecione a Clínica:</label>
                    <select id="clinicSelect" style="width: 200px">
                        <option value="">Todas</option>
                        <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                        <option value="Clínica Central">Clínica Central</option>
                        <option value="Clínica do Norte">Clínica do Norte</option>
                    </select>
                </div>
                <div>
                    <label for="searchProfessional">Pesquisar por Nome/E-mail (Profissional):</label>
                    <input style="width: 300px" type="text" id="searchProfessional" placeholder="Nome ou Email do profissional...">
                </div>
            </div>
            <table id="professionalsTable" class="table-section">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nome</th>
                        <th>Formação</th>
                        <th>Email</th>
                        <th>Clínica</th>
                        <th>Perfil</th>
                        <th>Status</th> <!-- Nova Coluna para Status -->
                        <th>#</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Profissionais via JS -->
                </tbody>
            </table>
            </div>
        </main>
    
    <!-- Modal Gerenciamento de Profissional -->
    <div id="manageProfessionalModal" class="modal" style="display: none;">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Detalhes do Profissional</h2>
            <p style="color: #4A5568; font-size: 14px; margin-top: -5px;">
                Abaixo estão as informações do profissional selecionado. Você pode editar ou excluir conforme necessário.
            </p>
            
            <hr style="margin: 15px 0; border: none; border-top: 1px solid #e2e8f0;" />

            <h3 id="manageProfName" style="font-size: 20px; color: #2d3748; margin-bottom: 10px;"></h3>

            <div class="prof-info" style="display: flex; flex-direction: column; font-size: 14px; color: #4A5568;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-briefcase" title="Profissão"></i>
                    <strong>Profissão:</strong> <span id="manageProfProfession"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-envelope" title="Email"></i>
                    <strong>Email:</strong> <span id="manageProfEmail"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-hospital-user" title="Clínica"></i>
                    <strong>Clínica:</strong> <span id="manageProfClinic"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-user-tag" title="Perfil"></i>
                    <strong>Perfil:</strong> <span id="manageProfPerfil"></span>
                </div>
                <div style="display: flex; align-items: center; gap: 8px;">
                    <i class="fas fa-info-circle" title="Status"></i>
                    <strong>Status:</strong> <span id="manageProfStatus"></span>
                </div>
            </div>

            <hr style="margin: 20px 0; border: none; border-top: 1px solid #e2e8f0;" />

            <div class="modal-actions" style="display: flex; justify-content: flex-end; gap: 10px;">
                <button class="btn save" id="manageProfEditButton">
                    <i class="fas fa-user-edit"></i> Editar Perfil
                </button>
                <button class="btn" id="manageProfUnlinkButton">
                    <!-- Conteúdo será atualizado via JS -->
                </button>
                <button class="btn delete" id="manageProfDeleteButton" style="display: none;">
                    <i class="fas fa-trash-alt"></i> Excluir
                </button>
                <button class="btn cancel" id="manageProfCancelButton">
                    <i class="fas fa-times"></i> Cancelar
                </button>
            </div>
        </div>
    </div>

    <!-- Scripts específicos para Profissionais -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Inicializa os dados globais que serão usados por múltiplos scripts
            // Se estiver usando um arquivo de dados incluído, descomente a linha abaixo
            // <?php include 'includes/data.php'; ?>

            // Exemplo de dados locais (substitua com dados reais ou carregue via backend)
            let professionals = [
                { name: 'Mariana Santos', profession: 'Fonoaudióloga', email: 'mariana.santos@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Administrador', status: 'Ativo', code: 'PRF001' },
                { name: 'Pedro Oliveira', profession: 'Psicólogo', email: 'pedro.oliveira@example.com', clinic: 'Clínica Central', perfil: 'Colaborador', status: 'Ativo', code: 'PRF002' },
                { name: 'Camila Rocha', profession: 'Nutricionista', email: 'camila.rocha@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', status: 'Ativo', code: 'PRF003' },
                { name: 'Beatriz Souza', profession: 'Terapeuta Ocupacional', email: 'beatriz.souza@example.com', clinic: 'Clínica Central', perfil: 'Administrador', status: 'Ativo', code: 'PRF004' },
                { name: 'Felipe Costa', profession: 'Fisioterapeuta', email: 'felipe.costa@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', status: 'Ativo', code: 'PRF005' },
                { name: 'Juliana Lima', profession: 'Enfermeira', email: 'juliana.lima@example.com', clinic: 'Clínica Sertãozinho', perfil: 'Colaborador', status: 'Ativo', code: 'PRF006' },
                { name: 'Ricardo Pinto', profession: 'Nutricionista', email: 'ricardo.pinto@example.com', clinic: 'Clínica Central', perfil: 'Administrador', status: 'Ativo', code: 'PRF007' },
                { name: 'Gustavo Ribeiro', profession: 'Terapeuta Ocupacional', email: 'gustavo.ribeiro@example.com', clinic: 'Clínica do Norte', perfil: 'Colaborador', status: 'Ativo', code: 'PRF008' },
            ];

            // Função para atualizar a tabela de profissionais
            function updateProfessionalsTable() {
                const clinicFilter = document.getElementById('clinicSelect').value;
                const searchFilter = document.getElementById('searchProfessional').value.toLowerCase();
                const tableBody = document.querySelector('#professionalsTable tbody');
                tableBody.innerHTML = '';

                const filtered = professionals.filter(prof => {
                    const matchClinic = !clinicFilter || prof.clinic === clinicFilter;
                    const matchSearch = prof.name.toLowerCase().includes(searchFilter) ||
                                        prof.profession.toLowerCase().includes(searchFilter) ||
                                        prof.email.toLowerCase().includes(searchFilter);
                    return matchClinic && matchSearch;
                });

                filtered.forEach(prof => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${prof.code}</td> <!-- Exibir Código -->
                        <td>${prof.name}</td>
                        <td>${prof.profession}</td>
                        <td>${prof.email}</td>
                        <td>${prof.clinic}</td>
                        <td>${prof.perfil}</td> <!-- Exibir Perfil -->
                        <td class="status-${prof.status.toLowerCase()}">${prof.status}</td> <!-- Exibir Status -->
                        <td class="action-icons">
                            <button class="btn manage-icon" onclick="openManageProfessionalModal('${prof.email}')">
                                <i class="fas fa-cog" title="Gerenciar"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });
            }

            // Eventos de filtro
            document.getElementById('clinicSelect').addEventListener('change', updateProfessionalsTable);
            document.getElementById('searchProfessional').addEventListener('input', updateProfessionalsTable);
            updateProfessionalsTable();

            // Função para abrir o modal de gerenciamento
            window.openManageProfessionalModal = function(email) {
                const professional = professionals.find(prof => prof.email === email);
                if (professional) {
                    document.getElementById('manageProfName').textContent = professional.name;
                    document.getElementById('manageProfProfession').textContent = professional.profession;
                    document.getElementById('manageProfEmail').textContent = professional.email;
                    document.getElementById('manageProfClinic').textContent = professional.clinic;
                    document.getElementById('manageProfPerfil').textContent = professional.perfil;
                    document.getElementById('manageProfStatus').textContent = professional.status;

                    // Armazenar o email do profissional no botão para referência
                    document.getElementById('manageProfEditButton').dataset.email = email;
                    document.getElementById('manageProfUnlinkButton').dataset.email = email;
                    document.getElementById('manageProfDeleteButton').dataset.email = email;

                    // Atualizar Botões de Ação com base no Status
                    updateManageModalActions(professional.status);

                    // Abrir o modal
                    document.getElementById('manageProfessionalModal').style.display = 'block';
                } else {
                    alert('Profissional não encontrado.');
                }
            }

            // Função para atualizar os botões de ação no modal com base no status
            function updateManageModalActions(status) {
                const editButton = document.getElementById('manageProfEditButton');
                const unlinkButton = document.getElementById('manageProfUnlinkButton');
                const deleteButton = document.getElementById('manageProfDeleteButton');

                if (status.toLowerCase() === 'ativo') {
                    // Situação 1 e 2
                    unlinkButton.style.display = 'inline-flex';
                    unlinkButton.innerHTML = `<i class="fas fa-unlink"></i> Inativar`;
                    deleteButton.style.display = 'none'; // Não permite excluir enquanto estiver ativo
                } else if (status.toLowerCase() === 'inativo') {
                    // Situação 3 e 4
                    unlinkButton.style.display = 'inline-flex';
                    unlinkButton.innerHTML = `<i class="fas fa-link"></i> Reativar`;
                    deleteButton.style.display = 'inline-flex'; // Permite excluir apenas se desvinculado
                } else {
                    // Outros statuses, se houver
                    unlinkButton.style.display = 'none';
                    deleteButton.style.display = 'none';
                }
            }

            // Função para fechar o modal de gerenciamento
            window.closeManageProfessionalModal = function() {
                document.getElementById('manageProfessionalModal').style.display = 'none';
                // Resetar dados no modal
                document.getElementById('manageProfName').textContent = '';
                document.getElementById('manageProfProfession').textContent = '';
                document.getElementById('manageProfEmail').textContent = '';
                document.getElementById('manageProfClinic').textContent = '';
                document.getElementById('manageProfPerfil').textContent = '';
                document.getElementById('manageProfStatus').textContent = '';
            }

            // Eventos para fechar o modal
            const manageProfModal = document.getElementById('manageProfessionalModal');
            const manageProfCloseBtn = manageProfModal.querySelector('.close');
            const manageProfCancelBtn = document.getElementById('manageProfCancelButton');

            manageProfCloseBtn.onclick = function() {
                closeManageProfessionalModal();
            }

            manageProfCancelBtn.onclick = function() {
                closeManageProfessionalModal();
            }

            window.onclick = function(event) {
                if (event.target == manageProfModal) {
                    closeManageProfessionalModal();
                }
            }

            // Função para editar perfil a partir do modal
            document.getElementById('manageProfEditButton').addEventListener('click', function() {
                const email = this.dataset.email;
                openEditPerfilModal(email);
                closeManageProfessionalModal();
            });

            // Função para desvincular ou vincular profissional a partir do modal
            document.getElementById('manageProfUnlinkButton').addEventListener('click', function() {
                const email = this.dataset.email;
                const professional = professionals.find(prof => prof.email === email);

                if (!professional) {
                    alert('Profissional não encontrado.');
                    return;
                }

                if (professional.status.toLowerCase() === 'ativo') {
                    // Situação 2: Desvincular
                    if (confirm('Tem certeza que deseja desvincular este profissional?')) {
                        professional.status = 'Inativo';
                        updateProfessionalsTable();
                        // Atualizar histórico se necessário
                        alert('Profissional desvinculado com sucesso.');
                        closeManageProfessionalModal();
                    }
                } else if (professional.status.toLowerCase() === 'inativo') {
                    // Situação 3: Vincular
                    if (confirm('Tem certeza que deseja vincular este profissional novamente?')) {
                        professional.status = 'Ativo';
                        updateProfessionalsTable();
                        // Atualizar histórico se necessário
                        alert('Profissional vinculado novamente com sucesso.');
                        closeManageProfessionalModal();
                    }
                }
            });

            // Função para excluir profissional a partir do modal
            document.getElementById('manageProfDeleteButton').addEventListener('click', function() {
                const email = this.dataset.email;
                const professional = professionals.find(prof => prof.email === email);

                if (!professional) {
                    alert('Profissional não encontrado.');
                    return;
                }

                if (professional.status.toLowerCase() !== 'inativo') {
                    alert('Para excluir, o profissional deve estar desvinculado.');
                    return;
                }

                if (confirm('Tem certeza que deseja excluir este profissional?')) {
                    professionals = professionals.filter(prof => prof.email !== email);
                    updateProfessionalsTable();
                    alert('Profissional excluído com sucesso.');
                    closeManageProfessionalModal();
                }
            });
        });
    </script>
</body>
</html>
