<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gerenciamento - Sistema de Avaliação IFCora</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        /* Card de Perfil com Abas Lado a Lado */
        .profile-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
        }
        .profile-left {
            width: 100%;
            max-width: 300px;
            padding-right: 15px;
            border-right: 1px solid #e2e8f0;
        }
        .profile-right {
            flex: 1;
            padding-left: 15px;
        }
        .profile-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            position: relative;
        }
        .profile-header img {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
        }
        .edit-photo {
            position: absolute;
            top: 60px;
            left: 60px;
            background-color: #08C89E;
            color: #fff;
            border: none;
            border-radius: 50%;
            padding: 6px;
            cursor: pointer;
        }
        .profile-header h2 {
            font-size: 22px;
            color: #08C89E;
            line-height: 100%;
        }
        .profile-info p {
            font-size: 15px;
            color: #4a5568;
            margin-bottom: 6px;
            margin: 0px;
        }
        
        
        .profile-actions {
            display: flex;
            flex-wrap: wrap;
            margin-top: 10px;
        }
        .profile-actions button {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 12px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
            margin-right: 8px;
            margin-bottom: 8px;
            transition: background 0.3s;
            display: flex;
            align-items: center;
        }
        .profile-actions button:hover {
            background-color: #06b287;
        }
        .profile-actions button i {
            margin-right: 4px;
        }
        
        
        
        
        
        .person-card {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            margin-bottom: 10px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }
        .person-card h3 {
            font-size: 15px;
            color: #2d3748;
            margin-bottom: 4px;
            margin-top: 0px;
        }
        .person-card p {
            font-size: 13px;
            color: #4a5568;
            margin: 0px;
        }
        .person-card .remove-btn {
            background-color: #E53E3E;
            color: #fff;
            padding: 6px 10px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            margin-top: 8px;
            transition: background 0.3s;
        }
        .person-card .remove-btn:hover {
            background-color: #c53030;
        }
        
        
        
        #responsaveis .person-card {
            display: inline-block;
            width: calc(30% - 10px);
            margin: 5px;
            vertical-align: top;
        }
        
        
        .remove-icon {
            font-size: 16px;
            color: #e53e3e;
            cursor: pointer;
            transition: color 0.3s;
        }
        .remove-icon:hover {
            color: #c53030;
        }

        .annotations {
            margin-top: 40px;
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
        }
        .annotations h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
            text-align: left;
        }
        .status-button {
            background-color: #ffffff;
            color: #F7702D;
            border: 2px solid #F7702D;
            padding: 5px 10px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s;
        }
        .status-button:hover {
            background-color: #F7702D;
            color: #ffffff;
        }
        
        
        /* Estilos para o Formulário de Anamnese */
.anamnese-form {
    margin-top: 20px;
}

        /* Ferramentas */
        .tools {
            margin-top: 20px;
        }
        .tools h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
        }
        .tools-grid {
            display: grid; /* Usa Grid Layout */
            grid-template-columns: repeat(4, 1fr); /* Até 4 colunas */
            gap: 20px; /* Espaçamento entre os cartões */
        }
        .tool-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 15px;
            transition: box-shadow 0.2s, transform 0.2s;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .tool-card:hover {
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }
        .tool-info h3 {
            font-size: 18px;
            color: #2d3748;
            margin: 0 0 5px;
            font-weight: 600;
        }
        .tool-info p {
            font-size: 14px;
            color: #4a5568;
            margin: 0 0 10px;
        }
        .tool-info button {
            background-color: #08C89E;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 6px;
            font-size: 14px;
            cursor: pointer;
            transition: background 0.3s;
            align-self: start;
        }
        .tool-info button:hover {
            background-color: #06b287;
        }
        
        
        /* Área de Texto para Anotações */
        .annotation-area {
            width: 100%;
            margin-top: 10px;
        }
        .annotation-area textarea {
            width: 100%;
            height: 80px;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            resize: vertical;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
        }
        .annotation-area button {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
            margin-top: 8px;
            transition: background 0.3s;
        }
        .annotation-area button:hover {
            background-color: #06b287;
        }
        /* Estilos das Anotações */
        .annotation {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            margin-bottom: 10px;
            margin-top: 10px;
        }
        .annotation-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .annotation-author {
            font-weight: bold;
            font-size: 14px;
            color: #2d3748;
        }
        .annotation-date {
            font-size: 12px;
            color: #718096;
        }
        .annotation-content {
            margin-top: 5px;
            font-size: 14px;
            color: #4a5568;
        }
        .annotation-actions {
            margin-top: 5px;
            display: flex;
            gap: 10px;
        }
        .annotation-actions button {
            background: none;
            border: none;
            color: #08C89E;
            cursor: pointer;
            font-size: 13px;
            padding: 0;
        }
        .annotation-actions button:hover {
            text-decoration: underline;
        }
        /* Respostas às Anotações */
        .annotation-replies {
            margin-left: 20px;
            margin-top: 10px;
        }
        /* Formulário de Anamnese */
        .anamnese-form h2 {
    font-size: 22px;
    color: #2d3748;
    margin-bottom: 15px;
    text-align: left;
}

.anamnese-form fieldset {
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 20px;
}

.anamnese-form legend {
    font-size: 18px;
    font-weight: 600;
    color: #08C89E;
    padding: 0 10px;
}

.anamnese-form .form-group {
    margin-bottom: 15px;
}

.anamnese-form label {
    display: block;
    font-size: 14px;
    color: #2d3748;
    margin-bottom: 5px;
}

.anamnese-form input,
.anamnese-form select,
.anamnese-form textarea {
    width: 100%;
    padding: 8px;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    font-size: 14px;
    color: #2d3748;
    box-sizing: border-box;
    background-color: #fff;
}

.anamnese-form input:focus,
.anamnese-form select:focus,
.anamnese-form textarea:focus {
    outline: none;
    border-color: #08C89E;
    box-shadow: 0 0 0 1px #08C89E;
}

.anamnese-form .radio-group {
    display: flex;
    gap: 20px;
    align-items: center;
}

.anamnese-form .radio-group input {
    margin-right: 5px;
}

.submit-btn {
    background-color: #08C89E;
    color: #fff;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 15px;
    transition: background 0.3s;
}

.submit-btn:hover {
    background-color: #06b287;
}
        
        
        /* Estilos do Modal */
        .modal {
            display: none; /* Oculto por padrão */
            position: fixed;
            z-index: 200; /* Sobrepõe outros elementos */
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.5); /* Fundo semitransparente */
        }
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto; /* Centraliza verticalmente */
            padding: 20px;
            border: 1px solid #888;
            width: 80%; /* Largura do modal */
            max-width: 800px;
            border-radius: 10px;
            position: relative;
        }
        .close-button {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            position: absolute;
            right: 20px;
            top: 10px;
            cursor: pointer;
        }
        .close-button:hover,
        .close-button:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        
        
        .annotations {
            margin-top: 40px;
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
        }
        .annotations h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
            text-align: left;
        }
        .status-button {
            background-color: #ffffff;
            color: #F7702D;
            border: 2px solid #F7702D;
            padding: 5px 10px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s, color 0.3s;
        }
        .status-button:hover {
            background-color: #F7702D;
            color: #ffffff;
        }
        
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-responsavel-criancas.php'; ?>

    <!-- Conteúdo -->
    <main class="content">
        <div class="header-content">
            <h1>Perfil da Criança</h1>
        </div>
        <!-- Card de Perfil com Abas Lado a Lado -->
        <section class="profile-card">
            <!-- Esquerda: Informações do Perfil -->
            <div class="profile-left">
                <div class="profile-header">
                    <img src="https://via.placeholder.com/90" alt="Foto da Criança">
                    <!-- Botão para alterar foto -->
                    <button class="edit-photo" title="Alterar Foto"><i class="fas fa-camera"></i></button>
                    <h2>Luís Gustavo de Oliveira Santos Barosa</h2>
                </div>
                <div class="profile-info">
                    <p><b>ID:</b> #ABC12345</p>
                    <p><b>Data de Nasc.:</b> 01/01/2016</p>
                    <p><b>Idade:</b> 7 anos</p>
                    <p><b>Responsável:</b> Maria da Silva</p>
                    <p><b>Clínica:</b> Independente</p>
                    

                    <p>‎ </p>
                </div>
                <!-- Ações do Perfil -->
                
            </div>
            <!-- Direita: Abas -->
            <div class="profile-right">
                <!-- Abas -->
                <div class="tab-container">
                    <div class="tabs">
                        
                        <div class="tab active" class="tab" data-tab="profissionais">Profissionais</div>
                        <div class="tab" data-tab="supervisores">Supervisores</div>
                        <div class="tab" data-tab="responsaveis">Responsáveis e Assistentes</div>
                        
                        
                    </div>
                    <!-- Conteúdo das Abas -->
                    
                    
                    <div id="profissionais" class="tab-content active">
                        
                        <!-- Cards de pessoas -->
                        <div class="person-card">
                            <div class="card-header">
                                <h3>Maria da Silva</h3>
                                <i class="fas fa-trash remove-icon" title="Remover"></i>
                            </div>
                            <p><b>Tipo:</b> Responsável</p>
                            <p><b>Contato:</b> (11) 99999-9999</p>
                        </div>
                        
                       
                    </div>
                    
                    <div id="supervisores" class="tab-content">
                        
                        <!-- Cards de pessoas -->
                        
                        <div class="person-card">
                            <div class="card-header">
                                <h3>Carla Paes</h3>
                                <i class="fas fa-trash remove-icon" title="Remover"></i>
                            </div>
                            <p><b>Tipo:</b> Colaborador</p>
                            <p><b>Profissão:</b> Fonoaudiólogo</p>
                        </div>
                        <div class="person-card">
                            <div class="card-header">
                                <h3>Pedro Silva</h3>
                                <i class="fas fa-trash remove-icon" title="Remover"></i>
                            </div>
                            <p><b>Tipo:</b> Colaborador</p>
                            <p><b>Profissão:</b> Terapeuta Ocupacional</p>
                        </div>
                        
                        
                    </div>
                    
                    

                    <div id="responsaveis" class="tab-content">
                        
                        <!-- Cards de pessoas -->
                        <div class="person-card">
                            <div class="card-header">
                                <h3>Maria da Silva</h3>
                                <i class="fas fa-trash remove-icon" title="Remover"></i>
                            </div>
                            <p><b>Tipo:</b> Responsável</p>
                            <p><b>Contato:</b> (11) 99999-9999</p>
                        </div>
                        <div class="person-card">
                            <div class="card-header">
                                <h3>João Pereira</h3>
                                <i class="fas fa-trash remove-icon" title="Remover"></i>
                            </div>
                            <p><b>Tipo:</b> Assistente</p>
                            <p><b>Profissão:</b> Fonoaudiólogo</p>
                        </div>
                        
                        
                    </div>
                    

                    <div id="historico" class="tab-content">
                        <!-- Conteúdo do Histórico de Avaliações -->
                        <ul class="evaluation-list">
                            <li>
                                <span>Portage - 15/03/2023</span>
                                <a href="#">Ver Detalhes</a>
                            </li>
                            <li>
                                <span>CARS - 20/04/2023</span>
                                <a href="#">Ver Detalhes</a>
                            </li>
                            <!-- Outros registros de avaliação -->
                        </ul>
                    </div>
                    
                                        
                    
                </div>
            </div>
        </section>
        
        
        <!-- Modal para o Formulário de Anamnese -->
<div id="anamnese-modal" style="display: none; position: fixed; z-index: 1001; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0, 0, 0, 0.5); justify-content: center; align-items: center;">
    <div style="background-color: #fefefe; margin: auto; padding: 20px; border: 1px solid #888; border-radius: 12px; width: 90%; max-width: 800px; position: relative; display: flex; flex-direction: column;">
        <span id="closeAnamneseModal" style="color: #aaa; font-size: 24px; font-weight: bold; position: absolute; top: 10px; right: 20px; cursor: pointer;">&times;</span>
        
        <section style="margin-top: -10px; margin-bottom: -5px;">
            <h2 style="font-size: 20px; font-weight: bold; color: #333; margin-bottom: 10px;">Formulário de Anamnese</h2>
            <hr style="border: 1px solid #e2e8f0; margin-bottom: 20px;">
            
            <form method="POST" action="processar_formulario.php">
                <!-- 1. Identificação da Criança -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">1. Identificação da Criança</legend>
    
                    <div style="display: flex; gap: 15px; margin-bottom: 10px;">
                        <div style="flex: 2; display: flex; flex-direction: column;">
                            <label for="nome_crianca" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Nome completo:</label>
                            <input type="text" id="nome_crianca" name="nome_crianca" value="João Silva" required style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                        </div>
    
                        <div style="flex: 1; display: flex; flex-direction: column;">
                            <label for="data_nascimento" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Data de nascimento:</label>
                            <input type="date" id="data_nascimento" name="data_nascimento" value="2015-05-20" required style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                        </div>
                    </div>
    
                    <div style="display: flex; gap: 15px; margin-bottom: 10px;">
                        <div style="flex: 1; display: flex; flex-direction: column;">
                            <label for="idade_atual" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Idade atual:</label>
                            <input type="number" id="idade_atual" name="idade_atual" min="0" value="8" required style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                        </div>
    
                        <div style="flex: 1; display: flex; flex-direction: column;">
                            <label for="sexo" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Sexo:</label>
                            <select id="sexo" name="sexo" required style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                                <option value="">Selecione</option>
                                <option value="masculino" selected>Masculino</option>
                                <option value="feminino">Feminino</option>
                                <option value="outro">Outro</option>
                            </select>
                        </div>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="responsaveis" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Nome e contato dos responsáveis:</label>
                        <textarea id="responsaveis" name="responsaveis" rows="3" required style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Maria Silva (mãe) - (11) 99999-9999; Pedro Silva (pai) - (11) 98888-8888</textarea>
                    </div>
                </fieldset>
    
                <!-- 2. Histórico Familiar -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">2. Histórico Familiar</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="composicao_familiar" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Composição familiar (nome, idade, relação com a criança):</label>
                        <textarea id="composicao_familiar" name="composicao_familiar" rows="5" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Maria Silva, 35 anos, mãe; Pedro Silva, 37 anos, pai; Ana Silva, 10 anos, irmã</textarea>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Há casos na família de transtornos neurológicos, atraso de fala, autismo ou outros diagnósticos relevantes?</label>
                        <div style="display: flex; gap: 10px; align-items: center;">
                            <input type="radio" id="historico_sim" name="historico_familiar" value="sim">
                            <label for="historico_sim" style="font-size: 14px; color: #333;">Sim</label>
    
                            <input type="radio" id="historico_nao" name="historico_familiar" value="nao" checked>
                            <label for="historico_nao" style="font-size: 14px; color: #333;">Não</label>
                        </div>
                    </div>
    
                    <div id="detalhes_historico_group" style="display: none; margin-bottom: 10px;">
                        <label for="detalhes_historico" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Se sim, especifique quais e em quais familiares:</label>
                        <textarea id="detalhes_historico" name="detalhes_historico" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;"></textarea>
                    </div>
                </fieldset>
    
                <!-- 3. Histórico Gestacional e Neonatal -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">3. Histórico Gestacional e Neonatal</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">A gestação foi planejada?</label>
                        <div style="display: flex; gap: 10px; align-items: center;">
                            <input type="radio" id="gestacao_sim" name="gestacao_planejada" value="sim" checked>
                            <label for="gestacao_sim" style="font-size: 14px; color: #333;">Sim</label>
    
                            <input type="radio" id="gestacao_nao" name="gestacao_planejada" value="nao">
                            <label for="gestacao_nao" style="font-size: 14px; color: #333;">Não</label>
                        </div>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="complicacoes_gestacao" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Houve complicações durante a gravidez? Se sim, quais?</label>
                        <textarea id="complicacoes_gestacao" name="complicacoes_gestacao" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Nenhuma complicação significativa.</textarea>
                    </div>
    
                    <div style="display: flex; gap: 15px; margin-bottom: 10px;">
                        <div style="flex: 1; display: flex; flex-direction: column;">
                            <label for="tipo_parto" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Tipo de parto:</label>
                            <select id="tipo_parto" name="tipo_parto" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                                <option value="">Selecione</option>
                                <option value="normal" selected>Normal</option>
                                <option value="cesarea">Cesárea</option>
                                <option value="prematuro">Prematuro</option>
                            </select>
                        </div>
    
                        <div style="flex: 1; display: flex; flex-direction: column;">
                            <label for="semanas_gestacao" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Quantas semanas de gestação?</label>
                            <input type="number" id="semanas_gestacao" name="semanas_gestacao" min="20" max="42" value="39" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                        </div>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label style="font-size: 14px; font-weight: normal; color: #333;">A criança necessitou de cuidados especiais ao nascer (ex.: UTI neonatal)?</label>
                        <div style="display: flex; gap: 10px; align-items: center;">
                            <input type="radio" id="cuidados_sim" name="cuidados_especiais" value="sim">
                            <label for="cuidados_sim" style="font-size: 14px; color: #333;">Sim</label>
    
                            <input type="radio" id="cuidados_nao" name="cuidados_especiais" value="nao" checked>
                            <label for="cuidados_nao" style="font-size: 14px; color: #333;">Não</label>
                        </div>
                    </div>
    
                    <div id="detalhes_cuidados_group" style="display: none; margin-bottom: 10px;">
                        <label for="detalhes_cuidados" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Se sim, quais cuidados?</label>
                        <textarea id="detalhes_cuidados" name="detalhes_cuidados" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;"></textarea>
                    </div>
                </fieldset>
    
                <!-- 4. Histórico Médico e Saúde Geral -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">4. Histórico Médico e Saúde Geral</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="diagnostico_medico" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">A criança possui algum diagnóstico médico atual (ex.: epilepsia, alergias, problemas auditivos ou visuais)?</label>
                        <textarea id="diagnostico_medico" name="diagnostico_medico" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Nenhum diagnóstico médico atual.</textarea>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="internacoes" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Já foi internada ou submetida a cirurgias? Se sim, quando e por quê?</label>
                        <textarea id="internacoes" name="internacoes" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Não.</textarea>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="medicamentos" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Faz uso de medicação contínua? Se sim, quais?</label>
                        <textarea id="medicamentos" name="medicamentos" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Não.</textarea>
                    </div>
                </fieldset>
    
                <!-- 5. Rotina e Ambiente -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">5. Rotina e Ambiente</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="cuidador_principal" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Quem é o principal cuidador da criança?</label>
                        <input type="text" id="cuidador_principal" name="cuidador_principal" value="Maria Silva (mãe)" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label style="font-size: 14px; font-weight: normal; color: #333;">A criança frequenta escola ou creche?</label>
                        <div style="display: flex; gap: 10px; align-items: center;">
                            <input type="radio" id="escola_sim" name="frequenta_escola" value="sim" checked>
                            <label for="escola_sim" style="font-size: 14px; color: #333;">Sim</label>
    
                            <input type="radio" id="escola_nao" name="frequenta_escola" value="nao">
                            <label for="escola_nao" style="font-size: 14px; color: #333;">Não</label>
                        </div>
                    </div>
    
                    <div id="nome_instituicao_group" style="margin-bottom: 10px;">
                        <label for="nome_instituicao" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Se sim, qual instituição e em que período?</label>
                        <textarea id="nome_instituicao" name="nome_instituicao" rows="2" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Escola Infantil ABC, período da manhã.</textarea>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="exposicao_estresse" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Há exposição a fatores estressantes no ambiente familiar (ex.: conflitos, mudanças frequentes, perdas recentes)?</label>
                        <textarea id="exposicao_estresse" name="exposicao_estresse" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Não há exposição a fatores estressantes significativos.</textarea>
                    </div>
                </fieldset>
    
                <!-- 6. Histórico Escolar (se aplicável) -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">6. Histórico Escolar (se aplicável)</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="comportamento_escola" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Como é o comportamento da criança na escola ou creche?</label>
                        <textarea id="comportamento_escola" name="comportamento_escola" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">João é participativo e interage bem com os colegas.</textarea>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="preocupacao_escola" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">A instituição já sinalizou alguma preocupação com a criança?</label>
                        <textarea id="preocupacao_escola" name="preocupacao_escola" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">A professora mencionou que ele tem dificuldade em manter a atenção em atividades prolongadas.</textarea>
                    </div>
                </fieldset>
    
                <!-- 7. Motivo da Avaliação -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">7. Motivo da Avaliação</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="motivo_avaliacao" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">O que motivou a busca por avaliação?</label>
                        <textarea id="motivo_avaliacao" name="motivo_avaliacao" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Preocupação com a dificuldade de atenção e concentração.</textarea>
                    </div>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="preocupacoes_especificas" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Há preocupações específicas com o comportamento ou desenvolvimento da criança?</label>
                        <textarea id="preocupacoes_especificas" name="preocupacoes_especificas" rows="3" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">Dificuldade em concluir tarefas que exigem foco por mais tempo.</textarea>
                    </div>
                </fieldset>
    
                <!-- 8. Observações Adicionais -->
                <fieldset style="border: 1px solid #ccc; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
                    <legend style="font-size: 18px; font-weight: bold; color: #333;">8. Observações Adicionais</legend>
    
                    <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                        <label for="observacoes" style="font-size: 14px; font-weight: normal; color: #333; margin-bottom: 5px;">Espaço para anotações relevantes dos responsáveis:</label>
                        <textarea id="observacoes" name="observacoes" rows="5" style="padding: 8px; border-radius: 4px; border: 1px solid #ccc;">João tem demonstrado interesse em esportes e atividades ao ar livre.</textarea>
                    </div>
                </fieldset>
    
                <!-- Botão de Enviar -->
                <button type="submit" style="background-color: #08C89E; color: #fff; border: none; padding: 10px 20px; border-radius: 8px; cursor: pointer; font-size: 16px;">Enviar</button>
            </form>
        </section>
    </div>
</div>

        
        
        
        
        <!-- Seção de Anotações -->
        <section id="anotacoes-section" class="annotations">
            <h2>Anotações</h2>
            <!-- Área de Texto para Anotações -->
            <div class="annotation-area">
                <textarea placeholder="Escreva uma nova anotação..."></textarea>
                <button><i class="fas fa-paper-plane" ></i> Salvar Anotação</button>
            </div>
            <!-- Lista de Anotações Anteriores -->
            <div class="annotation">
                <div class="annotation-header">
                    <div class="annotation-author">Coralina Matos</div>
                    <div class="annotation-date">10/05/2023</div>
                </div>
                <div class="annotation-content">
                    Esta é uma anotação de exemplo. Aqui estão os detalhes importantes.
                </div>
                <div class="annotation-actions">
                    <button class="reply-btn">Responder</button>
                    <button class="edit-btn">Editar</button>
                    <button class="delete-btn">Excluir</button>
                </div>
                <!-- Respostas -->
                <div class="annotation-replies">
                    <div class="annotation">
                        <div class="annotation-header">
                            <div class="annotation-author">João Pereira</div>
                            <div class="annotation-date">11/05/2023</div>
                        </div>
                        <div class="annotation-content">
                            Esta é uma resposta à anotação.
                        </div>
                        <div class="annotation-actions">
                            <button class="reply-btn">Responder</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="annotation">
                <div class="annotation-header">
                    <div class="annotation-author">Coralina Matos</div>
                    <div class="annotation-date">10/05/2023</div>
                </div>
                <div class="annotation-content">
                    Esta é uma anotação de exemplo. Aqui estão os detalhes importantes.
                </div>
                <div class="annotation-actions">
                    <button class="reply-btn">Responder</button>
                    <button class="edit-btn">Editar</button>
                    <button class="delete-btn">Excluir</button>
                </div>
                <!-- Respostas -->
                <div class="annotation-replies">
                    <div class="annotation">
                        <div class="annotation-header">
                            <div class="annotation-author">João Pereira</div>
                            <div class="annotation-date">11/05/2023</div>
                        </div>
                        <div class="annotation-content">
                            Esta é uma resposta à anotação.
                        </div>
                        <div class="annotation-actions">
                            <button class="reply-btn">Responder</button>
                        </div>
                        
                    </div>
                    <div class="annotation">
                        <div class="annotation-header">
                            <div class="annotation-author">João Pereira</div>
                            <div class="annotation-date">11/05/2023</div>
                        </div>
                        <div class="annotation-content">
                            Esta é uma resposta à anotação.
                        </div>
                        <div class="annotation-actions">
                            <button class="reply-btn">Responder</button>
                        </div>
                        
                    </div>
                </div>
            </div>
            <!-- Outras anotações -->
        </section>
        
        
        
        


    </main>

    <!-- JavaScript para as Abas e Formulários -->
    <script>
        // Seleciona todas as abas
        const tabs = document.querySelectorAll('.tab');
        // Seleciona todo o conteúdo das abas
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                // Remove a classe 'active' de todas as abas e conteúdos
                tabs.forEach(item => item.classList.remove('active'));
                tabContents.forEach(content => content.classList.remove('active'));

                // Adiciona a classe 'active' na aba clicada e no conteúdo correspondente
                tab.classList.add('active');
                document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
            });
        });

        // Modal do Formulário de Anamnese
        const openAnamneseModalBtn = document.getElementById('open-anamnese-modal');
        const anamneseModal = document.getElementById('anamnese-modal');
        const closeModalBtn = document.querySelector('.close-button');

        openAnamneseModalBtn.addEventListener('click', () => {
            anamneseModal.style.display = 'block';
        });

        closeModalBtn.addEventListener('click', () => {
            anamneseModal.style.display = 'none';
        });

        // Fechar o modal ao clicar fora dele
        window.addEventListener('click', (event) => {
            if (event.target == anamneseModal) {
                anamneseModal.style.display = 'none';
            }
        });
    </script>
    
    <script>
    // Mostrar/ocultar detalhes do histórico familiar
    document.getElementsByName('historico_familiar').forEach((elem) => {
        elem.addEventListener('change', function() {
            let detalhesGroup = document.getElementById('detalhes_historico_group');
            if (this.value === 'sim') {
                detalhesGroup.style.display = 'block';
            } else {
                detalhesGroup.style.display = 'none';
            }
        });
    });

    // Mostrar/ocultar detalhes dos cuidados especiais
    document.getElementsByName('cuidados_especiais').forEach((elem) => {
        elem.addEventListener('change', function() {
            let detalhesCuidadosGroup = document.getElementById('detalhes_cuidados_group');
            if (this.value === 'sim') {
                detalhesCuidadosGroup.style.display = 'block';
            } else {
                detalhesCuidadosGroup.style.display = 'none';
            }
        });
    });

    // Mostrar/ocultar nome da instituição
    document.getElementsByName('frequenta_escola').forEach((elem) => {
        elem.addEventListener('change', function() {
            let instituicaoGroup = document.getElementById('nome_instituicao_group');
            if (this.value === 'sim') {
                instituicaoGroup.style.display = 'block';
            } else {
                instituicaoGroup.style.display = 'none';
            }
        });
    });
</script>

<script>
    // Função para fechar o modal ao clicar no "X"
    document.getElementById('closeAnamneseModal').addEventListener('click', function() {
        document.getElementById('anamnese-modal').style.display = 'none';
    });

    // Fechar o modal ao clicar fora da área de conteúdo
    window.addEventListener('click', function(event) {
        const modal = document.getElementById('anamnese-modal');
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    });

    // Lógica para mostrar/ocultar campos condicionais

    // Histórico Familiar
    const historicoSim = document.getElementById('historico_sim');
    const historicoNao = document.getElementById('historico_nao');
    const detalhesHistoricoGroup = document.getElementById('detalhes_historico_group');

    historicoSim.addEventListener('change', function() {
        if (this.checked) {
            detalhesHistoricoGroup.style.display = 'block';
        }
    });

    historicoNao.addEventListener('change', function() {
        if (this.checked) {
            detalhesHistoricoGroup.style.display = 'none';
            document.getElementById('detalhes_historico').value = '';
        }
    });

    // Histórico Gestacional e Neonatal
    const cuidadosSim = document.getElementById('cuidados_sim');
    const cuidadosNao = document.getElementById('cuidados_nao');
    const detalhesCuidadosGroup = document.getElementById('detalhes_cuidados_group');

    cuidadosSim.addEventListener('change', function() {
        if (this.checked) {
            detalhesCuidadosGroup.style.display = 'block';
        }
    });

    cuidadosNao.addEventListener('change', function() {
        if (this.checked) {
            detalhesCuidadosGroup.style.display = 'none';
            document.getElementById('detalhes_cuidados').value = '';
        }
    });

    // Rotina e Ambiente - Frequência na Escola
    const frequentaEscolaSim = document.getElementById('escola_sim');
    const frequentaEscolaNao = document.getElementById('escola_nao');
    const nomeInstituicaoGroup = document.getElementById('nome_instituicao_group');

    frequentaEscolaSim.addEventListener('change', function() {
        if (this.checked) {
            nomeInstituicaoGroup.style.display = 'block';
        }
    });

    frequentaEscolaNao.addEventListener('change', function() {
        if (this.checked) {
            nomeInstituicaoGroup.style.display = 'none';
            document.getElementById('nome_instituicao').value = '';
        }
    });
</script>
    
    
    
</body>
</html>
