<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Responsável - Meu Perfil</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        .profile-form {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            max-width: 100%;
            box-sizing: border-box;
            margin-bottom: 20px;
        }

        .profile-form h2 {
            font-size: 24px;
            color: #08C89E;
            margin-bottom: 10px;
            text-align: left;
        }

        .profile-form form {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .profile-form .column {
            background-color: #f9fafb;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
        }

        .profile-form .column h3 {
            font-size: 18px;
            color: #2d3748;
            margin-bottom: 15px;
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 10px;
        }

        .profile-form label {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #2d3748;
            display: block;
        }

        .profile-form input,
        .profile-form select,
        .profile-form textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
        }

        .profile-form input[readonly] {
            background-color: #edf2f7;
            cursor: not-allowed;
        }

        .profile-form button {
            background-color: #08C89E;
            color: #fff;
            padding: 10px 20px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 14px;
            margin-top: 10px;
        }

        .profile-form button:hover {
            background-color: #06b287;
        }

        @media(max-width:992px) {
            .profile-form form {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-responsavel-perfil.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1 style="color:#08C89E;">Meu Perfil</h1>
        </div>

        <div class="profile-form">
            <form id="responsavelProfileForm">
                <!-- Coluna Dados Pessoais -->
                <div class="column">
                    <h3>Dados Pessoais</h3>
                    <label for="profileName">Nome Completo</label>
                    <input type="text" id="profileName" name="profileName" value="Maria da Silva">

                    <label for="profileEmail">Email</label>
                    <input type="email" id="profileEmail" name="profileEmail" value="maria.silva@example.com" readonly>

                    <label for="profilePhone">Telefone</label>
                    <input type="tel" id="profilePhone" name="profilePhone" value="(11) 99999-9999">
                </div>

                <!-- Coluna Endereço -->
                <div class="column">
                    <h3>Endereço</h3>
                    <label for="profileStreet">Endereço</label>
                    <input type="text" id="profileStreet" name="profileStreet" placeholder="Rua Exemplo" value="Rua das Flores">

                    <label for="profileNumber">Número</label>
                    <input type="text" id="profileNumber" name="profileNumber" placeholder="123" value="123">

                    <label for="profileComplement">Complemento</label>
                    <input type="text" id="profileComplement" name="profileComplement" placeholder="Apto 45" value="Apto 10B">

                    <label for="profileNeighborhood">Bairro</label>
                    <input type="text" id="profileNeighborhood" name="profileNeighborhood" placeholder="Bairro Exemplo" value="Centro">

                    <label for="profileCity">Cidade</label>
                    <input type="text" id="profileCity" name="profileCity" placeholder="Cidade Exemplo" value="São Paulo">

                    <label for="profileState">Estado</label>
                    <select id="profileState" name="profileState">
                        <option value="">Selecione</option>
                        <option value="SP" selected>São Paulo (SP)</option>
                        <!-- outros estados -->
                    </select>

                    <label for="profileCEP">CEP</label>
                    <input type="text" id="profileCEP" name="profileCEP" placeholder="12345-678" value="01000-000">
                </div>

                <!-- Coluna Alterar Senha -->
                <div class="column">
                    <h3>Alterar Senha</h3>
                    <label for="currentPassword">Senha Atual</label>
                    <input type="password" id="currentPassword" name="currentPassword">

                    <label for="newPassword">Nova Senha</label>
                    <input type="password" id="newPassword" name="newPassword">

                    <label for="confirmPassword">Repetir Nova Senha</label>
                    <input type="password" id="confirmPassword" name="confirmPassword">

                    <button type="submit">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </main>

    <script>
        document.getElementById('responsavelProfileForm').addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Alterações salvas com sucesso!');
        });
    </script>
</body>
</html>
