<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Admin - Gestão de Pacientes</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        body {
            font-family:'Poppins', sans-serif;
            background:#f7fafc;
        }

        .header-content h1 {
            color: #08C89E;
            margin-top: -20px;
        }

        .filters {
            display: flex;
            align-items: flex-end;
            gap: 20px;
            flex-wrap: wrap;
            margin-bottom: 20px;
            background:#fff;
            padding:20px;
            border-radius:8px;
            border:1px solid #e2e8f0;
        }

        .filters .filter-group {
            display: flex;
            flex-direction: column;
        }
        .filters label {
            font-size:14px;
            font-weight:600;
            margin-bottom:5px;
            color:#2d3748;
        }
        .filters select, .filters input {
            padding:8px 12px;
            border:1px solid #e2e8f0;
            border-radius:8px;
            font-size:14px;
            width:250px;
        }
        .filters input::placeholder {
            color:#a0aec0;
        }
        .filters .btn {
            padding:8px 16px;
            background-color:#08C89E;
            color:#fff;
            border:none;
            border-radius:8px;
            cursor:pointer;
            font-size:14px;
        }
        .filters .btn:hover {
            background-color:#06b287;
        }

        .patients-container {
            display:grid;
            grid-template-columns: repeat(auto-fill,minmax(320px,1fr));
            gap:20px;
        }

        .patient-card {
            background:#fff;
            border:1px solid #e2e8f0;
            border-radius:12px;
            box-shadow:0 2px 4px rgba(0,0,0,0.05);
            padding:20px;
            display:flex;
            flex-direction:column;
            justify-content:space-between;
        }

        .patient-header {
            display:flex;
            justify-content:space-between;
            align-items:flex-start;
            margin-bottom:15px;
        }

        .patient-info {
            flex:1;
        }
        .patient-info h3 {
            font-size:18px;
            color:#08C89E;
            margin:0 0 5px;
        }
        .patient-info p {
            margin:2px 0;
            font-size:14px;
            color:#4a5568;
        }

        .patient-status {
            font-size:12px;
            font-weight:600;
            padding:3px 8px;
            border-radius:8px;
            color:#fff;
            text-transform:capitalize;
        }

        .patient-status.ativo { background:#48BB78; }
        .patient-status.bloqueado { background:#E53E3E; }
        .patient-status.removido { background:#718096; }

        .patient-actions {
            display:flex;
            gap:10px;
            margin-top:15px;
            flex-wrap:wrap;
        }

        .patient-actions button {
            background:#edf2f7;
            border:none;
            border-radius:8px;
            padding:8px;
            cursor:pointer;
            font-size:14px;
            display:flex;
            align-items:center;
            gap:5px;
            color:#2d3748;
        }

        .patient-actions button:hover {
            background:#e2e8f0;
        }

        .patient-actions button i {
            font-size:16px;
        }

        .pagination {
            display:flex;
            justify-content:flex-end;
            margin-top:20px;
            gap:5px;
        }

        .pagination button {
            background:#edf2f7;
            border:none;
            border-radius:5px;
            padding:5px 10px;
            cursor:pointer;
        }
        .pagination button.active {
            background:#08C89E;
            color:#fff;
        }
        .pagination button:hover {
            background:#ddd;
        }

        /* Modais */
        .modal {
            display:none;
            position:fixed;
            z-index:9999;
            top:0;left:0;right:0;bottom:0;
            background:rgba(0,0,0,0.5);
            justify-content:center;
            align-items:center;
        }
        .modal-content {
            background:#fff;
            border-radius:10px;
            padding:20px;
            width:90%;
            max-width:600px;
            box-shadow:0 2px 10px rgba(0,0,0,0.2);
            position:relative;
            animation:fadeIn 0.3s ease-in-out;
        }
        .modal-content h2 {
            font-size:20px;
            color:#08C89E;
            margin-bottom:10px;
        }
        .modal-content .close-modal {
            position:absolute;
            right:20px;
            top:20px;
            font-size:24px;
            cursor:pointer;
            color:#aaa;
        }
        .modal-content .close-modal:hover { color:#333; }
        .modal-content p {
            margin:5px 0;
            font-size:14px;
            color:#4a5568;
        }
        .modal-actions {
            margin-top:20px;
            display:flex;
            justify-content:flex-end;
            gap:10px;
        }
        .btn.cancel {
            background:#edf2f7;
            color:#2d3748;
        }
        .btn.cancel:hover {
            background:#e2e8f0;
        }
        .btn.confirm {
            background:#08C89E;
            color:#fff;
        }
        .btn.confirm:hover {
            background:#06b287;
        }

        .form-group-modal {
            margin-bottom:15px;
        }
        .form-group-modal label {
            display:block;
            font-size:14px;
            font-weight:600;
            margin-bottom:5px;
            color:#2d3748;
        }
        .form-group-modal textarea,
        .form-group-modal select {
            width:100%;
            padding:8px 10px;
            border:1px solid #e2e8f0;
            border-radius:8px;
            font-size:14px;
            box-sizing:border-box;
        }

        .history-list {
            list-style:none;
            padding:0;
            margin:0;
        }
        .history-item {
            border-bottom:1px solid #e2e8f0;
            padding:10px 0;
        }
        .history-item:last-child {
            border-bottom:none;
        }
        .history-item p {
            margin:0;
            font-size:14px;
            color:#4a5568;
        }
        .history-item .date {
            font-size:12px;
            color:#718096;
        }

        @keyframes fadeIn {
            from{opacity:0;transform:translateY(-10px);}
            to{opacity:1;transform:translateY(0);}
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-superadmin-pacientes.php'; ?>

    <!-- Main Content -->
    <main class="content">
        <div class="header-content">
            <h1>Gestão de Pacientes</h1>
        </div>

        

        <section class="filters">
            <p style="margin-top:-10px; margin-bottom:20px;">
            Filtre, visualize e gerencie pacientes. Mude de clínica, restaure, bloqueie e confira o histórico completo.
        </p>
        <hr />
            <div class="filter-group">
                <label for="filterName">Nome do Paciente</label>
                <input type="text" id="filterName" placeholder="Ex: João Silva">
            </div>
            <div class="filter-group">
                <label for="filterClinic">Clínica</label>
                <select id="filterClinic">
                    <option value="">Todas</option>
                    <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                    <option value="Clínica Central">Clínica Central</option>
                    <option value="Clínica do Norte">Clínica do Norte</option>
                </select>
            </div>
            <div class="filter-group">
                <label for="filterProfessional">Profissional Responsável</label>
                <select id="filterProfessional">
                    <option value="">Todos</option>
                    <option value="Mariana Santos">Mariana Santos</option>
                    <option value="Pedro Oliveira">Pedro Oliveira</option>
                    <option value="Ana Luiza">Ana Luiza</option>
                </select>
            </div>
            <button class="btn" id="applyFilters">Aplicar Filtros</button>
        </section>

        <div class="patients-container" id="patientsContainer">
            <!-- Cards via JS -->
        </div>

        <div class="pagination" id="pagination"></div>
    </main>

    <!-- Modais -->
    <!-- Modal Histórico -->
    <div class="modal" id="historyModal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <h2>Histórico do Paciente</h2>
            <ul class="history-list" id="historyList"></ul>
            <div class="modal-actions">
                <button class="btn cancel">Fechar</button>
            </div>
        </div>
    </div>

    <!-- Modal Mover Paciente -->
    <div class="modal" id="moveModal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <h2>Mudar Paciente de Clínica</h2>
            <div class="form-group-modal">
                <label for="newClinic">Nova Clínica</label>
                <select id="newClinic">
                    <option value="">Selecione</option>
                    <option value="Clínica Sertãozinho">Clínica Sertãozinho</option>
                    <option value="Clínica Central">Clínica Central</option>
                    <option value="Clínica do Norte">Clínica do Norte</option>
                </select>
            </div>
            <div class="form-group-modal">
                <label for="moveReason">Motivo da Mudança</label>
                <textarea id="moveReason" rows="3" placeholder="Descreva o motivo"></textarea>
            </div>
            <div class="modal-actions">
                <button class="btn cancel">Cancelar</button>
                <button class="btn confirm" id="confirmMoveBtn">Confirmar</button>
            </div>
        </div>
    </div>

    <!-- Modal Bloquear Paciente -->
    <div class="modal" id="blockModal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <h2>Bloquear Paciente</h2>
            <p>Ao bloquear, o paciente não poderá mais ser acessado, exceto pelo Admin do Sistema.</p>
            <p><b>ID:</b> <span id="blockPatientId"></span>, <b>Nome:</b> <span id="blockPatientName"></span></p>
            <div class="form-group-modal">
                <label for="blockReason">Motivo do Bloqueio</label>
                <textarea id="blockReason" rows="3" placeholder="Descreva o motivo"></textarea>
            </div>
            <div class="modal-actions">
                <button class="btn cancel">Cancelar</button>
                <button class="btn confirm" id="confirmBlockBtn">Confirmar</button>
            </div>
        </div>
    </div>

    <script>
        let patients = [
            {id:'#ABC001',name:'João Silva', clinic:'Clínica Sertãozinho', guardian:'Maria da Silva', professional:'Mariana Santos', dob:'2015-05-20', status:'ativo', history:[
                {date:'2023-01-10',desc:'Paciente cadastrado'},
                {date:'2023-03-15',desc:'Avaliação Portage realizada'},
                {date:'2023-07-05',desc:'Avaliação CARS adicionada'}
            ]},
            {id:'#ABC002',name:'Ana Clara', clinic:'Clínica Central', guardian:'Pedro Oliveira', professional:'Ana Luiza', dob:'2016-03-10', status:'ativo', history:[
                {date:'2023-02-20',desc:'Paciente cadastrado'},
                {date:'2023-05-10',desc:'M-CHAT realizado'},
            ]},
            {id:'#ABC003',name:'Bruno Costa', clinic:'Clínica do Norte', guardian:'Carla Costa', professional:'Mariana Santos', dob:'2014-12-01', status:'bloqueado', history:[
                {date:'2023-01-01',desc:'Paciente cadastrado'},
                {date:'2023-04-22',desc:'Paciente bloqueado pelo Admin'},
            ]},
            {id:'#ABC004',name:'Carla Souza', clinic:'Clínica Sertãozinho', guardian:'João Souza', professional:'Pedro Oliveira', dob:'2017-07-22', status:'removido', history:[
                {date:'2023-02-02',desc:'Paciente cadastrado'},
                {date:'2023-08-15',desc:'Paciente removido da clínica.'}
            ]},
            {id:'#ABC005',name:'Daniel Lima', clinic:'Clínica Central', guardian:'Fernanda Lima', professional:'Mariana Santos', dob:'2018-01-15', status:'ativo', history:[
                {date:'2023-03-01',desc:'Paciente cadastrado'}
            ]}
        ];

        const perPage=5;
        let currentPage=1;

        const filterName=document.getElementById('filterName');
        const filterClinic=document.getElementById('filterClinic');
        const filterProfessional=document.getElementById('filterProfessional');
        const applyFiltersBtn=document.getElementById('applyFilters');
        const patientsContainer=document.getElementById('patientsContainer');
        const pagination=document.getElementById('pagination');

        function renderCards() {
            const nameVal=filterName.value.toLowerCase();
            const clinicVal=filterClinic.value;
            const profVal=filterProfessional.value;

            let filtered=patients.filter(p=>{
                const matchName=!nameVal||p.name.toLowerCase().includes(nameVal);
                const matchClinic=!clinicVal||p.clinic===clinicVal;
                const matchProf=!profVal||p.professional===profVal;
                return matchName&&matchClinic&&matchProf;
            });

            const total=filtered.length;
            const totalPages=Math.ceil(total/perPage);
            if(currentPage>totalPages && totalPages>0) currentPage=totalPages;
            const start=(currentPage-1)*perPage;
            const end=start+perPage;
            const pageData=filtered.slice(start,end);

            patientsContainer.innerHTML='';
            pageData.forEach(p=>{
                const age=new Date().getFullYear()-new Date(p.dob).getFullYear();
                let statusClass=p.status;
                const card=document.createElement('div');
                card.classList.add('patient-card');
                card.innerHTML=`
                    <div class="patient-header">
                        <div class="patient-info">
                            <h3>${p.name}</h3>
                            <p><b>ID:</b> ${p.id}</p>
                            <p><b>Clínica:</b> ${p.clinic}</p>
                            <p><b>Responsável:</b> ${p.guardian}</p>
                            <p><b>Profissional:</b> ${p.professional}</p>
                            <p><b>Idade:</b> ${age} anos</p>
                        </div>
                        <span class="patient-status ${statusClass}">${p.status}</span>
                    </div>
                    <div class="patient-actions">
                        <button class="viewHistoryBtn" data-id="${p.id}" title="Histórico"><i class="fas fa-history"></i></button>
                        <button class="moveClinicBtn" data-id="${p.id}" title="Mudar Clínica"><i class="fas fa-exchange-alt"></i></button>
                        <button class="blockPatientBtn" data-id="${p.id}" title="Bloquear Paciente"><i class="fas fa-ban"></i></button>
                        ${p.status==='removido'?'<button class="restorePatientBtn" data-id="'+p.id+'" title="Restaurar Paciente"><i class="fas fa-undo-alt"></i></button>':''}
                        <button class="viewProfileBtn" data-id="${p.id}" title="Ver Perfil Completo"><i class="fas fa-user"></i></button>
                    </div>
                `;
                patientsContainer.appendChild(card);
            });

            renderPagination(totalPages);
        }

        function renderPagination(totalPages){
            pagination.innerHTML='';
            for(let i=1;i<=totalPages;i++){
                const btn=document.createElement('button');
                btn.textContent=i;
                if(i===currentPage) btn.classList.add('active');
                btn.onclick=()=>{
                    currentPage=i;
                    renderCards();
                };
                pagination.appendChild(btn);
            }
        }

        applyFiltersBtn.onclick=()=>{
            currentPage=1;
            renderCards();
        };

        renderCards();

        // Modais
        const historyModal=document.getElementById('historyModal');
        const moveModal=document.getElementById('moveModal');
        const blockModal=document.getElementById('blockModal');
        const historyList=document.getElementById('historyList');
        const newClinic=document.getElementById('newClinic');
        const moveReason=document.getElementById('moveReason');
        const blockReason=document.getElementById('blockReason');
        const blockPatientId=document.getElementById('blockPatientId');
        const blockPatientName=document.getElementById('blockPatientName');

        document.body.addEventListener('click',(e)=>{
            if(e.target.classList.contains('viewHistoryBtn')||e.target.closest('.viewHistoryBtn')){
                const id=(e.target.dataset.id)||(e.target.closest('button').dataset.id);
                openHistoryModal(id);
            }

            if(e.target.classList.contains('moveClinicBtn')||e.target.closest('.moveClinicBtn')){
                const id=(e.target.dataset.id)||(e.target.closest('button').dataset.id);
                moveModal.dataset.id=id;
                moveModal.style.display='flex';
            }

            if(e.target.classList.contains('blockPatientBtn')||e.target.closest('.blockPatientBtn')){
                const id=(e.target.dataset.id)||(e.target.closest('button').dataset.id);
                const p=patients.find(x=>x.id===id);
                blockPatientId.textContent=p.id;
                blockPatientName.textContent=p.name;
                blockModal.dataset.id=id;
                blockModal.style.display='flex';
            }

            if(e.target.classList.contains('restorePatientBtn')||e.target.closest('.restorePatientBtn')){
                const id=(e.target.dataset.id)||(e.target.closest('button').dataset.id);
                restorePatient(id);
            }

            if(e.target.classList.contains('viewProfileBtn')||e.target.closest('.viewProfileBtn')){
                const id=(e.target.dataset.id)||(e.target.closest('button').dataset.id);
                alert('Redirecionando para o perfil completo do paciente '+id);
            }
        });

        function openHistoryModal(id){
            const p=patients.find(x=>x.id===id);
            historyList.innerHTML='';
            p.history.forEach(h=>{
                const li=document.createElement('li');
                li.classList.add('history-item');
                li.innerHTML=`<p><strong>${h.desc}</strong></p><p class="date">${h.date}</p>`;
                historyList.appendChild(li);
            });
            historyModal.style.display='flex';
        }

        function restorePatient(id){
            if(confirm('Deseja restaurar este paciente?')){
                const p=patients.find(x=>x.id===id);
                p.status='ativo';
                alert('Paciente restaurado com sucesso!');
                renderCards();
            }
        }

        document.getElementById('confirmMoveBtn').onclick=()=>{
            const id=moveModal.dataset.id;
            const p=patients.find(x=>x.id===id);
            if(!newClinic.value||!moveReason.value.trim()){
                alert('Selecione a clínica e informe o motivo.');
                return;
            }
            p.clinic=newClinic.value;
            alert('Paciente movido com sucesso!');
            moveModal.style.display='none';
            renderCards();
        };

        document.getElementById('confirmBlockBtn').onclick=()=>{
            const id=blockModal.dataset.id;
            const p=patients.find(x=>x.id===id);
            if(!blockReason.value.trim()){
                alert('Informe o motivo do bloqueio.');
                return;
            }
            p.status='bloqueado';
            alert('Paciente bloqueado com sucesso!');
            blockModal.style.display='none';
            renderCards();
        };

        document.querySelectorAll('.close-modal').forEach(btn=>{
            btn.onclick=()=>{
                btn.closest('.modal').style.display='none';
            };
        });
        document.querySelectorAll('.btn.cancel').forEach(btn=>{
            btn.onclick=()=>{
                btn.closest('.modal').style.display='none';
            };
        });
        window.onclick=(e)=>{
            [historyModal,moveModal,blockModal].forEach(m=>{
                if(e.target===m) m.style.display='none';
            });
        };
    </script>
</body>
</html>
