<?php
// processa_nova_senha.php

session_start(); // Inicia a sessão

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Filtrar e validar dados de entrada
    $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
    $codigo = trim($_POST['codigo']);
    $nova_senha = $_POST['nova_senha'];
    $confirmar_senha = $_POST['confirmar_senha'];
    $captcha = trim($_POST['captcha']);
    $form_start_time = isset($_POST['form_start_time']) ? intval($_POST['form_start_time']) : 0;
    $current_time = time();

    // Verificar se o formulário foi preenchido muito rapidamente (menos de 5 segundos)
    if (($current_time - $form_start_time) < 3) {
        die('Formulário preenchido muito rapidamente. Por favor, tente novamente.');
    }

    

    // Verificar honeypot
    if (!empty($_POST['honeypot'])) {
        die('Bot detectado.');
    }

    if (!$email || empty($codigo) || empty($nova_senha) || empty($confirmar_senha)) {
        die('Todos os campos são obrigatórios.');
    }

    // Verificar se as senhas coincidem
    if ($nova_senha !== $confirmar_senha) {
        die('As senhas não coincidem.');
    }

    // Validar a força da senha (exemplo simples)
    if (strlen($nova_senha) < 6) {
        die('A senha deve ter pelo menos 6 caracteres.');
    }

    // Verificar se os dados correspondem à sessão
    if (isset($_SESSION['recupera_senha'])) {
        $recupera = $_SESSION['recupera_senha'];
        if ($recupera['email'] === $email && $recupera['codigo'] === $codigo && $recupera['expira'] >= $current_time) {
            // Simular atualização da senha
            // Em um ambiente real, você atualizaria a senha no banco de dados aqui

            // Limpar os dados da sessão
            unset($_SESSION['recupera_senha']);

            // Exibir mensagem de sucesso
            echo "<!DOCTYPE html>
            <html lang='pt-BR'>
            <head>
                <meta charset='UTF-8'>
                <title>Senha Redefinida</title>
                <meta http-equiv='refresh' content='5;url=login.php'>
                <style>
                    body { font-family: 'Nunito', sans-serif; background-color: #f0f2f5; display: flex; justify-content: center; align-items: center; height: 100vh; }
                    .message { background: #fff; padding: 30px; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); text-align: center; }
                </style>
            </head>
            <body>
                <div class='message'>
                    <h2>Senha Redefinida com Sucesso!</h2>
                    <p>Sua senha foi atualizada. Você será redirecionado para a página de login.</p>
                </div>
            </body>
            </html>";
            exit();
        } else {
            die('E-mail ou código inválido.');
        }
    } else {
        die('Sessão inválida ou expirada. Por favor, inicie o processo novamente.');
    }
} else {
    header('Location: nova_senha.php');
    exit();
}
?>
