<?php
// Lista de atributos para gerar diferentes imagens de homens e mulheres em pixel-art
$genders = ["male", "female"];
$skinColors = ["light", "medium", "dark"];
$hairStyles = ["short", "long", "curly", "bald"];
$accessories = ["none", "glasses", "hat", "earrings"]; // Adicionando acessórios

// Função para criar um seed baseado nos atributos selecionados
function criarSeed($gender, $skin, $hair, $accessory) {
    return "{$gender}-{$skin}-{$hair}-{$accessory}";
}

// Estilo fixo para 'pixel-art'
$style = "pixel-art";

// Inicializa arrays para armazenar as seleções do usuário
$selectedGenders = $genders;
$selectedSkinColors = $skinColors;
$selectedHairStyles = $hairStyles;
$selectedAccessories = $accessories;

// Verifica se o formulário foi submetido e atualiza as seleções
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['genders'])) {
        $selectedGenders = $_POST['genders'];
    }
    if (isset($_POST['skinColors'])) {
        $selectedSkinColors = $_POST['skinColors'];
    }
    if (isset($_POST['hairStyles'])) {
        $selectedHairStyles = $_POST['hairStyles'];
    }
    if (isset($_POST['accessories'])) {
        $selectedAccessories = $_POST['accessories'];
    }
}

// Gerar todas as combinações possíveis de seeds com base nas seleções
$seeds = [];
foreach ($selectedGenders as $gender) {
    foreach ($selectedSkinColors as $skin) {
        foreach ($selectedHairStyles as $hair) {
            foreach ($selectedAccessories as $accessory) {
                $seeds[] = criarSeed($gender, $skin, $hair, $accessory);
            }
        }
    }
}

// Função para obter a URL da imagem gerada pela API
function obterImagem($style, $seed) {
    return "https://api.dicebear.com/6.x/" . urlencode($style) . "/svg?seed=" . urlencode($seed);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galeria de Avatares DiceBear - Pixel Art</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            margin: 0;
            padding: 20px;
            text-align: center;
        }
        h1 {
            margin-bottom: 20px;
        }
        form {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
            display: inline-block;
            text-align: left;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            font-weight: bold;
            display: block;
            margin-bottom: 5px;
        }
        select, .checkbox-group {
            width: 100%;
            padding: 8px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }
        .checkbox-group label {
            display: inline-block;
            margin-right: 10px;
            font-weight: normal;
        }
        .submit-btn {
            background-color: #28a745;
            color: #fff;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .submit-btn:hover {
            background-color: #218838;
        }
        .gallery {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 15px;
            padding: 20px;
        }
        .gallery div {
            text-align: center;
            background-color: #fff;
            padding: 10px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .gallery img {
            width: 100%;
            height: auto;
            border-radius: 8px;
        }
        .gallery h3 {
            margin-top: 10px;
            font-size: 14px;
            color: #333;
        }
    </style>
</head>
<body>

<h1>Galeria de Avatares DiceBear - Pixel Art</h1>

<!-- Formulário de Estilização -->
<form method="POST" action="">
    <div class="form-group">
        <label for="genders">Gênero:</label>
        <div class="checkbox-group" id="genders">
            <?php foreach ($genders as $gender): ?>
                <label>
                    <input type="checkbox" name="genders[]" value="<?= htmlspecialchars($gender) ?>" <?= in_array($gender, $selectedGenders) ? 'checked' : '' ?>> <?= ucfirst($gender) ?>
                </label>
            <?php endforeach; ?>
        </div>
    </div>
    
    <div class="form-group">
        <label for="skinColors">Cor da Pele:</label>
        <div class="checkbox-group" id="skinColors">
            <?php foreach ($skinColors as $skin): ?>
                <label>
                    <input type="checkbox" name="skinColors[]" value="<?= htmlspecialchars($skin) ?>" <?= in_array($skin, $selectedSkinColors) ? 'checked' : '' ?>> <?= ucfirst($skin) ?>
                </label>
            <?php endforeach; ?>
        </div>
    </div>
    
    <div class="form-group">
        <label for="hairStyles">Estilo de Cabelo:</label>
        <div class="checkbox-group" id="hairStyles">
            <?php foreach ($hairStyles as $hair): ?>
                <label>
                    <input type="checkbox" name="hairStyles[]" value="<?= htmlspecialchars($hair) ?>" <?= in_array($hair, $selectedHairStyles) ? 'checked' : '' ?>> <?= ucfirst($hair) ?>
                </label>
            <?php endforeach; ?>
        </div>
    </div>
    
    <div class="form-group">
        <label for="accessories">Acessórios:</label>
        <div class="checkbox-group" id="accessories">
            <?php foreach ($accessories as $accessory): ?>
                <label>
                    <input type="checkbox" name="accessories[]" value="<?= htmlspecialchars($accessory) ?>" <?= in_array($accessory, $selectedAccessories) ? 'checked' : '' ?>> <?= ucfirst($accessory) ?>
                </label>
            <?php endforeach; ?>
        </div>
    </div>
    
    <button type="submit" class="submit-btn">Gerar Avatares</button>
</form>

<!-- Galeria de Avatares -->
<div class="gallery">
    <?php foreach ($seeds as $seed): ?>
        <?php 
            $imgUrl = obterImagem($style, $seed);
            // Formatar a descrição substituindo '-' por espaços e capitalizando a primeira letra
            $description = ucfirst(str_replace('-', ' ', $seed));
        ?>
        <div>
            <img src="<?= htmlspecialchars($imgUrl) ?>" alt="<?= htmlspecialchars($description) ?>">
            <h3><?= htmlspecialchars($description) ?></h3>
        </div>
    <?php endforeach; ?>
</div>

</body>
</html>
