<?php
// nova_senha.php
session_start();

// Verificar se o e-mail e o código estão presentes na URL
if (!isset($_GET['email']) || !isset($_GET['codigo'])) {
    header('Location: recupera_senha.php');
    exit();
}

$email = filter_var($_GET['email'], FILTER_VALIDATE_EMAIL);
$codigo = trim($_GET['codigo']);

// Verificar se os dados correspondem à sessão
if (isset($_SESSION['recupera_senha'])) {
    $recupera = $_SESSION['recupera_senha'];
    if ($recupera['email'] !== $email || $recupera['codigo'] !== $codigo || $recupera['expira'] < time()) {
        die('Dados inválidos ou código expirado.');
    }
} else {
    die('Sessão inválida ou expirada. Por favor, inicie o processo novamente.');
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Nova Senha - Recuperação de Senha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Fonte personalizada -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700&display=swap" rel="stylesheet">
    <style>
        /* Estilos consistentes com as outras páginas */
        body {
            font-family: 'Nunito', sans-serif;
            background-color: #f0f2f5;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .container-nova-senha {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            max-width: 900px;
            width: 100%;
            display: flex;
            flex-direction: row;
            overflow: hidden;
        }

        .left-panel {
            background: linear-gradient(to bottom right, #08CA9D, #234EA1);
            color: #fff;
            padding: 50px;
            width: 50%;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .left-panel h1 {
            font-size: 2.5rem;
            margin-bottom: 20px;
        }

        .left-panel p {
            font-size: 1.2rem;
            line-height: 1.5;
        }

        .right-panel {
            padding: 50px;
            width: 50%;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .logo img {
            width: 80px;
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-group label {
            position: absolute;
            top: -10px;
            left: 15px;
            background: #fff;
            padding: 0 5px;
            font-size: 0.9rem;
            color: #888;
        }

        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid #ddd;
            border-radius: 10px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-group input:focus {
            border-color: #08CA9D;
            outline: none;
        }

        .btn-primary {
            width: 100%;
            padding: 15px;
            background: #08CA9D;
            border: none;
            color: white;
            font-size: 1rem;
            font-weight: bold;
            border-radius: 10px;
            cursor: pointer;
            transition: background 0.3s;
            margin-top: 10px;
        }

        .btn-primary:hover {
            background: #06b487;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
        }

        .footer p {
            font-size: 0.9rem;
            color: #555;
            margin-bottom: 15px;
        }

        .btn-secondary {
            padding: 12px 25px;
            border: 2px solid #08CA9D;
            color: #08CA9D;
            font-size: 0.9rem;
            border-radius: 10px;
            text-decoration: none;
            cursor: pointer;
            transition: background 0.3s, color 0.3s;
            text-align: center;
            display: inline-block;
        }

        .btn-secondary:hover {
            background: #08CA9D;
            color: white;
        }

        /* Responsividade */
        @media (max-width: 768px) {
            .container-nova-senha {
                flex-direction: column;
            }

            .left-panel, .right-panel {
                width: 100%;
            }

            .left-panel {
                padding: 30px;
                text-align: center;
            }

            .left-panel h1 {
                font-size: 2rem;
            }

            .left-panel p {
                font-size: 1rem;
            }

            .right-panel {
                padding: 30px;
            }

            .logo img {
                width: 100px;
            }
        }
    </style>
</head>
<body>
    <div class="container-nova-senha">
        <!-- Lado Esquerdo -->
        <div class="left-panel">
            <h1>Nova Senha</h1>
            <p>Escolha uma nova senha para sua conta. Certifique-se de que seja segura e fácil de lembrar.</p>
        </div>

        <!-- Lado Direito -->
        <div class="right-panel">
            <div class="logo">
                <img src="includes/logo.webp" alt="Sistema Coralina Matos">
            </div>

            <!-- Formulário de Nova Senha -->
            <form action="processa_nova_senha.php" method="POST">
                <!-- Campos ocultos para identificar o usuário e o código -->
                <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>">
                <input type="hidden" name="codigo" value="<?php echo htmlspecialchars($codigo); ?>">

                <div class="form-group">
                    <label for="nova_senha">Nova Senha</label>
                    <input type="password" id="nova_senha" name="nova_senha" placeholder="Digite sua nova senha" required value="NovaSenha123">
                </div>
                <div class="form-group">
                    <label for="confirmar_senha">Confirmar Senha</label>
                    <input type="password" id="confirmar_senha" name="confirmar_senha" placeholder="Confirme sua nova senha" required value="NovaSenha123">
                </div>

                <!-- Campo honeypot -->
                <div style="display: none;">
                    <label for="honeypot">Não preencha este campo</label>
                    <input type="text" id="honeypot" name="honeypot" value="">
                </div>


                <!-- Campo de Tempo -->
                <input type="hidden" name="form_start_time" value="<?php echo time(); ?>">

                <!-- Campo oculto para verificação -->
                <input type="hidden" name="captcha_verified" id="captcha_verified" value="true">

                <button type="submit" class="btn-primary">Redefinir Senha</button>
            </form>

            
        </div>
    </div>
    
    
</body>
</html>
