<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Assistente - Perfil da Criança</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/global.css">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <style>
        .profile-card {
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
        }

        .profile-left {
            width: 100%;
            max-width: 300px;
            padding-right: 15px;
            border-right: 1px solid #e2e8f0;
        }

        .profile-right {
            flex: 1;
            padding-left: 15px;
        }

        .profile-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            position: relative;
        }

        .profile-header img {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            border: 2px solid #08C89E;
            margin-right: 15px;
        }

        .profile-header h2 {
            font-size: 22px;
            color: #08C89E;
            line-height: 100%;
        }

        .profile-info p {
            font-size: 15px;
            color: #4a5568;
            margin-bottom: 6px;
            margin: 0px;
        }

        .tab-container {
            margin-top: 20px;
        }

        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }

        .tab {
            background-color: #f7fafc;
            padding: 10px 15px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            color: #2d3748;
        }

        .tab.active {
            background-color: #08C89E;
            color: #fff;
            font-weight: 600;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Ferramentas e Anotações semelhantes aos outros perfis */

        .annotations {
            margin-top: 40px;
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 20px;
        }
        .annotations h2 {
            font-size: 22px;
            color: #2d3748;
            margin-bottom: 15px;
            text-align: left;
        }

        .annotation-area {
            width: 100%;
            margin-top: 10px;
        }
        .annotation-area textarea {
            width: 100%;
            height: 80px;
            padding: 10px;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            resize: vertical;
            font-size: 14px;
            color: #2d3748;
            box-sizing: border-box;
        }
        .annotation-area button {
            background-color: #08C89E;
            color: #fff;
            padding: 8px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 13px;
            margin-top: 8px;
            transition: background 0.3s;
        }
        .annotation-area button:hover {
            background-color: #06b287;
        }
        .annotation {
            background-color: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            padding: 10px;
            margin-bottom: 10px;
            margin-top: 10px;
        }

    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar-painel-assistente.php'; ?>

    <main class="content">
        <div class="header-content">
            <h1 style="color: #08C89E;">Perfil da Criança</h1>
        </div>
        
        <section class="profile-card">
            <div class="profile-left">
                <div class="profile-header">
                    <img src="https://via.placeholder.com/90" alt="Foto da Criança">
                    <h2>Nome da Criança</h2>
                </div>
                <div class="profile-info">
                    <p><b>ID:</b> #ABC12345</p>
                    <p><b>Data de Nasc.:</b> 01/01/2016</p>
                    <p><b>Idade:</b> 7 anos</p>
                    <p><b>Responsável:</b> Maria da Silva</p>
                    <p><b>Clínica:</b> Independente</p>
                    <!-- Assistente não pode editar dados sensíveis -->
                    <p><b>Anamnese:</b> Pendente</p>
                </div>
            </div>

            <div class="profile-right">
                <div class="tab-container">
                    <div class="tabs">
                        <div class="tab active" data-tab="registros">Registros Clínicos</div>
                        <div class="tab" data-tab="ferramentas">Ferramentas</div>
                        <div class="tab" data-tab="anotacoes">Anotações</div>
                    </div>

                    <!-- Conteúdos das abas -->
                    <div id="registros" class="tab-content active">
                        <!-- Lista de avaliações e registros clínicos -->
                        <ul class="evaluation-list">
                            <li>Portage - 15/03/2023 - <a href="#">Ver Detalhes</a></li>
                            <li>CARS - 20/04/2023 - <a href="#">Ver Detalhes</a></li>
                            <!-- Assistente só visualiza, não pode editar -->
                        </ul>
                    </div>
                    <div id="ferramentas" class="tab-content">
                        <p>Ferramentas de avaliação disponíveis:</p>
                        <div class="tools-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px,1fr)); gap: 20px; margin-top:10px;">
                            <div style="border:1px solid #e2e8f0; border-radius:8px; padding:15px;">
                                <h3 style="font-size:16px; color:#2d3748; margin-bottom:5px;">Portage</h3>
                                <p style="font-size:14px; color:#4a5568;">Avaliação de desenvolvimento infantil.</p>
                                <button style="background-color:#08C89E;color:#fff;padding:8px 12px;border:none;border-radius:6px;font-size:14px;cursor:pointer;">Acessar</button>
                            </div>
                            <div style="border:1px solid #e2e8f0; border-radius:8px; padding:15px;">
                                <h3 style="font-size:16px; color:#2d3748; margin-bottom:5px;">M-CHAT</h3>
                                <p style="font-size:14px; color:#4a5568;">Checklist de autismo em crianças pequenas.</p>
                                <button style="background-color:#08C89E;color:#fff;padding:8px 12px;border:none;border-radius:6px;font-size:14px;cursor:pointer;">Acessar</button>
                            </div>
                            <!-- Outras ferramentas -->
                        </div>
                    </div>
                    <div id="anotacoes" class="tab-content">
                        <div class="annotation-area">
                            <textarea placeholder="Escreva uma nova anotação..."></textarea>
                            <button><i class="fas fa-paper-plane"></i> Salvar Anotação</button>
                        </div>

                        <div class="annotation">
                            <div style="display:flex;justify-content:space-between;align-items:center;">
                                <div style="font-weight:bold;font-size:14px;color:#2d3748;">Coralina Matos</div>
                                <div style="font-size:12px;color:#718096;">10/05/2023</div>
                            </div>
                            <div style="margin-top:5px;font-size:14px;color:#4a5568;">
                                Esta é uma anotação de exemplo.
                            </div>
                            <!-- Assistente pode responder, mas não necessariamente editar/remover dependendo das permissões -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <script>
        const tabs = document.querySelectorAll('.tab');
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                tabs.forEach(t => t.classList.remove('active'));
                tabContents.forEach(c => c.classList.remove('active'));

                tab.classList.add('active');
                document.getElementById(tab.getAttribute('data-tab')).classList.add('active');
            });
        });
    </script>
</body>
</html>
